# List of Modules

<!-- BBOT MODULES -->
| Module                | Type     | Needs API Key   | Description                                                                                                                                           | Flags                                                            | Consumed Events                                                                                                                         | Produced Events                                             | Author                    | Created Date   |
|-----------------------|----------|-----------------|-------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------|---------------------------|----------------|
| ajaxpro               | scan     | No              | Check for potentially vulnerable Ajaxpro instances                                                                                                    | active, safe, web-thorough                                       | HTTP_RESPONSE, URL                                                                                                                      | FINDING, VULNERABILITY                                      | @liquidsec                | 2024-01-18     |
| aspnet_bin_exposure   | scan     | No              | Check for ASP.NET Security Feature Bypasses (CVE-2023-36899 and CVE-2023-36560)                                                                       | active, safe, web-thorough                                       | URL                                                                                                                                     | VULNERABILITY                                               | @liquidsec                | 2025-01-28     |
| baddns                | scan     | No              | Check hosts for domain/subdomain takeovers                                                                                                            | active, baddns, cloud-enum, safe, subdomain-hijack, web-basic    | DNS_NAME, DNS_NAME_UNRESOLVED                                                                                                           | FINDING, VULNERABILITY                                      | @liquidsec                | 2024-01-18     |
| baddns_direct         | scan     | No              | Check for unusual subdomain / service takeover edge cases that require direct detection                                                               | active, baddns, cloud-enum, safe, subdomain-enum                 | STORAGE_BUCKET, URL                                                                                                                     | FINDING, VULNERABILITY                                      | @liquidsec                | 2024-01-29     |
| baddns_zone           | scan     | No              | Check hosts for DNS zone transfers and NSEC walks                                                                                                     | active, baddns, cloud-enum, safe, subdomain-enum                 | DNS_NAME                                                                                                                                | FINDING, VULNERABILITY                                      | @liquidsec                | 2024-01-29     |
| badsecrets            | scan     | No              | Library for detecting known or weak secrets across many web frameworks                                                                                | active, safe, web-basic                                          | HTTP_RESPONSE                                                                                                                           | FINDING, TECHNOLOGY, VULNERABILITY                          | @liquidsec                | 2022-11-19     |
| bucket_amazon         | scan     | No              | Check for S3 buckets related to target                                                                                                                | active, cloud-enum, safe, web-basic                              | DNS_NAME, STORAGE_BUCKET                                                                                                                | FINDING, STORAGE_BUCKET                                     | @TheTechromancer          | 2022-11-04     |
| bucket_digitalocean   | scan     | No              | Check for DigitalOcean spaces related to target                                                                                                       | active, cloud-enum, safe, slow, web-thorough                     | DNS_NAME, STORAGE_BUCKET                                                                                                                | FINDING, STORAGE_BUCKET                                     | @TheTechromancer          | 2022-11-08     |
| bucket_firebase       | scan     | No              | Check for open Firebase databases related to target                                                                                                   | active, cloud-enum, safe, web-basic                              | DNS_NAME, STORAGE_BUCKET                                                                                                                | FINDING, STORAGE_BUCKET                                     | @TheTechromancer          | 2023-03-20     |
| bucket_google         | scan     | No              | Check for Google object storage related to target                                                                                                     | active, cloud-enum, safe, web-basic                              | DNS_NAME, STORAGE_BUCKET                                                                                                                | FINDING, STORAGE_BUCKET                                     | @TheTechromancer          | 2022-11-04     |
| bucket_microsoft      | scan     | No              | Check for Azure storage blobs related to target                                                                                                       | active, cloud-enum, safe, web-basic                              | DNS_NAME, STORAGE_BUCKET                                                                                                                | FINDING, STORAGE_BUCKET                                     | @TheTechromancer          | 2022-11-04     |
| bypass403             | scan     | No              | Check 403 pages for common bypasses                                                                                                                   | active, aggressive, web-thorough                                 | URL                                                                                                                                     | FINDING                                                     | @liquidsec                | 2022-07-05     |
| dnsbrute              | scan     | No              | Brute-force subdomains with massdns + static wordlist                                                                                                 | active, aggressive, subdomain-enum                               | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2024-04-24     |
| dnsbrute_mutations    | scan     | No              | Brute-force subdomains with massdns + target-specific mutations                                                                                       | active, aggressive, slow, subdomain-enum                         | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2024-04-25     |
| dnscommonsrv          | scan     | No              | Check for common SRV records                                                                                                                          | active, safe, subdomain-enum                                     | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-05-15     |
| dotnetnuke            | scan     | No              | Scan for critical DotNetNuke (DNN) vulnerabilities                                                                                                    | active, aggressive, web-thorough                                 | HTTP_RESPONSE                                                                                                                           | TECHNOLOGY, VULNERABILITY                                   | @liquidsec                | 2023-11-21     |
| ffuf                  | scan     | No              | A fast web fuzzer written in Go                                                                                                                       | active, aggressive, deadly                                       | URL                                                                                                                                     | URL_UNVERIFIED                                              | @liquidsec                | 2022-04-10     |
| ffuf_shortnames       | scan     | No              | Use ffuf in combination IIS shortnames                                                                                                                | active, aggressive, iis-shortnames, web-thorough                 | URL_HINT                                                                                                                                | URL_UNVERIFIED                                              | @liquidsec                | 2022-07-05     |
| filedownload          | scan     | No              | Download common filetypes such as PDF, DOCX, PPTX, etc.                                                                                               | active, download, safe, web-basic                                | HTTP_RESPONSE, URL_UNVERIFIED                                                                                                           | FILESYSTEM                                                  | @TheTechromancer          | 2023-10-11     |
| fingerprintx          | scan     | No              | Fingerprint exposed services like RDP, SSH, MySQL, etc.                                                                                               | active, safe, service-enum, slow                                 | OPEN_TCP_PORT                                                                                                                           | PROTOCOL                                                    | @TheTechromancer          | 2023-01-30     |
| generic_ssrf          | scan     | No              | Check for generic SSRFs                                                                                                                               | active, aggressive, web-thorough                                 | URL                                                                                                                                     | VULNERABILITY                                               | @liquidsec                | 2022-07-30     |
| git                   | scan     | No              | Check for exposed .git repositories                                                                                                                   | active, code-enum, safe, web-basic                               | URL                                                                                                                                     | CODE_REPOSITORY, FINDING                                    | @TheTechromancer          | 2023-05-30     |
| gitlab_com            | scan     | No              | Enumerate GitLab SaaS (gitlab.com/org) for projects and groups                                                                                        | active, code-enum, safe                                          | SOCIAL                                                                                                                                  | CODE_REPOSITORY                                             | @TheTechromancer          | 2024-03-11     |
| gitlab_onprem         | scan     | No              | Detect self-hosted GitLab instances and query them for repositories                                                                                   | active, code-enum, safe                                          | HTTP_RESPONSE, SOCIAL, TECHNOLOGY                                                                                                       | CODE_REPOSITORY, FINDING, SOCIAL, TECHNOLOGY                | @TheTechromancer          | 2024-03-11     |
| gowitness             | scan     | No              | Take screenshots of webpages                                                                                                                          | active, safe, web-screenshots                                    | SOCIAL, URL                                                                                                                             | TECHNOLOGY, URL, URL_UNVERIFIED, WEBSCREENSHOT              | @TheTechromancer          | 2022-07-08     |
| graphql_introspection | scan     | No              | Perform GraphQL introspection on a target                                                                                                             | active, safe, web-basic                                          | URL                                                                                                                                     | FINDING                                                     | @mukesh-dream11           | 2025-07-01     |
| host_header           | scan     | No              | Try common HTTP Host header spoofing techniques                                                                                                       | active, aggressive, web-thorough                                 | HTTP_RESPONSE                                                                                                                           | FINDING                                                     | @liquidsec                | 2022-07-27     |
| httpx                 | scan     | No              | Visit webpages. Many other modules rely on httpx                                                                                                      | active, cloud-enum, safe, social-enum, subdomain-enum, web-basic | OPEN_TCP_PORT, URL, URL_UNVERIFIED                                                                                                      | HTTP_RESPONSE, URL                                          | @TheTechromancer          | 2022-07-08     |
| hunt                  | scan     | No              | Watch for commonly-exploitable HTTP parameters                                                                                                        | active, safe, web-thorough                                       | WEB_PARAMETER                                                                                                                           | FINDING                                                     | @liquidsec                | 2022-07-20     |
| iis_shortnames        | scan     | No              | Check for IIS shortname vulnerability                                                                                                                 | active, iis-shortnames, safe, web-basic                          | URL                                                                                                                                     | URL_HINT                                                    | @liquidsec                | 2022-04-15     |
| legba                 | scan     | No              | Credential bruteforcing supporting various services.                                                                                                  | active, aggressive, deadly                                       | PROTOCOL                                                                                                                                | FINDING                                                     | @christianfl, @fuzikowski | 2025-07-18     |
| lightfuzz             | scan     | No              | Find Web Parameters and Lightly Fuzz them using a heuristic based scanner                                                                             | active, aggressive, deadly, web-thorough                         | URL, WEB_PARAMETER                                                                                                                      | FINDING, VULNERABILITY                                      | @liquidsec                | 2024-06-28     |
| medusa                | scan     | No              | Medusa SNMP bruteforcing with v1, v2c and R/W check.                                                                                                  | active, aggressive, deadly                                       | PROTOCOL                                                                                                                                | VULNERABILITY                                               | @christianfl              | 2025-05-16     |
| newsletters           | scan     | No              | Searches for Newsletter Submission Entry Fields on Websites                                                                                           | active, safe                                                     | HTTP_RESPONSE                                                                                                                           | FINDING                                                     | @stryker2k2               | 2024-02-02     |
| ntlm                  | scan     | No              | Watch for HTTP endpoints that support NTLM authentication                                                                                             | active, safe, web-basic                                          | HTTP_RESPONSE, URL                                                                                                                      | DNS_NAME, FINDING                                           | @liquidsec                | 2022-07-25     |
| nuclei                | scan     | No              | Fast and customisable vulnerability scanner                                                                                                           | active, aggressive, deadly                                       | URL                                                                                                                                     | FINDING, TECHNOLOGY, VULNERABILITY                          | @TheTechromancer          | 2022-03-12     |
| oauth                 | scan     | No              | Enumerate OAUTH and OpenID Connect services                                                                                                           | active, affiliates, cloud-enum, safe, subdomain-enum, web-basic  | DNS_NAME, URL_UNVERIFIED                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2023-07-12     |
| paramminer_cookies    | scan     | No              | Smart brute-force to check for common HTTP cookie parameters                                                                                          | active, aggressive, slow, web-paramminer                         | HTTP_RESPONSE, WEB_PARAMETER                                                                                                            | FINDING, WEB_PARAMETER                                      | @liquidsec                | 2022-06-27     |
| paramminer_getparams  | scan     | No              | Use smart brute-force to check for common HTTP GET parameters                                                                                         | active, aggressive, slow, web-paramminer                         | HTTP_RESPONSE, WEB_PARAMETER                                                                                                            | FINDING, WEB_PARAMETER                                      | @liquidsec                | 2022-06-28     |
| paramminer_headers    | scan     | No              | Use smart brute-force to check for common HTTP header parameters                                                                                      | active, aggressive, slow, web-paramminer                         | HTTP_RESPONSE, WEB_PARAMETER                                                                                                            | WEB_PARAMETER                                               | @liquidsec                | 2022-04-15     |
| portscan              | scan     | No              | Port scan with masscan. By default, scans top 100 ports.                                                                                              | active, portscan, safe                                           | DNS_NAME, IP_ADDRESS, IP_RANGE                                                                                                          | OPEN_TCP_PORT                                               | @TheTechromancer          | 2024-05-15     |
| reflected_parameters  | scan     | No              | Highlight parameters that reflect their contents in response body                                                                                     | active, safe, web-thorough                                       | WEB_PARAMETER                                                                                                                           | FINDING                                                     | @liquidsec                | 2024-10-29     |
| retirejs              | scan     | No              | Detect vulnerable/out-of-date JavaScript libraries                                                                                                    | active, safe, web-thorough                                       | URL_UNVERIFIED                                                                                                                          | FINDING                                                     | @liquidsec                | 2025-08-19     |
| robots                | scan     | No              | Look for and parse robots.txt                                                                                                                         | active, safe, web-basic                                          | URL                                                                                                                                     | URL_UNVERIFIED                                              | @liquidsec                | 2023-02-01     |
| securitytxt           | scan     | No              | Check for security.txt content                                                                                                                        | active, cloud-enum, safe, subdomain-enum, web-basic              | DNS_NAME                                                                                                                                | EMAIL_ADDRESS, URL_UNVERIFIED                               | @colin-stubbs             | 2024-05-26     |
| smuggler              | scan     | No              | Check for HTTP smuggling                                                                                                                              | active, aggressive, slow, web-thorough                           | URL                                                                                                                                     | FINDING                                                     | @liquidsec                | 2022-07-06     |
| sslcert               | scan     | No              | Visit open ports and retrieve SSL certificates                                                                                                        | active, affiliates, email-enum, safe, subdomain-enum, web-basic  | OPEN_TCP_PORT                                                                                                                           | DNS_NAME, EMAIL_ADDRESS                                     | @TheTechromancer          | 2022-03-30     |
| telerik               | scan     | No              | Scan for critical Telerik vulnerabilities                                                                                                             | active, aggressive, web-thorough                                 | HTTP_RESPONSE, URL                                                                                                                      | FINDING, VULNERABILITY                                      | @liquidsec                | 2022-04-10     |
| url_manipulation      | scan     | No              | Attempt to identify URL parsing/routing based vulnerabilities                                                                                         | active, aggressive, web-thorough                                 | URL                                                                                                                                     | FINDING                                                     | @liquidsec                | 2022-09-27     |
| vhost                 | scan     | No              | Fuzz for virtual hosts                                                                                                                                | active, aggressive, deadly, slow                                 | URL                                                                                                                                     | DNS_NAME, VHOST                                             | @liquidsec                | 2022-05-02     |
| wafw00f               | scan     | No              | Web Application Firewall Fingerprinting Tool                                                                                                          | active, aggressive                                               | URL                                                                                                                                     | WAF                                                         | @liquidsec                | 2023-02-15     |
| wappalyzer            | scan     | No              | Extract technologies from web responses                                                                                                               | active, safe, web-basic                                          | HTTP_RESPONSE                                                                                                                           | TECHNOLOGY                                                  | @liquidsec                | 2022-04-15     |
| wpscan                | scan     | No              | Wordpress security scanner. Highly recommended to use an API key for better results.                                                                  | active, aggressive                                               | HTTP_RESPONSE, TECHNOLOGY                                                                                                               | FINDING, TECHNOLOGY, URL_UNVERIFIED, VULNERABILITY          | @domwhewell-sage          | 2024-05-29     |
| affiliates            | scan     | No              | Summarize affiliate domains at the end of a scan                                                                                                      | affiliates, passive, safe                                        | *                                                                                                                                       |                                                             | @TheTechromancer          | 2022-07-25     |
| anubisdb              | scan     | No              | Query jldc.me's database for subdomains                                                                                                               | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-10-04     |
| apkpure               | scan     | No              | Download android applications from apkpure.com                                                                                                        | code-enum, download, passive, safe                               | MOBILE_APP                                                                                                                              | FILESYSTEM                                                  | @domwhewell-sage          | 2024-10-11     |
| asn                   | scan     | No              | Query ripe and bgpview.io for ASNs                                                                                                                    | passive, safe, subdomain-enum                                    | IP_ADDRESS                                                                                                                              | ASN                                                         | @TheTechromancer          | 2022-07-25     |
| azure_realm           | scan     | No              | Retrieves the "AuthURL" from login.microsoftonline.com/getuserrealm                                                                                   | affiliates, cloud-enum, passive, safe, subdomain-enum, web-basic | DNS_NAME                                                                                                                                | URL_UNVERIFIED                                              | @TheTechromancer          | 2023-07-12     |
| azure_tenant          | scan     | No              | Query Azure for tenant sister domains                                                                                                                 | affiliates, cloud-enum, passive, safe, subdomain-enum            | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2024-07-04     |
| bevigil               | scan     | Yes             | Retrieve OSINT data from mobile applications using BeVigil                                                                                            | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME, URL_UNVERIFIED                                    | @alt-glitch               | 2022-10-26     |
| bucket_file_enum      | scan     | No              | Works in conjunction with the filedownload module to download files from open storage buckets. Currently supported cloud providers: AWS, DigitalOcean | cloud-enum, passive, safe                                        | STORAGE_BUCKET                                                                                                                          | URL_UNVERIFIED                                              | @TheTechromancer          | 2023-11-14     |
| bufferoverrun         | scan     | Yes             | Query BufferOverrun's TLS API for subdomains                                                                                                          | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2024-10-23     |
| builtwith             | scan     | Yes             | Query Builtwith.com for subdomains                                                                                                                    | affiliates, passive, safe, subdomain-enum                        | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-08-23     |
| c99                   | scan     | Yes             | Query the C99 API for subdomains                                                                                                                      | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-07-08     |
| certspotter           | scan     | No              | Query Certspotter's API for subdomains                                                                                                                | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-07-28     |
| chaos                 | scan     | Yes             | Query ProjectDiscovery's Chaos API for subdomains                                                                                                     | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-08-14     |
| code_repository       | scan     | No              | Look for code repository links in webpages                                                                                                            | code-enum, passive, safe                                         | URL_UNVERIFIED                                                                                                                          | CODE_REPOSITORY                                             | @domwhewell-sage          | 2024-05-15     |
| credshed              | scan     | Yes             | Send queries to your own credshed server to check for known credentials of your targets                                                               | passive, safe                                                    | DNS_NAME                                                                                                                                | EMAIL_ADDRESS, HASHED_PASSWORD, PASSWORD, USERNAME          | @SpamFaux                 | 2023-10-12     |
| crt                   | scan     | No              | Query crt.sh (certificate transparency) for subdomains                                                                                                | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-05-13     |
| crt_db                | scan     | No              | Query crt.sh (certificate transparency) for subdomains via PostgreSQL                                                                                 | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2025-03-27     |
| dehashed              | scan     | Yes             | Execute queries against dehashed.com for exposed credentials                                                                                          | email-enum, passive, safe                                        | DNS_NAME                                                                                                                                | EMAIL_ADDRESS, HASHED_PASSWORD, PASSWORD, USERNAME          | @SpamFaux                 | 2023-10-12     |
| digitorus             | scan     | No              | Query certificatedetails.com for subdomains                                                                                                           | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2023-07-25     |
| dnsbimi               | scan     | No              | Check DNS_NAME's for BIMI records to find image and certificate hosting URL's                                                                         | cloud-enum, passive, safe, subdomain-enum                        | DNS_NAME                                                                                                                                | RAW_DNS_RECORD, URL_UNVERIFIED                              | @colin-stubbs             | 2024-11-15     |
| dnscaa                | scan     | No              | Check for CAA records                                                                                                                                 | email-enum, passive, safe, subdomain-enum                        | DNS_NAME                                                                                                                                | DNS_NAME, EMAIL_ADDRESS, URL_UNVERIFIED                     | @colin-stubbs             | 2024-05-26     |
| dnsdumpster           | scan     | No              | Query dnsdumpster for subdomains                                                                                                                      | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-03-12     |
| dnstlsrpt             | scan     | No              | Check for TLS-RPT records                                                                                                                             | cloud-enum, email-enum, passive, safe, subdomain-enum            | DNS_NAME                                                                                                                                | EMAIL_ADDRESS, RAW_DNS_RECORD, URL_UNVERIFIED               | @colin-stubbs             | 2024-07-26     |
| docker_pull           | scan     | No              | Download images from a docker repository                                                                                                              | code-enum, download, passive, safe, slow                         | CODE_REPOSITORY                                                                                                                         | FILESYSTEM                                                  | @domwhewell-sage          | 2024-03-24     |
| dockerhub             | scan     | No              | Search for docker repositories of discovered orgs/usernames                                                                                           | code-enum, passive, safe                                         | ORG_STUB, SOCIAL                                                                                                                        | CODE_REPOSITORY, SOCIAL, URL_UNVERIFIED                     | @domwhewell-sage          | 2024-03-12     |
| emailformat           | scan     | No              | Query email-format.com for email addresses                                                                                                            | email-enum, passive, safe                                        | DNS_NAME                                                                                                                                | EMAIL_ADDRESS                                               | @TheTechromancer          | 2022-07-11     |
| extractous            | scan     | No              | Module to extract data from files                                                                                                                     | passive, safe                                                    | FILESYSTEM                                                                                                                              | RAW_TEXT                                                    | @domwhewell-sage          | 2024-06-03     |
| fullhunt              | scan     | Yes             | Query the fullhunt.io API for subdomains                                                                                                              | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-08-24     |
| git_clone             | scan     | No              | Clone code github repositories                                                                                                                        | code-enum, download, passive, safe, slow                         | CODE_REPOSITORY                                                                                                                         | FILESYSTEM                                                  | @domwhewell-sage          | 2024-03-08     |
| gitdumper             | scan     | No              | Download a leaked .git folder recursively or by fuzzing common names                                                                                  | code-enum, download, passive, safe, slow                         | CODE_REPOSITORY                                                                                                                         | FILESYSTEM                                                  | @domwhewell-sage          | 2025-02-11     |
| github_codesearch     | scan     | Yes             | Query Github's API for code containing the target domain name                                                                                         | code-enum, passive, safe, subdomain-enum                         | DNS_NAME                                                                                                                                | CODE_REPOSITORY, URL_UNVERIFIED                             | @domwhewell-sage          | 2023-12-14     |
| github_org            | scan     | No              | Query Github's API for organization and member repositories                                                                                           | code-enum, passive, safe, subdomain-enum                         | ORG_STUB, SOCIAL                                                                                                                        | CODE_REPOSITORY                                             | @domwhewell-sage          | 2023-12-14     |
| github_usersearch     | scan     | Yes             | Query Github's API for users with emails matching in scope domains that may not be discoverable by listing members of the organization.               | code-enum, passive, safe                                         | DNS_NAME                                                                                                                                | EMAIL_ADDRESS, SOCIAL                                       | @domwhewell-sage          | 2025-05-10     |
| github_workflows      | scan     | Yes             | Download a github repositories workflow logs and workflow artifacts                                                                                   | code-enum, download, passive, safe                               | CODE_REPOSITORY                                                                                                                         | FILESYSTEM                                                  | @domwhewell-sage          | 2024-04-29     |
| google_playstore      | scan     | No              | Search for android applications on play.google.com                                                                                                    | code-enum, passive, safe                                         | CODE_REPOSITORY, ORG_STUB                                                                                                               | MOBILE_APP                                                  | @domwhewell-sage          | 2024-10-08     |
| hackertarget          | scan     | No              | Query the hackertarget.com API for subdomains                                                                                                         | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-07-28     |
| hunterio              | scan     | Yes             | Query hunter.io for emails                                                                                                                            | email-enum, passive, safe, subdomain-enum                        | DNS_NAME                                                                                                                                | DNS_NAME, EMAIL_ADDRESS, URL_UNVERIFIED                     | @TheTechromancer          | 2022-04-25     |
| ip2location           | scan     | Yes             | Query IP2location.io's API for geolocation information.                                                                                               | passive, safe                                                    | IP_ADDRESS                                                                                                                              | GEOLOCATION                                                 | @TheTechromancer          | 2023-09-12     |
| ipneighbor            | scan     | No              | Look beside IPs in their surrounding subnet                                                                                                           | aggressive, passive, subdomain-enum                              | IP_ADDRESS                                                                                                                              | IP_ADDRESS                                                  | @TheTechromancer          | 2022-06-08     |
| ipstack               | scan     | Yes             | Query IPStack's GeoIP API                                                                                                                             | passive, safe                                                    | IP_ADDRESS                                                                                                                              | GEOLOCATION                                                 | @tycoonslive              | 2022-11-26     |
| jadx                  | scan     | No              | Decompile APKs and XAPKs using JADX                                                                                                                   | code-enum, passive, safe                                         | FILESYSTEM                                                                                                                              | FILESYSTEM                                                  | @domwhewell-sage          | 2024-11-04     |
| leakix                | scan     | No              | Query leakix.net for subdomains                                                                                                                       | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-07-11     |
| myssl                 | scan     | No              | Query myssl.com's API for subdomains                                                                                                                  | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2023-07-10     |
| otx                   | scan     | Yes             | Query otx.alienvault.com for subdomains                                                                                                               | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-08-24     |
| passivetotal          | scan     | Yes             | Query the PassiveTotal API for subdomains                                                                                                             | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-08-08     |
| pgp                   | scan     | No              | Query common PGP servers for email addresses                                                                                                          | email-enum, passive, safe                                        | DNS_NAME                                                                                                                                | EMAIL_ADDRESS                                               | @TheTechromancer          | 2022-08-10     |
| portfilter            | scan     | No              | Filter out unwanted open ports from cloud/CDN targets                                                                                                 | passive, safe                                                    | OPEN_TCP_PORT, URL, URL_UNVERIFIED                                                                                                      |                                                             | @TheTechromancer          | 2025-01-06     |
| postman               | scan     | No              | Query Postman's API for related workspaces, collections, requests and download them                                                                   | code-enum, passive, safe, subdomain-enum                         | ORG_STUB, SOCIAL                                                                                                                        | CODE_REPOSITORY                                             | @domwhewell-sage          | 2024-09-07     |
| postman_download      | scan     | No              | Download workspaces, collections, requests from Postman                                                                                               | code-enum, download, passive, safe, subdomain-enum               | CODE_REPOSITORY                                                                                                                         | FILESYSTEM                                                  | @domwhewell-sage          | 2024-09-07     |
| rapiddns              | scan     | No              | Query rapiddns.io for subdomains                                                                                                                      | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-08-24     |
| securitytrails        | scan     | Yes             | Query the SecurityTrails API for subdomains                                                                                                           | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-07-03     |
| shodan_dns            | scan     | Yes             | Query Shodan for subdomains                                                                                                                           | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-07-03     |
| shodan_idb            | scan     | No              | Query Shodan's InternetDB for open ports, hostnames, technologies, and vulnerabilities                                                                | passive, portscan, safe, subdomain-enum                          | DNS_NAME, IP_ADDRESS                                                                                                                    | DNS_NAME, FINDING, OPEN_TCP_PORT, TECHNOLOGY, VULNERABILITY | @TheTechromancer          | 2023-12-22     |
| sitedossier           | scan     | No              | Query sitedossier.com for subdomains                                                                                                                  | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2023-08-04     |
| skymem                | scan     | No              | Query skymem.info for email addresses                                                                                                                 | email-enum, passive, safe                                        | DNS_NAME                                                                                                                                | EMAIL_ADDRESS                                               | @TheTechromancer          | 2022-07-11     |
| social                | scan     | No              | Look for social media links in webpages                                                                                                               | passive, safe, social-enum                                       | URL_UNVERIFIED                                                                                                                          | SOCIAL                                                      | @TheTechromancer          | 2023-03-28     |
| subdomaincenter       | scan     | No              | Query subdomain.center's API for subdomains                                                                                                           | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2023-07-26     |
| subdomainradar        | scan     | Yes             | Query the Subdomain API for subdomains                                                                                                                | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-07-08     |
| trickest              | scan     | Yes             | Query Trickest's API for subdomains                                                                                                                   | affiliates, passive, safe, subdomain-enum                        | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @amiremami                | 2024-07-27     |
| trufflehog            | scan     | No              | TruffleHog is a tool for finding credentials                                                                                                          | code-enum, passive, safe                                         | CODE_REPOSITORY, FILESYSTEM, HTTP_RESPONSE, RAW_TEXT                                                                                    | FINDING, VULNERABILITY                                      | @domwhewell-sage          | 2024-03-12     |
| urlscan               | scan     | No              | Query urlscan.io for subdomains                                                                                                                       | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME, URL_UNVERIFIED                                    | @TheTechromancer          | 2022-06-09     |
| viewdns               | scan     | No              | Query viewdns.info's reverse whois for related domains                                                                                                | affiliates, passive, safe                                        | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-07-04     |
| virustotal            | scan     | Yes             | Query VirusTotal's API for subdomains                                                                                                                 | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME                                                    | @TheTechromancer          | 2022-08-25     |
| wayback               | scan     | No              | Query archive.org's API for subdomains                                                                                                                | passive, safe, subdomain-enum                                    | DNS_NAME                                                                                                                                | DNS_NAME, URL_UNVERIFIED                                    | @liquidsec                | 2022-04-01     |
| asset_inventory       | output   | No              | Merge hosts, open ports, technologies, findings, etc. into a single asset inventory CSV                                                               |                                                                  | DNS_NAME, FINDING, HTTP_RESPONSE, IP_ADDRESS, OPEN_TCP_PORT, TECHNOLOGY, URL, VULNERABILITY, WAF                                        | IP_ADDRESS, OPEN_TCP_PORT                                   | @liquidsec                | 2022-09-30     |
| csv                   | output   | No              | Output to CSV                                                                                                                                         |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2022-04-07     |
| discord               | output   | No              | Message a Discord channel when certain events are encountered                                                                                         |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2023-08-14     |
| emails                | output   | No              | Output any email addresses found belonging to the target domain                                                                                       | email-enum                                                       | EMAIL_ADDRESS                                                                                                                           |                                                             | @domwhewell-sage          | 2023-12-23     |
| http                  | output   | No              | Send every event to a custom URL via a web request                                                                                                    |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2022-04-13     |
| json                  | output   | No              | Output to Newline-Delimited JSON (NDJSON)                                                                                                             |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2022-04-07     |
| mysql                 | output   | No              | Output scan data to a MySQL database                                                                                                                  |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2024-11-13     |
| neo4j                 | output   | No              | Output to Neo4j                                                                                                                                       |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2022-04-07     |
| nmap_xml              | output   | No              | Output to Nmap XML                                                                                                                                    |                                                                  | DNS_NAME, HTTP_RESPONSE, IP_ADDRESS, OPEN_TCP_PORT, PROTOCOL                                                                            |                                                             | @TheTechromancer          | 2024-11-16     |
| postgres              | output   | No              | Output scan data to a SQLite database                                                                                                                 |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2024-11-08     |
| python                | output   | No              | Output via Python API                                                                                                                                 |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2022-09-13     |
| slack                 | output   | No              | Message a Slack channel when certain events are encountered                                                                                           |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2023-08-14     |
| splunk                | output   | No              | Send every event to a splunk instance through HTTP Event Collector                                                                                    |                                                                  | *                                                                                                                                       |                                                             | @w0Tx                     | 2024-02-17     |
| sqlite                | output   | No              | Output scan data to a SQLite database                                                                                                                 |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2024-11-07     |
| stdout                | output   | No              | Output to text                                                                                                                                        |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2024-04-03     |
| subdomains            | output   | No              | Output only resolved, in-scope subdomains                                                                                                             | subdomain-enum                                                   | DNS_NAME, DNS_NAME_UNRESOLVED                                                                                                           |                                                             | @TheTechromancer          | 2023-07-31     |
| teams                 | output   | No              | Message a Teams channel when certain events are encountered                                                                                           |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2023-08-14     |
| txt                   | output   | No              | Output to text                                                                                                                                        |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2024-04-03     |
| web_parameters        | output   | No              | Output WEB_PARAMETER names to a file                                                                                                                  |                                                                  | WEB_PARAMETER                                                                                                                           |                                                             | @liquidsec                | 2025-01-25     |
| web_report            | output   | No              | Create a markdown report with web assets                                                                                                              |                                                                  | FINDING, TECHNOLOGY, URL, VHOST, VULNERABILITY                                                                                          |                                                             | @liquidsec                | 2023-02-08     |
| websocket             | output   | No              | Output to websockets                                                                                                                                  |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2022-04-15     |
| cloudcheck            | internal | No              | Tag events by cloud provider, identify cloud resources like storage buckets                                                                           |                                                                  | *                                                                                                                                       |                                                             | @TheTechromancer          | 2024-07-07     |
| dnsresolve            | internal | No              | Perform DNS resolution                                                                                                                                |                                                                  | *                                                                                                                                       | DNS_NAME, IP_ADDRESS, RAW_DNS_RECORD                        | @TheTechromancer          | 2022-04-08     |
| aggregate             | internal | No              | Summarize statistics at the end of a scan                                                                                                             | passive, safe                                                    |                                                                                                                                         |                                                             | @TheTechromancer          | 2022-07-25     |
| excavate              | internal | No              | Passively extract juicy tidbits from scan data                                                                                                        | passive                                                          | HTTP_RESPONSE, RAW_TEXT                                                                                                                 | URL_UNVERIFIED, WEB_PARAMETER                               | @liquidsec                | 2022-06-27     |
| speculate             | internal | No              | Derive certain event types from others by common sense                                                                                                | passive                                                          | AZURE_TENANT, DNS_NAME, DNS_NAME_UNRESOLVED, HTTP_RESPONSE, IP_ADDRESS, IP_RANGE, SOCIAL, STORAGE_BUCKET, URL, URL_UNVERIFIED, USERNAME | DNS_NAME, FINDING, IP_ADDRESS, OPEN_TCP_PORT, ORG_STUB      | @liquidsec                | 2022-05-03     |
| unarchive             | internal | No              | Extract different types of files into folders on the filesystem                                                                                       | passive, safe                                                    | FILESYSTEM                                                                                                                              | FILESYSTEM                                                  | @domwhewell-sage          | 2024-12-08     |
<!-- END BBOT MODULES -->

For a list of module config options, see [Module Options](../scanning/configuration.md#module-config-options).
