#
# Copyright (c) 2006-2026 Wade Alcorn - wade@bindshell.net
# Browser Exploitation Framework (BeEF) - https://beefproject.com
# See the file 'doc/COPYING' for copying permission
#
class Zenoss_add_user_csrf < BeEF::Core::Command
  def self.options
    [
      { 'name' => 'base', 'ui_label' => 'Zenoss web root', 'value' => 'http://192.168.1.1:8080/' },
      { 'name' => 'username', 'ui_label' => 'Username', 'value' => 'username' },
      { 'name' => 'password', 'ui_label' => 'Password', 'value' => 'password' },
      { 'name' => 'user_level',
        'type' => 'combobox',
        'ui_label' => 'User Level',
        'store_type' => 'arraystore',
        'store_fields' => ['user_level'],
        'store_data' => [
          ['Manager'],
          ['ZenManager'],
          ['ZenUser']
        ],
        'emptyText' => 'Select a user level ("Manager" is highest)',
        'valueField' => 'user_level',
        'displayField' => 'user_level',
        'mode' => 'local',
        'autoWidth' => true }
    ]
  end

  def post_execute
    save({ 'result' => @datastore['result'] })
  end
end
