var Parser = require('htmlparser2/lib/Parser');
var DomHandler = require('domhandler');

/**
 * Parses HTML string to DOM nodes (server).
 *
 * This is the same method as `require('htmlparser2').parseDOM`
 * https://github.com/fb55/htmlparser2/blob/v3.9.1/lib/index.js#L39-L43
 *
 * @param  {String} html      - The HTML string.
 * @param  {Object} [options] - The parser options.
 * @return {Array}            - The DOM nodes.
 */
function parseDOM(html, options) {
  if (typeof html !== 'string') {
    throw new TypeError('First argument must be a string.');
  }
  var handler = new DomHandler(options);
  new Parser(handler, options).end(html);
  return handler.dom;
}

module.exports = parseDOM;
