'use strict';

exports.__esModule = true;
exports.default = ignore;
exports.hasValidExtension = hasValidExtension;

var _path = require('path');

var _es6Set = require('es6-set');

var _es6Set2 = _interopRequireDefault(_es6Set);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// one-shot memoized
var cachedSet = void 0,
    lastSettings = void 0;
function validExtensions(_ref) {
  var settings = _ref.settings;

  if (cachedSet && settings === lastSettings) {
    return cachedSet;
  }

  // todo: add 'mjs'?
  lastSettings = settings;
  // breaking: default to '.js'
  // cachedSet = new Set(settings['import/extensions'] || [ '.js' ])
  cachedSet = 'import/extensions' in settings ? makeValidExtensionSet(settings) : { has: function has() {
      return true;
    } }; // the set of all elements

  return cachedSet;
}

function makeValidExtensionSet(settings) {
  // start with explicit JS-parsed extensions
  var exts = new _es6Set2.default(settings['import/extensions']);

  // all alternate parser extensions are also valid
  if ('import/parsers' in settings) {
    for (var parser in settings['import/parsers']) {
      settings['import/parsers'][parser].forEach(function (ext) {
        return exts.add(ext);
      });
    }
  }

  return exts;
}

function ignore(path, context) {
  // ignore node_modules by default
  var ignoreStrings = context.settings['import/ignore'] ? [].concat(context.settings['import/ignore']) : ['node_modules'];

  // check extension list first (cheap)
  if (!hasValidExtension(path, context)) return true;

  if (ignoreStrings.length === 0) return false;

  for (var i = 0; i < ignoreStrings.length; i++) {
    var regex = new RegExp(ignoreStrings[i]);
    if (regex.test(path)) return true;
  }

  return false;
}

function hasValidExtension(path, context) {
  return validExtensions(context).has((0, _path.extname)(path));
}
//# sourceMappingURL=data:application/json;base64,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