/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph;

import com.paterva.maltego.core.GenericLink;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.GraphStructureWrapper;
import com.paterva.maltego.graph.MaltegoGraph;
import com.paterva.maltego.graph.MaltegoGraphEvent;
import com.paterva.maltego.graph.MaltegoGraphListener;
import com.paterva.maltego.graph.UserDataHolder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import yguard.A.A.C;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.A._;
import yguard.A.I.;
import yguard.A.I.FA;
import yguard.A.I.QA;
import yguard.A.I.o;

public class GraphWrapper
extends GraphStructureWrapper
implements MaltegoGraph {
    private Collection<MaltegoGraphListener> _listeners;
    private List<EventListener> _propertyChangeListeners = Collections.synchronizedList(new LinkedList());

    protected GraphWrapper(D d) {
        super(d);
        this.attachListeners(d);
    }

    private Collection<MaltegoGraphListener> listeners() {
        if (this._listeners == null) {
            this._listeners = Collections.synchronizedList(new LinkedList());
        }
        return this._listeners;
    }

    private void attachListeners(D d) {
        d.A(new _(){

            public void onGraphEvent(C c) {
                switch (c.C()) {
                    case 1: {
                        GraphWrapper.this.onEdgeCreated((H)c.A());
                        break;
                    }
                    case 7: {
                        GraphWrapper.this.onEdgeChanged((H)c.A());
                        break;
                    }
                    case 0: {
                        GraphWrapper.this.onNodeCreated((Y)c.A());
                        break;
                    }
                    case 6: {
                        GraphWrapper.this.onNodeChanged((Y)c.A());
                        break;
                    }
                    case 9: {
                        GraphWrapper.this.onEdgeChanged((H)c.A());
                        break;
                    }
                    case 5: {
                        GraphWrapper.this.onEdgeRemoved((H)c.A());
                        break;
                    }
                    case 3: {
                        GraphWrapper.this.onNodeRemoved((Y)c.A());
                        break;
                    }
                    case 10: {
                        GraphWrapper.this.onSubGraphInserted();
                        break;
                    }
                    case 11: {
                        GraphWrapper.this.onSubGraphRemoved();
                    }
                }
            }
        });
    }

    protected void onEdgeCreated(H h) {
    }

    protected void onEdgeChanged(H h) {
    }

    protected void onNodeCreated(Y y) {
    }

    protected void onNodeChanged(Y y) {
    }

    protected void onEdgeRemoved(H h) {
        MaltegoLink maltegoLink = this.link(h);
        if (maltegoLink != null) {
            this.linkMap().remove(maltegoLink);
        }
    }

    protected void onNodeRemoved(Y y) {
        MaltegoEntity maltegoEntity = this.entity(y);
        if (maltegoEntity != null) {
            this.entityMap().remove(maltegoEntity);
        }
    }

    protected void onSubGraphInserted() {
    }

    protected void onSubGraphRemoved() {
    }

    private void fireGraphEvent(MaltegoGraphEvent maltegoGraphEvent) {
        if (this._listeners != null) {
            for (MaltegoGraphListener maltegoGraphListener : this._listeners) {
                maltegoGraphListener.graphChanged(maltegoGraphEvent);
            }
        }
    }

    @Override
    public void add(MaltegoEntity maltegoEntity) {
        this.addAsNode(maltegoEntity);
    }

    public Y addAsNode(MaltegoEntity maltegoEntity) {
        return this.create(maltegoEntity);
    }

    @Override
    public void remove(MaltegoEntity maltegoEntity) {
        this.beginUpdate();
        Y y = this.node(maltegoEntity);
        if (y != null) {
            this.graph().B(y);
        }
        this.entityMap().remove(maltegoEntity);
        this.endUpdate();
    }

    @Override
    public void connect(MaltegoEntity maltegoEntity, MaltegoEntity maltegoEntity2, MaltegoLink maltegoLink) {
        this.connectWithEdge(maltegoEntity, maltegoEntity2, maltegoLink);
    }

    public H connectWithEdge(MaltegoEntity maltegoEntity, MaltegoEntity maltegoEntity2, MaltegoLink maltegoLink) {
        Y y;
        this.beginUpdate();
        Y y2 = this.node(maltegoEntity);
        if (y2 == null) {
            y2 = this.create(maltegoEntity);
        }
        if ((y = this.node(maltegoEntity2)) == null) {
            y = this.create(maltegoEntity2);
        }
        if (maltegoLink == null) {
            maltegoLink = new GenericLink("Generic Link");
        }
        H h = this.create(y2, y, maltegoLink);
        this.endUpdate();
        return h;
    }

    @Override
    public void remove(MaltegoLink maltegoLink) {
        this.beginUpdate();
        H h = this.edge(maltegoLink);
        if (h != null) {
            this.graph().H(h);
        }
        this.linkMap().remove(maltegoLink);
        this.endUpdate();
    }

    public H create(Y y, Y y2, MaltegoLink maltegoLink) {
        this.beginUpdate();
        H h = this.graph().A(y, y2);
        this.set(h, maltegoLink);
        this.endUpdate();
        return h;
    }

    private Y create(MaltegoEntity maltegoEntity) {
        this.beginUpdate();
        Y y = this.graph().\u00cb();
        this.set(y, maltegoEntity);
        this.endUpdate();
        return y;
    }

    public void reAdd(MaltegoEntity maltegoEntity) {
        this.replace(maltegoEntity, maltegoEntity);
    }

    public void replace(MaltegoEntity maltegoEntity, MaltegoEntity maltegoEntity2) {
        LinkEntityMap linkEntityMap = this.getOutgoingLinks(maltegoEntity);
        LinkEntityMap linkEntityMap2 = this.getIncomingLinks(maltegoEntity);
        this.remove(maltegoEntity);
        this.add(maltegoEntity2);
        this.connect(maltegoEntity2, linkEntityMap, linkEntityMap2);
    }

    private LinkEntityMap getIncomingLinks(MaltegoEntity maltegoEntity) {
        LinkEntityMap linkEntityMap = new LinkEntityMap();
        for (MaltegoLink maltegoLink : this.incoming(maltegoEntity)) {
            linkEntityMap.put(maltegoLink, this.source(maltegoLink));
        }
        return linkEntityMap;
    }

    private LinkEntityMap getOutgoingLinks(MaltegoEntity maltegoEntity) {
        LinkEntityMap linkEntityMap = new LinkEntityMap();
        for (MaltegoLink maltegoLink : this.outgoing(maltegoEntity)) {
            linkEntityMap.put(maltegoLink, this.target(maltegoLink));
        }
        return linkEntityMap;
    }

    private void connect(MaltegoEntity maltegoEntity, LinkEntityMap linkEntityMap, LinkEntityMap linkEntityMap2) {
        for (MaltegoLink maltegoLink : linkEntityMap.keySet()) {
            this.connect(maltegoEntity, (MaltegoEntity)linkEntityMap.get(maltegoLink), maltegoLink);
        }
        for (MaltegoLink maltegoLink : linkEntityMap2.keySet()) {
            this.connect((MaltegoEntity)linkEntityMap2.get(maltegoLink), maltegoEntity, maltegoLink);
        }
    }

    @Override
    public void addMaltegoGraphListener(MaltegoGraphListener maltegoGraphListener) {
        this.listeners().add(maltegoGraphListener);
    }

    @Override
    public void removeMaltegoGraphListener(MaltegoGraphListener maltegoGraphListener) {
        if (this._listeners != null) {
            this._listeners.remove(maltegoGraphListener);
        }
    }

    @Override
    public void beginUpdate() {
        this.graph().\u00e3();
    }

    @Override
    public void endUpdate() {
        this.graph().\u00d0();
    }

    public void set(Y y, MaltegoEntity maltegoEntity) {
        if (maltegoEntity != null) {
            QA qA;
            .A a;
            assert (y != null);
            this.nodeMap().set((Object)y, (Object)maltegoEntity);
            this.entityMap().put(maltegoEntity, y);
            D d = this.getGraph();
            if (d instanceof QA && (a = (qA = (QA)d).f(y)) instanceof FA) {
                ((FA)a).setUserData((Object)maltegoEntity);
            }
        }
    }

    public void set(H h, MaltegoLink maltegoLink) {
        if (maltegoLink != null) {
            QA qA;
            o o2;
            assert (h != null);
            this.edgeMap().set((Object)h, (Object)maltegoLink);
            this.linkMap().put(maltegoLink, h);
            D d = this.getGraph();
            if (d instanceof QA && (o2 = (qA = (QA)d).X(h)) instanceof UserDataHolder) {
                ((UserDataHolder)o2).setUserData(maltegoLink);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeListeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeListeners.remove(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeListener[] propertyChangeListenerArray = this._propertyChangeListeners.toArray(new PropertyChangeListener[0]);
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            propertyChangeListenerArray[i].propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    private class LinkEntityMap
    extends HashMap<MaltegoLink, MaltegoEntity> {
        private LinkEntityMap() {
        }
    }
}

