/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.core;

import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptorSet;
import com.paterva.maltego.typing.TypeRegistry;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class GenericPart
implements MaltegoPart {
    protected String _typeName;
    protected String _valuePropertyName;
    protected String _displayValuePropertyName;
    protected PropertyDescriptorSet _properties;
    protected DataSources.Map _data;
    protected PropertyChangeSupport _changeSupport;
    protected PropertyChangeSupport _notesChangeSupport;
    protected PropertyChangeSupport _bookmarkChangeSupport;
    protected Guid _id;
    protected DisplayInformationCollection _displayInformation;
    protected String _notes;
    protected boolean _showNotes = false;
    protected Integer _bookmark;

    public GenericPart(String string) {
        this._typeName = string;
        this._data = new DataSources.Map();
        this._id = Guid.create();
    }

    public GenericPart(String string, PropertyDescriptorCollection propertyDescriptorCollection) {
        this(string);
        this.getProperties().addAll(propertyDescriptorCollection);
    }

    protected GenericPart(GenericPart genericPart) {
        this._typeName = genericPart._typeName;
        this._valuePropertyName = genericPart._valuePropertyName;
        this._displayValuePropertyName = genericPart._displayValuePropertyName;
        this._id = genericPart._id;
        this.getProperties().addAll((PropertyDescriptorCollection)genericPart.getProperties());
        this._data = new DataSources.Map();
        this._data.putAll((Map)genericPart._data);
        if (genericPart._displayInformation != null) {
            this.getDisplayInformation().addAll(genericPart._displayInformation);
            this.setDisplayInformation(this._displayInformation);
        }
        this._notes = genericPart._notes;
        this._showNotes = genericPart._showNotes;
        this._bookmark = genericPart._bookmark;
    }

    protected Object getSpecialPropertyValue(String string) {
        PropertyDescriptor propertyDescriptor = this.getSpecialProperty(string);
        if (propertyDescriptor == null) {
            return null;
        }
        return this.getValue(propertyDescriptor);
    }

    protected void setSpecialPropertyValue(String string, Object object) {
        PropertyDescriptor propertyDescriptor = this.getSpecialProperty(string);
        if (propertyDescriptor == null) {
            if (object != null) {
                PropertyDescriptor propertyDescriptor2 = new PropertyDescriptor(object.getClass(), string);
                this.addProperty(propertyDescriptor2);
                this.setValue(propertyDescriptor2, object);
            }
        } else {
            this.setValue(propertyDescriptor, object);
        }
    }

    protected PropertyDescriptor getSpecialProperty(String string) {
        if (string == null) {
            return null;
        }
        return this.getProperties().get(string);
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public void setTypeName(String string) {
        this._typeName = string;
        this.firePropertyChange("type");
    }

    @Override
    public PropertyDescriptor getValueProperty() {
        return this.getSpecialProperty(this._valuePropertyName);
    }

    @Override
    public void setValueProperty(PropertyDescriptor propertyDescriptor) {
        boolean bl = false;
        if (propertyDescriptor == null) {
            bl = this._valuePropertyName != null;
            this._valuePropertyName = null;
        } else {
            bl = !propertyDescriptor.getName().equals(this._valuePropertyName);
            this._valuePropertyName = propertyDescriptor.getName();
        }
        if (bl) {
            this.firePropertyChange("value");
        }
    }

    @Override
    public PropertyDescriptor getDisplayValueProperty() {
        return this.getSpecialProperty(this._displayValuePropertyName);
    }

    @Override
    public void setDisplayValueProperty(PropertyDescriptor propertyDescriptor) {
        boolean bl = false;
        if (propertyDescriptor == null) {
            bl = this._displayValuePropertyName != null;
            this._displayValuePropertyName = null;
        } else {
            bl = !propertyDescriptor.getName().equals(this._displayValuePropertyName);
            this._displayValuePropertyName = propertyDescriptor.getName();
        }
        if (bl) {
            this.firePropertyChange("displayValue");
        }
    }

    @Override
    public Object getValue() {
        return this.getSpecialPropertyValue(this._valuePropertyName);
    }

    @Override
    public void setValue(Object object) {
        if (this._valuePropertyName == null) {
            this._valuePropertyName = "value";
        }
        this.setSpecialPropertyValue(this._valuePropertyName, object);
    }

    @Override
    public Object getDisplayValue() {
        Object object = this.getSpecialPropertyValue(this._displayValuePropertyName);
        if (!this.isNullOrEmpty(object)) {
            return object;
        }
        return this.getValue();
    }

    @Override
    public void setDisplayValue(Object object) {
        if (this._displayValuePropertyName == null) {
            this._displayValuePropertyName = "display-value";
        }
        this.setSpecialPropertyValue(this._displayValuePropertyName, object);
    }

    @Override
    public void addProperty(PropertyDescriptor propertyDescriptor) {
        if (this.getProperties().add(propertyDescriptor)) {
            this.firePropertiesChanged();
        }
    }

    @Override
    public void removeProperty(PropertyDescriptor propertyDescriptor) {
        this.setValue(propertyDescriptor, null);
        if (this.getProperties().remove(propertyDescriptor)) {
            this.firePropertiesChanged();
        }
    }

    @Override
    public void removeProperty(String string) {
        PropertyDescriptor propertyDescriptor = this.getProperties().get(string);
        if (propertyDescriptor != null) {
            this.removeProperty(propertyDescriptor);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertiesChanged() {
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange("properties", null, this.getProperties());
        }
    }

    protected void firePropertyChange(String string) {
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(string, null, null);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(string, object, object2);
        }
    }

    protected void checkSpecialPropertyUpdate(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.getName().equals(this._valuePropertyName)) {
            this.firePropertyChange("value");
        } else if (propertyDescriptor.getName().equals(this._displayValuePropertyName)) {
            this.firePropertyChange("displayValue");
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport != null) {
            this._changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyDescriptorSet getProperties() {
        if (this._properties == null) {
            this._properties = new PropertyDescriptorSet();
        }
        return this._properties;
    }

    public Object getValue(PropertyDescriptor propertyDescriptor) {
        return this._data.getValue(propertyDescriptor);
    }

    public void setValue(PropertyDescriptor propertyDescriptor, Object object) {
        Object object2;
        if (object != null) {
            object2 = object;
            boolean bl = Converter.isAssignableFrom((Class)propertyDescriptor.getType(), object.getClass());
            if (!bl && object instanceof String && !propertyDescriptor.getType().equals(String.class)) {
                boolean bl2 = bl = (object = Converter.convertFrom((String)((String)object), (Class)propertyDescriptor.getType())) != null;
            }
            if (!bl) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("The property \"");
                stringBuilder.append(propertyDescriptor.getName());
                stringBuilder.append("\" of type \"");
                stringBuilder.append(propertyDescriptor.getType().getSimpleName());
                stringBuilder.append("\" is not compatible with value \"");
                stringBuilder.append(object2);
                stringBuilder.append("\" of type \"");
                stringBuilder.append(object2.getClass().getSimpleName());
                stringBuilder.append("\"");
                throw new IllegalArgumentException(stringBuilder.toString());
            }
        }
        if (!GenericPart.areEqual(object, object2 = this._data.getValue(propertyDescriptor))) {
            if (!this.getProperties().contains(propertyDescriptor)) {
                this.getProperties().add(propertyDescriptor);
            }
            this._data.setValue(propertyDescriptor, object);
            LinkedList<PropertyDescriptor> linkedList = new LinkedList<PropertyDescriptor>();
            linkedList.add(propertyDescriptor);
            this.refreshProperties(propertyDescriptor, linkedList);
            this.firePropertyChange("value");
            this.firePropertyChange("displayValue");
            for (PropertyDescriptor propertyDescriptor2 : linkedList) {
                this.firePropertyChange(propertyDescriptor2.getName());
            }
        }
    }

    protected void refreshProperties(PropertyDescriptor propertyDescriptor, List<PropertyDescriptor> list) {
        List list2 = propertyDescriptor.getLinkedProperties();
        for (PropertyDescriptor propertyDescriptor2 : this.getProperties()) {
            if (propertyDescriptor == propertyDescriptor2) continue;
            if (list2.contains(propertyDescriptor2)) {
                this.clearProperty(propertyDescriptor2);
                list.add(propertyDescriptor2);
                continue;
            }
            List list3 = propertyDescriptor2.getLinkedProperties();
            if (!list3.contains(propertyDescriptor)) continue;
            propertyDescriptor2.refreshValues((DataSource)this._data);
            list.add(propertyDescriptor2);
        }
    }

    private void clearProperty(PropertyDescriptor propertyDescriptor) {
        this._data.setValue(propertyDescriptor, TypeRegistry.getDefault().getType(propertyDescriptor.getType()).getDefaultValue());
    }

    private static boolean areEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object != null) {
            return object.equals(object2);
        }
        return object2.equals(object);
    }

    @Override
    public DisplayInformationCollection getDisplayInformation() {
        if (this._displayInformation == null) {
            this._displayInformation = new DisplayInformationCollection();
        }
        return this._displayInformation;
    }

    @Override
    public void setDisplayInformation(DisplayInformationCollection displayInformationCollection) {
        this._displayInformation = displayInformationCollection;
        this.firePropertyChange("displayInformationChanged");
    }

    @Override
    public Guid getID() {
        return this._id;
    }

    public boolean equals(Object object) {
        if (object instanceof MaltegoPart) {
            return this.equals((MaltegoPart)object);
        }
        return false;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public boolean equals(MaltegoPart maltegoPart) {
        if (maltegoPart == null) {
            return false;
        }
        return this._id.equals(maltegoPart.getID());
    }

    private boolean isNullOrEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return ((String)object).isEmpty();
        }
        return false;
    }

    @Override
    public String getNotes() {
        return this._notes;
    }

    @Override
    public void setNotes(String string) {
        if (!GenericPart.areEqual(string, this._notes)) {
            String string2 = this._notes;
            this._notes = string;
            if (this._notesChangeSupport != null) {
                this._notesChangeSupport.firePropertyChange("notesChanged", string2, this._notes);
            }
        }
    }

    @Override
    public boolean isShowNotes() {
        return this._showNotes;
    }

    @Override
    public void setShowNotes(boolean bl) {
        if (this._showNotes != bl) {
            this._showNotes = bl;
            if (this._notesChangeSupport != null) {
                this._notesChangeSupport.firePropertyChange("showNotesChanged", !this._showNotes, this._showNotes);
            }
        }
    }

    @Override
    public void addNotesListener(PropertyChangeListener propertyChangeListener) {
        if (this._notesChangeSupport == null) {
            this._notesChangeSupport = new PropertyChangeSupport(this);
        }
        this._notesChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removeNotesListener(PropertyChangeListener propertyChangeListener) {
        if (this._notesChangeSupport != null) {
            this._notesChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public Integer getBookmark() {
        return this._bookmark;
    }

    @Override
    public void setBookmark(Integer n) {
        if (!GenericPart.areEqual(n, this._bookmark)) {
            Integer n2 = this._bookmark;
            this._bookmark = n;
            if (this._bookmarkChangeSupport != null) {
                this._bookmarkChangeSupport.firePropertyChange("bookmarkChanged", n2, this._bookmark);
            }
        }
    }

    @Override
    public void addBookmarkListener(PropertyChangeListener propertyChangeListener) {
        if (this._bookmarkChangeSupport == null) {
            this._bookmarkChangeSupport = new PropertyChangeSupport(this);
        }
        this._bookmarkChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removeBookmarkListener(PropertyChangeListener propertyChangeListener) {
        if (this._bookmarkChangeSupport != null) {
            this._bookmarkChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

