/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.entity.manager.forms.MainPropertyForm;
import com.paterva.maltego.entity.manager.forms.PropertyTypes;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.ui.dialog.DataEditController;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openide.WizardDescriptor;

public class MainPropertyFormController
extends DataEditController<MainPropertyForm, MaltegoEntitySpec>
implements WizardDescriptor.FinishablePanel {
    public MainPropertyFormController() {
        super("entitySpec");
        this.setName("Main Property");
    }

    protected String getFirstError(MainPropertyForm mainPropertyForm) {
        if (mainPropertyForm.isCreateCustomProperty()) {
            String string = mainPropertyForm.getDisplayName();
            if (string.trim().length() == 0) {
                return "Display name is required";
            }
            String string2 = mainPropertyForm.getUniqueName();
            if ((string2 = string2.trim()).length() == 0) {
                return "Unique type name is required";
            }
            if (!this.checkChars(string2)) {
                return "Only alphabetic characters, full stops and digits are allowed in the unique type name.";
            }
            if (mainPropertyForm.getDataType() == null) {
                return "Data type is required";
            }
            if (mainPropertyForm.isSampleValueEmpty()) {
                return "Sample value is required";
            }
            if (mainPropertyForm.isDefaultValueEmpty()) {
                return "Default value is required";
            }
        }
        return null;
    }

    protected MainPropertyForm createComponent() {
        final MainPropertyForm mainPropertyForm = new MainPropertyForm();
        mainPropertyForm.addChangeListener(this.changeListener());
        mainPropertyForm.addDisplayNameFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string;
                if (!MainPropertyFormController.this.isEditMode() && (string = mainPropertyForm.getUniqueName()).trim().length() == 0) {
                    mainPropertyForm.setUniqueName(MainPropertyFormController.this.createID(mainPropertyForm.getDisplayName()));
                }
            }
        });
        return mainPropertyForm;
    }

    protected boolean isEditMode() {
        return this.getDescriptor().getProperty("editMode") == Boolean.TRUE;
    }

    private String createID(String string) {
        string = string.replaceAll(" ", "");
        string = string.toLowerCase();
        return "properties." + string;
    }

    protected void setData(MainPropertyForm mainPropertyForm, MaltegoEntitySpec maltegoEntitySpec) {
        mainPropertyForm.setDataTypes(PropertyTypes.valueTypes());
        List<MaltegoEntitySpec> list = this.getInheritedSpecs(maltegoEntitySpec);
        mainPropertyForm.setInheritPropertyEnabled(!list.isEmpty());
        Boolean bl = (Boolean)this.getDescriptor().getProperty("inheritMainProperty");
        if (bl == null) {
            bl = !list.isEmpty();
        } else if (list.isEmpty()) {
            bl = Boolean.FALSE;
        }
        mainPropertyForm.setCreateCustomProperty(bl == false);
        DisplayDescriptor displayDescriptor = (DisplayDescriptor)this.getDescriptor().getProperty("mainProperty");
        if (displayDescriptor != null) {
            this.setData(mainPropertyForm, displayDescriptor);
        } else {
            mainPropertyForm.setDisplayName(maltegoEntitySpec.getDisplayName());
            mainPropertyForm.setDataType(TypeRegistry.getDefault().getType(String.class));
            mainPropertyForm.setSampleValue("-");
            mainPropertyForm.setDefaultValue(" ");
        }
    }

    private void setData(MainPropertyForm mainPropertyForm, DisplayDescriptor displayDescriptor) {
        mainPropertyForm.setDataType(displayDescriptor.getTypeDescriptor());
        mainPropertyForm.setSampleValue(displayDescriptor.getSampleValue());
        mainPropertyForm.setDefaultValue(displayDescriptor.getDefaultValue());
        mainPropertyForm.setDisplayName(displayDescriptor.getDisplayName());
        mainPropertyForm.setDescription(displayDescriptor.getDescription());
        mainPropertyForm.setUniqueName(displayDescriptor.getName());
    }

    private List<MaltegoEntitySpec> getInheritedSpecs(MaltegoEntitySpec maltegoEntitySpec) {
        HashSet<MaltegoEntitySpec> hashSet = new HashSet<MaltegoEntitySpec>();
        EntityRegistry entityRegistry = (EntityRegistry)this.getDescriptor().getProperty("entityRegistry");
        Set<MaltegoEntitySpec> set = this.getValidVisibleSpecs(entityRegistry, maltegoEntitySpec.getBaseEntitySpecs());
        for (MaltegoEntitySpec maltegoEntitySpec2 : set) {
            List list = InheritanceHelper.getInheritanceList((SpecRegistry)entityRegistry, (String)maltegoEntitySpec2.getTypeName());
            Set<MaltegoEntitySpec> set2 = this.getValidVisibleSpecs(entityRegistry, list);
            hashSet.addAll(set2);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList, new Comparator<MaltegoEntitySpec>(){

            @Override
            public int compare(MaltegoEntitySpec maltegoEntitySpec, MaltegoEntitySpec maltegoEntitySpec2) {
                return maltegoEntitySpec.getDisplayName().compareToIgnoreCase(maltegoEntitySpec2.getDisplayName());
            }
        });
        return arrayList;
    }

    private Set<MaltegoEntitySpec> getValidVisibleSpecs(EntityRegistry entityRegistry, List<String> list) {
        HashSet<MaltegoEntitySpec> hashSet = new HashSet<MaltegoEntitySpec>();
        for (String string : list) {
            MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)entityRegistry.get(string);
            if (maltegoEntitySpec == null || !maltegoEntitySpec.isVisible()) continue;
            hashSet.add(maltegoEntitySpec);
        }
        return hashSet;
    }

    protected void updateData(MainPropertyForm mainPropertyForm, MaltegoEntitySpec maltegoEntitySpec) {
        DisplayDescriptorCollection displayDescriptorCollection = maltegoEntitySpec.getProperties();
        displayDescriptorCollection.clear();
        DisplayDescriptor displayDescriptor = null;
        if (mainPropertyForm.getDataType() != null) {
            displayDescriptor = MainPropertyFormController.createProperty(mainPropertyForm.getUniqueName(), mainPropertyForm.getDataType());
            displayDescriptor.setDisplayName(mainPropertyForm.getDisplayName());
            displayDescriptor.setDescription(mainPropertyForm.getDescription());
            displayDescriptor.setSampleValue(mainPropertyForm.getSampleValue());
            displayDescriptor.setDefaultValue(mainPropertyForm.getDefaultValue());
        }
        this.getDescriptor().putProperty("mainProperty", displayDescriptor);
        this.getDescriptor().putProperty("inheritMainProperty", (Object)(!mainPropertyForm.isCreateCustomProperty() ? 1 : 0));
        if (mainPropertyForm.isCreateCustomProperty() && displayDescriptor != null) {
            displayDescriptorCollection.add((Object)displayDescriptor);
            maltegoEntitySpec.setValueProperty(displayDescriptor);
        }
    }

    private static DisplayDescriptor createProperty(String string, TypeDescriptor typeDescriptor) {
        DisplayDescriptor displayDescriptor = new DisplayDescriptor(typeDescriptor.getType(), string);
        return displayDescriptor;
    }

    public boolean isFinishPanel() {
        return true;
    }

    private boolean checkChars(String string) {
        for (char c : string.toCharArray()) {
            if (Character.isLetter(c) || c == '.' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

