/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.convert;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.table.io.api.PropertyToColumnMap;
import com.paterva.maltego.graph.table.io.api.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.api.TabularGraphLink;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TabularTranslator {
    public static Map<TabularGraphEntity, MaltegoEntity> translateEntities(List<TabularGraphEntity> list, ArrayList<Object> arrayList) throws TypeInstantiationException, RowImportException {
        HashMap<TabularGraphEntity, MaltegoEntity> hashMap = new HashMap<TabularGraphEntity, MaltegoEntity>(list.size());
        for (TabularGraphEntity tabularGraphEntity : list) {
            MaltegoEntity maltegoEntity = TabularTranslator.translate(tabularGraphEntity, arrayList);
            hashMap.put(tabularGraphEntity, maltegoEntity);
        }
        return hashMap;
    }

    private static MaltegoEntity translate(TabularGraphEntity tabularGraphEntity, ArrayList<Object> arrayList) throws TypeInstantiationException, RowImportException {
        MaltegoEntitySpec maltegoEntitySpec = tabularGraphEntity.getEntitySpec();
        MaltegoEntity maltegoEntity = EntityFactory.getDefault().createInstance(maltegoEntitySpec, false);
        TabularTranslator.translateProperties(tabularGraphEntity, (MaltegoPart)maltegoEntity, arrayList);
        return maltegoEntity;
    }

    public static Map<TabularGraphLink, MaltegoLink> translateLinks(List<TabularGraphLink> list, ArrayList<Object> arrayList) throws TypeInstantiationException, RowImportException {
        HashMap<TabularGraphLink, MaltegoLink> hashMap = new HashMap<TabularGraphLink, MaltegoLink>(list.size());
        for (TabularGraphLink tabularGraphLink : list) {
            MaltegoLink maltegoLink = TabularTranslator.translate(tabularGraphLink, arrayList);
            hashMap.put(tabularGraphLink, maltegoLink);
        }
        return hashMap;
    }

    private static MaltegoLink translate(TabularGraphLink tabularGraphLink, ArrayList<Object> arrayList) throws RowImportException {
        MaltegoLink maltegoLink = LinkFactory.createInstance((MaltegoLinkSpec)MaltegoLinkSpec.getManualSpec());
        TabularTranslator.translateProperties(tabularGraphLink, (MaltegoPart)maltegoLink, arrayList);
        return maltegoLink;
    }

    private static void translateProperties(PropertyToColumnMap propertyToColumnMap, MaltegoPart maltegoPart, ArrayList<Object> arrayList) throws RowImportException {
        for (int n : propertyToColumnMap.getColumns()) {
            PropertyDescriptor propertyDescriptor = propertyToColumnMap.getProperty(n);
            if (propertyDescriptor == null) {
                throw new RowImportException("No property set for mapped column: " + n);
            }
            Object object = TabularTranslator.getValue(n, arrayList, propertyDescriptor);
            try {
                TabularTranslator.setProperty(maltegoPart, propertyDescriptor, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RowImportException(illegalArgumentException.getMessage());
            }
        }
    }

    private static Object getValue(int n, ArrayList<Object> arrayList, PropertyDescriptor propertyDescriptor) {
        Object object = null;
        if (n < arrayList.size()) {
            object = arrayList.get(n);
        }
        if (object == null) {
            object = TypeRegistry.getDefault().getType(propertyDescriptor.getType()).getDefaultValue();
        }
        return object;
    }

    private static void setProperty(MaltegoPart maltegoPart, PropertyDescriptor propertyDescriptor, Object object) {
        if (!maltegoPart.getProperties().contains(propertyDescriptor)) {
            maltegoPart.getProperties().add(propertyDescriptor);
        }
        maltegoPart.setValue(propertyDescriptor, object);
    }

    public static class RowImportException
    extends Exception {
        public RowImportException(String string) {
            super(string);
        }
    }
}

