/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.graph.table.io.graph.ConnectivityController;
import com.paterva.maltego.graph.table.io.wizard.EntityMappingController;
import com.paterva.maltego.graph.table.io.wizard.ImportFileController;
import com.paterva.maltego.graph.table.io.wizard.ImportProgressController;
import com.paterva.maltego.graph.table.io.wizard.LinkMappingController;
import com.paterva.maltego.graph.table.io.wizard.SamplingController;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.util.ui.dialog.ArrayWizardIterator;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.io.File;
import java.text.MessageFormat;
import org.openide.WizardDescriptor;
import org.openide.util.NbPreferences;

public class ImportWizard {
    public static WizardDescriptor create(TabularGraphFileImporter[] tabularGraphFileImporterArray) {
        return ImportWizard.create(tabularGraphFileImporterArray, null);
    }

    public static WizardDescriptor create(TabularGraphFileImporter[] tabularGraphFileImporterArray, File file) {
        String string = "Graph Import Wizard";
        WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{new ImportFileController(), new EntityMappingController(), new ConnectivityController(), new LinkMappingController(), new SamplingController(), new ImportProgressController()};
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])panelArray);
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new ArrayWizardIterator(panelArray));
        wizardDescriptor.setTitleFormat(new MessageFormat("Graph Import Wizard - {0}"));
        wizardDescriptor.setTitle("Graph Import Wizard");
        wizardDescriptor.putProperty("importers", (Object)tabularGraphFileImporterArray);
        if (file != null) {
            wizardDescriptor.putProperty("selectedFile", (Object)file);
        } else {
            wizardDescriptor.putProperty("browseDir", (Object)NbPreferences.root().get("browseDir", ""));
        }
        wizardDescriptor.putProperty("newGraph", (Object)Boolean.TRUE);
        boolean bl = GraphEditorRegistry.getDefault().getTopmost() != null;
        wizardDescriptor.putProperty("showMergeGraphOption", (Object)bl);
        wizardDescriptor.putProperty("defaultLinksCreated", (Object)false);
        return wizardDescriptor;
    }
}

