/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.graph.table.io.api.PropertyToColumnMap;
import com.paterva.maltego.graph.table.io.api.TabularGraph;
import com.paterva.maltego.graph.table.io.wizard.PropertyTableModel;
import com.paterva.maltego.graph.table.io.wizard.SampleTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.openide.util.NbBundle;

public abstract class MappingPanel
extends JPanel {
    public static final int STATE_UNMAPPED = 0;
    public static final int STATE_MAPPED_ONE = 1;
    public static final int STATE_MAPPED_MANY = 2;
    private TabularGraph _tabularGraph;
    private SampleTableModel _sampleTableModel;
    private PropertyTableModel _propertyTableModel;
    private boolean _updatingCombo;
    private JCheckBox _headersCheckBox;
    private JTextArea _infoBox;
    private JComboBox _mappingCombo;
    private JTable _propertyTable;
    private JTable _sampleTable;
    private JButton _unmapButton;

    protected abstract List getMappableItems();

    protected abstract Object getItem(int var1);

    protected abstract List getItems(int[] var1);

    protected abstract Object getMappedItem(Object var1);

    protected abstract String getHint(int var1);

    public MappingPanel(SampleTableModel sampleTableModel, PropertyTableModel propertyTableModel) {
        this._sampleTableModel = sampleTableModel;
        this._propertyTableModel = propertyTableModel;
        this.initComponents();
        this._sampleTable.addPropertyChangeListener("selectionChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                List list = MappingPanel.this.getSelectedItems();
                MappingPanel.this.updateCombo(list);
                MappingPanel.this.updateUnmapButton(list);
                MappingPanel.this.updateInfo(list);
            }
        });
    }

    private void initCombo() {
        List list = this.getMappableItems();
        this._updatingCombo = true;
        this._mappingCombo.removeAllItems();
        for (Object e : list) {
            this._mappingCombo.addItem(e);
        }
        this._mappingCombo.setSelectedItem(null);
        this._updatingCombo = false;
    }

    public void setTabularGraph(TabularGraph tabularGraph) throws IOException {
        this._tabularGraph = tabularGraph;
        this._propertyTableModel.setTabularGraph(tabularGraph);
        this._sampleTableModel.setTabularGraph(this._tabularGraph);
        this.initCombo();
        List list = this.getSelectedItems();
        this.updateCombo(list);
        this.updateUnmapButton(list);
        this.updateInfo(list);
        this._headersCheckBox.setSelected(this._tabularGraph.hasHeaderRow());
        this._headersCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MappingPanel.this._tabularGraph.setHasHeaderRow(MappingPanel.this._headersCheckBox.isSelected());
            }
        });
    }

    public TabularGraph getTabularGraph() {
        return this._tabularGraph;
    }

    public void select(int[] nArray) {
        this._sampleTableModel.select(nArray);
    }

    protected void updateCombo(List list) {
        this._updatingCombo = true;
        if (list.size() == 1) {
            this._mappingCombo.setSelectedItem(this.getMappedItem(list.get(0)));
        } else {
            this._mappingCombo.setSelectedItem(null);
        }
        this._mappingCombo.setEnabled(this.getSelectedColumns().length > 0);
        this._updatingCombo = false;
    }

    protected void updatePropertyTable(List list) {
        if (list.size() != 1 || this.isUnmappedColumnsSelected()) {
            this._propertyTableModel.setMap(null);
        } else {
            PropertyToColumnMap propertyToColumnMap = (PropertyToColumnMap)list.get(0);
            if (propertyToColumnMap != this._propertyTableModel.getMap()) {
                this._propertyTableModel.setMap(propertyToColumnMap);
            }
        }
    }

    protected void updateUnmapButton(List list) {
        this._unmapButton.setEnabled(!list.isEmpty());
    }

    protected void updateInfo(List list) {
        if (list.isEmpty()) {
            this._infoBox.setText(this.getHint(0));
        } else if (list.size() == 1) {
            this._infoBox.setText(this.getHint(1));
        } else {
            this._infoBox.setText(this.getHint(2));
        }
    }

    protected boolean isUnmappedColumnsSelected() {
        for (int n : this.getSelectedColumns()) {
            if (this.getItem(n) != null) continue;
            return true;
        }
        return false;
    }

    protected int[] getSelectedColumns() {
        return this._sampleTableModel.getTable().getSelectedColumns();
    }

    protected List getSelectedItems() {
        return this.getItems(this.getSelectedColumns());
    }

    protected void onComboChanged(Object object) {
    }

    private void initComponents() {
        JSplitPane jSplitPane = new JSplitPane();
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this._sampleTable = this._sampleTableModel.getTable();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        this._mappingCombo = new JComboBox();
        this._unmapButton = new JButton();
        this._headersCheckBox = new JCheckBox();
        JPanel jPanel3 = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this._propertyTable = this._propertyTableModel.getTable();
        this._infoBox = new JTextArea();
        this.setLayout(new BorderLayout());
        jSplitPane.setBorder(null);
        jSplitPane.setOrientation(0);
        jPanel.setLayout(new BorderLayout(5, 5));
        jScrollPane.setPreferredSize(new Dimension(450, 218));
        this._sampleTable.setModel(this._sampleTableModel);
        jScrollPane.setViewportView(this._sampleTable);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel2.setLayout(new FlowLayout(0));
        jLabel.setText(NbBundle.getMessage(MappingPanel.class, (String)"MappingPanel.jLabel1.text"));
        jPanel2.add(jLabel);
        this._mappingCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._mappingCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MappingPanel.this.comboActionPerformed(actionEvent);
            }
        });
        jPanel2.add(this._mappingCombo);
        this._unmapButton.setText(NbBundle.getMessage(MappingPanel.class, (String)"MappingPanel._unmapButton.text"));
        this._unmapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MappingPanel.this.unmapButtonActionPerformed(actionEvent);
            }
        });
        jPanel2.add(this._unmapButton);
        this._headersCheckBox.setText(NbBundle.getMessage(MappingPanel.class, (String)"MappingPanel._headersCheckBox.text"));
        jPanel2.add(this._headersCheckBox);
        jPanel.add((Component)jPanel2, "North");
        jSplitPane.setTopComponent(jPanel);
        jPanel3.setPreferredSize(new Dimension(400, 250));
        jPanel3.setLayout(new BorderLayout(5, 5));
        jScrollPane2.setPreferredSize(new Dimension(450, 200));
        this._propertyTable.setModel(this._propertyTableModel);
        this._propertyTable.setPreferredSize(new Dimension(450, 100));
        jScrollPane2.setViewportView(this._propertyTable);
        jPanel3.add((Component)jScrollPane2, "Center");
        this._infoBox.setBackground(SystemColor.control);
        this._infoBox.setColumns(20);
        this._infoBox.setLineWrap(true);
        this._infoBox.setRows(1);
        this._infoBox.setWrapStyleWord(true);
        this._infoBox.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MappingPanel.class, (String)"MappingPanel._infoBox.border.title")));
        this._infoBox.setMaximumSize(new Dimension(32000, 32000));
        this._infoBox.setMinimumSize(new Dimension(0, 0));
        jPanel3.add((Component)this._infoBox, "South");
        jSplitPane.setRightComponent(jPanel3);
        this.add((Component)jSplitPane, "Center");
    }

    private void comboActionPerformed(ActionEvent actionEvent) {
        Object object;
        if (!this._updatingCombo && (object = this._mappingCombo.getSelectedItem()) != null) {
            this.onComboChanged(object);
            this.updateUnmapButton(this.getSelectedItems());
        }
        if (this._tabularGraph != null) {
            object = this.getSelectedItems();
            this.updatePropertyTable((List)object);
            this.updateInfo((List)object);
        }
    }

    private void unmapButtonActionPerformed(ActionEvent actionEvent) {
        this._tabularGraph.remove(this.getSelectedColumns());
        List list = this.getSelectedItems();
        this.updateCombo(list);
        this.updateUnmapButton(list);
        this.updateInfo(list);
    }
}

