/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import java.awt.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public abstract class ValidatingController<TComponent extends Component>
implements WizardDescriptor.Panel {
    public static final String CLIENT_PROP_NAME = "clientPropertyName";
    private TComponent _component;
    private boolean _valid = true;
    private WizardDescriptor _descriptor;
    private ChangeSupport _changeSupport = new ChangeSupport((Object)this);
    private ChangeListener _listener;
    private Map<String, Object> _clientProperties;

    public final void addChangeListener(ChangeListener changeListener) {
        this._changeSupport.addChangeListener(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this._changeSupport.removeChangeListener(changeListener);
    }

    protected WizardDescriptor getDescriptor() {
        return this._descriptor;
    }

    protected ChangeListener changeListener() {
        if (this._listener == null) {
            this._listener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ValidatingController.this.doValidate();
                }
            };
        }
        return this._listener;
    }

    public Component getComponent() {
        return this.component();
    }

    protected TComponent component() {
        if (this._component == null) {
            this._component = this.createComponent();
            if (this._component instanceof JComponent) {
                JComponent jComponent = (JComponent)this._component;
                for (String string : this.getClientProperties()) {
                    if (CLIENT_PROP_NAME.equals(string)) {
                        jComponent.setName((String)this.getClientProperty(string));
                        continue;
                    }
                    jComponent.putClientProperty(string, this.getClientProperty(string));
                }
            }
        }
        return this._component;
    }

    protected abstract TComponent createComponent();

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        return this._valid;
    }

    protected void setValid(boolean bl) {
        if (bl != this._valid) {
            this._valid = bl;
            this.fireValidChanged();
        }
    }

    private final void fireValidChanged() {
        this._changeSupport.fireChange();
    }

    protected void doValidate() {
        String string = this.getFirstError(this.component());
        this.info(string);
        this.setValid(string == null);
    }

    protected String getFirstError(TComponent TComponent) {
        return null;
    }

    protected void error(String string) {
        this._descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        this.fireValidChanged();
    }

    protected void info(String string) {
        this._descriptor.putProperty("WizardPanel_infoMessage", (Object)string);
    }

    protected void warn(String string) {
        this._descriptor.putProperty("WizardPanel_warningMessage", (Object)string);
    }

    public void readSettings(Object object) {
        WizardDescriptor wizardDescriptor;
        this._descriptor = wizardDescriptor = (WizardDescriptor)object;
        this.readSettings(wizardDescriptor);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ValidatingController.this.doValidate();
            }
        });
    }

    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        this.storeSettings(wizardDescriptor);
    }

    public void putClientProperty(String string, Object object) {
        if (this._clientProperties == null) {
            this._clientProperties = new HashMap<String, Object>();
        }
        this._clientProperties.put(string, object);
    }

    public Object getClientProperty(String string) {
        if (this._clientProperties == null) {
            return null;
        }
        return this._clientProperties.get(string);
    }

    protected Set<String> getClientProperties() {
        if (this._clientProperties == null) {
            return Collections.emptySet();
        }
        return this._clientProperties.keySet();
    }

    public void setName(String string) {
        this.putClientProperty(CLIENT_PROP_NAME, string);
    }

    public String getName() {
        return (String)this.getClientProperty(CLIENT_PROP_NAME);
    }

    protected abstract void readSettings(WizardDescriptor var1);

    protected abstract void storeSettings(WizardDescriptor var1);

    protected void fireNavigationChanged() {
        ChangeSupport changeSupport = (ChangeSupport)this._clientProperties.get("maltego.navigation.changesupport");
        if (changeSupport != null) {
            changeSupport.fireChange();
        }
    }
}

