/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.table;

import com.paterva.maltego.util.ListMap;
import com.paterva.maltego.util.ui.table.ModelDecorator;
import com.paterva.maltego.util.ui.table.TableButtonCallback;
import com.paterva.maltego.util.ui.table.TableButtonEvent;
import com.paterva.maltego.util.ui.table.TableButtonListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class TableButtonCellEditor
extends DefaultCellEditor
implements TableCellRenderer {
    private boolean _isPushed;
    private TableButtonListener _buttonListener;
    private JTable _editingTable;
    private int _editingRow;
    private ActionEvent _editingEvent;
    private String _editingValue;
    private Map<String, ButtonPair> _editButtons = new ListMap();
    private Map<String, ButtonPair> _renderButtons = new ListMap();

    public TableButtonCellEditor() {
        this(null, new JButton[0]);
    }

    public TableButtonCellEditor(TableButtonListener tableButtonListener, JButton[] jButtonArray) {
        this(tableButtonListener, jButtonArray, new boolean[jButtonArray.length]);
    }

    public TableButtonCellEditor(TableButtonListener tableButtonListener, JButton[] jButtonArray, boolean[] blArray) {
        this(tableButtonListener, jButtonArray, blArray, new TableButtonCallback[jButtonArray.length]);
    }

    public TableButtonCellEditor(TableButtonListener tableButtonListener, JButton[] jButtonArray, boolean[] blArray, TableButtonCallback[] tableButtonCallbackArray) {
        super(new JCheckBox());
        this._buttonListener = tableButtonListener;
        if (jButtonArray.length != blArray.length) {
            throw new IllegalArgumentException("buttons and multiSelect arrays must be of equal length");
        }
        for (int i = 0; i < jButtonArray.length; ++i) {
            this.addButton(jButtonArray[i], blArray[i], tableButtonCallbackArray[i]);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        ModelDecorator.ActionDecorator actionDecorator = (ModelDecorator.ActionDecorator)object;
        this._editingValue = actionDecorator.getCommand();
        ButtonPair buttonPair = this._editButtons.get(this._editingValue);
        if (buttonPair == null) {
            throw new NullPointerException("No button registered to handle action " + this._editingValue);
        }
        JButton jButton = buttonPair.getButton();
        jButton.setEnabled(buttonPair.getCallback().isButtonEnabled(jTable, this._editingValue, n));
        if (bl) {
            jButton.setForeground(jTable.getSelectionForeground());
            jButton.setBackground(jTable.getSelectionBackground());
        } else {
            jButton.setForeground(jTable.getForeground());
            jButton.setBackground(jTable.getBackground());
        }
        this._isPushed = jButton.isEnabled();
        this._editingTable = jTable;
        this._editingRow = n;
        return jButton;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        if (this._editingTable.isRowSelected(this._editingRow)) {
            return !this.allowMultiSelect(this._editingValue);
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        if (this._isPushed && this._buttonListener != null) {
            this._buttonListener.actionPerformed(new TableButtonEvent((Object)this._editingTable, this._editingEvent.getID(), this._editingEvent.getActionCommand(), this._editingTable.getSelectedRows()));
        }
        this._isPushed = false;
        return null;
    }

    @Override
    public boolean stopCellEditing() {
        this._isPushed = false;
        this._editingTable = null;
        this._editingRow = -1;
        this._editingValue = null;
        this._editingEvent = null;
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        ModelDecorator.ActionDecorator actionDecorator = (ModelDecorator.ActionDecorator)object;
        ButtonPair buttonPair = this._renderButtons.get(actionDecorator.getCommand());
        if (buttonPair == null) {
            throw new NullPointerException("No button registered to handle action " + actionDecorator.getCommand());
        }
        JButton jButton = buttonPair.getButton();
        jButton.setEnabled(buttonPair.getCallback().isButtonEnabled(jTable, actionDecorator.getCommand(), n));
        if (bl) {
            jButton.setForeground(jTable.getSelectionForeground());
            jButton.setBackground(jTable.getSelectionBackground());
        } else {
            jButton.setForeground(jTable.getForeground());
            jButton.setBackground(jTable.getBackground());
        }
        jButton.setBorderPainted(false);
        return jButton;
    }

    public TableButtonListener getButtonListener() {
        return this._buttonListener;
    }

    public void setButtonListener(TableButtonListener tableButtonListener) {
        this._buttonListener = tableButtonListener;
    }

    private boolean allowMultiSelect(String string) {
        ButtonPair buttonPair = this._editButtons.get(string);
        if (buttonPair == null) {
            throw new NullPointerException("No button registered to handle action " + string);
        }
        return buttonPair.isMultiSelect();
    }

    public void addButton(JButton jButton, boolean bl) {
        this.addButton(jButton, bl);
    }

    public void addButton(JButton jButton, boolean bl, TableButtonCallback tableButtonCallback) {
        JButton jButton2 = this.copyButton(jButton);
        this._editButtons.put(jButton.getActionCommand(), new ButtonPair(jButton2, bl, tableButtonCallback));
        jButton2.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                TableButtonCellEditor.this.stopCellEditing();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableButtonCellEditor.this._editingEvent = actionEvent;
                TableButtonCellEditor.this.fireEditingStopped();
            }
        });
        this._renderButtons.put(jButton.getActionCommand(), new ButtonPair(this.copyButton(jButton), bl, tableButtonCallback));
    }

    public void removeButton(JButton jButton) {
        this._editButtons.remove(jButton.getActionCommand());
    }

    private JButton copyButton(JButton jButton) {
        JButton jButton2 = new JButton();
        jButton2.setText(jButton.getText());
        jButton2.setBorder(jButton.getBorder());
        jButton2.setIcon(jButton.getIcon());
        jButton2.setForeground(jButton.getForeground());
        jButton2.setFont(jButton.getFont());
        jButton2.setBackground(jButton.getBackground());
        jButton2.setActionCommand(jButton.getActionCommand());
        jButton2.setDisabledIcon(jButton.getDisabledIcon());
        jButton2.setMargin(jButton.getMargin());
        jButton2.setBorderPainted(jButton.isBorderPainted());
        jButton2.setOpaque(jButton2.isOpaque());
        jButton2.setContentAreaFilled(jButton.isContentAreaFilled());
        return jButton2;
    }

    private static class ButtonPair {
        private boolean _multiSelect;
        private JButton _button;
        private TableButtonCallback _callback;
        private static final TableButtonCallback defaultCallback = new TableButtonCallback(){

            @Override
            public boolean isButtonEnabled(JTable jTable, String string, int n) {
                return true;
            }
        };

        public ButtonPair(JButton jButton, boolean bl, TableButtonCallback tableButtonCallback) {
            this._button = jButton;
            this._multiSelect = bl;
            this._callback = tableButtonCallback;
            if (this._callback == null) {
                this._callback = defaultCallback;
            }
        }

        public boolean isMultiSelect() {
            return this._multiSelect;
        }

        public void setMultiSelect(boolean bl) {
            this._multiSelect = bl;
        }

        public JButton getButton() {
            return this._button;
        }

        public void setButton(JButton jButton) {
            this._button = jButton;
        }

        public TableButtonCallback getCallback() {
            return this._callback;
        }

        public void setCallback(TableButtonCallback tableButtonCallback) {
            this._callback = tableButtonCallback;
        }
    }
}

