/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.utils;

import java.io.File;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockUtils;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public final class FileInfo {
    private static final FileSystemView FILESYSTEMVIEW = FileSystemView.getFileSystemView();
    private static boolean IS_WINDOWS = Utilities.isWindows();
    private int isFile = -1;
    private int isDirectory = -1;
    private int exists = -1;
    private int isComputeNode = -1;
    private int isUnixSpecialFile = -1;
    private int isUNC = -1;
    private int isConvertibleToFileObject = -1;
    private Integer id = null;
    private FileInfo root = null;
    private final File file;
    private FileInfo parent = null;
    private FileNaming fileNaming = null;
    private FileObject fObject = null;

    public FileInfo(File file, int exists) {
        this.file = file;
        this.exists = exists;
    }

    public FileInfo(File file) {
        this.file = file;
    }

    public FileInfo(FileInfo parent, File file) {
        this(file);
        this.parent = parent;
    }

    public boolean isFile() {
        if (this.isFile == -1) {
            this.isFile = this.getFile().isFile() ? 1 : 0;
        }
        return this.isFile != 0;
    }

    public boolean isDirectory() {
        if (this.isDirectory == -1) {
            this.isDirectory = this.getFile().isDirectory() ? 1 : 0;
        }
        return this.isDirectory != 0;
    }

    public boolean exists() {
        if (this.exists == -1) {
            this.exists = FileChangedManager.getInstance().exists(this.getFile()) ? 1 : 0;
        }
        return this.exists != 0;
    }

    public boolean isComputeNode() {
        if (this.isComputeNode == -1) {
            this.isComputeNode = FILESYSTEMVIEW.isComputerNode(this.getFile()) ? 1 : 0;
        }
        return this.isComputeNode == 1;
    }

    public boolean isUnixSpecialFile() {
        if (this.isUnixSpecialFile == -1) {
            this.isUnixSpecialFile = !IS_WINDOWS && !this.isDirectory() && !this.isFile() && this.exists() ? 1 : 0;
        }
        return this.isUnixSpecialFile == 1;
    }

    public boolean isUNCFolder() {
        if (this.isUNC == -1) {
            this.isUNC = this.isWindows() && !this.isFile() && !this.isDirectory() && !this.exists() && this.isComputeNode() ? 1 : 0;
        }
        return this.isUNC == 1;
    }

    public boolean isWindows() {
        return IS_WINDOWS;
    }

    public boolean isConvertibleToFileObject() {
        if (this.isConvertibleToFileObject == -1) {
            this.isConvertibleToFileObject = this.isSupportedFile() && this.exists() ? 1 : 0;
        }
        return this.isConvertibleToFileObject == 1;
    }

    public boolean isSupportedFile() {
        return !this.getFile().getName().equals(".nbattrs") && !WriteLockUtils.hasActiveLockFileSigns(this.getFile().getName());
    }

    public FileInfo getRoot() {
        if (this.root == null) {
            String filename;
            int firstSlash;
            File tmp;
            File retVal = tmp = this.getFile();
            while (tmp != null) {
                retVal = tmp;
                tmp = tmp.getParentFile();
            }
            if ("\\\\".equals(retVal.getPath()) && (firstSlash = (filename = this.getFile().getAbsolutePath()).indexOf("\\", 2)) != -1) {
                int secondSlash = filename.indexOf("\\", firstSlash + 1);
                if (secondSlash != -1) {
                    filename = filename.substring(0, secondSlash);
                }
                retVal = new File(filename);
            }
            this.root = new FileInfo(retVal);
        }
        return this.root;
    }

    public File getFile() {
        return this.file;
    }

    public Integer getID() {
        if (this.id == null) {
            this.id = NamingFactory.createID(this.getFile());
        }
        return this.id;
    }

    public FileInfo getParent() {
        return this.parent;
    }

    public FileNaming getFileNaming() {
        return this.fileNaming;
    }

    public void setFileNaming(FileNaming fileNaming) {
        this.fileNaming = fileNaming;
    }

    public FileObject getFObject() {
        return this.fObject;
    }

    public void setFObject(FileObject fObject) {
        this.fObject = fObject;
    }

    public String toString() {
        return this.getFile().toString();
    }

    public static final String composeName(String name, String ext) {
        return ext != null && ext.length() > 0 ? name + "." + ext : name;
    }

    public static final String getName(String name) {
        int i = name.lastIndexOf(46);
        return i <= 0 || i == name.length() - 1 ? name : name.substring(0, i);
    }

    public static final String getExt(String name) {
        int i = name.lastIndexOf(46) + 1;
        return i <= 1 || i == name.length() ? "" : name.substring(i);
    }
}

