/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.FileEntry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveOutputStream;
import com.paterva.maltego.util.FileUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;

public class MaltegoArchiveWriter {
    private MaltegoArchiveOutputStream _stream;
    private ZipFile _zipFile;
    private ZipParameters _params;

    public MaltegoArchiveWriter(OutputStream outputStream) throws IOException {
        this._stream = new MaltegoArchiveOutputStream(outputStream);
    }

    public MaltegoArchiveWriter(ZipFile zipFile, ZipParameters zipParameters) throws IOException {
        this._zipFile = zipFile;
        this._params = zipParameters;
    }

    public <T> void write(Entry<T> entry) throws IOException {
        if (this._stream != null) {
            this.writeNormal(entry);
        } else {
            this.writeEncrypted(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void writeNormal(Entry<T> entry) throws IOException {
        try {
            this._stream.addEntry(entry);
            entry.write(entry.getData(), this._stream);
        }
        finally {
            this._stream.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void writeEncrypted(Entry<T> entry) throws IOException {
        Object object;
        File file = null;
        boolean bl = false;
        if (entry instanceof FileEntry) {
            object = (FileEntry)entry;
            file = ((FileEntry)object).getFile();
        } else {
            object = FileUtilities.createTempDir((String)"Zip");
            FileUtilities.deleteContents((File)new File((String)object));
            file = new File((String)object + entry.getTypeName() + "." + entry.getType());
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                entry.write(entry.getData(), fileOutputStream);
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            bl = true;
        }
        this._params.setRootFolderInZip(entry.getFolder());
        try {
            this._zipFile.addFile(file, this._params);
        }
        catch (ZipException zipException) {
            throw new IOException(zipException);
        }
        finally {
            if (bl && file != null) {
                file.delete();
            }
        }
    }

    public void close() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
    }
}

