/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz.graph;

import com.paterva.maltego.archive.mtz.graph.IOHelper;
import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.GenericEntity;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.InternalFile;
import com.paterva.maltego.typing.types.TimeSpan;
import com.paterva.maltego.util.FastURL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openide.util.Exceptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import yguard.A.H.B.A.H;
import yguard.A.H.B.B.Z;

class MaltegoEntityIO {
    MaltegoEntityIO() {
    }

    public MaltegoEntity read(Node node, EntityFactory entityFactory) throws Z {
        String string = IOHelper.getRequiredAttribute(node, "type");
        try {
            Element element;
            Element element2;
            Element element3;
            Element element4;
            Element element5;
            Element element6;
            MaltegoEntity maltegoEntity = (MaltegoEntity)entityFactory.createInstance(string, false);
            Map<Integer, Attachment> map = null;
            Element element7 = IOHelper.findElement(node, "MaltegoEntityList");
            if (element7 != null) {
                map = this.attachEntities(maltegoEntity, element7, entityFactory);
            }
            if ((element6 = IOHelper.findElement(node, "AttachmentProperties")) != null) {
                this.attachProperties(maltegoEntity, element6, null);
            }
            if ((element5 = IOHelper.findElement(node, "Properties2")) != null) {
                this.attachProperties(maltegoEntity, element5, null);
            }
            if ((element4 = IOHelper.findElement(node, "Properties")) != null) {
                this.attachProperties(maltegoEntity, element4, map);
            }
            if ((element3 = IOHelper.findElement(node, "DisplayInformation")) != null) {
                this.attachDisplayInformation(maltegoEntity, element3);
            }
            if ((element2 = IOHelper.findElement(node, "Weight")) != null) {
                this.attachWeight(maltegoEntity, element2);
            } else {
                maltegoEntity.setWeight(0);
            }
            Element element8 = IOHelper.findElement(node, "Notes");
            if (element8 != null) {
                this.attachNotes(maltegoEntity, element8);
            }
            if ((element = IOHelper.findElement(node, "Bookmarks")) != null) {
                this.attachBookmarks(maltegoEntity, element);
            }
            return maltegoEntity;
        }
        catch (TypeInstantiationException typeInstantiationException) {
            throw new Z("Could not instantiate entity of type " + string, (Throwable)typeInstantiationException);
        }
    }

    private Map<Integer, Attachment> attachEntities(MaltegoEntity maltegoEntity, Element element, EntityFactory entityFactory) throws Z {
        HashMap<Integer, Attachment> hashMap = new HashMap<Integer, Attachment>();
        Attachments attachments = new Attachments();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"MaltegoEntity".equals(node.getLocalName())) continue;
            MaltegoEntity maltegoEntity2 = this.read(node, entityFactory);
            PropertyDescriptorCollection propertyDescriptorCollection = maltegoEntity2.getProperties();
            PropertyDescriptor propertyDescriptor = propertyDescriptorCollection.get("source");
            FastURL fastURL = (FastURL)maltegoEntity2.getValue(propertyDescriptor);
            PropertyDescriptor propertyDescriptor2 = propertyDescriptorCollection.get("file");
            InternalFile internalFile = (InternalFile)maltegoEntity2.getValue(propertyDescriptor2);
            if (internalFile != null) {
                Attachment attachment = new Attachment(internalFile.fileStoreIndex, fastURL);
                attachments.add((Object)attachment);
                hashMap.put(n, attachment);
            }
            ++n;
        }
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(Attachments.class, "attachments_internal", "Attachments");
        maltegoEntity.setValue(propertyDescriptor, (Object)attachments);
        return hashMap;
    }

    private void attachWeight(MaltegoEntity maltegoEntity, Element element) {
        try {
            maltegoEntity.setWeight(Integer.valueOf(element.getTextContent()).intValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void attachDisplayInformation(MaltegoEntity maltegoEntity, Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"DisplayElement".equals(node.getLocalName()) || (string = IOHelper.findCData(node)) == null) continue;
            DisplayInformationCollection displayInformationCollection = maltegoEntity.getDisplayInformation();
            displayInformationCollection.add(IOHelper.getOptionalAttribute(node, "name", ""), string);
            maltegoEntity.setDisplayInformation(displayInformationCollection);
        }
    }

    private void attachProperties(MaltegoEntity maltegoEntity, Node node, Map<Integer, Attachment> map) throws Z {
        Object object;
        String string;
        String string2;
        Object object2;
        Object object3;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object3 = nodeList.item(i);
            if (object3.getNodeType() != 1 || !"Property".equals(object3.getLocalName())) continue;
            object2 = IOHelper.getRequiredAttribute((Node)object3, "name");
            if (!maltegoEntity.getProperties().contains((String)object2)) {
                this.attachProperty(maltegoEntity, (Node)object3);
            }
            string2 = IOHelper.getValue((Node)object3);
            string = maltegoEntity.getProperties().get((String)object2);
            if (this.isDependentSet((PropertyDescriptor)string, maltegoEntity)) continue;
            try {
                object = Converter.convertFrom((String)string2, (Class)string.getType());
                maltegoEntity.setValue((PropertyDescriptor)string, object);
                continue;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                TypeDescriptor typeDescriptor = TypeRegistry.getDefault().getType(string.getType());
                if (typeDescriptor == null) continue;
                maltegoEntity.setValue((PropertyDescriptor)string, typeDescriptor.getDefaultValue());
            }
        }
        String string3 = IOHelper.getStringAttribute(node, "value");
        if (string3 != null) {
            object3 = maltegoEntity.getProperties().get(string3);
            maltegoEntity.setValueProperty((PropertyDescriptor)object3);
        }
        if ((object3 = IOHelper.getStringAttribute(node, "displayValue")) != null) {
            object2 = maltegoEntity.getProperties().get((String)object3);
            maltegoEntity.setDisplayValueProperty((PropertyDescriptor)object2);
        }
        object2 = null;
        string2 = IOHelper.getStringAttribute(node, "image");
        if (string2 != null) {
            string = "MaltegoEntityList#";
            if (string2.startsWith(string)) {
                if (map != null) {
                    try {
                        object2 = Integer.parseInt(string2.substring(string.length()));
                        object = map.get(object2);
                        this.setAsEntityImage((Attachment)object, maltegoEntity);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                maltegoEntity.setImageProperty(maltegoEntity.getProperties().get(string2));
            }
        }
    }

    private void setAsEntityImage(Attachment attachment, MaltegoEntity maltegoEntity) {
        if (attachment != null) {
            PropertyDescriptorCollection propertyDescriptorCollection = maltegoEntity.getProperties();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorCollection) {
                Attachments attachments;
                if (!Attachments.class.equals((Object)propertyDescriptor.getType()) || !(attachments = (Attachments)maltegoEntity.getValue(propertyDescriptor)).contains((Object)attachment)) continue;
                attachments.setPrimaryImage(attachment);
                maltegoEntity.setImageProperty(propertyDescriptor);
                break;
            }
        }
    }

    private boolean isDependentSet(PropertyDescriptor propertyDescriptor, MaltegoEntity maltegoEntity) {
        if (propertyDescriptor instanceof DisplayDescriptor) {
            DisplayDescriptor displayDescriptor = (DisplayDescriptor)propertyDescriptor;
            List list = displayDescriptor.getLinkedProperties();
            for (PropertyDescriptor propertyDescriptor2 : list) {
                propertyDescriptor2 = maltegoEntity.getProperties().get(propertyDescriptor2.getName());
                Object object = maltegoEntity.getValue(propertyDescriptor2);
                if (object == null || object.equals(TypeRegistry.getDefault().getType(propertyDescriptor2.getType()).getDefaultValue())) continue;
                return true;
            }
        }
        return false;
    }

    private void attachProperty(MaltegoEntity maltegoEntity, Node node) throws Z {
        String string = IOHelper.getRequiredAttribute(node, "name");
        String string2 = IOHelper.getRequiredAttribute(node, "type");
        TypeDescriptor typeDescriptor = TypeRegistry.getDefault().getType(string2);
        if (typeDescriptor != null) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(typeDescriptor.getType(), string, IOHelper.getStringAttribute(node, "displayName"));
            propertyDescriptor.setHidden(IOHelper.getBooleanAttribute(node, "hidden", false));
            propertyDescriptor.setNullable(IOHelper.getBooleanAttribute(node, "nullable", true));
            propertyDescriptor.setReadonly(IOHelper.getBooleanAttribute(node, "readonly", false));
            maltegoEntity.getProperties().add(propertyDescriptor);
        } else {
            System.out.println("Unknown type in loaded graph: " + string2);
        }
    }

    private void attachNotes(MaltegoEntity maltegoEntity, Element element) {
        String string = IOHelper.findCData(element);
        maltegoEntity.setNotes(string);
        String string2 = IOHelper.getOptionalAttribute(element, "show", "false");
        maltegoEntity.setShowNotes("true".equals(string2));
    }

    private void attachBookmarks(MaltegoEntity maltegoEntity, Element element) {
        try {
            maltegoEntity.setBookmark(Integer.valueOf(element.getTextContent()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void write(H h, MaltegoEntity maltegoEntity) {
        AttachmentEntities attachmentEntities = this.translateAttachments(maltegoEntity);
        h.writeStartElement("mtg", "MaltegoEntity", "http://maltego.paterva.com/xml/mtgx");
        h.writeAttribute("type", maltegoEntity.getTypeName());
        this.writeProperties(h, maltegoEntity, attachmentEntities.imgIndex);
        this.writeProperties2(h, maltegoEntity);
        this.writeDisplayInformation(h, maltegoEntity.getDisplayInformation());
        this.writeWeight(h, maltegoEntity.getWeight());
        this.writeNotes(h, maltegoEntity.getNotes(), maltegoEntity.isShowNotes());
        this.writeBookmarks(h, maltegoEntity.getBookmark());
        this.writeContainedEntities(h, maltegoEntity, attachmentEntities.entities);
        h.writeEndElement();
    }

    private void writeWeight(H h, int n) {
        if (n != 0) {
            h.writeStartElement("mtg", "Weight", "http://maltego.paterva.com/xml/mtgx");
            h.writeText(String.valueOf(n));
            h.writeEndElement();
        }
    }

    private void writeDisplayInformation(H h, DisplayInformationCollection displayInformationCollection) {
        if (displayInformationCollection != null && !displayInformationCollection.isEmpty()) {
            h.writeStartElement("mtg", "DisplayInformation", "http://maltego.paterva.com/xml/mtgx");
            for (DisplayInformation displayInformation : displayInformationCollection) {
                h.writeStartElement("mtg", "DisplayElement", "http://maltego.paterva.com/xml/mtgx");
                h.writeAttribute("name", displayInformation.getName());
                h.writeCData(displayInformation.getValue());
                h.writeEndElement();
            }
            h.writeEndElement();
        }
    }

    private void writeProperties(H h, MaltegoEntity maltegoEntity, Integer n) {
        h.writeStartElement("mtg", "Properties", "http://maltego.paterva.com/xml/mtgx");
        this.writePropertyName(h, "value", maltegoEntity.getValueProperty());
        this.writePropertyName(h, "displayValue", maltegoEntity.getDisplayValueProperty());
        if (n == null) {
            this.writePropertyName(h, "image", maltegoEntity.getImageProperty());
        } else {
            h.writeAttribute("image", "MaltegoEntityList#" + n);
        }
        for (PropertyDescriptor propertyDescriptor : maltegoEntity.getProperties()) {
            if (this.isProperties2Property(propertyDescriptor) || Attachments.class.equals((Object)propertyDescriptor.getType())) continue;
            IOHelper.writeProperty(h, (MaltegoPart)maltegoEntity, propertyDescriptor);
        }
        h.writeEndElement();
    }

    private boolean isProperties2Property(PropertyDescriptor propertyDescriptor) {
        return DateTime.class.equals((Object)propertyDescriptor.getType()) || TimeSpan.class.equals((Object)propertyDescriptor.getType()) || InternalFile.class.equals((Object)propertyDescriptor.getType());
    }

    private void writeProperties2(H h, MaltegoEntity maltegoEntity) {
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor propertyDescriptor : maltegoEntity.getProperties()) {
            if (!this.isProperties2Property(propertyDescriptor) || Attachments.class.equals((Object)propertyDescriptor.getType())) continue;
            arrayList.add(propertyDescriptor);
        }
        if (!arrayList.isEmpty()) {
            h.writeStartElement("mtg", "Properties2", "http://maltego.paterva.com/xml/mtgx");
            for (PropertyDescriptor propertyDescriptor : arrayList) {
                IOHelper.writeProperty(h, (MaltegoPart)maltegoEntity, propertyDescriptor);
            }
            h.writeEndElement();
        }
    }

    private void writePropertyName(H h, String string, PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor != null) {
            h.writeAttribute(string, propertyDescriptor.getName());
        }
    }

    private void writeNotes(H h, String string, boolean bl) {
        if (string != null && !string.isEmpty()) {
            h.writeStartElement("mtg", "Notes", "http://maltego.paterva.com/xml/mtgx");
            if (bl) {
                h.writeAttribute("show", bl);
            }
            h.writeCData(string);
            h.writeEndElement();
        }
    }

    private void writeBookmarks(H h, Integer n) {
        if (n != null) {
            h.writeStartElement("mtg", "Bookmarks", "http://maltego.paterva.com/xml/mtgx");
            h.writeText(n.toString());
            h.writeEndElement();
        }
    }

    private void writeContainedEntities(H h, MaltegoEntity maltegoEntity, List<MaltegoEntity> list) {
        if (!list.isEmpty()) {
            h.writeStartElement("mtg", "MaltegoEntityList", "http://maltego.paterva.com/xml/mtgx");
            for (MaltegoEntity maltegoEntity2 : list) {
                this.write(h, maltegoEntity2);
            }
            h.writeEndElement();
        }
    }

    private AttachmentEntities translateAttachments(MaltegoEntity maltegoEntity) {
        Attachment attachment;
        PropertyDescriptor propertyDescriptor = maltegoEntity.getImageProperty();
        Attachment attachment2 = null;
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>();
        for (PropertyDescriptor propertyDescriptor2 : maltegoEntity.getProperties()) {
            if (!Attachments.class.equals((Object)propertyDescriptor2.getType())) continue;
            Attachments attachments = (Attachments)maltegoEntity.getValue(propertyDescriptor2);
            if (attachments != null) {
                Iterator iterator = attachments.iterator();
                while (iterator.hasNext()) {
                    attachment = (Attachment)iterator.next();
                    arrayList.add(attachment);
                }
            }
            if (propertyDescriptor == null || !propertyDescriptor.equals(propertyDescriptor2)) continue;
            attachment2 = attachments.getPrimaryImage();
        }
        AttachmentEntities attachmentEntities = new AttachmentEntities();
        attachmentEntities.entities = new ArrayList<MaltegoEntity>();
        int n = 0;
        for (Attachment attachment3 : arrayList) {
            attachment = new GenericEntity("maltego.File");
            PropertyDescriptor propertyDescriptor2 = new PropertyDescriptor(FastURL.class, "source", "Source");
            attachment.setValue(propertyDescriptor2, (Object)attachment3.getSource());
            PropertyDescriptor propertyDescriptor3 = new PropertyDescriptor(InternalFile.class, "file", "File");
            attachment.setValue(propertyDescriptor3, (Object)new InternalFile(attachment3.getId()));
            attachment.setImageProperty(propertyDescriptor3);
            attachmentEntities.entities.add((MaltegoEntity)attachment);
            if (attachment3.equals((Object)attachment2)) {
                attachmentEntities.imgIndex = n;
            }
            ++n;
        }
        return attachmentEntities;
    }

    private static class AttachmentEntities {
        public List<MaltegoEntity> entities;
        public Integer imgIndex;

        private AttachmentEntities() {
        }
    }
}

