/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.cdma;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class MEIDCondition {
    private static final String ORG_OSGI_UTIL_CDMA_MEID = "org.osgi.util.cdma.meid";
    private static final String MEID = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            String meid = System.getProperty(MEIDCondition.ORG_OSGI_UTIL_CDMA_MEID);
            if (meid == null) {
                return null;
            }
            return meid.toUpperCase();
        }
    });
    private static final int MEID_LENGTH = 14;

    private MEIDCondition() {
    }

    public static Condition getCondition(Bundle bundle, ConditionInfo conditionInfo) {
        String meid = conditionInfo.getArgs()[0].toUpperCase();
        int length = meid.length();
        if (length > 14) {
            throw new IllegalArgumentException("MEID too long: " + meid);
        }
        if (meid.endsWith("*")) {
            meid = meid.substring(0, --length);
        } else if (length < 14) {
            throw new IllegalArgumentException("MEID too short: " + meid);
        }
        for (int i = 0; i < length; ++i) {
            char c = meid.charAt(i);
            if ('0' <= c && c <= '9' || 'A' <= c && c <= 'F') continue;
            throw new IllegalArgumentException("not a valid MEID: " + meid);
        }
        if (MEID == null) {
            System.err.println("The OSGi implementation of org.osgi.util.cdma.MEIDCondition needs the system property org.osgi.util.cdma.meid set.");
            return Condition.FALSE;
        }
        return MEID.startsWith(meid) ? Condition.TRUE : Condition.FALSE;
    }
}

