/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LicenseApprovalPanel
extends JPanel {
    public static final String LICENSE_APPROVED = "license-approved";
    private Map<String, Set<String>> license4plugins;
    private JCheckBox cbAccept;
    private JScrollPane spLicenses;
    private JTextArea taLicenses;
    private JTextArea taTitle;

    public LicenseApprovalPanel(InstallUnitWizardModel model, boolean isApproved) {
        this.initComponents();
        this.cbAccept.setSelected(isApproved);
        if (model != null) {
            this.writeLicenses(model);
        } else {
            this.cbAccept.setEnabled(false);
            this.taLicenses.setEnabled(false);
        }
    }

    Collection<String> getLicenses() {
        assert (this.license4plugins != null) : "Licenses must found.";
        if (this.license4plugins == null && this.license4plugins.isEmpty()) {
            return Collections.emptyList();
        }
        return this.license4plugins.keySet();
    }

    private void goOverLicenses(InstallUnitWizardModel model) {
        for (UpdateElement el : model.getAllUpdateElements()) {
            if (el.getLicence() == null) continue;
            if (this.license4plugins == null) {
                this.license4plugins = new HashMap<String, Set<String>>();
            }
            if (this.license4plugins.containsKey(el.getLicence())) {
                this.license4plugins.get(el.getLicence()).add(el.getDisplayName());
                continue;
            }
            HashSet<String> plugins = new HashSet<String>();
            plugins.add(el.getDisplayName());
            this.license4plugins.put(el.getLicence(), plugins);
        }
    }

    public boolean isApproved() {
        return this.cbAccept.isSelected();
    }

    private void initComponents() {
        this.taTitle = new JTextArea();
        this.spLicenses = new JScrollPane();
        this.taLicenses = new JTextArea();
        this.cbAccept = new JCheckBox();
        this.taTitle.setEditable(false);
        this.taTitle.setLineWrap(true);
        this.taTitle.setText(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taTitle_Text"));
        this.taTitle.setWrapStyleWord(true);
        this.taTitle.setMargin(new Insets(0, 4, 0, 0));
        this.taTitle.setOpaque(false);
        this.taLicenses.setColumns(20);
        this.taLicenses.setEditable(false);
        this.taLicenses.setLineWrap(true);
        this.taLicenses.setRows(5);
        this.taLicenses.setWrapStyleWord(true);
        this.taLicenses.setMargin(new Insets(0, 4, 0, 4));
        this.spLicenses.setViewportView(this.taLicenses);
        this.taLicenses.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taLicenses_ACN"));
        this.taLicenses.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taLicenses_ACD"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAccept, (String)NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel.cbAccept.text"));
        this.cbAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseApprovalPanel.this.cbAcceptActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbAccept).addComponent(this.taTitle, GroupLayout.Alignment.TRAILING, -1, 461, Short.MAX_VALUE).addComponent(this.spLicenses, -1, 461, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.taTitle, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spLicenses).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAccept).addContainerGap()));
        this.cbAccept.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_cbAccept_ACN"));
    }

    private void cbAcceptActionPerformed(ActionEvent evt) {
        this.firePropertyChange(LICENSE_APPROVED, null, (Object)this.cbAccept.isSelected());
    }

    private void writeLicenses(InstallUnitWizardModel model) {
        this.goOverLicenses(model);
        StringBuffer content = new StringBuffer();
        for (String lic : this.license4plugins.keySet()) {
            StringBuffer title = new StringBuffer();
            for (String plugin : this.license4plugins.get(lic)) {
                title.append((title.length() == 0 ? "" : NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_tpLicense_Delimeter")) + plugin);
            }
            content.append(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_tpLicense_Head", (Object)title));
            content.append("\n");
            content.append(lic);
            content.append(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_tpLicense_Separator"));
        }
        this.taLicenses.setText(content.toString());
        this.taLicenses.setCaretPosition(0);
    }
}

