/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabControlButton;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.officelaf.DoubleArrowIcon;
import org.openide.awt.HtmlRenderer;

public class OfficeViewTabDisplayerUIOld
extends AbstractViewTabDisplayerUI {
    private static final int MAIN_ICON_PAD = 4;
    private static final int TXT_X_PAD = 4;
    private static final int TXT_Y_PAD = 3;
    private static final int ICON_X_PAD = 2;
    private static final int HIGHLIGHTED_RAISE = 1;
    private static Map<Integer, String[]> buttonIconPaths;
    private static Color inactBgColor;
    private static Color actBgColor;
    public static final Color GRAY_76;
    public static final Color BORDER_COLOR;
    public static final Color BORDER_FOCUSED_COLOR;
    public static final Color BORDER_HIGHLIGHT_COLOR;
    public static final Color BG1_FOCUSED_COLOR;
    public static final Color BG2_FOCUSED_COLOR;
    public static final Color BG3_FOCUSED_COLOR;
    public static final Color BG4_FOCUSED_COLOR;
    public static final Color BG1_COLOR;
    public static final Color BG2_COLOR;
    public static final Color BG3_COLOR;
    public static final Color BG4_COLOR;
    private Dimension prefSize = new Dimension(100, 17);
    private Font font;
    private TabControlButton hidePin;
    protected JPanel buttonsPanel;

    private OfficeViewTabDisplayerUIOld(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new OfficeViewTabDisplayerUIOld((TabDisplayer)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        OfficeViewTabDisplayerUIOld.initIcons();
        jComponent.setOpaque(false);
        this.getControlButtons();
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (this.buttonsPanel != null) {
            this.displayer.remove((Component)this.buttonsPanel);
            this.buttonsPanel = null;
        }
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 17 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 3;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top + 2;
        return this.prefSize;
    }

    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        Serializable serializable;
        Serializable serializable2;
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        if (!this.isTabInFront(n) && this.isMoreThanOne()) {
            ++n3;
            --n5;
        }
        Icon icon = this.getDataModel().getTab(n).getIcon();
        boolean bl = false;
        if (icon != null && icon.getIconWidth() <= 16 && icon.getIconHeight() <= 16) {
            bl = true;
        }
        int n6 = n4;
        int n7 = 8 + (bl ? icon.getIconWidth() + 4 : 0);
        if (this.isSelected(n)) {
            serializable2 = this.getControlButtons();
            if (null != serializable2) {
                serializable = ((Component)serializable2).getPreferredSize();
                n6 = n4 - (serializable.width + 2 + n7);
                ((Component)serializable2).setLocation(n2 + n6 + n7, n3 + (n5 - serializable.height) / 2);
            }
        } else {
            n6 = n4 - n7;
        }
        serializable2 = this.getTxtFont();
        Serializable serializable3 = serializable = this.isDimmed(n) ? Color.WHITE : Color.BLACK;
        if (bl) {
            icon.paintIcon(null, graphics, n2 + 4, n3 + 3);
        }
        int n8 = 4 + (bl ? 4 + icon.getIconWidth() : 0);
        if (string != null) {
            HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)(n2 + n8), (int)(n3 + fontMetrics.getAscent() + 3), (int)n6, (int)n5, (Font)serializable2, (Color)serializable, (int)1, (boolean)true);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = this.isSelected(n);
        boolean bl2 = bl && this.isActive();
        boolean bl3 = this.isAttention(n);
        boolean bl4 = this.isUnderMouse(n);
        boolean bl5 = n == 0;
        boolean bl6 = this.isLast(n);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!bl) {
            ++n3;
            --n5;
        }
        graphics2D.setColor(BORDER_COLOR);
        if (!bl) {
            graphics2D.drawLine(n2, n3 + n5 - 1, n2 + n4 - 1, n3 + n5 - 1);
        } else {
            if (bl5 && bl2) {
                graphics2D.setColor(BORDER_FOCUSED_COLOR);
            }
            graphics2D.drawLine(n2, n3 + n5 - 1, n2, n3 + n5 - 1);
            if (!bl6 || !bl2) {
                graphics2D.setColor(BORDER_COLOR);
            }
            graphics2D.drawLine(n2 + n4 - 1, n3 + n5 - 1, n2 + n4 - 1, n3 + n5 - 1);
        }
        if (bl2 || bl4) {
            graphics2D.setColor(BORDER_FOCUSED_COLOR);
        }
        int n6 = n2;
        if (bl5 || bl) {
            n6 = n2 + 1;
            graphics2D.drawLine(n2, n3 + 2, n2, n3 + n5 - 2);
        }
        graphics2D.drawLine(n6, n3 + 1, n6, n3 + 1);
        int n7 = !bl6 && this.isSelected(n + 1) ? 1 : 0;
        graphics2D.drawLine(n6 + 1, n3, n2 + n4 - 3 + n7, n3);
        graphics2D.drawLine(n2 + n4 - 2 + n7, n3 + 1, n2 + n4 - 2 + n7, n3 + 1);
        if (bl6 || !this.isSelected(n + 1)) {
            graphics2D.drawLine(n2 + n4 - 1, n3 + 2, n2 + n4 - 1, n3 + n5 - 2);
        }
        if (!this.isDimmed(n)) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.5f));
            graphics2D.setColor(bl4 ? BORDER_FOCUSED_COLOR : BORDER_HIGHLIGHT_COLOR);
            graphics2D.drawLine(n6, n3 + 2, n6, n3 + n5 - 2);
            graphics2D.drawLine(n6 + 1, n3 + 1, n2 + n4 - 3 + n7, n3 + 1);
            graphics2D.drawLine(n2 + n4 - 2 + n7, n3 + 2, n2 + n4 - 2 + n7, n3 + n5 - 2);
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.2f));
            graphics2D.drawLine(n6 + 1, n3 + 2, n6 + 1, n3 + 2);
            graphics2D.drawLine(n2 + n4 - 3 + n7, n3 + 2, n2 + n4 - 3 + n7, n3 + 2);
            graphics2D.setComposite(composite);
        }
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color[] colorArray;
        boolean bl = this.isSelected(n);
        boolean bl2 = bl && this.isActive();
        boolean bl3 = this.isAttention(n);
        boolean bl4 = n == 0;
        boolean bl5 = this.isLast(n);
        if (bl4 || bl) {
            --n4;
            ++n2;
        }
        if (!bl) {
            ++n3;
            n5 -= 2;
        }
        if (bl5 || !this.isSelected(n + 1)) {
            --n4;
        }
        if (bl2) {
            Color[] colorArray2 = new Color[4];
            colorArray2[0] = BG1_FOCUSED_COLOR;
            colorArray2[1] = BG2_FOCUSED_COLOR;
            colorArray2[2] = BG3_FOCUSED_COLOR;
            colorArray = colorArray2;
            colorArray2[3] = BG4_FOCUSED_COLOR;
        } else {
            Color[] colorArray3 = new Color[4];
            colorArray3[0] = BG1_COLOR;
            colorArray3[1] = BG2_COLOR;
            colorArray3[2] = BG3_COLOR;
            colorArray = colorArray3;
            colorArray3[3] = BG4_COLOR;
        }
        Color[] colorArray4 = colorArray;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(new LinearGradientPaint(n2, n3, n2, n3 + n5 - 1, new float[]{0.0f, 0.49f, 0.5f, 1.0f}, colorArray4));
        graphics2D.fillRect(n2, n3 + 1, n4, n5 - 1);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setColor(GRAY_76);
        graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        TabDataModel tabDataModel = this.getDataModel();
        TabLayoutModel tabLayoutModel = this.getLayoutModel();
        for (int i = 0; i < tabDataModel.size(); ++i) {
            boolean bl = this.isDimmed(i);
            TabData tabData = tabDataModel.getTab(i);
            int n = tabLayoutModel.getX(i);
            int n2 = tabLayoutModel.getY(i);
            int n3 = tabLayoutModel.getW(i);
            int n4 = tabLayoutModel.getH(i);
            String string = tabData.getText();
            BufferedImage bufferedImage = null;
            Graphics2D graphics2D2 = graphics2D;
            int n5 = n;
            int n6 = n2;
            if (bl) {
                n = 0;
                n2 = 0;
                bufferedImage = graphics2D.getDeviceConfiguration().createCompatibleImage(n3, n4, 3);
                graphics2D2 = bufferedImage.createGraphics();
                graphics2D2.setClip(0, 0, n3, n4);
                float f = this.isActive() ? 0.7f : 0.5f;
                graphics2D2.setComposite(AlphaComposite.getInstance(3, f));
            }
            if (graphics2D2.hitClip(n, n2, n3, n4)) {
                this.paintTabBackground(graphics2D2, i, n, n2, n3, n4);
                this.paintTabContent(graphics2D2, i, string, n, n2, n3, n4);
                this.paintTabBorder(graphics2D2, i, n, n2, n3, n4);
            }
            if (!bl) continue;
            graphics2D2.dispose();
            graphics2D.drawImage((Image)bufferedImage, n5, n6, null);
        }
        graphics.dispose();
    }

    protected Font getTxtFont() {
        if (this.font == null) {
            this.font = (Font)UIManager.get("windowTitleFont");
            this.font = this.font == null ? new Font("Dialog", 0, 12) : new Font(this.font.getName(), 0, 12);
        }
        return this.font;
    }

    private boolean isDimmed(int n) {
        return !this.isSelected(n) && !this.isUnderMouse(n);
    }

    private boolean isUnderMouse(int n) {
        return ((OwnController)this.getController()).getMouseIndex() == n;
    }

    private boolean isTabInFront(int n) {
        return this.isSelected(n) && (this.isActive() || this.isMoreThanOne());
    }

    private boolean isMoreThanOne() {
        return this.getDataModel().size() > 1;
    }

    private boolean isLast(int n) {
        return this.getDataModel().size() - 1 == n;
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] stringArray;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_bigclose_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_bigclose_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/xp_bigclose_rollover.png"};
            buttonIconPaths.put(1, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_slideright_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/xp_slideright_rollover.png"};
            buttonIconPaths.put(6, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_slideleft_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/xp_slideleft_rollover.png"};
            buttonIconPaths.put(5, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_slidebottom_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/xp_slidebottom_rollover.png"};
            buttonIconPaths.put(7, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_pin_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/xp_pin_rollover.png"};
            buttonIconPaths.put(2, stringArray);
        }
    }

    protected Component getControlButtons() {
        if (null == this.buttonsPanel) {
            Object object;
            this.buttonsPanel = new JPanel(null);
            this.buttonsPanel.setOpaque(false);
            Border border = this.createBorder();
            this.buttonsPanel.setBorder(border);
            Insets insets = border.getBorderInsets(this.buttonsPanel);
            int n = insets.left;
            int n2 = insets.top;
            if (null != this.displayer.getWinsysInfo()) {
                this.hidePin = TabControlButtonFactory.createSlidePinButton((TabDisplayer)this.displayer);
                this.buttonsPanel.add((Component)this.hidePin);
                object = this.hidePin.getIcon();
                this.hidePin.setBounds(n, 0, object.getIconWidth(), object.getIconHeight());
                n += object.getIconWidth();
            }
            object = TabControlButtonFactory.createCloseButton((TabDisplayer)this.displayer);
            this.buttonsPanel.add((Component)object);
            Icon icon = object.getIcon();
            if (0 != n) {
                n += 2;
            }
            object.setBounds(n, 0, icon.getIconWidth(), icon.getIconHeight());
            n += icon.getIconWidth();
            n2 += this.hidePin.getHeight() > object.getHeight() ? this.hidePin.getHeight() : object.getHeight();
            n += insets.right;
            Rectangle rectangle = this.hidePin.getBounds();
            rectangle.y = (n2 += insets.bottom) / 2 - rectangle.height / 2;
            this.hidePin.setBounds(rectangle);
            rectangle = object.getBounds();
            rectangle.y = n2 / 2 - rectangle.height / 2;
            object.setBounds(rectangle);
            Dimension dimension = new Dimension(n, n2);
            this.buttonsPanel.setMinimumSize(dimension);
            this.buttonsPanel.setSize(dimension);
            this.buttonsPanel.setPreferredSize(dimension);
            this.buttonsPanel.setMaximumSize(dimension);
            try {
                Field field = AbstractViewTabDisplayerUI.class.getDeclaredField("btnAutoHidePin");
                if (field != null) {
                    field.setAccessible(true);
                    field.set((Object)this, this.hidePin);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return this.buttonsPanel;
    }

    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        OfficeViewTabDisplayerUIOld.initIcons();
        if (n == 6) {
            return new DoubleArrowIcon(DoubleArrowIcon.Orientation.RIGHT);
        }
        if (n == 5) {
            return new DoubleArrowIcon(DoubleArrowIcon.Orientation.LEFT);
        }
        if (n == 7) {
            return new DoubleArrowIcon(DoubleArrowIcon.Orientation.DOWN);
        }
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon((String)stringArray[n2]);
        }
        return icon;
    }

    public void postTabAction(TabActionEvent tabActionEvent) {
        super.postTabAction(tabActionEvent);
        if ("maximize".equals(tabActionEvent.getActionCommand())) {
            ((OwnController)this.getController()).updateHighlight(-1);
        }
    }

    private Border createBorder() {
        Border border = BorderFactory.createEmptyBorder(4, 3, 4, 1);
        AbstractBorder abstractBorder = new AbstractBorder(){

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color = graphics2D.getColor();
                int n5 = n2 + 2;
                int n6 = n2 + n4 - 3;
                graphics2D.setColor(new Color(145, 153, 164));
                graphics2D.drawLine(n, n5, n, n6);
                graphics2D.setColor(new Color(221, 224, 227));
                graphics2D.drawLine(n + 1, n5, n + 1, n6);
                graphics2D.setColor(color);
            }

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(0, 2, 0, 0);
            }

            @Override
            public Insets getBorderInsets(Component component, Insets insets) {
                insets.left = 2;
                insets.top = 0;
                insets.right = 0;
                insets.bottom = 0;
                return insets;
            }
        };
        return BorderFactory.createCompoundBorder(abstractBorder, border);
    }

    static Color getInactBgColor() {
        if (inactBgColor == null && (inactBgColor = (Color)UIManager.get("inactiveCaption")) == null) {
            inactBgColor = new Color(204, 204, 204);
        }
        return inactBgColor;
    }

    static Color getActBgColor() {
        if (actBgColor == null && (actBgColor = (Color)UIManager.get("activeCaption")) == null) {
            actBgColor = new Color(204, 204, 255);
        }
        return actBgColor;
    }

    static {
        GRAY_76 = new Color(76, 76, 76);
        BORDER_COLOR = new Color(9014421);
        BORDER_FOCUSED_COLOR = new Color(3964849);
        BORDER_HIGHLIGHT_COLOR = Color.WHITE;
        BG1_FOCUSED_COLOR = new Color(15923708);
        BG2_FOCUSED_COLOR = new Color(15923708);
        BG3_FOCUSED_COLOR = new Color(14807545);
        BG4_FOCUSED_COLOR = new Color(14216438);
        BG1_COLOR = new Color(0xE9E9E9);
        BG2_COLOR = new Color(0xE5E5E5);
        BG3_COLOR = new Color(0xD6D6D6);
        BG4_COLOR = new Color(0xCCCCCC);
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex;

        private OwnController() {
            super((AbstractViewTabDisplayerUI)OfficeViewTabDisplayerUIOld.this);
            this.lastIndex = -1;
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        public boolean inControlButtonsRect(Point point) {
            if (null != OfficeViewTabDisplayerUIOld.this.buttonsPanel) {
                Point point2 = SwingUtilities.convertPoint((Component)OfficeViewTabDisplayerUIOld.this.displayer, point, OfficeViewTabDisplayerUIOld.this.buttonsPanel);
                return OfficeViewTabDisplayerUIOld.this.buttonsPanel.contains(point2);
            }
            return false;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            Point point = mouseEvent.getPoint();
            if (!mouseEvent.getSource().equals(OfficeViewTabDisplayerUIOld.this.displayer)) {
                point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, (Component)OfficeViewTabDisplayerUIOld.this.displayer);
            }
            this.updateHighlight(OfficeViewTabDisplayerUIOld.this.getLayoutModel().indexOfPoint(point.x, point.y));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            if (!this.inControlButtonsRect(mouseEvent.getPoint())) {
                this.updateHighlight(-1);
            }
        }

        private void updateHighlight(int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (n == this.lastIndex) {
                return;
            }
            TabLayoutModel tabLayoutModel = OfficeViewTabDisplayerUIOld.this.getLayoutModel();
            Rectangle rectangle = null;
            if (n != -1) {
                n5 = tabLayoutModel.getX(n);
                n4 = tabLayoutModel.getY(n);
                n3 = tabLayoutModel.getW(n);
                n2 = tabLayoutModel.getH(n);
                rectangle = new Rectangle(n5, n4, n3, n2);
            }
            if (this.lastIndex != -1 && this.lastIndex < OfficeViewTabDisplayerUIOld.this.getDataModel().size()) {
                n5 = tabLayoutModel.getX(this.lastIndex);
                n4 = tabLayoutModel.getY(this.lastIndex);
                n3 = tabLayoutModel.getW(this.lastIndex);
                n2 = tabLayoutModel.getH(this.lastIndex);
                rectangle = rectangle != null ? rectangle.union(new Rectangle(n5, n4, n3, n2)) : new Rectangle(n5, n4, n3, n2);
            }
            if (rectangle != null) {
                OfficeViewTabDisplayerUIOld.this.getDisplayer().repaint(rectangle);
            }
            this.lastIndex = n;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            this.mouseMoved(mouseEvent);
        }
    }
}

