/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.DefaultStringConverter;
import com.paterva.maltego.typing.StringConverter;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.formatting.BooleanFormatAdapter;
import com.paterva.maltego.typing.formatting.DateFormatAdapter;
import com.paterva.maltego.typing.formatting.DateTimeFormatAdapter;
import com.paterva.maltego.typing.formatting.TimeSpanFormatAdapter;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.InternalFile;
import com.paterva.maltego.typing.types.TimeSpan;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TypeRegistry {
    private static TypeRegistry _default;
    private Map<String, TypeDescriptor> _nameMap = new HashMap<String, TypeDescriptor>();
    private Map<Class, TypeDescriptor> _classMap = new HashMap<Class, TypeDescriptor>();

    public static TypeRegistry getDefault() {
        if (_default == null) {
            _default = new TypeRegistry();
            TypeRegistry.registerDefaults(_default);
        }
        return _default;
    }

    private TypeRegistry() {
    }

    public void registerType(TypeDescriptor typeDescriptor) {
        this._nameMap.put(typeDescriptor.getTypeName(), typeDescriptor);
        this._classMap.put(typeDescriptor.getType(), typeDescriptor);
    }

    public void deregisterType(String string) {
        TypeDescriptor typeDescriptor = this._nameMap.get(string);
        if (typeDescriptor != null) {
            this._classMap.remove(typeDescriptor.getType());
        }
    }

    public void deregisterType(Class clazz) {
        TypeDescriptor typeDescriptor = this._classMap.get(clazz);
        if (typeDescriptor != null) {
            this._nameMap.remove(typeDescriptor.getTypeName());
        }
    }

    public TypeDescriptor getType(String string) {
        return this._nameMap.get(string);
    }

    public TypeDescriptor getType(Class clazz) {
        return this._classMap.get(clazz);
    }

    public TypeDescriptor[] getTypes() {
        Collection<TypeDescriptor> collection = this._nameMap.values();
        return collection.toArray(new TypeDescriptor[collection.size()]);
    }

    public void registerType(String string, Class clazz) {
        this.registerType(new TypeDescriptor(string, clazz));
    }

    public void registerType(String string, Class clazz, StringConverter stringConverter) {
        this.registerType(new TypeDescriptor(string, clazz, stringConverter));
    }

    public void registerType(String string, Class clazz, StringConverter stringConverter, Object object) {
        this.registerType(new TypeDescriptor(string, clazz, stringConverter, object));
    }

    public void registerType(String string, Class clazz, Object object) {
        this.registerType(new TypeDescriptor(string, clazz, object));
    }

    public static void registerDefaults(TypeRegistry typeRegistry) {
        typeRegistry.registerType("string", String.class, "");
        typeRegistry.registerType("char", Character.TYPE, Character.valueOf('0'));
        typeRegistry.registerType("int", Integer.TYPE, 0);
        typeRegistry.registerType("double", Double.TYPE, 0.0);
        typeRegistry.registerType("float", Float.TYPE, Float.valueOf(0.0f));
        typeRegistry.registerType("byte", Byte.TYPE, (byte)0);
        typeRegistry.registerType("int[]", int[].class, new int[0]);
        typeRegistry.registerType("string[]", String[].class, new String[0]);
        typeRegistry.registerType("boolean[]", boolean[].class, new boolean[0]);
        typeRegistry.registerType("double[]", double[].class, new double[0]);
        typeRegistry.registerType("float[]", float[].class, new float[0]);
        TypeDescriptor typeDescriptor = new TypeDescriptor("date", Date.class, new DateConverter(), null);
        typeDescriptor.setFormatAdapter(new DateFormatAdapter());
        typeRegistry.registerType(typeDescriptor);
        TypeDescriptor typeDescriptor2 = new TypeDescriptor("boolean", Boolean.TYPE, false);
        typeDescriptor2.setFormatAdapter(new BooleanFormatAdapter());
        typeRegistry.registerType(typeDescriptor2);
        TypeDescriptor typeDescriptor3 = new TypeDescriptor("boolean[]", boolean[].class, new boolean[0]);
        typeDescriptor3.setFormatAdapter(typeDescriptor2.getFormatAdapter());
        typeRegistry.registerType(typeDescriptor3);
        TypeDescriptor typeDescriptor4 = new TypeDescriptor("date[]", Date[].class, new Date[0]);
        typeDescriptor4.setFormatAdapter(typeDescriptor.getFormatAdapter());
        typeRegistry.registerType(typeDescriptor4);
        typeRegistry.registerType("file", File.class, null);
        typeRegistry.registerType("image", Image.class, new ImageURLConverter(), null);
        typeRegistry.registerType("url", FastURL.class, new FastURLConverter());
        typeRegistry.registerType("color", Color.class, new ColorConverter(), null);
        typeRegistry.registerType("attachments", Attachments.class, null);
        typeRegistry.registerType("internalfile", InternalFile.class, null);
        TypeDescriptor typeDescriptor5 = new TypeDescriptor("datetime", DateTime.class, new DateTimeConverter(), null);
        typeDescriptor5.setFormatAdapter(new DateTimeFormatAdapter());
        typeRegistry.registerType(typeDescriptor5);
        TypeDescriptor typeDescriptor6 = new TypeDescriptor("timespan", TimeSpan.class, new TimeSpanConverter(), null);
        typeDescriptor6.setFormatAdapter(new TimeSpanFormatAdapter());
        typeRegistry.registerType(typeDescriptor6);
    }

    public static String getDefaultDateFormat() {
        return "yyyy-MM-dd";
    }

    private static class TimeSpanConverter
    implements StringConverter {
        private TimeSpanConverter() {
        }

        @Override
        public Object convertFrom(String string, Class clazz) throws IllegalArgumentException {
            if (!StringUtilities.isNullOrEmpty((String)string)) {
                return TimeSpan.parse(string);
            }
            return null;
        }

        @Override
        public String convertTo(Object object, Class clazz) throws IllegalArgumentException {
            if (object instanceof TimeSpan) {
                return object.toString();
            }
            return DefaultStringConverter.instance().convertTo(object, clazz);
        }
    }

    private static class DateTimeConverter
    implements StringConverter {
        private DateTimeConverter() {
        }

        @Override
        public Object convertFrom(String string, Class clazz) throws IllegalArgumentException {
            if (!StringUtilities.isNullOrEmpty((String)string)) {
                return DateTime.parse(string);
            }
            return null;
        }

        @Override
        public String convertTo(Object object, Class clazz) throws IllegalArgumentException {
            if (object instanceof DateTime) {
                return object.toString();
            }
            return DefaultStringConverter.instance().convertTo(object, clazz);
        }
    }

    private static class DateConverter
    implements StringConverter {
        private DateConverter() {
        }

        protected SimpleDateFormat getFormat() {
            return new SimpleDateFormat(TypeRegistry.getDefaultDateFormat());
        }

        @Override
        public Object convertFrom(String string, Class clazz) throws IllegalArgumentException {
            if (!StringUtilities.isNullOrEmpty((String)string)) {
                Date date = null;
                try {
                    date = this.getFormat().parse(string);
                }
                catch (ParseException parseException) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z");
                    try {
                        simpleDateFormat.parse(string);
                    }
                    catch (ParseException parseException2) {
                        // empty catch block
                    }
                }
                return date;
            }
            return null;
        }

        @Override
        public String convertTo(Object object, Class clazz) throws IllegalArgumentException {
            if (object instanceof Date) {
                return this.getFormat().format((Date)object);
            }
            return DefaultStringConverter.instance().convertTo(object, clazz);
        }
    }

    private static class FastURLConverter
    implements StringConverter {
        private FastURLConverter() {
        }

        @Override
        public Object convertFrom(String string, Class clazz) throws IllegalArgumentException {
            if (!StringUtilities.isNullOrEmpty((String)string)) {
                return new FastURL(string);
            }
            return null;
        }

        @Override
        public String convertTo(Object object, Class clazz) throws IllegalArgumentException {
            if (object instanceof FastURL) {
                return object.toString();
            }
            return DefaultStringConverter.instance().convertTo(object, clazz);
        }
    }

    private static class ColorConverter
    implements StringConverter {
        private ColorConverter() {
        }

        @Override
        public Object convertFrom(String string, Class clazz) throws IllegalArgumentException {
            Object object = null;
            if (!StringUtilities.isNullOrEmpty((String)string) && (object = new Color(Integer.parseInt(string))) == null) {
                object = DefaultStringConverter.instance().convertFrom(string, clazz);
            }
            return object;
        }

        @Override
        public String convertTo(Object object, Class clazz) throws IllegalArgumentException {
            if (object instanceof Color) {
                Color color = (Color)object;
                return String.valueOf(color.getRGB());
            }
            return DefaultStringConverter.instance().convertTo(object, clazz);
        }
    }

    private static class ImageURLConverter
    implements StringConverter {
        private ImageURLConverter() {
        }

        @Override
        public Object convertFrom(String string, Class clazz) throws IllegalArgumentException {
            Object object = null;
            if (string != null) {
                if (string.startsWith("http")) {
                    try {
                        object = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (object == null) {
                    object = DefaultStringConverter.instance().convertFrom(string, clazz);
                }
            }
            return object;
        }

        @Override
        public String convertTo(Object object, Class clazz) throws IllegalArgumentException {
            if (object instanceof URL) {
                return object.toString();
            }
            return DefaultStringConverter.instance().convertTo(object, clazz);
        }
    }
}

