/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.filetypes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.ui.options.filetypes.FileAssociationsModel;
import org.netbeans.core.ui.options.filetypes.NewExtensionPanel;
import org.netbeans.core.ui.options.filetypes.OpenAsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class OpenAsAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(OpenAsAction.class.getName());
    private OpenAsPanel openAsPanel;

    protected void performAction(Node[] activatedNodes) {
        String mimeType;
        if (this.openAsPanel == null) {
            this.openAsPanel = new OpenAsPanel();
        }
        FileAssociationsModel model = new FileAssociationsModel();
        this.openAsPanel.setModel(model);
        final DataObject dob = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        FileObject fo = dob.getPrimaryFile();
        String extension = fo.getExt();
        this.openAsPanel.setExtension(extension);
        String openLabel = NbBundle.getMessage(NewExtensionPanel.class, (String)"OpenAsPanel.open");
        DialogDescriptor dd = new DialogDescriptor((Object)this.openAsPanel, NbBundle.getMessage(OpenAsPanel.class, (String)"OpenAsPanel.title"), true, new Object[]{openLabel, DialogDescriptor.CANCEL_OPTION}, (Object)openLabel, 0, null, null);
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        if (openLabel.equals(dd.getValue()) && (mimeType = this.openAsPanel.getMimeType()) != null) {
            dob.addPropertyChangeListener(new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("valid") && !((Boolean)evt.getNewValue()).booleanValue()) {
                        LOGGER.fine("PROP_VALID " + evt.getNewValue() + " - " + evt);
                        try {
                            OpenCookie openCookie = (OpenCookie)DataObject.find((FileObject)dob.getPrimaryFile()).getCookie(OpenCookie.class);
                            if (openCookie == null) return;
                            openCookie.open();
                            return;
                        }
                        catch (DataObjectNotFoundException ex) {
                            LOGGER.log(Level.INFO, null, ex);
                            return;
                        }
                        finally {
                            dob.removePropertyChangeListener((PropertyChangeListener)this);
                        }
                    } else {
                        dob.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            });
            model.setMimeType(extension, mimeType);
            model.store();
            OpenCookie openCookie = (OpenCookie)dob.getCookie(OpenCookie.class);
            if (openCookie != null) {
                openCookie.open();
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    public String getName() {
        return NbBundle.getMessage(OpenAsAction.class, (String)"OpenAsAction.name");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(OpenAsAction.class);
    }
}

