/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.merging;

import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.merging.MergeUtils;
import java.util.Collection;

public abstract class PartMergeStrategy {
    public static final PartMergeStrategy KeepOriginal = new KeepOriginal();
    public static final PartMergeStrategy PreferOriginal = new PreferOriginal();
    public static final PartMergeStrategy PreferNew = new PreferNew();
    public static final PartMergeStrategy Replace = new Replace();

    public abstract MaltegoPart merge(MaltegoPart var1, MaltegoPart var2);

    private static class Replace
    extends PartMergeStrategy {
        private Replace() {
        }

        public MaltegoPart merge(MaltegoPart maltegoPart, MaltegoPart maltegoPart2) {
            MergeUtils.replaceProperties(maltegoPart, maltegoPart2);
            MergeUtils.replacePropertyValues(maltegoPart, maltegoPart2, true);
            MergeUtils.copySpecialPropertyMapping(maltegoPart, maltegoPart2, true);
            DisplayInformationCollection displayInformationCollection = maltegoPart.getDisplayInformation();
            displayInformationCollection.clear();
            displayInformationCollection.addAll((Collection)maltegoPart2.getDisplayInformation());
            maltegoPart.setDisplayInformation(displayInformationCollection);
            maltegoPart.setNotes(maltegoPart2.getNotes());
            maltegoPart.setShowNotes(maltegoPart2.isShowNotes());
            maltegoPart.setBookmark(maltegoPart2.getBookmark());
            return maltegoPart2;
        }
    }

    private static class PreferNew
    extends PartMergeStrategy {
        private PreferNew() {
        }

        public MaltegoPart merge(MaltegoPart maltegoPart, MaltegoPart maltegoPart2) {
            MergeUtils.addMissingProperties(maltegoPart, maltegoPart2);
            MergeUtils.mergePropertyValues(maltegoPart, maltegoPart2, true);
            MergeUtils.mergeSpecialPropertyMapping(maltegoPart, maltegoPart2, true);
            MergeUtils.mergeDisplayInformation(maltegoPart, maltegoPart2, true);
            MergeUtils.mergeNotes(maltegoPart, maltegoPart2, true);
            maltegoPart.setBookmark(maltegoPart2.getBookmark());
            return maltegoPart;
        }
    }

    private static class PreferOriginal
    extends PartMergeStrategy {
        private PreferOriginal() {
        }

        public MaltegoPart merge(MaltegoPart maltegoPart, MaltegoPart maltegoPart2) {
            MergeUtils.addMissingProperties(maltegoPart, maltegoPart2);
            MergeUtils.mergePropertyValues(maltegoPart, maltegoPart2, false);
            MergeUtils.mergeSpecialPropertyMapping(maltegoPart, maltegoPart2, false);
            MergeUtils.mergeDisplayInformation(maltegoPart, maltegoPart2, false);
            MergeUtils.mergeNotes(maltegoPart, maltegoPart2, false);
            return maltegoPart;
        }
    }

    private static class KeepOriginal
    extends PartMergeStrategy {
        private KeepOriginal() {
        }

        public MaltegoPart merge(MaltegoPart maltegoPart, MaltegoPart maltegoPart2) {
            return maltegoPart;
        }
    }
}

