/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.impl;

import com.paterva.maltego.util.ui.dialog.ArrayWizardIterator;
import com.paterva.maltego.util.ui.dialog.WizardSegment;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import com.paterva.maltego.welcome.StartupWizardDisplayer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.lookup.Lookups;

public class DefaultStartupWizardDisplayer
extends StartupWizardDisplayer {
    @Override
    public void run() {
        block8: {
            Collection collection = Lookups.forPath((String)"Maltego/StartupWizard").lookupAll(WizardSegment.class);
            if (!DefaultStartupWizardDisplayer.shouldRun(collection)) break block8;
            ArrayList<SegmentWrapper> arrayList = new ArrayList<SegmentWrapper>();
            for (WizardSegment wizardSegment : collection) {
                arrayList.add(new SegmentWrapper(wizardSegment));
            }
            if (arrayList.size() > 0) {
                SegmentWrapper segmentWrapper2;
                WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[DefaultStartupWizardDisplayer.getPanelCount(arrayList)];
                int n = 0;
                Collections.sort(arrayList);
                for (SegmentWrapper segmentWrapper2 : arrayList) {
                    System.arraycopy(segmentWrapper2.getPanels(), 0, panelArray, n, segmentWrapper2.getPanels().length);
                    n += segmentWrapper2.getPanels().length;
                }
                WizardUtilities.updatePanels((WizardDescriptor.Panel[])panelArray);
                ArrayWizardIterator arrayWizardIterator = new ArrayWizardIterator(panelArray);
                segmentWrapper2 = new WizardDescriptor((WizardDescriptor.Iterator)arrayWizardIterator);
                for (SegmentWrapper segmentWrapper3 : arrayList) {
                    segmentWrapper3.initialize((WizardDescriptor)segmentWrapper2);
                }
                segmentWrapper2.setTitle("Welcome to Maltego!");
                segmentWrapper2.setTitleFormat(new MessageFormat("Startup wizard - {0} ({1})"));
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)segmentWrapper2) == WizardDescriptor.FINISH_OPTION) {
                    for (SegmentWrapper segmentWrapper3 : arrayList) {
                        segmentWrapper3.handleFinish((WizardDescriptor)segmentWrapper2);
                    }
                } else {
                    for (SegmentWrapper segmentWrapper3 : arrayList) {
                        segmentWrapper3.handleCancel((WizardDescriptor)segmentWrapper2);
                    }
                }
            }
        }
    }

    private static boolean shouldRun(Collection<? extends WizardSegment> collection) {
        return collection.size() != 1 || collection.iterator().next().getProperty("ignoreIfAlone") != Boolean.TRUE;
    }

    private static int getPanelCount(Collection<SegmentWrapper> collection) {
        int n = 0;
        for (SegmentWrapper segmentWrapper : collection) {
            n += segmentWrapper.getPanels().length;
        }
        return n;
    }

    private static class SegmentWrapper
    implements Comparable<SegmentWrapper> {
        private WizardSegment _segment;
        private WizardDescriptor.Panel[] _panels;

        public SegmentWrapper(WizardSegment wizardSegment) {
            this._segment = wizardSegment;
        }

        public WizardDescriptor.Panel[] getPanels() {
            if (this._panels == null) {
                this._panels = this._segment.createPanels();
            }
            return this._panels;
        }

        public void initialize(WizardDescriptor wizardDescriptor) {
            this._segment.initialize(wizardDescriptor, this.getPanels());
        }

        public void handleFinish(WizardDescriptor wizardDescriptor) {
            this._segment.handleFinish(wizardDescriptor);
        }

        public void handleCancel(WizardDescriptor wizardDescriptor) {
            this._segment.handleCancel(wizardDescriptor);
        }

        @Override
        public int compareTo(SegmentWrapper segmentWrapper) {
            return Integer.valueOf(this._segment.getPosition()).compareTo(segmentWrapper._segment.getPosition());
        }
    }
}

