/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.util.FileExtensionFileFilter;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openide.ErrorManager;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;

public final class FileOpenAction
extends CallableSystemAction {
    public FileOpenAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(GraphDataObject.class).setTitle("Open graph");
        fileChooserBuilder.setFileFilter((FileFilter)new FileExtensionFileFilter("mtgx", "Maltego graph files"));
        File[] fileArray = this.showMultiOpenDialog(fileChooserBuilder);
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                FileOpenAction.open(fileArray[i]);
            }
        }
    }

    private File[] showMultiOpenDialog(FileChooserBuilder fileChooserBuilder) throws HeadlessException {
        File[] fileArray = null;
        JFileChooser jFileChooser = fileChooserBuilder.createFileChooser();
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (0 == n) {
            fileArray = jFileChooser.getSelectedFiles();
        }
        return fileArray;
    }

    public static void open(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            if (openCookie != null) {
                openCookie.open();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
    }

    public String getName() {
        return "Open";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/Open.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

