/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.ui.graph.clipboard.MergeOptionsPanel;
import java.util.prefs.Preferences;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbPreferences;

public class MergeOptionsController {
    private static final String MERGE_SETTING = "mergeOptionsMergeEnabled";
    private static final String SKIP_SETTING = "mergeOptionsSkipEnabled";
    private static final String STRATEGY_SETTING = "mergeOptionsStrategy";
    private static final int STRAT_PREFER_NEW = 0;
    private static final int STRAT_PREFER_OLD = 1;
    private static final int STRAT_REPLACE = 2;
    private static final int STRAT_KEEP_OLD = 3;
    private GraphWrapper _destGraph;
    private GraphWrapper _srcGraph;
    private MaltegoEntity _srcEntity;
    private MaltegoEntity _destEntity;
    private int _remaining;
    private Preferences _prefs;
    private boolean _doForAll;

    public MergeOptionsController(GraphWrapper graphWrapper, GraphWrapper graphWrapper2, MaltegoEntity maltegoEntity, MaltegoEntity maltegoEntity2, int n) {
        this._destGraph = graphWrapper;
        this._srcGraph = graphWrapper2;
        this._destEntity = maltegoEntity;
        this._srcEntity = maltegoEntity2;
        this._remaining = n;
        this._prefs = NbPreferences.forModule(MergeOptionsPanel.class);
    }

    public boolean showMergeOptions() {
        MergeOptionsPanel mergeOptionsPanel = new MergeOptionsPanel(this._destGraph, this._srcGraph, this._destEntity, this._srcEntity, this._remaining);
        this.readSettings(mergeOptionsPanel);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mergeOptionsPanel, "Entities Match", true, 2, DialogDescriptor.OK_OPTION, null);
        if (DialogDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor))) {
            this.storeSettings(mergeOptionsPanel);
            this._doForAll = mergeOptionsPanel.isDoForAll();
            return true;
        }
        return false;
    }

    public boolean isDoForAll() {
        return this._doForAll;
    }

    public boolean isSkipEntity() {
        return this._prefs.getBoolean(SKIP_SETTING, false);
    }

    public boolean isKeepBothEntity() {
        return !this.isMergeEntities() && !this.isSkipEntity();
    }

    public boolean isMergeEntities() {
        return this._prefs.getBoolean(MERGE_SETTING, true);
    }

    public PartMergeStrategy getMergeStrategy() {
        int n = this._prefs.getInt(STRATEGY_SETTING, 0);
        switch (n) {
            case 1: {
                return PartMergeStrategy.PreferOriginal;
            }
            case 2: {
                return PartMergeStrategy.Replace;
            }
            case 3: {
                return PartMergeStrategy.KeepOriginal;
            }
        }
        return PartMergeStrategy.PreferNew;
    }

    private void readSettings(MergeOptionsPanel mergeOptionsPanel) {
        if (this.isMergeEntities()) {
            mergeOptionsPanel.setMergeEntities();
        } else if (this.isSkipEntity()) {
            mergeOptionsPanel.setSkipEntities();
        } else {
            mergeOptionsPanel.setKeepBothEntities();
        }
        mergeOptionsPanel.setMergeStrategy(this.getMergeStrategy());
    }

    private void storeSettings(MergeOptionsPanel mergeOptionsPanel) {
        boolean bl = mergeOptionsPanel.isMergeEntities();
        boolean bl2 = mergeOptionsPanel.isSkipEntity();
        this._prefs.putBoolean(MERGE_SETTING, bl);
        this._prefs.putBoolean(SKIP_SETTING, bl2);
        int n = 0;
        PartMergeStrategy partMergeStrategy = mergeOptionsPanel.getMergeStrategy();
        if (PartMergeStrategy.PreferOriginal.equals(partMergeStrategy)) {
            n = 1;
        } else if (PartMergeStrategy.Replace.equals(partMergeStrategy)) {
            n = 2;
        } else if (PartMergeStrategy.KeepOriginal.equals(partMergeStrategy)) {
            n = 3;
        }
        this._prefs.putInt(STRATEGY_SETTING, n);
    }
}

