/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.Group;
import com.paterva.maltego.typing.GroupCollection;
import com.paterva.maltego.typing.GroupCollections;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.GroupSet;
import com.paterva.maltego.typing.HighlightStyle;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptorList;
import com.paterva.maltego.typing.PropertyDescriptors;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.propertygrid.DisplayDescriptorProperty;
import com.paterva.maltego.typing.editing.propertygrid.PropertySheetFactory;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public abstract class PartProperties {
    protected static GroupCollection _dynamicGroup;
    protected static final String DYNAMIC_GROUP = "dynamic";
    protected static final String DISPLAY_IMAGE_ICON = "com/paterva/maltego/ui/graph/nodes/DisplayImage.png";
    protected static final ImageIcon EMPTY_ICON;

    protected PartProperties() {
    }

    private static PropertyConfiguration prepare(PropertyConfiguration propertyConfiguration, PropertyDescriptorCollection propertyDescriptorCollection) {
        PropertyConfiguration propertyConfiguration2 = new PropertyConfiguration();
        if (propertyConfiguration == null) {
            propertyConfiguration2.setProperties(PartProperties.rewriteDynamicProperties(propertyDescriptorCollection));
        } else {
            propertyConfiguration2.setGroups(PartProperties.addDynamicGroup(propertyConfiguration.getGroups()));
            propertyConfiguration2.setProperties(PropertyDescriptors.add((DisplayDescriptorEnumeration)PartProperties.rewriteDynamicProperties(propertyDescriptorCollection), (DisplayDescriptorEnumeration)propertyConfiguration.getProperties()));
        }
        return propertyConfiguration2;
    }

    private static DisplayDescriptorEnumeration rewriteDynamicProperties(PropertyDescriptorCollection propertyDescriptorCollection) {
        DisplayDescriptorList displayDescriptorList = new DisplayDescriptorList();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorCollection) {
            DisplayDescriptor displayDescriptor = new DisplayDescriptor(propertyDescriptor);
            displayDescriptor.setGroupName(DYNAMIC_GROUP);
            displayDescriptorList.add((Object)displayDescriptor);
        }
        return displayDescriptorList;
    }

    private static GroupDefinitions addDynamicGroup(GroupDefinitions groupDefinitions) {
        if (groupDefinitions == null) {
            return new GroupDefinitions(_dynamicGroup, null);
        }
        GroupDefinitions groupDefinitions2 = new GroupDefinitions(GroupCollections.add((GroupCollection[])new GroupCollection[]{_dynamicGroup, groupDefinitions.getTopLevelGroups()}), groupDefinitions.getTopLevelSuperGroups());
        return groupDefinitions2;
    }

    public static void addProperties(SpecRegistry specRegistry, Sheet sheet, MaltegoPart maltegoPart, PropertyConfiguration propertyConfiguration) {
        PropertyConfiguration propertyConfiguration2 = PartProperties.combinePropertyConfigs(maltegoPart, propertyConfiguration);
        for (DisplayDescriptor displayDescriptor : propertyConfiguration2.getProperties()) {
            DisplayDescriptor displayDescriptor2 = PartProperties.createDisplayDescriptor((PropertyDescriptor)displayDescriptor);
            if (InheritanceHelper.isValueProperty((SpecRegistry)specRegistry, (TypedPropertyBag)maltegoPart, (PropertyDescriptor)displayDescriptor)) {
                displayDescriptor2.setHighlight(HighlightStyle.High);
            } else if (InheritanceHelper.isDisplayValueProperty((SpecRegistry)specRegistry, (TypedPropertyBag)maltegoPart, (PropertyDescriptor)displayDescriptor)) {
                displayDescriptor2.setHighlight(HighlightStyle.Medium);
            }
            if (maltegoPart instanceof MaltegoEntity && InheritanceHelper.isImageProperty((EntityRegistry)((EntityRegistry)specRegistry), (MaltegoEntity)((MaltegoEntity)maltegoPart), (PropertyDescriptor)displayDescriptor)) {
                displayDescriptor2.setImage(DISPLAY_IMAGE_ICON);
            }
            try {
                PropertySheetFactory.addProperty((Sheet)sheet, (DisplayDescriptor)displayDescriptor2, (DataSource)maltegoPart, (GroupDefinitions)propertyConfiguration2.getGroups());
            }
            catch (UnsupportedEditorException unsupportedEditorException) {
                Exceptions.printStackTrace((Throwable)unsupportedEditorException);
            }
        }
    }

    protected static PropertyConfiguration combinePropertyConfigs(MaltegoPart maltegoPart, PropertyConfiguration propertyConfiguration) {
        DisplayDescriptorEnumeration displayDescriptorEnumeration = propertyConfiguration == null ? null : propertyConfiguration.getProperties();
        PropertyDescriptorCollection propertyDescriptorCollection = PartProperties.getDynamicProperties(displayDescriptorEnumeration, maltegoPart.getProperties(), (DataSource)maltegoPart);
        PropertyConfiguration propertyConfiguration2 = PartProperties.prepare(propertyConfiguration, propertyDescriptorCollection);
        return propertyConfiguration2;
    }

    protected static DisplayDescriptor createDisplayDescriptor(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor instanceof DisplayDescriptor) {
            return new DisplayDescriptor((DisplayDescriptor)propertyDescriptor);
        }
        return new DisplayDescriptor(propertyDescriptor);
    }

    private static PropertyDescriptorCollection getDynamicProperties(DisplayDescriptorEnumeration displayDescriptorEnumeration, PropertyDescriptorCollection propertyDescriptorCollection, DataSource dataSource) {
        if (displayDescriptorEnumeration == null) {
            return propertyDescriptorCollection;
        }
        PropertyDescriptorList propertyDescriptorList = new PropertyDescriptorList();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorCollection) {
            if (displayDescriptorEnumeration.contains(propertyDescriptor.getName())) {
                Object object;
                DisplayDescriptor displayDescriptor = displayDescriptorEnumeration.get(propertyDescriptor.getName());
                if (propertyDescriptor.getType().isAssignableFrom(displayDescriptor.getType()) || (object = dataSource.getValue(propertyDescriptor)) == null) continue;
                try {
                    dataSource.setValue((PropertyDescriptor)displayDescriptor, Converter.convert((Object)object, (Class)propertyDescriptor.getType(), (Class)displayDescriptor.getType()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger.getLogger(PartProperties.class.getName()).warning("incompatible entities/links with same type");
                }
                continue;
            }
            propertyDescriptorList.add(propertyDescriptor);
        }
        return propertyDescriptorList;
    }

    public static boolean isDynamicProperty(DisplayDescriptorProperty displayDescriptorProperty) {
        return DYNAMIC_GROUP.equals(displayDescriptorProperty.getDisplayDescriptor().getGroupName());
    }

    static {
        EMPTY_ICON = new ImageIcon();
        _dynamicGroup = new GroupSet();
        _dynamicGroup.add(new Group(DYNAMIC_GROUP, "Dynamic properties", "Dynamic properties exist only in the instance and not in the definition."));
    }
}

