/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.list;

import com.paterva.maltego.ui.graph.GraphHoverContext;
import com.paterva.maltego.ui.graph.ViewCallback;
import com.paterva.maltego.ui.graph.ViewControlAdapter;
import com.paterva.maltego.ui.graph.nodes.EntityProperties;
import com.paterva.maltego.util.ui.outline.OutlineSearchPanel;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import com.paterva.maltego.view.list.EntityQuickFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openide.explorer.view.NodePopupFactory;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import yguard.A.A.D;
import yguard.A.A.Y;

public class EntityListView
implements ViewControlAdapter {
    private JPanel _panel = new JPanel(new BorderLayout());
    private OutlineView _view = new OutlineView();
    private D _graph;
    private ViewCallback _cb;

    public EntityListView() {
        this._view.getOutline().setRootVisible(false);
        HoverListener hoverListener = new HoverListener();
        this._view.getOutline().addMouseMotionListener((MouseMotionListener)hoverListener);
        this._view.getOutline().addMouseListener((MouseListener)hoverListener);
        this._panel.add((Component)this._view, "Center");
        this._view.setProperties(new Node.Property[]{EntityProperties.type(), EntityProperties.value(), EntityProperties.weight(), EntityProperties.incomingLinks(), EntityProperties.outgoingLinks(), EntityProperties.bookmark()});
        NodePopupFactory nodePopupFactory = new NodePopupFactory();
        nodePopupFactory.setShowQuickFilter(false);
        this._view.setNodePopupFactory(nodePopupFactory);
        this._view.setDragSource(false);
    }

    public JComponent getVisualRepresentation() {
        return this._panel;
    }

    public JComponent getToolbar() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        OutlineSearchPanel outlineSearchPanel = new OutlineSearchPanel();
        outlineSearchPanel.setOutline(this._view.getOutline());
        outlineSearchPanel.setFilter((TextQuickFilter)new EntityQuickFilter());
        jPanel.add((Component)outlineSearchPanel);
        return jPanel;
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public void prepareToShow() {
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentShowing() {
    }

    public void componentHidden() {
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public void setGraph(D d) {
        this._graph = d;
    }

    public D getGraph() {
        return this._graph;
    }

    public JComponent getViewControl() {
        return this._panel;
    }

    public void setViewCallback(ViewCallback viewCallback) {
        this._cb = viewCallback;
    }

    public ViewCallback getViewCallback() {
        return this._cb;
    }

    public void onGraphUpdated(Set<Y> set, boolean bl) {
    }

    public void addInput(KeyStroke keyStroke, Object object) {
        if (this._view != null) {
            this._view.getInputMap(1).put(keyStroke, object);
            if (this._view.getOutline() != null) {
                this._view.getOutline().getInputMap(1).put(keyStroke, object);
            }
        }
    }

    private class HoverListener
    implements MouseMotionListener,
    MouseListener {
        private HoverListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Object object;
            int n = EntityListView.this._view.getOutline().rowAtPoint(mouseEvent.getPoint());
            Node node = null;
            if (n >= 0 && (object = EntityListView.this._view.getOutline().getValueAt(n, 0)) != null) {
                node = Visualizer.findNode((Object)object);
            }
            GraphHoverContext.instance().setHover(node);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            GraphHoverContext.instance().setHover(null);
        }
    }
}

