resource "azurerm_virtual_machine" "virtual_machine_good_1" {
  name                  = "acctvm"
  location              = "location"
  resource_group_name   = "group"
  network_interface_ids = ["id"]
  vm_size               = "Standard_F2"
  storage_os_disk {
    name          = "myosdisk1"
    caching       = "ReadWrite"
    create_option = "FromImage"
  }
}

resource "azurerm_virtual_machine" "virtual_machine_bad_1" {
  name                  = "acctvm"
  location              = "location"
  resource_group_name   = "group"
  network_interface_ids = ["id"]
  vm_size               = "Standard_F2"
  storage_os_disk {
    name          = "myosdisk1"
    caching       = "ReadWrite"
    create_option = "FromImage"
  }
}

resource "azurerm_virtual_machine" "virtual_machine_bad_2" {
  name                  = "acctvm"
  location              = "location"
  resource_group_name   = "group"
  network_interface_ids = ["id"]
  vm_size               = "Standard_F2"
  storage_os_disk {
    name          = "myosdisk1"
    caching       = "ReadWrite"
    create_option = "FromImage"
  }
}

resource "azurerm_virtual_machine" "virtual_machine_bad_3" {
  name                  = "acctvm"
  location              = "location"
  resource_group_name   = "group"
  network_interface_ids = ["id"]
  vm_size               = "Standard_F2"
  storage_os_disk {
    name          = "myosdisk1"
    caching       = "ReadWrite"
    create_option = "FromImage"
  }
}

resource "azurerm_virtual_machine_extension" "extension_good_1" {
  name                 = "hostname"
  virtual_machine_id   = azurerm_virtual_machine.virtual_machine_good_1.id
  publisher            = "Microsoft.Azure.Security"
  type                 = "IaaSAntimalware"
  type_handler_version = "2.0"
  auto_upgrade_minor_version = true
}

resource "azurerm_virtual_machine_extension" "extension_bad_1" {
  name                 = "hostname"
  virtual_machine_id   = azurerm_virtual_machine.virtual_machine_bad_1.id
  publisher            = "Microsoft.Azure.Extensions"
  type                 = "IaaSAntimalware"
  type_handler_version = "2.0"
  auto_upgrade_minor_version = true
}

resource "azurerm_virtual_machine_extension" "extension_bad_2" {
  name                 = "hostname"
  virtual_machine_id   = azurerm_virtual_machine.virtual_machine_bad_2.id
  publisher            = "Microsoft.Azure.Security"
  type                 = "IaaSAntimalware"
  type_handler_version = "2.0"
  auto_upgrade_minor_version = false
}

resource "azurerm_virtual_machine_extension" "extension_bad_3" {
  name                 = "hostname"
  virtual_machine_id   = azurerm_virtual_machine.virtual_machine_bad_3.id
  publisher            = "Microsoft.Azure.Security"
  type                 = "CustomScript"
  type_handler_version = "2.0"
  auto_upgrade_minor_version = true
}