"use strict";
/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedClient = void 0;
const tslib_1 = require("tslib");
const coreClient = tslib_1.__importStar(require("@azure/core-client"));
const index_js_1 = require("./operations/index.js");
/** @internal */
class GeneratedClient extends coreClient.ServiceClient {
    /**
     * Initializes a new instance of the GeneratedClient class.
     * @param url The URL of the service account or table that is the target of the desired operation.
     * @param options The parameter options
     */
    constructor(url, options) {
        var _a, _b;
        if (url === undefined) {
            throw new Error("'url' cannot be null");
        }
        // Initializing default values for options
        if (!options) {
            options = {};
        }
        const defaults = {
            requestContentType: "application/json; charset=utf-8"
        };
        const packageDetails = `azsdk-js-data-tables/13.1.2`;
        const userAgentPrefix = options.userAgentOptions && options.userAgentOptions.userAgentPrefix
            ? `${options.userAgentOptions.userAgentPrefix} ${packageDetails}`
            : `${packageDetails}`;
        const optionsWithDefaults = Object.assign(Object.assign(Object.assign({}, defaults), options), { userAgentOptions: {
                userAgentPrefix
            }, baseUri: (_b = (_a = options.endpoint) !== null && _a !== void 0 ? _a : options.baseUri) !== null && _b !== void 0 ? _b : "{url}" });
        super(optionsWithDefaults);
        // Parameter assignments
        this.url = url;
        // Assigning values to Constant parameters
        this.version = options.version || "2019-02-02";
        this.table = new index_js_1.TableImpl(this);
        this.service = new index_js_1.ServiceImpl(this);
    }
}
exports.GeneratedClient = GeneratedClient;
//# sourceMappingURL=generatedClient.js.map