/**
 * This is a helper class to construct a string representing the NTFS attributes to a file or directory.
 * @see https://learn.microsoft.com/rest/api/storageservices/create-file#file-system-attributes
 */
export declare class FileSystemAttributes {
    /**
     * Creates a FileSystemAttributes from the specified attributes string. This method will throw an
     * Error if it encounters a string that does not correspond to a valid attributes.
     *
     * @param fileAttributes - The value of header x-ms-file-attributes.
     */
    static parse(fileAttributes: string): FileSystemAttributes;
    /**
     * Specifies a directory or file that is read-only.
     */
    readonly: boolean;
    /**
     * Specifies a directory or file is hidden.
     */
    hidden: boolean;
    /**
     * Specifies a directory or file that the operating system uses a part of, or uses exclusively.
     */
    system: boolean;
    /**
     * Specifies a directory or file that does not have other attributes set. This attribute is valid only when used alone.
     */
    none: boolean;
    /**
     * Specifies the handle identifies a directory.
     */
    directory: boolean;
    /**
     * Specifies a directory or file is an archive. Applications typically use this attribute to mark files for backup or removal.
     */
    archive: boolean;
    /**
     * Specifies if a file is temporary.
     */
    temporary: boolean;
    /**
     * Specifies the data of a directory or file is not available immediately.
     * This file system attribute is presented primarily to provide compatibility with Windows - Azure Files does not support with offline storage options.
     */
    offline: boolean;
    /**
     * Specifies the directory or file is not to be indexed by the content indexing service.
     */
    notContentIndexed: boolean;
    /**
     * Specifies the user data stream not to be read by the background data integrity scanner.
     * This file system attribute is presented primarily to provide compatibility with Windows.
     * Applicable to directory or file.
     */
    noScrubData: boolean;
    /**
     * Converts the given attributes to a string.
     *
     * @returns A string which represents the FileSystemAttributes
     */
    toString(): string;
}
//# sourceMappingURL=FileSystemAttributes.d.ts.map