"use strict";
/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageClient = void 0;
const tslib_1 = require("tslib");
const coreHttpCompat = tslib_1.__importStar(require("@azure/core-http-compat"));
const index_js_1 = require("./operations/index.js");
class StorageClient extends coreHttpCompat.ExtendedServiceClient {
    url;
    version;
    /**
     * Initializes a new instance of the StorageClient class.
     * @param url The URL of the service account, queue or message that is the target of the desired
     *            operation.
     * @param options The parameter options
     */
    constructor(url, options) {
        if (url === undefined) {
            throw new Error("'url' cannot be null");
        }
        // Initializing default values for options
        if (!options) {
            options = {};
        }
        const defaults = {
            requestContentType: "application/json; charset=utf-8"
        };
        const packageDetails = `azsdk-js-azure-storage-queue/12.27.0`;
        const userAgentPrefix = options.userAgentOptions && options.userAgentOptions.userAgentPrefix
            ? `${options.userAgentOptions.userAgentPrefix} ${packageDetails}`
            : `${packageDetails}`;
        const optionsWithDefaults = {
            ...defaults,
            ...options,
            userAgentOptions: {
                userAgentPrefix
            },
            endpoint: options.endpoint ?? options.baseUri ?? "{url}"
        };
        super(optionsWithDefaults);
        // Parameter assignments
        this.url = url;
        // Assigning values to Constant parameters
        this.version = options.version || "2025-07-05";
        this.service = new index_js_1.ServiceImpl(this);
        this.queue = new index_js_1.QueueImpl(this);
        this.messages = new index_js_1.MessagesImpl(this);
        this.messageId = new index_js_1.MessageIdImpl(this);
    }
    service;
    queue;
    messages;
    messageId;
}
exports.StorageClient = StorageClient;
//# sourceMappingURL=storageClient.js.map