/**
 * This is a helper class to construct a string representing the permissions granted by a ServiceSAS to a share.
 * Setting a value to true means that any SAS which uses these permissions will grant permissions for that operation.
 * Once all the values are set, this should be serialized with toString and set as the permissions field on a
 * {@link FileSASSignatureValues} object. It is possible to construct the permissions string without this class, but
 * the order of the permissions is particular and this class guarantees correctness.
 */
export declare class ShareSASPermissions {
    /**
     * Creates an {@link ShareSASPermissions} from the specified permissions string. This method will throw an
     * Error if it encounters a character that does not correspond to a valid permission.
     *
     * @param permissions -
     */
    static parse(permissions: string): ShareSASPermissions;
    /**
     * Specifies Read access granted.
     */
    read: boolean;
    /**
     * Specifies Create access granted.
     */
    create: boolean;
    /**
     * Specifies Write access granted.
     */
    write: boolean;
    /**
     * Specifies Delete access granted.
     */
    delete: boolean;
    /**
     * Specifies List access granted.
     */
    list: boolean;
    /**
     * Converts the given permissions to a string. Using this method will guarantee the permissions are in an
     * order accepted by the service.
     *
     * The order of the characters should be as specified here to ensure correctness.
     * @see https://learn.microsoft.com/rest/api/storageservices/constructing-a-service-sas
     *
     */
    toString(): string;
}
//# sourceMappingURL=ShareSASPermissions.d.ts.map