import { Directory } from "../operationsInterfaces/index.js";
import { StorageClient } from "../storageClient.js";
import { DirectoryCreateOptionalParams, DirectoryCreateResponse, DirectoryGetPropertiesOptionalParams, DirectoryGetPropertiesResponse, DirectoryDeleteOptionalParams, DirectoryDeleteResponse, DirectorySetPropertiesOptionalParams, DirectorySetPropertiesResponse, DirectorySetMetadataOptionalParams, DirectorySetMetadataResponse, DirectoryListFilesAndDirectoriesSegmentOptionalParams, DirectoryListFilesAndDirectoriesSegmentResponse, DirectoryListHandlesOptionalParams, DirectoryListHandlesResponse, DirectoryForceCloseHandlesOptionalParams, DirectoryForceCloseHandlesResponse, DirectoryRenameOptionalParams, DirectoryRenameResponse } from "../models/index.js";
/** Class containing Directory operations. */
export declare class DirectoryImpl implements Directory {
    private readonly client;
    /**
     * Initialize a new instance of the class Directory class.
     * @param client Reference to the service client
     */
    constructor(client: StorageClient);
    /**
     * Creates a new directory under the specified share or parent directory.
     * @param options The options parameters.
     */
    create(options?: DirectoryCreateOptionalParams): Promise<DirectoryCreateResponse>;
    /**
     * Returns all system properties for the specified directory, and can also be used to check the
     * existence of a directory. The data returned does not include the files in the directory or any
     * subdirectories.
     * @param options The options parameters.
     */
    getProperties(options?: DirectoryGetPropertiesOptionalParams): Promise<DirectoryGetPropertiesResponse>;
    /**
     * Removes the specified empty directory. Note that the directory must be empty before it can be
     * deleted.
     * @param options The options parameters.
     */
    delete(options?: DirectoryDeleteOptionalParams): Promise<DirectoryDeleteResponse>;
    /**
     * Sets properties on the directory.
     * @param options The options parameters.
     */
    setProperties(options?: DirectorySetPropertiesOptionalParams): Promise<DirectorySetPropertiesResponse>;
    /**
     * Updates user defined metadata for the specified directory.
     * @param options The options parameters.
     */
    setMetadata(options?: DirectorySetMetadataOptionalParams): Promise<DirectorySetMetadataResponse>;
    /**
     * Returns a list of files or directories under the specified share or directory. It lists the contents
     * only for a single level of the directory hierarchy.
     * @param options The options parameters.
     */
    listFilesAndDirectoriesSegment(options?: DirectoryListFilesAndDirectoriesSegmentOptionalParams): Promise<DirectoryListFilesAndDirectoriesSegmentResponse>;
    /**
     * Lists handles for directory.
     * @param options The options parameters.
     */
    listHandles(options?: DirectoryListHandlesOptionalParams): Promise<DirectoryListHandlesResponse>;
    /**
     * Closes all handles open for given directory.
     * @param handleId Specifies handle ID opened on the file or directory to be closed. Asterisk (‘*’) is
     *                 a wildcard that specifies all handles.
     * @param options The options parameters.
     */
    forceCloseHandles(handleId: string, options?: DirectoryForceCloseHandlesOptionalParams): Promise<DirectoryForceCloseHandlesResponse>;
    /**
     * Renames a directory
     * @param renameSource Required. Specifies the URI-style path of the source file, up to 2 KB in length.
     * @param options The options parameters.
     */
    rename(renameSource: string, options?: DirectoryRenameOptionalParams): Promise<DirectoryRenameResponse>;
}
//# sourceMappingURL=directory.d.ts.map