const async = require('async');
const helpers = require('../../../helpers/azure');

module.exports = {
    title: 'Monitor VM Vulnerability',
    category: 'Security Center',
    domain: 'Management and Governance',
    severity: 'Medium',
    description: 'Ensures that Monitor Vulnerability Assessment is enabled in Security Center.',
    more_info: 'When this setting is enabled, Security Center will monitor virtual machines for detected vulnerabilities.',
    recommended_action: 'Ensure VM Vulnerability monitoring is configured for virtual machines from the Azure Security Center.',
    link: 'https://learn.microsoft.com/en-us/azure/security-center/security-center-policy-definitions',
    apis: ['policyAssignments:list'],
    compliance: {
        pci: 'PCI requires reviewing systems for vulnerabilities on an ongoing basis ' +
            'to protect cardholder data. These requirements include manual or automated ' +
            'vulnerability testing.'
    },
    realtime_triggers: ['microsoftauthorization:policyassignments:write','microsoftauthorization:policyassignments:delete'],

    run: function(cache, settings, callback) {
        const results = [];
        const source = {};
        const locations = helpers.locations(settings.govcloud);

        async.each(locations.policyAssignments, function(location, rcb) {

            const policyAssignments = helpers.addSource(cache, source,
                ['policyAssignments', 'list', location]);

            helpers.checkPolicyAssignment(policyAssignments,
                'vulnerabilityAssesmentMonitoringEffect',
                'Monitor Vulnerability Assessment', results, location);

            rcb();
        }, function() {
            // Global checking goes here
            callback(null, results, source);
        });
    }
};
