/*
  YARA rules generated with peid-userdb-to-yara-rules.py
  https://DidierStevens.com
  Use at your own risk

  File: userdb.txt
  --exclude: exclude.txt
  --eponly: all
  --pe: True
  Generated: 2015/02/15 12:03:34
*/

import "pe"

rule PEiD_00001__EP__ExE_Pack__V1_0____Elite_Coding_Group_
{
    meta:
        description = "[!EP (ExE Pack) V1.0 -> Elite Coding Group]"
        ep_only = "true"
    strings:
        $a = {60 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_00002__EP_ExE_Pack__V1_0____6aHguT___g_l_u_k_
{
    meta:
        description = "[!EP(ExE Pack) V1.0 -> 6aHguT & g-l-u-k]"
        ep_only = "true"
    strings:
        $a = {60 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 6A 40 FF D0 89 05 ?? ?? ?? ?? 89 C7 BE ?? ?? ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41}
    condition:
        $a at pe.entry_point
}

rule PEiD_00003__EP_ExE_Pack__V1_4_lite_b2____6aHguT___g_l_u_k_
{
    meta:
        description = "[!EP(ExE Pack) V1.4 lite b2 -> 6aHguT & g-l-u-k]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45}
    condition:
        $a at pe.entry_point
}

rule PEiD_00004__EP_ExE_Pack__V1_4_lite_final____6aHguT___g_l_u_k_
{
    meta:
        description = "[!EP(ExE Pack) V1.4 lite final -> 6aHguT & g-l-u-k]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 61 B8 ?? ?? ?? ?? FF E0 55 8B EC 60 55 8B 75 08 8B 7D 0C E8 02 00 00 00 EB 04 8B 1C 24 C3 81 C3 00 02 00 00 53 57 8B 07 89 03 83 C7 04 83 C3 04 4E 75 F3 5F 5E FC B2 80 8A 06 46 88 07 47 02 D2 75 05 8A 16 46 12 D2 73 EF 02 D2 75 05 8A 16 46 12}
    condition:
        $a at pe.entry_point
}

rule PEiD_00005__EPack_1_4_lite__final____by_6aHguT_
{
    meta:
        description = "[!EPack 1.4 lite (final) - by 6aHguT]"
        ep_only = "true"
    strings:
        $a = {33 C0 8B C0 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00006__EPack_V1_4_lite_final____6aHguT_
{
    meta:
        description = "[!EPack V1.4 lite final -> 6aHguT]"
        ep_only = "true"
    strings:
        $a = {33 C0 8B C0 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00007__pirit_v1_5_
{
    meta:
        description = "[$pirit v1.5]"
        ep_only = "true"
    strings:
        $a = {?? ?? ?? 5B 24 55 50 44 FB 32 2E 31 5D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00008___PseudoSigner_0_2__Yoda_s_Protector_1_02______Anorganix_
{
    meta:
        description = "[* PseudoSigner 0.2 [Yoda's Protector 1.02] --> Anorganix]"
        ep_only = "true"
    strings:
        $a = {E8 03 00 00 00 EB 01 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_00009__BJFnt_v1_1b_
{
    meta:
        description = "[.BJFnt v1.1b]"
        ep_only = "true"
    strings:
        $a = {EB 01 EA 9C EB 01 EA 53 EB 01 EA 51 EB 01 EA 52 EB 01 EA 56}
    condition:
        $a at pe.entry_point
}

rule PEiD_00010__BJFnt_v1_2_RC_
{
    meta:
        description = "[.BJFnt v1.2 RC]"
        ep_only = "true"
    strings:
        $a = {EB 02 69 B1 83 EC 04 EB 03 CD 20 EB EB 01 EB 9C EB 01 EB EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00011__BJFnt_v1_3_
{
    meta:
        description = "[.BJFnt v1.3]"
        ep_only = "true"
    strings:
        $a = {EB 03 3A 4D 3A 1E EB 02 CD 20 9C EB 02 CD 20 EB 02 CD 20 60}
    condition:
        $a at pe.entry_point
}

rule PEiD_00012__BJFnt_v1_3_
{
    meta:
        description = "[.BJFnt v1.3]"
        ep_only = "true"
    strings:
        $a = {EB ?? 3A ?? ?? 1E EB ?? CD 20 9C EB ?? CD 20 EB ?? CD 20 60 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00013__NET_DLL____Microsoft_
{
    meta:
        description = "[.NET DLL -> Microsoft]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 5F 43 6F 72 44 6C 6C 4D 61 69 6E 00 6D 73 63 6F 72 65 65 2E 64 6C 6C 00 00 ?? 00 00 FF 25}
    condition:
        $a
}

rule PEiD_00014__NET_executable____Microsoft_
{
    meta:
        description = "[.NET executable -> Microsoft]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 5F 43 6F 72 45 78 65 4D 61 69 6E 00 6D 73 63 6F 72 65 65 2E 64 6C 6C 00 00 00 00 00 FF 25}
    condition:
        $a
}

rule PEiD_00015__NET_executable_
{
    meta:
        description = "[.NET executable]"
        ep_only = "true"
    strings:
        $a = {FF 25 00 20 40 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00016_32Lite_v0_03a_
{
    meta:
        description = "[32Lite v0.03a]"
        ep_only = "true"
    strings:
        $a = {60 06 FC 1E 07 BE ?? ?? ?? ?? 6A 04 68 ?? 10 ?? ?? 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_00017_3DMark_Database_file_
{
    meta:
        description = "[3DMark Database file]"
        ep_only = "false"
    strings:
        $a = {33 44 4D 61 72 6B 20 44 61 74 61 62 61 73 65 20 46 69 6C 65}
    condition:
        $a
}

rule PEiD_00018_624__Six_to_Four__v1_0_
{
    meta:
        description = "[624 (Six to Four) v1.0]"
        ep_only = "true"
    strings:
        $a = {50 55 4C 50 83 ?? ?? FC BF ?? ?? BE ?? ?? B5 ?? 57 F3 A5 C3 33 ED}
    condition:
        $a at pe.entry_point
}

rule PEiD_00019__MSLRH__v32a____emadicius_
{
    meta:
        description = "[[MSLRH] v32a -> emadicius]"
        ep_only = "true"
    strings:
        $a = {EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31}
    condition:
        $a at pe.entry_point
}

rule PEiD_00020_A_program_by_Jupiter____
{
    meta:
        description = "[A program by Jupiter ..]"
        ep_only = "true"
    strings:
        $a = {2B C0 74 05 68 ?? ?? ?? ?? 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_00021_A3E__TXT2COM__
{
    meta:
        description = "[A3E (TXT2COM)]"
        ep_only = "true"
    strings:
        $a = {1E 33 C0 50 BE ?? ?? 81 C6 ?? ?? B8 ?? ?? 8E C0 BF ?? ?? B9 ?? ?? F3 A5 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00022_Aase_Crypter___by_santasdad_
{
    meta:
        description = "[Aase Crypter - by santasdad]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 B8 A0 3E 00 10 E8 93 DE FF FF 68 F8 42 00 10 E8 79 DF FF FF 68 00 43 00 10 68 0C 43 00 10 E8 42 DF FF FF 50 E8 44 DF FF FF A3 98 66 00 10 83 3D 98 66 00 10 00 75 13 6A 00 68 18 43 00 10 68 1C 43 00 10 6A 00 E8 4B DF FF FF 68 2C 43 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00023_Aase_Crypter___by_santasdad_
{
    meta:
        description = "[Aase Crypter - by santasdad]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 B8 A0 3E 00 10 E8 93 DE FF FF 68 F8 42 00 10 E8 79 DF FF FF 68 00 43 00 10 68 0C 43 00 10 E8 42 DF FF FF 50 E8 44 DF FF FF A3 98 66 00 10 83 3D 98 66 00 10 00 75 13 6A 00 68 18 43 00 10 68 1C 43 00 10 6A 00 E8 4B DF FF FF 68 2C 43 00 10 68 0C 43 ?? ?? ?? ?? DF FF FF 50 E8 0E DF FF FF A3 94 66 00 10 83 3D 94 66 00 10 00 75 13 6A 00 68 18 43 00 10 68 38 43 00 10 6A 00 E8 15 DF FF FF 68 48 43 00 10 68 0C 43 00 10 E8 D6 DE FF FF 50 E8 D8 DE FF FF A3 A0 66 00 10 83 3D A0 66 00 10 00 75 13 6A 00 68 18 43 00 10 68 58 43 00 10 6A 00 E8 DF DE FF FF 68 6C 43 00 10 68 0C 43 00 10 E8 A0 DE FF FF 50 E8 A2 DE FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00024_ABC_Cryptor_1_0___by_ZloY_
{
    meta:
        description = "[ABC Cryptor 1.0 - by ZloY]"
        ep_only = "true"
    strings:
        $a = {68 FF 64 24 F0 68 58 58 58 58 90 FF D4 50 8B 40 F2 05 B0 95 F6 95 0F 85 01 81 BB FF 68 ?? ?? ?? ?? BF 00 ?? ?? ?? B9 00 ?? ?? ?? 80 37 ?? 47 39 CF 75 F8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00025_ACE_Archive_
{
    meta:
        description = "[ACE Archive]"
        ep_only = "false"
    strings:
        $a = {?? ?? ?? ?? ?? ?? ?? 2A 2A 41 43 45 2A 2A}
    condition:
        $a
}

rule PEiD_00026_AcidCrypt_
{
    meta:
        description = "[AcidCrypt]"
        ep_only = "true"
    strings:
        $a = {60 B9 ?? ?? ?? 00 BA ?? ?? ?? 00 BE ?? ?? ?? 00 02 38 40 4E 75 FA 8B C2 8A 18 32 DF C0 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00027_AcidCrypt_
{
    meta:
        description = "[AcidCrypt]"
        ep_only = "true"
    strings:
        $a = {BE ?? ?? ?? ?? 02 38 40 4E 75 FA 8B C2 8A 18 32 DF C0 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00028_ACProtect_1_09g____Risco_software_Inc__
{
    meta:
        description = "[ACProtect 1.09g -> Risco software Inc.]"
        ep_only = "true"
    strings:
        $a = {60 F9 50 E8 01 00 00 00 7C 58 58 49 50 E8 01 00 00 00 7E 58 58 79 04 66 B9 B8 72 E8 01 00 00 00 7A 83 C4 04 85 C8 EB 01 EB C1 F8 BE 72 03 73 01 74 0F 81 01 00 00 00 F9 EB 01 75 F9 E8 01 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00029_ACProtect_1_4x____RISCO_soft_
{
    meta:
        description = "[ACProtect 1.4x -> RISCO soft]"
        ep_only = "false"
    strings:
        $a = {47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 90 4D 69 6E 65 49 6D 70}
    condition:
        $a
}

rule PEiD_00030_ACProtect_1_4x____RISCO_soft_
{
    meta:
        description = "[ACProtect 1.4x -> RISCO soft]"
        ep_only = "false"
    strings:
        $a = {47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 90 4D 69 6E 65 49 6D 70 6F 72 74 5F 45 6E 64 73 73 00}
    condition:
        $a
}

rule PEiD_00031_ACProtect_V1_3X____risco_
{
    meta:
        description = "[ACProtect V1.3X -> risco]"
        ep_only = "true"
    strings:
        $a = {60 50 E8 01 00 00 00 75 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_00032_ACProtect_v1_41_
{
    meta:
        description = "[ACProtect v1.41]"
        ep_only = "true"
    strings:
        $a = {60 76 03 77 01 7B 74 03 75 01 78 47 87 EE E8 01 00 00 00 76 83 C4 04 85 EE EB 01 7F 85 F2 EB 01 79 0F 86 01 00 00 00 FC EB 01 78 79 02 87 F2 61 51 8F 05 19 38 01 01 60 EB 01 E9 E9 01 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00033_ACProtect_V1_4X____risco_
{
    meta:
        description = "[ACProtect V1.4X -> risco]"
        ep_only = "true"
    strings:
        $a = {60 E8 01 00 00 00 7C 83 04 24 06 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00034_ACProtect_v1_90g____Risco_software_Inc__
{
    meta:
        description = "[ACProtect v1.90g -> Risco software Inc.]"
        ep_only = "true"
    strings:
        $a = {60 0F 87 02 00 00 00 1B F8 E8 01 00 00 00 73 83 04 24 06 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00035_ACProtect_UltraProtect_1_0X_2_0X____RiSco_
{
    meta:
        description = "[ACProtect/UltraProtect 1.0X-2.0X -> RiSco]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00036_ACProtect_UltraProtect_1_0X_2_0X____RiSco_
{
    meta:
        description = "[ACProtect/UltraProtect 1.0X-2.0X -> RiSco]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 55 53 45 52 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 90 4D 69 6E 65 49 6D 70 6F 72 74 5F 45 6E 64 73 73 00}
    condition:
        $a
}

rule PEiD_00037_ActiveMARK_5_x____Trymedia_Systems_Inc___h__
{
    meta:
        description = "[ActiveMARK 5.x -> Trymedia Systems Inc. (h)]"
        ep_only = "false"
    strings:
        $a = {20 2D 2D 4D 50 52 4D 4D 47 56 41 2D 2D 00 75 73 65 72 33 32 2E 64 6C 6C 00 4D 65 73 73 61 67 65 42 6F 78 41 00 54 68 69 73 20 61 70 70 6C 69 63 61 74 69 6F 6E 20 63 61 6E 6E 6F 74 20 72 75 6E 20 77 69 74 68 20 61 6E 20 61 63 74 69 76 65 20 64 65 62 75 67}
    condition:
        $a
}

rule PEiD_00038_ActiveMARK_5_x____Trymedia_Systems_Inc___h__
{
    meta:
        description = "[ActiveMARK 5.x -> Trymedia Systems,Inc. (h)]"
        ep_only = "false"
    strings:
        $a = {20 2D 2D 4D 50 52 4D 4D 47 56 41 2D 2D 00 75 73 65 72 33 32 2E 64 6C 6C 00 4D 65 73 73 61 67 65 42 6F 78 41 00 54 68 69 73 20 61 70 70 6C 69 63 61 74 69 6F 6E 20 63 61 6E 6E 6F 74 20 72 75 6E 20 77 69 74 68 20 61 6E 20 61 63 74 69 76 65 20 64 65 62 75 67 67 65 72 20 69 6E 20 6D 65 6D 6F 72 79 2E 0D 0A 50 6C 65 61 73 65 20 75 6E 6C 6F 61 64 20 74 68 65 20 64 65 62 75 67 67 65 72 20 61 6E 64 20 72 65 73 74 61 72 74 20 74 68 65 20 61 70 70 6C 69 63 61 74 69 6F 6E 2E 00 57 61 72 6E 69 6E 67}
    condition:
        $a
}

rule PEiD_00039_ActiveMARK_TM_
{
    meta:
        description = "[ActiveMARK[TM]"
        ep_only = "true"
    strings:
        $a = {79 11 7F AB 9A 4A 83 B5 C9 6B 1A 48 F9 27 B4 25}
    condition:
        $a at pe.entry_point
}

rule PEiD_00040_AdFlt2_
{
    meta:
        description = "[AdFlt2]"
        ep_only = "true"
    strings:
        $a = {68 00 01 9C 0F A0 0F A8 60 FD 6A 00 0F A1 BE ?? ?? AD}
    condition:
        $a at pe.entry_point
}

rule PEiD_00041_Adlib_Sample_Audio_file_
{
    meta:
        description = "[Adlib Sample Audio file]"
        ep_only = "false"
    strings:
        $a = {47 4F 4C 44 20 53 41 4D 50 4C 45}
    condition:
        $a
}

rule PEiD_00042_Ady_s_Glue_1_10_
{
    meta:
        description = "[Ady's Glue 1.10]"
        ep_only = "true"
    strings:
        $a = {2E ?? ?? ?? ?? 0E 1F BF ?? ?? 33 DB 33 C0 AC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00043_Ady_s_Glue_v0_10_
{
    meta:
        description = "[Ady`s Glue v0.10]"
        ep_only = "true"
    strings:
        $a = {2E 8C 06 ?? ?? 0E 07 33 C0 8E D8 BE ?? ?? BF ?? ?? FC B9 ?? ?? 56 F3 A5 1E 07 5F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00044_AHpack_0_1____FEUERRADER__h__
{
    meta:
        description = "[AHpack 0.1 -> FEUERRADER (h)]"
        ep_only = "true"
    strings:
        $a = {60 68 54 ?? ?? ?? B8 48 ?? ?? ?? FF 10 68 B3 ?? ?? ?? 50 B8 44 ?? ?? ?? FF 10 68 00 ?? ?? ?? 6A 40 FF D0 89 05 CA ?? ?? ?? 89 C7 BE 00 10 ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 89 E8 B3 01 56 89 FE 29 C6 F3 A4 5E EB 8E 00 D2 75 05 8A 16 46 10 D2 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00045_AHPack_0_1____FEUERRADER_
{
    meta:
        description = "[AHPack 0.1 -> FEUERRADER]"
        ep_only = "true"
    strings:
        $a = {60 68 54 ?? ?? 00 B8 48 ?? ?? 00 FF 10 68 B3 ?? ?? 00 50 B8 44 ?? ?? 00 FF 10 68 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00046_AHpack_0_1____FEUERRADER_
{
    meta:
        description = "[AHpack 0.1 -> FEUERRADER]"
        ep_only = "true"
    strings:
        $a = {60 68 54 ?? ?? ?? B8 48 ?? ?? ?? FF 10 68 B3 ?? ?? ?? 50 B8 44 ?? ?? ?? FF 10 68 00 ?? ?? ?? 6A 40 FF D0 89 05 CA ?? ?? ?? 89 C7 BE 00 10 ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41}
    condition:
        $a at pe.entry_point
}

rule PEiD_00047_AINEXE_v2_1_
{
    meta:
        description = "[AINEXE v2.1]"
        ep_only = "true"
    strings:
        $a = {A1 ?? ?? 2D ?? ?? 8E D0 BC ?? ?? 8C D8 36 A3 ?? ?? 05 ?? ?? 36 A3 ?? ?? 2E A1 ?? ?? 8A D4 B1 04 D2 EA FE C9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00048_AINEXE_v2_30_
{
    meta:
        description = "[AINEXE v2.30]"
        ep_only = "true"
    strings:
        $a = {0E 07 B9 ?? ?? BE ?? ?? 33 FF FC F3 A4 A1 ?? ?? 2D ?? ?? 8E D0 BC ?? ?? 8C D8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00049_Alex_Protector_0_4_beta_1_by_Alex_
{
    meta:
        description = "[Alex Protector 0.4 beta 1 by Alex]"
        ep_only = "false"
    strings:
        $a = {60 E8 01 00 00 00 C7 83 C4 04 33 C9 E8 01 00 00 00 68 83 C4 04 E8 01 00 00 00 68 83 C4 04 B9 ?? 00 00 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 01 00 00 00 C7 83 C4 04 8B 2C 24 83 C4 04 E8 01 00 00 00 A9 83 C4 04 81 ED 3C 13 40 00 E8 01 00 00 00 68}
    condition:
        $a
}

rule PEiD_00050_Alex_Protector_1_0____Alex_
{
    meta:
        description = "[Alex Protector 1.0 -> Alex]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 10 40 00 E8 24 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00051_Alex_Protector_1_0_beta_2_by_Alex_
{
    meta:
        description = "[Alex Protector 1.0 beta 2 by Alex]"
        ep_only = "false"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 10 40 00 E8 24 00 00 00 EB 01 E9 8B 44 24 0C EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 83 80 B8 00 00 00 02 33 C0 EB 01 E9 C3 58 83 C4 04 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 50 64 FF 35 00 00 00 00 64 89 25}
    condition:
        $a
}

rule PEiD_00052_Alex_Protector_1_0_beta_2_by_Alex_
{
    meta:
        description = "[Alex Protector 1.0 beta 2 by Alex]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 10 40 00 E8 24 00 00 00 EB 01 E9 8B 44 24 0C EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 83 80 B8 00 00 00 02 33 C0 EB 01 E9 C3 58 83 C4 04 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 EB 01 E9 FF FF 60 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 0F 31 8B D8 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 8B CA EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 0F 31 2B C3 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 1B D1 0F 31 03 C3 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 13 D1 0F 31 2B C3 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 EB 05 68 F0 0F C7 C8 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 1B D1 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_00053_Alex_Protector_v0_4_beta_1_by_Alex_
{
    meta:
        description = "[Alex Protector v0.4 beta 1 by Alex]"
        ep_only = "true"
    strings:
        $a = {60 E8 01 00 00 00 C7 83 C4 04 33 C9 E8 01 00 00 00 68 83 C4 04 E8 01 00 00 00 68 83 C4 04 B9 ?? 00 00 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 01 00 00 00 C7 83 C4 04 8B 2C 24 83 C4 04 E8 01 00 00 00 A9 83 C4 04 81 ED 3C 13 40 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 00 00 00 00 49 E8 01 00 00 00 68 83 C4 04 85 C9 75 DF E8 B9 02 00 00 E8 01 00 00 00 C7 83 C4 04 8D 95 63 14 40 00 E8 01 00 00 00 C7 83 C4 04 90 90 90 E8 CA 01 00 00 01 02 03 04 05 68 90 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00054_Alex_Protector_v1_0____Alex_
{
    meta:
        description = "[Alex Protector v1.0 -> Alex]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 10 40 00 E8 24 00 00 00 EB 01 E9 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00055_Alias_PIX_Vivid_IMG_Graphics_format_
{
    meta:
        description = "[Alias PIX/Vivid IMG Graphics format]"
        ep_only = "false"
    strings:
        $a = {?? ?? ?? ?? 00 00 ?? ?? 00 18 ?? ?? ?? ?? 01}
    condition:
        $a
}

rule PEiD_00056_Alloy_4_x____PGWare_LLC_
{
    meta:
        description = "[Alloy 4.x -> PGWare LLC]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 30 40 00 87 DD 6A 04 68 00 10 00 00 68 00 02 00 00 6A 00 FF 95 A8 33 40 00 0B C0 0F 84 F6 01 00 00 89 85 2E 33 40 00 83 BD E8 32 40 00 01 74 0D 83 BD E4 32 40 00 01 74 2A 8B F8 EB 3E 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_00057_Alloy_4_x____PGWare_LLC_
{
    meta:
        description = "[Alloy 4.x -> PGWare LLC]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 30 40 00 87 DD 6A 04 68 00 10 00 00 68 00 02 00 00 6A 00 FF 95 A8 33 40 00 0B C0 0F 84 F6 01 00 00 89 85 2E 33 40 00 83 BD E8 32 40 00 01 74 0D 83 BD E4 32 40 00 01 74 2A 8B F8 EB 3E 68 D8 01 00 00 50 FF 95 CC 33 40 00 50 8D 85 28 33 40 00 50 FF B5 2E 33 40 00 FF 95 D0 33 40 00 58 83 C0 05 EB 0C 68 D8 01 00 00 50 FF 95 C0 33 40 00 8B BD 2E 33 40 00 03 F8 C6 07 5C 47 8D B5 00 33 40 00 AC 0A C0 74 03 AA EB F8 83 BD DC 32 40 00 01 74 7A 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 FF B5 2E 33 40 00 FF 95 B4 33 40 00 83 F8 FF 74 57 89 85 32 33 40 00 8D 85 56 33 40 00 8D 9D 5E 33 40 00 8D 8D 66 33 40 00 51 53 50 FF B5 32 33 40 00 FF 95 C4 33 40 00 FF B5 32 33 40 00 FF 95 B8 33 40 00 8B 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_00058_Alloy_v1_x_2000_
{
    meta:
        description = "[Alloy v1.x.2000]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 20 40 ?? 87 DD 6A 04 68 ?? 10 ?? ?? 68 ?? 02 ?? ?? 6A ?? FF 95 46 23 40 ?? 0B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00059_Aluwain_v8_09_
{
    meta:
        description = "[Aluwain v8.09]"
        ep_only = "true"
    strings:
        $a = {8B EC 1E E8 ?? ?? 9D 5E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00060_Amiga_AIFF_8SFX_Audio_file_
{
    meta:
        description = "[Amiga AIFF 8SFX Audio file]"
        ep_only = "false"
    strings:
        $a = {46 4F 52 4D ?? ?? ?? ?? 38 53 56 58 56 48 44 52}
    condition:
        $a
}

rule PEiD_00061_Amiga_IFF_ILBM_Graphics_format_
{
    meta:
        description = "[Amiga IFF/ILBM Graphics format]"
        ep_only = "false"
    strings:
        $a = {46 4F 52 4D ?? ?? ?? ?? 49 4C 42 4D 42 4D 48 44}
    condition:
        $a
}

rule PEiD_00062_ANDpakk2_0_06___by_Dmitry__AND__Andreev_
{
    meta:
        description = "[ANDpakk2 0.06 - by Dmitry \"AND\" Andreev]"
        ep_only = "true"
    strings:
        $a = {60 FC BE D4 00 40 00 BF 00 10 00 01 57 83 CD FF 33 C9 F9 EB 05 A4 02 DB 75 05 8A 1E 46 12 DB 72 F4 33 C0 40 02 DB 75 05 8A 1E 46 12 DB 13 C0 02 DB 75 05 8A 1E 46 12 DB 72 0E 48 02 DB 75 05 8A 1E 46 12 DB 13 C0 EB DC 83 E8 03 72 0F C1 E0 08 AC 83 F0 FF 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_00063_ANDpakk2_0_06___by_Dmitry__quot_AND_quot__Andreev_
{
    meta:
        description = "[ANDpakk2 0.06 - by Dmitry &quot;AND&quot; Andreev]"
        ep_only = "true"
    strings:
        $a = {60 FC BE D4 00 40 00 BF 00 10 00 01 57 83 CD FF 33 C9 F9 EB 05 A4 02 DB 75 05 8A 1E 46 12 DB 72 F4 33 C0 40 02 DB 75 05 8A 1E 46 12 DB 13 C0 02 DB 75 05 8A 1E 46 12 DB 72 0E 48 02 DB 75 05 8A 1E 46 12 DB 13 C0 EB DC 83 E8 03 72 0F C1 E0 08 AC 83 F0 FF 74 4D D1 F8 8B E8 EB 09 02 DB 75 05 8A 1E 46 12 DB 13 C9 02 DB 75 05 8A 1E 46 12 DB 13 C9 75 1A 41 02 DB 75 05 8A 1E 46 12 DB 13 C9 02 DB 75 05 8A 1E 46 12 DB 73 EA 83 C1 02 81 FD 00 FB FF FF 83 D1 01 56 8D 34 2F F3 A4 5E E9 73 FF FF FF C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00064_ANDpakk2_0_18___by_Dmitry__quot_AND_quot__Andreev_
{
    meta:
        description = "[ANDpakk2 0.18 - by Dmitry &quot;AND&quot; Andreev]"
        ep_only = "true"
    strings:
        $a = {FC BE D4 00 40 00 BF 00 ?? ?? 00 57 83 CD FF 33 C9 F9 EB 05 A4 02 DB 75 05 8A 1E 46 12 DB 72 F4 33 C0 40 02 DB 75 05 8A 1E 46 12 DB 13 C0 02 DB 75 05 8A 1E 46 12 DB 72 0E 48 02 DB 75 05 8A 1E 46 12 DB 13 C0 EB DC 83 E8 03 72 0F C1 E0 08 AC 83 F0 FF 74 4D D1 F8 8B E8 EB 09 02 DB 75 05 8A 1E 46 12 DB 13 C9 02 DB 75 05 8A 1E 46 12 DB 13 C9 75 1A 41 02 DB 75 05 8A 1E 46 12 DB 13 C9 02 DB 75 05 8A 1E 46 12 DB 73 EA 83 C1 02 81 FD 00 FB FF FF 83 D1 01 56 8D 34 2F F3 A4 5E E9 73 FF FF FF C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00065_Anskya_Binder_v1_1____Anskya_
{
    meta:
        description = "[Anskya Binder v1.1 -> Anskya]"
        ep_only = "true"
    strings:
        $a = {BE ?? ?? ?? 00 BB F8 11 40 00 33 ED 83 EE 04 39 2E 74 11}
    condition:
        $a at pe.entry_point
}

rule PEiD_00066_Anskya_NTPacker_Generator____Anskya_
{
    meta:
        description = "[Anskya NTPacker Generator -> Anskya]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 B8 88 1D 00 10 E8 C7 FA FF FF 6A 0A 68 20 1E 00 10 A1 14 31 00 10 50 E8 71 FB FF FF 8B D8 85 DB 74 2F 53 A1 14 31 00 10 50 E8 97 FB FF FF 85 C0 74 1F 53 A1 14 31 00 10 50 E8 5F FB FF FF 85 C0 74 0F 50 E8 5D FB FF FF 85 C0 74 05 E8 70}
    condition:
        $a at pe.entry_point
}

rule PEiD_00067_Anskya_NTPacker_Generator____Anskya_
{
    meta:
        description = "[Anskya NTPacker Generator -> Anskya]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 B8 88 1D 00 10 E8 C7 FA FF FF 6A 0A 68 20 1E 00 10 A1 14 31 00 10 50 E8 71 FB FF FF 8B D8 85 DB 74 2F 53 A1 14 31 00 10 50 E8 97 FB FF FF 85 C0 74 1F 53 A1 14 31 00 10 50 E8 5F FB FF FF 85 C0 74 0F 50 E8 5D FB FF FF 85 C0 74 05 E8 70 FC FF FF 5B E8 F2 F6 FF FF 00 00 48 45 41 52 54}
    condition:
        $a at pe.entry_point
}

rule PEiD_00068_Anslym_Crypter_
{
    meta:
        description = "[Anslym Crypter]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 56 B8 38 17 05 10 E8 5A 45 FB FF 33 C0 55 68 21 1C 05 10 64 FF 30 64 89 20 EB 08 FC FC FC FC FC FC 27 54 E8 85 4C FB FF 6A 00 E8 0E 47 FB FF 6A 0A E8 27 49 FB FF E8 EA 47 FB FF 6A 0A 68 30 1C 05 10 A1 60 56 05 10 50 E8 68 47 FB FF 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00069_Anslym_Crypter_
{
    meta:
        description = "[Anslym Crypter]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 56 B8 38 17 05 10 E8 5A 45 FB FF 33 C0 55 68 21 1C 05 10 64 FF 30 64 89 20 EB 08 FC FC FC FC FC FC 27 54 E8 85 4C FB FF 6A 00 E8 0E 47 FB FF 6A 0A E8 27 49 FB FF E8 EA 47 FB FF 6A 0A 68 30 1C 05 10 A1 60 56 05 10 50 E8 68 47 FB FF 8B D8 85 DB 0F 84 B6 02 00 00 53 A1 60 56 05 10 50 E8 F2 48 FB FF 8B F0 85 F6 0F 84 A0 02 00 00 E8 F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00070_Anslym_FUD_Crypter___Sign_by_fly_
{
    meta:
        description = "[Anslym FUD Crypter ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 56 B8 38 17 05 10 E8 5A 45 FB FF 33 C0 55 68 21 1C 05 10 64 FF 30 64 89 20 EB 08 FC FC FC FC FC FC 27 54 E8 85 4C FB FF 6A 00 E8 0E 47 FB FF 6A 0A E8 27 49 FB FF E8 EA 47 FB FF 6A 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_00071_Anti007____NsPacK_Private_
{
    meta:
        description = "[Anti007 -> NsPacK Private]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 10 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00072_Anti007_V1_0_V2_X____NsPacK_Private_
{
    meta:
        description = "[Anti007 V1.0-V2.X -> NsPacK Private]"
        ep_only = "true"
    strings:
        $a = {00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 45 78 69 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_00073_Anti007_V2_5_V2_6____NsPacK_Private_
{
    meta:
        description = "[Anti007 V2.5-V2.6 -> NsPacK Private]"
        ep_only = "true"
    strings:
        $a = {00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 53}
    condition:
        $a at pe.entry_point
}

rule PEiD_00074_Anti007_V2_6____LiuXingPing___Sign_by_fly_
{
    meta:
        description = "[Anti007 V2.6 -> LiuXingPing ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 53 79 73 74 65 6D 44 69 72 65 63 74 6F 72 79 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 57 72 69 74 65 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00}
    condition:
        $a
}

rule PEiD_00075_Anti007_V2_7_V3_5____NsPacK_Private_
{
    meta:
        description = "[Anti007 V2.7-V3.5 -> NsPacK Private]"
        ep_only = "true"
    strings:
        $a = {00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 54}
    condition:
        $a at pe.entry_point
}

rule PEiD_00076_Anticrack_Software_Protector_v1_09__ACProtect__
{
    meta:
        description = "[Anticrack Software Protector v1.09 (ACProtect)]"
        ep_only = "true"
    strings:
        $a = {60 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 83 04 24 06 C3 ?? ?? ?? ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00077_AntiDote_1_0_Beta____SIS_Team_
{
    meta:
        description = "[AntiDote 1.0 Beta -> SIS-Team]"
        ep_only = "true"
    strings:
        $a = {E8 BB FF FF FF 84 C0 74 2F 68 04 01 00 00 68 C0 23 60 00 6A 00 FF 15 08 10 60 00 E8 40 FF FF FF 50 68 78 11 60 00 68 68 11 60 00 68 C0 23 60 00 E8 AB FD FF FF 83 C4 10 33 C0 C2 10 00 90 90 90 8B 4C 24 08 56 8B 74 24 08 33 D2 8B C6 F7 F1 8B C6 85 D2 74 08 33 D2 F7 F1 40 0F AF C1 5E C3 90 8B 44 24 04 53 55 56 8B 48 3C 57 03 C8 33 D2 8B 79 54 8B 71 38 8B C7 F7 F6 85 D2 74 0C 8B C7 33 D2 F7 F6 8B F8 47 0F AF FE 33 C0 33 DB 66 8B 41 14 8D 54 08 18 33 C0 66 8B 41 06 89 54 24 14 8D 68 FF 85 ED 7C 37 33 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00078_AntiDote_1_0_beta____Spy_Instructor_
{
    meta:
        description = "[AntiDote 1.0 beta -> Spy Instructor]"
        ep_only = "true"
    strings:
        $a = {E8 BB FF FF FF 84 C0 74 2F 68 04 01 00 00 68 C0 23 60 00 6A 00 FF 15 08 10 60 00 E8 40 FF FF FF 50 68 78 11 60 00 68 68 11 60 00 68 C0 23 60 00 E8 AB FD FF FF 83 C4 10 33 C0 C2 10 00 90 90 90 8B 4C 24 08 56 8B 74 24 08 33 D2 8B C6 F7 F1 8B C6 85 D2 74 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_00079_AntiDote_1_0_beta____Spy_Instructor_
{
    meta:
        description = "[AntiDote 1.0 beta -> Spy Instructor]"
        ep_only = "true"
    strings:
        $a = {E8 BB FF FF FF 84 C0 74 2F 68 04 01 00 00 68 C0 23 60 00 6A 00 FF 15 08 10 60 00 E8 40 FF FF FF 50 68 78 11 60 00 68 68 11 60 00 68 C0 23 60 00 E8 AB FD FF FF 83 C4 10 33 C0 C2 10 00 90 90 90 8B 4C 24 08 56 8B 74 24 08 33 D2 8B C6 F7 F1 8B C6 85 D2 74 08 33 D2 F7 F1 40 0F AF C1 5E C3 90 8B 44 24 04 53 55 56 8B 48 3C 57 03 C8 33 D2 8B 79 54 8B 71 38 8B C7 F7 F6 85 D2 74 0C 8B C7 33 D2 F7 F6 8B F8 47 0F AF FE 33 C0 33 DB 66 8B 41 14 8D 54 08 18 33 C0 66 8B 41 06 89 54 24 14 8D 68 FF 85 ED 7C 37 33 C0 8B 4C 24 14 8D 04 80 8B 4C C1 08 85 C9 74 1A 8B C1 33 D2 F7 F6 85 D2 75 04 03 F9 EB 0C 8B C1 33 D2 F7 F6 40 0F AF C6 03 F8 43 8B C3 25 FF FF 00 00 3B C5 7E CB 8B C7 5F 5E 5D 5B C3 90 90 90 90 90 90 90 90 90 90 90 90 55 8B EC 6A FF 68 50 22 60 00 64 A1 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00080_AntiDote_1_0_Demo___1_2____SIS_Team_
{
    meta:
        description = "[AntiDote 1.0 Demo / 1.2 -> SIS-Team]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 09 01 47 65 74 43 6F 6D 6D 61 6E 64 4C 69 6E 65 41 00 DB 01 47 65 74 56 65 72 73 69 6F 6E 45 78 41 00 73 01 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 00 7A 03 57 61 69 74 46 6F 72 53 69 6E 67 6C 65 4F 62 6A 65 63 74 00 BF 02 52 65 73 75 6D 65 54 68 72 65 61 64 00 00 29 03 53 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 94 03 57 72 69 74 65 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 00 6B 03 56 69 72 74 75 61 6C 41 6C 6C 6F 63 45 78 00 00 A6 02 52 65 61 64 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 CA 01 47 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 62 00 43 72 65 61 74 65 50 72 6F 63 65 73 73 41 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C}
    condition:
        $a
}

rule PEiD_00081_AntiDote_1_0_Demo____SIS_Team_
{
    meta:
        description = "[AntiDote 1.0.Demo -> SIS-Team]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 09 01 47 65 74 43 6F 6D 6D 61 6E 64 4C 69 6E 65 41 00 DB 01 47 65 74 56 65 72 73 69 6F 6E 45 78 41 00 73 01 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 00 7A 03 57 61 69 74 46 6F 72 53 69 6E 67 6C 65 4F 62 6A 65 63 74 00 BF 02 52}
    condition:
        $a at pe.entry_point
}

rule PEiD_00082_AntiDote_1_0_Demo____SIS_Team_
{
    meta:
        description = "[AntiDote 1.0.Demo -> SIS-Team]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 09 01 47 65 74 43 6F 6D 6D 61 6E 64 4C 69 6E 65 41 00 DB 01 47 65 74 56 65 72 73 69 6F 6E 45 78 41 00 73 01 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 00 7A 03 57 61 69 74 46 6F 72 53 69 6E 67 6C 65 4F 62 6A 65 63 74 00 BF 02 52 65 73 75 6D 65 54 68 72 65 61 64 00 00 29 03 53 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 94 03 57 72 69 74 65 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 00 6B 03 56 69 72 74 75 61 6C 41 6C 6C 6F 63 45 78 00 00 A6 02 52 65 61 64 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 CA 01 47 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 62 00 43 72 65 61 74 65 50 72 6F 63 65 73 73 41 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 DC 01 4D 65 73 73 61 67 65 42 6F 78 41 00 26 00 43 68 61 72 4C 6F 77 65 72 41 00 00 55 53 45 52 33 32 2E 64 6C 6C 00 00 C5 02 73 74 72 73 74 72 00 00 91 02 6D 61 6C 6C 6F 63 00 00 5E 02 66 72 65 65 00 00 4C 02 66 63 6C 6F 73 65 00 00 DA 00 5F 66 69 6C 62 75 66 00 64 02 66 74 65 6C 6C 00 62 02 66 73 65 65 6B 00 57 02 66 6F 70 65 6E 00 49 00 5F 5F 43 78 78 46 72 61 6D 65 48 61 6E 64 6C 65 72 00 4D 53 56 43 52 54 2E 64 6C 6C 00 00}
    condition:
        $a
}

rule PEiD_00083_AntiDote_1_2_Beta__Demo_____SIS_Team_
{
    meta:
        description = "[AntiDote 1.2 Beta (Demo) -> SIS-Team]"
        ep_only = "true"
    strings:
        $a = {68 69 D6 00 00 E8 C6 FD FF FF 68 69 D6 00 00 E8 BC FD FF FF 83 C4 08 E8 A4 FF FF FF 84 C0 74 2F 68 04 01 00 00 68 B0 21 60 00 6A 00 FF 15 08 10 60 00 E8 29 FF FF FF 50 68 88 10 60 00 68 78 10 60 00 68 B0 21 60 00 E8 A4 FD FF FF 83 C4 10 33 C0 C2 10 00 90 90 90 90 90 90 90 90 90 90 90 90 8B 4C 24 08 56 8B 74 24 08 33 D2 8B C6 F7 F1 8B C6 85 D2 74 08 33 D2 F7 F1 40 0F AF C1 5E C3 90 8B 44 24 04 53 55 56 8B 48 3C 57 03 C8 33 D2 8B 79 54 8B 71 38 8B C7 F7 F6 85 D2 74 0C 8B C7 33 D2 F7 F6 8B F8 47 0F AF FE 33 C0 33 DB 66 8B 41 14 8D 54 08 18 33 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00084_AntiDote_1_2_Demo____SIS_Team_
{
    meta:
        description = "[AntiDote 1.2.Demo -> SIS-Team]"
        ep_only = "true"
    strings:
        $a = {E8 F7 FE FF FF 05 CB 22 00 00 FF E0 E8 EB FE FF FF 05 BB 19 00 00 FF E0 E8 BD 00 00 00 08 B2 62 00 01 52 17 0C 0F 2C 2B 20 7F 52 79 01 30 07 17 29 4F 01 3C 30 2B 5A 3D C7 26 11 26 06 59 0E 78 2E 10 14 0B 13 1A 1A 3F 64 1D 71 33 57 21 09 24 8B 1B 09 37 08 61 0F 1D 1D 2A 01 87 35 4C 07 39 0B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00085_AntiDote_1_2_DLL_Demo____SIS_Team_
{
    meta:
        description = "[AntiDote 1.2.DLL.Demo -> SIS-Team]"
        ep_only = "true"
    strings:
        $a = {EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 08 32 90 90 90 90 90 90 90 90 90 90 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF EB 0B 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00086_AntiDote_1_2_DLL_Demo____SIS_Team_
{
    meta:
        description = "[AntiDote 1.2.DLL.Demo -> SIS-Team]"
        ep_only = "true"
    strings:
        $a = {EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 08 32 90 90 90 90 90 90 90 90 90 90 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF EB 0B 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 83 C1 02 81 FD 00 F3 FF FF 83 D1 01 8D 14 2F 83 FD FC 76 0F 8A 02 42 88 07 47 49 75 F7 E9 63 FF FF FF 90 8B 02 83 C2 04 89 07 83 C7 04 83 E9 04 77 F1 01 CF E9 4C FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00087_AntiDote_1_2_1_4_SE_DLL____SIS_Team_
{
    meta:
        description = "[AntiDote 1.2/1.4 SE DLL -> SIS-Team]"
        ep_only = "true"
    strings:
        $a = {EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 08 32 90 90 90 90 90 90 90 90 90 90 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF EB 0B 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 ?? 75 ?? 8B 1E 83 EE FC 11 DB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00088_AntiDote_1_4_SE____SIS_Team_
{
    meta:
        description = "[AntiDote 1.4 SE -> SIS-Team]"
        ep_only = "true"
    strings:
        $a = {68 90 03 00 00 E8 C6 FD FF FF 68 90 03 00 00 E8 BC FD FF FF 68 90 03 00 00 E8 B2 FD FF FF 50 E8 AC FD FF FF 50 E8 A6 FD FF FF 68 69 D6 00 00 E8 9C FD FF FF 50 E8 96 FD FF FF 50 E8 90 FD FF FF 83 C4 20 E8 78 FF FF FF 84 C0 74 4F 68 04 01 00 00 68 10 22 60 00 6A 00 FF 15 08 10 60 00 68 90 03 00 00 E8 68 FD FF FF 68 69 D6 00 00 E8 5E FD FF FF 50 E8 58 FD FF FF 50 E8 52 FD FF FF E8 DD FE FF FF 50 68 A4 10 60 00 68 94 10 60 00 68 10 22 60 00 E8 58 FD FF FF 83 C4 20 33 C0 C2 10 00 8B 4C 24 08 56 8B 74 24 08 33 D2 8B C6 F7 F1 8B C6 85 D2 74 08 33 D2 F7 F1 40 0F AF C1 5E C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00089_AntiDote_V1_2____SIS_Team___Sign_by_fly_
{
    meta:
        description = "[AntiDote V1.2 -> SIS-Team ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 09 01 47 65 74 43 6F 6D 6D 61 6E 64 4C 69 6E 65 41 00 DB 01 47 65 74 56 65 72 73 69 6F 6E 45 78 41 00 73 01 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 00 7A 03 57 61 69 74 46 6F 72 53 69 6E 67 6C 65 4F 62 6A 65 63 74 00 BF 02 52 65 73 75 6D 65 54 68 72 65 61 64 00 00 29 03 53 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 94 03 57 72 69 74 65 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 00 6B 03 56 69 72 74 75 61 6C 41 6C 6C 6F 63 45 78 00 00 A6 02 52 65 61 64 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 CA 01 47 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 62 00 43 72 65 61 74 65 50 72 6F 63 65 73 73 41 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 26 00 43 68 61 72 4C 6F 77 65 72 41 00 00 55 53 45 52 33 32 2E 64 6C 6C 00 00 5E 02 66 72 65 65 00 00 4C 02 66 63 6C 6F 73 65 00 00 DA 00 5F 66 69 6C 62 75 66 00 91 02 6D 61 6C 6C 6F 63 00 00 64 02 66 74 65 6C 6C 00 62 02 66 73 65 65 6B 00 57 02 66 6F 70 65 6E 00 C5 02 73 74 72 73 74 72 00 00 4D 53 56 43 52 54 2E 64 6C 6C 00 00}
    condition:
        $a
}

rule PEiD_00090_AntiDote_V1_2_Demo____SIS_Team_
{
    meta:
        description = "[AntiDote V1.2.Demo -> SIS-Team]"
        ep_only = "true"
    strings:
        $a = {E8 F7 FE FF FF 05 CB 22 00 00 FF E0 E8 EB FE FF FF 05 BB 19 00 00 FF E0 E8 BD 00 00 00 08 B2 62 00 01 52 17 0C 0F 2C 2B 20 7F 52 79 01 30 07 17 29 4F 01 3C 30 2B 5A 3D C7 26 11 26 06 59 0E 78 2E 10 14 0B 13 1A 1A 3F 64 1D 71 33 57 21 09 24 8B 1B 09 37 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_00091_AntiDote_v1_4_osCE__Sing_by_osC__CoDeR_
{
    meta:
        description = "[AntiDote v1.4 osCE *Sing by osC++CoDeR]"
        ep_only = "true"
    strings:
        $a = {68 95 01 00 00 E8 D0 FD FF FF 68 95 01 00 00 E8 C3 FD FF FF 68 90 03 00 00 E8 BC FD FF FF 68 90 03 00 00 E8 B2 FD FF FF 50 E8 AC FD FF FF 50 E8 A6 FD FF FF 68 69 D6 00 00 E8 9C FD FF FF 50 E8 96 FD FF FF 50 E8 90 FD FF FF 83 C4 20 E8 78 FF FF FF 84 C0 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_00092_AntiDote_V1_x____SIS_Team_
{
    meta:
        description = "[AntiDote V1.x -> SIS-Team]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? 00 00 E8 ?? FD FF FF 68 ?? ?? 00 00 E8 ?? FD FF FF 68 90 03 00 00 E8 ?? FD FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? FD FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00093_AntiVirus_Vaccine_v_1_03_
{
    meta:
        description = "[AntiVirus Vaccine v.1.03]"
        ep_only = "true"
    strings:
        $a = {FA 33 DB B9 ?? ?? 0E 1F 33 F6 FC AD 35 ?? ?? 03 D8 E2}
    condition:
        $a at pe.entry_point
}

rule PEiD_00094_aPack_v0_62_
{
    meta:
        description = "[aPack v0.62]"
        ep_only = "true"
    strings:
        $a = {1E 06 8C C8 8E D8 ?? ?? ?? 8E C0 50 BE ?? ?? 33 FF FC B6}
    condition:
        $a at pe.entry_point
}

rule PEiD_00095_aPack_v0_82_
{
    meta:
        description = "[aPack v0.82]"
        ep_only = "true"
    strings:
        $a = {1E 06 8C CB BA ?? ?? 03 DA 8D ?? ?? ?? FC 33 F6 33 FF 48 4B 8E C0 8E DB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00096_aPack_v0_98__m_
{
    meta:
        description = "[aPack v0.98 -m]"
        ep_only = "false"
    strings:
        $a = {1E 06 8C C8 8E D8 05 ?? ?? 8E C0 50 BE ?? ?? 33 FF FC B2 ?? BD ?? ?? 33 C9 50 A4 BB ?? ?? 3B F3 76}
    condition:
        $a
}

rule PEiD_00097_aPack_v0_98b__com__
{
    meta:
        description = "[aPack v0.98b (com)]"
        ep_only = "false"
    strings:
        $a = {BE ?? ?? BF ?? ?? 8B CF FC 57 F3 A4 C3 BF ?? ?? 57 57 BE ?? ?? B2 ?? BD ?? ?? 50 A4}
    condition:
        $a
}

rule PEiD_00098_aPack_v0_98b__DS___ES_not_saved__
{
    meta:
        description = "[aPack v0.98b (DS & ES not saved)]"
        ep_only = "false"
    strings:
        $a = {8C CB BA ?? ?? 03 DA FC 33 F6 33 FF 4B 8E DB 8D ?? ?? ?? 8E C0 B9 ?? ?? F3 A5 4A 75}
    condition:
        $a
}

rule PEiD_00099_aPack_v0_98b__exe__
{
    meta:
        description = "[aPack v0.98b (exe)]"
        ep_only = "false"
    strings:
        $a = {93 07 1F 05 ?? ?? 8E D0 BC ?? ?? EA}
    condition:
        $a
}

rule PEiD_00100_APatch_GUI_v1_1_
{
    meta:
        description = "[APatch GUI v1.1]"
        ep_only = "true"
    strings:
        $a = {52 31 C0 E8 FF FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00101_Apex_3_0_alpha____500mhz_
{
    meta:
        description = "[Apex 3.0 alpha -> 500mhz]"
        ep_only = "false"
    strings:
        $a = {5F B9 14 00 00 00 51 BE 00 10 40 00 B9 00 ?? ?? 00 8A 07 30 06 46 E2 FB 47 59 E2 EA 68 ?? ?? ?? 00 C3}
    condition:
        $a
}

rule PEiD_00102_APEX_C__BLT_Apex_4_0_____500mhz_
{
    meta:
        description = "[APEX_C (BLT Apex 4.0) -> 500mhz]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? B9 FF FF FF 00 01 D0 F7 E2 72 01 48 E2 F7 B9 FF 00 00 00 8B 34 24 80 36 FD 46 E2 FA C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00103_Apex_c_beta____500mhz_
{
    meta:
        description = "[Apex_c beta -> 500mhz]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? B9 FF FF FF 00 01 D0 F7 E2 72 01 48 E2 F7 B9 FF 00 00 00 8B 34 24 80 36 FD 46 E2 FA C3 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00104_Apex_c_beta____500mhz_
{
    meta:
        description = "[Apex_c beta -> 500mhz]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? B9 FF FF FF 00 01 D0 F7 E2 72 01 48 E2 F7 B9 FF 00 00 00 8B 34 24 80 36 FD 46 E2 FA C3 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00105_App_Encryptor____Silent_Team_
{
    meta:
        description = "[App Encryptor -> Silent Team]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 1F 1F 40 00 B9 7B 09 00 00 8D BD 67 1F 40 00 8B F7 AC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00106_App_Protector____Silent_Team_
{
    meta:
        description = "[App Protector -> Silent Team]"
        ep_only = "true"
    strings:
        $a = {E9 97 00 00 00 0D 0A 53 69 6C 65 6E 74 20 54 65 61 6D 20 41 70 70 20 50 72 6F 74 65 63 74 6F 72 0D 0A 43 72 65 61 74 65 64 20 62 79 20 53 69 6C 65 6E 74 20 53 6F 66 74 77 61 72 65 0D 0A 54 68 65 6E 6B 7A 20 74 6F 20 44 6F 63 68 74 6F 72 20 58 0D 0A 0D 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_00107_App_Protector____Silent_Team_
{
    meta:
        description = "[App Protector -> Silent Team]"
        ep_only = "true"
    strings:
        $a = {E9 97 00 00 00 0D 0A 53 69 6C 65 6E 74 20 54 65 61 6D 20 41 70 70 20 50 72 6F 74 65 63 74 6F 72 0D 0A 43 72 65 61 74 65 64 20 62 79 20 53 69 6C 65 6E 74 20 53 6F 66 74 77 61 72 65 0D 0A 54 68 65 6E 6B 7A 20 74 6F 20 44 6F 63 68 74 6F 72 20 58 0D 0A 0D 0A 54 68 69 73 20 69 73 20 53 50 61 6B 65 64 20 41 70 70 6C 69 63 61 74 69 6F 6E 0D 0A 53 50 41 4B 20 63 6F 6D 70 72 69 6D 61 74 69 6F 6E 20 73 79 73 74 65 6D 20 69 73 20 AE 53 69 6C 65 6E 74 20 54 65 61 6D 99 0D 0A 60 E8 01 00 00 00 E8 83 C4 04 E8 01 00 00 00 E9 5D 81 ED 76 22 40 00 E8 04 02 00 00 E8 EB 08 EB 02 CD 20 FF 24 24 9A 66 BE 47 46 E8 01 00 00 00 9A 59 8D 95 C8 22 40 00 E8 01 00 00 00 69 58 66 BF 4D 4A E8 BF 01 00 00 8D 52 F9 E8 01 00 00 00 E8 5B 68 CC FF E2 9A FF E4 69 FF A5 E4 24 40 00 E9 E8 B9 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00108_ARC_SFX_Archive_
{
    meta:
        description = "[ARC-SFX Archive]"
        ep_only = "true"
    strings:
        $a = {8C C8 8C DB 8E D8 8E C0 89 ?? ?? ?? 2B C3 A3 ?? ?? 89 ?? ?? ?? BE ?? ?? B9 ?? ?? BF ?? ?? BA ?? ?? FC AC 32 C2 8A D8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00109_ARJ_SFX_Custom_
{
    meta:
        description = "[ARJ SFX Custom]"
        ep_only = "true"
    strings:
        $a = {60 BE 15 F0 40 00 8D BE EB 1F FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73}
    condition:
        $a at pe.entry_point
}

rule PEiD_00110_ARJ_SFX_Custom_
{
    meta:
        description = "[ARJ SFX Custom]"
        ep_only = "true"
    strings:
        $a = {64 A1 00 00 00 00 55 8B EC 6A FF 68 18 C0 40 00 68 C4 A1 40 00 50 64 89 25 00 00 00 00 83 EC 60 53 56 57 89 65 E8 FF 15 38 03 41 00 A3 D0 D6 40 00 33 C0 A0 D1 D6 40 00 A3 DC D6 40 00 A1 D0 D6}
    condition:
        $a at pe.entry_point
}

rule PEiD_00111_ARJ_SFX_Custom_
{
    meta:
        description = "[ARJ SFX Custom]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 66 9C 60 50 8D 90 5C 01 00 00 68 00 00 40 00 83 3A 00 0F 84 C6 C1 FF FF 8B 04 24 8B 0A 0F BA F1 1F 73 13 FD 8B F0 8B F8 03 72 04 03 7A 08 F3 A5 83 C2 0C FC EB D9 83 C2 10 8B 5A}
    condition:
        $a at pe.entry_point
}

rule PEiD_00112_ARM_Protector_0_1_by_SMoKE_
{
    meta:
        description = "[ARM Protector 0.1 by SMoKE]"
        ep_only = "false"
    strings:
        $a = {E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 5E 1F 40 00 EB 02 83 09 8D B5 EF 1F 40 00 EB 02 83 09 BA A3 11 00 00 EB 01 00 8D 8D 92 31 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0}
    condition:
        $a
}

rule PEiD_00113_ARM_Protector_0_2___SMoKE_
{
    meta:
        description = "[ARM Protector 0.2-> SMoKE]"
        ep_only = "false"
    strings:
        $a = {E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 09 20 40 00 EB 02 83 09 8D B5 9A 20 40 00 EB 02 83 09 BA 0B 12 00 00 EB 01 00 8D 8D A5 32 40 00}
    condition:
        $a
}

rule PEiD_00114_ARM_Protector_0_3___by_SMoKE_
{
    meta:
        description = "[ARM Protector 0.3 - by SMoKE]"
        ep_only = "false"
    strings:
        $a = {E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 13 24 40 00 EB 02 83 09 8D B5 A4 24 40 00 EB 02 83 09 BA 4B 15 00 00 EB 01 00 8D 8D EF 39 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 50 C3 8A 06 46 EB 01 00 D0 C8 E8 14 00 00 00 83 EB 01 00 2A C2 E8 00 00 00 00 5B 83 C3 07 53 C3 00 EB 04 5B 43 53 C3 EB 01 00 32 C2 E8 0B 00 00 00 00 32 C1 EB 01 00 C0 C0 02 EB 09 2A C2 5B EB 01 00 43 53 C3 88 07 EB 01 00 47 4A 75 B4}
    condition:
        $a
}

rule PEiD_00115_ARM_Protector_v0_1_by_SMoKE_
{
    meta:
        description = "[ARM Protector v0.1 by SMoKE]"
        ep_only = "false"
    strings:
        $a = {E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 5E 1F 40 00 EB 02 83 09 8D B5 EF 1F 40 00 EB 02 83 09 BA A3 11 00 00 EB 01 00 8D 8D 92 31 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 50 C3 8A 06 46 EB 01 00 D0 C8 E8 14 00 00 00 83 EB 01 00 2A C2 E8 00 00 00 00 5B 83 C3 07 53 C3 00 EB 04 5B 43 53 C3 EB 01 00 32 C2 E8 0B 00 00 00 00 32 C1 EB 01 00 C0 C0 02 EB 09 2A C2 5B EB 01 00 43 53 C3 88 07 EB 01 00 47 4A 75 B4}
    condition:
        $a
}

rule PEiD_00116_Armadillo_3_00a____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 3.00a -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00117_Armadillo_3_00a____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 3.00a -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 ?? 87 DB 7A F0 ?? ?? 61 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 ?? 8B 04 24 EB 03 7A 29 ?? C6 00 90 C3 ?? 70 F0 87 D2 71 07 ?? ?? 40 8B DB 7A 11 EB 08 ?? EB F7 EB C3 ?? 7A E9 70 DA 7B D1 71 F3 ?? 7B F3 71 D6 ?? 9D 61 83 ED 06 33 FF 47 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 EB 87 ?? 7A F0 ?? ?? 61 8B 9C BD 26 42}
    condition:
        $a at pe.entry_point
}

rule PEiD_00118_Armadillo_3_01__3_05_
{
    meta:
        description = "[Armadillo 3.01, 3.05]"
        ep_only = "false"
    strings:
        $a = {60 E8 00 00 00 00 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 0F}
    condition:
        $a
}

rule PEiD_00119_Armadillo_3_10_
{
    meta:
        description = "[Armadillo 3.10]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 E0 97 44 00 68 20 C0 42 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 4C 41 44 00 33 D2 8A D4 89 15 90 A1 44 00 8B C8 81 E1 FF 00 00 00 89 0D 8C A1 44 00 C1 E1 08 03 CA 89 0D 88 A1 44 00 C1 E8 10 A3 84 A1}
    condition:
        $a
}

rule PEiD_00120_Armadillo_3_6x____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 3.6x -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 ?? 87 DB 7A F0 ?? ?? 61 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 ?? 8B 04 24 EB 03 7A 29 ?? C6 00 90 C3 ?? 70 F0 87 D2 71 07 ?? ?? 40 8B DB 7A 11 EB 08 ?? EB F7 EB C3 ?? 7A E9 70 DA 7B D1 71 F3 ?? 7B F3 71 D6 ?? 9D 61 83 ED 06 33 FF 47 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 EB 87 ?? 7A F0 ?? ?? 61 8B 9C BD AB 76}
    condition:
        $a at pe.entry_point
}

rule PEiD_00121_Armadillo_3_7x____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 3.7x -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 ?? 87 DB 7A F0 ?? ?? 61 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 ?? 8B 04 24 EB 03 7A 29 ?? C6 00 90 C3 ?? 70 F0 87 D2 71 07 ?? ?? 40 8B DB 7A 11 EB 08 ?? EB F7 EB C3 ?? 7A E9 70 DA 7B D1 71 F3 ?? 7B F3 71 D6 ?? 9D 61 83 ED 06 B8 3B 01 00 00 03 C5 33 DB 81 C3 01 01 01 01 31 18 81 38 78 54 00 00 74 04 31 18 EB EC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00122_Armadillo_3_X_5_X____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 3.X-5.X -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 9D 0F C9 8B CA F7 D1 59 58 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_00123_Armadillo_3_X_5_X____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 3.X-5.X -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 9D 0F C9 8B CA F7 D1 59 58 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 9D 0F C9 8B CA F7 D1 59 58 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 9D 0F C9 8B CA F7 D1 59 58 60 33 C9 75 02 EB 15 EB 33}
    condition:
        $a at pe.entry_point
}

rule PEiD_00124_Armadillo_4_00_0053____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 4.00.0053 -> Silicon Realms Toolworks]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 20 8B 4B 00 68 80 E4 48 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4B 00 33 D2 8A D4 89 15 A4 A1 4B 00 8B C8 81 E1 FF 00 00 00 89 0D A0 A1 4B 00 C1 E1 08 03 CA 89 0D 9C A1 4B 00 C1 E8 10 A3 98 A1}
    condition:
        $a
}

rule PEiD_00125_Armadillo_4_10____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 4.10 -> Silicon Realms Toolworks]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 F8 8E 4C 00 68 D0 EA 49 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4C 00 33 D2 8A D4 89 15 7C A5 4C 00 8B C8 81 E1 FF 00 00 00 89 0D 78 A5 4C 00 C1 E1 08 03 CA 89 0D 74 A5 4C 00 C1 E8 10 A3 70 A5}
    condition:
        $a
}

rule PEiD_00126_Armadillo_4_20____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 4.20 -> Silicon Realms Toolworks]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 F8 8E 4C 00 68 F0 EA 49 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4C 00 33 D2 8A D4 89 15 84 A5 4C 00 8B C8 81 E1 FF 00 00 00 89 0D 80 A5 4C 00 C1 E1 08 03 CA 89 0D 7C A5 4C 00 C1 E8 10 A3 78 A5}
    condition:
        $a
}

rule PEiD_00127_Armadillo_4_30___4_40____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 4.30 - 4.40 -> Silicon Realms Toolworks]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 40 ?? ?? 00 68 80 ?? ?? 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 ?? ?? 00 33 D2 8A D4 89 15 30 ?? ?? 00 8B C8 81 E1 FF 00 00 00 89 0D 2C ?? ?? 00 C1 E1 08 03 CA 89 0D 28 ?? ?? 00 C1 E8 10 A3 24}
    condition:
        $a
}

rule PEiD_00128_Armadillo_4_30a____Silicon_Realms_Toolworks__h__
{
    meta:
        description = "[Armadillo 4.30a -> Silicon Realms Toolworks (h)]"
        ep_only = "false"
    strings:
        $a = {44 64 65 44 61 74 61 20 69 6E 69 74 69 61 6C 69 7A 65 64 20 28 41 4E 53 49 29 2C 20 61 70 70 20 73 74 72 69 6E 67 73 20 61 72 65 20 27 25 73 27 20 61 6E 64 20 27 25 73 27 00 00 00 44 64 65 44 61 74 61 20 69 6E 69 74 69 61 6C 69 7A 65 64 20 28 55 4E 49 43 4F 44 45 29 2C 20 61 70 70 20 73 74 72 69 6E 67 73 20 61 72 65 20 27 25 53 27 20 61 6E 64 20 27 25 53 27 00 00 00 00 50 75 74 53 74 72 69 6E 67 28 27 25 73 27 29 00 47 65 74 53 74 72 69 6E 67 28 29 2C 20 66 61 6C 73 65 00 00 47 65 74 53}
    condition:
        $a
}

rule PEiD_00129_Armadillo_4_30a____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 4.30a -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {44 64 65 44 61 74 61 20 69 6E 69 74 69 61 6C 69 7A 65 64 20 28 41 4E 53 49 29 2C 20 61 70 70 20 73 74 72 69 6E 67 73 20 61 72 65 20 27 25 73 27 20 61 6E 64 20 27 25 73 27 00 00 00 44 64 65 44 61 74 61 20 69 6E 69 74 69 61 6C 69 7A 65 64 20 28 55 4E 49 43}
    condition:
        $a at pe.entry_point
}

rule PEiD_00130_Armadillo_4_40____Silicon_Realms_Toolworks__h__
{
    meta:
        description = "[Armadillo 4.40 -> Silicon Realms Toolworks (h)]"
        ep_only = "false"
    strings:
        $a = {31 2E 31 2E 34 00 00 00 C2 E0 94 BE 93 FC DE C6 B6 24 83 F7 D2 A4 92 77 40 27 CF EB D8 6F 50 B4 B5 29 24 FA 45 08 04 52 D5 1B D2 8C 8A 1E 6E FF 8C 5F 42 89 F1 83 B1 27 C5 69 57 FC 55 0A DD 44 BE 2A 02 97 6B 65 15 AA 31 E9 28 7D 49 1B DF B5 5D 08 A8 BA A8 73 DC F6 D1 05 42 55 53 79 73 74 65 6D 00 00 53 00 79 00 73 00 74 00 65 00 6D 00 00 00 00 00 44 44 45 20 50 72 6F 63 65 73 73 69 6E 67 00 00 53 77 50 44 44 45 00 00 44 00 44 00 45 00 20 00 50 00 72 00 6F 00 63 00 65 00 73 00 73 00 69 00 6E 00 67 00 00 00 00 00 53 00 77 00 50 00 44 00 44 00 45 00 00 00 00 00 3C 00 00 00}
    condition:
        $a
}

rule PEiD_00131_Armadillo_4_40____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 4.40 -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {31 2E 31 2E 34 00 00 00 C2 E0 94 BE 93 FC DE C6 B6 24 83 F7 D2 A4 92 77 40 27 CF EB D8 6F 50 B4 B5 29 24 FA 45 08 04 52 D5 1B D2 8C 8A 1E 6E FF 8C 5F 42 89 F1 83 B1 27 C5 69 57 FC 55 0A DD 44 BE 2A 02 97 6B 65 15 AA 31 E9 28 7D 49 1B DF B5 5D 08 A8 BA A8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00132_Armadillo_4_44a_public_build____Silicon_Realms_Toolworks__h__
{
    meta:
        description = "[Armadillo 4.44a public build -> Silicon Realms Toolworks (h)]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 EC 0C 53 56 57 8B 45 08 50 FF 15 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 51 B9 00 08 00 00 B9 06 00 00 00 F7 D1 0F C8 F7 D1 41 41 41 41 41 41 41 83 C1 04 41 41 41 41 83 C1 03 41 41 41 41 41 41 49 41 FE C1 FE C1 FE C1 83 C1 0D FE C1 FE C1 FE C1 FE C1 FE C1 83 C1 0A 49 52 BA 04 00 00 00 03 CA 41 5A 0F C8 23 C1 59 F7 D8 1B C0 F7 D8 5A 89 45 F4 8B 0D ?? ?? ?? ?? 33 0D ?? ?? ?? ?? D1 E1 89 4D F8 83 7D F4 00 74 09 8B 55 F8 83 CA 01 89 55 F8 8B 45 F8 50 FF 15 ?? ?? ?? ?? 83 C4 04 5F 5E 5B 8B E5 5D C3 55 8B EC 83 EC 0C 53 56 57 8B 45 08 50 FF 15 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 53 BB 80 00 00 00 EB 05 BB 04 00 00 00 BB 32 00 00 00 F7 D3 0F C8 F7 D3 43 43 83 E0 00 83 C3 08 4B 51 B9 04 00 00 00 03 D9 43 59 0F C8 40 5B 89 45 F4 8B 0D ?? ?? ?? ?? 33 0D ?? ?? ?? ?? D1 E1 89 4D F8 83 7D F4 00 74 09 8B 55 F8 83 CA 01 89 55 F8 8B 45 F8 50 FF 15 ?? ?? ?? ?? 83 C4 04 5F 5E 5B 8B E5 5D C3 55 8B EC 83 EC 0C 53 56 57 8B 45 08 50 FF 15 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 70 07 7C 03 EB 05 E9 74 FB EB F9 53 BB FF FF 00 00 23 C3 51 B5 2C 80 ED 01 80 ED 20 FE CD FE CD 80 ED 04 FE CD 80 ED 03 FE CD 22 E5 B1 70 80 E9 02 FE C9 FE C9 FE C9 80 E9 06 F6 D0 0F C9 F6 D0 0F C9 FE C9 FE C9 80 E9 10 FE C9 FE C9 80 C1 0C FE C9 FE C9 FE C9 70 07 7C 03 EB 05 C7 74 FB EB F9 FE C9 FE C9 FE C9 FE C9 80 E9 10 80 E9 01 FE C9 FE C9 FE C9 FE C9 FE C9 FE C9 FE C9 FE C9 F7 D1 0F C8 F7 D1 0F C8 FE C1 80 C1 02 22 C1 59 5B 85 C0 0F 85 94 00 00 00 8B 45 FC 53 BB 00 08 00 00 EB 05 BB 80 00 00 00 BB 72 00 00 00 F7 D3 0F C8 F7 D3 43 43 83 C3 08 4B 51 B9 04 00 00 00 03 D9 43 59 0F C8 23 C3 5B F7 D8 1B C0 40 5A 8B C8 51 8B 45 FC 52 BA FF FF}
    condition:
        $a
}

rule PEiD_00133_Armadillo_5_0_Dll____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 5.0 Dll -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {83 7C 24 08 01 75 05 E8 DE 4B 00 00 FF 74 24 04 8B 4C 24 10 8B 54 24 0C E8 ED FE FF FF 59 C2 0C 00 6A 0C 68 ?? ?? ?? ?? E8 E5 24 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 8F 15 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 20 15 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? 03 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 D7 23 00 00 59 89 7D FC FF 75 08 E8 EC 53 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 2B C5 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 19 ED FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 7D 22 00 00 59 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00134_Armadillo_5_00____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 5.00 -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {E8 E3 40 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 44 15 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 36 13 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 C7 12 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75}
    condition:
        $a at pe.entry_point
}

rule PEiD_00135_Armadillo_5_00____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 5.00 -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {E8 E3 40 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 44 15 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 36 13 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 C7 12 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? 03 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 48 11 00 00 59 89 7D FC FF 75 08 E8 01 49 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 66 D3 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 AF F9 FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 EE 0F 00 00 59 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00136_Armadillo_5_00_Dll____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo 5.00 Dll -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {83 7C 24 08 01 75 05 E8 DE 4B 00 00 FF 74 24 04 8B 4C 24 10 8B 54 24 0C E8 ED FE FF FF 59 C2 0C 00 6A 0C 68 ?? ?? ?? ?? E8 E5 24 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 8F 15 00 00 C7 00 0C 00 00 00 57 57 57 57 57}
    condition:
        $a at pe.entry_point
}

rule PEiD_00137_Armadillo_v1_60a_
{
    meta:
        description = "[Armadillo v1.60a]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 98 71 40 00 68 48 2D 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00138_Armadillo_v1_71_
{
    meta:
        description = "[Armadillo v1.71]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1}
    condition:
        $a
}

rule PEiD_00139_Armadillo_v1_72___v1_73_
{
    meta:
        description = "[Armadillo v1.72 - v1.73]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 E8 C1 ?? ?? 68 F4 86 ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00140_Armadillo_v1_77_
{
    meta:
        description = "[Armadillo v1.77]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 B0 71 40 00 68 6C 37 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00141_Armadillo_v1_80_
{
    meta:
        description = "[Armadillo v1.80]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 E8 C1 00 00 68 F4 86 00 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00142_Armadillo_v1_82_
{
    meta:
        description = "[Armadillo v1.82]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 E0 C1 40 00 68 74 81 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00143_Armadillo_v1_83_
{
    meta:
        description = "[Armadillo v1.83]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 E0 C1 40 00 68 64 84 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00144_Armadillo_v1_84_
{
    meta:
        description = "[Armadillo v1.84]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 E8 C1 40 00 68 F4 86 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00145_Armadillo_v1_90_
{
    meta:
        description = "[Armadillo v1.90]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 10 F2 40 00 68 64 9A 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00146_Armadillo_v1_90a_
{
    meta:
        description = "[Armadillo v1.90a]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 64 FF 68 10 F2 40 00 68 14 9B 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00147_Armadillo_v1_90b1_
{
    meta:
        description = "[Armadillo v1.90b1]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 E0 C1 40 00 68 04 89 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00148_Armadillo_v1_90b2_
{
    meta:
        description = "[Armadillo v1.90b2]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 F0 C1 40 00 68 A4 89 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00149_Armadillo_v1_90b3_
{
    meta:
        description = "[Armadillo v1.90b3]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 08 E2 40 00 68 94 95 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00150_Armadillo_v1_90b4_
{
    meta:
        description = "[Armadillo v1.90b4]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 08 E2 40 00 68 B4 96 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00151_Armadillo_v1_90c_
{
    meta:
        description = "[Armadillo v1.90c]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 10 F2 40 00 68 74 9D 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00152_Armadillo_v1_9x_
{
    meta:
        description = "[Armadillo v1.9x]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 98 ?? ?? ?? 68 10 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15}
    condition:
        $a at pe.entry_point
}

rule PEiD_00153_Armadillo_v1_xx___v2_xx_
{
    meta:
        description = "[Armadillo v1.xx - v2.xx]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6}
    condition:
        $a at pe.entry_point
}

rule PEiD_00154_Armadillo_v2_00_
{
    meta:
        description = "[Armadillo v2.00]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 00 02 41 00 68 C4 A0 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00155_Armadillo_v2_00b2_2_00b3_
{
    meta:
        description = "[Armadillo v2.00b2-2.00b3]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 00 F2 40 00 68 C4 A0 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00156_Armadillo_v2_01_
{
    meta:
        description = "[Armadillo v2.01]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 08 02 41 00 68 04 9A 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00157_Armadillo_v2_10b2_
{
    meta:
        description = "[Armadillo v2.10b2]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 18 12 41 00 68 24 A0 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00158_Armadillo_v2_20_
{
    meta:
        description = "[Armadillo v2.20]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 10 12 41 00 68 F4 A0 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00159_Armadillo_v2_20b1_
{
    meta:
        description = "[Armadillo v2.20b1]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 30 12 41 00 68 A4 A5 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00160_Armadillo_v2_50_
{
    meta:
        description = "[Armadillo v2.50]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 B8 ?? ?? ?? 68 F8 ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 20 ?? ?? ?? 33 D2 8A D4 89 15 D0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00161_Armadillo_v2_50b3_
{
    meta:
        description = "[Armadillo v2.50b3]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 B8 ?? ?? ?? 68 F8 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 20 ?? ?? ?? 33 D2 8A D4 89 15 D0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00162_Armadillo_v2_51_
{
    meta:
        description = "[Armadillo v2.51]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 B8 ?? ?? ?? 68 D0 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 20}
    condition:
        $a at pe.entry_point
}

rule PEiD_00163_Armadillo_v2_52_beta2_
{
    meta:
        description = "[Armadillo v2.52 beta2]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? B0 ?? ?? ?? ?? 68 60 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF ?? ?? ?? 15 24}
    condition:
        $a at pe.entry_point
}

rule PEiD_00164_Armadillo_v2_52_
{
    meta:
        description = "[Armadillo v2.52]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? E0 ?? ?? ?? ?? 68 D4 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF ?? ?? ?? 15 38}
    condition:
        $a at pe.entry_point
}

rule PEiD_00165_Armadillo_v2_52_
{
    meta:
        description = "[Armadillo v2.52]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 E0 ?? ?? ?? 68 D4 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 38}
    condition:
        $a at pe.entry_point
}

rule PEiD_00166_Armadillo_v2_52b2_
{
    meta:
        description = "[Armadillo v2.52b2]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 B0 ?? ?? ?? 68 60 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 24}
    condition:
        $a at pe.entry_point
}

rule PEiD_00167_Armadillo_v2_53_
{
    meta:
        description = "[Armadillo v2.53]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 40 ?? ?? ?? 68 54 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 58 ?? ?? ?? 33 D2 8A D4 89 15 EC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00168_Armadillo_v2_53_
{
    meta:
        description = "[Armadillo v2.53]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 40 ?? ?? ?? ?? 68 54 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF ?? ?? ?? 15 58 33 D2 8A D4 89}
    condition:
        $a at pe.entry_point
}

rule PEiD_00169_Armadillo_v2_53b3_
{
    meta:
        description = "[Armadillo v2.53b3]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 D8 ?? ?? ?? 68 14 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15}
    condition:
        $a at pe.entry_point
}

rule PEiD_00170_Armadillo_v2_5x___v2_6x_
{
    meta:
        description = "[Armadillo v2.5x - v2.6x]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 58 ?? ?? ?? 33 D2 8A D4 89 15 EC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00171_Armadillo_v2_60_
{
    meta:
        description = "[Armadillo v2.60]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 D0 ?? ?? ?? 68 34 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 68 ?? ?? ?? 33 D2 8A D4 89 15 84}
    condition:
        $a at pe.entry_point
}

rule PEiD_00172_Armadillo_v2_60a_
{
    meta:
        description = "[Armadillo v2.60a]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 94 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 6C ?? ?? ?? 33 D2 8A D4 89 15 B4}
    condition:
        $a at pe.entry_point
}

rule PEiD_00173_Armadillo_v2_60b1_
{
    meta:
        description = "[Armadillo v2.60b1]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 50 ?? ?? ?? 68 74 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 58 ?? ?? ?? 33 D2 8A D4 89 15 FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00174_Armadillo_v2_60b2_
{
    meta:
        description = "[Armadillo v2.60b2]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 90 ?? ?? ?? 68 24 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 60 ?? ?? ?? 33 D2 8A D4 89 15 3C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00175_Armadillo_v2_60c_
{
    meta:
        description = "[Armadillo v2.60c]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 40 ?? ?? ?? 68 F4 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 6C ?? ?? ?? 33 D2 8A D4 89 15 F4}
    condition:
        $a at pe.entry_point
}

rule PEiD_00176_Armadillo_v2_61_
{
    meta:
        description = "[Armadillo v2.61]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 28 ?? ?? ?? 68 E4 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 6C ?? ?? ?? 33 D2 8A D4 89 15 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00177_Armadillo_v2_65b1_
{
    meta:
        description = "[Armadillo v2.65b1]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 38 ?? ?? ?? 68 40 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 28 ?? ?? ?? 33 D2 8A D4 89 15 F4}
    condition:
        $a at pe.entry_point
}

rule PEiD_00178_Armadillo_v2_75a_
{
    meta:
        description = "[Armadillo v2.75a]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 68 ?? ?? ?? 68 D0 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 28 ?? ?? ?? 33 D2 8A D4 89 15 24}
    condition:
        $a at pe.entry_point
}

rule PEiD_00179_Armadillo_v2_85_
{
    meta:
        description = "[Armadillo v2.85]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 68 ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 28 ?? ?? ?? 33 D2 8A D4 89 15 24}
    condition:
        $a at pe.entry_point
}

rule PEiD_00180_Armadillo_v2_xx__CopyMem_II__
{
    meta:
        description = "[Armadillo v2.xx (CopyMem II)]"
        ep_only = "true"
    strings:
        $a = {6A ?? 8B B5 ?? ?? ?? ?? C1 E6 04 8B 85 ?? ?? ?? ?? 25 07 ?? ?? 80 79 05 48 83 C8 F8 40 33 C9 8A 88 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 81 E2 07 ?? ?? 80 79 05 4A 83 CA F8 42 33 C0 8A 82}
    condition:
        $a at pe.entry_point
}

rule PEiD_00181_Armadillo_v3_00_
{
    meta:
        description = "[Armadillo v3.00]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 60 33 C9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00182_Armadillo_v3_00a_
{
    meta:
        description = "[Armadillo v3.00a]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00183_Armadillo_v3_01___v3_50a____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo v3.01 - v3.50a -> Silicon Realms Toolworks]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 ?? 87 DB 7A F0 ?? ?? 61 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 ?? 8B 04 24 EB 03 7A 29 ?? C6 00 90 C3 ?? 70 F0 87 D2 71 07 ?? ?? 40 8B DB 7A 11 EB 08 ?? EB F7 EB C3 ?? 7A E9 70 DA 7B D1 71 F3 ?? 7B F3 71 D6 ?? 9D 61 83 ED 06 33 FF 47 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 EB 87 ?? 7A F0 ?? ?? 61 8B 9C BD B8 43}
    condition:
        $a at pe.entry_point
}

rule PEiD_00184_Armadillo_v3_01__v3_05_
{
    meta:
        description = "[Armadillo v3.01, v3.05]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 60 33 C9 75 02 EB 15 EB 33 C9 75 18 7A 0C 70 0E EB 0D E8 72 0E 79 F1 FF 15 00 79 09 74 F0 EB 87 DB 7A F0 A0 33 61 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 A0 8B 04 24 EB 03 7A 29 E9 C6 00 90 C3 E8 70 F0 87 D2 71 07 E9 00 40 8B DB 7A 11 EB 08 E9 EB F7 EB C3 E8 7A E9 70 DA 7B D1 71 F3 E9 7B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00185_Armadillo_v3_10_
{
    meta:
        description = "[Armadillo v3.10]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 E0 97 44 00 68 20 C0 42 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 4C 41 44 00 33 D2 8A D4 89 15 90 A1 44 00 8B C8 81 E1 FF 00 00 00 89 0D 8C A1 44 00 C1 E1 08 03 CA 89 0D 88 A1 44 00 C1 E8 10 A3 84 A1 44 00 33 F6 56 E8 72 16 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 3D 13 00 00 FF 15 30 40 44 00 A3 84 B7 44 00 E8 FB 11 00 00 A3 E0 A1 44 00 E8 A4 0F 00 00 E8 E6 0E 00 00 E8 4E F6 FF FF 89 75 D0 8D 45 A4 50 FF 15 38 40 44 00 E8 77 0E 00 00 89 45 9C F6 45 D0 01 74 06 0F B7 45 D4 EB 03 6A 0A 58 50 FF 75 9C 56 56 FF 15 7C 41 44 00 50 E8 49 D4 FE FF 89 45 A0 50 E8 3C F6 FF FF 8B 45 EC 8B 08 8B 09 89 4D 98 50 51 E8 B5 0C 00 00 59 59 C3 8B 65 E8 FF 75 98 E8 2E F6 FF FF 83 3D E8 A1 44 00 01 75 05}
    condition:
        $a at pe.entry_point
}

rule PEiD_00186_Armadillo_v3_xx_
{
    meta:
        description = "[Armadillo v3.xx]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00187_Armadillo_v4_00_0053____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo v4.00.0053 -> Silicon Realms Toolworks]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 20 8B 4B 00 68 80 E4 48 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4B 00 33 D2 8A D4 89 15 A4 A1 4B 00 8B C8 81 E1 FF 00 00 00 89 0D A0 A1 4B 00 C1 E1 08 03 CA 89 0D 9C A1 4B 00 C1 E8 10 A3 98 A1 4B 00 33 F6 56 E8 78 16 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 43 13 00 00 FF 15 8C 30 4B 00 A3 A4 B7 4B 00 E8 01 12 00 00 A3 F8 A1 4B 00 E8 AA 0F 00 00 E8 EC 0E 00 00 E8 2D FA FF FF 89}
    condition:
        $a
}

rule PEiD_00188_Armadillo_v4_10____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo v4.10 -> Silicon Realms Toolworks]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 F8 8E 4C 00 68 D0 EA 49 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4C 00 33 D2 8A D4 89 15 7C A5 4C 00 8B C8 81 E1 FF 00 00 00 89 0D 78 A5 4C 00 C1 E1 08 03 CA 89 0D 74 A5 4C 00 C1 E8 10 A3 70 A5 4C 00 33 F6 56 E8 78 16 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 43 13 00 00 FF 15 8C 30 4C 00 A3 84 BB 4C 00 E8 01 12 00 00 A3 D0 A5 4C 00 E8 AA 0F 00 00 E8 EC 0E 00 00 E8 2D FA FF FF 89}
    condition:
        $a
}

rule PEiD_00189_Armadillo_v4_20____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo v4.20 -> Silicon Realms Toolworks]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 F8 8E 4C 00 68 F0 EA 49 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4C 00 33 D2 8A D4 89 15 84 A5 4C 00 8B C8 81 E1 FF 00 00 00 89 0D 80 A5 4C 00 C1 E1 08 03 CA 89 0D 7C A5 4C 00 C1 E8 10 A3 78 A5 4C 00 33 F6 56 E8 78 16 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 43 13 00 00 FF 15 8C 30 4C 00 A3 84 BB 4C 00 E8 01 12 00 00 A3 D8 A5 4C 00 E8 AA 0F 00 00 E8 EC 0E 00 00 E8 2D FA FF FF 89}
    condition:
        $a
}

rule PEiD_00190_Armadillo_v4_30___4_40____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo v4.30 - 4.40 -> Silicon Realms Toolworks]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 40 ?? ?? 00 68 80 ?? ?? 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 ?? ?? 00 33 D2 8A D4 89 15 30 ?? ?? 00 8B C8 81 E1 FF 00 00 00 89 0D 2C ?? ?? 00 C1 E1 08 03 CA 89 0D 28 ?? ?? 00 C1 E8 10 A3 24 ?? ?? 00 33 F6 56 E8 78 16 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 43 13 00 00 FF 15 8C ?? ?? 00 A3 24}
    condition:
        $a
}

rule PEiD_00191_Armadillo_v4_30___4_40____Silicon_Realms_Toolworks_
{
    meta:
        description = "[Armadillo v4.30 - 4.40 -> Silicon Realms Toolworks]"
        ep_only = "false"
    strings:
        $a = {60 E8 00 00 00 00 5D 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 9D 0F C9 8B CA F7 D1 59 58 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 9D 0F C9 8B CA F7 D1 59 58 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3}
    condition:
        $a
}

rule PEiD_00192_AsCrypt_v0_1____SToRM____3_
{
    meta:
        description = "[AsCrypt v0.1 -> SToRM - #3]"
        ep_only = "false"
    strings:
        $a = {80 ?? ?? ?? 83 ?? ?? ?? ?? 90 90 90 51 ?? ?? ?? 01 00 00 00 83 ?? ?? E2}
    condition:
        $a
}

rule PEiD_00193_AsCrypt_v0_1____SToRM___needs_to_be_added_
{
    meta:
        description = "[AsCrypt v0.1 -> SToRM - needs to be added]"
        ep_only = "false"
    strings:
        $a = {80 ?? ?? ?? 83 ?? ?? ?? ?? 90 90 90 83 ?? ?? E2}
    condition:
        $a
}

rule PEiD_00194_AsCrypt_v0_1____SToRM___needs_to_be_added_
{
    meta:
        description = "[AsCrypt v0.1 -> SToRM - needs to be added]"
        ep_only = "false"
    strings:
        $a = {80 ?? ?? ?? 83 ?? ?? ?? ?? 90 90 90 E2}
    condition:
        $a
}

rule PEiD_00195_AsCrypt_v0_1____SToRM___needs_to_be_added_
{
    meta:
        description = "[AsCrypt v0.1 -> SToRM - needs to be added]"
        ep_only = "false"
    strings:
        $a = {81 ?? ?? ?? ?? ?? ?? 83 ?? ?? ?? ?? ?? ?? ?? 83 ?? ?? E2 ?? EB}
    condition:
        $a
}

rule PEiD_00196_ASDPack_2_0____asd_
{
    meta:
        description = "[ASDPack 2.0 -> asd]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 8D 49 00 1F 01 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 90}
    condition:
        $a
}

rule PEiD_00197_ASDPack_2_0____asd_
{
    meta:
        description = "[ASDPack 2.0 -> asd]"
        ep_only = "false"
    strings:
        $a = {5B 43 83 7B 74 00 0F 84 08 00 00 00 89 43 14 E9}
    condition:
        $a
}

rule PEiD_00198_ASDPack_2_0____asd_
{
    meta:
        description = "[ASDPack 2.0 -> asd]"
        ep_only = "true"
    strings:
        $a = {8B 44 24 04 56 57 53 E8 CD 01 00 00 C3 00 00 00 00 00 00 00 00 00 00 00 00 00 10 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00199_ASDPack_v1_0____asd_
{
    meta:
        description = "[ASDPack v1.0 -> asd]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 56 53 E8 5C 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 10 00 00 ?? ?? ?? 00 00 00 00 00 00 00 40 00 00 ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 ?? ?? 00 00 10 00 00 00 ?? 00 00 00 ?? ?? 00 00 ?? ?? 00 00 ?? ?? 00 00 ?? 00 00 00 ?? ?? 00 00 ?? 00 00 00 ?? ?? 00 00 ?? 00 00 00 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 5B 81 EB E6 1D 40 00 83 7D 0C 01 75 11 55 E8 4F 01 00 00 E8 6A 01 00 00 5D E8 2C 00 00 00 8B B3 1A 1E 40 00 03 B3 FA 1D 40 00 8B 76 0C AD 0B C0 74 0D FF 75 10 FF 75 0C FF 75 08 FF D0 EB EE B8 01 00 00 00 5B 5E C9 C2 0C 00 55 6A 00 FF 93 20 21 40 00 89 83 FA 1D 40 00 6A 40 68 00 10 00 00 FF B3 02 1E 40 00 6A 00 FF 93 2C 21 40 00 89 83 06 1E 40 00 8B 83 F2 1D 40 00 03 83 FA 1D 40 00 50 FF B3 06 1E 40 00 50 E8 6D 01 00 00 5F}
    condition:
        $a
}

rule PEiD_00200_ASPack_1_08_
{
    meta:
        description = "[ASPack 1.08]"
        ep_only = "true"
    strings:
        $a = {90 90 90 75 01 90 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00201_ASPack_v1_00b_
{
    meta:
        description = "[ASPack v1.00b]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 81 ED 92 1A 44 ?? B8 8C 1A 44 ?? 03 C5 2B 85 CD 1D 44 ?? 89 85 D9 1D 44 ?? 80 BD C4 1D 44}
    condition:
        $a at pe.entry_point
}

rule PEiD_00202_ASPack_v1_01b_
{
    meta:
        description = "[ASPack v1.01b]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 81 ED D2 2A 44 ?? B8 CC 2A 44 ?? 03 C5 2B 85 A5 2E 44 ?? 89 85 B1 2E 44 ?? 80 BD 9C 2E 44}
    condition:
        $a at pe.entry_point
}

rule PEiD_00203_ASPack_v1_02a_
{
    meta:
        description = "[ASPack v1.02a]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 81 ED 3E D9 43 ?? B8 38 ?? ?? ?? 03 C5 2B 85 0B DE 43 ?? 89 85 17 DE 43 ?? 80 BD 01 DE 43 ?? ?? 75 15 FE 85 01 DE 43 ?? E8 1D ?? ?? ?? E8 79 02 ?? ?? E8 12 03 ?? ?? 8B 85 03 DE 43 ?? 03 85 17 DE 43 ?? 89 44 24 1C 61 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00204_ASPack_v1_02b_
{
    meta:
        description = "[ASPack v1.02b]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 96 78 43 00 B8 90 78 43 00 03 C5}
    condition:
        $a at pe.entry_point
}

rule PEiD_00205_ASPack_v1_02b_
{
    meta:
        description = "[ASPack v1.02b]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 81 ED 96 78 43 ?? B8 90 78 43 ?? 03 C5 2B 85 7D 7C 43 ?? 89 85 89 7C 43 ?? 80 BD 74 7C 43}
    condition:
        $a at pe.entry_point
}

rule PEiD_00206_ASPack_v1_03b_
{
    meta:
        description = "[ASPack v1.03b]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 81 ED AE 98 43 ?? B8 A8 98 43 ?? 03 C5 2B 85 18 9D 43 ?? 89 85 24 9D 43 ?? 80 BD 0E 9D 43}
    condition:
        $a at pe.entry_point
}

rule PEiD_00207_ASPack_v1_04b_
{
    meta:
        description = "[ASPack v1.04b]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? B8 ?? ?? ?? ?? 03 C5 2B 85 ?? 12 9D ?? 89 85 1E 9D ?? ?? 80 BD 08 9D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00208_ASPack_v1_05b_
{
    meta:
        description = "[ASPack v1.05b]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 81 ED CE 3A 44 ?? B8 C8 3A 44 ?? 03 C5 2B 85 B5 3E 44 ?? 89 85 C1 3E 44 ?? 80 BD AC 3E 44}
    condition:
        $a at pe.entry_point
}

rule PEiD_00209_ASPack_v1_061b_
{
    meta:
        description = "[ASPack v1.061b]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 81 ED EA A8 43 ?? B8 E4 A8 43 ?? 03 C5 2B 85 78 AD 43 ?? 89 85 84 AD 43 ?? 80 BD 6E AD 43}
    condition:
        $a at pe.entry_point
}

rule PEiD_00210_ASPack_v1_06b_
{
    meta:
        description = "[ASPack v1.06b]"
        ep_only = "true"
    strings:
        $a = {90 90 90 75 00 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00211_ASPack_v1_06b_
{
    meta:
        description = "[ASPack v1.06b]"
        ep_only = "true"
    strings:
        $a = {90 90 75 00 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00212_ASPack_v1_07b__DLL__
{
    meta:
        description = "[ASPack v1.07b (DLL)]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D ?? ?? ?? ?? ?? ?? B8 ?? ?? ?? ?? 03 C5}
    condition:
        $a at pe.entry_point
}

rule PEiD_00213_ASPack_v1_07b_
{
    meta:
        description = "[ASPack v1.07b]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? B8 ?? ?? ?? ?? 03 C5 2B 85 ?? 0B DE ?? 89 85 17 DE ?? ?? 80 BD 01 DE}
    condition:
        $a at pe.entry_point
}

rule PEiD_00214_ASPack_v1_07b_
{
    meta:
        description = "[ASPack v1.07b]"
        ep_only = "true"
    strings:
        $a = {90 90 90 75 ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00215_ASPack_v1_08_01____Alexey_Solodovnikov_
{
    meta:
        description = "[ASPack v1.08.01 -> Alexey Solodovnikov]"
        ep_only = "true"
    strings:
        $a = {60 EB ?? 5D EB ?? FF ?? ?? ?? ?? ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00216_ASPack_v1_08_01_
{
    meta:
        description = "[ASPack v1.08.01]"
        ep_only = "true"
    strings:
        $a = {60 EB 0A 5D EB 02 FF 25 45 FF E5 E8 E9 E8 F1 FF FF FF E9 81 ?? ?? ?? 44 00 BB 10 ?? 44 00 03 DD 2B 9D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00217_ASPack_v1_08_01_
{
    meta:
        description = "[ASPack v1.08.01]"
        ep_only = "true"
    strings:
        $a = {60 EB 0A 5D EB 02 FF 25 45 FF E5 E8 E9 E8 F1 FF FF FF E9 81 ?? ?? ?? 44 ?? BB 10 ?? 44 ?? 03 DD 2B 9D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00218_ASPack_v1_08_01_
{
    meta:
        description = "[ASPack v1.08.01]"
        ep_only = "true"
    strings:
        $a = {90 90 75 ?? 90 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00219_ASPack_v1_08_01_
{
    meta:
        description = "[ASPack v1.08.01]"
        ep_only = "true"
    strings:
        $a = {90 90 90 75 ?? 90 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00220_ASPack_v1_08_02_
{
    meta:
        description = "[ASPack v1.08.02]"
        ep_only = "true"
    strings:
        $a = {60 EB 0A 5D EB 02 FF 25 45 FF E5 E8 E9 E8 F1 FF FF FF E9 81 ED 23 6A 44 00 BB 10 ?? 44 00 03 DD 2B 9D 72}
    condition:
        $a at pe.entry_point
}

rule PEiD_00221_ASPack_v1_08_02_
{
    meta:
        description = "[ASPack v1.08.02]"
        ep_only = "true"
    strings:
        $a = {90 90 75 01 90 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00222_ASPack_v1_08_02_
{
    meta:
        description = "[ASPack v1.08.02]"
        ep_only = "true"
    strings:
        $a = {90 75 01 90 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00223_ASPack_v1_08_03_
{
    meta:
        description = "[ASPack v1.08.03]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 0A 4A 44 00 BB 04 4A 44 00 03 DD}
    condition:
        $a at pe.entry_point
}

rule PEiD_00224_ASPack_v1_08_03_
{
    meta:
        description = "[ASPack v1.08.03]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 0A 4A 44 00 BB 04 4A 44 00 03 DD 2B 9D B1 50 44 00 83 BD AC 50 44 00 00 89 9D BB 4E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00225_ASPack_v1_08_03_
{
    meta:
        description = "[ASPack v1.08.03]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D ?? ?? ?? ?? ?? ?? BB ?? ?? ?? ?? 03 DD}
    condition:
        $a at pe.entry_point
}

rule PEiD_00226_ASPack_v1_08_03_
{
    meta:
        description = "[ASPack v1.08.03]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D ?? ?? ?? ?? ?? ?? BB ?? ?? ?? ?? 03 DD 2B 9D B1 50 44 00 83 BD AC 50 44 00 00 89 9D BB 4E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00227_ASPack_v1_08_04____Alexey_Solodovnikov_
{
    meta:
        description = "[ASPack v1.08.04 -> Alexey Solodovnikov]"
        ep_only = "true"
    strings:
        $a = {60 E8 41 06 00 00 EB 41}
    condition:
        $a at pe.entry_point
}

rule PEiD_00228_ASPack_v1_08_x_
{
    meta:
        description = "[ASPack v1.08.x]"
        ep_only = "true"
    strings:
        $a = {60 EB 03 5D FF E5 E8 F8 FF FF FF 81 ED 1B 6A 44 00 BB 10 6A 44 00 03 DD 2B 9D 2A}
    condition:
        $a at pe.entry_point
}

rule PEiD_00229_ASPack_v1_08_
{
    meta:
        description = "[ASPack v1.08]"
        ep_only = "true"
    strings:
        $a = {90 75 01 FF E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00230_ASPack_v1_08_
{
    meta:
        description = "[ASPack v1.08]"
        ep_only = "true"
    strings:
        $a = {90 90 90 75 01 FF E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00231_ASPack_v1_08_
{
    meta:
        description = "[ASPack v1.08]"
        ep_only = "true"
    strings:
        $a = {90 90 75 01 FF E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00232_ASPack_v2_000____Alexey_Solodovnikov_
{
    meta:
        description = "[ASPack v2.000 -> Alexey Solodovnikov]"
        ep_only = "true"
    strings:
        $a = {60 E8 70 05 00 00 EB 4C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00233_ASPack_v2_001____Alexey_Solodovnikov_
{
    meta:
        description = "[ASPack v2.001 -> Alexey Solodovnikov]"
        ep_only = "true"
    strings:
        $a = {60 E8 72 05 00 00 EB 4C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00234_ASPack_v2_11_
{
    meta:
        description = "[ASPack v2.11]"
        ep_only = "true"
    strings:
        $a = {60 E9 3D 04 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00235_ASPack_v2_11b_
{
    meta:
        description = "[ASPack v2.11b]"
        ep_only = "true"
    strings:
        $a = {60 E8 02 00 00 00 EB 09 5D 55 81 ED 39 39 44 00 C3 E9 3D 04 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00236_ASPack_v2_11c_
{
    meta:
        description = "[ASPack v2.11c]"
        ep_only = "true"
    strings:
        $a = {60 E8 02 00 00 00 EB 09 5D 55 81 ED 39 39 44 00 C3 E9 59 04 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00237_ASPack_v2_11d_
{
    meta:
        description = "[ASPack v2.11d]"
        ep_only = "true"
    strings:
        $a = {60 E8 02 00 00 00 EB 09 5D 55}
    condition:
        $a at pe.entry_point
}

rule PEiD_00238_ASPack_v2_12_
{
    meta:
        description = "[ASPack v2.12]"
        ep_only = "false"
    strings:
        $a = {60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01}
    condition:
        $a
}

rule PEiD_00239_ASPack_v2_12_
{
    meta:
        description = "[ASPack v2.12]"
        ep_only = "true"
    strings:
        $a = {60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00240_ASPack_v2_1_
{
    meta:
        description = "[ASPack v2.1]"
        ep_only = "true"
    strings:
        $a = {60 E8 72 05 00 00 EB 33 87 DB 90 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00241_ASPack_v2_xx_
{
    meta:
        description = "[ASPack v2.xx]"
        ep_only = "true"
    strings:
        $a = {A8 03 00 00 61 75 08 B8 01 00 00 00 C2 0C 00 68 00 00 00 00 C3 8B 85 26 04 00 00 8D 8D 3B 04 00 00 51 50 FF 95}
    condition:
        $a at pe.entry_point
}

rule PEiD_00242_ASPack_v2_xx_
{
    meta:
        description = "[ASPack v2.xx]"
        ep_only = "true"
    strings:
        $a = {A8 03 ?? ?? 61 75 08 B8 01 ?? ?? ?? C2 0C ?? 68 ?? ?? ?? ?? C3 8B 85 26 04 ?? ?? 8D 8D 3B 04 ?? ?? 51 50 FF 95}
    condition:
        $a at pe.entry_point
}

rule PEiD_00243_ASPR_Stripper_v2_x_unpacked_
{
    meta:
        description = "[ASPR Stripper v2.x unpacked]"
        ep_only = "true"
    strings:
        $a = {BB ?? ?? ?? ?? E9 ?? ?? ?? ?? 60 9C FC BF ?? ?? ?? ?? B9 ?? ?? ?? ?? F3 AA 9D 61 C3 55 8B EC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00244_ASProtect_1_23_RC4_build_08_07__dll_____Alexey_Solodovnikov__h__
{
    meta:
        description = "[ASProtect 1.23 RC4 build 08.07 (dll) -> Alexey Solodovnikov (h)]"
        ep_only = "false"
    strings:
        $a = {60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_00245_ASProtect_1_23_RC4_build_08_07__exe_____Alexey_Solodovnikov__h__
{
    meta:
        description = "[ASProtect 1.23 RC4 build 08.07 (exe) -> Alexey Solodovnikov (h)]"
        ep_only = "false"
    strings:
        $a = {90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB ?? ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_00246_ASProtect_1_33___2_1_Registered____Alexey_Solodovnikov_
{
    meta:
        description = "[ASProtect 1.33 - 2.1 Registered -> Alexey Solodovnikov]"
        ep_only = "true"
    strings:
        $a = {68 01 ?? ?? ?? E8 01 00 00 00 C3 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00247_ASProtect_2_0_
{
    meta:
        description = "[ASProtect 2.0]"
        ep_only = "false"
    strings:
        $a = {68 01 ?? 40 00 E8 01 00 00 00 C3 C3}
    condition:
        $a
}

rule PEiD_00248_ASProtect_2_3_SKE_build_04_26_Beta_
{
    meta:
        description = "[ASProtect 2.3 SKE build 04.26 Beta]"
        ep_only = "false"
    strings:
        $a = {68 01 60 40 00 E8 01 00 00 00 C3 C3 0D 6C 65 3E 09 84 BB 91 89 38 D0 5A 1D 60 6D AF D5 51 2D A9 2F E1 62 D8 C1 5A 8D 6B 6E 94 A7 F9 1D 26 8C 8E FB 08 A8 7E 9D 3B 0C DF 14 5E 62 14 7D 78 D0 6E}
    condition:
        $a
}

rule PEiD_00249_ASProtect_SKE_2_1_2_2__dll_____Alexey_Solodovnikov__h__
{
    meta:
        description = "[ASProtect SKE 2.1/2.2 (dll) -> Alexey Solodovnikov (h)]"
        ep_only = "false"
    strings:
        $a = {60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 ED 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_00250_ASProtect_SKE_2_1_2_2__dll_____Alexey_Solodovnikov__h__
{
    meta:
        description = "[ASProtect SKE 2.1/2.2 (dll) -> Alexey Solodovnikov (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 ED 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00251_ASProtect_SKE_2_1_2_2__exe_____Alexey_Solodovnikov__h__
{
    meta:
        description = "[ASProtect SKE 2.1/2.2 (exe) -> Alexey Solodovnikov (h)]"
        ep_only = "false"
    strings:
        $a = {90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 ED 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_00252_ASProtect_SKE_2_1_2_2__exe_____Alexey_Solodovnikov__h__
{
    meta:
        description = "[ASProtect SKE 2.1/2.2 (exe) -> Alexey Solodovnikov (h)]"
        ep_only = "false"
    strings:
        $a = {90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 ED 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C}
    condition:
        $a
}

rule PEiD_00253_ASProtect_SKE_2_1_2_2__exe_____Alexey_Solodovnikov__h__
{
    meta:
        description = "[ASProtect SKE 2.1/2.2 (exe) -> Alexey Solodovnikov (h)]"
        ep_only = "false"
    strings:
        $a = {90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 ED 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C 00}
    condition:
        $a
}

rule PEiD_00254_ASProtect_SKE_2_3____Alexey_Solodovnikov__h__
{
    meta:
        description = "[ASProtect SKE 2.3 -> Alexey Solodovnikov (h)]"
        ep_only = "false"
    strings:
        $a = {90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 E5 0B 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C}
    condition:
        $a
}

rule PEiD_00255_ASProtect_v1_0_
{
    meta:
        description = "[ASProtect v1.0]"
        ep_only = "true"
    strings:
        $a = {60 E8 01 ?? ?? ?? 90 5D 81 ED ?? ?? ?? ?? BB ?? ?? ?? ?? 03 DD 2B 9D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00256_ASProtect_v1_1_MTE_
{
    meta:
        description = "[ASProtect v1.1 MTE]"
        ep_only = "true"
    strings:
        $a = {60 E9 ?? ?? ?? ?? 91 78 79 79 79 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00257_ASProtect_v1_1_MTEc_
{
    meta:
        description = "[ASProtect v1.1 MTEc]"
        ep_only = "true"
    strings:
        $a = {90 60 E8 1B ?? ?? ?? E9 FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00258_ASProtect_v1_1_
{
    meta:
        description = "[ASProtect v1.1]"
        ep_only = "true"
    strings:
        $a = {60 E9 ?? 04 ?? ?? E9 ?? ?? ?? ?? ?? ?? ?? EE}
    condition:
        $a at pe.entry_point
}

rule PEiD_00259_ASProtect_v1_2____Alexey_Solodovnikov__h1__
{
    meta:
        description = "[ASProtect v1.2 -> Alexey Solodovnikov (h1)]"
        ep_only = "false"
    strings:
        $a = {90 60 E8 1B 00 00 00 E9 FC 8D B5 0F 06 00 00 8B FE B9 97 00 00 00 AD 35 78 56 34 12 AB 49 75 F6 EB 04 5D 45 55 C3 E9 ?? ?? ?? 00}
    condition:
        $a
}

rule PEiD_00260_ASProtect_v1_23_RC1_
{
    meta:
        description = "[ASProtect v1.23 RC1]"
        ep_only = "true"
    strings:
        $a = {68 01 ?? ?? 00 E8 01 00 00 00 C3 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00261_ASProtect_v1_23_RC4_build_08_07__dll_____Alexey_Solodovnikov__h__
{
    meta:
        description = "[ASProtect v1.23 RC4 build 08.07 (dll) -> Alexey Solodovnikov (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00262_ASProtect_v1_23_RC4_build_08_07__exe_____Alexey_Solodovnikov__h__
{
    meta:
        description = "[ASProtect v1.23 RC4 build 08.07 (exe) -> Alexey Solodovnikov (h)]"
        ep_only = "false"
    strings:
        $a = {90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB ?? ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C 00}
    condition:
        $a
}

rule PEiD_00263_ASProtect_v1_2x__New_Strain__
{
    meta:
        description = "[ASProtect v1.2x (New Strain)]"
        ep_only = "true"
    strings:
        $a = {68 01 ?? ?? ?? E8 01 ?? ?? ?? C3 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00264_ASProtect_v1_2x_
{
    meta:
        description = "[ASProtect v1.2x]"
        ep_only = "true"
    strings:
        $a = {00 00 68 01 ?? ?? ?? C3 AA}
    condition:
        $a at pe.entry_point
}

rule PEiD_00265_ASProtect_V2_X_DLL____Alexey_Solodovnikov_
{
    meta:
        description = "[ASProtect V2.X DLL -> Alexey Solodovnikov]"
        ep_only = "true"
    strings:
        $a = {60 E8 03 00 00 00 E9 ?? ?? 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ?? ?? ?? ?? 03 DD}
    condition:
        $a at pe.entry_point
}

rule PEiD_00266_ASProtect_v_______If_you_know_this_version__post_on_PEiD_board__h2__
{
    meta:
        description = "[ASProtect v?.? -> If you know this version, post on PEiD board (h2)]"
        ep_only = "false"
    strings:
        $a = {90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? 00 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 DD 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_00267_ASProtect_v_______If_you_know_this_version__post_on_PEiD_board_
{
    meta:
        description = "[ASProtect v?.? -> If you know this version, post on PEiD board]"
        ep_only = "true"
    strings:
        $a = {90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? 00 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 DD 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00268_ASProtect_vx_x_
{
    meta:
        description = "[ASProtect vx.x]"
        ep_only = "true"
    strings:
        $a = {60 ?? ?? ?? ?? ?? 90 5D ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 DD}
    condition:
        $a at pe.entry_point
}

rule PEiD_00269_ass___crypter____by_santasdad_
{
    meta:
        description = "[ass - crypter -> by santasdad]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 EC 53 ?? ?? ?? ?? 89 45 EC B8 98 40 00 10 E8 AC EA FF FF 33 C0 55 68 78 51 00 10 64 ?? ?? ?? ?? 20 6A 0A 68 88 51 00 10 A1 E0 97 00 10 50 E8 D8 EA FF FF 8B D8 53 A1 E0 97 00 10 50 E8 12 EB FF FF 8B F8 53 A1 E0 97 00 10 50 E8 DC EA FF FF 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00270_ass___crypter____by_santasdad_
{
    meta:
        description = "[ass - crypter -> by santasdad]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 EC 53 ?? ?? ?? ?? 89 45 EC B8 98 40 00 10 E8 AC EA FF FF 33 C0 55 68 78 51 00 10 64 ?? ?? ?? ?? 20 6A 0A 68 88 51 00 10 A1 E0 97 00 10 50 E8 D8 EA FF FF 8B D8 53 A1 E0 97 00 10 50 E8 12 EB FF FF 8B F8 53 A1 E0 97 00 10 50 E8 DC EA FF FF 8B D8 53 E8 DC EA FF FF 8B F0 85 F6 74 26 8B D7 4A B8 F0 97 00 10 E8 C9 E7 FF FF B8 F0 97 00 10 E8 B7 E7 FF FF 8B CF 8B D6 E8 EE EA FF FF 53 E8 98 EA FF FF 8D 4D EC BA 9C 51 00 10 A1 F0 97 00 10 E8 22 EB FF FF 8B 55 EC B8 F0 97 00 10 E8 89 E6 FF FF B8 F0 97 00 10 E8 7F E7 FF FF E8 6E EC FF FF 33 C0 5A 59 59 64 89 10 68 7F 51 00 10 8D 45 EC E8 11 E6 FF FF C3 E9 FF DF FF FF EB F0 5F 5E 5B E8 0D E5 FF FF 00 53 45 54 54 49 4E 47 53 00 00 00 00 FF FF FF FF 1C 00 00 00 45 4E 54 45 52 20 59 4F 55 52 20 4F 57 4E 20 50 41 53 53 57 4F 52 44 20 48 45 52 45}
    condition:
        $a at pe.entry_point
}

rule PEiD_00271_ASYLUM_Music_File_v_1_0_
{
    meta:
        description = "[ASYLUM Music File v.1.0]"
        ep_only = "false"
    strings:
        $a = {41 53 59 4C 55 4D 20 4D 75 73 69 63 20 46 6F 72 6D 61 74 20 56 31 2E 30 00}
    condition:
        $a
}

rule PEiD_00272_Audio_CD_file_
{
    meta:
        description = "[Audio-CD file]"
        ep_only = "false"
    strings:
        $a = {52 49 46 46 ?? ?? ?? ?? 43 44 44 41 66 6D 74}
    condition:
        $a
}

rule PEiD_00273_AutoDesk_Animation_file_
{
    meta:
        description = "[AutoDesk Animation file]"
        ep_only = "false"
    strings:
        $a = {?? ?? ?? 00 12 AF ?? ?? 40 01 C8}
    condition:
        $a
}

rule PEiD_00274_AverCryptor_1_0____os1r1s_
{
    meta:
        description = "[AverCryptor 1.0 -> os1r1s]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 75 17 40 00 8B BD 9C 18 40 00 8B 8D A4 18 40 00 B8 BC 18 40 00 03 C5 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 A0 18 40 00 33 C0 51 33 C9 66 B9 FA 00 66 83 F9 00 74 49 8B 57 0C 03 95 A0 18 40 00 8B 85 A8 18 40 00 83 F8 02 75 06 81 C2 00 02 00 00 51 8B 4F 10 83 F8 02 75 06 81 E9 00 02 00 00 57 BF C8 00 00 00 8B F1 E8 27 00 00 00 8B C8 5F B8 BC 18 40 00 03 C5 E8 24 00 00 00 59 49 EB B1 59 83 C7 28 49 EB 8A 8B 85 98 18 40 00 89 44 24 1C 61 FF E0 56 57 4F F7 D7 23 F7 8B C6 5F 5E C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00275_AverCryptor_1_02_beta____os1r1s_
{
    meta:
        description = "[AverCryptor 1.02 beta -> os1r1s]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 0C 17 40 00 8B BD 33 18 40 00 8B 8D 3B 18 40 00 B8 51 18 40 00 03 C5 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 37 18 40 00 33 C0 51 33 C9 66 B9 F7 00 66 83 F9 00 74 49 8B 57 0C 03 95 37 18 40 00 8B 85 3F 18 40 00 83 F8 02 75 06 81 C2 00 02 00 00 51 8B 4F 10 83 F8 02 75 06 81 E9 00 02 00 00 57 BF C8 00 00 00 8B F1 E8 27 00 00 00 8B C8 5F B8 51 18 40 00 03 C5 E8 24 00 00 00 59 49 EB B1 59 83 C7 28 49 EB 8A 8B 85 2F 18 40 00 89 44 24 1C 61 FF E0 56 57 4F F7 D7 23 F7 8B C6 5F 5E C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00276_AVI_movie_file_
{
    meta:
        description = "[AVI movie file]"
        ep_only = "false"
    strings:
        $a = {52 49 46 46 ?? ?? ?? ?? 41 56 49 ?? 4C 49 53 54}
    condition:
        $a
}

rule PEiD_00277_AVP_Antiviral_Database_
{
    meta:
        description = "[AVP Antiviral Database]"
        ep_only = "false"
    strings:
        $a = {41 56 50 20 41 6E 74 69 76 69 72 61 6C 20 44 61 74 61 62 61 73 65}
    condition:
        $a
}

rule PEiD_00278_AVP_Inspector_Database_
{
    meta:
        description = "[AVP Inspector Database]"
        ep_only = "false"
    strings:
        $a = {47 68 6F 73 74 20 42 75 73 74 65 72}
    condition:
        $a
}

rule PEiD_00279_AVPACK_v1_20_
{
    meta:
        description = "[AVPACK v1.20]"
        ep_only = "true"
    strings:
        $a = {50 1E 0E 1F 16 07 33 F6 8B FE B9 ?? ?? FC F3 A5 06 BB ?? ?? 53 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00280_AZProtect_0001___by_AlexZ_aka_AZCRC_
{
    meta:
        description = "[AZProtect 0001 - by AlexZ aka AZCRC]"
        ep_only = "true"
    strings:
        $a = {FC 33 C9 49 8B D1 33 C0 33 DB AC 32 C1 8A CD 8A EA 8A D6 B6 08 66 D1 EB 66 D1 D8 73 09 66 35 20 83 66 81 F3 B8 ED FE CE 75 EB 33 C8 33 D3 4F 75 D5 F7 D2 F7 D1 8B C2 C1 C0 10 66 8B C1 C3 F0 DA 55 8B EC 53 56 33 C9 33 DB 8B 4D 0C 8B 55 10 8B 75 08 4E 4A 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_00281_AZProtect_0001___by_AlexZ_aka_AZCRC_
{
    meta:
        description = "[AZProtect 0001 - by AlexZ aka AZCRC]"
        ep_only = "true"
    strings:
        $a = {EB 70 FC 60 8C 80 4D 11 00 70 25 81 00 40 0D 91 BB 60 8C 80 4D 11 00 70 21 81 1D 61 0D 81 00 40 CE 60 8C 80 4D 11 00 70 25 81 25 81 25 81 25 81 29 61 41 81 31 61 1D 61 00 40 B7 30 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 60 BE 00 ?? ?? 00 BF 00 00 40 00 EB 17 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 00 00 00 00 FF 25 ?? ?? ?? 00 8B C6 03 C7 8B F8 57 55 8B EC 05 7F 00 00 00 50 E8 E5 FF FF FF BA 8C ?? ?? 00 89 02 E9 1A 01 00 00 ?? 00 00 00 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 47 65 74 56 6F 6C 75 6D 65 49 6E 66 6F 72 6D 61 74 69 6F 6E 41 00 4D 65 73 73 61 67 65 42 6F 78 41 00 45 78 69 74 50 72 6F 63 65 73 73 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41}
    condition:
        $a at pe.entry_point
}

rule PEiD_00282_AZProtect_0001___by_AlexZ_aka_AZCRC_
{
    meta:
        description = "[AZProtect 0001 - by AlexZ aka AZCRC]"
        ep_only = "false"
    strings:
        $a = {FC 33 C9 49 8B D1 33 C0 33 DB AC 32 C1 8A CD 8A EA 8A D6 B6 08 66 D1 EB 66 D1 D8 73 09 66 35 20 83 66 81 F3 B8 ED FE CE 75 EB 33 C8 33 D3 4F 75 D5 F7 D2 F7 D1 8B C2 C1 C0 10 66 8B C1 C3 F0 DA 55 8B EC 53 56 33 C9 33 DB 8B 4D 0C 8B 55 10 8B 75 08 4E 4A 83 FB 08 72 05 33 DB 43 EB 01 43 33 C0 8A 04 31 8A 24 13 2A C4 88 04 31 E2 E6 5E 5B C9 C2 0C}
    condition:
        $a
}

rule PEiD_00283_AZProtect_0x0001____AlexZ_aka_AZCRC_
{
    meta:
        description = "[AZProtect 0x0001 -> AlexZ aka AZCRC]"
        ep_only = "true"
    strings:
        $a = {EB 70 FC 60 8C 80 4D 11 00 70 25 81 00 40 0D 91 BB 60 8C 80 4D 11 00 70 21 81 1D 61 0D 81 00 40 CE 60 8C 80 4D 11 00 70 25 81 25 81 25 81 25 81 29 61 41 81 31 61 1D 61 00 40 B7 30 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00284_AZProtect_
{
    meta:
        description = "[AZProtect]"
        ep_only = "true"
    strings:
        $a = {EB 70 FC 60 8C 80 4D 11 00 70 25 81 00 40 0D 91 BB 60 8C 80 4D 11 00 70 21 81 1D 61 0D 81 00 40 CE 60 8C 80 4D 11 00 70 25 81 25 81 25 81 25 81 29 61 41 81 31 61 1D 61 00 40 B7 30}
    condition:
        $a at pe.entry_point
}

rule PEiD_00285_BamBam_0_01_
{
    meta:
        description = "[BamBam 0.01]"
        ep_only = "false"
    strings:
        $a = {6A 14 E8 9A 05 00 00 8B D8 53 68 FB ?? ?? 00 E8 6C FD FF FF B9 05 00 00 00 8B F3 BF FB ?? ?? 00 53 F3 A5 E8 8D 05 00 00 8B 3D 03 ?? ?? 00 A1 2B ?? ?? 00 66 8B 15 2F ?? ?? 00 B9 80 ?? ?? 00 2B CF 89 45 E8 89 0D 6B ?? ?? 00 66 89 55 EC 8B 41 3C 33 D2 03 C1}
    condition:
        $a
}

rule PEiD_00286_bambam_V0_01____bedrock___Sign_by_fly_
{
    meta:
        description = "[bambam V0.01 -> bedrock ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {6A 14 E8 9A 05 00 00 8B D8 53 68 ?? ?? ?? ?? E8 6C FD FF FF B9 05 00 00 00 8B F3 BF ?? ?? ?? ?? 53 F3 A5 E8 8D 05 00 00 8B 3D ?? ?? ?? ?? A1 ?? ?? ?? ?? 66 8B 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? 2B CF 89 45 E8 89 0D ?? ?? ?? ?? 66 89 55 EC 8B 41 3C 33 D2 03 C1 83 C4 10 66 8B 48 06 66 8B 50 14 81 E1 FF FF 00 00 8D 5C 02 18 8D 41 FF 85 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00287_bambam_V0_01____bedrock_
{
    meta:
        description = "[bambam V0.01 -> bedrock]"
        ep_only = "true"
    strings:
        $a = {6A 14 E8 9A 05 00 00 8B D8 53 68 ?? ?? ?? ?? E8 6C FD FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00288_bambam_V0_01____bedrock_
{
    meta:
        description = "[bambam V0.01 -> bedrock]"
        ep_only = "true"
    strings:
        $a = {6A 14 E8 9A 05 00 00 8B D8 53 68 ?? ?? ?? ?? E8 6C FD FF FF B9 05 00 00 00 8B F3 BF ?? ?? ?? ?? 53 F3 A5 E8 8D 05 00 00 8B 3D ?? ?? ?? ?? A1 ?? ?? ?? ?? 66 8B 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? 2B CF 89 45 E8 89 0D ?? ?? ?? ?? 66 89 55 EC 8B 41 3C 33 D2 03 C1}
    condition:
        $a at pe.entry_point
}

rule PEiD_00289_BamBam_v0_01_
{
    meta:
        description = "[BamBam v0.01]"
        ep_only = "false"
    strings:
        $a = {6A 14 E8 9A 05 00 00 8B D8 53 68 FB ?? ?? 00 E8 6C FD FF FF B9 05 00 00 00 8B F3 BF FB ?? ?? 00 53 F3 A5 E8 8D 05 00 00 8B 3D 03 ?? ?? 00 A1 2B ?? ?? 00 66 8B 15 2F ?? ?? 00 B9 80 ?? ?? 00 2B CF 89 45 E8 89 0D 6B ?? ?? 00 66 89 55 EC 8B 41 3C 33 D2 03 C1 83 C4 10 66 8B 48 06 66 8B 50 14 81 E1 FF FF 00 00 8D 5C 02 18 8D 41 FF 85 C0 0F 8E 39 01 00 00 89 45 F0 C6 45 FF 00 8D 7D E8 8B F3 8A 0E 8A 17 8A C1 3A CA 75 1E 84 C0 74 16 8A 56 01 8A 4F 01 8A C2 3A D1 75 0E 83 C6 02 83 C7 02 84 C0 75 DC 33 C0 EB 05 1B C0 83 D8 FF 85 C0 75 04 C6 45 FF 01 8B 43 10 85 C0 0F 84 DD 00 00 00 8B 43 08 50 E8 D7 04 00 00 8A 4D FF 83 C4 04 84 C9 8B 4B 08 89 45 F8 C7 45 F4 00 00 00 00 74 61 8B 15 07 ?? ?? 00 8B 35 6B ?? ?? 00 8B 7B 0C 2B CA 03 F2 8B D1 03 F7 8B F8 C1 E9 02 F3 A5}
    condition:
        $a
}

rule PEiD_00290_bambam_V0_04____bedrock___Sign_by_fly_
{
    meta:
        description = "[bambam V0.04 -> bedrock ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {BF ?? ?? ?? ?? 83 C9 FF 33 C0 68 ?? ?? ?? ?? F2 AE F7 D1 49 51 68 ?? ?? ?? ?? E8 11 0A 00 00 83 C4 0C 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 BF ?? ?? ?? ?? 83 C9 FF 33 C0 F2 AE F7 D1 49 BF ?? ?? ?? ?? 8B D1 68 ?? ?? ?? ?? C1 E9 02 F3 AB 8B CA 83 E1 03 F3 AA BF ?? ?? ?? ?? 83 C9 FF 33 C0 F2 AE F7 D1 49 51 68 ?? ?? ?? ?? E8 C0 09 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00291_bambam_V0_04____bedrock_
{
    meta:
        description = "[bambam V0.04 -> bedrock]"
        ep_only = "true"
    strings:
        $a = {BF ?? ?? ?? ?? 83 C9 FF 33 C0 68 ?? ?? ?? ?? F2 AE F7 D1 49 51 68 ?? ?? ?? ?? E8 11 0A 00 00 83 C4 0C 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 BF ?? ?? ?? ?? 83 C9 FF 33 C0 F2 AE F7 D1 49 BF ?? ?? ?? ?? 8B D1 68 ?? ?? ?? ?? C1 E9 02 F3 AB 8B CA 83 E1 03 F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00292_BDC_HelpSystem_Help_file_
{
    meta:
        description = "[BDC HelpSystem Help file]"
        ep_only = "false"
    strings:
        $a = {42 44 43 20 48 65 6C 70 53 79 73 74 65 6D}
    condition:
        $a
}

rule PEiD_00293_beria_v0_07_public_WIP____symbiont__h__
{
    meta:
        description = "[beria v0.07 public WIP -> symbiont (h)]"
        ep_only = "true"
    strings:
        $a = {83 EC 18 53 8B 1D 00 30 ?? ?? 55 56 57 68 30 07 00 00 33 ED 55 FF D3 8B F0 3B F5 74 0D 89 AE 20 07 00 00 E8 88 0F 00 00 EB 02 33 F6 6A 10 55 89 35 30 40 ?? ?? FF D3 8B F0 3B F5 74 09 89 2E E8 3C FE FF FF EB 02 33 F6 6A 18 55 89 35 D8 43 ?? ?? FF D3 8B F0 3B F5 74 37 8B 46 0C 3B C5 8B 3D 04 30 ?? ?? 89 2E 89 6E 04 89 6E 08 74 06 50 FF D7 89 6E 0C 8B 46 10 3B C5 74 06 50 FF D7 89 6E 10 8B 46 14 3B C5 74 0A 50 FF D7 89 6E 14 EB 02 33 F6 6A 10 55 89 35 A4 40 ?? ?? FF D3 8B F0 3B F5 74 09 E8 08 12 00 00 8B C6 EB 02 33 C0 8B 48 08 8B 51 04 8B 09 8B 35 30 30 ?? ?? A3 D4 43 ?? ?? 8B 00 03 D0 52 03 C8 51 FF D6 8B 3D 24 30 ?? ?? 50 FF D7}
    condition:
        $a at pe.entry_point
}

rule PEiD_00294_beria_v0_07_public_WIP____symbiont_
{
    meta:
        description = "[beria v0.07 public WIP -> symbiont]"
        ep_only = "true"
    strings:
        $a = {83 EC 18 53 8B 1D 00 30 ?? ?? 55 56 57 68 30 07 00 00 33 ED 55 FF D3 8B F0 3B F5 74 0D 89 AE 20 07 00 00 E8 88 0F 00 00 EB 02 33 F6 6A 10 55 89 35 30 40 ?? ?? FF D3 8B F0 3B F5 74 09 89 2E E8 3C FE FF FF EB 02 33 F6 6A 18 55 89 35 D8 43 ?? ?? FF D3 8B F0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00295_Berio_1_00_beta__h__
{
    meta:
        description = "[Berio 1.00 beta (h)]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 E9 01 12 00 00 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 B0 01 00 83 BD 22 04 00 00 00 89 9D 22 04 00 00 0F 85 65 03 00 00 8D 85 2E 04 00 00 50 FF 95 4D 0F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00296_Berio_2_00_beta__h__
{
    meta:
        description = "[Berio 2.00 beta (h)]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 E9 01 74 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_00297_BeRo_Tiny_Pascal____BeRo_
{
    meta:
        description = "[BeRo Tiny Pascal -> BeRo]"
        ep_only = "true"
    strings:
        $a = {E9 ?? ?? ?? ?? 20 43 6F 6D 70 69 6C 65 64 20 62 79 3A 20 42 65 52 6F 54 69 6E 79 50 61 73 63 61 6C 20 2D 20 28 43 29 20 43 6F 70 79 72 69 67 68 74 20 32 30 30 36 2C 20 42 65 6E 6A 61 6D 69 6E 20 27 42 65 52 6F 27 20 52 6F 73 73 65 61 75 78 20}
    condition:
        $a at pe.entry_point
}

rule PEiD_00298_BeRoEXEPacker_v1_00__DLL_____BeRo___Farbrausch_
{
    meta:
        description = "[BeRoEXEPacker v1.00 (DLL) -> BeRo / Farbrausch]"
        ep_only = "true"
    strings:
        $a = {83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B F9 81 FE ?? ?? ?? ?? 7F 10 AC 47 04 18 2C 02 73 F0 29 3E 03 F1 03 F9 EB E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00299_BeRoEXEPacker_v1_00__DLL_____BeRo___Farbrausch_
{
    meta:
        description = "[BeRoEXEPacker v1.00 (DLL) -> BeRo / Farbrausch]"
        ep_only = "true"
    strings:
        $a = {83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B F9 81 FE ?? ?? ?? ?? 7F 10 AC 47 04 18 2C 02 73 F0 29 3E 03 F1 03 F9 EB E8 BA ?? ?? ?? ?? 8D B2}
    condition:
        $a at pe.entry_point
}

rule PEiD_00300_BeRoEXEPacker_v1_00__DLL_____BeRo___Farbrausch_
{
    meta:
        description = "[BeRoEXEPacker v1.00 (DLL) -> BeRo / Farbrausch]"
        ep_only = "true"
    strings:
        $a = {83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC B2 80 33 DB A4 B3 02 E8 ?? ?? ?? ?? 73 F6 33 C9 E8 ?? ?? ?? ?? 73 1C 33 C0 E8 ?? ?? ?? ?? 73 23 B3 02 41 B0 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_00301_BeRoEXEPacker_v1_00__LZMA__
{
    meta:
        description = "[BeRoEXEPacker v1.00 (LZMA)]"
        ep_only = "true"
    strings:
        $a = {60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 04 00 00 00 8B F9 81 FE ?? ?? ?? ?? 7F 10 AC 47 04 18 2C 02 73 F0 29 3E 03 F1 03 F9 EB E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00302_BeRoEXEPacker_V1_00____BeRo___Sign_by_fly_
{
    meta:
        description = "[BeRoEXEPacker V1.00 -> BeRo ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {BA ?? ?? ?? ?? 8D B2 ?? ?? ?? ?? 8B 46 ?? 85 C0 74 51 03 C2 8B 7E ?? 8B 1E 85 DB 75 02 8B DF 03 DA 03 FA 52 57 50 FF 15 ?? ?? ?? ?? 5F 5A 85 C0 74 2F 8B C8 8B 03 85 C0 74 22 0F BA F0 1F 72 04 8D 44 ?? ?? 51 52 57 50 51 FF 15 ?? ?? ?? ?? 5F 5A 59 85 C0 74 0B AB 83 C3 04 EB D8 83 C6 14 EB AA 61 C3}
    condition:
        $a
}

rule PEiD_00303_BeRoEXEPacker_v1_00____BeRo___Farbrausch_
{
    meta:
        description = "[BeRoEXEPacker v1.00 -> BeRo / Farbrausch]"
        ep_only = "false"
    strings:
        $a = {60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 04 00 00 00 8B F9 81 FE ?? ?? ?? ?? 7F 10 AC 47 04 18 2C 02 73 F0 29 3E 03 F1 03 F9 EB E8 BA ?? ?? ?? ?? 8D B2}
    condition:
        $a
}

rule PEiD_00304_BeRoEXEPacker_v1_00____BeRo___Farbrausch_
{
    meta:
        description = "[BeRoEXEPacker v1.00 -> BeRo / Farbrausch]"
        ep_only = "true"
    strings:
        $a = {60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC ?? ?? ?? ?? A4 ?? ?? ?? ?? 00 ?? ?? ?? ?? 33 C9 E8 64 00 00 00 73 1C ?? ?? ?? ?? 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 ?? ?? ?? ?? D4 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00305_BeRoEXEPacker_V1_00____BeRo_
{
    meta:
        description = "[BeRoEXEPacker V1.00 -> BeRo]"
        ep_only = "false"
    strings:
        $a = {BA ?? ?? ?? ?? 8D B2 ?? ?? ?? ?? 8B 46 ?? 85 C0 74 51 03 C2 8B 7E ?? 8B 1E 85 DB 75 02 8B DF 03 DA 03 FA 52 57 50 FF 15 ?? ?? ?? ?? 5F 5A 85 C0 74 2F 8B C8 8B 03 85 C0 74 22 0F BA F0 1F 72 04 8D 44 ?? ?? 51 52 57 50 51 FF 15 ?? ?? ?? ?? 5F 5A 59 85 C0 74}
    condition:
        $a
}

rule PEiD_00306_BeRoEXEPacker_v1_00__LZBRR__
{
    meta:
        description = "[BeRoEXEPacker v1.00 [LZBRR]]"
        ep_only = "true"
    strings:
        $a = {60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC B2 80 33 DB A4 B3 02 E8 ?? ?? ?? ?? 73 F6 33 C9 E8 ?? ?? ?? ?? 73 1C 33 C0 E8 ?? ?? ?? ?? 73 23 B3 02 41 B0 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_00307_BeRoEXEPacker_v1_00__LZBRS__
{
    meta:
        description = "[BeRoEXEPacker v1.00 [LZBRS]]"
        ep_only = "true"
    strings:
        $a = {60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC AD 8D 1C 07 B0 80 3B FB 73 3B E8 1C 00 00 00 72 03 A4 EB F2 E8 1A 00 00 00 8D 51 FF E8 12 00 00 00 56 8B F7 2B F2 F3 A4 5E EB DB 02 C0 75 03 AC 12 C0 C3 33}
    condition:
        $a at pe.entry_point
}

rule PEiD_00308_BeRoEXEPacker_v1_00__LZBRS__
{
    meta:
        description = "[BeRoEXEPacker v1.00 [LZBRS]]"
        ep_only = "true"
    strings:
        $a = {60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC AD 8D 1C 07 B0 80 3B FB 73 3B E8 ?? ?? ?? ?? 72 03 A4 EB F2 E8 ?? ?? ?? ?? 8D 51 FF E8 ?? ?? ?? ?? 56 8B F7 2B F2 F3 A4 5E EB DB 02 C0 75 03 AC 12 C0 C3 33}
    condition:
        $a at pe.entry_point
}

rule PEiD_00309_BeRoEXEPacker_v1_00_DLL__LZBRS__
{
    meta:
        description = "[BeRoEXEPacker v1.00 DLL [LZBRS]]"
        ep_only = "true"
    strings:
        $a = {83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC AD 8D 1C 07 B0 80 3B FB 73 3B E8 1C 00 00 00 72 03 A4 EB F2 E8 1A 00 00 00 8D 51 FF E8 12 00 00 00 56 8B F7 2B F2 F3 A4 5E EB DB 02 C0 75 03 AC 12 C0 C3 33}
    condition:
        $a at pe.entry_point
}

rule PEiD_00310_BeRoEXEPacker_v1_00_DLL__LZBRS__
{
    meta:
        description = "[BeRoEXEPacker v1.00 DLL [LZBRS]]"
        ep_only = "true"
    strings:
        $a = {83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC AD 8D 1C 07 B0 80 3B FB 73 3B E8 ?? ?? ?? ?? 72 03 A4 EB F2 E8 ?? ?? ?? ?? 8D 51 FF E8 ?? ?? ?? ?? 56 8B F7 2B F2 F3 A4 5E EB DB 02 C0 75 03 AC 12 C0 C3 33}
    condition:
        $a at pe.entry_point
}

rule PEiD_00311_BGI_Stroked_Font_v_1_1_
{
    meta:
        description = "[BGI Stroked Font v.1.1]"
        ep_only = "false"
    strings:
        $a = {50 4B 08 08 42 47 49 20 53 74 72 6F 6B 65 64 20 46 6F 6E 74 20 56 31 2E 31}
    condition:
        $a
}

rule PEiD_00312_BlackEnergy_DDoS_Bot_Crypter_
{
    meta:
        description = "[BlackEnergy DDoS Bot Crypter]"
        ep_only = "true"
    strings:
        $a = {55 ?? ?? 81 EC 1C 01 00 00 53 56 57 6A 04 BE 00 30 00 00 56 FF 35 00 20 11 13 6A 00 E8 ?? 03 00 00 ?? ?? 83 C4 10 ?? FF 89 7D F4 0F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00313_Blade_Joiner_v1_5_
{
    meta:
        description = "[Blade Joiner v1.5]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 C4 E4 FE FF FF 53 56 57 33 C0 89 45 F0 89 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_00314_BlindSpot_1_0____s134k_
{
    meta:
        description = "[BlindSpot 1.0 -> s134k]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 50 02 00 00 8D 85 B0 FE FF FF 53 56 A3 90 12 40 00 57 8D 85 B0 FD FF FF 68 00 01 00 00 33 F6 50 56 FF 15 24 10 40 00 56 68 80 00 00 00 6A 03 56 56 8D 85 B0 FD FF FF 68 00 00 00 80 50 FF 15 20 10 40 00 56 56 68 00 08 00 00 50 89 45 FC FF 15}
    condition:
        $a at pe.entry_point
}

rule PEiD_00315_BlindSpot_1_0____s134k_
{
    meta:
        description = "[BlindSpot 1.0 -> s134k]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 50 02 00 00 8D 85 B0 FE FF FF 53 56 A3 90 12 40 00 57 8D 85 B0 FD FF FF 68 00 01 00 00 33 F6 50 56 FF 15 24 10 40 00 56 68 80 00 00 00 6A 03 56 56 8D 85 B0 FD FF FF 68 00 00 00 80 50 FF 15 20 10 40 00 56 56 68 00 08 00 00 50 89 45 FC FF 15 1C 10 40 00 8D 45 F8 8B 1D 18 10 40 00 56 50 6A 34 FF 35 90 12 40 00 FF 75 FC FF D3 85 C0 0F 84 7F 01 00 00 39 75 F8 0F 84 76 01 00 00 A1 90 12 40 00 66 8B 40 30 66 3D 01 00 75 14 8D 85 E4 FE FF FF 68 04 01 00 00 50 FF 15 14 10 40 00 EB 2C 66 3D 02 00 75 14 8D 85 E4 FE FF FF 50 68 04 01 00 00 FF 15 10 10 40 00 EB 12 8D 85 E4 FE FF FF 68 04 01 00 00 50 FF 15 0C 10 40 00 8B 3D 08 10 40 00 8D 85 E4 FE FF FF 68 54 10 40 00 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_00316_BobPack_v1_00____BoB___BobSoft_
{
    meta:
        description = "[BobPack v1.00 -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 0C 24 89 CD 83 E9 06 81 ED ?? ?? ?? ?? E8 3D 00 00 00 89 85 ?? ?? ?? ?? 89 C2 B8 5D 0A 00 00 8D 04 08 E8 E4 00 00 00 8B 70 04 01 D6 E8 76 00 00 00 E8 51 01 00 00 E8 01 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_00317_BobSoft_Mini_Delphi____BoB___BobSoft_
{
    meta:
        description = "[BobSoft Mini Delphi -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 56 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00318_BobSoft_Mini_Delphi____BoB___BobSoft_
{
    meta:
        description = "[BobSoft Mini Delphi -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B8 ?? ?? ?? ?? E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00319_BobSoft_Mini_Delphi____BoB___BobSoft_
{
    meta:
        description = "[BobSoft Mini Delphi -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 B8 ?? ?? ?? ?? E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00320_BookManager_v9510_
{
    meta:
        description = "[BookManager v9510]"
        ep_only = "true"
    strings:
        $a = {FC A3 ?? ?? 89 1E ?? ?? 49 89 0E ?? ?? BB ?? ?? 8C 1F 83 ?? ?? 89 ?? ?? B8 ?? ?? 50 89 ?? ?? F7 D0 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_00321_BopCrypt_v1_0_
{
    meta:
        description = "[BopCrypt v1.0]"
        ep_only = "true"
    strings:
        $a = {60 BD ?? ?? ?? ?? E8 ?? ?? 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00322_Borland_C___Borland_Builder_
{
    meta:
        description = "[Borland C / Borland Builder]"
        ep_only = "false"
    strings:
        $a = {3B CF 76 05 2B CF FC F3 AA 59}
    condition:
        $a
}

rule PEiD_00323_Borland_C___1991_
{
    meta:
        description = "[Borland C++ 1991]"
        ep_only = "true"
    strings:
        $a = {2E 8C 06 ?? ?? 2E 8C 1E ?? ?? BB ?? ?? 8E DB 1E E8 ?? ?? 1F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00324_Borland_C___1992__1994_
{
    meta:
        description = "[Borland C++ 1992, 1994]"
        ep_only = "true"
    strings:
        $a = {8C C8 8E D8 8C 1E ?? ?? 8C 06 ?? ?? 8C 06 ?? ?? 8C 06}
    condition:
        $a at pe.entry_point
}

rule PEiD_00325_Borland_C___1994_
{
    meta:
        description = "[Borland C++ 1994]"
        ep_only = "true"
    strings:
        $a = {8C CA 2E 89 ?? ?? ?? B4 30 CD 21 8B 2E ?? ?? 8B 1E ?? ?? 8E DA A3 ?? ?? 8C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00326_Borland_C___DLL_
{
    meta:
        description = "[Borland C++ DLL]"
        ep_only = "false"
    strings:
        $a = {EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9}
    condition:
        $a
}

rule PEiD_00327_Borland_C___DLL_
{
    meta:
        description = "[Borland C++ DLL]"
        ep_only = "true"
    strings:
        $a = {EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E0 02 A3 ?? ?? ?? ?? 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00328_Borland_C___DLL_
{
    meta:
        description = "[Borland C++ DLL]"
        ep_only = "true"
    strings:
        $a = {EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 A1 C1 E0 02 A3 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00329_Borland_C___for_Win16_1991_
{
    meta:
        description = "[Borland C++ for Win16 1991]"
        ep_only = "true"
    strings:
        $a = {9A FF FF 00 00 0B C0 75 ?? E9 ?? ?? 8C ?? ?? ?? 89 ?? ?? ?? 89 ?? ?? ?? 89 ?? ?? ?? 89 ?? ?? ?? B8 FF FF 50 9A FF FF 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00330_Borland_C___for_Win32_1994_
{
    meta:
        description = "[Borland C++ for Win32 1994]"
        ep_only = "true"
    strings:
        $a = {A1 ?? ?? ?? ?? C1 ?? ?? A3 ?? ?? ?? ?? 83 ?? ?? ?? ?? 75 ?? 57 51 33 C0 BF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00331_Borland_C___for_Win32_1995_
{
    meta:
        description = "[Borland C++ for Win32 1995]"
        ep_only = "true"
    strings:
        $a = {A1 ?? ?? ?? ?? C1 ?? ?? A3 ?? ?? ?? ?? 57 51 33 C0 BF ?? ?? ?? ?? B9 ?? ?? ?? ?? 3B CF 76}
    condition:
        $a at pe.entry_point
}

rule PEiD_00332_Borland_C___for_Win32_1999_
{
    meta:
        description = "[Borland C++ for Win32 1999]"
        ep_only = "false"
    strings:
        $a = {EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90}
    condition:
        $a
}

rule PEiD_00333_Borland_C___for_Win32_1999_
{
    meta:
        description = "[Borland C++ for Win32 1999]"
        ep_only = "true"
    strings:
        $a = {EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E0 02 A3 ?? ?? ?? ?? 52}
    condition:
        $a at pe.entry_point
}

rule PEiD_00334_Borland_C___
{
    meta:
        description = "[Borland C++]"
        ep_only = "true"
    strings:
        $a = {A1 ?? ?? ?? ?? C1 E0 02 A3 ?? ?? ?? ?? 57 51 33 C0 BF ?? ?? ?? ?? B9 ?? ?? ?? ?? 3B CF 76 05 2B CF FC F3 AA 59 5F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00335_Borland_Delphi_3____Portions_Copyright__c__1983_96_Borland__h__
{
    meta:
        description = "[Borland Delphi 3 -> Portions Copyright (c) 1983,96 Borland (h)]"
        ep_only = "false"
    strings:
        $a = {50 6F 72 74 69 6F 6E 73 20 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 38 33 2C 39 36 20 42 6F 72 6C 61 6E 64 00}
    condition:
        $a
}

rule PEiD_00336_Borland_Delphi_3____Portions_Copyright__c__1983_97_Borland__h__
{
    meta:
        description = "[Borland Delphi 3 -> Portions Copyright (c) 1983,97 Borland (h)]"
        ep_only = "false"
    strings:
        $a = {50 6F 72 74 69 6F 6E 73 20 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 38 33 2C 39 37 20 42 6F 72 6C 61 6E 64 00}
    condition:
        $a
}

rule PEiD_00337_Borland_Delphi_5____Portions_Copyright__c__1983_99_Borland__h__
{
    meta:
        description = "[Borland Delphi 5 -> Portions Copyright (c) 1983,99 Borland (h)]"
        ep_only = "false"
    strings:
        $a = {50 6F 72 74 69 6F 6E 73 20 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 38 33 2C 39 39 20 42 6F 72 6C 61 6E 64 00}
    condition:
        $a
}

rule PEiD_00338_Borland_Delphi_DLL_
{
    meta:
        description = "[Borland Delphi DLL]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 B4 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00339_Borland_Delphi_Setup_Module_
{
    meta:
        description = "[Borland Delphi Setup Module]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 ?? 53 56 57 33 C0 89 45 F0 89 45 D4 89 45 D0 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00340_Borland_Delphi_v2_0_
{
    meta:
        description = "[Borland Delphi v2.0]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 0A ?? ?? ?? B8 ?? ?? ?? ?? C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00341_Borland_Delphi_v3_0_
{
    meta:
        description = "[Borland Delphi v3.0]"
        ep_only = "true"
    strings:
        $a = {50 6A ?? E8 ?? ?? FF FF BA ?? ?? ?? ?? 52 89 05 ?? ?? ?? ?? 89 42 04 E8 ?? ?? ?? ?? 5A 58 E8 ?? ?? ?? ?? C3 55 8B EC 33 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00342_Borland_Delphi_v4_0___v5_0_
{
    meta:
        description = "[Borland Delphi v4.0 - v5.0]"
        ep_only = "true"
    strings:
        $a = {50 6A 00 E8 ?? ?? FF FF BA ?? ?? ?? ?? 52 89 05 ?? ?? ?? ?? 89 42 04 C7 42 08 00 00 00 00 C7 42 0C 00 00 00 00 E8 ?? ?? ?? ?? 5A 58 E8 ?? ?? ?? ?? C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00343_Borland_Delphi_v4_0___v5_0_
{
    meta:
        description = "[Borland Delphi v4.0 - v5.0]"
        ep_only = "true"
    strings:
        $a = {50 6A ?? E8 ?? ?? FF FF BA ?? ?? ?? ?? 52 89 05 ?? ?? ?? ?? 89 42 04 C7 42 08 ?? ?? ?? ?? C7 42 0C ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 58 E8 ?? ?? ?? ?? C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00344_Borland_Delphi_v5_0_KOL_
{
    meta:
        description = "[Borland Delphi v5.0 KOL]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 B8 ?? ?? 40 00 E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF 8B C0 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00345_Borland_Delphi_v6_0___v7_0_
{
    meta:
        description = "[Borland Delphi v6.0 - v7.0]"
        ep_only = "true"
    strings:
        $a = {53 8B D8 33 C0 A3 00 ?? ?? ?? 06 A0 0E 80 ?? ?? 0F FA 30 ?? ?? ?? 0A 10 ?? ?? ?? 0A 30 ?? ?? ?? 03 3C 0A 30 ?? ?? ?? 03 3C 0A 30 ?? ?? ?? E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00346_Borland_Delphi_v6_0___v7_0_
{
    meta:
        description = "[Borland Delphi v6.0 - v7.0]"
        ep_only = "false"
    strings:
        $a = {53 8B D8 33 C0 A3 0? ?? ?? ?0 6A 00 E8 0? ?? ?0 FF A3 0? ?? ?? ?0 A1 0? ?? ?? ?0 A3 0? ?? ?? ?0 33 C0 A3 0? ?? ?? ?0 33 C0 A3 0? ?? ?? ?0 E8}
    condition:
        $a
}

rule PEiD_00347_Borland_Delphi_v6_0___v7_0_
{
    meta:
        description = "[Borland Delphi v6.0 - v7.0]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 F0 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8}
    condition:
        $a
}

rule PEiD_00348_Borland_Delphi_v6_0___v7_0_
{
    meta:
        description = "[Borland Delphi v6.0 - v7.0]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 B8 ?? ?? ?? ?? E8 ?? ?? FB FF A1 ?? ?? ?? ?? 8B ?? E8 ?? ?? FF FF 8B 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 8B 15 ?? ?? ?? ?? E8 ?? ?? FF FF A1 ?? ?? ?? ?? 8B ?? E8 ?? ?? FF FF E8 ?? ?? FB FF 8D 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00349_Borland_Delphi_v6_0___v7_0_
{
    meta:
        description = "[Borland Delphi v6.0 - v7.0]"
        ep_only = "true"
    strings:
        $a = {BA ?? ?? ?? ?? 83 7D 0C 01 75 ?? 50 52 C6 05 ?? ?? ?? ?? ?? 8B 4D 08 89 0D ?? ?? ?? ?? 89 4A 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_00350_Borland_Delphi_v6_0_KOL_
{
    meta:
        description = "[Borland Delphi v6.0 KOL]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 B8 ?? ?? 40 00 E8 ?? ?? FF FF A1 ?? 72 40 00 33 D2 E8 ?? ?? FF FF A1 ?? 72 40 00 8B 00 83 C0 14 E8 ?? ?? FF FF E8 ?? ?? FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00351_Borland_Delphi_v6_0_
{
    meta:
        description = "[Borland Delphi v6.0]"
        ep_only = "true"
    strings:
        $a = {53 8B D8 33 C0 A3 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? FF A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00352_Borland_Delphi_v6_0_
{
    meta:
        description = "[Borland Delphi v6.0]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 B8 ?? ?? 45 00 E8 ?? ?? ?? FF A1 ?? ?? 45 00 8B 00 E8 ?? ?? FF FF 8B 0D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00353_Borland_Pascal_v7_0_for_Windows_
{
    meta:
        description = "[Borland Pascal v7.0 for Windows]"
        ep_only = "true"
    strings:
        $a = {9A FF FF 00 00 9A FF FF 00 00 55 89 E5 31 C0 9A FF FF 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00354_Borland_Pascal_v7_0_Protected_Mode_
{
    meta:
        description = "[Borland Pascal v7.0 Protected Mode]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? BB ?? ?? 8E D0 8B E3 8C D8 8E C0 0E 1F A1 ?? ?? 25 ?? ?? A3 ?? ?? E8 ?? ?? 83 3E ?? ?? ?? 75}
    condition:
        $a at pe.entry_point
}

rule PEiD_00355_Borland_Pascal_v7_0_
{
    meta:
        description = "[Borland Pascal v7.0]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? 8E D8 8C ?? ?? ?? 8C D3 8C C0 2B D8 8B C4 05 ?? ?? C1 ?? ?? 03 D8 B4 ?? CD 21 0E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00356_by_Central_Point_Software_
{
    meta:
        description = "[by Central Point Software]"
        ep_only = "true"
    strings:
        $a = {50 51 52 56 57 8B EB 1E 2E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00357_C_I_Crypt_V0_1____FearlesS_
{
    meta:
        description = "[C.I Crypt V0.1 -> FearlesS]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72}
    condition:
        $a at pe.entry_point
}

rule PEiD_00358_C_I_Crypt_V0_2____FearlesS_
{
    meta:
        description = "[C.I Crypt V0.2 -> FearlesS]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_00359_CA_Visual_Objects_2_0___2_5_
{
    meta:
        description = "[CA Visual Objects 2.0 - 2.5]"
        ep_only = "true"
    strings:
        $a = {89 25 ?? ?? ?? ?? 33 ED 55 8B EC E8 ?? ?? ?? ?? 8B D0 81 E2 FF 00 00 00 89 15 ?? ?? ?? ?? 8B D0 C1 EA 08 81 E2 FF 00 00 00 A3 ?? ?? ?? ?? D1 E0 0F 93 C3 33 C0 8A C3 A3 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? BB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00360_CA_Visual_Objects_2_0___2_5_
{
    meta:
        description = "[CA Visual Objects 2.0 - 2.5]"
        ep_only = "true"
    strings:
        $a = {89 25 ?? ?? ?? ?? 33 ED 55 8B EC E8 ?? ?? ?? ?? 8B D0 81 E2 FF 00 00 00 89 15 ?? ?? ?? ?? 8B D0 C1 EA 08 81 E2 FF 00 00 00 A3 ?? ?? ?? ?? D1 E0 0F 93 C3 33 C0 8A C3 A3 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? BB ?? ?? ?? ?? C7 03 44 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00361_CALS_Raster_graphics_format_
{
    meta:
        description = "[CALS Raster graphics format]"
        ep_only = "false"
    strings:
        $a = {73 72 63 64 6F 63 69 64 3A 20}
    condition:
        $a
}

rule PEiD_00362_Can2Exe_v0_01_
{
    meta:
        description = "[Can2Exe v0.01]"
        ep_only = "true"
    strings:
        $a = {0E 1F 0E 07 E8 ?? ?? E8 ?? ?? 3A C6 73}
    condition:
        $a at pe.entry_point
}

rule PEiD_00363_CAN2EXE_v0_01_
{
    meta:
        description = "[CAN2EXE v0.01]"
        ep_only = "true"
    strings:
        $a = {26 8E 06 ?? ?? B9 ?? ?? 33 C0 8B F8 F2 AE E3 ?? 26 38 05 75 ?? EB ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00364_CauseWay_DOS_Extender_v3_25_
{
    meta:
        description = "[CauseWay DOS Extender v3.25]"
        ep_only = "true"
    strings:
        $a = {FA 16 1F 26 ?? ?? ?? 83 ?? ?? 8E D0 FB 06 16 07 BE ?? ?? 8B FE B9 ?? ?? F3 A4 07}
    condition:
        $a at pe.entry_point
}

rule PEiD_00365_CC_v2_61_Beta_
{
    meta:
        description = "[CC v2.61 Beta]"
        ep_only = "true"
    strings:
        $a = {BA ?? ?? B4 30 CD 21 3C 02 73 ?? 33 C0 06 50 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00366_CD_Cops_II_
{
    meta:
        description = "[CD-Cops II]"
        ep_only = "true"
    strings:
        $a = {53 60 BD ?? ?? ?? ?? 8D 45 ?? 8D 5D ?? E8 ?? ?? ?? ?? 8D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00367_CDS_SS_1_0_beta1____CyberDoom_
{
    meta:
        description = "[CDS SS 1.0 beta1 -> CyberDoom]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED CA 47 40 00 FF 74 24 20 E8 D3 03 00 00 0B C0 0F 84 13 03 00 00 89 85 B8 4E 40 00 66 8C D8 A8 04 74 0C C7 85 8C 4E 40 00 01 00 00 00 EB 12 64 A1 30 00 00 00 0F B6 40 02 0A C0 0F 85 E8 02 00 00 8D 85 F6 4C 40 00 50 FF B5 B8 4E 40 00 E8 FC 03 00 00 0B C0 0F 84 CE 02 00 00 E8 1E 03 00 00 89 85 90 4E 40 00 8D 85 03 4D 40 00 50 FF B5 B8 4E 40 00 E8 D7 03 00 00 0B C0 0F 84 A9 02 00 00 E8 F9 02 00 00 89 85 94 4E 40 00 8D 85 12 4D 40 00 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_00368_CDS_SS_v1_0_Beta_1____CyberDoom___Team_X_
{
    meta:
        description = "[CDS SS v1.0 Beta 1 -> CyberDoom / Team-X]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED CA 47 40 00 FF 74 24 20 E8 D3 03 00 00 0B C0 0F 84 13 03 00 00 89 85 B8 4E 40 00 66 8C D8 A8 04 74 0C C7 85 8C 4E 40 00 01 00 00 00 EB 12 64 A1 30 00 00 00 0F B6 40 02 0A C0 0F 85 E8 02 00 00 8D 85 F6 4C 40 00 50 FF B5 B8 4E 40 00 E8 FC 03 00 00 0B C0 0F 84 CE 02 00 00 E8 1E 03 00 00 89 85 90 4E 40 00 8D 85 03 4D 40 00 50 FF B5 B8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00369_Celsius_Crypt_2_1____Z3r0_
{
    meta:
        description = "[Celsius Crypt 2.1 -> Z3r0]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 84 92 44 00 E8 C8 FE FF FF 90 8D B4 26 00 00 00 00 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 84 92 44 00 E8 A8 FE FF FF 90 8D B4 26 00 00 00 00 55 8B 0D C4 92 44 00 89 E5 5D FF E1 8D 74 26 00 55 8B 0D AC 92 44 00 89 E5 5D FF E1 90 90 90 90 55 89 E5 5D E9 77 C2 00 00 90 90 90 90 90 90 90 55 89 E5 83 EC 28 8B 45 10 89 04 24 E8 3F 14 01 00 48 89 45 FC 8B 45 0C 48 89 45 F4 8D 45 F4 89 44 24 04 8D 45 FC 89 04 24 E8 12 A3 03 00 8B 00 89 45 F8 8B 45 FC 89 45 F0 C6 45 EF 01 C7 45 E8 00 00 00 00 8B 45 E8 3B 45 F8 73 39 80 7D EF 00 74 33 8B 45 F0 89 44 24 04 8B 45 10 89 04 24 E8 1C 1A 01 00 89 C1 8B 45 08 8B 55 E8 01 C2 0F B6 01 3A 02 0F 94 C0 88 45 EF 8D 45 F0 FF 08 8D 45 E8 FF 00 EB BF 83 7D F0 00 74 34 80 7D EF 00 74 2E 8B 45 F0 89 44 24 04 8B 45 10 89 04 24 E8 DD 19 01 00 89 C1 8B 45 08 8B 55 F8 01 C2 0F B6 01 3A 02 0F 94 C0 88 45 EF 8D 45 F0 FF 08 EB C6 C7 44 24 04 00 00 00 00 8B 45 10 89 04 24 E8 AE 19 01 00 89 C1 8B 45 08 8B 55 F8 01 C2 0F B6 01 3A 02 7F 0C 0F B6 45 EF 83 E0 01 88 45 E7 EB 04 C6 45 E7 00 0F B6 45 E7 88 45 EF 0F B6 45 EF C9 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00370_Celsius_Crypt_2_1____Z3r0_
{
    meta:
        description = "[Celsius Crypt 2.1 -> Z3r0]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 83 EC 28 8B 45 10 89 04 24 E8 3F 14 01 00 48 89 45 FC 8B 45 0C 48 89 45 F4 8D 45 F4 89 44 24 04 8D 45 FC 89 04 24 E8 12 A3 03 00 8B 00 89 45 F8 8B 45 FC 89 45 F0 C6 45 EF 01 C7 45 E8 00 00 00 00 8B 45 E8 3B 45 F8 73 39 80 7D EF 00 74 33 8B 45 F0 89 44 24 04 8B 45 10 89 04 24 E8 1C 1A 01 00 89 C1 8B 45 08 8B 55 E8 01 C2 0F B6 01 3A 02 0F 94 C0 88 45 EF 8D 45 F0 FF 08 8D 45 E8 FF 00 EB BF 83 7D F0 00 74 34 80 7D EF 00 74 2E 8B 45 F0 89 44 24 04 8B 45 10 89 04 24 E8 DD 19 01 00 89 C1 8B 45 08 8B 55 F8 01 C2 0F B6 01 3A 02 0F 94 C0 88 45 EF 8D 45 F0 FF 08 EB C6 C7 44 24 04 00 00 00 00 8B 45 10 89 04 24 E8 AE 19 01 00 89 C1 8B 45 08 8B 55 F8 01 C2 0F B6 01 3A 02 7F 0C 0F B6 45 EF 83 E0 01 88 45 E7 EB 04 C6 45 E7 00 0F B6 45 E7 88 45 EF 0F B6 45 EF C9 C3}
    condition:
        $a
}

rule PEiD_00371_CERBERUS_v2_0_
{
    meta:
        description = "[CERBERUS v2.0]"
        ep_only = "true"
    strings:
        $a = {9C 2B ED 8C ?? ?? 8C ?? ?? FA E4 ?? 88 ?? ?? 16 07 BF ?? ?? 8E DD 9B F5 B9 ?? ?? FC F3 A5}
    condition:
        $a at pe.entry_point
}

rule PEiD_00372_CExe_v1_0a_
{
    meta:
        description = "[CExe v1.0a]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 0C 02 ?? ?? 56 BE 04 01 ?? ?? 8D 85 F8 FE FF FF 56 50 6A ?? FF 15 54 10 40 ?? 8A 8D F8 FE FF FF 33 D2 84 C9 8D 85 F8 FE FF FF 74 16}
    condition:
        $a at pe.entry_point
}

rule PEiD_00373_CGM_Graphics_format_
{
    meta:
        description = "[CGM Graphics format]"
        ep_only = "false"
    strings:
        $a = {00 2A 08 48 69 4A 61 61 6B 20 32}
    condition:
        $a
}

rule PEiD_00374_CHECKPRG__c__1992_
{
    meta:
        description = "[CHECKPRG (c) 1992]"
        ep_only = "true"
    strings:
        $a = {33 C0 BE ?? ?? 8B D8 B9 ?? ?? BF ?? ?? BA ?? ?? 47 4A 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_00375_ChinaProtect____dummy___Sign_by_fly_
{
    meta:
        description = "[ChinaProtect -> dummy ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {C3 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 56 8B ?? ?? ?? 6A 40 68 00 10 00 00 8D ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 89 30 83 C0 04 5E C3 8B 44 ?? ?? 56 8D ?? ?? 68 00 40 00 00 FF 36 56 E8 ?? ?? ?? ?? 68 00 80 00 00 6A 00 56 E8 ?? ?? ?? ?? 5E C3}
    condition:
        $a
}

rule PEiD_00376_ChSfx__small__v1_1_
{
    meta:
        description = "[ChSfx (small) v1.1]"
        ep_only = "true"
    strings:
        $a = {BA ?? ?? E8 ?? ?? 8B EC 83 EC ?? 8C C8 BB ?? ?? B1 ?? D3 EB 03 C3 8E D8 05 ?? ?? 89}
    condition:
        $a at pe.entry_point
}

rule PEiD_00377_CICompress_1_0_
{
    meta:
        description = "[CICompress 1.0]"
        ep_only = "false"
    strings:
        $a = {6A 04 68 00 10 00 00 FF 35 9C 14 40 00 6A 00 FF 15 38 10 40 00 A3 FC 10 40 00 97 BE 00 20 40 00 E8 71 00 00 00 3B 05 9C 14 40 00 75 61 6A 00 6A 20 6A 02 6A 00 6A 03 68 00 00 00 C0 68 94 10 40 00 FF 15 2C 10 40 00 A3 F8 10 40 00 6A 00 68 F4 10 40 00 FF 35}
    condition:
        $a
}

rule PEiD_00378_CICompress_v1_0_
{
    meta:
        description = "[CICompress v1.0]"
        ep_only = "true"
    strings:
        $a = {6A 04 68 00 10 00 00 FF 35 9C 14 40 00 6A 00 FF 15 38 10 40 00 A3 FC 10 40 00 97 BE 00 20 40 00 E8 71 00 00 00 3B 05 9C 14 40 00 75 61 6A 00 6A 20 6A 02 6A 00 6A 03 68 00 00 00 C0 68 94 10 40 00 FF 15 2C 10 40 00 A3 F8 10 40 00 6A 00 68 F4 10 40 00 FF 35 9C 14 40 00 FF 35 FC 10 40 00 FF 35 F8 10 40 00 FF 15 34 10 40 00 FF 35 F8 10 40 00 FF 15 30 10 40 00 68 00 40 00 00 FF 35 9C 14 40 00 FF 35 FC 10 40 00 FF 15 3C 10 40 00 6A 00 FF 15 28 10 40 00 60 33 DB 33 C9 E8 7F 00 00 00 73 0A B1 08 E8 82 00 00 00 AA EB EF E8 6E 00 00 00 73 14 B1 04 E8 71 00 00 00 3C 00 74 EB 56 8B F7 2B F0 A4 5E EB D4 33 ED E8 51 00 00 00 72 10 B1 02 E8 54 00 00 00 3C 00 74 3B 8B E8 C1 C5 08 B1 08 E8 44 00 00 00 0B C5 50 33 ED E8 2E 00 00 00 72 0C B1 02 E8 31 00 00 00 8B E8 C1 C5 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_00379_CipherWall_Self_Extrator_Decryptor__Console__1_5_
{
    meta:
        description = "[CipherWall Self-Extrator/Decryptor (Console) 1.5]"
        ep_only = "false"
    strings:
        $a = {90 61 BE 00 10 42 00 8D BE 00 00 FE FF C7 87 C0 20 02 00 0B 6E 5B 9B 57 83 CD FF EB 0E 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4}
    condition:
        $a
}

rule PEiD_00380_CipherWall_Self_Extrator_Decryptor__Console__v1_5_
{
    meta:
        description = "[CipherWall Self-Extrator/Decryptor (Console) v1.5]"
        ep_only = "true"
    strings:
        $a = {90 61 BE 00 10 42 00 8D BE 00 00 FE FF C7 87 C0 20 02 00 0B 6E 5B 9B 57 83 CD FF EB 0E 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 83 C1 02 81 FD 00 F3 FF FF 83 D1 01 8D 14 2F 83 FD FC 76 0F 8A 02 42 88 07 47 49 75 F7 E9 63 FF FF FF 90 8B 02 83 C2 04 89 07 83 C7 04 83 E9 04 77 F1 01 CF E9 4C FF FF FF 5E 89 F7 B9 12 10 00 00 8A 07 47 2C E8 3C 01 77 F7 80 3F 06 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4}
    condition:
        $a at pe.entry_point
}

rule PEiD_00381_CipherWall_Self_Extrator_Decryptor__GUI__1_5_
{
    meta:
        description = "[CipherWall Self-Extrator/Decryptor (GUI) 1.5]"
        ep_only = "false"
    strings:
        $a = {90 61 BE 00 10 42 00 8D BE 00 00 FE FF C7 87 C0 20 02 00 F9 89 C7 6A 57 83 CD FF EB 0E 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4}
    condition:
        $a
}

rule PEiD_00382_CipherWall_Self_Extrator_Decryptor__GUI__v1_5_
{
    meta:
        description = "[CipherWall Self-Extrator/Decryptor (GUI) v1.5]"
        ep_only = "true"
    strings:
        $a = {90 61 BE 00 10 42 00 8D BE 00 00 FE FF C7 87 C0 20 02 00 F9 89 C7 6A 57 83 CD FF EB 0E 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 83 C1 02 81 FD 00 F3 FF FF 83 D1 01 8D 14 2F 83 FD FC 76 0F 8A 02 42 88 07 47 49 75 F7 E9 63 FF FF FF 90 8B 02 83 C2 04 89 07 83 C7 04 83 E9 04 77 F1 01 CF E9 4C FF FF FF 5E 89 F7 B9 52 10 00 00 8A 07 47 2C E8 3C 01 77 F7 80 3F 0E 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4}
    condition:
        $a at pe.entry_point
}

rule PEiD_00383_Code_Virtualizer_V1_3_1_0____Oreans_Technologies___Sign_by_fly_
{
    meta:
        description = "[Code Virtualizer V1.3.1.0 -> Oreans Technologies ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {60 9C FC E8 00 00 00 00 5F 81 EF ?? ?? ?? ?? 8B C7 81 C7 ?? ?? ?? ?? 3B 47 2C 75 02 EB 2E 89 47 2C B9 A7 00 00 00 EB 05 01 44 8F ?? 49 0B C9 75 F7 83 7F 40 00 74 15 8B 77 40 03 F0 EB 09 8B 1E 03 D8 01 03 83 C6 04 83 3E 00 75 F2 8B 74 24 24 8B DE 03 F0 B9 01 00 00 00 33 C0 F0 0F B1 4F 30 75 F7 AC}
    condition:
        $a
}

rule PEiD_00384_Code_Virtualizer_V1_3_1_0____Oreans_Technologies_
{
    meta:
        description = "[Code Virtualizer V1.3.1.0 -> Oreans Technologies]"
        ep_only = "true"
    strings:
        $a = {60 9C FC E8 00 00 00 00 5F 81 EF ?? ?? ?? ?? 8B C7 81 C7 ?? ?? ?? ?? 3B 47 2C 75 02 EB 2E 89 47 2C B9 A7 00 00 00 EB 05 01 44 8F ?? 49 0B C9 75 F7 83 7F 40 00 74 15 8B 77 40 03 F0 EB 09 8B 1E 03 D8 01 03 83 C6 04 83 3E 00 75 F2 8B 74 24 24 8B DE 03 F0 B9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00385_Code_Lock_vx_x_
{
    meta:
        description = "[Code-Lock vx.x]"
        ep_only = "true"
    strings:
        $a = {43 4F 44 45 2D 4C 4F 43 4B 2E 4F 43 58 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00386_CodeCrypt_v0_14b_
{
    meta:
        description = "[CodeCrypt v0.14b]"
        ep_only = "true"
    strings:
        $a = {E9 C5 02 00 00 EB 02 83 3D 58 EB 02 FF 1D 5B EB 02 0F C7 5F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00387_CodeCrypt_v0_15b_
{
    meta:
        description = "[CodeCrypt v0.15b]"
        ep_only = "true"
    strings:
        $a = {E9 31 03 00 00 EB 02 83 3D 58 EB 02 FF 1D 5B EB 02 0F C7 5F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00388_CodeCrypt_v0_164_
{
    meta:
        description = "[CodeCrypt v0.164]"
        ep_only = "true"
    strings:
        $a = {E9 2E 03 00 00 EB 02 83 3D 58 EB 02 FF 1D 5B EB 02 0F C7 5F EB 03 FF 1D 34}
    condition:
        $a at pe.entry_point
}

rule PEiD_00389_CodeCrypt_v0_16b___v0_163b_
{
    meta:
        description = "[CodeCrypt v0.16b - v0.163b]"
        ep_only = "true"
    strings:
        $a = {E9 2E 03 00 00 EB 02 83 3D 58 EB 02 FF 1D 5B EB 02 0F C7 5F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00390_codeCrypter_0_31____Tibbar_
{
    meta:
        description = "[codeCrypter 0.31 -> Tibbar]"
        ep_only = "true"
    strings:
        $a = {50 58 53 5B 90 BB ?? ?? ?? 00 FF E3 90 CC CC CC 55 8B EC 5D C3 CC CC CC CC CC CC CC CC CC CC CC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00391_codeCrypter_0_31_
{
    meta:
        description = "[codeCrypter 0.31]"
        ep_only = "true"
    strings:
        $a = {50 58 53 5B 90 BB ?? ?? 40 00 FF E3 90 CC CC CC 55 8B EC 5D C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00392_codeCrypter_0_31_
{
    meta:
        description = "[codeCrypter 0.31]"
        ep_only = "false"
    strings:
        $a = {50 58 53 5B 90 BB ?? ?? 40 00 FF E3 90 CC CC CC 55 8B EC 5D C3 CC CC CC CC CC CC CC CC CC CC CC}
    condition:
        $a
}

rule PEiD_00393_Com4mail_v1_0_
{
    meta:
        description = "[Com4mail v1.0]"
        ep_only = "true"
    strings:
        $a = {42 45 47 49 4E 3D 3D 3D 74 66 75 64 23 6F 66 5F 43 6F 6D 34 4D 61 69 6C 5F 66 69 6C 65 23 0D 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_00394_COMPACK_v4_5__2__
{
    meta:
        description = "[COMPACK v4.5 (2)]"
        ep_only = "true"
    strings:
        $a = {BE ?? ?? E8 ?? ?? 5D 83 ?? ?? 55 50 53 51 52 0E 07 0E 1F 8B CE}
    condition:
        $a at pe.entry_point
}

rule PEiD_00395_COMPACK_v5_1_
{
    meta:
        description = "[COMPACK v5.1]"
        ep_only = "true"
    strings:
        $a = {BD ?? ?? 50 06 8C CB 03 DD 8C D2 4B 8E DB BE ?? ?? BF ?? ?? 8E C2 B9 ?? ?? F3 A5 4A 4D 75 ?? 8B F7 8E DA 0E 07 06 16}
    condition:
        $a at pe.entry_point
}

rule PEiD_00396_COP_v1_0__c__1988_
{
    meta:
        description = "[COP v1.0 (c) 1988]"
        ep_only = "true"
    strings:
        $a = {BF ?? ?? BE ?? ?? B9 ?? ?? AC 32 ?? ?? ?? AA E2 ?? 8B ?? ?? ?? EB ?? 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_00397_Copy_Protector_v2_0_
{
    meta:
        description = "[Copy Protector v2.0]"
        ep_only = "true"
    strings:
        $a = {2E A2 ?? ?? 53 51 52 1E 06 B4 ?? 1E 0E 1F BA ?? ?? CD 21 1F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00398_CopyControl_v3_03_
{
    meta:
        description = "[CopyControl v3.03]"
        ep_only = "true"
    strings:
        $a = {CC 90 90 EB 0B 01 50 51 52 53 54 61 33 61 2D 35 CA D1 07 52 D1 A1 3C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00399_CopyMinder____Microcosm_Ltd___Sign_by_fly_
{
    meta:
        description = "[CopyMinder -> Microcosm.Ltd ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {83 25 ?? ?? ?? ?? EF 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25}
    condition:
        $a at pe.entry_point
}

rule PEiD_00400_CopyMinder____Microcosm_Ltd_
{
    meta:
        description = "[CopyMinder -> Microcosm.Ltd]"
        ep_only = "true"
    strings:
        $a = {83 25 ?? ?? ?? ?? EF 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25}
    condition:
        $a at pe.entry_point
}

rule PEiD_00401_CorelDraw_8_CDR_Graphics_format_
{
    meta:
        description = "[CorelDraw 8 CDR Graphics format]"
        ep_only = "false"
    strings:
        $a = {52 49 46 46 ?? ?? ?? ?? 43 44 52 38}
    condition:
        $a
}

rule PEiD_00402_CorelDraw_CMX_Graphics_format_
{
    meta:
        description = "[CorelDraw CMX Graphics format]"
        ep_only = "false"
    strings:
        $a = {52 49 46 46 ?? ?? ?? ?? 43 4D 58 31}
    condition:
        $a
}

rule PEiD_00403_CPAV_
{
    meta:
        description = "[CPAV]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? 4D 5A B1 01 93 01 00 00 02}
    condition:
        $a at pe.entry_point
}

rule PEiD_00404_Cracked_by_AutoHack__1__
{
    meta:
        description = "[Cracked by AutoHack (1)]"
        ep_only = "true"
    strings:
        $a = {FA 50 51 57 56 1E 06 2E 80 3E ?? ?? ?? 74 ?? 8E 06 ?? ?? 2B FF FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00405_Cracked_by_Autohack__2__
{
    meta:
        description = "[Cracked by Autohack (2)]"
        ep_only = "true"
    strings:
        $a = {0E 1F B4 09 BA ?? ?? CD 21 FA 8E 06 ?? ?? BE ?? ?? 8B 0E ?? ?? 83 F9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00406_CrackStop_v1_01__c__Stefan_Esser_1997_
{
    meta:
        description = "[CrackStop v1.01 (c) Stefan Esser 1997]"
        ep_only = "true"
    strings:
        $a = {B4 48 BB FF FF B9 EB 27 8B EC CD 21 FA FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00407_CreateInstall_2003_3_5_
{
    meta:
        description = "[CreateInstall 2003.3.5]"
        ep_only = "false"
    strings:
        $a = {81 EC 0C 04 00 00 53 56 57 55 68 60 50 40 00 6A 01 6A 00 FF 15 D8 80 40 00 8B F0 FF 15 D4 80 40 00 3D B7 00 00 00 75 0F 56 FF 15 B8 80 40 00 6A 02 FF 15 A4 80 40 00 33 DB E8 F2 FE FF FF 68 02 7F 00 00 89 1D 94 74 40 00 53 89 1D 98 74 40 00 FF 15 E4 80 40}
    condition:
        $a
}

rule PEiD_00408_CreateInstall_Stub_vx_x_
{
    meta:
        description = "[CreateInstall Stub vx.x]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 20 02 00 00 53 56 57 6A 00 FF 15 18 61 40 00 68 00 70 40 00 89 45 08 FF 15 14 61 40 00 85 C0 74 27 6A 00 A1 00 20 40 00 50 FF 15 3C 61 40 00 8B F0 6A 06 56 FF 15 38 61 40 00 6A 03 56 FF 15 38 61 40 00 E9 36 03 00 00 68 02 7F 00 00 33 F6 56}
    condition:
        $a at pe.entry_point
}

rule PEiD_00409_CreateInstall_Stub_vx_x_
{
    meta:
        description = "[CreateInstall Stub vx.x]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 20 02 00 00 53 56 57 6A 00 FF 15 18 61 40 00 68 00 70 40 00 89 45 08 FF 15 14 61 40 00 85 C0 74 27 6A 00 A1 00 20 40 00 50 FF 15 3C 61 40 00 8B F0 6A 06 56 FF 15 38 61 40 00 6A 03 56 FF 15 38 61 40 00 E9 36 03 00 00 68 02 7F 00 00 33 F6 56 BF 00 30 00 00 FF 15 20 61 40 00 50 FF 15 2C 61 40 00 6A 04 57 68 00 FF 01 00 56 FF 15 CC 60 40 00 6A 04 A3 CC 35 40 00 57 68 00 0F 01 00 56 FF 15 CC 60 40 00 68 00 01 00 00 BE B0 3F 40 00 56 A3 C4 30 40 00 FF 75 08 FF 15 10 61 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00410_CreateInstall_v2003_3_5_
{
    meta:
        description = "[CreateInstall v2003.3.5]"
        ep_only = "false"
    strings:
        $a = {81 EC 0C 04 00 00 53 56 57 55 68 60 50 40 00 6A 01 6A 00 FF 15 D8 80 40 00 8B F0 FF 15 D4 80 40 00 3D B7 00 00 00 75 0F 56 FF 15 B8 80 40 00 6A 02 FF 15 A4 80 40 00 33 DB E8 F2 FE FF FF 68 02 7F 00 00 89 1D 94 74 40 00 53 89 1D 98 74 40 00 FF 15 E4 80 40 00 50 FF 15 E0 80 40 00 8B 0D 00 50 40 00 E8 68 FF FF FF B9 40 0D 03 00 89 44 24 14 E8 5A FF FF FF 68 00 02 00 00 8B 2D D0 80 40 00 89 44 24 1C 8D 44 24 20 50 53 FF D5 8D 4C 24 1C 53 68 00 00 00 80 8B 3D CC 80 40 00 6A 03 53 6A 03 68 00 00 00 80 51 FF D7 8B F0 53 8D 44 24 14 8B 0D 00 50 40 00 8B 54 24 18 50 51 52 56 FF 15 C8 80 40 00 85 C0 0F 84 40 02 00 00 8B 15 00 50 40 00 3B 54 24 10 0F 85 30 02 00 00 6A FF A1 04 50 40 00 2B D0 8B 4C 24 18 03 C8 E8 9F FE FF FF 3B 05 10 50 40 00 0F 85 10 02 00 00 56 FF}
    condition:
        $a
}

rule PEiD_00411_Creative_Audio_file_
{
    meta:
        description = "[Creative Audio file]"
        ep_only = "false"
    strings:
        $a = {43 72 65 61 74 69 76 65 20 56 6F 69 63 65 20 46 69 6C 65}
    condition:
        $a
}

rule PEiD_00412_Crinkler_V0_1_V0_2____Rune_L_H_Stubbe_and_Aske_Simon_Christensen_
{
    meta:
        description = "[Crinkler V0.1-V0.2 -> Rune L.H.Stubbe and Aske Simon Christensen]"
        ep_only = "true"
    strings:
        $a = {B9 ?? ?? ?? ?? 01 C0 68 ?? ?? ?? ?? 6A 00 58 50 6A 00 5F 48 5D BB 03 00 00 00 BE ?? ?? ?? ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00413_Crinkler_V0_3_V0_4____Rune_L_H_Stubbe_and_Aske_Simon_Christensen_
{
    meta:
        description = "[Crinkler V0.3-V0.4 -> Rune L.H.Stubbe and Aske Simon Christensen]"
        ep_only = "true"
    strings:
        $a = {B8 00 00 42 00 31 DB 43 EB 58}
    condition:
        $a at pe.entry_point
}

rule PEiD_00414_Crunch_4____Bit_Arts_
{
    meta:
        description = "[Crunch 4 -> Bit-Arts]"
        ep_only = "true"
    strings:
        $a = {EB 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 55 E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00415_Crunch_4_0_
{
    meta:
        description = "[Crunch 4.0]"
        ep_only = "false"
    strings:
        $a = {EB 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 18 00 00 00 8B C5 55 60 9C 2B 85 E9 06 00 00 89 85 E1 06 00 00 FF 74 24 2C E8 BB 01 00 00 0F 82 92 05 00 00 E8 F1 03 00 00 49 0F 88 86 05 00 00 68 6C D9 B2 96 33 C0 50 E8 24}
    condition:
        $a
}

rule PEiD_00416_Crunch_5____Bit_Arts_
{
    meta:
        description = "[Crunch 5 -> Bit-Arts]"
        ep_only = "false"
    strings:
        $a = {EB 15 03 00 00 00 06 00 00 00 00 00 00 00 00 00 00 00 68 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 1D 00 00 00 8B C5 55 60 9C 2B 85 FC 07 00 00 89 85 E8 07 00 00 FF 74 24 2C E8 20 02 00 00 0F 82 94 06 00 00 E8 F3 04 00 00 49 0F 88 88 06 00 00 8B B5 E8 07 00}
    condition:
        $a
}

rule PEiD_00417_Crunch_5___Fusion_4____Bit_Arts_
{
    meta:
        description = "[Crunch 5 / Fusion 4 -> Bit-Arts]"
        ep_only = "true"
    strings:
        $a = {EB 15 03 00 00 00 06 00 00 00 00 00 00 00 00 00 00 00 68 00 00 00 00 55 E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00418_Crunch_5_Fusion_4_
{
    meta:
        description = "[Crunch 5 Fusion 4]"
        ep_only = "false"
    strings:
        $a = {EB 15 03 ?? ?? ?? 06 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 55 E8}
    condition:
        $a
}

rule PEiD_00419_Crunch_v4_0_
{
    meta:
        description = "[Crunch v4.0]"
        ep_only = "true"
    strings:
        $a = {EB 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 18 00 00 00 8B C5 55 60 9C 2B 85 E9 06 00 00 89 85 E1 06 00 00 FF 74 24 2C E8 BB 01 00 00 0F 82 92 05 00 00 E8 F1 03 00 00 49 0F 88 86 05 00 00 68 6C D9 B2 96 33 C0 50 E8 24 03 00 00 89 85 D9 41 00 00 68 EC 49 7B 79 33 C0 50 E8 11 03 00 00 89 85 D1 41 00 00 E8 67 05 00 00 E9 56 05 00 00 51 52 53 33 C9 49 8B D1 33 C0 33 DB AC 32 C1 8A CD 8A EA 8A D6 B6 08 66 D1 EB 66 D1 D8 73 09 66 35 20 83 66 81 F3 B8 ED FE CE 75 EB 33 C8 33 D3 4F 75 D5 F7 D2 F7 D1 5B 8B C2 C1 C0 10 66 8B C1 5A 59 C3 68 03 02 00 00 E8 80 04 00 00 0F 82 A8 02 00 00 96 8B 44 24 04 0F C8 8B D0 25 0F 0F 0F 0F 33 D0 C1 C0 08 0B C2 8B D0 25 33 33 33 33 33 D0 C1 C0 04 0B C2 8B D0 25 55 55 55 55 33 D0 C1 C0 02 0B C2}
    condition:
        $a at pe.entry_point
}

rule PEiD_00420_Crunch_v5____Bit_Arts_
{
    meta:
        description = "[Crunch v5 -> Bit-Arts]"
        ep_only = "true"
    strings:
        $a = {EB 15 03 00 00 00 06 00 00 00 00 00 00 00 00 00 00 00 68 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 1D 00 00 00 8B C5 55 60 9C 2B 85 FC 07 00 00 89 85 E8 07 00 00 FF 74 24 2C E8 20 02 00 00 0F 82 94 06 00 00 E8 F3 04 00 00 49 0F 88 88 06 00 00 8B B5 E8 07 00 00 8B 56 3C 8D 8C 32 C8 00 00 00 83 39 00 74 50 8B D9 53 68 BB D4 C3 79 33 C0 50 E8 0E 04 00 00 50 8D 95 EC 07 00 00 52 6A 04 68 00 10 00 00 FF B5 E8 07 00 00 FF D0 58 5B C7 03 00 00 00 00 C7 43 04 00 00 00 00 8D 95 F0 07 00 00 52 FF B5 EC 07 00 00 68 00 10 00 00 FF B5 E8 07 00 00 FF D0 68 6C D9 B2 96 33 C0 50 E8 C1 03 00 00 89 85 ?? 46 00 00 68 EC 49 7B 79 33 C0 50 E8 AE 03 00 00 89 85 ?? 46 00 00 E8 04 06 00 00 E9 F3 05 00 00 51 52 53 33 C9 49 8B D1 33 C0 33 DB AC 32 C1 8A CD 8A EA 8A D6 B6 08 66 D1 EB 66 D1}
    condition:
        $a at pe.entry_point
}

rule PEiD_00421_Crunch_V5_0____Bitarts_
{
    meta:
        description = "[Crunch V5.0 -> Bitarts]"
        ep_only = "true"
    strings:
        $a = {EB 15 03 00 00 00 06}
    condition:
        $a at pe.entry_point
}

rule PEiD_00422_Crunch_PE_4_0_
{
    meta:
        description = "[Crunch/PE 4.0]"
        ep_only = "false"
    strings:
        $a = {EB 10 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 5D 81 ED 18 ?? ?? ?? 8B C5 55 60 9C 2B 85 E9 06 ?? ?? 89 85 E1 06 ?? ?? FF 74 24 2C E8 BB 01 00 00 0F 82 92 05 00 00 E8 F1 03 00 00 49 0F 88 86 05 00 00 68 6C D9 B2 96 33 C0 50 E8 24}
    condition:
        $a
}

rule PEiD_00423_Crunch_PE_v1_0_x_x_
{
    meta:
        description = "[Crunch/PE v1.0.x.x]"
        ep_only = "true"
    strings:
        $a = {55 E8 ?? ?? ?? ?? 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 80 BD ?? ?? ?? ?? ?? 75 09 C6 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_00424_Crunch_PE_v2_0_x_x_
{
    meta:
        description = "[Crunch/PE v2.0.x.x]"
        ep_only = "true"
    strings:
        $a = {55 E8 ?? ?? ?? ?? 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 55 BB ?? ?? ?? ?? 03 DD 53 64 67 FF 36 ?? ?? 64 67 89 26}
    condition:
        $a at pe.entry_point
}

rule PEiD_00425_Crunch_PE_v3_0_x_x_
{
    meta:
        description = "[Crunch/PE v3.0.x.x]"
        ep_only = "true"
    strings:
        $a = {EB 10 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 5D 81 ED 18 ?? ?? ?? 8B C5 55 60 9C 2B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? FF 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_00426_Crunch_PE_v4_0_
{
    meta:
        description = "[Crunch/PE v4.0]"
        ep_only = "false"
    strings:
        $a = {EB 10 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 5D 81 ED 18 ?? ?? ?? 8B C5 55 60 9C 2B 85 E9 06 ?? ?? 89 85 E1 06 ?? ?? FF 74 24 2C E8 BB 01 00 00 0F 82 92 05 00 00 E8 F1 03 00 00 49 0F 88 86 05 00 00 68 6C D9 B2 96 33 C0 50 E8 24 03 00 00 89 85 D9 41 00 00 68 EC 49 7B 79 33 C0 50 E8 11 03 00 00 89 85 D1 41 00 00 E8 67 05 00 00 E9 56 05 00 00 51 52 53 33 C9 49 8B D1 33 C0 33 DB AC 32 C1 8A CD 8A EA 8A D6 B6 08 66 D1 EB 66 D1 D8 73 09 66 35 20 83 66 81 F3 B8 ED FE CE 75 EB 33 C8 33 D3 4F 75 D5 F7 D2 F7 D1 5B 8B C2 C1 C0 10 66 8B C1 5A 59 C3 68 03 02 00 00 E8 80 04 00 00 0F 82 A8 02 00 00 96 8B 44 24 04 0F C8 8B D0 25 0F 0F 0F 0F 33 D0 C1 C0 08 0B C2 8B D0 25 33 33 33 33 33 D0 C1 C0 04 0B C2 8B D0 25 55 55 55 55 33 D0 C1 C0 02 0B C2}
    condition:
        $a
}

rule PEiD_00427_Crunch_PE_
{
    meta:
        description = "[Crunch/PE]"
        ep_only = "true"
    strings:
        $a = {55 E8 ?? ?? ?? ?? 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_00428_Cruncher_v1_0_
{
    meta:
        description = "[Cruncher v1.0]"
        ep_only = "true"
    strings:
        $a = {2E ?? ?? ?? ?? 2E ?? ?? ?? B4 30 CD 21 3C 03 73 ?? BB ?? ?? 8E DB 8D ?? ?? ?? B4 09 CD 21 06 33 C0 50 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00429_CrypKey____Kenonic_Controls__h__
{
    meta:
        description = "[CrypKey -> Kenonic Controls (h)]"
        ep_only = "true"
    strings:
        $a = {8B 1D ?? ?? 3E 00 83 FB 00 75 0A E8 3C 00 00 00 E8 ?? 0A 00 00 8B 44 24 08 50 E8 ?? 02 00 00 A1 ?? ?? 3E 00 83 F8 01 74 06 FF 25 14 ?? 3E 00 C3 C8 00 00 00 53 8B 5D 08 33 C0 8B 4D 0C 8B 13 33 D3 83 C3 04 03 C2 49 75 F4 5B C9 C3 56 68 ?? ?? 3E 00 E8 ?? 16 00 00 8B F0 68 ?? ?? 3E 00 56 E8 ?? 16 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? 16 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? ?? 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? ?? 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? ?? 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? ?? 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00430_CrypKey_v5___v6_
{
    meta:
        description = "[CrypKey v5 - v6]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? 58 83 E8 05 50 5F 57 8B F7 81 EF ?? ?? ?? ?? 83 C6 39 BA ?? ?? ?? ?? 8B DF B9 0B ?? ?? ?? 8B 06}
    condition:
        $a at pe.entry_point
}

rule PEiD_00431_CrypKey_V5_6_X____Kenonic_Controls_Ltd__
{
    meta:
        description = "[CrypKey V5.6.X -> Kenonic Controls Ltd.]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 00 75 07 6A 00 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00432_CrypKey_V5_6_X_DLL____Kenonic_Controls_Ltd__
{
    meta:
        description = "[CrypKey V5.6.X DLL -> Kenonic Controls Ltd.]"
        ep_only = "true"
    strings:
        $a = {8B 1D ?? ?? ?? ?? 83 FB 00 75 0A E8 ?? ?? ?? ?? E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00433_CrypKey_V6_1X_DLL____CrypKey__Canada__Inc__
{
    meta:
        description = "[CrypKey V6.1X DLL -> CrypKey (Canada) Inc.]"
        ep_only = "true"
    strings:
        $a = {83 3D ?? ?? ?? ?? 00 75 34 68 ?? ?? ?? ?? E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00434_CRYPT_Version_1_7__c__Dismember__COM__
{
    meta:
        description = "[CRYPT Version 1.7 (c) Dismember (COM)]"
        ep_only = "true"
    strings:
        $a = {0E 17 9C 58 F6 C4 01 ?? ?? ?? ?? ?? B4 01 BE ?? ?? BF ?? ?? B9 ?? ?? 68 ?? ?? 68 ?? ?? 68 ?? ?? 57 F3 A4 C3 B0 02 E6 21 60}
    condition:
        $a at pe.entry_point
}

rule PEiD_00435_CRYPT_Version_1_7__c__Dismember__EXE__
{
    meta:
        description = "[CRYPT Version 1.7 (c) Dismember (EXE)]"
        ep_only = "true"
    strings:
        $a = {0E 17 9C 58 F6 ?? ?? 74 ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00436_CryptCom_v1_1_
{
    meta:
        description = "[CryptCom v1.1]"
        ep_only = "true"
    strings:
        $a = {BF ?? ?? 57 BE ?? ?? ?? B9 ?? ?? F3 A4 C3 8B ?? ?? ?? 8B ?? ?? ?? BF ?? ?? 57 BE ?? ?? ?? AD 33 C2 AB E2 ?? C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00437_Crypter_3_1____SLESH_
{
    meta:
        description = "[Crypter 3.1 -> SLESH]"
        ep_only = "true"
    strings:
        $a = {68 FF 64 24 F0 68 58 58 58 58 FF D4 50 8B 40 F2 05 B0 95 F6 95 0F 85 01 81 BB FF 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_00438_Cryptic_2_0____Tughack_
{
    meta:
        description = "[Cryptic 2.0 -> Tughack]"
        ep_only = "true"
    strings:
        $a = {B8 00 00 40 00 BB ?? ?? ?? 00 B9 00 10 00 00 BA ?? ?? ?? 00 03 D8 03 C8 03 D1 3B CA 74 06 80 31 ?? 41 EB F6 FF E3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00439_Crypto_Lock_2_02__Eng_____Ryan_Thian_
{
    meta:
        description = "[Crypto-Lock 2.02 (Eng) -> Ryan Thian]"
        ep_only = "false"
    strings:
        $a = {60 BE 15 90 40 00 8D BE EB 7F FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0}
    condition:
        $a
}

rule PEiD_00440_Crypto_Lock_2_02__Eng_____Ryan_Thian_
{
    meta:
        description = "[Crypto-Lock 2.02 (Eng) -> Ryan Thian]"
        ep_only = "true"
    strings:
        $a = {60 BE ?? 90 40 00 8D BE ?? ?? FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00441_Crypto_Lock_v2_02__Eng_____Ryan_Thian_
{
    meta:
        description = "[Crypto-Lock v2.02 (Eng) -> Ryan Thian]"
        ep_only = "true"
    strings:
        $a = {60 BE 15 90 40 00 8D BE EB 7F FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47}
    condition:
        $a at pe.entry_point
}

rule PEiD_00442_Crypto_Lock_v2_02__Eng_____Ryan_Thian_
{
    meta:
        description = "[Crypto-Lock v2.02 (Eng) -> Ryan Thian]"
        ep_only = "true"
    strings:
        $a = {60 BE 15 90 40 00 8D BE EB 7F FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 83 C1 02 81 FD 00 F3 FF FF 83 D1 01 8D 14 2F 83 FD FC 76 0F 8A 02 42 88 07 47 49 75 F7 E9 63 FF FF FF 90 8B 02 83 C2 04 89 07 83 C7 04 83 E9 04 77 F1 01 CF E9 4C FF FF FF 5E 89 F7 B9 55 00 00 00 8A 07 47 2C E8 3C 01 77 F7 80 3F 01 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 29 F8 80 EB E8 01 F0 89 07}
    condition:
        $a at pe.entry_point
}

rule PEiD_00443_Crypto_Lock_v2_02__Eng_____Ryan_Thian_
{
    meta:
        description = "[Crypto-Lock v2.02 (Eng) -> Ryan Thian]"
        ep_only = "true"
    strings:
        $a = {60 BE ?? 90 40 00 8D BE ?? ?? FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 83 C1 02 81 FD 00 F3 FF FF 83 D1 01 8D 14 2F 83 FD FC 76 0F 8A 02 42 88 07 47 49 75 F7 E9 63 FF FF FF 90 8B 02 83 C2 04 89 07 83 C7 04 83 E9 04 77 F1 01 CF E9 4C FF FF FF 5E 89 F7 B9 55 00 00 00 8A 07 47 2C E8 3C 01 77 F7 80 3F 01 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 29 F8 80 EB E8 01 F0 89 07}
    condition:
        $a at pe.entry_point
}

rule PEiD_00444_CRYPToCRACk_s_PE_Protector_V0_9_2____Lukas_Fleischer___Sign_by_fly_
{
    meta:
        description = "[CRYPToCRACk's PE Protector V0.9.2 -> Lukas Fleischer ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {E8 01 00 00 00 E8 58 5B 81 E3 00 FF FF FF 66 81 3B 4D 5A 75 37 84 DB 75 33 8B F3 03 ?? ?? 81 3E 50 45 00 00 75 26}
    condition:
        $a at pe.entry_point
}

rule PEiD_00445_CRYPToCRACk_s_PE_Protector_v0_9_3____Lucas_Fleischer__h__
{
    meta:
        description = "[CRYPToCRACk's PE Protector v0.9.3 -> Lucas Fleischer (h)]"
        ep_only = "true"
    strings:
        $a = {5B 81 E3 00 FF FF FF 66 81 3B 4D 5A 75 33 8B F3 03 73 3C 81 3E 50 45 00 00 75 26 0F B7 46 18 8B C8 69 C0 AD 0B 00 00 F7 E0 2D AB 5D 41 4B 69 C9 DE C0 00 00 03 C1 75 09 83 EC 04 0F 85 DD 00 00 00 81 EB 00 01 00 00 75 BE 90 72 ?? ?? ?? ?? 00 00 00 00 00 00 00 7A ?? ?? ?? 72 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 C1 00 46 61 74 61 6C 45 78 69 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_00446_CRYPToCRACk_s_PE_Protector_V0_9_3____Lukas_Fleischer___Sign_by_fly_
{
    meta:
        description = "[CRYPToCRACk's PE Protector V0.9.3 -> Lukas Fleischer ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {5B 81 E3 00 FF FF FF 66 81 3B 4D 5A 75 33 8B F3 03 73 3C 81 3E 50 45 00 00 75 26 0F B7 46 18 8B C8 69 C0 AD 0B 00 00 F7 E0 2D AB 5D 41 4B 69 C9 DE C0 00 00 03 C1}
    condition:
        $a at pe.entry_point
}

rule PEiD_00447_CrypWrap_vx_x_
{
    meta:
        description = "[CrypWrap vx.x]"
        ep_only = "true"
    strings:
        $a = {E8 B8 ?? ?? ?? E8 90 02 ?? ?? 83 F8 ?? 75 07 6A ?? E8 ?? ?? ?? ?? FF 15 49 8F 40 ?? A9 ?? ?? ?? 80 74 0E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00448_Cygwin32_
{
    meta:
        description = "[Cygwin32]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 04 83 3D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00449_D1NS1G____D1N_
{
    meta:
        description = "[D1NS1G -> D1N]"
        ep_only = "false"
    strings:
        $a = {18 37 00 00 00 00 00 00 01 00 0A 00 00 00 18 00 00 80 00 00 00 00 ?? ?? 18 37 00 00 00 00 02 00 00 00 88 00 00 80 38 00 00 80 96 00 00 80 50 00 00 80 00 00 00 00 ?? ?? 18 37 00 00 00 00 00 00 01 00 00 00 00 00 68 00 00 00 00 00 00 00 ?? ?? 18 37 00 00 00 00 00 00 01 00 00 00 00 00 78 00 00 00 B0 F0 00 00 10 00 00 00 00 00 00 00 00 00 00 00 C0 F0 00 00 60 00 00 00 00 00 00 00 00 00 00 00 06 00 44 00 56 00 43 00 4C 00 41 00 4C 00 0B 00 50 00 41 00 43 00 4B 00 41 00 47 00 45 00 49 00 4E 00 46 00 4F 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_00450_D1S1G_v1_1_Beta____Scrambled_EXE____D1N_
{
    meta:
        description = "[D1S1G v1.1 Beta ++ Scrambled EXE -> D1N]"
        ep_only = "false"
    strings:
        $a = {E8 07 00 00 00 E8 1E 00 00 00 C3 90 58 89 C2 89 C2 25 00 F0 FF FF 50 83 C0 55 8D 00 FF 30 8D 40 04 FF 30 52 C3 8D 40 00 55 8B EC 83 C4 E8 53 56 57 8B 4D 10 8B 45 08 89 45 F8 8B 45 0C 89 45 F4 8D 41 61 8B 38 8D 41 65 8B 00 03 C7 89 45 FC 8D 41 69 8B 00 03 C7 8D 51 6D 8B 12 03 D7 83 C1 71 8B 09 03 CF 2B CA 72 0A 41 87 D1 80 31 FF 41 4A 75 F9 89 45 F0 EB 71 8B}
    condition:
        $a
}

rule PEiD_00451_D1S1G_v1_1_beta_____D1N_
{
    meta:
        description = "[D1S1G v1.1 beta --> D1N]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 01 00 0A 00 00 00 18 00 00 80 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 02 00 00 00 88 00 00 80 38 00 00 80 96 00 00 80 50 00 00 80 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 00 00 68 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 00 00 78 00 00 00 B0 ?? ?? 00 10 00 00 00 00 00 00 00 00 00 00 00 C0 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 06 00 44 00 56 00 43 00 4C 00 41 00 4C 00 0B 00 50 00 41 00 43 00 4B 00 41 00 47 00 45 00 49 00 4E 00 46 00 4F 00 00 00}
    condition:
        $a
}

rule PEiD_00452_DAEMON_Protect_v0_6_7_
{
    meta:
        description = "[DAEMON Protect v0.6.7]"
        ep_only = "true"
    strings:
        $a = {60 60 9C 8C C9 32 C9 E3 0C 52 0F 01 4C 24 FE 5A 83 C2 0C 8B 1A 9D 61}
    condition:
        $a at pe.entry_point
}

rule PEiD_00453_DalKrypt_1_0___by_DalKiT_
{
    meta:
        description = "[DalKrypt 1.0 - by DalKiT]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? 58 68 ?? ?? ?? 00 5F 33 DB EB 0D 8A 14 03 80 EA 07 80 F2 04 88 14 03 43 81 FB ?? ?? ?? 00 72 EB FF E7}
    condition:
        $a at pe.entry_point
}

rule PEiD_00454_DalKrypt_1_0___by_DalKiT_
{
    meta:
        description = "[DalKrypt 1.0 - by DalKiT]"
        ep_only = "true"
    strings:
        $a = {68 00 10 40 00 58 68 ?? ?? ?? 00 5F 33 DB EB 0D 8A 14 03 80 EA 07 80 F2 04 88 14 03 43 81 FB ?? ?? ?? 00 72 EB FF E7}
    condition:
        $a at pe.entry_point
}

rule PEiD_00455_DBPE_v1_53_
{
    meta:
        description = "[DBPE v1.53]"
        ep_only = "true"
    strings:
        $a = {9C 55 57 56 52 51 53 9C FA E8 ?? ?? ?? ?? 5D 81 ED 5B 53 40 ?? B0 ?? E8 ?? ?? ?? ?? 5E 83 C6 11 B9 27 ?? ?? ?? 30 06 46 49 75 FA}
    condition:
        $a at pe.entry_point
}

rule PEiD_00456_DBPE_v2_10_
{
    meta:
        description = "[DBPE v2.10]"
        ep_only = "true"
    strings:
        $a = {9C 6A 10 73 0B EB 02 C1 51 E8 06 ?? ?? ?? C4 11 73 F7 5B CD 83 C4 04 EB 02 99 EB FF 0C 24 71 01 E8 79 E0 7A 01 75 83 C4 04 9D EB 01 75 68 5F 20 40 ?? E8 B0 EF FF FF 72 03 73 01 75 BE}
    condition:
        $a at pe.entry_point
}

rule PEiD_00457_DCrypt_Private_0_9b____drmist_
{
    meta:
        description = "[DCrypt Private 0.9b -> drmist]"
        ep_only = "true"
    strings:
        $a = {B9 ?? ?? ?? 00 E8 00 00 00 00 58 68 ?? ?? ?? 00 83 E8 0B 0F 18 00 D0 00 48 E2 FB C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00458_DEF_1_0____bart_xt_
{
    meta:
        description = "[DEF 1.0 -> bart/xt]"
        ep_only = "true"
    strings:
        $a = {BE ?? ?? 40 00 6A ?? 59 80 7E 07 00 74 11 8B 46 0C 05 00 00 40 00 8B 56 10 30 10 40 4A 75 FA 83 C6 28 E2 E4 68 ?? ?? 40 00 C3 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00459_DEF_1_0____bart_xt_
{
    meta:
        description = "[DEF 1.0 -> bart/xt]"
        ep_only = "true"
    strings:
        $a = {BE ?? ?? 40 00 6A ?? 59 80 7E 07 00 74 11 8B 46 0C 05 00 00 40 00 8B 56 10 30 10 40 4A 75 FA 83 C6 28 E2 E4 68 ?? ?? 40 00 C3 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00460_DEF_1_00__Eng_____bart_xt_
{
    meta:
        description = "[DEF 1.00 (Eng) -> bart/xt]"
        ep_only = "false"
    strings:
        $a = {BE ?? 01 40 00 6A ?? 59 80 7E 07 00 74 11 8B 46 0C 05 00 00 40 00 8B 56 10 30 10 40 4A 75 FA 83 C6 28 E2 E4 68 ?? ?? 40 00 C3 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_00461_DEF_v1_00__Eng_____bart_xt_
{
    meta:
        description = "[DEF v1.00 (Eng) -> bart/xt]"
        ep_only = "true"
    strings:
        $a = {BE ?? 01 40 00 6A ?? 59 80 7E 07 00 74 11 8B 46 0C 05 00 00 40 00 8B 56 10 30 10 40 4A 75 FA 83 C6 28 E2 E4 68 ?? ?? 40 00 C3 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00462_DEF_v1_0_
{
    meta:
        description = "[DEF v1.0]"
        ep_only = "true"
    strings:
        $a = {BE ?? 01 40 00 6A 05 59 80 7E 07 00 74 11 8B 46}
    condition:
        $a at pe.entry_point
}

rule PEiD_00463_DEF_v1_0_
{
    meta:
        description = "[DEF v1.0]"
        ep_only = "false"
    strings:
        $a = {BE ?? 01 40 00 6A ?? 59 80 7E 07 00 74 11 8B 46 0C 05 00 00 40 00 8B 56 10 30 10 40 4A 75 FA 83 C6 28 E2 E4 68 ?? 10 40 00 C3}
    condition:
        $a
}

rule PEiD_00464_dePACK____deNULL_
{
    meta:
        description = "[dePACK -> deNULL]"
        ep_only = "true"
    strings:
        $a = {EB 01 DD 60 68 00 ?? ?? ?? 68 ?? ?? 00 00 E8 ?? 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00465_Dev_C___4_9_9_2____Bloodshed_Software_
{
    meta:
        description = "[Dev-C++ 4.9.9.2 -> Bloodshed Software]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 ?? ?? ?? 00 E8 C8 FE FF FF 90 8D B4 26 00 00 00 00 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 ?? ?? ?? 00 E8 A8 FE FF FF 90 8D B4 26 00 00 00 00 55 8B 0D ?? ?? ?? 00 89 E5 5D FF E1 8D 74 26 00 55 8B 0D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00466_Dev_C___v4_
{
    meta:
        description = "[Dev-C++ v4]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 83 EC 08 83 C4 F4 6A ?? A1 ?? ?? ?? 00 FF D0 E8 ?? FF FF FF}
    condition:
        $a
}

rule PEiD_00467_Dev_C___v5_
{
    meta:
        description = "[Dev-C++ v5]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 83 EC 14 6A ?? FF 15 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00}
    condition:
        $a
}

rule PEiD_00468_DIET_v1_00__v1_00d_
{
    meta:
        description = "[DIET v1.00, v1.00d]"
        ep_only = "true"
    strings:
        $a = {BF ?? ?? 3B FC 72 ?? B4 4C CD 21 BE ?? ?? B9 ?? ?? FD F3 A5 FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00469_DIET_v1_00d_
{
    meta:
        description = "[DIET v1.00d]"
        ep_only = "true"
    strings:
        $a = {FC 06 1E 0E 8C C8 01 ?? ?? ?? BA ?? ?? 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00470_DIET_v1_02b__v1_10a__v1_20_
{
    meta:
        description = "[DIET v1.02b, v1.10a, v1.20]"
        ep_only = "true"
    strings:
        $a = {BE ?? ?? BF ?? ?? B9 ?? ?? 3B FC 72 ?? B4 4C CD 21 FD F3 A5 FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00471_DIET_v1_44__v1_45f_
{
    meta:
        description = "[DIET v1.44, v1.45f]"
        ep_only = "true"
    strings:
        $a = {F8 9C 06 1E 57 56 52 51 53 50 0E FC 8C C8 BA ?? ?? 03 D0 52}
    condition:
        $a at pe.entry_point
}

rule PEiD_00472_Ding_Boy_s_PE_lock_Phantasm_v0_8_
{
    meta:
        description = "[Ding Boy's PE-lock Phantasm v0.8]"
        ep_only = "true"
    strings:
        $a = {55 57 56 52 51 53 E8 00 00 00 00 5D 8B D5 81 ED 0D 39 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00473_Ding_Boy_s_PE_lock_Phantasm_v1_0___v1_1_
{
    meta:
        description = "[Ding Boy's PE-lock Phantasm v1.0 / v1.1]"
        ep_only = "true"
    strings:
        $a = {55 57 56 52 51 53 66 81 C3 EB 02 EB FC 66 81 C3 EB 02 EB FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00474_Ding_Boy_s_PE_lock_Phantasm_v1_5b3_
{
    meta:
        description = "[Ding Boy's PE-lock Phantasm v1.5b3]"
        ep_only = "true"
    strings:
        $a = {9C 55 57 56 52 51 53 9C FA E8 00 00 00 00 5D 81 ED 5B 53 40 00 B0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00475_Ding_Boy_s_PE_lock_v0_07_
{
    meta:
        description = "[Ding Boy's PE-lock v0.07]"
        ep_only = "true"
    strings:
        $a = {55 57 56 52 51 53 E8 00 00 00 00 5D 8B D5 81 ED 23 35 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00476_diPacker_1_x____diProtector_Software_
{
    meta:
        description = "[diPacker 1.x -> diProtector Software]"
        ep_only = "true"
    strings:
        $a = {0F 00 2D E9 01 00 A0 E3 68 01 00 EB 8C 00 00 EB 2B 00 00 EB 00 00 20 E0 1C 10 8F E2 8E 20 8F E2 00 30 A0 E3 67 01 00 EB 0F 00 BD E8 00 C0 8F E2 00 F0 9C E5}
    condition:
        $a at pe.entry_point
}

rule PEiD_00477_diProtector_1_x____diProtector_Software_
{
    meta:
        description = "[diProtector 1.x -> diProtector Software]"
        ep_only = "true"
    strings:
        $a = {01 00 A0 E3 14 00 00 EB 00 00 20 E0 44 10 9F E5 03 2A A0 E3 40 30 A0 E3 AE 00 00 EB 30 00 8F E5 00 20 A0 E1 3A 0E 8F E2 00 00 80 E2 1C 10 9F E5 20 30 8F E2 0E 00 00 EB 14 00 9F E5 14 10 9F E5 7F 20 A0 E3 C5 00 00 EB 04 C0 8F E2 00 F0 9C E5}
    condition:
        $a at pe.entry_point
}

rule PEiD_00478_DiskDupe__c__MSD_Configuration_file_
{
    meta:
        description = "[DiskDupe (c) MSD Configuration file]"
        ep_only = "false"
    strings:
        $a = {4D 53 44 20 44 61 74 61 20 56 65 72 73}
    condition:
        $a
}

rule PEiD_00479_DiskDupe__c__MSD_Users_file_
{
    meta:
        description = "[DiskDupe (c) MSD Users file]"
        ep_only = "false"
    strings:
        $a = {4D 53 44 20 55 73 65 72 73 20 56 65 72 73 69 6F 6E}
    condition:
        $a
}

rule PEiD_00480_DJoin_v0_7_public__RC4_encryption_____drmist_
{
    meta:
        description = "[DJoin v0.7 public (RC4 encryption) -> drmist]"
        ep_only = "true"
    strings:
        $a = {C6 05 ?? ?? 40 00 00 C6 05 ?? ?? 40 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00481_DJoin_v0_7_public__xor_encryption_____drmist_
{
    meta:
        description = "[DJoin v0.7 public (xor encryption) -> drmist]"
        ep_only = "true"
    strings:
        $a = {C6 05 ?? ?? 40 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00482_DOS_16M_DOS_Extender__c__Tenberry_Software_Inc_1987_1995_
{
    meta:
        description = "[DOS/16M DOS Extender (c) Tenberry Software Inc 1987-1995]"
        ep_only = "true"
    strings:
        $a = {BF ?? ?? 8E C7 8E D7 BC ?? ?? 36 ?? ?? ?? ?? FF ?? ?? ?? 36 ?? ?? ?? ?? BE ?? ?? AC 8A D8 B7 00 ?? ?? 8B ?? ?? ?? 4F 8E C7}
    condition:
        $a at pe.entry_point
}

rule PEiD_00483_DOS32_v_3_3_DOS_Extender_and_Loader_
{
    meta:
        description = "[DOS32 v.3.3 DOS-Extender and Loader]"
        ep_only = "true"
    strings:
        $a = {0E 1F FC 9C 5B 8B C3 80 F4 ?? 50 9D 9C 58 3A E7 75 ?? BA ?? ?? B4 09 CD 21 B4 4C CD 21}
    condition:
        $a at pe.entry_point
}

rule PEiD_00484_DotFix_Nice_Protect_2_1____GPcH_Soft_
{
    meta:
        description = "[DotFix Nice Protect 2.1 -> GPcH Soft]"
        ep_only = "true"
    strings:
        $a = {E9 FF 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00485_DotFix_Nice_Protect_V2_1____GPcH_Soft___Sign_By_haggar_
{
    meta:
        description = "[DotFix Nice Protect V2.1 -> GPcH Soft * Sign.By.haggar]"
        ep_only = "false"
    strings:
        $a = {E9 FF 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C3 60 B8 ?? ?? ?? ?? 03 C5 50 B8 ?? ?? ?? ?? 03 C5 FF 10 BB ?? ?? ?? ?? 03 DD 83 C3 0C 53 50 B8 ?? ?? ?? ?? 03 C5 FF 10 6A 40 68 00 10 00 00 FF 74 24 2C 6A 00 FF D0 89 44 24 1C 61 C3}
    condition:
        $a
}

rule PEiD_00486_DotFix_NiceProtect_vna_
{
    meta:
        description = "[DotFix NiceProtect vna]"
        ep_only = "true"
    strings:
        $a = {60 E8 55 00 00 00 8D BD 00 10 40 00 68 ?? ?? ?? 00 03 3C 24 8B F7 90 68 31 10 40 00 9B DB E3 55 DB 04 24 8B C7 DB 44 24 04 DE C1 DB 1C 24 8B 1C 24 66 AD 51 DB 04 24 90 90 DA 8D 77 10 40 00 DB 1C 24 D1 E1 29}
    condition:
        $a at pe.entry_point
}

rule PEiD_00487_Dr_Web_Virus_Finding_Engine____InSoft_EDV_Systeme_
{
    meta:
        description = "[Dr.Web Virus-Finding Engine -> InSoft EDV-Systeme]"
        ep_only = "true"
    strings:
        $a = {B8 01 00 00 00 C2 0C 00 8D 80 00 00 00 00 8B D2 8B ?? 24 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_00488_DragonArmor____Orient_
{
    meta:
        description = "[DragonArmor -> Orient]"
        ep_only = "true"
    strings:
        $a = {BF 4C ?? ?? 00 83 C9 FF 33 C0 68 34 ?? ?? 00 F2 AE F7 D1 49 51 68 4C ?? ?? 00 E8 11 0A 00 00 83 C4 0C 68 4C ?? ?? 00 FF 15 00 ?? ?? 00 8B F0 BF 4C ?? ?? 00 83 C9 FF 33 C0 F2 AE F7 D1 49 BF 4C ?? ?? 00 8B D1 68 34 ?? ?? 00 C1 E9 02 F3 AB 8B CA 83 E1 03 F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00489_DragonArmor____Orient_
{
    meta:
        description = "[DragonArmor -> Orient]"
        ep_only = "true"
    strings:
        $a = {BF 4C ?? ?? 00 83 C9 FF 33 C0 68 34 ?? ?? 00 F2 AE F7 D1 49 51 68 4C ?? ?? 00 E8 11 0A 00 00 83 C4 0C 68 4C ?? ?? 00 FF 15 00 ?? ?? 00 8B F0 BF 4C ?? ?? 00 83 C9 FF 33 C0 F2 AE F7 D1 49 BF 4C ?? ?? 00 8B D1 68 34 ?? ?? 00 C1 E9 02 F3 AB 8B CA 83 E1 03 F3 AA BF 5C ?? ?? 00 83 C9 FF 33 C0 F2 AE F7 D1 49 51 68 5C ?? ?? 00 E8 C0 09 00 00 8B 1D 04 ?? ?? 00 83 C4 0C 68 5C ?? ?? 00 56 FF D3 A3 D4 ?? ?? 00 BF 5C ?? ?? 00 83 C9 FF 33 C0 F2 AE F7 D1 49 BF 5C ?? ?? 00 8B D1 68 34 ?? ?? 00 C1 E9 02 F3 AB 8B CA 83 E1}
    condition:
        $a at pe.entry_point
}

rule PEiD_00490_Dropper_Creator_V0_1____Conflict_
{
    meta:
        description = "[Dropper Creator V0.1 -> Conflict]"
        ep_only = "false"
    strings:
        $a = {60 E8 00 00 00 00 5D 8D 05 ?? ?? ?? ?? 29 C5 8D 85 ?? ?? ?? ?? 31 C0 64 03 40 30 78 0C 8B 40 0C 8B 70 1C AD 8B 40 08 EB 09}
    condition:
        $a
}

rule PEiD_00491_DSHIELD_
{
    meta:
        description = "[DSHIELD]"
        ep_only = "true"
    strings:
        $a = {06 E8 ?? ?? 5E 83 EE ?? 16 17 9C 58 B9 ?? ?? 25 ?? ?? 2E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00492_Dual_s_Cryptor____dual_
{
    meta:
        description = "[Dual's Cryptor -> dual]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 00 05 00 00 E8 00 00 00 00 5D 81 ED 0E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00493_Dual_s_eXe_1_0_
{
    meta:
        description = "[Dual's eXe 1.0]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 00 05 00 00 E8 00 00 00 00 5D 81 ED 0E 00 00 00 8D 85 08 03 00 00 89 28 33 FF 8D 85 7D 02 00 00 8D 8D 08 03 00 00 2B C8 8B 9D 58 03 00 00 E8 1C 02 00 00 8D 9D 61 02 00 00 8D B5 7C 02 00 00 46 80 3E 00 74 24 56 FF 95 0A 04 00 00 46 80 3E 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00494_Dual_s_eXe_1_0_
{
    meta:
        description = "[Dual's eXe 1.0]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 00 05 00 00 E8 00 00 00 00 5D 81 ED 0E 00 00 00 8D 85 08 03 00 00 89 28 33 FF 8D 85 7D 02 00 00 8D 8D 08 03 00 00 2B C8 8B 9D 58 03 00 00 E8 1C 02 00 00 8D 9D 61 02 00 00 8D B5 7C 02 00 00 46 80 3E 00 74 24 56 FF 95 0A 04 00 00 46 80 3E 00 75 FA 46 80 3E 00 74 E7 50 56 50 FF 95 0E 04 00 00 89 03 58 83 C3 04 EB E3 8D 85 24 03 00 00 50 68 1F 00 02 00 6A 00 8D 85 48 03 00 00 50 68 01 00 00 80 FF 95 69 02 00 00 83 BD 24 03 00 00 00 0F 84 8B 00 00 00 C7 85 28 03 00 00 04 00 00 00 8D 85 28 03 00 00 50 8D 85 20 03 00 00 50 8D 85 6C 03 00 00 50 6A 00 8D 85 62 03 00 00 50 FF B5 24 03 00 00 FF 95 71 02 00 00 83 BD 20 03 00 00 01 7E 02 EB 20 6A 40 8D 85 73 03 00 00 50 8D 85 82 03 00 00 50 6A 00 FF 95 61 02 00 00 6A 00 FF 95 65 02 00 00 FF 8D 20 03 00 00 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00495_Dual_s_eXe_Encryptor_1_0b____Dual_
{
    meta:
        description = "[Dual's eXe Encryptor 1.0b -> Dual]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 00 05 00 00 E8 00 00 00 00 5D 81 ED 0E 00 00 00 8D 85 3A 04 00 00 89 28 33 FF 8D 85 80 03 00 00 8D 8D 3A 04 00 00 2B C8 8B 9D 8A 04 00 00 E8 24 02 00 00 8D 9D 58 03 00 00 8D B5 7F 03 00 00 46 80 3E 00 74 24 56 FF 95 58 05 00 00 46 80 3E 00 75 FA 46 80 3E 00 74 E7 50 56 50 FF 95 5C 05 00 00 89 03 58 83 C3 04 EB E3 8D 85 69 02 00 00 FF D0 8D 85 56 04 00 00 50 68 1F 00 02 00 6A 00 8D 85 7A 04 00 00 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_00496_dUP_2_x_Patcher____www_diablo2oo2_cjb_net_
{
    meta:
        description = "[dUP 2.x Patcher -> www.diablo2oo2.cjb.net]"
        ep_only = "false"
    strings:
        $a = {8B CB 85 C9 74 ?? 80 3A 01 74 08 AC AE 75 0A 42 49 EB EF 47 46 42 49 EB E9}
    condition:
        $a
}

rule PEiD_00497_dUP_v2_x_Patcher_____www_diablo2oo2_cjb_net_
{
    meta:
        description = "[dUP v2.x Patcher --> www.diablo2oo2.cjb.net]"
        ep_only = "false"
    strings:
        $a = {54 68 69 73 20 70 72 6F 67 72 61 6D 20 63 61 6E 6E 6F 74 20 62 65 20 72 75 6E 20 69 6E 20 44 4F 53 20 6D 6F}
    condition:
        $a
}

rule PEiD_00498_dUP2____diablo2oo2_
{
    meta:
        description = "[dUP2 -> diablo2oo2]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 3C 01 75}
    condition:
        $a at pe.entry_point
}

rule PEiD_00499_dUP2____diablo2oo2_
{
    meta:
        description = "[dUP2 -> diablo2oo2]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 3C 01 75 19 BE ?? ?? ?? ?? 68 00 02 00 00 56 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_00500_DxPack_1_0_
{
    meta:
        description = "[DxPack 1.0]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 8B FD 81 ED ?? ?? ?? ?? 2B B9 ?? ?? ?? ?? 81 EF ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 84}
    condition:
        $a at pe.entry_point
}

rule PEiD_00501_DxPack_V0_86____Dxd_
{
    meta:
        description = "[DxPack V0.86 -> Dxd]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 8B FD 81 ED 06 10 40 00 2B BD 94 12 40 00 81 EF 06 00 00 00 83 BD 14 13 40 00 01 0F 84 2F 01 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00502_DzA_Patcher_1_3_Loader_
{
    meta:
        description = "[DzA Patcher 1.3 Loader]"
        ep_only = "false"
    strings:
        $a = {BF 00 40 40 00 99 68 48 20 40 00 68 00 20 40 00 52 52 52 52 52 52 52 57 E8 15 01 00 00 85 C0 75 1C 99 52 52 57 52 E8 CB 00 00 00 FF 35 4C 20 40 00 E8 D2 00 00 00 6A 00 E8 BF 00 00 00 99 68 58 20 40 00 52 52 68 63 10 40 00 52 52 E8 DB 00 00 00 6A FF FF 35}
    condition:
        $a
}

rule PEiD_00503_DZA_Patcher_v1_3____DZA_
{
    meta:
        description = "[DZA Patcher v1.3 -> DZA]"
        ep_only = "true"
    strings:
        $a = {EB 08 35 48 34 30 4C 31 4E 00 60 E8 00 00 00 00 5D 8B D5 81 ED 44 73 40 00 2B 95 74 74 40 00 83 EA 10 89 95 70 74 40 00 8B 44 24 20 25 00 00 FF FF 80 38 4D 74 07 2D 00 00 01 00 EB F4 93 89 85 7C 74 40 00 8D BD 8C 74 40 00 E8 83 00 00 00 89 85 80 74 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00504_DZA_Patcher_v1_3____DZA_
{
    meta:
        description = "[DZA Patcher v1.3 -> DZA]"
        ep_only = "true"
    strings:
        $a = {EB 08 35 48 34 30 4C 31 4E 00 60 E8 00 00 00 00 5D 8B D5 81 ED 44 73 40 00 2B 95 74 74 40 00 83 EA 10 89 95 70 74 40 00 8B 44 24 20 25 00 00 FF FF 80 38 4D 74 07 2D 00 00 01 00 EB F4 93 89 85 7C 74 40 00 8D BD 8C 74 40 00 E8 83 00 00 00 89 85 80 74 40 00 8D BD A4 74 40 00 E8 72 00 00 00 89 85 84 74 40 00 8D BD F0 73 40 00 57 FF D0 8D BD 99 74 40 00 E8 58 00 00 00 89 85 88 74 40 00 8B 85 78 74 40 00 03 85 70 74 40 00 99 8D 8D 6C 74 40 00 51 52 52 50 52 52 FF 95 80 74 40 00 8D BD C0 74 40 00 8B 0F E3 13 8A 5F 05 8A 01 3A C3 75 FA 8A 57 04 88 11 83 C7 06 EB E9 E8 00 00 00 00 5D 81 ED F5 73 40 00 6A 00 FF 95 88 74 40 00 61 C3 8B D3 0F B7 43 3C 03 D8 8B 5B 78 03 DA 0B FF 74 40 8B 73 20 03 F2 8B 4B 18 53 33 DB AD 03 C2 56 57 87 FE 97 AC 0A C0 75 07 80 3F 00 74 0B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00505_DzA_Patcher_v1_3_Loader_
{
    meta:
        description = "[DzA Patcher v1.3 Loader]"
        ep_only = "false"
    strings:
        $a = {BF 00 40 40 00 99 68 48 20 40 00 68 00 20 40 00 52 52 52 52 52 52 52 57 E8 15 01 00 00 85 C0 75 1C 99 52 52 57 52 E8 CB 00 00 00 FF 35 4C 20 40 00 E8 D2 00 00 00 6A 00 E8 BF 00 00 00 99 68 58 20 40 00 52 52 68 63 10 40 00 52 52 E8 DB 00 00 00 6A FF FF 35 48 20 40 00 E8 C2 00 00 00 E8 C8 FF FF FF BF 40 40 40 00 FF 35 4C 20 40 00 E8 A1 00 00 00 8B 0F 83 F9 00 74 B1 60 6A 00 6A 04 6A 01 51 FF 35 48 20 40 00 E8 75 00 00 00 61 60 BB 5C 20 40 00 6A 00 6A 01 53 51 FF 35 48 20 40 00 E8 75 00 00 00 61 A0 5C 20 40 00 8A 5F 05 3A C3 74 14 FF 35 4C 20 40 00 E8 4B 00 00 00 6A 03 E8 4A 00 00 00 EB A2 60 8D 5F 04 6A 00 6A 01 53 51 FF 35 48 20 40 00 E8 4B 00 00 00 61 83 C7 06 FF 35 4C 20 40 00 E8 1E 00 00 00 6A 03 E8 1D 00 00 00 E9 72 FF FF FF FF 25 70 30 40 00 FF 25 78}
    condition:
        $a
}

rule PEiD_00506_E_language_
{
    meta:
        description = "[E language]"
        ep_only = "true"
    strings:
        $a = {E8 06 00 00 00 50 E8 ?? 01 00 00 55 8B EC 81 C4 F0 FE FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00507_E_S_O__Eclipse_Operating_System_v_2_08___DOS_Extender_
{
    meta:
        description = "[E.S.O. Eclipse Operating System v.2.08 + DOS Extender]"
        ep_only = "true"
    strings:
        $a = {8C C8 8E D8 BA ?? ?? E8 ?? ?? BB ?? ?? 8C C0 2B D8 B4 4A CD 21 BA ?? ?? 73 ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00508_E2C_by_DoP_
{
    meta:
        description = "[E2C by DoP]"
        ep_only = "true"
    strings:
        $a = {BE ?? ?? BF ?? ?? B9 ?? ?? FC 57 F3 A5 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00509_EEXE_Version_1_12_
{
    meta:
        description = "[EEXE Version 1.12]"
        ep_only = "true"
    strings:
        $a = {B4 30 CD 21 3C 03 73 ?? BA 1F 00 0E 1F B4 09 CD 21 B8 FF 4C CD 21}
    condition:
        $a at pe.entry_point
}

rule PEiD_00510_Elicense_System_V4_0_0_0____ViaTech_Inc_
{
    meta:
        description = "[Elicense System V4.0.0.0 -> ViaTech Inc]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 63 79 62 00 65 6C 69 63 65 6E 34 30 2E 64 6C 6C 00 00 00 00}
    condition:
        $a
}

rule PEiD_00511_Embed_PE_v1_13____cyclotron_
{
    meta:
        description = "[Embed PE v1.13 -> cyclotron]"
        ep_only = "true"
    strings:
        $a = {83 EC 50 60 68 5D B9 52 5A E8 2F 99 00 00 DC 99 F3 57 05 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_00512_EmbedPE_1_13____cyclotron_
{
    meta:
        description = "[EmbedPE 1.13 -> cyclotron]"
        ep_only = "true"
    strings:
        $a = {83 EC 50 60 68 5D B9 52 5A E8 2F 99 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00513_EmbedPE_1_13____cyclotron_
{
    meta:
        description = "[EmbedPE 1.13 -> cyclotron]"
        ep_only = "true"
    strings:
        $a = {83 EC 50 60 68 5D B9 52 5A E8 2F 99 00 00 DC 99 F3 57 05 68 B8 5E 2D C6 DA FD 48 63 05 3C 71 B8 5E 97 7C 36 7E 32 7C 08 4F 06 51 64 10 A3 F1 4E CF 25 CB 80 D2 99 54 46 ED E1 D3 46 86 2D 10 68 93 83 5C 46 4D 43 9B 8C D6 7C BB 99 69 97 71 2A 2F A3 38 6B 33}
    condition:
        $a at pe.entry_point
}

rule PEiD_00514_EmbedPE_1_13____cyclotron_
{
    meta:
        description = "[EmbedPE 1.13 -> cyclotron]"
        ep_only = "true"
    strings:
        $a = {83 EC 50 60 68 5D B9 52 5A E8 2F 99 00 00 DC 99 F3 57 05 68 B8 5E 2D C6 DA FD 48 63 05 3C 71 B8 5E 97 7C 36 7E 32 7C 08 4F 06 51 64 10 A3 F1 4E CF 25 CB 80 D2 99 54 46 ED E1 D3 46 86 2D 10 68 93 83 5C 46 4D 43 9B 8C D6 7C BB 99 69 97 71 2A 2F A3 38 6B 33 A3 F5 0B 85 97 7C BA 1D 96 DD 07 F8 FD D2 3A 98 83 CC 46 99 9D DF 6F 89 92 54 46 9F 94 43 CC 41 43 9B 8C 61 B9 D8 6F 96 3B D1 07 32 24 DD 07 05 8E CB 6F A1 07 5C 62 20 E0 DB BA 9D 83 54 46 E6 83 51 7A 2B 94 54 64 8A 83 05 68 D7 5E 2D C6 B7 57 00 B3 E8 3C 71 B8 3C 97 7C 36 19 32 7C 08 2A 06 51 64 73 A3 F1 4E 92 25 CB 80 8D 99 54 46 B0 E1 D3 46 A5 2D 10 68 B6 83 91 46 F2 DF 64 FD D1 BC CA AA 70 E2 AB 39 AE 3B 5A 6F 9B 15 BD 25 98 25 30 4C AD 7D 55 07 A8 A3 AC 0A C1 BD 54 72 BC 83 54 82 A3 97 B1 1A B3 83 54 46 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_00515_EmbedPE_V1_00_V1_24____cyclotron___Sign_by_fly_
{
    meta:
        description = "[EmbedPE V1.00-V1.24 -> cyclotron ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_00516_EmbedPE_V1_00_V1_24____cyclotron_
{
    meta:
        description = "[EmbedPE V1.00-V1.24 -> cyclotron]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00517_EmbedPE_v1_24____cyclotron_
{
    meta:
        description = "[EmbedPE v1.24 -> cyclotron]"
        ep_only = "true"
    strings:
        $a = {83 EC 50 60 68 ?? ?? ?? ?? E8 CB FF 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00518_EmbedPE_V1_X____cyclotron_
{
    meta:
        description = "[EmbedPE V1.X -> cyclotron]"
        ep_only = "true"
    strings:
        $a = {83 EC 50 60 68 ?? ?? ?? ?? E8 ?? ?? 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00519_Encapsulated_Postscript_graphics_file_v2_0_EPSF_1_2_
{
    meta:
        description = "[Encapsulated Postscript graphics file v2.0 EPSF-1.2]"
        ep_only = "false"
    strings:
        $a = {25 21 50 53 2D 41 64 6F 62 65 2D 32 2E 30 20 45 50 53 46 2D 31 2E 32}
    condition:
        $a
}

rule PEiD_00520_Encapsulated_Postscript_graphics_file_v3_0_EPSF_3_0_
{
    meta:
        description = "[Encapsulated Postscript graphics file v3.0 EPSF-3.0]"
        ep_only = "false"
    strings:
        $a = {25 21 50 53 2D 41 64 6F 62 65 2D 33 2E 30 20 45 50 53 46 2D 33 2E 30}
    condition:
        $a
}

rule PEiD_00521_Encrypted_by__RSCC_286_v1_01_
{
    meta:
        description = "[Encrypted by? RSCC/286 v1.01]"
        ep_only = "false"
    strings:
        $a = {FE 52 53 43 43 2F 31 2E 30 31 FE}
    condition:
        $a
}

rule PEiD_00522_Encrypted_by__RSCC_286_v1_02_
{
    meta:
        description = "[Encrypted by? RSCC/286 v1.02]"
        ep_only = "false"
    strings:
        $a = {FE 52 53 43 43 2F 31 2E 30 32 FE}
    condition:
        $a
}

rule PEiD_00523_EncryptPE_1_2003_5_18____WFS_
{
    meta:
        description = "[EncryptPE 1.2003.5.18 -> WFS]"
        ep_only = "true"
    strings:
        $a = {60 9C 64 FF 35 00 00 00 00 E8 79}
    condition:
        $a at pe.entry_point
}

rule PEiD_00524_EncryptPE_2_2004_8_10___2_2005_3_14____WFS_
{
    meta:
        description = "[EncryptPE 2.2004.8.10 - 2.2005.3.14 -> WFS]"
        ep_only = "true"
    strings:
        $a = {60 9C 64 FF 35 00 00 00 00 E8 7A}
    condition:
        $a at pe.entry_point
}

rule PEiD_00525_EncryptPE_V1_2003_3_18_V1_2003_5_18____WFS_
{
    meta:
        description = "[EncryptPE V1.2003.3.18-V1.2003.5.18 -> WFS]"
        ep_only = "true"
    strings:
        $a = {60 9C 64 FF 35 00 00 00 00 E8 79 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00526_EncryptPE_V2_2004_6_16_V2_2006_6_30____WFS___Sign_by_fly_
{
    meta:
        description = "[EncryptPE V2.2004.6.16-V2.2006.6.30 -> WFS ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 9C 64 FF 35 00 00 00 00 E8 7A 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00527_EncryptPE_V2_2004_6_16_V2_2006_6_30____WFS_
{
    meta:
        description = "[EncryptPE V2.2004.6.16-V2.2006.6.30 -> WFS]"
        ep_only = "true"
    strings:
        $a = {60 9C 64 FF 35 00 00 00 00 E8 73 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00528_EncryptPE_V2_2006_1_15____WFS_
{
    meta:
        description = "[EncryptPE V2.2006.1.15 -> WFS]"
        ep_only = "false"
    strings:
        $a = {45 50 45 3A 20 45 6E 63 72 79 70 74 50 45 20 56 32 2E 32 30 30 36 2E 31 2E 31 35}
    condition:
        $a
}

rule PEiD_00529_EncryptPE_V2_2006_7_10____WFS_
{
    meta:
        description = "[EncryptPE V2.2006.7.10 -> WFS]"
        ep_only = "false"
    strings:
        $a = {60 9C 64 FF 35 00 00 00 00 E8 73 01 00 00}
    condition:
        $a
}

rule PEiD_00530_EncryptPE_V2_2006_7_10_V2_2007_04_11____WFS_
{
    meta:
        description = "[EncryptPE V2.2006.7.10-V2.2007.04.11 -> WFS]"
        ep_only = "true"
    strings:
        $a = {60 9C 64 FF 35 00 00 00 00 E8 1B 02 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00531_Enigma_protector_1_10__unregistered__
{
    meta:
        description = "[Enigma protector 1.10 (unregistered)]"
        ep_only = "false"
    strings:
        $a = {60 72 80 72 88 72 8C 72 90 72 94 72 98 72 9C 72 A0 72 A4 59 A8 B0 5C E8 39 D5 39 E4 39 F1 31 F9 5C 3D 58 CA 5F 56 B1 2D 20 7A 2E 30 16 32 72 2B 72 36 1C A5 33 A9 9C AD 9C B1 9C B5 9C B9 9C BD 9C C1 9C C5 9C C9 9C CD 9C D1 9C D5 9C D9 9C DD 9C E1 9C E5 89}
    condition:
        $a
}

rule PEiD_00532_Enigma_protector_1_10__unregistered__
{
    meta:
        description = "[Enigma protector 1.10 (unregistered)]"
        ep_only = "false"
    strings:
        $a = {60 72 80 72 88 72 8C 72 90 72 94 72 98 72 9C 72 A0 72 A4 59 A8 B0 5C E8 39 D5 39 E4 39 F1 31 F9 5C 3D 58 CA 5F 56 B1 2D 20 7A 2E 30 16 32 72 2B 72 36 1C A5 33 A9 9C AD 9C B1 9C B5 9C B9 9C BD 9C C1 9C C5 9C C9 9C CD 9C D1 9C D5 9C D9 9C DD 9C E1 9C E5 89 E9 51 0B C4 80 BC 7E 35 09 37 E7 C9 3D C9 45 C9 4D 74 92 BA E4 E9 24 6B DF 3E 0E 38 0C 49 10 27 80 51 A1 8E 3A A3 C8 AE 3B 1C 35}
    condition:
        $a
}

rule PEiD_00533_Enigma_Protector_1_1X_1_3X____Sukhov_Vladimir___Serge_N__Markin_
{
    meta:
        description = "[Enigma Protector 1.1X-1.3X -> Sukhov Vladimir & Serge N. Markin]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 B8 00 10 40 00 E8 01 00 00 00 9A 83 C4 10 8B E5 5D E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00534_Enigma_Protector_1_X____Sukhov_Vladimir___Serge_N__Markin_
{
    meta:
        description = "[Enigma Protector 1.X -> Sukhov Vladimir & Serge N. Markin]"
        ep_only = "true"
    strings:
        $a = {00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4C 6F 61}
    condition:
        $a at pe.entry_point
}

rule PEiD_00535_Enigma_Protector_1_X____Sukhov_Vladimir___Serge_N__Markin_
{
    meta:
        description = "[Enigma Protector 1.X -> Sukhov Vladimir & Serge N. Markin]"
        ep_only = "false"
    strings:
        $a = {00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 00 00 52 65 67 43 6C 6F 73 65 4B 65 79 00 00 00 53 79 73 46 72 65 65 53 74 72 69 6E 67 00 00 00 43 72 65 61 74 65 46 6F 6E 74 41 00 00 00 53 68 65 6C 6C 45 78 65 63 75 74 65 41 00 00}
    condition:
        $a
}

rule PEiD_00536_ENIGMA_Protector_V1_1____Sukhov_Vladimir_
{
    meta:
        description = "[ENIGMA Protector V1.1 -> Sukhov Vladimir]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 83 ?? ?? 81}
    condition:
        $a at pe.entry_point
}

rule PEiD_00537_ENIGMA_Protector_V1_1_CracKed_By__shoooo___fly____Sukhov_Vladimir_
{
    meta:
        description = "[ENIGMA Protector V1.1 CracKed By: shoooo & fly -> Sukhov Vladimir]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 83 C5 FA 81}
    condition:
        $a at pe.entry_point
}

rule PEiD_00538_ENIGMA_Protector_V1_1_V1_2____Sukhov_Vladimir_
{
    meta:
        description = "[ENIGMA Protector V1.1-V1.2 -> Sukhov Vladimir]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 83 ED 06 81}
    condition:
        $a at pe.entry_point
}

rule PEiD_00539_ENIGMA_Protector_V1_X____Sukhov_Vladimir_
{
    meta:
        description = "[ENIGMA Protector V1.X -> Sukhov Vladimir]"
        ep_only = "false"
    strings:
        $a = {45 6E 69 67 6D 61 20 70 72 6F 74 65 63 74 6F 72 20 76 31}
    condition:
        $a
}

rule PEiD_00540_EP_1_0_
{
    meta:
        description = "[EP 1.0]"
        ep_only = "false"
    strings:
        $a = {50 83 C0 17 8B F0 97 33 C0 33 C9 B1 24 AC 86 C4 AC AA 86 C4 AA E2 F6 00 B8 40 00 03 00 3C 40 D2 33 8B 66 14 50 70 8B 8D 34 02 44 8B 18 10 48 70 03 BA 0C ?? ?? ?? ?? C0 33 FE 8B 30 AC 30 D0 C1 F0 10 C2 D0 30 F0 30 C2 C1 AA 10 42 42 CA C1 E2 04 5F E9 5E B1}
    condition:
        $a
}

rule PEiD_00541_EP_v1_0_
{
    meta:
        description = "[EP v1.0]"
        ep_only = "true"
    strings:
        $a = {50 83 C0 17 8B F0 97 33 C0 33 C9 B1 24 AC 86 C4 AC AA 86 C4 AA E2 F6 00 B8 40 00 03 00 3C 40 D2 33 8B 66 14 50 70 8B 8D 34 02 44 8B 18 10 48 70 03 BA 0C ?? ?? ?? ?? C0 33 FE 8B 30 AC 30 D0 C1 F0 10 C2 D0 30 F0 30 C2 C1 AA 10 42 42 CA C1 E2 04 5F E9 5E B1 C0 30 ?? 68 ?? ?? F3 00 C3 AA}
    condition:
        $a at pe.entry_point
}

rule PEiD_00542_EP_v2_0_
{
    meta:
        description = "[EP v2.0]"
        ep_only = "true"
    strings:
        $a = {6A ?? 60 E9 01 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_00543_EPW_v1_2_
{
    meta:
        description = "[EPW v1.2]"
        ep_only = "true"
    strings:
        $a = {06 57 1E 56 55 52 51 53 50 2E ?? ?? ?? ?? 8C C0 05 ?? ?? 2E ?? ?? ?? 8E D8 A1 ?? ?? 2E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00544_EPW_v1_30_
{
    meta:
        description = "[EPW v1.30]"
        ep_only = "true"
    strings:
        $a = {06 57 1E 56 55 52 51 53 50 2E 8C 06 08 00 8C C0 83 C0 10 2E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00545_Erdas_LAN_GIS_Image_graphics_format_
{
    meta:
        description = "[Erdas LAN/GIS Image graphics format]"
        ep_only = "false"
    strings:
        $a = {48 45 41 44 37 34 00 00 03 00}
    condition:
        $a
}

rule PEiD_00546_Escargot_0_1__final_______Meat_
{
    meta:
        description = "[Escargot 0.1 (final) -> ++Meat]"
        ep_only = "true"
    strings:
        $a = {EB 04 40 30 2E 31 60 68 61 ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 B8 92 ?? ?? ?? 8B 00 FF D0 50 B8 CD ?? ?? ?? 81 38 DE C0 37 13 75 2D 68 C9 ?? ?? ?? 6A 40 68 00 ?? 00 00 68 00 00 ?? ?? B8 96 ?? ?? ?? 8B 00 FF D0 8B 44 24 F0 8B 4C 24 F4 EB 05 49 C6 04 01 40 0B C9 75 F7 BE 00 10 ?? ?? B9 00 ?? ?? 00 EB 05 49 80 34 31 40 0B C9 75 F7 58 0B C0 74 08 33 C0 C7 00 DE C0 AD 0B BE ?? ?? ?? ?? E9 AC 00 00 00 8B 46 0C BB 00 00 ?? ?? 03 C3 50 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_00547_Escargot_0_1___by_ueMeat_
{
    meta:
        description = "[Escargot 0.1 - by ueMeat]"
        ep_only = "true"
    strings:
        $a = {EB 08 28 65 73 63 30 2E 31 29 60 68 2B ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 B8 5C ?? ?? ?? 8B 00 FF D0 50 BE 00 10 ?? ?? B9 00 ?? ?? 00 EB 05 49 80 34 31 40 0B C9 75 F7 58 0B C0 74 08 33 C0 C7 00 DE C0 AD 0B BE ?? ?? ?? ?? E9 AC 00 00 00 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00548_Escargot_0_1___by_ueMeat_
{
    meta:
        description = "[Escargot 0.1 - by ueMeat]"
        ep_only = "false"
    strings:
        $a = {EB 08 28 65 73 63 30 2E 31 29 60 68 2B ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 B8 5C ?? ?? ?? 8B 00 FF D0 50 BE 00 10 ?? ?? B9 00 ?? ?? 00 EB 05 49 80 34 31 40 0B C9 75 F7 58 0B C0 74 08 33 C0 C7 00 DE C0 AD 0B BE ?? ?? ?? ?? E9 AC 00 00 00 8B 46 0C BB 00 00 ?? ?? 03 C3 50 50 B8 54 ?? ?? ?? 8B 00 FF D0 5F 80 3F 00 74 06 C6 07 00 47 EB F5 33 FF 8B 16 0B D2 75 03 8B 56 10 03 D3 03 D7 8B 0A C7 02 00 00 00 00 0B C9 74 4B F7 C1 00 00 00 80 74 14 81 E1 FF FF 00 00 50 51 50 B8 50}
    condition:
        $a
}

rule PEiD_00549_Escargot_V0_1______Meat_
{
    meta:
        description = "[Escargot V0.1 -> ++Meat]"
        ep_only = "true"
    strings:
        $a = {EB 04 40 30 2E 31 60 68 61}
    condition:
        $a at pe.entry_point
}

rule PEiD_00550_Exact_Audio_Copy_____UnknownCompiler__
{
    meta:
        description = "[Exact Audio Copy -> (UnknownCompiler)]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? 00 31 ED 55 89 E5 81 EC ?? 00 00 00 8D BD ?? FF FF FF B9 ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00551_Exact_Audio_Copy_
{
    meta:
        description = "[Exact Audio Copy]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? 00 31 ED 55 89 E5 81 EC ?? 00 00 00 8D BD ?? FF FF FF B9 ?? 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00552_Excalibur_1_03____forgot_
{
    meta:
        description = "[Excalibur 1.03 -> forgot]"
        ep_only = "true"
    strings:
        $a = {E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00553_Excalibur_V1_03____forgot___Sign_by_fly_
{
    meta:
        description = "[Excalibur V1.03 -> forgot ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 EB 39}
    condition:
        $a at pe.entry_point
}

rule PEiD_00554_eXcalibur_v1_03____forgot_us__h__
{
    meta:
        description = "[eXcalibur v1.03 -> forgot/us (h)]"
        ep_only = "false"
    strings:
        $a = {E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 EB 39 20 45 78 63 61 6C 69 62 75 72 20 28 63 29 20 62 79 20 66 6F 72 67 6F 74 2F 75 53 2F 44 46 43 47 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20}
    condition:
        $a
}

rule PEiD_00555_eXcalibur_v1_03____forgot_us__h__
{
    meta:
        description = "[eXcalibur v1.03 -> forgot/us (h)]"
        ep_only = "true"
    strings:
        $a = {E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 EB 39 20 45 78 63 61 6C 69 62 75 72 20 28 63 29 20 62 79 20 66 6F 72 67 6F 74 2F 75 53 2F 44 46 43 47 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 0D 0A 60 9C 9C 6A 63 73 0B EB 02 E8 E8 E8 06 00 00 00 E8 E8 73 F7 E8 E8 83 C4 04 EB 02 E8 E8 FF 0C 24 71 01 E8 79 E0 7A 01 E8 83 C4 04 9D EB 01 E8 E8 01 00 00 00 E9 5D 81 ED AE 28 40 00 9C 6A 63 73 0B EB 02 69 69 E8 06 00 00 00 69 69 73 F7 69 69 83 C4 04 EB 02 69 69 FF 0C 24 71 01 69 79 E0 7A 01 69 83 C4 04 9D EB 01 69 E8 E7 02 00 00 E8 9C 6A 63 73 0B EB 02 69 69 E8 06 00 00 00 69 69 73 F7 69 69 83 C4 04 EB 02 69 69 FF 0C 24 71 01 69 79 E0 7A 01 69 83 C4 04 9D EB 01 69 E8 B4 02 00 00 E8 60 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00556_Exe_Guarder_1_8____Exeicon_com__h__
{
    meta:
        description = "[Exe Guarder 1.8 -> Exeicon.com (h)]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 D0 53 56 57 8D 75 FC 8B 44 24 30 25 00 00 FF FF 81 38 4D 5A 90 00 74 07 2D 00 10 00 00 EB F1 89 45 FC E8 C8 FF FF FF 2D B2 04 00 00 89 45 F4 8B 06 8B 40 3C 03 06 8B 40 78 03 06 8B C8 8B 51 20 03 16 8B 59 24 03 1E 89 5D F0 8B 59 1C 03 1E 89}
    condition:
        $a
}

rule PEiD_00557_Exe_Guarder_v1_8____Exeicon_com__h__
{
    meta:
        description = "[Exe Guarder v1.8 -> Exeicon.com (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 D0 53 56 57 8D 75 FC 8B 44 24 30 25 00 00 FF FF 81 38 4D 5A 90 00 74 07 2D 00 10 00 00 EB F1 89 45 FC E8 C8 FF FF FF 2D B2 04 00 00 89 45 F4 8B 06 8B 40 3C 03 06 8B 40 78 03 06 8B C8 8B 51 20 03 16 8B 59 24 03 1E 89 5D F0 8B 59 1C 03 1E 89 5D EC 8B 41 18 8B C8 49 85 C9 72 5A 41 33 C0 8B D8 C1 E3 02 03 DA 8B 3B 03 3E 81 3F 47 65 74 50 75 40 8B DF 83 C3 04 81 3B 72 6F 63 41 75 33 8B DF 83 C3 08 81 3B 64 64 72 65 75 26 83 C7 0C 66 81 3F 73 73 75 1C 8B D0 03 D2 03 55 F0 0F B7 12 C1 E2 02 03 55 EC 8B 12 03 16 8B 4D F4 89 51 08 EB 04 40 49 75 A9 8B 5D F4 8D 83 A1 00 00 00 50 8B 06 50 FF 53 08 89 43 0C 8D 83 AE 00 00 00 50 8B 06 50 FF 53 08 89 43 10 8D 83 BA 00 00 00 50 8B 06 50 FF 53 08 89 43 14 8D 83 C6 00 00 00 50 8B 06 50 FF 53 08 89 43 18 8D 83 D7 00 00 00 50 8B 06 50 FF 53 08 89 43 1C 8D 83 E0 00 00 00 50 8B 06 50 FF 53 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_00558_EXE_joiner____Amok_
{
    meta:
        description = "[EXE joiner -> Amok]"
        ep_only = "true"
    strings:
        $a = {A1 14 A1 40 00 C1 E0 02 A3 18 A1 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00559_Exe_Locker_1_0____IonIce_
{
    meta:
        description = "[Exe Locker 1.0 -> IonIce]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 60 8B 6C 24 20 81 ED 05 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00560_Exe_Locker_v1_0____IonIce_
{
    meta:
        description = "[Exe Locker v1.0 -> IonIce]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 60 8B 6C 24 20 81 ED 05 00 00 00 3E 8F 85 6C 00 00 00 3E 8F 85 68 00 00 00 3E 8F 85 64 00 00 00 3E 8F 85 60 00 00 00 3E 8F 85 5C 00 00 00 3E 8F 85 58 00 00 00 3E 8F 85 54 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00561_EXE_Manager_Version_3_0_1994__c__Solar_Designer_
{
    meta:
        description = "[EXE Manager Version 3.0 1994 (c) Solar Designer]"
        ep_only = "true"
    strings:
        $a = {B4 30 1E 06 CD 21 2E ?? ?? ?? BF ?? ?? B9 ?? ?? 33 C0 2E ?? ?? 47 E2}
    condition:
        $a at pe.entry_point
}

rule PEiD_00562_EXE_Packer_v7_0_by_TurboPower_Software_
{
    meta:
        description = "[EXE Packer v7.0 by TurboPower Software]"
        ep_only = "true"
    strings:
        $a = {1E 06 8C C3 83 ?? ?? 2E ?? ?? ?? ?? B9 ?? ?? 8C C8 8E D8 8B F1 4E 8B FE}
    condition:
        $a at pe.entry_point
}

rule PEiD_00563_EXE_Shield_0_5____Smoke_
{
    meta:
        description = "[EXE Shield 0.5 -> Smoke]"
        ep_only = "false"
    strings:
        $a = {E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D 81 ED BC 1A 40 00 EB 01 00 8D B5 46 1B 40 00 BA B3 0A 00 00 EB 01 00 8D 8D F9 25 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40}
    condition:
        $a
}

rule PEiD_00564_Exe_Shield_2_7b_
{
    meta:
        description = "[Exe Shield 2.7b]"
        ep_only = "false"
    strings:
        $a = {EB 06 68 40 85 06 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 00 87 DD 8B 85 E6 90 40 00 01 85 33 90 40 00 66 C7 85 30 90 40 00 90 90 01 85 DA 90 40 00 01 85 DE 90 40 00 01 85 E2 90 40 00 BB 7B 11 00 00 03 9D EA 90 40}
    condition:
        $a
}

rule PEiD_00565_EXE_Shield_v0_1b___v0_3b__v0_3____SMoKE_
{
    meta:
        description = "[EXE Shield v0.1b - v0.3b, v0.3 -> SMoKE]"
        ep_only = "true"
    strings:
        $a = {E8 04 00 00 00 83 60 EB 0C 5D EB 05}
    condition:
        $a at pe.entry_point
}

rule PEiD_00566_EXE_Shield_V0_5____Smoke_
{
    meta:
        description = "[EXE Shield V0.5 -> Smoke]"
        ep_only = "true"
    strings:
        $a = {E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D 81 ED BC 1A 40 00 EB 01 00 8D B5 46 1B 40 00 BA B3 0A 00 00 EB 01 00 8D 8D F9 25 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 50 C3 8A 06 46 EB 01 00 D0 C8 E8 14 00 00 00 83 EB 01 00 2A C2 E8 00 00 00 00 5B 83 C3 07 53 C3 00 EB 04 5B 43 53 C3 EB 01 00 32 C2 E8 0B 00 00 00 00 32 C1 EB 01 00 C0 C0 02 EB 09 2A C2 5B EB 01 00 43 53 C3 88 07 EB 01 00 47 4A 75 B4 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_00567_EXE_Shield_V0_6____SMoKE_
{
    meta:
        description = "[EXE Shield V0.6 -> SMoKE]"
        ep_only = "false"
    strings:
        $a = {E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D 81 ED D4 1A 40 00 EB 01 00 8D B5 5E 1B 40 00 BA A1 0B 00 00 EB 01 00 8D 8D FF 26 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40}
    condition:
        $a
}

rule PEiD_00568_EXE_Shield_V0_6____SMoKE_
{
    meta:
        description = "[EXE Shield V0.6 -> SMoKE]"
        ep_only = "true"
    strings:
        $a = {E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D 81 ED D4 1A 40 00 EB 01 00 8D B5 5E 1B 40 00 BA A1 0B 00 00 EB 01 00 8D 8D FF 26 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 50 C3 8A 06 46 EB 01 00 D0 C8 E8 14 00 00 00 83 EB 01 00 2A C2 E8 00 00 00 00 5B 83 C3 07 53 C3 00 EB 04 5B 43 53 C3 EB 01 00 32 C2 E8 0B 00 00 00 00 32 C1 EB 01 00 C0 C0 02 EB 09 2A C2 5B EB 01 00 43 53 C3 88 07 EB 01 00 47 4A 75 B4 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_00569_Exe_Shield_v1_7_
{
    meta:
        description = "[Exe Shield v1.7]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 90 1F 06 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_00570_Exe_Shield_v2_7_
{
    meta:
        description = "[Exe Shield v2.7]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 F4 86 06 00 C3 9C 60 E8 02 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00571_Exe_Shield_v2_7b_
{
    meta:
        description = "[Exe Shield v2.7b]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 40 85 06 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 00 87 DD 8B 85 E6 90 40 00 01 85 33 90 40 00 66 C7 85 30 90 40 00 90 90 01 85 DA 90 40 00 01 85 DE 90 40 00 01 85 E2 90 40 00 BB 7B 11 00 00 03 9D EA 90 40 00 03 9D E6 90 40 00 53 8B C3 8B FB 2D AC 90 40 00 89 85 AD 90 40 00 8D B5 AC 90 40 00 B9 40 04 00 00 F3 A5 8B FB C3 BD 00 00 00 00 8B F7 83 C6 54 81 C7 FF 10 00 00 56 57 57 56 FF 95 DA 90 40 00 8B C8 5E 5F 8B C1 C1 F9 02 F3 A5 03 C8 83 E1 03 F3 A4 EB 26 D0 12 5B 00 AC 12 5B 00 48 12 5B 00 00 00 40 00 00 D0 5A 00 00 10 5B 00 87 DB 87 DB 87 DB 87 DB 87 DB 87 DB 87 DB 8B 0E B5 E6 90 40 07 56 03 76 EE 0F 18 83 C6 14 12 35 97 80 8D BD 63 39 0D B9 06 86 02 07 F3 A5 6A 04 68 06 10 12 1B FF B5 51 29 EE 10 22 95}
    condition:
        $a at pe.entry_point
}

rule PEiD_00572_Exe_Shield_v2_9_
{
    meta:
        description = "[Exe Shield v2.9]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 0B 20 40 00 B9 EB 08 00 00 8D BD 53 20 40 00 8B F7 AC ?? ?? ?? F8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00573_Exe_Shield_vx_x_
{
    meta:
        description = "[Exe Shield vx.x]"
        ep_only = "true"
    strings:
        $a = {65 78 65 73 68 6C 2E 64 6C 6C C0 5D 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00574_EXE_Stealth_2_5_
{
    meta:
        description = "[EXE Stealth 2.5]"
        ep_only = "false"
    strings:
        $a = {60 90 EB 22 45 78 65 53 74 65 61 6C 74 68 20 2D 20 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D E8 00 00 00 00 5D 81 ED 40 1E 40 00 B9 99 09 00 00 8D BD 88 1E 40 00 8B F7 AC}
    condition:
        $a
}

rule PEiD_00575_EXE_Stealth_2_73_
{
    meta:
        description = "[EXE Stealth 2.73]"
        ep_only = "false"
    strings:
        $a = {EB 00 EB 2F 53 68 61 72 65 77 61 72 65 20 2D 20 45 78 65 53 74 65 61 6C 74 68 00 EB 16 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 00 60 90 E8 00 00 00 00 5D 81 ED F0 27 40 00 B9 15 00 00 00 83 C1 05 EB 05 EB FE 83 C7 56 EB 00 83 E9 02}
    condition:
        $a
}

rule PEiD_00576_EXE_Stealth_2_74_
{
    meta:
        description = "[EXE Stealth 2.74]"
        ep_only = "false"
    strings:
        $a = {EB 00 EB 17 53 68 61 72 65 77 61 72 65 20 2D 20 45 78 65 53 74 65 61 6C 74 68 00 60 90 E8 00 00 00 00 5D 81 ED C4 27 40 00 B9 15 00 00 00 83 C1 04 83 C1 01 EB 05 EB FE 83 C7 56 EB 00 83 E9 02 81 C1 78 43 27 65 EB 00 81 C1 10 25 94 00 81 E9 63 85 00 00 B9}
    condition:
        $a
}

rule PEiD_00577_Exe_Stealth_2_75a____WebtoolMaster_
{
    meta:
        description = "[Exe Stealth 2.75a -> WebtoolMaster]"
        ep_only = "true"
    strings:
        $a = {EB 58 53 68 61 72 65 77 61 72 65 2D 56 65 72 73 69 6F 6E 20 45 78 65 53 74 65 61 6C 74 68 2C 20 63 6F 6E 74 61 63 74 20 73 75 70 70 6F 72 74 40 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 20 2D 20 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72}
    condition:
        $a at pe.entry_point
}

rule PEiD_00578_Exe_Stealth_2_75a____WebtoolMaster_
{
    meta:
        description = "[Exe Stealth 2.75a -> WebtoolMaster]"
        ep_only = "true"
    strings:
        $a = {EB 58 53 68 61 72 65 77 61 72 65 2D 56 65 72 73 69 6F 6E 20 45 78 65 53 74 65 61 6C 74 68 2C 20 63 6F 6E 74 61 63 74 20 73 75 70 70 6F 72 74 40 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 20 2D 20 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 00 90 60 90 E8 00 00 00 00 5D 81 ED F7 27 40 00 B9 15 00 00 00 83 C1 04 83 C1 01 EB 05 EB FE 83 C7 56 EB 00 EB 00 83 E9 02 81 C1 78 43 27 65 EB 00 81 C1 10 25 94 00 81 E9 63 85 00 00 B9 96 0C 00 00 90 8D BD 74 28 40 00 8B F7 AC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00579_EXE_Stealth_v1_1_
{
    meta:
        description = "[EXE Stealth v1.1]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED FB 1D 40 00 B9 7B 09 00 00 8B F7 AC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00580_EXE_Stealth_v2_71_
{
    meta:
        description = "[EXE Stealth v2.71]"
        ep_only = "true"
    strings:
        $a = {EB 00 60 EB 00 E8 00 00 00 00 5D 81 ED B0 27 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00581_EXE_Stealth_v2_72_
{
    meta:
        description = "[EXE Stealth v2.72]"
        ep_only = "true"
    strings:
        $a = {EB 00 EB 2F 53 68 61 72 65 77 61 72 65 20 2D 20}
    condition:
        $a at pe.entry_point
}

rule PEiD_00582_EXE_Stealth_v2_76____WebToolMaster_
{
    meta:
        description = "[EXE Stealth v2.76 -> WebToolMaster]"
        ep_only = "true"
    strings:
        $a = {EB 65 45 78 65 53 74 65 61 6C 74 68 20 56 32 20 2D 20 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 20 59 4F 55 52 20 41 44 20 48 45 52 45 21 50 69 52 41 43 59 20 69 53 20 41}
    condition:
        $a at pe.entry_point
}

rule PEiD_00583_EXE_Stealth_v2_7_
{
    meta:
        description = "[EXE Stealth v2.7]"
        ep_only = "true"
    strings:
        $a = {EB 00 60 EB 00 E8 00 00 00 00 5D 81 ED D3 26 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00584_EXE2COM__Encrypted_without_selfcheck__
{
    meta:
        description = "[EXE2COM (Encrypted without selfcheck)]"
        ep_only = "true"
    strings:
        $a = {B3 ?? B9 ?? ?? BE ?? ?? BF ?? ?? EB ?? 54 69 ?? ?? ?? ?? 03 ?? ?? 32 C3 AA 43 49 E3 ?? EB ?? BE ?? ?? 8B C6}
    condition:
        $a at pe.entry_point
}

rule PEiD_00585_EXE2COM__Limited__
{
    meta:
        description = "[EXE2COM (Limited)]"
        ep_only = "true"
    strings:
        $a = {BE ?? ?? 8B 04 3D ?? ?? 74 ?? BA ?? ?? B4 09 CD 21 CD 20}
    condition:
        $a at pe.entry_point
}

rule PEiD_00586_EXE2COM__Method_1__
{
    meta:
        description = "[EXE2COM (Method 1)]"
        ep_only = "true"
    strings:
        $a = {8C DB BE ?? ?? 8B C6 B1 ?? D3 E8 03 C3 03 ?? ?? A3 ?? ?? 8C C8 05 ?? ?? A3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00587_EXE2COM__Packed__
{
    meta:
        description = "[EXE2COM (Packed)]"
        ep_only = "true"
    strings:
        $a = {BD ?? ?? 89 ?? ?? ?? 81 ?? ?? ?? ?? ?? 8C ?? ?? ?? 8C C8 05 ?? ?? 8E C0 BE ?? ?? 8B FE 0E 57 54 59 F3 A4 06 68 ?? ?? CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00588_EXE2COM__regular__
{
    meta:
        description = "[EXE2COM (regular)]"
        ep_only = "true"
    strings:
        $a = {E9 8C CA 81 C3 ?? ?? 3B 16 ?? ?? 76 ?? BA ?? ?? B4 09 CD 21 CD 20 0D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00589_EXE2COM__With_CRC_check__
{
    meta:
        description = "[EXE2COM (With CRC check)]"
        ep_only = "true"
    strings:
        $a = {B3 ?? B9 ?? ?? 33 D2 BE ?? ?? 8B FE AC 32 C3 AA 43 49 32 E4 03 D0 E3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00590_EXE32Pack_v1_36_
{
    meta:
        description = "[EXE32Pack v1.36]"
        ep_only = "true"
    strings:
        $a = {3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC ?? ?? ?? ?? 02 81 ?? ?? ?? ?? ?? ?? ?? 3B DB 74 01 BE 5D 8B D5 81 ED CC 8D 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00591_EXE32Pack_v1_37_
{
    meta:
        description = "[EXE32Pack v1.37]"
        ep_only = "true"
    strings:
        $a = {3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC ?? ?? ?? ?? 02 81 ?? ?? ?? ?? ?? ?? ?? 3B DB 74 01 BE 5D 8B D5 81 ED 4C 8E 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00592_EXE32Pack_v1_38_
{
    meta:
        description = "[EXE32Pack v1.38]"
        ep_only = "true"
    strings:
        $a = {3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC ?? ?? ?? ?? 02 81 ?? ?? ?? ?? ?? ?? ?? 3B DB 74 01 BE 5D 8B D5 81 ED DC 8D 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00593_EXE32Pack_v1_39_
{
    meta:
        description = "[EXE32Pack v1.39]"
        ep_only = "true"
    strings:
        $a = {3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC ?? ?? ?? ?? 02 81 ?? ?? ?? ?? ?? ?? ?? 3B DB 74 01 BE 5D 8B D5 81 ED EC 8D 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00594_EXE32Pack_v1_3x_
{
    meta:
        description = "[EXE32Pack v1.3x]"
        ep_only = "true"
    strings:
        $a = {3B ?? 74 02 81 83 55 3B ?? 74 02 81 ?? 53 3B ?? 74 01 ?? ?? ?? ?? ?? 02 81 ?? ?? E8 ?? ?? ?? ?? 3B 74 01 ?? 5D 8B D5 81 ED}
    condition:
        $a at pe.entry_point
}

rule PEiD_00595_ExeBundle_v3_0__small_loader__
{
    meta:
        description = "[ExeBundle v3.0 (small loader)]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 60 BE 00 F0 40 00 8D BE 00 20 FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11}
    condition:
        $a at pe.entry_point
}

rule PEiD_00596_ExeBundle_v3_0__standard_loader__
{
    meta:
        description = "[ExeBundle v3.0 (standard loader)]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 60 BE 00 B0 42 00 8D BE 00 60 FD FF C7 87 B0 E4 02 00 31 3C 4B DF 57 83 CD FF EB 0E 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00597_EXECrypt_1_0____ReBirth_
{
    meta:
        description = "[EXECrypt 1.0 -> ReBirth]"
        ep_only = "true"
    strings:
        $a = {90 90 60 E8 00 00 00 00 5D 81 ED D1 27 40 00 B9 15 00 00 00 83 C1 04 83 C1 01 EB 05 EB FE 83 C7 56 EB 00 EB 00 83 E9 02 81 C1 78 43 27 65 EB 00 81 C1 10 25 94 00 81 E9 63 85 00 00 B9 96 0C 00 00 90 8D BD 4E 28 40 00 8B F7 AC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00598_EXECryptor_2_0_2_1__protected_IAT_____www_strongbit_com___Sign_By_haggar_
{
    meta:
        description = "[EXECryptor 2.0/2.1 (protected IAT) -> www.strongbit.com * Sign.By.haggar]"
        ep_only = "false"
    strings:
        $a = {A4 ?? ?? ?? 00 00 00 00 FF FF FF FF 3C ?? ?? ?? 94 ?? ?? ?? D8 ?? ?? ?? 00 00 00 00 FF FF FF FF B8 ?? ?? ?? D4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 60 ?? ?? ?? 70 ?? ?? ?? 84 ?? ?? ?? 00 00 00 00 75 73 65 72 33 32 2E 64 6C 6C 00 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41}
    condition:
        $a
}

rule PEiD_00599_EXECryptor_2_0_2_1__protected_IAT_____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.0/2.1 (protected IAT) -> www.strongbit.com]"
        ep_only = "true"
    strings:
        $a = {A4 ?? ?? ?? 00 00 00 00 FF FF FF FF 3C ?? ?? ?? 94 ?? ?? ?? D8 ?? ?? ?? 00 00 00 00 FF FF FF FF B8 ?? ?? ?? D4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75}
    condition:
        $a at pe.entry_point
}

rule PEiD_00600_EXECryptor_2_0_2_1____www_strongbit_com___Sign_By_haggar_
{
    meta:
        description = "[EXECryptor 2.0/2.1 -> www.strongbit.com * Sign.By.haggar]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 F4 56 57 53 BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F 85 03 00 00 00 8B 46 10 01 D0 03 45 F4 8B 18 8B 7E 10 01 D7 03 7D F4 09 DB 0F 84 ?? 00 00 00 F7 C3 00 00 00 80 0F 85 04 00 00 00 8D 5C 13 02 81 E3 FF FF FF ?? 53 FF 75 F8 FF 15 9C ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 07 83 45 F4 04 E9 A6 FF FF FF}
    condition:
        $a
}

rule PEiD_00601_EXECryptor_2_0_2_1____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.0/2.1 -> www.strongbit.com]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F4 56 57 53 BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00602_EXECryptor_2_1_17____Strongbit___SoftComplete_Development__h__
{
    meta:
        description = "[EXECryptor 2.1.17 -> Strongbit / SoftComplete Development (h)]"
        ep_only = "false"
    strings:
        $a = {BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F 85 03 00 00 00 8B 46 10 01}
    condition:
        $a
}

rule PEiD_00603_EXECryptor_2_1_17____Strongbit_SoftComplete_Development__h__
{
    meta:
        description = "[EXECryptor 2.1.17 -> Strongbit/SoftComplete Development (h)]"
        ep_only = "false"
    strings:
        $a = {BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F 85 03 00 00 00 8B 46 10 01 D0 03 45 F4 8B 18 8B 7E 10 01 D7 03 7D F4 09 DB 0F 84 ?? 00 00 00 F7 C3 00 00 00 80 0F 85 04 00 00 00 8D 5C 13 02 81 E3 FF FF FF 7F 53 FF 75 F8 FF 15 9C ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 07 83 45 F4 04 E9 A6 FF FF FF}
    condition:
        $a
}

rule PEiD_00604_EXECryptor_2_2_4____Strongbit_SoftComplete_Development__h1__
{
    meta:
        description = "[EXECryptor 2.2.4 -> Strongbit/SoftComplete Development (h1)]"
        ep_only = "true"
    strings:
        $a = {E8 F7 FE FF FF 05 ?? ?? 00 00 FF E0 E8 EB FE FF FF 05 ?? ?? 00 00 FF E0 E8 04 00 00 00 FF FF FF FF 5E C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00605_EXECryptor_2_2_4____Strongbit_SoftComplete_Development__h2__
{
    meta:
        description = "[EXECryptor 2.2.4 -> Strongbit/SoftComplete Development (h2)]"
        ep_only = "true"
    strings:
        $a = {E8 F7 FE FF FF 05 ?? ?? 00 00 FF E0 E8 EB FE FF FF 05 ?? ?? 00 00 FF E0 E8 ?? 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00606_EXECryptor_2_2_4____Strongbit_SoftComplete_Development_
{
    meta:
        description = "[EXECryptor 2.2.4 -> Strongbit/SoftComplete Development]"
        ep_only = "false"
    strings:
        $a = {6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73}
    condition:
        $a
}

rule PEiD_00607_EXECryptor_2_2_6__minimum_protection_____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.2.6 (minimum protection) -> www.strongbit.com]"
        ep_only = "false"
    strings:
        $a = {50 68 ?? ?? ?? ?? 58 81 E0 ?? ?? ?? ?? E9 ?? ?? ?? 00 87 0C 24 59 E8 ?? ?? ?? 00 89 45 F8 E9 ?? ?? ?? ?? 0F 83 ?? ?? ?? 00 E9 ?? ?? ?? ?? 87 14 24 5A 57 68 ?? ?? ?? ?? E9 ?? ?? ?? ?? 58 81 C0 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? 81 C8 ?? ?? ?? ?? 81 E0}
    condition:
        $a
}

rule PEiD_00608_EXECryptor_2_2_6__minimum_protection__
{
    meta:
        description = "[EXECryptor 2.2.6 (minimum protection)]"
        ep_only = "true"
    strings:
        $a = {50 68 ?? ?? ?? ?? 58 81 E0 ?? ?? ?? ?? E9 ?? ?? ?? 00 87 0C 24 59 E8 ?? ?? ?? 00 89 45 F8 E9 ?? ?? ?? ?? 0F 83 ?? ?? ?? 00 E9 ?? ?? ?? ?? 87 14 24 5A 57 68 ?? ?? ?? ?? E9 ?? ?? ?? ?? 58 81 C0 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? 81 C8 ?? ?? ?? ?? 81 E0 ?? ?? ?? ?? E9 ?? ?? ?? 00 C3 E9 ?? ?? ?? ?? C3 BF ?? ?? ?? ?? 81 CB ?? ?? ?? ?? BA ?? ?? ?? ?? 52 E9 ?? ?? ?? 00 E8 ?? ?? ?? 00 E9 ?? ?? ?? 00 E9 ?? ?? ?? ?? 87 34 24 5E 66 8B 00 66 25 ?? ?? E9 ?? ?? ?? ?? 8B CD 87 0C 24 8B EC 51 89 EC 5D 8B 05 ?? ?? ?? ?? 09 C0 E9 ?? ?? ?? ?? 59 81 C1 ?? ?? ?? ?? C1 C1 ?? 23 0D ?? ?? ?? ?? 81 F9 ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 E9 ?? ?? ?? 00 13 D0 0B F9 E9 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 8B 64 24 08 31 C0 64 8F 05 00 00 00 00 5A E9 ?? ?? ?? ?? 3C A4 0F 85 ?? ?? ?? 00 8B 45 FC 66 81 38 ?? ?? 0F 84 05 00 00 00 E9 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? E9 ?? ?? ?? ?? 87 3C 24 5F 31 DB 31 C9 31 D2 68 ?? ?? ?? ?? E9 ?? ?? ?? ?? 89 45 FC 33 C0 89 45 F4 83 7D FC 00 E9 ?? ?? ?? ?? 53 52 8B D1 87 14 24 81 C0 ?? ?? ?? ?? 0F 88 ?? ?? ?? ?? 3B CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00609_EXECryptor_2_2_6_DLL__minimum_protection_____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.2.6 DLL (minimum protection) -> www.strongbit.com]"
        ep_only = "false"
    strings:
        $a = {50 8B C6 87 04 24 68 ?? ?? ?? ?? 5E E9 ?? ?? ?? ?? 85 C8 E9 ?? ?? ?? ?? 81 C3 ?? ?? ?? ?? 0F 81 ?? ?? ?? 00 81 FA ?? ?? ?? ?? 33 D0 E9 ?? ?? ?? 00 0F 8D ?? ?? ?? 00 81 D5 ?? ?? ?? ?? F7 D1 0B 15 ?? ?? ?? ?? C1 C2 ?? 81 C2 ?? ?? ?? ?? 9D E9 ?? ?? ?? ?? C1}
    condition:
        $a
}

rule PEiD_00610_EXECryptor_2_2_6_DLL__minimum_protection__
{
    meta:
        description = "[EXECryptor 2.2.6 DLL (minimum protection)]"
        ep_only = "true"
    strings:
        $a = {50 8B C6 87 04 24 68 ?? ?? ?? ?? 5E E9 ?? ?? ?? ?? 85 C8 E9 ?? ?? ?? ?? 81 C3 ?? ?? ?? ?? 0F 81 ?? ?? ?? 00 81 FA ?? ?? ?? ?? 33 D0 E9 ?? ?? ?? 00 0F 8D ?? ?? ?? 00 81 D5 ?? ?? ?? ?? F7 D1 0B 15 ?? ?? ?? ?? C1 C2 ?? 81 C2 ?? ?? ?? ?? 9D E9 ?? ?? ?? ?? C1 E2 ?? C1 E8 ?? 81 EA ?? ?? ?? ?? 13 DA 81 E9 ?? ?? ?? ?? 87 04 24 8B C8 E9 ?? ?? ?? ?? 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC 89 45 F8 8B 45 08 E9 ?? ?? ?? ?? 8B 45 E0 C6 00 00 FF 45 E4 E9 ?? ?? ?? ?? FF 45 E4 E9 ?? ?? ?? 00 F7 D3 0F 81 ?? ?? ?? ?? E9 ?? ?? ?? ?? 87 34 24 5E 8B 45 F4 E8 ?? ?? ?? 00 8B 45 F4 8B E5 5D C3 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00611_EXECryptor_2_2_x____SoftComplete_Developement_
{
    meta:
        description = "[EXECryptor 2.2.x -> SoftComplete Developement]"
        ep_only = "false"
    strings:
        $a = {E8 F7 FE FF FF 05 ?? ?? 00 00 FF E0 E8 EB FE FF FF 05 ?? ?? 00 00 FF E0 E8 04 00 00 00 FF FF FF FF}
    condition:
        $a
}

rule PEiD_00612_EXECryptor_2_2_2_3__compressed_code_____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.2/2.3 (compressed code) -> www.strongbit.com]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 58 ?? ?? ?? ?? ?? 8B 1C 24 81 EB ?? ?? ?? ?? B8 ?? ?? ?? ?? 50 6A 04 68 00 10 00 00 50 6A 00 B8 C4 ?? ?? ?? 8B 04 18 FF D0 59 BA ?? ?? ?? ?? 01 DA 52 53 50 89 C7 89 D6 FC F3 A4 B9 ?? ?? ?? ?? 01 D9 FF D1 58 8B 1C 24 68 00 80 00 00 6A 00 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_00613_EXECryptor_2_2_2_3__compressed_code_____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.2/2.3 (compressed code) -> www.strongbit.com]"
        ep_only = "false"
    strings:
        $a = {E8 00 00 00 00 58 ?? ?? ?? ?? ?? 8B 1C 24 81 EB ?? ?? ?? ?? B8 ?? ?? ?? ?? 50 6A 04 68 00 10 00 00 50 6A 00 B8 C4 ?? ?? ?? 8B 04 18 FF D0 59 BA ?? ?? ?? ?? 01 DA 52 53 50 89 C7 89 D6 FC F3 A4 B9 ?? ?? ?? ?? 01 D9 FF D1 58 8B 1C 24 68 00 80 00 00 6A 00 50 B8 C8 ?? ?? ?? 8B 04 18 FF D0 59 58 5B 83 EB 05 C6 03 B8 43 89 03 83 C3 04 C6 03 C3 09 C9 74 46 89 C3 E8 A0 00 00 00 FC AD 83 F8 FF 74 38 53 89 CB 01 C3 01 0B 83 C3 04 AC 3C FE 73 07 25 FF 00 00 00 EB ED 81 C3 FE 00 00 00 09 C0 7A 09 66 AD 25 FF FF 00 00 EB DA AD 4E 25 FF FF FF 00 3D FF FF FF 00 75 CC ?? ?? ?? ?? ?? C3}
    condition:
        $a
}

rule PEiD_00614_EXECryptor_2_2_2_3__protected_IAT_____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.2/2.3 (protected IAT) -> www.strongbit.com]"
        ep_only = "true"
    strings:
        $a = {CC ?? ?? ?? 00 00 00 00 FF FF FF FF 3C ?? ?? ?? B4 ?? ?? ?? 08 ?? ?? ?? 00 00 00 00 FF FF FF FF E8 ?? ?? ?? 04 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75}
    condition:
        $a at pe.entry_point
}

rule PEiD_00615_EXECryptor_2_3_9__compressed_resources_____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.3.9 (compressed resources) -> www.strongbit.com]"
        ep_only = "false"
    strings:
        $a = {51 68 ?? ?? ?? ?? 59 81 F1 12 3C CB 98 E9 53 2C 00 00 F7 D7 E9 EB 60 00 00 83 45 F8 02 E9 E3 36 00 00 F6 45 F8 20 0F 84 1E 21 00 00 55 E9 80 62 00 00 87 0C 24 8B E9 ?? ?? ?? ?? 00 00 23 C1 81 E9 ?? ?? ?? ?? 57 E9 ED 00 00 00 0F 88 ?? ?? ?? ?? E9 2C 0D 00}
    condition:
        $a
}

rule PEiD_00616_EXECryptor_2_3_9__compressed_resources__
{
    meta:
        description = "[EXECryptor 2.3.9 (compressed resources)]"
        ep_only = "true"
    strings:
        $a = {51 68 ?? ?? ?? ?? 59 81 F1 12 3C CB 98 E9 53 2C 00 00 F7 D7 E9 EB 60 00 00 83 45 F8 02 E9 E3 36 00 00 F6 45 F8 20 0F 84 1E 21 00 00 55 E9 80 62 00 00 87 0C 24 8B E9 ?? ?? ?? ?? 00 00 23 C1 81 E9 ?? ?? ?? ?? 57 E9 ED 00 00 00 0F 88 ?? ?? ?? ?? E9 2C 0D 00 00 81 ED BB 43 CB 79 C1 E0 1C E9 9E 14 00 00 0B 15 ?? ?? ?? ?? 81 E2 2A 70 7F 49 81 C2 9D 83 12 3B E8 0C 50 00 00 E9 A0 16 00 00 59 5B C3 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 E8 41 42 00 00 E9 93 33 00 00 31 DB 89 D8 59 5B C3 A1 ?? ?? ?? ?? 8A 00 2C 99 E9 82 30 00 00 0F 8A ?? ?? ?? ?? B8 01 00 00 00 31 D2 0F A2 25 FF 0F 00 00 E9 72 21 00 00 0F 86 57 0B 00 00 E9 ?? ?? ?? ?? C1 C0 03 E8 F0 36 00 00 E9 41 0A 00 00 81 F7 B3 6E 85 EA 81 C7 ?? ?? ?? ?? 87 3C 24 E9 74 52 00 00 0F 8E ?? ?? ?? ?? E8 5E 37 00 00 68 B1 74 96 13 5A E9 A1 04 00 00 81 D1 49 C0 12 27 E9 50 4E 00 00 C1 C8 1B 1B C3 81 E1 96 36 E5}
    condition:
        $a at pe.entry_point
}

rule PEiD_00617_EXECryptor_2_3_9__minimum_protection_____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.3.9 (minimum protection) -> www.strongbit.com]"
        ep_only = "false"
    strings:
        $a = {68 ?? ?? ?? ?? E9 ?? ?? ?? FF 50 C1 C8 18 89 05 ?? ?? ?? ?? C3 C1 C0 18 51 E9 ?? ?? ?? FF 84 C0 0F 84 6A F9 FF FF E9 ?? ?? ?? FF C3 E9 ?? ?? ?? FF E8 CF E9 FF FF B8 01 00 00 00 E9 ?? ?? ?? FF 2B D0 68 A0 36 80 D4 59 81 C9 64 98 FF 99 E9 ?? ?? ?? FF 84 C0}
    condition:
        $a
}

rule PEiD_00618_EXECryptor_2_3_9__minimum_protection__
{
    meta:
        description = "[EXECryptor 2.3.9 (minimum protection)]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? E9 ?? ?? ?? FF 50 C1 C8 18 89 05 ?? ?? ?? ?? C3 C1 C0 18 51 E9 ?? ?? ?? FF 84 C0 0F 84 6A F9 FF FF E9 ?? ?? ?? FF C3 E9 ?? ?? ?? FF E8 CF E9 FF FF B8 01 00 00 00 E9 ?? ?? ?? FF 2B D0 68 A0 36 80 D4 59 81 C9 64 98 FF 99 E9 ?? ?? ?? FF 84 C0 0F 84 8E EC FF FF E9 ?? ?? ?? FF C3 87 3C 24 5F 8B 00 03 45 FC 83 C0 18 E9 ?? ?? ?? FF 87 0C 24 59 B8 01 00 00 00 D3 E0 23 D0 E9 02 18 00 00 0F 8D DB 00 00 00 C1 E8 14 E9 CA 00 00 00 9D 87 0C 24 59 87 1C 24 68 AE 73 B9 96 E9 C5 10 00 00 0F 8A ?? ?? ?? ?? E9 ?? ?? ?? FF 81 FD F5 FF 8F 07 E9 4F 10 00 00 C3 E9 5E 12 00 00 87 3C 24 E9 ?? ?? ?? FF E8 ?? ?? ?? FF 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 55 EC B8 ?? ?? ?? ?? E9 ?? ?? ?? FF E8 A7 1A 00 00 E8 2A CB FF FF E9 ?? ?? ?? FF C3 E9 ?? ?? ?? FF 59 89 45 E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00619_EXECryptor_2_3_9_DLL__compressed_resources_____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.3.9 DLL (compressed resources) -> www.strongbit.com]"
        ep_only = "false"
    strings:
        $a = {50 68 ?? ?? ?? ?? 58 C1 C0 0F E9 ?? ?? ?? 00 87 04 24 58 89 45 FC E9 ?? ?? ?? FF FF 05 ?? ?? ?? ?? E9 ?? ?? ?? 00 C1 C3 18 E9 ?? ?? ?? ?? 8B 55 08 09 42 F8 E9 ?? ?? ?? FF 83 7D F0 01 0F 85 ?? ?? ?? ?? E9 ?? ?? ?? 00 87 34 24 5E 8B 45 FC 33 D2 56 8B F2 E9}
    condition:
        $a
}

rule PEiD_00620_EXECryptor_2_3_9_DLL__compressed_resources__
{
    meta:
        description = "[EXECryptor 2.3.9 DLL (compressed resources)]"
        ep_only = "true"
    strings:
        $a = {50 68 ?? ?? ?? ?? 58 C1 C0 0F E9 ?? ?? ?? 00 87 04 24 58 89 45 FC E9 ?? ?? ?? FF FF 05 ?? ?? ?? ?? E9 ?? ?? ?? 00 C1 C3 18 E9 ?? ?? ?? ?? 8B 55 08 09 42 F8 E9 ?? ?? ?? FF 83 7D F0 01 0F 85 ?? ?? ?? ?? E9 ?? ?? ?? 00 87 34 24 5E 8B 45 FC 33 D2 56 8B F2 E9 ?? ?? ?? 00 BA ?? ?? ?? ?? E8 ?? ?? ?? 00 A3 ?? ?? ?? ?? C3 E9 ?? ?? ?? 00 C3 83 C4 04 C3 E9 ?? ?? ?? FF 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 E8 ?? ?? ?? 00 E9 ?? ?? ?? FF C1 C2 03 81 CA ?? ?? ?? ?? 81 C2 ?? ?? ?? ?? 03 C2 5A E9 ?? ?? ?? FF 81 E7 ?? ?? ?? ?? 81 EF ?? ?? ?? ?? 81 C7 ?? ?? ?? ?? 89 07 E9 ?? ?? ?? ?? 0F 89 ?? ?? ?? ?? 87 14 24 5A 50 C1 C8 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_00621_EXECryptor_2_3_9_DLL__minimum_protection_____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.3.9 DLL (minimum protection) -> www.strongbit.com]"
        ep_only = "false"
    strings:
        $a = {51 68 ?? ?? ?? ?? 87 2C 24 8B CD 5D 81 E1 ?? ?? ?? ?? E9 ?? ?? ?? 00 89 45 F8 51 68 ?? ?? ?? ?? 59 81 F1 ?? ?? ?? ?? 0B 0D ?? ?? ?? ?? 81 E9 ?? ?? ?? ?? E9 ?? ?? ?? 00 81 C2 ?? ?? ?? ?? E8 ?? ?? ?? 00 87 0C 24 59 51 64 8B 05 30 00 00 00 8B 40 0C 8B 40 0C}
    condition:
        $a
}

rule PEiD_00622_EXECryptor_2_3_9_DLL__minimum_protection__
{
    meta:
        description = "[EXECryptor 2.3.9 DLL (minimum protection)]"
        ep_only = "true"
    strings:
        $a = {51 68 ?? ?? ?? ?? 87 2C 24 8B CD 5D 81 E1 ?? ?? ?? ?? E9 ?? ?? ?? 00 89 45 F8 51 68 ?? ?? ?? ?? 59 81 F1 ?? ?? ?? ?? 0B 0D ?? ?? ?? ?? 81 E9 ?? ?? ?? ?? E9 ?? ?? ?? 00 81 C2 ?? ?? ?? ?? E8 ?? ?? ?? 00 87 0C 24 59 51 64 8B 05 30 00 00 00 8B 40 0C 8B 40 0C E9 ?? ?? ?? 00 F7 D6 2B D5 E9 ?? ?? ?? 00 87 3C 24 8B CF 5F 87 14 24 1B CA E9 ?? ?? ?? 00 83 C4 08 68 ?? ?? ?? ?? E9 ?? ?? ?? 00 C3 E9 ?? ?? ?? 00 E9 ?? ?? ?? 00 50 8B C5 87 04 24 8B EC 51 0F 88 ?? ?? ?? 00 FF 05 ?? ?? ?? ?? E9 ?? ?? ?? 00 87 0C 24 59 99 03 04 24 E9 ?? ?? ?? 00 C3 81 D5 ?? ?? ?? ?? 9C E9 ?? ?? ?? 00 81 FA ?? ?? ?? ?? E9 ?? ?? ?? 00 C1 C3 15 81 CB ?? ?? ?? ?? 81 F3 ?? ?? ?? ?? 81 C3 ?? ?? ?? ?? 87}
    condition:
        $a at pe.entry_point
}

rule PEiD_00623_EXECryptor_2_x____SoftComplete_Developement_
{
    meta:
        description = "[EXECryptor 2.x -> SoftComplete Developement]"
        ep_only = "false"
    strings:
        $a = {A4 ?? ?? 00 00 00 00 00 FF FF FF FF 3C ?? ?? 00 94 ?? ?? 00 D8 ?? ?? 00 00 00 00 00 FF FF FF FF}
    condition:
        $a
}

rule PEiD_00624_EXECryptor_2_xx__compressed_resources_____www_strongbit_com___Sign_By_haggar_
{
    meta:
        description = "[EXECryptor 2.xx (compressed resources) -> www.strongbit.com * Sign.By.haggar]"
        ep_only = "false"
    strings:
        $a = {56 57 53 31 DB 89 C6 89 D7 0F B6 06 89 C2 83 E0 1F C1 EA 05 74 2D 4A 74 15 8D 5C 13 02 46 C1 E0 08 89 FA 0F B6 0E 46 29 CA 4A 29 C2 EB 32 C1 E3 05 8D 5C 03 04 46 89 FA 0F B7 0E 29 CA 4A 83 C6 02 EB 1D C1 E3 04 46 89 C1 83 E1 0F 01 CB C1 E8 05 73 07 43 89 F2 01 DE EB 06 85 DB 74 0E EB A9 56 89 D6 89 D9 F3 A4 31 DB 5E EB 9D 89 F0 5B 5F 5E C3}
    condition:
        $a
}

rule PEiD_00625_EXECryptor_2_xx__compressed_resources_____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.xx (compressed resources) -> www.strongbit.com]"
        ep_only = "true"
    strings:
        $a = {56 57 53 31 DB 89 C6 89 D7 0F B6 06 89 C2 83 E0 1F C1 EA 05 74 2D 4A 74 15 8D 5C 13 02 46 C1 E0 08 89 FA 0F B6 0E 46 29 CA 4A 29 C2 EB 32 C1 E3 05 8D 5C 03 04 46 89 FA 0F B7 0E 29 CA 4A 83 C6 02 EB 1D C1 E3 04 46 89 C1 83 E1 0F 01 CB C1 E8 05 73 07 43 89}
    condition:
        $a at pe.entry_point
}

rule PEiD_00626_EXECryptor_2_xx__max__compressed_resources_____www_strongbit_com___Sign_By_haggar_
{
    meta:
        description = "[EXECryptor 2.xx (max. compressed resources) -> www.strongbit.com * Sign.By.haggar]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 EC FC 53 57 56 89 45 FC 89 55 F8 89 C6 89 D7 66 81 3E 4A 43 0F 85 23 01 00 00 83 C6 0A C7 45 F4 08 00 00 00 31 DB BA 00 00 00 80 43 31 C0 E8 11 01 00 00 73 0E 8B 4D F0 E8 1F 01 00 00 02 45 EF AA EB E9 E8 FC 00 00 00 0F 82 97 00 00 00 E8 F1 00 00 00 73 5B B9 04 00 00 00 E8 FD 00 00 00 48 74 DE 0F 89 C7 00 00 00 E8 D7 00 00 00 73 1B 55 BD 00 01 00 00 E8 D7 00 00 00 88 07 47 4D 75 F5 E8 BF 00 00 00 72 E9 5D EB A2 B9 01 00 00 00 E8 C8 00 00 00 83 C0 07 89 45 F0 C6 45 EF 00 83 F8 08 74 89 E8 A9 00 00 00 88 45 EF E9 7C FF FF FF B9 07 00 00 00 E8 A2 00 00 00 50}
    condition:
        $a
}

rule PEiD_00627_EXECryptor_2_xx__max__compressed_resources_____www_strongbit_com_
{
    meta:
        description = "[EXECryptor 2.xx (max. compressed resources) -> www.strongbit.com]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 EC FC 53 57 56 89 45 FC 89 55 F8 89 C6 89 D7 66 81 3E 4A 43 0F 85 23 01 00 00 83 C6 0A C7 45 F4 08 00 00 00 31 DB BA 00 00 00 80 43 31 C0 E8 11 01 00 00 73 0E 8B 4D F0 E8 1F 01 00 00 02 45 EF AA EB E9 E8 FC 00 00 00 0F 82 97 00 00 00 E8 F1}
    condition:
        $a at pe.entry_point
}

rule PEiD_00628_EXECryptor_v1_3_0_45_
{
    meta:
        description = "[EXECryptor v1.3.0.45]"
        ep_only = "true"
    strings:
        $a = {E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 ?? ?? ?? ?? ?? ?? ?? 31 C0 89 41 14 89 41 18 80 A1}
    condition:
        $a at pe.entry_point
}

rule PEiD_00629_EXECryptor_v1_3_0_45_
{
    meta:
        description = "[EXECryptor v1.3.0.45]"
        ep_only = "true"
    strings:
        $a = {E8 24 ?? ?? ?? 8B 4C 24 0C C7 01 17 ?? 01 ?? C7 81 ?? ?? ?? ?? ?? ?? ?? 31 C0 89 41 14 89 41 18 80 A1}
    condition:
        $a at pe.entry_point
}

rule PEiD_00630_EXECryptor_v1_4_0_1_
{
    meta:
        description = "[EXECryptor v1.4.0.1]"
        ep_only = "true"
    strings:
        $a = {E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 B8 00 00 00 00 ?? ?? 00 31 C0 89 41 14 89 41 18 80}
    condition:
        $a at pe.entry_point
}

rule PEiD_00631_EXECryptor_v1_5_1_x_
{
    meta:
        description = "[EXECryptor v1.5.1.x]"
        ep_only = "true"
    strings:
        $a = {E8 24 ?? ?? ?? 8B 4C 24 0C C7 01 17 ?? 01 ?? C7 81 B8 ?? ?? ?? ?? ?? ?? ?? 31 C0 89 41 14 89 41 18 80 A1 C1 ?? ?? ?? FE C3 31 C0 64 FF 30 64 89 20 CC C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00632_EXECryptor_v1_5_3_
{
    meta:
        description = "[EXECryptor v1.5.3]"
        ep_only = "false"
    strings:
        $a = {E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 B8 00 00 00 00 ?? ?? 00 31 C0 89 41 14 89 41 18 80 A1 C1 00 00 00 FE C3 31 C0 64 FF 30 64 89 20 CC C3}
    condition:
        $a
}

rule PEiD_00633_EXECryptor_V2_1X____softcomplete_com_
{
    meta:
        description = "[EXECryptor V2.1X -> softcomplete.com]"
        ep_only = "false"
    strings:
        $a = {83 C6 14 8B 55 FC E9 ?? FF FF FF}
    condition:
        $a
}

rule PEiD_00634_EXECryptor_V2_1X____SoftComplete_com_
{
    meta:
        description = "[EXECryptor V2.1X -> SoftComplete.com]"
        ep_only = "true"
    strings:
        $a = {E9 ?? ?? ?? ?? 66 9C 60 50 8D 88 ?? ?? ?? ?? 8D 90 04 16 ?? ?? 8B DC 8B E1}
    condition:
        $a at pe.entry_point
}

rule PEiD_00635_EXECryptor_V2_2X____softcomplete_com_
{
    meta:
        description = "[EXECryptor V2.2X -> softcomplete.com]"
        ep_only = "false"
    strings:
        $a = {FF E0 E8 04 00 00 00 FF FF FF FF 5E C3 00}
    condition:
        $a
}

rule PEiD_00636_EXECryptor_vx_x_x_x_
{
    meta:
        description = "[EXECryptor vx.x.x.x]"
        ep_only = "true"
    strings:
        $a = {E8 24 ?? ?? ?? 8B 4C 24 0C C7 01 17 ?? 01 ?? C7 81 B8 ?? ?? ?? ?? ?? ?? ?? 31 C0 89 41}
    condition:
        $a at pe.entry_point
}

rule PEiD_00637_ExeJoiner_1_0____Yoda_f2f_
{
    meta:
        description = "[ExeJoiner 1.0 -> Yoda f2f]"
        ep_only = "true"
    strings:
        $a = {68 00 10 40 00 68 04 01 00 00 E8 39 03 00 00 05 00 10 40 00 C6 00 5C 68 04 01 00 00 68 04 11 40 00 6A 00 E8 1A 03 00 00 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 68 04 11 40 00 E8 EC 02 00 00 83 F8 FF 0F 84 83 02 00 00 A3 08 12 40 00 6A 00 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_00638_ExeJoiner_1_0____Yoda_f2f_
{
    meta:
        description = "[ExeJoiner 1.0 -> Yoda f2f]"
        ep_only = "true"
    strings:
        $a = {68 00 10 40 00 68 04 01 00 00 E8 39 03 00 00 05 00 10 40 00 C6 00 5C 68 04 01 00 00 68 04 11 40 00 6A 00 E8 1A 03 00 00 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 68 04 11 40 00 E8 EC 02 00 00 83 F8 FF 0F 84 83 02 00 00 A3 08 12 40 00 6A 00 50 E8 E2 02 00 00 83 F8 FF 0F 84 6D 02 00 00 A3 0C 12 40 00 8B D8 83 EB 04 6A 00 6A 00 53 FF 35 08 12 40 00 E8 E3 02 00 00 6A 00 68 3C 12 40 00 6A 04 68 1E 12 40 00 FF 35 08 12 40 00 E8 C4 02 00 00 83 EB 04 6A 00 6A 00 53 FF 35 08 12 40 00 E8 B7 02 00 00 6A 00 68 3C 12 40 00 6A 04 68 1A 12 40 00 FF 35 08 12 40 00 E8 98 02 00 00 83 EB 04 6A 00 6A 00 53 FF 35 08 12 40 00 E8 8B 02 00 00 6A 00 68 3C 12 40 00 6A 04 68 34 12 40 00 FF 35 08 12 40 00 E8 6C 02 00 00 83 EB 04 6A 00 6A 00 53 FF 35 08 12 40 00 E8 5F 02 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00639_ExeJoiner_1_0____Yoda_
{
    meta:
        description = "[ExeJoiner 1.0 -> Yoda]"
        ep_only = "true"
    strings:
        $a = {68 00 10 40 00 68 04 01 00 00 E8 39 03 00 00 05 00 10 40 00 C6 00 5C 68 04 01 00 00 68 04 11 40 00 6A 00 E8 1A 03 00 00 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 68 04 11 40 00 E8 EC 02 00 00 83 F8 FF 0F 84 83 02 00 00 A3 08 12 40 00 6A 00 50 E8 E2 02 00 00 83 F8 FF 0F 84 6D 02 00 00 A3 0C 12 40 00 8B D8 83 EB 04 6A 00 6A 00 53 FF 35 08 12 40 00 E8 E3 02 00 00 6A 00 68 3C 12 40 00 6A 04 68 1E 12 40 00 FF 35 08 12 40 00 E8 C4 02 00 00 83 EB 04 6A 00 6A 00 53 FF 35 08 12 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00640_ExeJoiner_V1_0____Yoda_f2f_
{
    meta:
        description = "[ExeJoiner V1.0 -> Yoda f2f]"
        ep_only = "true"
    strings:
        $a = {68 00 10 40 00 68 04 01 00 00 E8 39 03 00 00 05 00 10 40 00 C6 00 5C 68 04 01 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00641_EXEJoiner_v1_0_
{
    meta:
        description = "[EXEJoiner v1.0]"
        ep_only = "true"
    strings:
        $a = {68 00 10 40 00 68 04 01 00 00 E8 39 03 00 00 05 00 10 40 C6 00 5C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00642_EXELOCK_666_1_5_
{
    meta:
        description = "[EXELOCK 666 1.5]"
        ep_only = "true"
    strings:
        $a = {BA ?? ?? BF ?? ?? EB ?? EA ?? ?? ?? ?? 79 ?? 7F ?? 7E ?? 1C ?? 48 78 ?? E3 ?? 45 14 ?? 5A E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00643_ExeLock_v1_00_
{
    meta:
        description = "[ExeLock v1.00]"
        ep_only = "true"
    strings:
        $a = {06 8C C8 8E C0 BE ?? ?? 26 ?? ?? 34 ?? 26 ?? ?? 46 81 ?? ?? ?? 75 ?? 40 B3 ?? B3 ?? F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00644_EXEPACK__LINK__v3_60__v3_64__v3_65_or_5_01_21_
{
    meta:
        description = "[EXEPACK (LINK) v3.60, v3.64, v3.65 or 5.01.21]"
        ep_only = "true"
    strings:
        $a = {8C C0 05 ?? ?? 0E 1F A3 ?? ?? 03 ?? ?? ?? 8E C0 8B ?? ?? ?? 8B ?? 4F 8B F7 FD F3 A4 50 B8 ?? ?? 50 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00645_EXEPACK_v4_05__v4_06_
{
    meta:
        description = "[EXEPACK v4.05, v4.06]"
        ep_only = "true"
    strings:
        $a = {8C C0 05 ?? ?? 0E 1F A3 ?? ?? 03 06 ?? ?? 8E C0 8B 0E ?? ?? 8B F9 4F 8B F7 FD F3 A4}
    condition:
        $a at pe.entry_point
}

rule PEiD_00646_EXERefactor_V0_1____random_
{
    meta:
        description = "[EXERefactor V0.1 -> random]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 90 0B 00 00 53 56 57 E9 58 8C 01 00 55 53 43 41 54 49 4F 4E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00647_ExeSafeguard_1_0____simonzh__h__
{
    meta:
        description = "[ExeSafeguard 1.0 -> simonzh (h)]"
        ep_only = "false"
    strings:
        $a = {C0 5D EB 4E EB 47 DF 69 4E 58 DF 59 74 F3 EB 01 DF 75 EE 9A 59 9C 81 C1 E2 FF FF FF EB 01 DF 9D FF E1 E8 51 E8 EB FF FF FF DF 22 3F 9A C0 81 ED 19 18 40 00 EB 48 EB 47 DF 69 4E 58 DF 59 79 EE EB 01 DF 78 E9 DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE}
    condition:
        $a
}

rule PEiD_00648_ExeSafeguard_v1_0____simonzh__h__
{
    meta:
        description = "[ExeSafeguard v1.0 -> simonzh (h)]"
        ep_only = "false"
    strings:
        $a = {C0 5D EB 4E EB 47 DF 69 4E 58 DF 59 74 F3 EB 01 DF 75 EE 9A 59 9C 81 C1 E2 FF FF FF EB 01 DF 9D FF E1 E8 51 E8 EB FF FF FF DF 22 3F 9A C0 81 ED 19 18 40 00 EB 48 EB 47 DF 69 4E 58 DF 59 79 EE EB 01 DF 78 E9 DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF DF BA A3 22 3F 9A C0 60 EB 4D EB 47 DF 69 4E 58 DF 59 79 F3 EB 01 DF 78 EE DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF E8 BA A3 22 3F 9A C0 8D B5 EE 19 40 00 EB 47 EB 47 DF 69 4E 58 DF 59 7A EE EB 01 DF 7B E9 DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF DF 22 3F 9A C0 8B FE EB 4C EB 47 DF 69 4E 58 DF 59 74 F2 EB 01 DF 75 ED 0F 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF E8 BA A3 22 3F 9A C0 B9 2B CB 00 00 EB 4B EB 47 DF 69 4E 58 DF 59 78 EF}
    condition:
        $a
}

rule PEiD_00649_ExeShield_3_6____www_exeshield_com_
{
    meta:
        description = "[ExeShield 3.6 -> www.exeshield.com]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 CE 1E 42 AF F8 D6 CC E9 FB C8 4F 1B 22 7C B4 C8 0D BD 71 A9 C8 1F 5F B1 29 8F 11 73 8F 00 D1 88 87 A9 3F 4D 00 6C 3C BF C0 80 F7 AD 35 23 EB 84 82 6F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00650_ExeShield_Cryptor_1_3RC____Tom_Commander_
{
    meta:
        description = "[ExeShield Cryptor 1.3RC -> Tom Commander]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 8C 21 40 00 B9 51 2D 40 00 81 E9 E6 21 40 00 8B D5 81 C2 E6 21 40 00 8D 3A 8B F7 33 C0 EB 04 90 EB 01 C2 AC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00651_ExeShield_Protector_V3_6____www_exeshield_com_
{
    meta:
        description = "[ExeShield Protector V3.6 -> www.exeshield.com]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 CE 1E 42 AF F8 D6 CC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00652_ExeShield_v3_7____ExeShield_Team__h__
{
    meta:
        description = "[ExeShield v3.7 -> ExeShield Team (h)]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 CE 1E 42 AF F8 D6 CC E9 FB C8 4F 1B 22 7C B4 C8 0D BD 71 A9 C8 1F 5F B1 29 8F 11 73 8F 00 D1 88 87 A9 3F 4D 00 6C 3C BF C0 80 F7 AD 35 23 EB 84 82 6F 8C B9 0A FC EC E4 82 97 AE 0F 18 D2 47 1B 65 EA 46 A5 FD 3E 9D 75 2A 62 80 60 F9 B0 0D E1 AC 12 0E 9D 24 D5 43 CE 9A D6 18 BF 22 DA 1F 72 76 B0 98 5B C2 64 BC AE D8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00653_ExeSmasher_vx_x_
{
    meta:
        description = "[ExeSmasher vx.x]"
        ep_only = "true"
    strings:
        $a = {9C FE 03 ?? 60 BE ?? ?? 41 ?? 8D BE ?? 10 FF FF 57 83 CD FF EB 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_00654_ExeSplitter_1_2____Bill_Prisoner___TPOC_
{
    meta:
        description = "[ExeSplitter 1.2 -> Bill Prisoner / TPOC]"
        ep_only = "false"
    strings:
        $a = {E9 95 02 00 00 64 A1 00 00 00 00 83 38 FF 74 04 8B 00 EB F7 8B 40 04 C3 55 8B EC B8 00 00 00 00 8B 75 08 81 E6 00 00 FF FF B9 06 00 00 00 56 56 E8 B0 00 00 00 5E 83 F8 01 75 06 8B C6 C9 C2 04 00 81 EE 00 00 01 00 E2 E5 C9 C2 04 00 55 8B EC 8B 75 0C 8B DE 03 76 3C 8D 76 18 8D 76 60 8B 36 03 F3 56 8B 76 20 03 F3 33 D2 8B C6 8B 36 03 F3 8B 7D 08 B9 0E 00 00 00 FC F3 A6 0B C9 75 02 EB 08}
    condition:
        $a
}

rule PEiD_00655_ExeSplitter_1_3__Split_Method_____Bill_Prisoner___TPOC_
{
    meta:
        description = "[ExeSplitter 1.3 (Split Method) -> Bill Prisoner / TPOC]"
        ep_only = "false"
    strings:
        $a = {E8 00 00 00 00 5D 81 ED 08 12 40 00 E8 66 FE FF FF 55 50 8D 9D 81 11 40 00 53 8D 9D 21 11 40 00 53 6A 08 E8 76 FF FF FF 6A 40 68 00 30 00 00 68 00 01 00 00 6A 00 FF 95 89 11 40 00 89 85 61 10 40 00 50 68 00 01 00 00 FF 95 85 11 40 00 8D 85 65 10 40 00 50 FF B5 61 10 40 00 FF 95 8D 11 40 00 6A 00 68 80 00 00 00 6A 02 6A 00 ?? ?? ?? ?? 01 1F 00 FF B5 61 10 40 00 FF 95 91 11 40 00 89 85 72 10 40 00 6A 00 8D ?? ?? ?? ?? 00 50 FF B5 09 10 40 00 8D 85 F5 12 40 00 50 FF B5 72 10 40 00 FF 95 95 11 40 00 FF B5 72 10 40 00 FF 95 99 11 40 00 8D 85 0D 10 40 00 50 8D 85 1D 10 40 00 50 B9 07 00 00 00 6A 00 E2 FC}
    condition:
        $a
}

rule PEiD_00656_ExeSplitter_1_3__Split_Method_____Bill_Prisoner___TPOC_
{
    meta:
        description = "[ExeSplitter 1.3 (Split Method) -> Bill Prisoner / TPOC]"
        ep_only = "true"
    strings:
        $a = {E9 FE 01 00 00 ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 73 76 63 45 72 30 31 31 2E 74 6D 70 00 00 00 00 00 00 00 00 00 64 A1 30 00 00 00 8B 40 0C 8B 40 0C 8B 00 85 C0 0F 84 5F 02 00 00 8B 48 30 80 39 6B 74 07 80 39 4B 74 02 EB E7 80 79 0C 33 74 02 EB DF 8B 40 18 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00657_ExeSplitter_1_3__Split_Crypt_Method_____Bill_Prisoner___TPOC_
{
    meta:
        description = "[ExeSplitter 1.3 (Split+Crypt Method) -> Bill Prisoner / TPOC]"
        ep_only = "false"
    strings:
        $a = {15 10 05 23 14 56 57 57 48 12 0B 16 66 66 66 66 66 66 66 66 66 02 C7 56 66 66 66 ED 26 6A ED 26 6A ED 66 E3 A6 69 E2 39 64 66 66 ED 2E 56 E6 5F 0D 12 61 E6 5F 2D 12 64 8D 81 E6 1F 6A 55 12 64 8D B9 ED 26 7E A5 33 ED 8A 8D 69 21 03 12 36 14 09 05 27 02 02 14 03 15 15 27 ED 2B 6A ED 13 6E ED B8 65 10 5A EB 10 7E EB 10 06 ED 50 65 95 30 ED 10 46 65 95 55 B4 ED A0 ED 50 65 95 37 ED 2B 6A EB DF AB 76 26 66 3F DF 68 66 66 66 9A 95 C0 6D AF 13 64}
    condition:
        $a
}

rule PEiD_00658_ExeSplitter_1_3__Split_Crypt_Method_____Bill_Prisoner___TPOC_
{
    meta:
        description = "[ExeSplitter 1.3 (Split+Crypt Method) -> Bill Prisoner / TPOC]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 5D 81 ED 05 10 40 00 B9 ?? ?? ?? ?? 8D 85 1D 10 40 00 80 30 66 40 E2 FA 8F 98 67 66 66 ?? ?? ?? ?? ?? ?? ?? 66}
    condition:
        $a at pe.entry_point
}

rule PEiD_00659_ExeStealth____WebToolMaster_
{
    meta:
        description = "[ExeStealth -> WebToolMaster]"
        ep_only = "false"
    strings:
        $a = {EB 58 53 68 61 72 65 77 61 72 65 2D 56 65 72 73 69 6F 6E 20 45 78 65 53 74 65 61 6C 74 68 2C 20 63 6F 6E 74 61 63 74 20 73 75 70 70 6F 72 74 40 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F}
    condition:
        $a
}

rule PEiD_00660_EXEStealth_2_75____WebtoolMaster_
{
    meta:
        description = "[EXEStealth 2.75 -> WebtoolMaster]"
        ep_only = "true"
    strings:
        $a = {90 60 90 E8 00 00 00 00 5D 81 ED D1 27 40 00 B9 15 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00661_EXEStealth_2_76_Unregistered____WebtoolMaster_
{
    meta:
        description = "[EXEStealth 2.76 Unregistered -> WebtoolMaster]"
        ep_only = "false"
    strings:
        $a = {EB ?? 45 78 65 53 74 65 61 6C 74 68 20 56 32 20 53 68 61 72 65 77 61 72 65 20}
    condition:
        $a
}

rule PEiD_00662_ExeTools_COM2EXE_
{
    meta:
        description = "[ExeTools COM2EXE]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? 5D 83 ED ?? 8C DA 2E 89 96 ?? ?? 83 C2 ?? 8E DA 8E C2 2E 01 96 ?? ?? 60}
    condition:
        $a at pe.entry_point
}

rule PEiD_00663_ExeTools_v2_1_Encruptor_by_DISMEMBER_
{
    meta:
        description = "[ExeTools v2.1 Encruptor by DISMEMBER]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? 5D 83 ?? ?? 1E 8C DA 83 ?? ?? 8E DA 8E C2 BB ?? ?? BA ?? ?? 85 D2 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_00664_EXE______________Liuli_
{
    meta:
        description = "[EXEļϲ -> Liuli]"
        ep_only = "false"
    strings:
        $a = {E8 53 03 00 00 8B F0 56 56 E8 98 03 00 00 8B C8}
    condition:
        $a
}

rule PEiD_00665_eXPressor_1_0_beta____CGSoftLabs_
{
    meta:
        description = "[eXPressor 1.0 beta -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {E9 35 14 00 00 E9 31 13 00 00 E9 98 12 00 00 E9 EF 0C 00 00 E9 42 13 00 00 E9 E9 02 00 00 E9 EF 0B 00 00 E9 1B 0D 00 00 CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00666_eXPressor_1_0_beta____CGSoftLabs_
{
    meta:
        description = "[eXPressor 1.0 beta -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {E9 35 14 00 00 E9 31 13 00 00 E9 98 12 00 00 E9 EF 0C 00 00 E9 42 13 00 00 E9 E9 02 00 00 E9 EF 0B 00 00 E9 1B 0D 00 00 CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC CC 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 2A 70 77 20 3D 20 30 78 25 30 34 78 20 20 2A 70 64 77 20 3D 20 30 78 25 30 38 78 00 00 00 00 00 00 00 00 00 42 61 64 20 70 6F 69 6E 74 65 72 3A 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 2A 70 64 77 20 3D 20 30 78 25 30 38 78 00 00 00 45 72 72 6F 72 3A 00 00 54 68 65 20 25 68 73 20 66 69 6C 65 20 69 73 20 0A 6C 69 6E 6B 65 64 20 74 6F 20 6D 69 73 73 69 6E 67 20 65 78 70}
    condition:
        $a at pe.entry_point
}

rule PEiD_00667_eXPressor_1_1____CGSoftLabs_
{
    meta:
        description = "[eXPressor 1.1 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {E9 ?? ?? 00 00 E9 ?? ?? 00 00 E9 ?? 12 00 00 E9 ?? 0C 00 00 E9 ?? ?? 00 00 E9 ?? ?? 00 00 E9 ?? ?? 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00668_eXPressor_1_2____CGSoftLabs__h__
{
    meta:
        description = "[eXPressor 1.2 -> CGSoftLabs (h)]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 81 EC D4 01 00 00 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 32 2E 2E B8 ?? ?? ?? ?? 2B 05 84 ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 16 A1 ?? ?? ?? ?? 03 05 80 ?? ?? ?? 89 85 54 FE FF FF E9 ?? 07 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 68 04}
    condition:
        $a
}

rule PEiD_00669_eXPressor_1_2____CGSoftLabs_
{
    meta:
        description = "[eXPressor 1.2 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC D4 01 00 00 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 32 2E 2E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00670_eXPressor_1_2_0_Beta_PE_Packer_
{
    meta:
        description = "[eXPressor 1.2.0 Beta PE Packer]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 EB ?? 45 78 50 72 2D 76 2E 31 2E 32 2E 2E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00671_eXPressor_1_2_0b_
{
    meta:
        description = "[eXPressor 1.2.0b]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 81 EC D4 01 00 00 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 32 2E 2E B8 ?? ?? ?? 00 2B 05 84 ?? ?? 00 A3 ?? ?? ?? 00 83 3D ?? ?? ?? 00 00 74 16 A1 ?? ?? ?? 00 03 05 80 ?? ?? 00 89 85 54 FE FF FF E9 ?? 07 00 00 C7 05 ?? ?? ?? 00 01 00 00 00 68 04}
    condition:
        $a
}

rule PEiD_00672_eXPressor_1_3____CGSoftLabs_
{
    meta:
        description = "[eXPressor 1.3 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC ?? 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 33 2E 2E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00673_eXPressor_1_4_5_1____CGSoftLabs__h__
{
    meta:
        description = "[eXPressor 1.4.5.1 -> CGSoftLabs (h)]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 EC 58 53 56 57 83 65 DC 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 34 2E 00 A1 00 ?? ?? ?? 05 00 ?? ?? ?? A3 08 ?? ?? ?? A1 08 ?? ?? ?? B9 81 ?? ?? ?? 2B 48 18 89 0D 0C ?? ?? ?? 83 3D 10 ?? ?? ?? 00 74 16 A1 08 ?? ?? ?? 8B 0D 0C ?? ?? ?? 03 48 14}
    condition:
        $a
}

rule PEiD_00674_eXPressor_1_4_5_1____CGSoftLabs_
{
    meta:
        description = "[eXPressor 1.4.5.1 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 58 53 56 57 83 65 DC 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 34 2E 00 A1 00 ?? ?? 00 05 00 ?? ?? 00 A3 08 ?? ?? 00 A1 08 ?? ?? 00 B9 81 ?? ?? 00 2B 48 18 89 0D 0C ?? ?? 00 83 3D 10 ?? ?? 00 00 74 16 A1 08 ?? ?? 00 8B 0D 0C ?? ?? 00 03 48 14}
    condition:
        $a at pe.entry_point
}

rule PEiD_00675_eXPressor_1_4_5_1____CGSoftLabs_
{
    meta:
        description = "[eXPressor 1.4.5.1 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 58 53 56 57 83 65 DC 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 34 2E 00 A1 00 ?? ?? 00 05 00 ?? ?? 00 A3 08 ?? ?? 00 A1 08 ?? ?? 00 B9 81 ?? ?? 00 2B 48 18 89 0D 0C ?? ?? 00 83 3D 10 ?? ?? 00 00 74 16 A1 08 ?? ?? 00 8B 0D 0C ?? ?? 00 03 48 14 89 4D CC E9 97 04 00 00 C7 05 10 ?? ?? 00 01 00 00 00 ?? ?? 68 54 ?? ?? 00 68 18 ?? ?? 00 6A 00 FF 15 E4 ?? ?? 00 83 7D 0C 01 74 04 83 65 08 00 6A 04 68 00 10 00 00 68 04 01 00 00 6A 00 FF 15 C4 ?? ?? 00 89 45 EC 68 04 01 00 00 FF 75 EC FF 75 08 FF 15 DC ?? ?? 00 8B 4D EC 8D 44 01 FF 89 45 AC 8B 45 AC 0F BE 00 83 F8 5C 74 09 8B 45 AC 48 89 45 AC EB EC 8B 45 AC 40 89 45 AC 8B 45 AC 2B 45 EC 89 45 B0 6A 04 68 00 10 00 00 68 04 01 00 00 6A 00 FF 15 C4 ?? ?? 00 89 45 FC 8B 4D B0 8B 75 EC 8B 7D FC 8B C1 C1 E9 02}
    condition:
        $a at pe.entry_point
}

rule PEiD_00676_eXpressor_v1_0____CGSoftLabs_
{
    meta:
        description = "[eXpressor v1.0 -> CGSoftLabs]"
        ep_only = "false"
    strings:
        $a = {E9 35 14 00 00 E9 31 13 00 00 E9 98 12 00 00 E9 EF 0C 00 00 E9 42 13}
    condition:
        $a
}

rule PEiD_00677_eXPressor_V1_0____CGSoftLabs_
{
    meta:
        description = "[eXPressor V1.0 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {E9 35 14 00 00 E9 31 13 00 00 E9 98 12 00 00 E9 EF 0C 00 00 E9 42 13 00 00 E9 E9 02 00 00 E9 EF 0B 00 00 E9 1B 0D 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00678_eXpressor_v1_1____CGSoftLabs_
{
    meta:
        description = "[eXpressor v1.1 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {E9 15 13 00 00 E9 F0 12 00 00 E9 58 12 00 00 E9 AF 0C 00 00 E9 AE 02 00 00 E9 B4 0B 00 00 E9 E0 0C 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00679_eXPressor_v1_2____CGSoftLabs__h__
{
    meta:
        description = "[eXPressor v1.2 -> CGSoftLabs (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC D4 01 00 00 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 32 2E 2E B8 ?? ?? ?? ?? 2B 05 84 ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 16 A1 ?? ?? ?? ?? 03 05 80 ?? ?? ?? 89 85 54 FE FF FF E9 ?? 07 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 68 04 01 00 00 8D 85 F0 FE FF FF 50 6A 00 FF 15}
    condition:
        $a at pe.entry_point
}

rule PEiD_00680_eXPressor_v1_2____CGSoftLabs_
{
    meta:
        description = "[eXPressor v1.2 -> CGSoftLabs]"
        ep_only = "false"
    strings:
        $a = {45 78 50 72 2D 76 2E 31 2E 32 2E}
    condition:
        $a
}

rule PEiD_00681_eXpressor_v1_2____CGSoftLabs_
{
    meta:
        description = "[eXpressor v1.2 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC D4 01 00 00 53 56 57 EB 0C 45 78 50 72 2D 76}
    condition:
        $a at pe.entry_point
}

rule PEiD_00682_eXPressor_v1_2_0b_
{
    meta:
        description = "[eXPressor v1.2.0b]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 81 EC D4 01 00 00 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 32 2E 2E B8 ?? ?? ?? 00 2B 05 84 ?? ?? 00 A3 ?? ?? ?? 00 83 3D ?? ?? ?? 00 00 74 16 A1 ?? ?? ?? 00 03 05 80 ?? ?? 00 89 85 54 FE FF FF E9 ?? 07 00 00 C7 05 ?? ?? ?? 00 01 00 00 00 68 04 01 00 00 8D 85 F0 FE FF FF 50 6A 00 FF 15 ?? ?? ?? 00 8D 84 05 EF FE FF FF 89 85 38 FE FF FF 8B 85 38 FE FF FF 0F BE 00 83 F8 5C}
    condition:
        $a
}

rule PEiD_00683_eXPressor_v1_3____CGSoftLabs__h__
{
    meta:
        description = "[eXPressor v1.3 -> CGSoftLabs (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC ?? 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 33 2E 2E B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 13 A1 ?? ?? ?? ?? 03 05 ?? ?? ?? ?? 89 ?? ?? E9 ?? ?? 00 00 C7 05}
    condition:
        $a at pe.entry_point
}

rule PEiD_00684_eXPressor_v1_3____CGSoftLabs_
{
    meta:
        description = "[eXPressor v1.3 -> CGSoftLabs]"
        ep_only = "false"
    strings:
        $a = {45 78 50 72 2D 76 2E 31 2E 33 2E}
    condition:
        $a
}

rule PEiD_00685_eXPressor_V1_3____CGSoftLabs_
{
    meta:
        description = "[eXPressor V1.3 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC ?? 53 56 57 EB 0C 45}
    condition:
        $a at pe.entry_point
}

rule PEiD_00686_eXPressor_v1_4____CGSoftLabs__h__
{
    meta:
        description = "[eXPressor v1.4 -> CGSoftLabs (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC ?? 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 34 2E 2E B8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00687_eXPressor_v1_4____CGSoftLabs_
{
    meta:
        description = "[eXPressor v1.4 -> CGSoftLabs]"
        ep_only = "false"
    strings:
        $a = {65 58 50 72 2D 76 2E 31 2E 34 2E}
    condition:
        $a
}

rule PEiD_00688_eXpressor_v1_4_5____CGSoftLabs_
{
    meta:
        description = "[eXpressor v1.4.5 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 58 53 56 57 83 65 DC 00 F3 EB 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00689_eXpressor_v1_4_5____CGSoftLabs_
{
    meta:
        description = "[eXpressor v1.4.5 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC ?? 53 56 57 83 65 DC 00 F3 EB 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00690_eXPressor_v1_4_5_1____CGSoftLabs__h__
{
    meta:
        description = "[eXPressor v1.4.5.1 -> CGSoftLabs (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 58 53 56 57 83 65 DC 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 34 2E 00 A1 00 ?? ?? ?? 05 00 ?? ?? ?? A3 08 ?? ?? ?? A1 08 ?? ?? ?? B9 81 ?? ?? ?? 2B 48 18 89 0D 0C ?? ?? ?? 83 3D 10 ?? ?? ?? 00 74 16 A1 08 ?? ?? ?? 8B 0D 0C ?? ?? ?? 03 48 14 89 4D CC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00691_eXPressor_V1_4_5_1____CGSoftLabs_
{
    meta:
        description = "[eXPressor V1.4.5.1 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 58 53 56 57 83 65 DC 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 34 2E 00 A1 00 ?? ?? 00 05 00 ?? ?? 00 A3 08 ?? ?? 00 A1 08 ?? ?? 00 B9 81 ?? ?? 00 2B 48 18 89 0D 0C ?? ?? 00 83 3D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00692_eXPressor_V1_4_5_1____CGSoftLabs_
{
    meta:
        description = "[eXPressor V1.4.5.1 -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC ?? 53 56 57 83 65 ?? 00 F3 EB 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00693_eXPressor_V1_4_5_x____CGSoftLabs_
{
    meta:
        description = "[eXPressor V1.4.5.x -> CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC ?? 53 56 57 83 65 ?? 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 34 2E 00 A1 00 ?? ?? 00 05 00 ?? ?? 00 A3 ?? ?? ?? 00 A1 ?? ?? ?? 00 B9 ?? ?? ?? 00 2B 48 18 89 0D ?? ?? ?? 00 83 3D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00694_eXPressor_v1_5_0_1__Options____Light__Full_support__CGSoftLabs_
{
    meta:
        description = "[eXPressor v1.5.0.1 (Options -> Light, Full support) CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC ?? 02 00 00 53 56 57 83 A5 ?? FD FF FF 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35}
    condition:
        $a at pe.entry_point
}

rule PEiD_00695_eXPressor_v1_5_0_1__Options____Protection__CGSoftLabs_
{
    meta:
        description = "[eXPressor v1.5.0.1 (Options -> Protection) CGSoftLabs]"
        ep_only = "true"
    strings:
        $a = {5E 00 00 80 00 00 00 68 91 5D D4 27 35 C5 5A 4C A5 40 48 C4 08 4E C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00696_eXPressor_v1_5x____CGSoftLabs__h__
{
    meta:
        description = "[eXPressor v1.5x -> CGSoftLabs (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 58 02 00 00 53 56 57 83 A5 CC FD FF FF 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 2E 00 83 7D 0C 01 75 23}
    condition:
        $a at pe.entry_point
}

rule PEiD_00697_eXPressor_PacK_V1_5_0_X____CGSoftLabs___Sign_by_fly_
{
    meta:
        description = "[eXPressor.PacK V1.5.0.X -> CGSoftLabs ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 83 A5 ?? ?? ?? ?? ?? F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 2E 00 83 7D 0C ?? 75 23 8B 45 08 A3 ?? ?? ?? ?? 6A 04 68 00 10 00 00 68 20 03 00 00 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_00698_eXPressor_Protection_1_5_0_X____CGSoftLabs_
{
    meta:
        description = "[eXPressor.Protection 1.5.0.X -> CGSoftLabs]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 EB 01 ?? ?? ?? ?? 83 EC 0C 53 56 57 EB 01 ?? 83 3D ?? ?? ?? ?? 00 74 08 EB 01 E9 E9 56 01 00 00 EB 02 E8 E9 C7 05 ?? ?? ?? ?? 01 00 00 00 EB 01 C2 E8 E2 05 00 00 EB 02 DA 9F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF D0 59 59 EB 01 C8 EB 02}
    condition:
        $a
}

rule PEiD_00699_eXPressor_Protection_V1_5_0_X____CGSoftLabs___Sign_by_fly_
{
    meta:
        description = "[eXPressor.Protection V1.5.0.X -> CGSoftLabs ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 EB 01 ?? ?? ?? ?? 83 EC 0C 53 56 57 EB 01 ?? 83 3D ?? ?? ?? ?? 00 74 08 EB 01 E9 E9 56 01 00 00 EB 02 E8 E9 C7 05 ?? ?? ?? ?? 01 00 00 00 EB 01 C2 E8 E2 05 00 00 EB 02 DA 9F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF D0 59 59 EB 01 C8 EB 02 66 F0 68 ?? ?? ?? ?? E8 0E 05 00 00 59 EB 01 DD 83 65 F4 00 EB 07 8B 45 F4 40 89 45 F4 83 7D F4 61 73 1F EB 02 DA 1A 8B 45 F4 0F ?? ?? ?? ?? ?? ?? 33 45 F4 8B 4D F4 88 ?? ?? ?? ?? ?? EB 01 EB EB}
    condition:
        $a
}

rule PEiD_00700_EZIP_v1_0_
{
    meta:
        description = "[EZIP v1.0]"
        ep_only = "true"
    strings:
        $a = {E9 19 32 00 00 E9 7C 2A 00 00 E9 19 24 00 00 E9 FF 23 00 00 E9 1E 2E 00 00 E9 88 2E 00 00 E9 2C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00701_E___________________
{
    meta:
        description = "[Eεش -> ºڷ]"
        ep_only = "true"
    strings:
        $a = {55 8B EC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 56 57 0F 31 8B D8 0F 31 8B D0 2B D3 C1 EA 10 B8 ?? ?? ?? ?? 0F 6E C0 B8 ?? ?? ?? ?? 0F 6E C8 0F F5 C1 0F 7E C0 0F 77 03 C2 ?? ?? ?? ?? ?? FF E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00702_FACRYPT_v1_0_
{
    meta:
        description = "[FACRYPT v1.0]"
        ep_only = "true"
    strings:
        $a = {B9 ?? ?? B3 ?? 33 D2 BE ?? ?? 8B FE AC 32 C3 AA 49 43 32 E4 03 D0 E3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00703_FakeNinja_v2_8__Anti_Debug_____Spirit_
{
    meta:
        description = "[FakeNinja v2.8 (Anti-Debug) -> Spirit]"
        ep_only = "false"
    strings:
        $a = {64 A1 18 00 00 00 EB 02 C3 11 8B 40 30 EB 01 0F 0F B6 40 02 83 F8 01 74 FE EB 01 E8 90 C0 FF FF EB 03 BD F4 B5 64 A1 30 00 00 00 0F B6 40 02 74 01 BA 74 E0 50 00 64 A1 30 00 00 00 83 C0 68 8B 00 EB 00 83 F8 70 74 CF EB 02 EB FE 90 90 90 0F 31 33 C9 03 C8 0F 31 2B C1 3D FF 0F 00 00 73 EA E8 08 00 00 00 C1 3D FF 0F 00 00 74 AA EB 07 E8 8B 40 30 EB 08 EA 64 A1 18 00 00 00 EB F2 90 90 90 BA ?? ?? ?? ?? FF E2 64 11 40 00 FF 35 84 11 40 00 E8 40 11 00 00 6A 00 6A 00 FF 35 70 11 40 00 FF 35 84 11 40 00 E8 25 11 00 00 FF}
    condition:
        $a
}

rule PEiD_00704_FakeNinja_v2_8____Spirit_
{
    meta:
        description = "[FakeNinja v2.8 -> Spirit]"
        ep_only = "false"
    strings:
        $a = {BA ?? ?? ?? ?? FF E2 64 11 40 00 FF 35 84 11 40 00 E8 40}
    condition:
        $a
}

rule PEiD_00705_FASM_1_5x_
{
    meta:
        description = "[FASM 1.5x]"
        ep_only = "false"
    strings:
        $a = {6A 00 FF 15 ?? ?? 40 00 A3 ?? ?? 40 00}
    condition:
        $a
}

rule PEiD_00706_fds0ft_c0m_pr0tect_v0_4b_
{
    meta:
        description = "[fds0ft c0m pr0tect v0.4b]"
        ep_only = "true"
    strings:
        $a = {8C CA 2E ?? ?? ?? ?? B4 30 8B ?? ?? ?? 8B ?? ?? ?? 8E DA A3 ?? ?? 8C ?? ?? ?? 89 ?? ?? ?? 89 ?? ?? ?? EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00707_fEaRzCrypter_v1_0____fEaRz_
{
    meta:
        description = "[fEaRzCrypter v1.0 -> fEaRz]"
        ep_only = "true"
    strings:
        $a = {55 8B EC B9 09 00 00 00 6A 00 6A 00 49 75 ?? 53 56 57 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BA ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 75 ?? 6A 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00708_File_Analyzer_Compiled_Datafile_Version_
{
    meta:
        description = "[File Analyzer Compiled Datafile Version]"
        ep_only = "false"
    strings:
        $a = {46 69 6C 65 20 41 6E 61 6C 79 7A 65 72 20 43 6F 6D 70 69 6C 65 64 20 44 61 74 61 66 69 6C 65 20 56 65 72 73 69 6F 6E}
    condition:
        $a
}

rule PEiD_00709_File_Analyzer_Extended_Datafile_Version_
{
    meta:
        description = "[File Analyzer Extended Datafile Version]"
        ep_only = "false"
    strings:
        $a = {23 03 45 58 54 44 ?? ?? 3A 03}
    condition:
        $a
}

rule PEiD_00710_File_Analyzer_Registration_file_v1_0_
{
    meta:
        description = "[File Analyzer Registration file v1.0]"
        ep_only = "false"
    strings:
        $a = {24 46 41 52 45 47 24 4D 2D ?? ?? ?? ?? 31}
    condition:
        $a
}

rule PEiD_00711_File_Analyzer_Registration_file_v1_1_
{
    meta:
        description = "[File Analyzer Registration file v1.1]"
        ep_only = "false"
    strings:
        $a = {24 46 41 52 45 47 24 45 4E 43 3D ?? 26 26 52 45 47 3D ?? 26 26 45 58 50 3D}
    condition:
        $a
}

rule PEiD_00712_FileShield_
{
    meta:
        description = "[FileShield]"
        ep_only = "true"
    strings:
        $a = {50 1E EB ?? 90 00 00 8B D8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00713_Fish_PE_Shield_1_01____HellFish_
{
    meta:
        description = "[Fish PE Shield 1.01 -> HellFish]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 D0 53 56 57 8B 45 10 83 C0 0C 8B 00 89}
    condition:
        $a
}

rule PEiD_00714_Fish_PE_Shield_1_01____HellFish_
{
    meta:
        description = "[Fish PE Shield 1.01 -> HellFish]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 D0 53 56 57 8B 45 10 83 C0 0C 8B 00 89 45 DC 83 7D DC 00 75 08 E8 AD FF FF FF 89 45 DC E8 C1 FE FF FF 8B 10 03 55 DC 89 55 E4 83 C0 04 8B 10 89 55 FC 83 C0 04 8B 10 89 55 F4 83 C0 04 8B 10 89 55 F8 83 C0 04 8B 10 89 55 F0 83 C0 04 8B 10 89 55 EC 83 C0 04 8B 00 89 45 E8 8B 45 E4 8B 58 04 03 5D E4 8B FB 8B 45 E4 8B 30 4E 85 F6 72 2B 46 C7 45 E0 00 00 00 00 83 7B 04 00 74 14}
    condition:
        $a
}

rule PEiD_00715_Fish_PE_Shield_1_01____HellFish_
{
    meta:
        description = "[Fish PE Shield 1.01 -> HellFish]"
        ep_only = "true"
    strings:
        $a = {60 E8 12 FE FF FF C3 90 09 00 00 00 2C 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00716_Fish_PE_Shield_1_01____HellFish_
{
    meta:
        description = "[Fish PE Shield 1.01 -> HellFish]"
        ep_only = "true"
    strings:
        $a = {60 E8 12 FE FF FF C3 90 09 00 00 00 2C 00 00 00 ?? ?? ?? ?? C4 03 00 00 BC A0 00 00 00 40 01 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 99 00 00 00 00 8A 00 00 00 10 00 00 28 88 00 00 40 ?? 4B 00 00 00 02 00 00 00 A0 00 00 18 01 00 00 40 ?? 4C 00 00 00 0C 00 00 00 B0 00 00 38 0A 00 00 40 ?? 4E 00 00 00 00 00 00 00 C0 00 00 40 39 00 00 40 ?? 4E 00 00 00 08 00 00 00 00 01 00 C8 06 00 00 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00717_Fish_PE_Shield_1_12_1_16____HellFish_
{
    meta:
        description = "[Fish PE Shield 1.12/1.16 -> HellFish]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 D0 53 56 57 8B 45 10 83 C0 0C 8B 00 89 45 DC}
    condition:
        $a
}

rule PEiD_00718_Fish_PE_Shield_1_12_1_16____HellFish_
{
    meta:
        description = "[Fish PE Shield 1.12/1.16 -> HellFish]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 D0 53 56 57 8B 45 10 83 C0 0C 8B 00 89 45 DC 83 7D DC 00 75 08 E8 BD FE FF FF 89 45 DC E8 E1 FD FF FF 8B 00 03 45 DC 89 45 E4 E8 DC FE FF FF 8B D8 BA 8E 4E 0E EC 8B C3 E8 2E FF FF FF 89 45 F4 BA 04 49 32 D3 8B C3 E8 1F FF FF FF 89 45 F8 BA 54 CA AF 91 8B C3 E8 10 FF FF FF 89 45 F0 BA AC 33 06 03 8B C3 E8 01 FF FF FF 89 45 EC BA 1B C6 46 79 8B C3 E8 F2 FE FF FF 89 45 E8 BA AA FC 0D 7C 8B C3 E8 E3 FE FF FF 89 45 FC 8B 45 E4 8B 58 04 03 5D E4 8B FB 8B 45 E4 8B 30 4E 85 F6 72 2B}
    condition:
        $a
}

rule PEiD_00719_Fish_PE_Shield_1_12_1_16____HellFish_
{
    meta:
        description = "[Fish PE Shield 1.12/1.16 -> HellFish]"
        ep_only = "true"
    strings:
        $a = {60 E8 EA FD FF FF FF D0 C3 8D 40 00 ?? 00 00 00 2C 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00720_Fish_PE_Shield_1_12_1_16____HellFish_
{
    meta:
        description = "[Fish PE Shield 1.12/1.16 -> HellFish]"
        ep_only = "true"
    strings:
        $a = {60 E8 EA FD FF FF FF D0 C3 8D 40 00 ?? 00 00 00 2C 00 00 00 ?? ?? ?? 00 ?? ?? 00 00 ?? ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 00 00 00 00 ?? ?? 00 ?? ?? 00 00 ?? 00 00 00 00 ?? ?? 00 00 10 00 00 ?? ?? ?? 00 40 ?? ?? ?? 00 00 ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 40 ?? ?? ?? 00 00 ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00721_Fish_PE_Shield_1_16____HellFish_
{
    meta:
        description = "[Fish PE Shield 1.16 -> HellFish]"
        ep_only = "true"
    strings:
        $a = {60 E8 EA FD FF FF FF D0 C3 8D 40 00 ?? 00 00 00 2C 00 00 00 ?? ?? ?? 00 ?? ?? 00 00 ?? ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? 00 00 00 00 ?? ?? 00 00 10 00 00 ?? ?? ?? 00 40 ?? ?? ?? 00 00 ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 40 ?? ?? ?? 00 00 ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00722_FishPE_V1_0X____hellfish___Sign_by_fly_
{
    meta:
        description = "[FishPE V1.0X -> hellfish ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? C3 90 09 00 00 00 2C 00 00 00 ?? ?? ?? ?? C4 03 00 00 BC A0 00 00 00 40 01 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 99 00 00 00 00 8A 00 00 00 10 00 00 ?? ?? 00 00 ?? ?? ?? ?? 00 00 02 00 00 00 A0 00 00 18 01 00 00 ?? ?? ?? ?? 00 00 0C 00 00 00 B0 00 00 38 0A 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 C0 00 00 40 39 00 00 ?? ?? ?? ?? 00 00 08 00 00 00 00 01 00 C8 06 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00723_FishPE_V1_0X____hellfish_
{
    meta:
        description = "[FishPE V1.0X -> hellfish]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? C3 90 09 00 00 00 2C 00 00 00 ?? ?? ?? ?? C4 03 00 00 BC A0 00 00 00 40 01 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 99 00 00 00 00 8A 00 00 00 10 00 00 ?? ?? 00 00 ?? ?? ?? ?? 00 00 02 00 00 00 A0 00 00 18 01 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00724_FixupPak_1_20_
{
    meta:
        description = "[FixupPak 1.20]"
        ep_only = "false"
    strings:
        $a = {55 E8 00 00 00 00 5D 81 ED ?? ?? 00 00 BE 00 ?? 00 00 03 F5 BA 00 00 ?? ?? 2B D5 8B DD 33 C0 AC 3C 00 74 3D 3C 01 74 0E 3C 02 74 0E 3C 03 74 0D 03 D8 29 13 EB E7 66 AD EB F6 AD EB F3 AC 0F B6 C8 3C 00 74 06 3C 01 74 09 EB 0A 66 AD 0F B7 C8 EB 03 AD 8B C8}
    condition:
        $a
}

rule PEiD_00725_FixupPak_v1_20_
{
    meta:
        description = "[FixupPak v1.20]"
        ep_only = "true"
    strings:
        $a = {55 E8 00 00 00 00 5D 81 ED ?? ?? 00 00 BE 00 ?? 00 00 03 F5 BA 00 00 ?? ?? 2B D5 8B DD 33 C0 AC 3C 00 74 3D 3C 01 74 0E 3C 02 74 0E 3C 03 74 0D 03 D8 29 13 EB E7 66 AD EB F6 AD EB F3 AC 0F B6 C8 3C 00 74 06 3C 01 74 09 EB 0A 66 AD 0F B7 C8 EB 03 AD 8B C8 AC 0F B6 C0 03 D8 29 13 E2 FA EB BC 8D 85 ?? ?? 00 00 5D FF E0 00 00 00 00 08 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00726_Fly_Crypter_1_0____ut1lz_
{
    meta:
        description = "[Fly-Crypter 1.0 -> ut1lz]"
        ep_only = "false"
    strings:
        $a = {53 56 57 55 BB 2C ?? ?? 44 BE 00 30 44 44 BF 20 ?? ?? 44 80 7B 28 00 75 16 83 3F 00 74 11 8B 17 89 D0 33 D2 89 17 8B E8 FF D5 83 3F 00 75 EF 83 3D 04 30 44 44 00 74 06 FF 15 58 30 44 44 80 7B 28 02 75 0A 83 3E 00 75 05 33 C0 89 43 0C FF 15 20 30 44 44 80 7B 28 01 76 05 83 3E 00 74 22 8B 43 10 85 C0 74 1B FF 15 18 30 44 44 8B 53 10 8B 42 10 3B 42 04 74 0A 85 C0 74 06 50 E8 2F FA FF FF FF 15 24 30 44 44 80 7B 28 01 75 03 FF 53 24 80 7B 28 00 74 05 E8 35 FF FF FF 83 3B 00 75 17 83 3D 10 ?? ?? 44 00 74 06 FF 15 10 ?? ?? 44 8B 06 50 E8 51 FA FF FF 8B 03 56 8B F0 8B FB B9 0B 00 00 00 F3 A5 5E E9 73 FF FF FF 5D 5F 5E 5B C3 A3 00 30 44 44 E8 26 FF FF FF C3}
    condition:
        $a
}

rule PEiD_00727_Fly_Crypter_1_0____ut1lz_
{
    meta:
        description = "[Fly-Crypter 1.0 -> ut1lz]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 B8 18 22 44 44 E8 7F F7 FF FF E8 0A F1 FF FF B8 09 00 00 00 E8 5C F1 FF FF 8B D8 85 DB 75 05 E8 85 FD FF FF 83 FB 01 75 05 E8 7B FD FF FF 83 FB 02 75 05 E8 D1 FD FF FF 83 FB 03 75 05 E8 87 FE FF FF 83 FB 04 75 05 E8 5D FD FF FF 83 FB 05 75 05 E8 B3 FD FF FF 83 FB 06 75 05 E8 69 FE FF FF 83 FB 07 75 05 E8 5F FE FF FF 83 FB 08 75 05 E8 95 FD FF FF 83 FB 09 75 05 E8 4B FE FF FF 5B E8 9D F2 FF FF 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_00728_Free_Pascal_0_99_10_
{
    meta:
        description = "[Free Pascal 0.99.10]"
        ep_only = "false"
    strings:
        $a = {E8 00 6E 00 00 55 89 E5 8B 7D 0C 8B 75 08 89 F8 8B 5D 10 29}
    condition:
        $a
}

rule PEiD_00729_Free_Pascal_1_06_
{
    meta:
        description = "[Free Pascal 1.06]"
        ep_only = "false"
    strings:
        $a = {C6 05 ?? ?? 40 00 ?? E8 ?? ?? 00 00}
    condition:
        $a
}

rule PEiD_00730_Free_Pascal_v0_99_10_
{
    meta:
        description = "[Free Pascal v0.99.10]"
        ep_only = "true"
    strings:
        $a = {?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 00 6E 00 00 55 89 E5 8B 7D 0C 8B 75 08 89 F8 8B 5D 10 29}
    condition:
        $a at pe.entry_point
}

rule PEiD_00731_Free_Pascal_v1_0_10__win32_console__
{
    meta:
        description = "[Free Pascal v1.0.10 (win32 console)]"
        ep_only = "false"
    strings:
        $a = {C6 05 ?? ?? ?? 00 01 E8 ?? ?? 00 00 C6 05 ?? ?? ?? 00 00 E8 ?? ?? 00 00 50 E8 00 00 00 00 FF 25 ?? ?? ?? 00 55 89 E5 ?? EC}
    condition:
        $a
}

rule PEiD_00732_Free_Pascal_v1_0_10__win32_GUI__
{
    meta:
        description = "[Free Pascal v1.0.10 (win32 GUI)]"
        ep_only = "false"
    strings:
        $a = {C6 05 ?? ?? ?? 00 00 E8 ?? ?? 00 00 50 E8 00 00 00 00 FF 25 ?? ?? ?? 00 55 89 E5}
    condition:
        $a
}

rule PEiD_00733_FreeBASIC_0_16b_
{
    meta:
        description = "[FreeBASIC 0.16b]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 ?? ?? ?? 00 E8 88 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 ?? ?? ?? 00 E8 68 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 45 08 89 04 24 FF 15 ?? ?? ?? 00 89 EC 5D}
    condition:
        $a
}

rule PEiD_00734_FreeBASIC_0_16b_
{
    meta:
        description = "[FreeBASIC 0.16b]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 ?? ?? ?? 00 E8 88 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 ?? ?? ?? 00 E8 68 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 45 08 89 04 24 FF 15 ?? ?? ?? 00 89 EC 5D C3 8D 76 00 8D BC 27 00 00 00 00 55 89 E5 83 EC 08 8B 45 08 89 04 24 FF 15 ?? ?? ?? 00 89 EC 5D C3 90 90 90 90 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_00735_FreeBASIC_v0_11_
{
    meta:
        description = "[FreeBASIC v0.11]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? 00 00 E8 01 00 00 00 C3 55 89 E5}
    condition:
        $a at pe.entry_point
}

rule PEiD_00736_FreeCryptor_0_1__build_001____GlOFF_
{
    meta:
        description = "[FreeCryptor 0.1 (build 001)-> GlOFF]"
        ep_only = "false"
    strings:
        $a = {8B 04 24 40 90 83 C0 07 80 38 90 90 74 02 EB FF 68 26 ?? ?? 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 FF E4 90 8B 04 24 64 A3 00 00 00 00 8B 64 24 08 90 83 C4 08}
    condition:
        $a
}

rule PEiD_00737_FreeCryptor_0_1__build_002_____GlOFF_
{
    meta:
        description = "[FreeCryptor 0.1 (build 002) -> GlOFF]"
        ep_only = "false"
    strings:
        $a = {8B 04 24 40 90 83 C0 07 80 38 90 90 74 02 EB FF 90 68 27 ?? ?? 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 FF E4 90 8B 04 24 64 A3 00 00 00 00 8B 64 24 08 90 83 C4 08}
    condition:
        $a
}

rule PEiD_00738_FreeCryptor_0_2__build_002_____GlOFF_
{
    meta:
        description = "[FreeCryptor 0.2 (build 002) -> GlOFF]"
        ep_only = "false"
    strings:
        $a = {33 D2 90 1E 68 1B ?? ?? ?? 0F A0 1F 8B 02 90 50 54 8F 02 90 90 8E 64 24 08 FF E2 58 50 33 D2 52 83 F8 01 9B 40 8A 10 89 14 24 90 D9 04 24 90 D9 FA D9 5C 24 FC 8B 5C 24 FC 81 F3 C2 FC 1D 1C 75 E3 74 01 62 FF D0 90 5A 33 C0 8B 54 24 08 90 64 8F 00 90 83 C2 08 52 5C 5A}
    condition:
        $a
}

rule PEiD_00739_FreeJoiner_1_5_1____GlOFF_
{
    meta:
        description = "[FreeJoiner 1.5.1 -> GlOFF]"
        ep_only = "true"
    strings:
        $a = {90 87 FF 90 90 B9 2B 00 00 00 BA 07 10 40 00 83 C2 03 90 87 FF 90 90 B9 04 00 00 00 90 87 FF 90 33 C9 C7 05 09 30 40 00 00 00 00 00 68 00 01 00 00 68 21 30 40 00 6A 00 E8 B7 02 00 00 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 21 30 40 00 E8 8F 02 00 00 A3 19 30 40 00 90 87 FF 90 8B 15 09 30 40 00 81 C2 04 01 00 00 F7 DA 6A 02 6A 00 52}
    condition:
        $a at pe.entry_point
}

rule PEiD_00740_FreeJoiner_1_5_2__Stub_engine_1_6_____GlOFF_
{
    meta:
        description = "[FreeJoiner 1.5.2 (Stub engine 1.6) -> GlOFF]"
        ep_only = "true"
    strings:
        $a = {E8 46 FD FF FF 50 E8 0C 00 00 00 FF 25 08 20 40 00 FF 25 0C 20 40 00 FF 25 10 20 40 00 FF 25 14 20 40 00 FF 25 18 20 40 00 FF 25 1C 20 40 00 FF 25 20 20 40 00 FF 25 24 20 40 00 FF 25 28 20 40 00 FF 25 00 20 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00741_FreeJoiner_1_5_3__Stub_engine_1_7_____GlOFF_
{
    meta:
        description = "[FreeJoiner 1.5.3 (Stub engine 1.7) -> GlOFF]"
        ep_only = "true"
    strings:
        $a = {E8 33 FD FF FF 50 E8 0D 00 00 00 CC FF 25 08 20 40 00 FF 25 0C 20 40 00 FF 25 10 20 40 00 FF 25 14 20 40 00 FF 25 18 20 40 00 FF 25 1C 20 40 00 FF 25 20 20 40 00 FF 25 24 20 40 00 FF 25 28 20 40 00 FF 25 00 20 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00742_FreeJoiner_1_5_3__Stub_engine_1_7_1_____GlOFF_
{
    meta:
        description = "[FreeJoiner 1.5.3 (Stub engine 1.7.1) -> GlOFF]"
        ep_only = "false"
    strings:
        $a = {86 D6 90 86 F2 B9 93 60 08 FE 90 86 D6 90 86 F2 B9 9D 13 45 01 86 D6 90 86 F2 81 C2 93 60 08 FE 33 C9 B9 30 74 4D FF 86 D6 90 86 F2 33 C9 C7 05 B4 17 40 00 00 00 00 00 90 68 00 01 00 00 68 D1 17 40 00 6A 00 E8 CE 02 00 00 90 33 C9 86 D6 90 86 F2 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 D1 17 40 00 E8 9E 02 00 00 A3 CD 17 40 00 86 D6}
    condition:
        $a
}

rule PEiD_00743_FreeJoiner_1_5_3__Stub_engine_1_7_1_____GlOFF_
{
    meta:
        description = "[FreeJoiner 1.5.3 (Stub engine 1.7.1) -> GlOFF]"
        ep_only = "true"
    strings:
        $a = {E8 02 FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A8 10 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00744_FreeJoiner_Small__build_014_020_____GlOFF_
{
    meta:
        description = "[FreeJoiner Small (build 014-020) -> GlOFF]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00745_FreeJoiner_Small__build_014_015_____GlOFF_
{
    meta:
        description = "[FreeJoiner Small (build 014/015) -> GlOFF]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 F0 86 FF 68 00 01 00 00 68 F8 13 40 00 6A 00 E8 F3 01 00 00 8A C0 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 F8 13 40 00 E8 C9 01 00 00 A3 E0 13 40 00 40 0F 84 8B 01 00 00 90 90 90 90 90 6A 02 6A 00 6A FB FF 35 E0 13 40 00 E8 D1 01 00 00 86 FF 6A 00 8D 45 FC 50 6A 04 8D 45 F8 50 FF 35 E0 13 40 00 E8 B2 01 00 00 8A C0 6A 00 8D 45 FC 50 6A 01 8D 45 F3 50}
    condition:
        $a
}

rule PEiD_00746_FreeJoiner_Small__build_014_015_____GlOFF_
{
    meta:
        description = "[FreeJoiner Small (build 014/015) -> GlOFF]"
        ep_only = "true"
    strings:
        $a = {E8 0E FE FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00747_FreeJoiner_Small__build_017_____GlOFF_
{
    meta:
        description = "[FreeJoiner Small (build 017) -> GlOFF]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 F0 86 FF 86 DB 86 FF 68 00 01 00 00 68 18 20 40 00 6A 00 E8 FF 01 00 00 8A E4 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 18 20 40 00 E8 D5 01 00 00 A3 00 20 40 00 40 0F 84 97 01 00 00 8A E4 6A 02 6A 00 6A FB FF 35 00 20 40 00 E8 E0 01 00 00 86 FF 86 DB 86 FF 6A 00 8D 45 FC 50 6A 04 8D 45 F8 50 FF 35 00 20 40 00 E8 BD 01 00 00 8A E4 6A 00 8D 45 FC 50 6A 01 8D 45 F3 50}
    condition:
        $a
}

rule PEiD_00748_FreeJoiner_Small__build_017_____GlOFF_
{
    meta:
        description = "[FreeJoiner Small (build 017) -> GlOFF]"
        ep_only = "true"
    strings:
        $a = {E8 FE FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00749_FreeJoiner_Small__build_023_____GlOFF_
{
    meta:
        description = "[FreeJoiner Small (build 023) -> GlOFF]"
        ep_only = "true"
    strings:
        $a = {E8 E1 FD FF FF 6A 00 E8 0C 00 00 00 FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00750_FreeJoiner_Small__build_029_____GlOFF_
{
    meta:
        description = "[FreeJoiner Small (build 029) -> GlOFF]"
        ep_only = "true"
    strings:
        $a = {50 32 C4 8A C3 58 E8 DE FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00751_FreeJoiner_Small__build_031_032_____GlOFF_
{
    meta:
        description = "[FreeJoiner Small (build 031/032) -> GlOFF]"
        ep_only = "true"
    strings:
        $a = {50 32 ?? 66 8B C3 58 E8 ?? FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00752_FreeJoiner_Small__build_033_____GlOFF_
{
    meta:
        description = "[FreeJoiner Small (build 033) -> GlOFF]"
        ep_only = "true"
    strings:
        $a = {50 66 33 C3 66 8B C1 58 E8 AC FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00753_FreeJoiner_Small__build_035_____GlOFF_
{
    meta:
        description = "[FreeJoiner Small (build 035) -> GlOFF]"
        ep_only = "true"
    strings:
        $a = {51 33 CB 86 C9 59 E8 9E FD FF FF 66 87 DB 6A 00 E8 0C 00 00 00 FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00754_FreePascal_1_0_4_Win32_____Berczi_Gabor__Pierre_Muller___Peter_Vreman__
{
    meta:
        description = "[FreePascal 1.0.4 Win32 -> (Berczi Gabor, Pierre Muller & Peter Vreman)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? 55 31 ED 89 E0 A3 ?? ?? ?? ?? 66 8C D5 89 2D ?? ?? ?? ?? DB E3 D9 2D ?? ?? ?? ?? 31 ED E8 ?? ?? ?? ?? 5D E8 ?? ?? ?? ?? C9 C3}
    condition:
        $a
}

rule PEiD_00755_FreePascal_1_0_4_Win32_DLL_____Berczi_Gabor__Pierre_Muller___Peter_Vreman__
{
    meta:
        description = "[FreePascal 1.0.4 Win32 DLL -> (Berczi Gabor, Pierre Muller & Peter Vreman)]"
        ep_only = "false"
    strings:
        $a = {C6 05 ?? ?? ?? ?? 00 55 89 E5 53 56 57 8B 7D 08 89 3D ?? ?? ?? ?? 8B 7D 0C 89 3D ?? ?? ?? ?? 8B 7D 10 89 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 0C 00}
    condition:
        $a
}

rule PEiD_00756_FreePascal_2_0_0_Win32_____Berczi_Gabor__Pierre_Muller___Peter_Vreman__
{
    meta:
        description = "[FreePascal 2.0.0 Win32 -> (Berczi Gabor, Pierre Muller & Peter Vreman)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? 6A 00 64 FF 35 00 00 00 00 89 E0 A3 ?? ?? ?? ?? 55 31 ED 89 E0 A3 ?? ?? ?? ?? 66 8C D5 89 2D ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 ED E8 ?? ?? ?? ?? 5D E8 ?? ?? ?? ?? C9 C3}
    condition:
        $a
}

rule PEiD_00757_FreePascal_2_0_0_Win32_____B_rczi_G_bor__Pierre_Muller___Peter_Vreman__
{
    meta:
        description = "[FreePascal 2.0.0 Win32 -> (Brczi Gbor, Pierre Muller & Peter Vreman)]"
        ep_only = "true"
    strings:
        $a = {C6 05 00 80 40 00 01 E8 74 00 00 00 C6 05 00 80 40 00 00 E8 68 00 00 00 50 E8 00 00 00 00 FF 25 D8 A1 40 00 90 90 90 90 90 90 90 90 90 90 90 90 55 89 E5 83 EC 04 89 5D FC E8 92 00 00 00 E8 ED 00 00 00 89 C3 B9 ?? 70 40 00 89 DA B8 00 00 00 00 E8 0A 01 00 00 E8 C5 01 00 00 89 D8 E8 3E 02 00 00 E8 B9 01 00 00 E8 54 02 00 00 8B 5D FC C9 C3 8D 76 00 00 00 00 00 00 00 00 00 00 00 00 00 55 89 E5 C6 05 10 80 40 00 00 E8 D1 03 00 00 6A 00 64 FF 35 00 00 00 00 89 E0 A3 ?? 70 40 00 55 31 ED 89 E0 A3 20 80 40 00 66 8C D5 89 2D 30 80 40 00 E8 B9 03 00 00 31 ED E8 72 FF FF FF 5D E8 BC 03 00 00 C9 C3 00 00 00 00 00 00 00 00 00 00 55 89 E5 83 EC 08 E8 15 04 00 00 A1 ?? 70 40 00 89 45 F8 B8 01 00 00 00 89 45 FC 3B 45 F8 7F 2A FF 4D FC 90 FF 45 FC 8B 45 FC 83 3C C5 ?? 70 40 00 00 74 09 8B 04 C5 ?? 70 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00758_FreePascal_2_0_0_Win32_
{
    meta:
        description = "[FreePascal 2.0.0 Win32]"
        ep_only = "true"
    strings:
        $a = {C6 05 00 80 40 00 01 E8 74 00 00 00 C6 05 00 80 40 00 00 E8 68 00 00 00 50 E8 00 00 00 00 FF 25 D8 A1 40 00 90 90 90 90 90 90 90 90 90 90 90 90 55 89 E5 83 EC 04 89 5D FC E8 92 00 00 00 E8 ED 00 00 00 89 C3 B9 ?? 70 40 00 89 DA B8 00 00 00 00 E8 0A 01 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00759_FreePascal_2_0_0_Win32_
{
    meta:
        description = "[FreePascal 2.0.0 Win32]"
        ep_only = "true"
    strings:
        $a = {C6 05 ?? ?? ?? ?? 01 E8 74 00 00 00 C6 05 00 80 40 00 00 E8 68 00 00 00 50 E8 00 00 00 00 FF 25 D8 A1 40 00 90 90 90 90 90 90 90 90 90 90 90 90 55 89 E5 83 EC 04 89 5D FC E8 92 00 00 00 E8 ED 00 00 00 89 C3 B9 ?? 70 40 00 89 DA B8 00 00 00 00 E8 0A 01 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00760_Freshbind_v2_0____gFresh_
{
    meta:
        description = "[Freshbind v2.0 -> gFresh]"
        ep_only = "true"
    strings:
        $a = {64 A1 00 00 00 00 55 89 E5 6A FF 68 1C A0 41 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00761_from_NORMAN_Anti_Virus_Utilites_
{
    meta:
        description = "[from NORMAN Anti-Virus Utilites]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? 5B 52 45 2F 4E 44 44 53 5D 0D 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_00762_Frusion____biff_
{
    meta:
        description = "[Frusion -> biff]"
        ep_only = "true"
    strings:
        $a = {83 EC 0C 53 55 56 57 68 04 01 00 00 C7 44 24 14}
    condition:
        $a at pe.entry_point
}

rule PEiD_00763_FSG_1_00__Eng_____dulek_xt_
{
    meta:
        description = "[FSG 1.00 (Eng) -> dulek/xt]"
        ep_only = "false"
    strings:
        $a = {BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38}
    condition:
        $a
}

rule PEiD_00764_FSG_1_10__Eng_____bart_xt_
{
    meta:
        description = "[FSG 1.10 (Eng) -> bart/xt]"
        ep_only = "true"
    strings:
        $a = {BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00765_FSG_1_10__Eng_____dulek_xt_____Borland_C____
{
    meta:
        description = "[FSG 1.10 (Eng) -> dulek/xt -> (Borland C++)]"
        ep_only = "true"
    strings:
        $a = {23 CA EB 02 5A 0D E8 02 00 00 00 6A 35 58 C1 C9 10 BE 80 ?? ?? 00 0F B6 C9 EB 02 CD 20 BB F4 00 00 00 EB 02 04 FA EB 01 FA EB 01 5F EB 02 CD 20 8A 16 EB 02 11 31 80 E9 31 EB 02 30 11 C1 E9 11 80 EA 04 EB 02 F0 EA 33 CB 81 EA AB AB 19 08 04 D5 03 C2 80 EA}
    condition:
        $a at pe.entry_point
}

rule PEiD_00766_FSG_1_10__Eng_____dulek_xt_____Borland_Delphi___Borland_C____
{
    meta:
        description = "[FSG 1.10 (Eng) -> dulek/xt -> (Borland Delphi / Borland C++)]"
        ep_only = "true"
    strings:
        $a = {2B C2 E8 02 00 00 00 95 4A 59 8D 3D 52 F1 2A E8 C1 C8 1C BE 2E ?? ?? 18 EB 02 AB A0 03 F7 EB 02 CD 20 68 F4 00 00 00 0B C7 5B 03 CB 8A 06 8A 16 E8 02 00 00 00 8D 46 59 EB 01 A4 02 D3 EB 02 CD 20 02 D3 E8 02 00 00 00 57 AB 58 81 C2 AA 87 AC B9 0F BE C9 80}
    condition:
        $a at pe.entry_point
}

rule PEiD_00767_FSG_1_10__Eng_____dulek_xt_____Borland_Delphi___Microsoft_Visual_C____
{
    meta:
        description = "[FSG 1.10 (Eng) -> dulek/xt -> (Borland Delphi / Microsoft Visual C++)]"
        ep_only = "true"
    strings:
        $a = {1B DB E8 02 00 00 00 1A 0D 5B 68 80 ?? ?? 00 E8 01 00 00 00 EA 5A 58 EB 02 CD 20 68 F4 00 00 00 EB 02 CD 20 5E 0F B6 D0 80 CA 5C 8B 38 EB 01 35 EB 02 DC 97 81 EF F7 65 17 43 E8 02 00 00 00 97 CB 5B 81 C7 B2 8B A1 0C 8B D1 83 EF 17 EB 02 0C 65 83 EF 43 13}
    condition:
        $a at pe.entry_point
}

rule PEiD_00768_FSG_1_10__Eng_____dulek_xt_____MASM32___TASM32__
{
    meta:
        description = "[FSG 1.10 (Eng) -> dulek/xt -> (MASM32 / TASM32)]"
        ep_only = "true"
    strings:
        $a = {03 F7 23 FE 33 FB EB 02 CD 20 BB 80 ?? 40 00 EB 01 86 EB 01 90 B8 F4 00 00 00 83 EE 05 2B F2 81 F6 EE 00 00 00 EB 02 CD 20 8A 0B E8 02 00 00 00 A9 54 5E C1 EE 07 F7 D7 EB 01 DE 81 E9 B7 96 A0 C4 EB 01 6B EB 02 CD 20 80 E9 4B C1 CF 08 EB 01 71 80 E9 1C EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00769_FSG_1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG 1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "true"
    strings:
        $a = {03 DE EB 01 F8 B8 80 ?? 42 00 EB 02 CD 20 68 17 A0 B3 AB EB 01 E8 59 0F B6 DB 68 0B A1 B3 AB EB 02 CD 20 5E 80 CB AA 2B F1 EB 02 CD 20 43 0F BE 38 13 D6 80 C3 47 2B FE EB 01 F4 03 FE EB 02 4F 4E 81 EF 93 53 7C 3C 80 C3 29 81 F7 8A 8F 67 8B 80 C3 C7 2B FE}
    condition:
        $a at pe.entry_point
}

rule PEiD_00770_FSG_1_20__Eng_____dulek_xt_____Borland_C____
{
    meta:
        description = "[FSG 1.20 (Eng) -> dulek/xt -> (Borland C++)]"
        ep_only = "false"
    strings:
        $a = {C1 F0 07 EB 02 CD 20 BE 80 ?? ?? 00 1B C6 8D 1D F4 00 00 00 0F B6 06 EB 02 CD 20 8A 16 0F B6 C3 E8 01 00 00 00 DC 59 80 EA 37 EB 02 CD 20 2A D3 EB 02 CD 20 80 EA 73 1B CF 32 D3 C1 C8 0E 80 EA 23 0F B6 C9 02 D3 EB 01 B5 02 D3 EB 02 DB 5B 81 C2 F6 56 7B F6}
    condition:
        $a
}

rule PEiD_00771_FSG_1_20__Eng_____dulek_xt_____Borland_Delphi___Borland_C____
{
    meta:
        description = "[FSG 1.20 (Eng) -> dulek/xt -> (Borland Delphi / Borland C++)]"
        ep_only = "false"
    strings:
        $a = {0F BE C1 EB 01 0E 8D 35 C3 BE B6 22 F7 D1 68 43 ?? ?? 22 EB 02 B5 15 5F C1 F1 15 33 F7 80 E9 F9 BB F4 00 00 00 EB 02 8F D0 EB 02 08 AD 8A 16 2B C7 1B C7 80 C2 7A 41 80 EA 10 EB 01 3C 81 EA CF AE F1 AA EB 01 EC 81 EA BB C6 AB EE 2C E3 32 D3 0B CB 81 EA AB}
    condition:
        $a
}

rule PEiD_00772_FSG_1_20__Eng_____dulek_xt_____Borland_Delphi___Microsoft_Visual_C____
{
    meta:
        description = "[FSG 1.20 (Eng) -> dulek/xt -> (Borland Delphi / Microsoft Visual C++)]"
        ep_only = "false"
    strings:
        $a = {0F B6 D0 E8 01 00 00 00 0C 5A B8 80 ?? ?? 00 EB 02 00 DE 8D 35 F4 00 00 00 F7 D2 EB 02 0E EA 8B 38 EB 01 A0 C1 F3 11 81 EF 84 88 F4 4C EB 02 CD 20 83 F7 22 87 D3 33 FE C1 C3 19 83 F7 26 E8 02 00 00 00 BC DE 5A 81 EF F7 EF 6F 18 EB 02 CD 20 83 EF 7F EB 01}
    condition:
        $a
}

rule PEiD_00773_FSG_1_20__Eng_____dulek_xt_____MASM32___TASM32__
{
    meta:
        description = "[FSG 1.20 (Eng) -> dulek/xt -> (MASM32 / TASM32)]"
        ep_only = "false"
    strings:
        $a = {33 C2 2C FB 8D 3D 7E 45 B4 80 E8 02 00 00 00 8A 45 58 68 02 ?? 8C 7F EB 02 CD 20 5E 80 C9 16 03 F7 EB 02 40 B0 68 F4 00 00 00 80 F1 2C 5B C1 E9 05 0F B6 C9 8A 16 0F B6 C9 0F BF C7 2A D3 E8 02 00 00 00 99 4C 58 80 EA 53 C1 C9 16 2A D3 E8 02 00 00 00 9D CE}
    condition:
        $a
}

rule PEiD_00774_FSG_1_20__Eng_____dulek_xt_____Microsoft_Visual_C___6_0___7_0__
{
    meta:
        description = "[FSG 1.20 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0 / 7.0)]"
        ep_only = "false"
    strings:
        $a = {EB 02 CD 20 EB 01 91 8D 35 80 ?? ?? 00 33 C2 68 83 93 7E 7D 0C A4 5B 23 C3 68 77 93 7E 7D EB 01 FA 5F E8 02 00 00 00 F7 FB 58 33 DF EB 01 3F E8 02 00 00 00 11 88 58 0F B6 16 EB 02 CD 20 EB 02 86 2F 2A D3 EB 02 CD 20 80 EA 2F EB 01 52 32 D3 80 E9 CD 80 EA}
    condition:
        $a
}

rule PEiD_00775_FSG_1_20__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG 1.20 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "false"
    strings:
        $a = {C1 E0 06 EB 02 CD 20 EB 01 27 EB 01 24 BE 80 ?? 42 00 49 EB 01 99 8D 1D F4 00 00 00 EB 01 5C F7 D8 1B CA EB 01 31 8A 16 80 E9 41 EB 01 C2 C1 E0 0A EB 01 A1 81 EA A8 8C 18 A1 34 46 E8 01 00 00 00 62 59 32 D3 C1 C9 02 EB 01 68 80 F2 1A 0F BE C9 F7 D1 2A D3}
    condition:
        $a
}

rule PEiD_00776_FSG_1_31__Eng_____dulek_xt_
{
    meta:
        description = "[FSG 1.31 (Eng) -> dulek/xt]"
        ep_only = "false"
    strings:
        $a = {BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 BB ?? ?? ?? 00 B2 80 A4 B6 80 FF D3 73 F9 33 C9 FF D3 73 16 33 C0 FF D3 73 23 B6 80 41 B0 10 FF D3 12 C0 73 FA 75 42 AA EB E0 E8 46 00 00 00 02 F6 83 D9 01 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 48 13 C9 EB}
    condition:
        $a
}

rule PEiD_00777_FSG_1_31____dulek_xt_
{
    meta:
        description = "[FSG 1.31 -> dulek/xt]"
        ep_only = "true"
    strings:
        $a = {BE ?? ?? ?? 00 BF ?? ?? ?? 00 BB ?? ?? ?? 00 53 BB ?? ?? ?? 00 B2 80}
    condition:
        $a at pe.entry_point
}

rule PEiD_00778_FSG_1_33__Eng_____dulek_xt_
{
    meta:
        description = "[FSG 1.33 (Eng) -> dulek/xt]"
        ep_only = "true"
    strings:
        $a = {BE A4 01 40 00 AD 93 AD 97 AD 56 96 B2 80 A4 B6 80 FF 13 73 F9 33 C9 FF 13 73 16 33 C0 FF 13 73 1F B6 80 41 B0 10 FF 13 12 C0 73 FA 75 3C AA EB E0 FF 53 08 02 F6 83 D9 01 75 0E FF 53 04 EB 26 AC D1 E8 74 2F 13 C9 EB 1A 91 48 C1 E0 08 AC FF 53 04 3D 00 7D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00779_FSG_1_3_
{
    meta:
        description = "[FSG 1.3]"
        ep_only = "false"
    strings:
        $a = {BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? ?? 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00}
    condition:
        $a
}

rule PEiD_00780_FSG_v1_00__Eng_____dulek_xt_
{
    meta:
        description = "[FSG v1.00 (Eng) -> dulek/xt]"
        ep_only = "true"
    strings:
        $a = {BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 41 13 C9 EB 1C 91 48 C1 E0 08 AC E8 22 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 96 33 C9 41 FF 54 24 04 13 C9 FF 54 24 04 72 F4 C3 5F 5B 0F B7 3B 4F 74 08 4F 74 13 C1 E7 0C EB 07 8B 7B 02 57 83 C3 04 43 43 E9 51 FF FF FF 5F BB 28 ?? ?? 00 47 8B 37 AF 57 FF 13 95 33 C0 AE 75 FD FE 0F 74 EF FE 0F 75 06 47 FF 37 AF EB 09 FE 0F 0F 84 ?? ?? ?? FF 57 55 FF 53 04 09 06 AD 75 DB 8B EC C3 1C ?? ?? 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00781_FSG_v1_0_
{
    meta:
        description = "[FSG v1.0]"
        ep_only = "true"
    strings:
        $a = {BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? ?? 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00782_FSG_v1_10__Eng_____bart_xt_____Watcom_C_C___EXE__
{
    meta:
        description = "[FSG v1.10 (Eng) -> bart/xt -> (Watcom C/C++ EXE)]"
        ep_only = "true"
    strings:
        $a = {EB 02 CD 20 03 ?? 8D ?? 80 ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 02}
    condition:
        $a at pe.entry_point
}

rule PEiD_00783_FSG_v1_10__Eng_____bart_xt____WinRAR_SFX_
{
    meta:
        description = "[FSG v1.10 (Eng) -> bart/xt -> WinRAR-SFX]"
        ep_only = "true"
    strings:
        $a = {80 E9 A1 C1 C1 13 68 E4 16 75 46 C1 C1 05 5E EB 01 9D 68 64 86 37 46 EB 02 8C E0 5F F7 D0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00784_FSG_v1_10__Eng_____bart_xt____WinRAR_SFX_
{
    meta:
        description = "[FSG v1.10 (Eng) -> bart/xt -> WinRAR-SFX]"
        ep_only = "true"
    strings:
        $a = {EB 01 02 EB 02 CD 20 B8 80 ?? 42 00 EB 01 55 BE F4 00 00 00 13 DF 13 D8 0F B6 38 D1 F3 F7}
    condition:
        $a at pe.entry_point
}

rule PEiD_00785_FSG_v1_10__Eng_____bart_xt_
{
    meta:
        description = "[FSG v1.10 (Eng) -> bart/xt]"
        ep_only = "true"
    strings:
        $a = {BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 41 13 C9 EB 1C 91 48 C1 E0 08 AC E8 22 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 96 33 C9 41 FF 54 24 04 13 C9 FF 54 24 04 72 F4 C3 5F 5B 0F B7 3B 4F 74 08 4F 74 13 C1 E7 0C EB 07 8B 7B 02 57 83 C3 04 43 43 E9 52 FF FF FF 5F BB 27 ?? ?? 00 47 8B 37 AF 57 FF 13 95 33 C0 AE 75 FD FE 07 74 EF FE 07 75 06 47 FF 37 AF EB 09 FE 07 0F 84 1A ?? ?? FF 57 55 FF 53 04 09 06 AD 75 DB 8B EC C3 1B ?? ?? 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00786_FSG_v1_10__Eng_____dulek_xt_____Borland_C___1999__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Borland C++ 1999)]"
        ep_only = "true"
    strings:
        $a = {EB 02 CD 20 2B C8 68 80 ?? ?? 00 EB 02 1E BB 5E EB 02 CD 20 68 B1 2B 6E 37 40 5B 0F B6 C9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00787_FSG_v1_10__Eng_____dulek_xt_____Borland_C____
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Borland C++)]"
        ep_only = "true"
    strings:
        $a = {23 CA EB 02 5A 0D E8 02 00 00 00 6A 35 58 C1 C9 10 BE 80 ?? ?? 00 0F B6 C9 EB 02 CD 20 BB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00788_FSG_v1_10__Eng_____dulek_xt_____Borland_C____
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Borland C++)]"
        ep_only = "true"
    strings:
        $a = {23 CA EB 02 5A 0D E8 02 00 00 00 6A 35 58 C1 C9 10 BE 80 ?? ?? 00 0F B6 C9 EB 02 CD 20 BB F4 00 00 00 EB 02 04 FA EB 01 FA EB 01 5F EB 02 CD 20 8A 16 EB 02 11 31 80 E9 31 EB 02 30 11 C1 E9 11 80 EA 04 EB 02 F0 EA 33 CB 81 EA AB AB 19 08 04 D5 03 C2 80 EA 33 0F B6 C9 0F BE 0E 88 16 EB 01 5F EB 01 6B 46 EB 01 6D 0F BE C0 4B EB 02 CD 20 0F BE C9 2B C9 3B D9 75 B0 EB 01 99 C1 C1 05 91 9D B2 E3 22 E2 A1 E2 F2 22 E2 A0 ?? ?? ?? E2 35 CA EC E2 E2 E2 E4 B4 57 E7 6C F8 28 F4 B4 A5 94 62 15 BD 86 95 E4 E1 F6 06 55 DA 15 AB E1 F6 06 55 FA 15 A2 E1 F6 06 55 03 95 E4 23 92 F2 E1 F6 06 F4 A2 55 DB 57 21 8C CD BE CA 25 E2 E2 E2 0D AD 57 F2 CA 1A E2 E2 E2 CD 0A 8E B3 CA 56 23 F5 AB CD FE 73 2A A3 C2 EA 8E CA 04 E2 E2 E2 1F E2 5F E2 E2 55 EC 62 DE E7 55 E8 65 DA 61 59 E4}
    condition:
        $a at pe.entry_point
}

rule PEiD_00789_FSG_v1_10__Eng_____dulek_xt_____Borland_Delphi___Borland_C____
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Borland Delphi / Borland C++)]"
        ep_only = "true"
    strings:
        $a = {2B C2 E8 02 00 00 00 95 4A 59 8D 3D 52 F1 2A E8 C1 C8 1C BE 2E ?? ?? 18 EB 02 AB A0 03 F7}
    condition:
        $a at pe.entry_point
}

rule PEiD_00790_FSG_v1_10__Eng_____dulek_xt_____Borland_Delphi___Borland_C____
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Borland Delphi / Borland C++)]"
        ep_only = "true"
    strings:
        $a = {2B C2 E8 02 00 00 00 95 4A 59 8D 3D 52 F1 2A E8 C1 C8 1C BE 2E ?? ?? 18 EB 02 AB A0 03 F7 EB 02 CD 20 68 F4 00 00 00 0B C7 5B 03 CB 8A 06 8A 16 E8 02 00 00 00 8D 46 59 EB 01 A4 02 D3 EB 02 CD 20 02 D3 E8 02 00 00 00 57 AB 58 81 C2 AA 87 AC B9 0F BE C9 80 EA 0F E8 01 00 00 00 64 59 02 D3 EB 02 D6 5C 88 16 EB 02 CD 20 46 E8 02 00 00 00 6B B5 59 4B 0F B7 C6 0B DB 75 B1 EB 02 50 AA 91 44 5C 90 D2 95 57 9B AE E1 A4 65 ?? ?? ?? B3 09 A1 C6 BF C2 C5 CA 9D 43 D6 5E ED 20 EF B2 A6 98 69 1F CA 96 A8 FA FA 12 25 77 FF 3D D6 0F 27 3A 8C 34 52 E2 24 3C 4F A1 52 E7 39 7B ED 50 42 5A 6D 5E 0F C5 4E CD 9A 08 4C 40 4F AD 6D 70 73 A1 44 F1 8F 6A BD 88 8B 8E 7C BC 43 6B 85 14 E4 B9 72 97 CB 43 FD 79 9B C6 6D AC E9 CA CD D0 10 D6 56 DC DF 55 EF 68 E7 F3 64 FA 7A F2 7C 77 05}
    condition:
        $a at pe.entry_point
}

rule PEiD_00791_FSG_v1_10__Eng_____dulek_xt_____Borland_Delphi___Borland_C____
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Borland Delphi / Borland C++)]"
        ep_only = "true"
    strings:
        $a = {EB 01 2E EB 02 A5 55 BB 80 ?? ?? 00 87 FE 8D 05 AA CE E0 63 EB 01 75 BA 5E CE E0 63 EB 02}
    condition:
        $a at pe.entry_point
}

rule PEiD_00792_FSG_v1_10__Eng_____dulek_xt_____Borland_Delphi___Microsoft_Visual_C_____ASM__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Borland Delphi / Microsoft Visual C++ / ASM)]"
        ep_only = "true"
    strings:
        $a = {EB 02 CD 20 EB 02 CD 20 EB 02 CD 20 C1 E6 18 BB 80 ?? ?? 00 EB 02 82 B8 EB 01 10 8D 05 F4}
    condition:
        $a at pe.entry_point
}

rule PEiD_00793_FSG_v1_10__Eng_____dulek_xt_____Borland_Delphi___Microsoft_Visual_C____
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Borland Delphi / Microsoft Visual C++)]"
        ep_only = "true"
    strings:
        $a = {1B DB E8 02 00 00 00 1A 0D 5B 68 80 ?? ?? 00 E8 01 00 00 00 EA 5A 58 EB 02 CD 20 68 F4 00 00 00 EB 02 CD 20 5E 0F B6 D0 80 CA 5C 8B 38 EB 01 35 EB 02 DC 97 81 EF F7 65 17 43 E8 02 00 00 00 97 CB 5B 81 C7 B2 8B A1 0C 8B D1 83 EF 17 EB 02 0C 65 83 EF 43 13 D6 83 C7 32 F7 DA 03 FE EB 02 CD 20 87 FA 88 10 EB 02 CD 20 40 E8 02 00 00 00 F1 F8 5B 4E 2B D2 85 F6 75 AF EB 02 DE 09 EB 01 EF 34 4A 7C BC 7D 3D 7F 90 C1 82 41 ?? ?? ?? 87 DB 71 94 8B 8C 8D 90 61 05 96 1C A9 DA A7 68 5A 4A 19 CD 76 40 50 A0 9E B4 C5 15 9B D7 6E A5 BB CC 1C C2 DE 6C AC C2 D3 23 D2 65 B5 F5 65 C6 B6 CC DD CC 7B 2F B6 33 FE 6A AC 9E AB 07 C5 C6 C7 F3 94 3F DB B4 05 CE CF D0 BC FA 7F A5 BD 4A 18 EB A2 C5 F7 6D 25 9F BF E8 8D CA 05 E4 E5 E6 24 E8 66 EA EB 5F F7 6E EB F5 64 F8 76 EC 74 6D F9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00794_FSG_v1_10__Eng_____dulek_xt_____Borland_Delphi___Microsoft_Visual_C____
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Borland Delphi / Microsoft Visual C++)]"
        ep_only = "true"
    strings:
        $a = {C1 C8 10 EB 01 0F BF 03 74 66 77 C1 E9 1D 68 83 ?? ?? 77 EB 02 CD 20 5E EB 02 CD 20 2B F7}
    condition:
        $a at pe.entry_point
}

rule PEiD_00795_FSG_v1_10__Eng_____dulek_xt_____Borland_Delphi___Microsoft_Visual_C___x_
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Borland Delphi / Microsoft Visual C++)x]"
        ep_only = "true"
    strings:
        $a = {1B DB E8 02 00 00 00 1A 0D 5B 68 80 ?? ?? 00 E8 01 00 00 00 EA 5A 58 EB 02 CD 20 68 F4 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00796_FSG_v1_10__Eng_____dulek_xt_____Borland_Delphi_2_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Borland Delphi 2.0)]"
        ep_only = "true"
    strings:
        $a = {EB 01 56 E8 02 00 00 00 B2 D9 59 68 80 ?? 41 00 E8 02 00 00 00 65 32 59 5E EB 02 CD 20 BB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00797_FSG_v1_10__Eng_____dulek_xt_____MASM32___TASM32___Microsoft_Visual_Basic__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (MASM32 / TASM32 / Microsoft Visual Basic)]"
        ep_only = "true"
    strings:
        $a = {F7 D8 0F BE C2 BE 80 ?? ?? 00 0F BE C9 BF 08 3B 65 07 EB 02 D8 29 BB EC C5 9A F8 EB 01 94}
    condition:
        $a at pe.entry_point
}

rule PEiD_00798_FSG_v1_10__Eng_____dulek_xt_____MASM32___TASM32__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (MASM32 / TASM32)]"
        ep_only = "true"
    strings:
        $a = {03 F7 23 FE 33 FB EB 02 CD 20 BB 80 ?? 40 00 EB 01 86 EB 01 90 B8 F4 00 00 00 83 EE 05 2B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00799_FSG_v1_10__Eng_____dulek_xt_____MASM32___TASM32__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (MASM32 / TASM32)]"
        ep_only = "true"
    strings:
        $a = {03 F7 23 FE 33 FB EB 02 CD 20 BB 80 ?? 40 00 EB 01 86 EB 01 90 B8 F4 00 00 00 83 EE 05 2B F2 81 F6 EE 00 00 00 EB 02 CD 20 8A 0B E8 02 00 00 00 A9 54 5E C1 EE 07 F7 D7 EB 01 DE 81 E9 B7 96 A0 C4 EB 01 6B EB 02 CD 20 80 E9 4B C1 CF 08 EB 01 71 80 E9 1C EB 02 F0 49 C1 F6 09 88 0B F7 DE 0F B6 F2 43 EB 02 CD 20 C1 E7 0A 48 EB 01 89 C1 E7 14 2B FF 3B C7 75 A8 E8 01 00 00 00 81 5F F7 D7 D9 EE 1F 5E 1E DD 1E 2E 5E 1E DC ?? ?? 5E 1E 71 06 28 1E 1E 1E 20 F0 93 23 A8 34 64 30 F0 E1 D0 9E 51 F9 C2 D1 20 1D 32 42 91 16 51 E7 1D 32 42 91 36 51 DE 1D 32 42 91 3F D1 20 5F CE 2E 1D 32 42 30 DE 91 17 93 5D C8 09 FA 06 61 1E 1E 1E 49 E9 93 2E 06 56 1E 1E 1E 09 46 CA EF 06 92 5F 31 E7 09 3A AF 66 DF FE 26 CA 06 40 1E 1E 1E 5B 1E 9B 1E 1E 91 28 9E 1A 23 91 24 A1 16 9D 95 20}
    condition:
        $a at pe.entry_point
}

rule PEiD_00800_FSG_v1_10__Eng_____dulek_xt_____MASM32__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (MASM32)]"
        ep_only = "true"
    strings:
        $a = {EB 01 DB E8 02 00 00 00 86 43 5E 8D 1D D0 75 CF 83 C1 EE 1D 68 50 ?? 8F 83 EB 02 3D 0F 5A}
    condition:
        $a at pe.entry_point
}

rule PEiD_00801_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_Basic___MASM32__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual Basic / MASM32)]"
        ep_only = "true"
    strings:
        $a = {EB 02 09 94 0F B7 FF 68 80 ?? ?? 00 81 F6 8E 00 00 00 5B EB 02 11 C2 8D 05 F4 00 00 00 47}
    condition:
        $a at pe.entry_point
}

rule PEiD_00802_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_Basic_5_0___6_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual Basic 5.0 / 6.0)]"
        ep_only = "true"
    strings:
        $a = {C1 CB 10 EB 01 0F B9 03 74 F6 EE 0F B6 D3 8D 05 83 ?? ?? EF 80 F3 F6 2B C1 EB 01 DE 68 77}
    condition:
        $a at pe.entry_point
}

rule PEiD_00803_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___4_x___LCC_Win32_1_x__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 4.x / LCC Win32 1.x)]"
        ep_only = "true"
    strings:
        $a = {2C 71 1B CA EB 01 2A EB 01 65 8D 35 80 ?? ?? 00 80 C9 84 80 C9 68 BB F4 00 00 00 EB 01 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00804_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___5_0___6_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 5.0 / 6.0)]"
        ep_only = "true"
    strings:
        $a = {33 D2 0F BE D2 EB 01 C7 EB 01 D8 8D 05 80 ?? ?? ?? EB 02 CD 20 EB 01 F8 BE F4 00 00 00 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00805_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0___7_0___ASM__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0 / 7.0 / ASM)]"
        ep_only = "true"
    strings:
        $a = {E8 01 00 00 00 5A 5E E8 02 00 00 00 BA DD 5E 03 F2 EB 01 64 BB 80 ?? ?? 00 8B FA EB 01 A8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00806_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0___7_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0 / 7.0)]"
        ep_only = "true"
    strings:
        $a = {0B D0 8B DA E8 02 00 00 00 40 A0 5A EB 01 9D B8 80 ?? ?? 00 EB 02 CD 20 03 D3 8D 35 F4 00 00 00 EB 01 35 EB 01 88 80 CA 7C 80 F3 74 8B 38 EB 02 AC BA 03 DB E8 01 00 00 00 A5 5B C1 C2 0B 81 C7 DA 10 0A 4E EB 01 08 2B D1 83 EF 14 EB 02 CD 20 33 D3 83 EF 27}
    condition:
        $a at pe.entry_point
}

rule PEiD_00807_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0___7_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0 / 7.0)]"
        ep_only = "true"
    strings:
        $a = {0B D0 8B DA E8 02 00 00 00 40 A0 5A EB 01 9D B8 80 ?? ?? 00 EB 02 CD 20 03 D3 8D 35 F4 00 00 00 EB 01 35 EB 01 88 80 CA 7C 80 F3 74 8B 38 EB 02 AC BA 03 DB E8 01 00 00 00 A5 5B C1 C2 0B 81 C7 DA 10 0A 4E EB 01 08 2B D1 83 EF 14 EB 02 CD 20 33 D3 83 EF 27 EB 02 82 53 EB 02 CD 20 87 FA 88 10 80 F3 CA EB 02 CD 20 40 03 D7 0B D0 4E 1B D2 EB 02 CD 20 2B D2 3B F2 75 AC F7 DA 80 C3 AF 91 1C 31 62 A1 61 20 61 71 A1 61 1F ?? ?? ?? 61 B4 49 6B 61 61 61 63 33 D6 66 EB 77 A7 73 33 24 13 E1 94 3C 05 14 63 60 75 85 D4 59 94 2A 60 75 85 D4 79 94 21 60 75 85 D4 82 14 63 A2 11 71 60 75 85 73 21 D4 5A D6 A0 0B 4C 3D 49 A4 61 61 61 8C 2C D6 71 49 99 61 61 61 4C 89 0D 32 49 D5 A2 74 2A 4C 7D F2 A9 22 41 69 0D 49 83 61 61 61 9E 61 DE 61 61 D4 6B E1 5D 66 D4 67 E4 59 E0 D8 63}
    condition:
        $a at pe.entry_point
}

rule PEiD_00808_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0___7_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0 / 7.0)]"
        ep_only = "true"
    strings:
        $a = {0B D0 8B DA E8 02 00 00 00 40 A0 5A EB 01 9D B8 80 ?? ?? ?? EB 02 CD 20 03 D3 8D 35 F4 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00809_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0___7_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0 / 7.0)]"
        ep_only = "true"
    strings:
        $a = {87 FE E8 02 00 00 00 98 CC 5F BB 80 ?? ?? 00 EB 02 CD 20 68 F4 00 00 00 E8 01 00 00 00 E3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00810_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0___7_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0 / 7.0)]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00811_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0___7_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0 / 7.0)]"
        ep_only = "true"
    strings:
        $a = {F7 D8 40 49 EB 02 E0 0A 8D 35 80 ?? ?? ?? 0F B6 C2 EB 01 9C 8D 1D F4 00 00 00 EB 01 3C 80}
    condition:
        $a at pe.entry_point
}

rule PEiD_00812_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0___7_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0 / 7.0)]"
        ep_only = "true"
    strings:
        $a = {F7 DB 80 EA BF B9 2F 40 67 BA EB 01 01 68 AF ?? A7 BA 80 EA 9D 58 C1 C2 09 2B C1 8B D7 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_00813_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0___ASM__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0 / ASM)]"
        ep_only = "true"
    strings:
        $a = {F7 D0 EB 02 CD 20 BE BB 74 1C FB EB 02 CD 20 BF 3B ?? ?? FB C1 C1 03 33 F7 EB 02 CD 20 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_00814_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "true"
    strings:
        $a = {03 DE EB 01 F8 B8 80 ?? 42 00 EB 02 CD 20 68 17 A0 B3 AB EB 01 E8 59 0F B6 DB 68 0B A1 B3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00815_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "true"
    strings:
        $a = {03 DE EB 01 F8 B8 80 ?? 42 00 EB 02 CD 20 68 17 A0 B3 AB EB 01 E8 59 0F B6 DB 68 0B A1 B3 AB EB 02 CD 20 5E 80 CB AA 2B F1 EB 02 CD 20 43 0F BE 38 13 D6 80 C3 47 2B FE EB 01 F4 03 FE EB 02 4F 4E 81 EF 93 53 7C 3C 80 C3 29 81 F7 8A 8F 67 8B 80 C3 C7 2B FE EB 02 CD 20 57 EB 02 CD 20 5A 88 10 EB 02 CD 20 40 E8 02 00 00 00 C5 62 5A 4E E8 01 00 00 00 43 5A 2B DB 3B F3 75 B1 C1 F3 0D 92 B8 DC 0C 4E 0D B7 F7 0A 39 F4 B5 ?? ?? 36 FF 45 D9 FA FB FE FD FE CD 6B FE 82 0D 28 F3 B6 A6 A0 71 1F BA 92 9C EE DA FE 0D 47 DB 09 AE DF E3 F6 50 E4 12 9E C8 EC FB 4D EA 77 C9 03 75 E0 D2 D6 E5 E2 8B 41 B6 41 FA 70 B0 A0 AB F9 B5 C0 BF ED 78 25 CB 96 E5 A8 A7 AA A0 DC 5F 73 9D 14 F0 B5 6A 87 B7 3B E5 6D 77 B2 45 8C B9 96 95 A0 DC A2 1E 9C 9B 11 93 08 83 9B F8 9E 0A 8E 10 F7 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_00816_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "true"
    strings:
        $a = {91 EB 02 CD 20 BF 50 BC 04 6F 91 BE D0 ?? ?? 6F EB 02 CD 20 2B F7 EB 02 F0 46 8D 1D F4 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00817_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "true"
    strings:
        $a = {C1 CE 10 C1 F6 0F 68 00 ?? ?? 00 2B FA 5B 23 F9 8D 15 80 ?? ?? 00 E8 01 00 00 00 B6 5E 0B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00818_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "true"
    strings:
        $a = {D1 E9 03 C0 68 80 ?? ?? 00 EB 02 CD 20 5E 40 BB F4 00 00 00 33 CA 2B C7 0F B6 16 EB 01 3E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00819_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "true"
    strings:
        $a = {E8 01 00 00 00 0E 59 E8 01 00 00 00 58 58 BE 80 ?? ?? 00 EB 02 61 E9 68 F4 00 00 00 C1 C8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00820_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "true"
    strings:
        $a = {EB 01 4D 83 F6 4C 68 80 ?? ?? 00 EB 02 CD 20 5B EB 01 23 68 48 1C 2B 3A E8 02 00 00 00 38}
    condition:
        $a at pe.entry_point
}

rule PEiD_00821_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "true"
    strings:
        $a = {EB 02 AB 35 EB 02 B5 C6 8D 05 80 ?? ?? 00 C1 C2 11 BE F4 00 00 00 F7 DB F7 DB 0F BE 38 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00822_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "true"
    strings:
        $a = {F7 DB 80 EA BF B9 2F 40 67 BA EB 01 01 68 AF ?? ?? BA 80 EA 9D 58 C1 C2 09 2B C1 8B D7 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_00823_FSG_v1_10__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "true"
    strings:
        $a = {EB 02 CD 20 ?? CF ?? ?? 80 ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00824_FSG_v1_10__Eng_____dulek_xt_
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt]"
        ep_only = "true"
    strings:
        $a = {BB D0 01 40 ?? BF ?? 10 40 ?? BE}
    condition:
        $a at pe.entry_point
}

rule PEiD_00825_FSG_v1_10__Eng_____dulek_xt_
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt]"
        ep_only = "true"
    strings:
        $a = {E8 01 00 00 00 ?? ?? E8 ?? 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00826_FSG_v1_10__Eng_____dulek_xt_
{
    meta:
        description = "[FSG v1.10 (Eng) -> dulek/xt]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? EB 02 ?? ?? ?? 80 ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00827_FSG_v1_1_
{
    meta:
        description = "[FSG v1.1]"
        ep_only = "true"
    strings:
        $a = {BB D0 01 40 ?? BF ?? 10 40 ?? BE ?? ?? ?? ?? FC B2 80 8A 06 46 88 07 47 02 D2 75 05 8A 16}
    condition:
        $a at pe.entry_point
}

rule PEiD_00828_FSG_v1_20__Eng_____dulek_xt_____Borland_C____
{
    meta:
        description = "[FSG v1.20 (Eng) -> dulek/xt -> (Borland C++)]"
        ep_only = "true"
    strings:
        $a = {C1 F0 07 EB 02 CD 20 BE 80 ?? ?? 00 1B C6 8D 1D F4 00 00 00 0F B6 06 EB 02 CD 20 8A 16 0F B6 C3 E8 01 00 00 00 DC 59 80 EA 37 EB 02 CD 20 2A D3 EB 02 CD 20 80 EA 73 1B CF 32 D3 C1 C8 0E 80 EA 23 0F B6 C9 02 D3 EB 01 B5 02 D3 EB 02 DB 5B 81 C2 F6 56 7B F6 EB 02 56 7B 2A D3 E8 01 00 00 00 ED 58 88 16 13 C3 46 EB 02 CD 20 4B EB 02 CD 20 2B C9 3B D9 75 A1 E8 02 00 00 00 D7 6B 58 EB 00 9E 96 6A 28 67 AB 69 54 03 3E 7F ?? ?? ?? 31 0D 63 44 35 38 37 18 87 9F 10 8C 37 C6 41 80 4C 5E 8B DB 60 4C 3A 28 08 30 BF 93 05 D1 58 13 2D B8 86 AE C8 58 16 A6 95 C5 94 03 33 6F FF 92 20 98 87 9C E5 B9 20 B5 68 DE 16 4A 15 C1 7F 72 71 65 3E A9 85 20 AF 5A 59 54 26 66 E9 3F 27 DE 8E 7D 34 53 61 F7 AF 09 29 5C F7 36 83 60 5F 52 92 5C D0 56 55 C9 61 7A FD EF 7E E8 70 F8 6E 7B EF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00829_FSG_v1_20__Eng_____dulek_xt_____Borland_Delphi___Borland_C____
{
    meta:
        description = "[FSG v1.20 (Eng) -> dulek/xt -> (Borland Delphi / Borland C++)]"
        ep_only = "true"
    strings:
        $a = {0F BE C1 EB 01 0E 8D 35 C3 BE B6 22 F7 D1 68 43 ?? ?? 22 EB 02 B5 15 5F C1 F1 15 33 F7 80 E9 F9 BB F4 00 00 00 EB 02 8F D0 EB 02 08 AD 8A 16 2B C7 1B C7 80 C2 7A 41 80 EA 10 EB 01 3C 81 EA CF AE F1 AA EB 01 EC 81 EA BB C6 AB EE 2C E3 32 D3 0B CB 81 EA AB EE 90 14 2C 77 2A D3 EB 01 87 2A D3 E8 01 00 00 00 92 59 88 16 EB 02 52 08 46 EB 02 CD 20 4B 80 F1 C2 85 DB 75 AE C1 E0 04 EB 00 DA B2 82 5C 9B C7 89 98 4F 8A F7 ?? ?? ?? B1 4D DF B8 AD AC AB D4 07 27 D4 50 CF 9A D5 1C EC F2 27 77 18 40 4E A4 A8 B4 CB 9F 1D D9 EC 1F AD BC 82 AA C0 4C 0A A2 15 45 18 8F BB 07 93 BE C0 BC A3 B0 9D 51 D4 F1 08 22 62 96 6D 09 73 7E 71 A5 3A E5 7D 94 A3 96 99 98 72 B2 31 57 7B FA AE 9D 28 4F 99 EF A3 25 49 60 03 42 8B 54 53 5E 92 50 D4 52 4D C1 55 76 FD F7 8A FC 78 0C 82 87 0F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00830_FSG_v1_20__Eng_____dulek_xt_____Borland_Delphi___Microsoft_Visual_C____
{
    meta:
        description = "[FSG v1.20 (Eng) -> dulek/xt -> (Borland Delphi / Microsoft Visual C++)]"
        ep_only = "true"
    strings:
        $a = {0F B6 D0 E8 01 00 00 00 0C 5A B8 80 ?? ?? 00 EB 02 00 DE 8D 35 F4 00 00 00 F7 D2 EB 02 0E EA 8B 38 EB 01 A0 C1 F3 11 81 EF 84 88 F4 4C EB 02 CD 20 83 F7 22 87 D3 33 FE C1 C3 19 83 F7 26 E8 02 00 00 00 BC DE 5A 81 EF F7 EF 6F 18 EB 02 CD 20 83 EF 7F EB 01 F7 2B FE EB 01 7F 81 EF DF 30 90 1E EB 02 CD 20 87 FA 88 10 80 EA 03 40 EB 01 20 4E EB 01 3D 83 FE 00 75 A2 EB 02 CD 20 EB 01 C3 78 73 42 F7 35 6C 2D 3F ED 33 97 ?? ?? ?? 5D F0 45 29 55 57 55 71 63 02 72 E9 1F 2D 67 B1 C0 91 FD 10 58 A3 90 71 6C 83 11 E0 5D 20 AE 5C 71 83 D0 7B 10 97 54 17 11 C0 0E 00 33 76 85 33 3C 33 21 31 F5 50 CE 56 6C 89 C8 F7 CD 70 D5 E3 DD 08 E8 4E 25 FF 0D F3 ED EF C8 0B 89 A6 CD 77 42 F0 A6 C8 19 66 3D B2 CD E7 89 CB 13 D7 D5 E3 1E DF 5A E3 D5 50 DF B3 39 32 C0 2D B0 3F B4 B4 43}
    condition:
        $a at pe.entry_point
}

rule PEiD_00831_FSG_v1_20__Eng_____dulek_xt_____MASM32___TASM32__
{
    meta:
        description = "[FSG v1.20 (Eng) -> dulek/xt -> (MASM32 / TASM32)]"
        ep_only = "true"
    strings:
        $a = {33 C2 2C FB 8D 3D 7E 45 B4 80 E8 02 00 00 00 8A 45 58 68 02 ?? 8C 7F EB 02 CD 20 5E 80 C9 16 03 F7 EB 02 40 B0 68 F4 00 00 00 80 F1 2C 5B C1 E9 05 0F B6 C9 8A 16 0F B6 C9 0F BF C7 2A D3 E8 02 00 00 00 99 4C 58 80 EA 53 C1 C9 16 2A D3 E8 02 00 00 00 9D CE 58 80 EA 33 C1 E1 12 32 D3 48 80 C2 26 EB 02 CD 20 88 16 F7 D8 46 EB 01 C0 4B 40 8D 0D 00 00 00 00 3B D9 75 B7 EB 01 14 EB 01 0A CF C5 93 53 90 DA 96 67 54 8D CC ?? ?? 51 8E 18 74 53 82 83 80 47 B4 D2 41 FB 64 31 6A AF 7D 89 BC 0A 91 D7 83 37 39 43 50 A2 32 DC 81 32 3A 4B 97 3D D9 63 1F 55 42 F0 45 32 60 9A 28 51 61 4B 38 4B 12 E4 49 C4 99 09 47 F9 42 8C 48 51 4E 70 CF B8 12 2B 78 09 06 07 17 55 D6 EA 10 8D 3F 28 E5 02 0E A2 58 B8 D6 0F A8 E5 10 EB E8 F1 23 EF 61 E5 E2 54 EA A9 2A 22 AF 17 A1 23 97 9A 1C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00832_FSG_v1_20__Eng_____dulek_xt_____Microsoft_Visual_C___6_0___7_0__
{
    meta:
        description = "[FSG v1.20 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0 / 7.0)]"
        ep_only = "true"
    strings:
        $a = {EB 02 CD 20 EB 01 91 8D 35 80 ?? ?? 00 33 C2 68 83 93 7E 7D 0C A4 5B 23 C3 68 77 93 7E 7D EB 01 FA 5F E8 02 00 00 00 F7 FB 58 33 DF EB 01 3F E8 02 00 00 00 11 88 58 0F B6 16 EB 02 CD 20 EB 02 86 2F 2A D3 EB 02 CD 20 80 EA 2F EB 01 52 32 D3 80 E9 CD 80 EA 73 8B CF 81 C2 96 44 EB 04 EB 02 CD 20 88 16 E8 02 00 00 00 44 A2 59 46 E8 01 00 00 00 AD 59 4B 80 C1 13 83 FB 00 75 B2 F7 D9 96 8F 80 4D 0C 4C 91 50 1C 0C 50 8A ?? ?? ?? 50 E9 34 16 50 4C 4C 0E 7E 9B 49 C6 32 02 3E 7E 7B 5E 8C C5 6B 50 3F 0E 0F 38 C8 95 18 D1 65 11 2C B8 87 28 C3 4C 0B 3C AC D9 2D 15 4E 8F 1C 40 4F 28 98 3E 10 C1 45 DB 8F 06 3F EC 48 61 4C 50 50 81 DF C3 20 34 84 10 10 0C 1F 68 DC FF 24 8C 4D 29 F5 1D 2C BF 74 CF F0 24 C0 08 2E 0C 0C 10 51 0C 91 10 10 81 16 D0 54 4B D7 42 C3 54 CB C9 4E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00833_FSG_v1_20__Eng_____dulek_xt_____Microsoft_Visual_C___6_0__
{
    meta:
        description = "[FSG v1.20 (Eng) -> dulek/xt -> (Microsoft Visual C++ 6.0)]"
        ep_only = "true"
    strings:
        $a = {C1 E0 06 EB 02 CD 20 EB 01 27 EB 01 24 BE 80 ?? 42 00 49 EB 01 99 8D 1D F4 00 00 00 EB 01 5C F7 D8 1B CA EB 01 31 8A 16 80 E9 41 EB 01 C2 C1 E0 0A EB 01 A1 81 EA A8 8C 18 A1 34 46 E8 01 00 00 00 62 59 32 D3 C1 C9 02 EB 01 68 80 F2 1A 0F BE C9 F7 D1 2A D3 EB 02 42 C0 EB 01 08 88 16 80 F1 98 80 C9 28 46 91 EB 02 C0 55 4B EB 01 55 34 44 0B DB 75 AD E8 01 00 00 00 9D 59 0B C6 EB 01 6C E9 D2 C3 82 C2 03 C2 B2 82 C2 00 ?? ?? 7C C2 6F DA BC C2 C2 C2 CC 1C 3D CF 4C D8 84 D0 0C FD F0 42 77 0D 66 F1 AC C1 DE CE 97 BA D7 EB C3 AE DE 91 AA D5 02 0D 1E EE 3F 23 77 C4 01 72 12 C1 0E 1E 14 82 37 AB 39 01 88 C9 DE CA 07 C2 C2 C2 17 79 49 B2 DA 0A C2 C2 C2 A9 EA 6E 91 AA 2E 03 CF 7B 9F CE 51 FA 6D A2 AA 56 8A E4 C2 C2 C2 07 C2 47 C2 C2 17 B8 42 C6 8D 31 88 45 BA 3D 2B BC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00834_FSG_v1_2_
{
    meta:
        description = "[FSG v1.2]"
        ep_only = "true"
    strings:
        $a = {4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 ?? 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00835_FSG_v1_30__Eng_____dulek_xt_
{
    meta:
        description = "[FSG v1.30 (Eng) -> dulek/xt]"
        ep_only = "true"
    strings:
        $a = {BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 41 13 C9 EB 1C 91 48 C1 E0 08 AC E8 22 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 96 33 C9 41 FF 54 24 04 13 C9 FF 54 24 04 72 F4 C3 5F 5B 0F B7 3B 4F 74 08 4F 74 13 C1 E7 0C EB 07 8B 7B 02 57 83 C3 04 43 43 E9 52 FF FF FF 5F BB ?? ?? ?? 00 47 8B 37 AF 57 FF 13 95 33 C0 AE 75 FD FE 0F 74 EF FE 0F 75 06 47 FF 37 AF EB 09 FE 0F 0F 84 ?? ?? ?? FF 57 55 FF 53 04 09 06 AD 75 DB 8B EC C3 ?? ?? ?? 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00836_FSG_v1_31__Eng_____dulek_xt_
{
    meta:
        description = "[FSG v1.31 (Eng) -> dulek/xt]"
        ep_only = "true"
    strings:
        $a = {BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 BB ?? ?? ?? 00 B2 80 A4 B6 80 FF D3 73 F9 33 C9 FF D3 73 16 33 C0 FF D3 73 23 B6 80 41 B0 10 FF D3 12 C0 73 FA 75 42 AA EB E0 E8 46 00 00 00 02 F6 83 D9 01 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 48 13 C9 EB 1C 91 48 C1 E0 08 AC E8 22 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B6 00 56 8B F7 2B F0 F3 A4 5E EB 97 33 C9 41 FF D3 13 C9 FF D3 72 F8 C3 02 D2 75 05 8A 16 46 12 D2 C3 5B 5B 0F B7 3B 4F 74 08 4F 74 13 C1 E7 0C EB 07 8B 7B 02 57 83 C3 04 43 43 E9 58 FF FF FF 5F BB ?? ?? ?? 00 47 8B 37 AF 57 FF 13 95 33 C0 AE 75 FD FE 0F 74 EF FE 0F 75 06 47 FF 37 AF EB 09 FE 0F 0F 84 ?? ?? ?? FF 57 55 FF 53 04 89 06 AD 85 C0 75 D9 8B EC C3 ?? ?? ?? 00 00 00 00 00 00 00 00 00 88 01 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00837_FSG_v1_31_
{
    meta:
        description = "[FSG v1.31]"
        ep_only = "true"
    strings:
        $a = {BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? ?? 53 BB ?? ?? ?? ?? B2 80 A4 B6 80 FF D3 73 F9 33 C9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00838_FSG_v1_33__Eng_____dulek_xt_
{
    meta:
        description = "[FSG v1.33 (Eng) -> dulek/xt]"
        ep_only = "true"
    strings:
        $a = {BE A4 01 40 00 AD 93 AD 97 AD 56 96 B2 80 A4 B6 80 FF 13 73 F9 33 C9 FF 13 73 16 33 C0 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00839_FSG_v1_33__Eng_____dulek_xt_
{
    meta:
        description = "[FSG v1.33 (Eng) -> dulek/xt]"
        ep_only = "true"
    strings:
        $a = {BE A4 01 40 00 AD 93 AD 97 AD 56 96 B2 80 A4 B6 80 FF 13 73 F9 33 C9 FF 13 73 16 33 C0 FF 13 73 1F B6 80 41 B0 10 FF 13 12 C0 73 FA 75 3C AA EB E0 FF 53 08 02 F6 83 D9 01 75 0E FF 53 04 EB 26 AC D1 E8 74 2F 13 C9 EB 1A 91 48 C1 E0 08 AC FF 53 04 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B6 00 56 8B F7 2B F0 F3 A4 5E EB 9D 8B D6 5E AD 48 74 0A 79 02 AD 50 56 8B F2 97 EB 87 AD 93 5E 46 AD 97 56 FF 13 95 AC 84 C0 75 FB FE 0E 74 F0 79 05 46 AD 50 EB 09 FE 0E 0F 84 ?? ?? ?? FF 56 55 FF 53 04 AB EB E0 33 C9 41 FF 13 13 C9 FF 13 72 F8 C3 02 D2 75 05 8A 16 46 12 D2 C3 ?? ?? ?? 00 00 00 00 00 00 00 00 00 54 01 00 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 61 01 00 00 6F 01 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00840_FSG_v1_33_
{
    meta:
        description = "[FSG v1.33]"
        ep_only = "true"
    strings:
        $a = {BE A4 01 40 00 AD 93 AD 97 AD 56 96 B2 80 A4 B6 80 FF 13 73}
    condition:
        $a at pe.entry_point
}

rule PEiD_00841_FSG_v1_3_
{
    meta:
        description = "[FSG v1.3]"
        ep_only = "true"
    strings:
        $a = {BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? ?? 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 41 13 C9 EB 1C 91 48 C1 E0 08 AC E8 22 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 96 33 C9 41 FF 54 24 04 13 C9 FF 54 24 04 72 F4 C3 5F 5B 0F B7 3B 4F 74 08 4F 74 13 C1 E7 0C EB 07 8B 7B 02 57 83 C3 04 43 43 E9 52 FF FF FF 5F BB ?? ?? ?? ?? 47 8B 37 AF 57 FF 13 95 33 C0 AE 75 FD FE 0F 74 EF FE}
    condition:
        $a at pe.entry_point
}

rule PEiD_00842_FSG_v1_3_
{
    meta:
        description = "[FSG v1.3]"
        ep_only = "false"
    strings:
        $a = {BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? ?? 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 41 13 C9 EB 1C 91 48 C1 E0 08 AC E8 22 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 96 33 C9 41 FF 54 24 04 13 C9 FF 54 24 04 72 F4 C3 5F 5B 0F B7 3B 4F 74 08 4F 74 13 C1 E7 0C EB 07 8B 7B 02 57 83 C3 04 43 43 E9 52 FF FF FF 5F BB ?? ?? ?? ?? 47 8B 37 AF 57 FF 13 95 33 C0 AE 75 FD FE ?? 74 EF FE}
    condition:
        $a
}

rule PEiD_00843_FSG_v2_0____bart_xt_
{
    meta:
        description = "[FSG v2.0 -> bart/xt]"
        ep_only = "true"
    strings:
        $a = {87 25 ?? ?? ?? 00 61 94 55 A4 B6 80 FF 13}
    condition:
        $a at pe.entry_point
}

rule PEiD_00844_FSG_v2_0_
{
    meta:
        description = "[FSG v2.0]"
        ep_only = "false"
    strings:
        $a = {87 25 ?? ?? ?? ?? 61 94 55 A4 B6 80 FF 13 73 F9 33 C9 FF 13 73 16 33 C0 FF 13 73 1F B6 80 41 B0 10 FF 13 12 C0 73 FA 75}
    condition:
        $a
}

rule PEiD_00845_Fuck_n_Joy_1_0c____UsAr_
{
    meta:
        description = "[Fuck'n'Joy 1.0c -> UsAr]"
        ep_only = "false"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED D8 05 40 00 FF 74 24 20 E8 8C 02 00 00 0B C0 0F 84 2C 01 00 00 89 85 6C 08 40 00 8D 85 2F 08 40 00 50 FF B5 6C 08 40 00 E8 EF 02 00 00 0B C0 0F 84 0C 01 00 00 89 85 3B 08 40 00 8D 85 3F 08 40 00 50 FF B5 6C 08 40 00 E8 CF 02 00}
    condition:
        $a
}

rule PEiD_00846_Fuck_n_Joy_v1_0c____UsAr_
{
    meta:
        description = "[Fuck'n'Joy v1.0c -> UsAr]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED D8 05 40 00 FF 74 24 20 E8 8C 02 00 00 0B C0 0F 84 2C 01 00 00 89 85 6C 08 40 00 8D 85 2F 08 40 00 50 FF B5 6C 08 40 00 E8 EF 02 00 00 0B C0 0F 84 0C 01 00 00 89 85 3B 08 40 00 8D 85 3F 08 40 00 50 FF B5 6C 08 40 00 E8 CF 02 00 00 0B C0 0F 84 EC 00 00 00 89 85 4D 08 40 00 8D 85 51 08 40 00 50 FF B5 6C 08 40 00 E8 AF 02 00 00 0B C0 0F 84 CC 00 00 00 89 85 5C 08 40 00 8D 85 67 07 40 00 E8 7B 02 00 00 8D B5 C4 07 40 00 56 6A 64 FF 95 74 07 40 00 46 80 3E 00 75 FA C7 06 74 6D 70 2E 83 C6 04 C7 06 65 78 65 00 8D 85 36 07 40 00 E8 4C 02 00 00 33 DB 53 53 6A 02 53 53 68 00 00 00 40 8D 85 C4 07 40 00 50 FF 95 74 07 40 00 89 85 78 07 40 00 8D 85 51 07 40 00 E8 21 02 00 00 6A 00 8D 85 7C 07 40 00 50 68 00 ?? ?? 00 8D 85 F2 09 40 00 50 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00847_Fusion_1_0____jaNooNi_
{
    meta:
        description = "[Fusion 1.0 -> jaNooNi]"
        ep_only = "true"
    strings:
        $a = {68 04 30 40 00 68 04 30 40 00 E8 09 03 00 00 68 04 30 40 00 E8 C7 02 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00848_G_X_Protector_1_2____Guru_eXe_
{
    meta:
        description = "[G!X Protector 1.2 -> Guru.eXe]"
        ep_only = "true"
    strings:
        $a = {60 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00849_GameGuard___nProtect_
{
    meta:
        description = "[GameGuard - nProtect]"
        ep_only = "true"
    strings:
        $a = {31 FF 74 06 61 E9 4A 4D 50 30 5A BA 7D 00 00 00 80 7C 24 08 01 E9 00 00 00 00 60 BE ?? ?? ?? ?? 31 FF 74 06 61 E9 4A 4D 50 30 8D BE ?? ?? ?? ?? 31 C9 74 06 61 E9 4A 4D 50 30 B8 7D 00 00 00 39 C2 B8 4C 00 00 00 F7 D0 75 3F 64 A1 30 00 00 00 85 C0 78 23 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00850_GameGuard___nProtect_
{
    meta:
        description = "[GameGuard - nProtect]"
        ep_only = "true"
    strings:
        $a = {31 FF 74 06 61 E9 4A 4D 50 30 5A BA 7D 00 00 00 80 7C 24 08 01 E9 00 00 00 00 60 BE ?? ?? ?? ?? 31 FF 74 06 61 E9 4A 4D 50 30 8D BE ?? ?? ?? ?? 31 C9 74 06 61 E9 4A 4D 50 30 B8 7D 00 00 00 39 C2 B8 4C 00 00 00 F7 D0 75 3F 64 A1 30 00 00 00 85 C0 78 23 8B 40 0C 8B 40 0C C7 40 20 00 10 00 00 64 A1 18 00 00 00 8B 40 30 0F B6 40 02 85 C0 75 16 E9 12 00 00 00 31 C0 64 A0 20 00 00 00 85 C0 75 05 E9 01 00 00 00 61 57 83 CD FF EB 0B 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07}
    condition:
        $a at pe.entry_point
}

rule PEiD_00851_GameGuard_v2006_5_x_x____dll__
{
    meta:
        description = "[GameGuard v2006.5.x.x (*.dll)]"
        ep_only = "true"
    strings:
        $a = {31 FF 74 06 61 E9 4A 4D 50 30 BA 4C 00 00 00 80 7C 24 08 01 0F 85 ?? 01 00 00 60 BE 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00852_GameGuard_v2006_5_x_x____exe__
{
    meta:
        description = "[GameGuard v2006.5.x.x (*.exe)]"
        ep_only = "true"
    strings:
        $a = {31 FF 74 06 61 E9 4A 4D 50 30 5A BA 7D 00 00 00 80 7C 24 08 01 E9 00 00 00 00 60 BE 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00853_Gamehouse_Media_Protector_Version_Unknown_
{
    meta:
        description = "[Gamehouse Media Protector Version Unknown]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00854_Gardian_Angel_1_0_
{
    meta:
        description = "[Gardian Angel 1.0]"
        ep_only = "true"
    strings:
        $a = {06 8C C8 8E D8 8E C0 FC BF ?? ?? EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00855_Gentee_Installer_Custom_
{
    meta:
        description = "[Gentee Installer Custom]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 14 04 00 00 53 56 57 6A 00 FF 15 08 41 40 00 68 00 50 40 00 FF 15 04 41 40 00 85 C0 74 29 6A 00 A1 00 20 40 00 ?? ?? ?? ?? 41 40 00 8B F0 6A 06 56 FF 15 1C 41 40 00 6A 03 56 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00856_GHF_Protector__pack_only_____GPcH_
{
    meta:
        description = "[GHF Protector (pack only) -> GPcH]"
        ep_only = "true"
    strings:
        $a = {60 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 68 00 00 00 00 6A 40 FF D0 89 05 ?? ?? ?? ?? 89 C7 BE ?? ?? ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41}
    condition:
        $a at pe.entry_point
}

rule PEiD_00857_GHF_Protector__pack_only_____GPcH_
{
    meta:
        description = "[GHF Protector (pack only) -> GPcH]"
        ep_only = "true"
    strings:
        $a = {60 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 68 00 00 00 00 6A 40 FF D0 89 05 ?? ?? ?? ?? 89 C7 BE ?? ?? ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 89 E8 B3 01 56 89 FE 29 C6 F3 A4 5E EB 8E 00 D2 75 05 8A 16 46 10 D2 C3 31 C9 41 E8 EE FF FF FF 11 C9 E8 E7 FF FF FF 72 F2 C3 61 B9 FC FF FF FF 8B 1C 08 89 99 ?? ?? ?? ?? E2 F5 90 90 BA ?? ?? ?? ?? BE ?? ?? ?? ?? 01 D6 8B 46 0C 85 C0 0F 84 87 00 00 00 01 D0 89 C3 50 B8 ?? ?? ?? ?? FF 10 85 C0 75 08 53 B8 ?? ?? ?? ?? FF 10 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 BA ?? ?? ?? ?? 8B 06 85 C0 75 03 8B 46 10 01 D0 03 05 ?? ?? ?? ?? 8B 18 8B 7E 10 01 D7 03 3D ?? ?? ?? ?? 85 DB 74 2B F7 C3 00 00 00 80 75 04 01 D3 43 43 81 E3 FF FF FF 0F 53 FF 35 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 89 07 83 05 ?? ?? ?? ?? 04 EB AE 83 C6 14 BA ?? ?? ?? ?? E9 6E FF FF FF 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 8B 15 ?? ?? ?? ?? 52 FF D0 61 BA ?? ?? ?? ?? FF E2 90 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00858_GHF_Protector__pack____GPcH_
{
    meta:
        description = "[GHF Protector (pack) / GPcH]"
        ep_only = "true"
    strings:
        $a = {60 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 68 00 A0 00 00 6A 40 FF D0 89 05 ?? ?? ?? ?? 89 C7 BE ?? ?? ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6}
    condition:
        $a at pe.entry_point
}

rule PEiD_00859_Gleam_1_00_
{
    meta:
        description = "[Gleam 1.00]"
        ep_only = "false"
    strings:
        $a = {83 EC 0C 53 56 57 E8 24 02 00}
    condition:
        $a
}

rule PEiD_00860_Go32Stub_v_2_00_DOS_Extender_
{
    meta:
        description = "[Go32Stub v.2.00 DOS-Extender]"
        ep_only = "true"
    strings:
        $a = {0E 1F 8C 1E ?? ?? 8C 06 ?? ?? FC B4 30 CD 21 80}
    condition:
        $a at pe.entry_point
}

rule PEiD_00861_Go32Stub_v_2_00T_DOS_Extender_
{
    meta:
        description = "[Go32Stub v.2.00T DOS-Extender]"
        ep_only = "true"
    strings:
        $a = {0E 1F 8C 1E ?? ?? 8C 06 ?? ?? FC B4 30 CD 21 3C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00862_Goat_s_PE_Mutilator_1_6_
{
    meta:
        description = "[Goat's PE Mutilator 1.6]"
        ep_only = "true"
    strings:
        $a = {E8 EA 0B 00 00 ?? ?? ?? 8B 1C 79 F6 63 D8 8D 22 B0 BF F6 49 08 C3 02 BD 3B 6C 29 46 13 28 5D 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00863_Goat_s_PE_Mutilator_1_6_
{
    meta:
        description = "[Goat's PE Mutilator 1.6]"
        ep_only = "true"
    strings:
        $a = {E8 EA 0B 00 00 ?? ?? ?? 8B 1C 79 F6 63 D8 8D 22 B0 BF F6 49 08 C3 02 BD 3B 6C 29 46 13 28 5D 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0F 53 0F DE 0F 55 0F 60 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00864_Goats_Mutilator_v1_6____Goat__e0f_
{
    meta:
        description = "[Goats Mutilator v1.6 -> Goat/_e0f]"
        ep_only = "true"
    strings:
        $a = {E8 EA 0B 00 00 ?? ?? ?? 8B 1C 79 F6 63 D8 8D 22 B0 BF F6 49 08 C3 02 BD 3B 6C 29 46 13 28 5D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00865_GP_Install_v5_0_3_32_
{
    meta:
        description = "[GP-Install v5.0.3.32]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 57 B8 C4 1C 41 00 E8 6B 3E FF FF 33 C0 55 68 76 20 41 00 64 FF 30 64 89 20 BA A0 47 41 00 33 C0 E8 31 0A FF FF 33 D2 A1 A0}
    condition:
        $a
}

rule PEiD_00866_Guardant_Stealth_aka_Novex_Dongle_
{
    meta:
        description = "[Guardant Stealth aka Novex Dongle]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 60 E8 51 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00867_HACKSTOP_v1_00_
{
    meta:
        description = "[HACKSTOP v1.00]"
        ep_only = "true"
    strings:
        $a = {FA BD ?? ?? FF E5 6A 49 48 0C ?? E4 ?? 3F 98 3F}
    condition:
        $a at pe.entry_point
}

rule PEiD_00868_HACKSTOP_v1_10__v1_11_
{
    meta:
        description = "[HACKSTOP v1.10, v1.11]"
        ep_only = "true"
    strings:
        $a = {B4 30 CD 21 86 E0 3D ?? ?? 73 ?? B4 2F CD 21 B0 ?? B4 4C CD 21 50 B8 ?? ?? 58 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00869_HACKSTOP_v1_10p1_
{
    meta:
        description = "[HACKSTOP v1.10p1]"
        ep_only = "true"
    strings:
        $a = {B4 30 CD 21 86 E0 3D 00 03 73 ?? B4 2F CD 21 B4 2A CD 21 B4 2C CD 21 B0 FF B4 4C CD 21 50 B8 ?? ?? 58 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00870_HACKSTOP_v1_11c_
{
    meta:
        description = "[HACKSTOP v1.11c]"
        ep_only = "true"
    strings:
        $a = {B4 30 CD 21 86 E0 3D ?? ?? 73 ?? B4 ?? CD 21 B0 ?? B4 4C CD 21 53 BB ?? ?? 5B EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00871_HACKSTOP_v1_13_
{
    meta:
        description = "[HACKSTOP v1.13]"
        ep_only = "true"
    strings:
        $a = {52 B8 ?? ?? 1E CD 21 86 E0 3D ?? ?? 73 ?? CD 20 0E 1F B4 09 E8 ?? ?? 24 ?? EA}
    condition:
        $a at pe.entry_point
}

rule PEiD_00872_HACKSTOP_v1_18_
{
    meta:
        description = "[HACKSTOP v1.18]"
        ep_only = "true"
    strings:
        $a = {52 BA ?? ?? 5A EB ?? 9A ?? ?? ?? ?? 30 CD 21 ?? ?? ?? FD 02 ?? ?? CD 20 0E 1F 52 BA ?? ?? 5A EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00873_HACKSTOP_v1_19_
{
    meta:
        description = "[HACKSTOP v1.19]"
        ep_only = "true"
    strings:
        $a = {52 BA ?? ?? 5A EB ?? 9A ?? ?? ?? ?? 30 CD 21 ?? ?? ?? D6 02 ?? ?? CD 20 0E 1F 52 BA ?? ?? 5A EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00874_Hardlock_dongle__Alladin__
{
    meta:
        description = "[Hardlock dongle (Alladin)]"
        ep_only = "true"
    strings:
        $a = {5C 5C 2E 5C 48 41 52 44 4C 4F 43 4B 2E 56 58 44 00 00 00 00 5C 5C 2E 5C 46 45 6E 74 65 44 65 76}
    condition:
        $a at pe.entry_point
}

rule PEiD_00875_Hasp_4_envelope_dongle__Alladin__
{
    meta:
        description = "[Hasp 4 envelope dongle (Alladin)]"
        ep_only = "true"
    strings:
        $a = {10 02 D0 51 0F 00 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_00876_Hasp_dongle__Alladin__
{
    meta:
        description = "[Hasp dongle (Alladin)]"
        ep_only = "true"
    strings:
        $a = {50 53 51 52 57 56 8B 75 1C 8B 3E ?? ?? ?? ?? ?? 8B 5D 08 8A FB ?? ?? 03 5D 10 8B 45 0C 8B 4D 14 8B 55 18 80 FF 32}
    condition:
        $a at pe.entry_point
}

rule PEiD_00877_HASP_HL_Protection_1_X____Aladdin_
{
    meta:
        description = "[HASP HL Protection 1.X -> Aladdin]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 53 56 57 60 8B C4 A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 15 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 83 C4 04 E9 A5 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15}
    condition:
        $a
}

rule PEiD_00878_HASP_HL_Protection_V1_X____Aladdin___Sign_by_fly_
{
    meta:
        description = "[HASP HL Protection V1.X -> Aladdin ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 56 57 60 8B C4 A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 15 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 83 C4 04 E9 A5 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 15}
    condition:
        $a at pe.entry_point
}

rule PEiD_00879_HEALTH_v_5_1_by_Muslim_M_Polyak_
{
    meta:
        description = "[HEALTH v.5.1 by Muslim M.Polyak]"
        ep_only = "true"
    strings:
        $a = {1E E8 ?? ?? 2E 8C 06 ?? ?? 2E 89 3E ?? ?? 8B D7 B8 ?? ?? CD 21 8B D8 0E 1F E8 ?? ?? 06 57 A1 ?? ?? 26}
    condition:
        $a at pe.entry_point
}

rule PEiD_00880_Hide_PE_1_01____BGCorp_
{
    meta:
        description = "[Hide PE 1.01 -> BGCorp]"
        ep_only = "true"
    strings:
        $a = {?? BA ?? ?? ?? 00 B8 ?? ?? ?? ?? 89 02 83 C2 04 B8 ?? ?? ?? ?? 89 02 83 C2 04 B8 ?? ?? ?? ?? 89 02 83 C2 F8 FF E2 0D 0A 2D 3D 5B 20 48 69 64 65 50 45 20 62 79 20 42 47 43 6F 72 70 20 5D 3D 2D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00881_Hide_Protect_1_016____SoftWar_Company_
{
    meta:
        description = "[Hide&Protect 1.016 -> SoftWar Company]"
        ep_only = "true"
    strings:
        $a = {90 90 90 E9 D8 ?? 05 00 95 ?? 53 00 95 4A 50 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00882_Hide_Protect_V1_0X___SoftWar_Company_
{
    meta:
        description = "[Hide&Protect V1.0X-> SoftWar Company]"
        ep_only = "true"
    strings:
        $a = {90 90 90 E9 D8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00883_Histogram_graphics_file_
{
    meta:
        description = "[Histogram graphics file]"
        ep_only = "false"
    strings:
        $a = {6D 68 77 61 6E 68 00 04 01 02 01 02}
    condition:
        $a
}

rule PEiD_00884_Hitachi_Raster_Format_graphics_format_
{
    meta:
        description = "[Hitachi Raster Format graphics format]"
        ep_only = "false"
    strings:
        $a = {43 41 44 43 2F 4B 52 20 52 53 54}
    condition:
        $a
}

rule PEiD_00885_hmimys_protect_0_1____hmimys_
{
    meta:
        description = "[hmimys protect 0.1 -> hmimys]"
        ep_only = "false"
    strings:
        $a = {5E 83 C6 64 AD 50 AD 50 83 EE 6C AD 50 AD 50 AD 50 AD 50 AD 50 E8}
    condition:
        $a
}

rule PEiD_00886_hmimys_Protect_v1_0_
{
    meta:
        description = "[hmimys Protect v1.0]"
        ep_only = "true"
    strings:
        $a = {E8 BA 00 00 00 ?? 00 00 00 00 ?? ?? 00 00 10 40 00 ?? ?? ?? 00 ?? ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00887_hmimys_Protect_v1_0_
{
    meta:
        description = "[hmimys Protect v1.0]"
        ep_only = "true"
    strings:
        $a = {E8 BA 00 00 00 ?? 00 00 00 00 ?? ?? 00 00 10 40 00 ?? ?? ?? 00 ?? ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 5E 83 C6 64 AD 50 AD 50 83 EE 6C AD 50 AD 50 AD 50 AD 50 AD 50 E8 E7 07 00 00 AD 8B DE 8B F0 83 C3 44 AD 85 C0 74 32 8B F8 56 FF 13 8B E8 AC 84 C0 75 FB AC 84 C0 74 EA 4E AD A9 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00888_hmimys_Protect_v1_0_
{
    meta:
        description = "[hmimys Protect v1.0]"
        ep_only = "true"
    strings:
        $a = {E8 BA 00 00 00 ?? 00 00 00 00 ?? ?? 00 00 10 40 00 ?? ?? ?? 00 ?? ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 5E 83 C6 64 AD 50 AD 50 83 EE 6C AD 50 AD 50 AD 50 AD 50 AD 50 E8 E7 07 00 00 AD 8B DE 8B F0 83 C3 44 AD 85 C0 74 32 8B F8 56 FF 13 8B E8 AC 84 C0 75 FB AC 84 C0 74 EA 4E AD A9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00889_hmimys_s_PE_Pack_0_1____hmimys_
{
    meta:
        description = "[hmimys's PE-Pack 0.1 -> hmimys]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 5D 83 ED 05 6A 00 FF 95 E1 0E 00 00 89 85 85 0E 00 00 8B 58 3C 03 D8 81 C3 F8 00 00 00 80 AD 89 0E 00 00 01 89 9D 63 0F 00 00 8B 4B 0C 03 8D 85 0E 00 00 8B 53 08 80 BD 89 0E 00 00 00 75 0C 03 8D 91 0E 00 00 2B 95 91 0E 00 00 89 8D 57 0F 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00890_hmimys_s_PE_Pack_0_1____hmimys_
{
    meta:
        description = "[hmimys's PE-Pack 0.1 -> hmimys]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 5D 83 ED 05 6A 00 FF 95 E1 0E 00 00 89 85 85 0E 00 00 8B 58 3C 03 D8 81 C3 F8 00 00 00 80 AD 89 0E 00 00 01 89 9D 63 0F 00 00 8B 4B 0C 03 8D 85 0E 00 00 8B 53 08 80 BD 89 0E 00 00 00 75 0C 03 8D 91 0E 00 00 2B 95 91 0E 00 00 89 8D 57 0F 00 00 89 95 5B 0F 00 00 8B 5B 10 89 9D 5F 0F 00 00 8B 9D 5F 0F 00 00 8B 85 57 0F 00 00 53 50 E8 B7 0B 00 00 89 85 73 0F 00 00 6A 04 68 00 10 00 00 50 6A 00 FF 95 E9 0E 00 00 89 85 6B 0F 00 00 6A 04 68 00 10 00 00 68 D8 7C 00 00 6A 00 FF 95 E9 0E 00 00 89 85 6F 0F 00 00 8D 85 67 0F 00 00 8B 9D 73 0F 00 00 8B 8D 6B 0F 00 00 8B 95 5B 0F 00 00 83 EA 0E 8B B5 57 0F 00 00 83 C6 0E 8B BD 6F 0F 00 00 50 53 51 52 56 68 D8 7C 00 00 57 E8 01 01 00 00 8B 9D 57 0F 00 00 8B 03 3C 01 75}
    condition:
        $a at pe.entry_point
}

rule PEiD_00891_hmimys_Packer_1_0____hmimys_
{
    meta:
        description = "[hmimys-Packer 1.0 -> hmimys]"
        ep_only = "false"
    strings:
        $a = {5E 83 C6 64 AD 50 AD 50 83 EE 6C AD 50 AD 50 AD 50 AD 50 AD 50 E8 E7 07 00 00}
    condition:
        $a
}

rule PEiD_00892_hmimys_Packer_1_0____hmimys_
{
    meta:
        description = "[hmimys-Packer 1.0 -> hmimys]"
        ep_only = "false"
    strings:
        $a = {5E 83 C6 64 AD 50 AD 50 83 EE 6C AD 50 AD 50 AD 50 AD 50 AD 50 E8 E7 07}
    condition:
        $a
}

rule PEiD_00893_hmimys_Packer_1_0_
{
    meta:
        description = "[hmimys-Packer 1.0]"
        ep_only = "true"
    strings:
        $a = {E8 BA 00 00 00 03 00 00 00 00 ?? ?? 00 00 10 40 00 ?? ?? ?? 00 ?? ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00894_HPA_
{
    meta:
        description = "[HPA]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? 5E 8B D6 83 ?? ?? 83 ?? ?? 06 0E 1E 0E 1F 33 FF 8C D3}
    condition:
        $a at pe.entry_point
}

rule PEiD_00895_HQR_data_file_
{
    meta:
        description = "[HQR data file]"
        ep_only = "false"
    strings:
        $a = {48 00 00 00 ?? 02 00 00 ?? ?? 00 00 ?? ?? 00 00}
    condition:
        $a
}

rule PEiD_00896_hying_s_PE_Armor____hying_CCG_
{
    meta:
        description = "[hying's PE-Armor -> hying[CCG]"
        ep_only = "true"
    strings:
        $a = {E8 AA 00 00 00 2D ?? ?? ?? 00 00 00 00 00 00 00 00 3D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00897_Hying_s_PE_Armor_0_75_exe____Hying__CCG_
{
    meta:
        description = "[Hying's PE-Armor 0.75.exe -> Hying [CCG]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? 00 00 00 00 00 00 ?? ?? 01 00 00 00 00 00 00 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 74 ?? ?? ?? 00 00 00 00 00 00 00 00 84 ?? ?? ?? 74 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 00 08 00 00 00 00 00 00 00 60 E8 00 00 00 00 5D 81 ED D7 00 00 00 8D B5 EE 00 00 00 55 56 81 C5 ?? ?? 00 00 55 C3}
    condition:
        $a
}

rule PEiD_00898_Hying_s_PE_Armor_0_75_exe____Hying__CCG__
{
    meta:
        description = "[Hying's PE-Armor 0.75.exe -> Hying [CCG]]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? 00 00 00 00 00 00 ?? ?? 01 00 00 00 00 00 00 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 74 ?? ?? ?? 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_00899_Hying_s_PE_Armor_0_75_exe____Hying_
{
    meta:
        description = "[Hying's PE-Armor 0.75.exe -> Hying]"
        ep_only = "false"
    strings:
        $a = {E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8E 00 00 00 E8 03 00 00 00 EB 01 ?? E8 81 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B7 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AA 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75}
    condition:
        $a
}

rule PEiD_00900_Hying_s_PE_Armor_0_76____Hying__CCG_
{
    meta:
        description = "[Hying's PE-Armor 0.76 -> Hying [CCG]"
        ep_only = "false"
    strings:
        $a = {01 00 ?? ?? 00 00 00 00 00 00 00 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 56 69 72 74 75 61 6C 46 72 65 65 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 61 ?? ?? ?? 59 ?? ?? ?? ?? 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 8D ?? ?? ?? ?? 00 00 00 00 00 00 00 9D ?? ?? ?? 8D ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 00 08 00 00 00 00 00 00 00 60 E8 00 00 00 00 5D 81 ED F0 00 00 00 8D B5 07 01 00 00 55 56 81 C5 ?? ?? ?? ?? 55 C3}
    condition:
        $a
}

rule PEiD_00901_hying_s_PEArmor_V0_76____hying_
{
    meta:
        description = "[hying's PEArmor V0.76 -> hying]"
        ep_only = "true"
    strings:
        $a = {E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A ?? E8 A3 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00902_IBM_PictureMaker_graphics_file_
{
    meta:
        description = "[IBM PictureMaker graphics file]"
        ep_only = "false"
    strings:
        $a = {00 ?? C1 ?? 00 ?? ?? ?? ?? 02 00 01}
    condition:
        $a
}

rule PEiD_00903_ICrypt_1_0___by_BuGGz_
{
    meta:
        description = "[ICrypt 1.0 - by BuGGz]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 EC 53 56 57 33 C0 89 45 EC B8 70 3B 00 10 E8 3C FA FF FF 33 C0 55 68 6C 3C 00 10 64 FF 30 64 89 20 6A 0A 68 7C 3C 00 10 A1 50 56 00 10 50 E8 D8 FA FF FF 8B D8 53 A1 50 56 00 10 50 E8 0A FB FF FF 8B F8 53 A1 50 56 00 10 50 E8 D4 FA FF FF 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00904_ICrypt_1_0___by_BuGGz_
{
    meta:
        description = "[ICrypt 1.0 - by BuGGz]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 EC 53 56 57 33 C0 89 45 EC B8 70 3B 00 10 E8 3C FA FF FF 33 C0 55 68 6C 3C 00 10 64 FF 30 64 89 20 6A 0A 68 7C 3C 00 10 A1 50 56 00 10 50 E8 D8 FA FF FF 8B D8 53 A1 50 56 00 10 50 E8 0A FB FF FF 8B F8 53 A1 50 56 00 10 50 E8 D4 FA FF FF 8B D8 53 E8 D4 FA FF FF 8B F0 85 F6 74 26 8B D7 4A B8 64 56 00 10 E8 25 F6 FF FF B8 64 56 00 10 E8 13 F6 FF FF 8B CF 8B D6 E8 E6 FA FF FF 53 E8 90 FA FF FF 8D 4D EC BA 8C 3C 00 10 A1 64 56 00 10 E8 16 FB FF FF 8B 55 EC B8 64 56 00 10 E8 C5 F4 FF FF B8 64 56 00 10 E8 DB F5 FF FF E8 56 FC FF FF 33 C0 5A 59 59 64 89 10 68 73 3C 00 10 8D 45 EC E8 4D F4 FF FF C3 E9 E3 EE FF FF EB F0 5F 5E 5B E8 4D F3 FF FF 00 53 45 54 ?? ?? ?? ?? 00 FF FF FF FF 08 00 00 00 76 6F 74 72 65 63 6C 65}
    condition:
        $a at pe.entry_point
}

rule PEiD_00905_ID_Application_Protector_V1_2____ID_Security_Suite___Sign_by_fly_
{
    meta:
        description = "[ID Application Protector V1.2 -> ID Security Suite ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED F2 0B 47 00 B9 19 22 47 00 81 E9 EA 0E 47 00 89 EA 81 C2 EA 0E 47 00 8D 3A 89 FE 31 C0 E9 D3 02 00 00 CC CC CC CC E9 CA 02 00 00 43 3A 5C 57 69 6E 64 6F 77 73 5C 53 6F 66 74 57 61 72 65 50 72 6F 74 65 63 74 6F 72 5C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00906_ILUCRYPT_v4_015__exe_
{
    meta:
        description = "[ILUCRYPT v4.015 [exe]"
        ep_only = "true"
    strings:
        $a = {8B EC FA C7 46 F7 ?? ?? 42 81 FA ?? ?? 75 F9 FF 66 F7}
    condition:
        $a at pe.entry_point
}

rule PEiD_00907_iLUCRYPT_v4_018__exe_
{
    meta:
        description = "[iLUCRYPT v4.018 [exe]"
        ep_only = "true"
    strings:
        $a = {8B EC FA C7 ?? ?? ?? ?? 4C 4C C3 FB BF ?? ?? B8 ?? ?? 2E ?? ?? D1 C8 4F 81}
    condition:
        $a at pe.entry_point
}

rule PEiD_00908_Img_Software_Set_graphics_file_
{
    meta:
        description = "[Img Software Set graphics file]"
        ep_only = "false"
    strings:
        $a = {53 43 4D 49 20 20 20 31 41 54}
    condition:
        $a
}

rule PEiD_00909_IMP_Packer_1_0____Mahdi_Hezavehi__IMPOSTER_
{
    meta:
        description = "[IMP-Packer 1.0 -> Mahdi Hezavehi [IMPOSTER]"
        ep_only = "false"
    strings:
        $a = {28 ?? ?? ?? 00 00 00 00 00 00 00 00 40 ?? ?? ?? 34 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41}
    condition:
        $a
}

rule PEiD_00910_IMP_Packer_1_0____Mahdi_Hezavehi__IMPOSTER__
{
    meta:
        description = "[IMP-Packer 1.0 -> Mahdi Hezavehi [IMPOSTER]]"
        ep_only = "false"
    strings:
        $a = {28 ?? ?? ?? 00 00 00 00 00 00 00 00 40 ?? ?? ?? 34 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63}
    condition:
        $a
}

rule PEiD_00911_IMPostor_Pack_1_0____Mahdi_Hezavehi_
{
    meta:
        description = "[IMPostor Pack 1.0 -> Mahdi Hezavehi]"
        ep_only = "true"
    strings:
        $a = {BE ?? ?? ?? 00 83 C6 01 FF E6 00 00 00 00 ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 ?? 02 ?? ?? 00 10 00 00 00 02 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00912_Inbuild_v1_0__hard_
{
    meta:
        description = "[Inbuild v1.0 [hard]"
        ep_only = "true"
    strings:
        $a = {B9 ?? ?? BB ?? ?? 2E ?? ?? 2E ?? ?? 43 E2}
    condition:
        $a at pe.entry_point
}

rule PEiD_00913_INCrypter_0_3__INinY____by_z3e_NiFe_
{
    meta:
        description = "[INCrypter 0.3 (INinY) - by z3e_NiFe]"
        ep_only = "true"
    strings:
        $a = {60 64 A1 30 00 00 00 8B 40 0C 8B 40 0C 8D 58 20 C7 03 00 00 00 00 E8 00 00 00 00 5D 81 ED 4D 16 40 00 8B 9D 0E 17 40 00 64 A1 18 00 00 00 8B 40 30 0F B6 40 02 83 F8 01 75 05 03 DB C1 CB 10 8B 8D 12 17 40 00 8B B5 06 17 40 00 51 81 3E 2E 72 73 72 74 65 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00914_INCrypter_0_3__INinY____by_z3e_NiFe_
{
    meta:
        description = "[INCrypter 0.3 (INinY) - by z3e_NiFe]"
        ep_only = "false"
    strings:
        $a = {60 64 A1 30 00 00 00 8B 40 0C 8B 40 0C 8D 58 20 C7 03 00 00 00 00 E8 00 00 00 00 5D 81 ED 4D 16 40 00 8B 9D 0E 17 40 00 64 A1 18 00 00 00 8B 40 30 0F B6 40 02 83 F8 01 75 05 03 DB C1 CB 10 8B 8D 12 17 40 00 8B B5 06 17 40 00 51 81 3E 2E 72 73 72 74 65 8B 85 16 17 40 00 E8 23 00 00 00 8B 85 1A 17 40 00 E8 18 00 00 00 8B 85 1E 17 40 00 E8 0D 00 00 00 8B 85 22 17 40 00 E8 02 00 00 00 EB 18 8B D6 3B 46 0C 72 0A 83 F9 01 74 0B 3B 46 34 72 06 BA 00 00 00 00 C3 58 83 FA 00 75 1A 8B 4E 10 8B 7E 0C 03 BD 02 17 40 00 83 F9 00 74 09 F6 17 31 0F 31 1F 47 E2 F7 59 83 C6 28 49 83 F9 00 75 88 8B 85 0A 17 40 00 89 44 24 1C 61 50 C3}
    condition:
        $a
}

rule PEiD_00915_Inno_Installer_v5_1_2_
{
    meta:
        description = "[Inno Installer v5.1.2]"
        ep_only = "false"
    strings:
        $a = {9C 60 E8 00 00 00 00 58 BB DC 1E 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 50 00 00 68 D8 00 00 00 E8 C1 FE FF FF E9 97 FF FF FF CC CC}
    condition:
        $a
}

rule PEiD_00916_Inno_Setup_Module_v1_09a_
{
    meta:
        description = "[Inno Setup Module v1.09a]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 C0 53 56 57 33 C0 89 45 F0 89 45 C4 89 45 C0 E8 A7 7F FF FF E8 FA 92 FF FF E8 F1 B3 FF FF 33 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00917_Inno_Setup_Module_v1_2_9_
{
    meta:
        description = "[Inno Setup Module v1.2.9]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 C0 53 56 57 33 C0 89 45 F0 89 45 EC 89 45 C0 E8 5B 73 FF FF E8 D6 87 FF FF E8 C5 A9 FF FF E8 E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00918_Inno_Setup_Module_v2_0_18_
{
    meta:
        description = "[Inno Setup Module v2.0.18]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 B8 53 56 57 33 C0 89 45 F0 89 45 BC 89 45 B8 E8 73 71 FF FF E8 DA 85 FF FF E8 81 A7 FF FF E8 C8}
    condition:
        $a
}

rule PEiD_00919_Inno_Setup_Module_v3_0_4_beta_v3_0_6_v3_0_7_
{
    meta:
        description = "[Inno Setup Module v3.0.4-beta/v3.0.6/v3.0.7]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 B8 53 56 57 33 C0 89 45 F0 89 45 BC 89 45 B8 E8 B3 70 FF FF E8 1A 85 FF FF E8 25 A7 FF FF E8 6C}
    condition:
        $a
}

rule PEiD_00920_Inno_Setup_Module_
{
    meta:
        description = "[Inno Setup Module]"
        ep_only = "true"
    strings:
        $a = {49 6E 6E 6F 53 65 74 75 70 4C 64 72 57 69 6E 64 6F 77 00 00 53 54 41 54 49 43}
    condition:
        $a at pe.entry_point
}

rule PEiD_00921_Inno_Setup_Module_
{
    meta:
        description = "[Inno Setup Module]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 ?? 53 56 57 33 C0 89 45 F0 89 45 ?? 89 45 ?? E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF}
    condition:
        $a
}

rule PEiD_00922_Install_Stub_32_bit_
{
    meta:
        description = "[Install Stub 32-bit]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 14 ?? 00 00 53 56 57 6A 00 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 29}
    condition:
        $a at pe.entry_point
}

rule PEiD_00923_InstallAnywhere_6_1____Zero_G_Software_Inc_
{
    meta:
        description = "[InstallAnywhere 6.1 -> Zero G Software Inc]"
        ep_only = "true"
    strings:
        $a = {60 BE 00 A0 42 00 8D BE 00 70 FD FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07}
    condition:
        $a at pe.entry_point
}

rule PEiD_00924_InstallAnywhere_6_1____Zero_G_Software_Inc_
{
    meta:
        description = "[InstallAnywhere 6.1 -> Zero G Software Inc]"
        ep_only = "true"
    strings:
        $a = {60 BE 00 A0 42 00 8D BE 00 70 FD FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00925_InstallAnywhere_6_1____Zero_G_Software_Inc_
{
    meta:
        description = "[InstallAnywhere 6.1 -> Zero G Software Inc]"
        ep_only = "true"
    strings:
        $a = {60 BE 00 A0 42 00 8D BE 00 70 FD FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4}
    condition:
        $a at pe.entry_point
}

rule PEiD_00926_Installer_VISE_Custom_
{
    meta:
        description = "[Installer VISE Custom]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? 40 00 68 ?? ?? 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 ?? ?? 40 00 33 D2 8A D4 89 15 ?? ?? 40 00 8B C8 81 E1 FF 00 00 00 89 0D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00927_InstallShield_2000_
{
    meta:
        description = "[InstallShield 2000]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 ?? 53 56 57}
    condition:
        $a at pe.entry_point
}

rule PEiD_00928_InstallShield_3_x_Custom_
{
    meta:
        description = "[InstallShield 3.x Custom]"
        ep_only = "true"
    strings:
        $a = {64 A1 00 00 00 00 55 8B EC 6A FF 68 00 A0 40 00 68 34 76 40 00 50 64 89 25 00 00 00 00 83 EC 60 53 56 57 89 65 E8 FF 15 8C E3 40 00 A3 70 B1 40 00 33 C0 A0 71 B1 40 00 A3 7C B1 40 00 A1 70 B1}
    condition:
        $a at pe.entry_point
}

rule PEiD_00929_InstallShield_Custom_
{
    meta:
        description = "[InstallShield Custom]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 44 56 FF 15 ?? ?? 41 00 8B F0 85 F6 75 08 6A FF FF 15 ?? ?? 41 00 8A 06 57 8B 3D ?? ?? 41 00 3C 22 75 1B 56 FF D7 8B F0 8A 06 3C 22 74 04 84 C0 75 F1 80 3E 22 75 15 56 FF D7 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00930_Interchange_Format_File__IFF___type_WVQA_
{
    meta:
        description = "[Interchange Format File (IFF), type WVQA]"
        ep_only = "false"
    strings:
        $a = {46 4F 52 4D ?? ?? ?? ?? 57 56 51 41 56 51 48 44}
    condition:
        $a
}

rule PEiD_00931_Interplay_s_MVE_file_
{
    meta:
        description = "[Interplay's MVE file]"
        ep_only = "false"
    strings:
        $a = {49 6E 74 65 72 70 6C 61 79 20 4D 56 45 20 46 69 6C 65 1A 00 1A}
    condition:
        $a
}

rule PEiD_00932_Ionic_Wind_Software_
{
    meta:
        description = "[Ionic Wind Software]"
        ep_only = "true"
    strings:
        $a = {9B DB E3 9B DB E2 D9 2D 00 ?? ?? 00 55 89 E5 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00933_iPB_Protect_0_1_3___0_1_7____forgot_
{
    meta:
        description = "[iPB Protect 0.1.3 - 0.1.7 -> forgot]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 4B 43 55 46 68 54 49 48 53 64 A1 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00934_iPBProtect_0_1_3_
{
    meta:
        description = "[iPBProtect 0.1.3]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 4B 43 55 46 68 54 49 48 53 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 68 53 56 57 89 65 FA 33 DB 89 5D F8 6A 02 EB 01 F8 58 5F 5E 5B 64 8B 25 00 00 00 00 64 8F 05 00 00 00 00 58 58 58 5D 68 9F 6F 56 B6 50 E8 5D 00 00 00 EB FF 71 78}
    condition:
        $a
}

rule PEiD_00935_iPBProtect_v0_1_3_
{
    meta:
        description = "[iPBProtect v0.1.3]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 4B 43 55 46 68 54 49 48 53 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 68 53 56 57 89 65 FA 33 DB 89 5D F8 6A 02 EB 01 F8 58 5F 5E 5B 64 8B 25 00 00 00 00 64 8F 05 00 00 00 00 58 58 58 5D 68 9F 6F 56 B6 50 E8 5D 00 00 00 EB FF 71 78 C2 50 00 EB D3 5B F3 68 89 5C 24 48 5C 24 58 FF 8D 5C 24 58 5B 83 C3 4C 75 F4 5A 8D 71 78 75 09 81 F3 EB FF 52 BA 01 00 83 EB FC 4A FF 71 0F 75 19 8B 5C 24 00 00 81 33 50 53 8B 1B 0F FF C6 75 1B 81 F3 EB 87 1C 24 8B 8B 04 24 83 EC FC EB 01 E8 83 EC FC E9 E7 00 00 00 58 EB FF F0 EB FF C0 83 E8 FD EB FF 30 E8 C9 00 00 00 89 E0 EB FF D0 EB FF 71 0F 83 C0 01 EB FF 70 F0 71 EE EB FA EB 83 C0 14 EB FF 70 ED 71 EB EB FA FF 83 C0 FC EB FF 70 ED 71 EB EB FA 0F 83 C0 F8 EB FF 70 ED 71 EB EB FA FF 83 C0 18 EB FF 70}
    condition:
        $a
}

rule PEiD_00936_IProtect_1_0__Fxlib_dll_mode____by_FuXdas_
{
    meta:
        description = "[IProtect 1.0 (Fxlib.dll mode) - by FuXdas]"
        ep_only = "true"
    strings:
        $a = {EB 33 2E 46 55 58 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 46 78 4C 69 62 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 60 E8 00 00 00 00 5D 81 ED 71 10 40 00 FF 74 24 20 E8 40 00 00 00 0B C0 74 2F 89 85 63 10 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00937_IProtect_1_0__Fxlib_dll_mode____by_FuXdas_
{
    meta:
        description = "[IProtect 1.0 (Fxlib.dll mode) - by FuXdas]"
        ep_only = "true"
    strings:
        $a = {EB 33 2E 46 55 58 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 46 78 4C 69 62 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 60 E8 00 00 00 00 5D 81 ED 71 10 40 00 FF 74 24 20 E8 40 00 00 00 0B C0 74 2F 89 85 63 10 40 00 8D 85 3C 10 40 00 50 FF B5 63 10 40 00 E8 92 00 00 00 0B C0 74 13 89 85 5F 10 40 00 8D 85 49 10 40 00 50 FF 95 5F 10 40 00 8B 85 67 10 40 00 89 44 24 1C 61 FF E0 8B 7C 24 04 8D 85 00 10 40 00 50 64 FF 35 00 00 00 00 8D 85 53 10 40 00 89 20 89 68 04 8D 9D 0A 11 40 00 89 58 08 64 89 25 00 00 00 00 81 E7 00 00 FF FF 66 81 3F 4D 5A 75 0F 8B F7 03 76 3C 81 3E 50 45 00 00 75 02 EB 17 81 EF 00 00 01 00 81 FF 00 00 00 70 73 07 BF 00 00 F7 BF EB 02 EB D3 97 64 8F 05 00 00 00 00 83 C4 04 C2 04 00 8D 85 00 10 40 00 50 64 FF 35 00 00 00 00 8D 85 53 10 40 00 89 20 89 68 04 8D 9D 0A 11 40 00 89 58 08 64 89 25 00 00 00 00 8B 74 24 0C 66 81 3E 4D 5A 74 05 E9 8A 00 00 00 03 76 3C 81 3E 50 45 00 00 74 02 EB 7D 8B 7C 24 10 B9 96 00 00 00 32 C0 F2 AE 8B CF 2B 4C 24 10 8B 56 78 03 54 24 0C 8B 5A 20 03 5C 24 0C 33 C0 8B 3B 03 7C 24 0C 8B 74 24 10 51 F3 A6 75 05 83 C4 04 EB 0A 59 83 C3 04 40 3B 42 18 75 E2 3B 42 18 75 02 EB 35 8B 72 24 03 74 24 0C 52 BB 02 00 00 00 33 D2 F7 E3 5A 03 C6 33 C9 66 8B 08 8B 7A 1C 33 D2 BB 04 00 00 00 8B C1 F7 E3 03 44 24 0C 03 C7 8B 00 03 44 24 0C EB 02 33 C0 64 8F 05 00 00 00 00 83 C4 04 C2 08 00 E8 FA FD FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00938_IProtect_1_0__FxSub_dll_mode____by_FuXdas_
{
    meta:
        description = "[IProtect 1.0 (FxSub.dll mode) - by FuXdas]"
        ep_only = "true"
    strings:
        $a = {EB 33 2E 46 55 58 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 46 78 53 75 62 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 60 E8 00 00 00 00 5D 81 ED B6 13 40 00 FF 74 24 20 E8 40 00 00 00 0B C0 74 2F 89 85 A8 13 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00939_IProtect_1_0__FxSub_dll_mode____by_FuXdas_
{
    meta:
        description = "[IProtect 1.0 (FxSub.dll mode) - by FuXdas]"
        ep_only = "true"
    strings:
        $a = {EB 33 2E 46 55 58 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 46 78 53 75 62 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 60 E8 00 00 00 00 5D 81 ED B6 13 40 00 FF 74 24 20 E8 40 00 00 00 0B C0 74 2F 89 85 A8 13 40 00 8D 85 81 13 40 00 50 FF B5 A8 13 40 00 E8 92 00 00 00 0B C0 74 13 89 85 A4 13 40 00 8D 85 8E 13 40 00 50 FF 95 A4 13 40 00 8B 85 AC 13 40 00 89 44 24 1C 61 FF E0 8B 7C 24 04 8D 85 00 10 40 00 50 64 FF 35 00 00 00 00 8D 85 98 13 40 00 89 20 89 68 04 8D 9D 4F 14 40 00 89 58 08 64 89 25 00 00 00 00 81 E7 00 00 FF FF 66 81 3F 4D 5A 75 0F 8B F7 03 76 3C 81 3E 50 45 00 00 75 02 EB 17 81 EF 00 00 01 00 81 FF 00 00 00 70 73 07 BF 00 00 F7 BF EB 02 EB D3 97 64 8F 05 00 00 00 00 83 C4 04 C2 04 00 8D 85 00 10 40 00 50 64 FF 35 00 00 00 00 8D 85 98 13 40 00 89 20 89 68 04 8D 9D 4F 14 40 00 89 58 08 64 89 25 00 00 00 00 8B 74 24 0C 66 81 3E 4D 5A 74 05 E9 8A 00 00 00 03 76 3C 81 3E 50 45 00 00 74 02 EB 7D 8B 7C 24 10 B9 96 00 00 00 32 C0 F2 AE 8B CF 2B 4C 24 10 8B 56 78 03 54 24 0C 8B 5A 20 03 5C 24 0C 33 C0 8B 3B 03 7C 24 0C 8B 74 24 10 51 F3 A6 75 05 83 C4 04 EB 0A 59 83 C3 04 40 3B 42 18 75 E2 3B 42 18 75 02 EB 35 8B 72 24 03 74 24 0C 52 BB 02 00 00 00 33 D2 F7 E3 5A 03 C6 33 C9 66 8B 08 8B 7A 1C 33 D2 BB 04 00 00 00 8B C1 F7 E3 03 44 24 0C 03 C7 8B 00 03 44 24 0C EB 02 33 C0 64 8F 05 00 00 00 00 83 C4 04 C2 08 00 E8 B5 FA FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00940_JAM_v2_11_
{
    meta:
        description = "[JAM v2.11]"
        ep_only = "true"
    strings:
        $a = {50 06 16 07 BE ?? ?? 8B FE B9 ?? ?? FD FA F3 2E A5 FB 06 BD ?? ?? 55 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00941_JAR_Archive_
{
    meta:
        description = "[JAR Archive]"
        ep_only = "false"
    strings:
        $a = {?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1A 4A 61 72 1B}
    condition:
        $a
}

rule PEiD_00942_JDPack_2_x____JDPack_
{
    meta:
        description = "[JDPack 2.x -> JDPack]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 68 51 40 00 68 04 25 40 00 64 A1 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00943_JDPack_V2_00____JDPack_
{
    meta:
        description = "[JDPack V2.00 -> JDPack]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 ?? ?? ?? E8 01 00 00 00 ?? ?? ?? ?? ?? ?? 05 00 00 00 00 83 C4 0C 5D 60 E8 00 00 00 00 5D 8B D5 64 FF 35 00 00 00 00 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00944_JDPack_
{
    meta:
        description = "[JDPack]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 8B D5 81 ED ?? ?? ?? ?? 2B 95 ?? ?? ?? ?? 81 EA 06 ?? ?? ?? 89 95 ?? ?? ?? ?? 83 BD 45}
    condition:
        $a at pe.entry_point
}

rule PEiD_00945_JExeCompressor_1_0___by_Arash_Veyskarami_
{
    meta:
        description = "[JExeCompressor 1.0 - by Arash Veyskarami]"
        ep_only = "true"
    strings:
        $a = {8D 2D D3 4A E5 14 0F BB F7 0F BA E5 73 0F AF D5 8D 0D 0C 9F E6 11 C0 F8 EF F6 DE 80 DC 5B F6 DA 0F A5 C1 0F C1 F1 1C F3 4A 81 E1 8C 1F 66 91 0F BE C6 11 EE 0F C0 E7 33 D9 64 F2 C0 DC 73 0F C0 D5 55 8B EC BA C0 1F 41 00 8B C2 B9 97 00 00 00 80 32 79 50 B8}
    condition:
        $a at pe.entry_point
}

rule PEiD_00946_JExeCompressor_1_0___by_Arash_Veyskarami_
{
    meta:
        description = "[JExeCompressor 1.0 - by Arash Veyskarami]"
        ep_only = "true"
    strings:
        $a = {8D 2D D3 4A E5 14 0F BB F7 0F BA E5 73 0F AF D5 8D 0D 0C 9F E6 11 C0 F8 EF F6 DE 80 DC 5B F6 DA 0F A5 C1 0F C1 F1 1C F3 4A 81 E1 8C 1F 66 91 0F BE C6 11 EE 0F C0 E7 33 D9 64 F2 C0 DC 73 0F C0 D5 55 8B EC BA C0 1F 41 00 8B C2 B9 97 00 00 00 80 32 79 50 B8 02 00 00 00 50 03 14 24 58 58 51 2B C9 B9 01 00 00 00 83 EA 01 E2 FB 59 E2 E1 FF E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00947_JExeCompressor_V1_0____UsAr_
{
    meta:
        description = "[JExeCompressor V1.0 -> UsAr]"
        ep_only = "true"
    strings:
        $a = {0F C8 0F CF C6 C4 8B 0F AC EA 99 0F AD D8 13 F5 0F BD EF 85 EF 85 DA 69 FE ?? ?? ?? ?? 21 F9 BE ?? ?? ?? ?? 23 CF 0F BC FE D2 DC 85 EF B9 ?? ?? ?? ?? C6 C0 F7 8D 35 ?? ?? ?? ?? 8D 0D}
    condition:
        $a at pe.entry_point
}

rule PEiD_00948_Joiner__sign_from_pinch_25_03_2007_20_10__
{
    meta:
        description = "[Joiner (sign from pinch 25.03.2007 20:10)]"
        ep_only = "true"
    strings:
        $a = {81 EC 04 01 00 00 8B F4 68 04 01 00 00 56 6A 00 E8 7C 01 00 00 33 C0 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 56 E8 50 01 00 00 8B D8 6A 00 6A 00 6A 00 6A 02 6A 00 53 E8 44 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_00949_KBys_Packer_0_28_Beta____Shoooo_
{
    meta:
        description = "[KBys Packer 0.28 Beta -> Shoooo]"
        ep_only = "false"
    strings:
        $a = {60 E8 00 00 00 00 5E 83 EE 0A 8B 06 03 C2 8B 08 89 4E F3 83 EE 0F 56 52 8B F0 AD AD 03 C2 8B D8 6A 04 BF 00 10 00 00 57 57 6A 00 FF 53 08 5A 59 BD 00 80 00 00 55 6A 00 50 51 52 50 89 06 AD AD 03 C2 50 AD 03 C2 FF D0 6A 04 57 AD 50 6A 00 FF 53}
    condition:
        $a
}

rule PEiD_00950_Kbys_Packer_0_28_Beta___shoooo314_
{
    meta:
        description = "[Kbys Packer 0.28 Beta-> shoooo314]"
        ep_only = "false"
    strings:
        $a = {68 85 AE 01 01 E8 01 00 00 00 C3 C3 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00}
    condition:
        $a
}

rule PEiD_00951_KByS_V0_28____shoooo___Sign_by_fly_
{
    meta:
        description = "[KByS V0.28 -> shoooo ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? E8 01 00 00 00 C3 C3 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4}
    condition:
        $a at pe.entry_point
}

rule PEiD_00952_KByS_V0_28_DLL____shoooo___Sign_by_fly_
{
    meta:
        description = "[KByS V0.28 DLL -> shoooo ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? BA ?? ?? ?? ?? 03 C2 FF E0 ?? ?? ?? ?? 60 E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_00953_KGB_SFX_
{
    meta:
        description = "[KGB SFX]"
        ep_only = "true"
    strings:
        $a = {60 BE 00 A0 46 00 8D BE 00 70 F9 FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73}
    condition:
        $a at pe.entry_point
}

rule PEiD_00954_KGCrypt_vx_x_
{
    meta:
        description = "[KGCrypt vx.x]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? 64 A1 30 ?? ?? ?? 84 C0 74 ?? 64 A1 20 ?? ?? ?? 0B C0 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_00955_kkrunchy____Ryd_
{
    meta:
        description = "[kkrunchy -> Ryd]"
        ep_only = "true"
    strings:
        $a = {BD 08 ?? ?? 00 C7 45 00 ?? ?? ?? 00 FF 4D 08 C6 45 0C 05 8D 7D 14 31 C0 B4 04 89 C1 F3 AB BF ?? ?? ?? 00 57 BE ?? ?? ?? 00 31 C9 41 FF 4D 0C 8D 9C 8D A0 00 00 00 FF D6 10 C9 73 F3 FF 45 0C 91 AA 83 C9 FF 8D 5C 8D 18 FF D6 74 DD E3 17 8D 5D 1C FF D6 74 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_00956_kkrunchy____Ryd_
{
    meta:
        description = "[kkrunchy -> Ryd]"
        ep_only = "true"
    strings:
        $a = {BD 08 ?? ?? 00 C7 45 00 ?? ?? ?? 00 FF 4D 08 C6 45 0C 05 8D 7D 14 31 C0 B4 04 89 C1 F3 AB BF ?? ?? ?? 00 57 BE ?? ?? ?? 00 31 C9 41 FF 4D 0C 8D 9C 8D A0 00 00 00 FF D6 10 C9 73 F3 FF 45 0C 91 AA 83 C9 FF 8D 5C 8D 18 FF D6 74 DD E3 17 8D 5D 1C FF D6 74 10 8D 9D A0 08 00 00 E8 EB 00 00 00 8B 45 10 EB 42 8D 9D A0 04 00 00 E8 DB 00 00 00 49 49 78 40 8D 5D 20 74 03 83 C3 40 31 D2 42 E8 BD 00 00 00 8D 0C 48 F6 C2 10 74 F3 41 91 8D 9D A0 08 00 00 E8 B2 00 00 00 3D 00 08 00 00 83 D9 FF 83 F8 60 83 D9 FF 89 45 10 56 89 FE 29 C6 F3 A4 5E EB 90 BE ?? ?? ?? 00 BB ?? ?? ?? 00 55 46 AD 85 C0 74 29 97 56 FF 13 85 C0 74 16 95 AC 84 C0 75 FB 38 06 74 E8 78 0D 56 55 FF 53 04 AB 85 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00957_kkrunchy_0_23_alpha____Ryd_
{
    meta:
        description = "[kkrunchy 0.23 alpha -> Ryd]"
        ep_only = "true"
    strings:
        $a = {BD 08 ?? ?? 00 C7 45 00 ?? ?? ?? 00 FF 4D 08 C6 45 0C 05 8D 7D 14 31 C0 B4 04 89 C1 F3 AB BF ?? ?? ?? 00 57 BE ?? ?? ?? 00 31 C9 41 FF 4D 0C 8D 9C 8D A0 00 00 00 FF D6 10 C9 73 F3 FF 45 0C 91 AA 83 C9 FF 8D 5C 8D 18 FF D6 74 DD E3 17 8D 5D 1C FF D6 74 10 8D 9D A0 08 00 00 E8 ?? 00 00 00 8B 45 10 EB 42 8D 9D A0 04 00 00 E8 ?? 00 00 00 49 49 78 40 8D 5D 20 74 03 83 C3 40 31 D2 42 E8 ?? 00 00 00 8D 0C 48 F6 C2 10 74 F3 41 91 8D 9D A0 08 00 00 E8 ?? 00 00 00 3D 00 08 00 00 83 D9 FF 83 F8 60 83 D9 FF 89 45 10 56 89 FE 29 C6 F3 A4 5E EB 90 BE ?? ?? ?? 00 BB ?? ?? ?? 00 55 46 AD 85 C0 74 ?? 97 56 FF 13 85 C0 74 16 95 AC 84 C0 75 FB 38 06 74 E8 78 ?? 56 55 FF 53 04 AB 85 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00958_kkrunchy_0_23_alpha_2____Ryd_
{
    meta:
        description = "[kkrunchy 0.23 alpha 2 -> Ryd]"
        ep_only = "true"
    strings:
        $a = {BD ?? ?? ?? ?? C7 45 00 ?? ?? ?? 00 B8 ?? ?? ?? 00 89 45 04 89 45 54 50 C7 45 10 ?? ?? ?? 00 FF 4D 0C FF 45 14 FF 45 58 C6 45 1C 08 B8 00 08 00 00 8D 7D 30 AB AB AB AB BB 00 00 D8 00 BF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00959_kkrunchy_0_23_alpha_2____Ryd_
{
    meta:
        description = "[kkrunchy 0.23 alpha 2 -> Ryd]"
        ep_only = "true"
    strings:
        $a = {BD ?? ?? ?? ?? C7 45 00 ?? ?? ?? 00 B8 ?? ?? ?? 00 89 45 04 89 45 54 50 C7 45 10 ?? ?? ?? 00 FF 4D 0C FF 45 14 FF 45 58 C6 45 1C 08 B8 00 08 00 00 8D 7D 30 AB AB AB AB BB 00 00 D8 00 BF ?? ?? ?? 01 31 C9 41 8D 74 09 01 B8 CA 8E 2A 2E 99 F7 F6 01 C3 89 D8 C1 E8 15 AB FE C1 75 E8 BE}
    condition:
        $a at pe.entry_point
}

rule PEiD_00960_kkrunchy_v0_17____F__Giesen_
{
    meta:
        description = "[kkrunchy v0.17 -> F. Giesen]"
        ep_only = "false"
    strings:
        $a = {FC FF 4D 08 31 D2 8D 7D 30 BE}
    condition:
        $a
}

rule PEiD_00961_kkrunchy_V0_2X____Ryd___Sign_by_fly_
{
    meta:
        description = "[kkrunchy V0.2X -> Ryd ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {BD ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? FF 4D 08 C6 45 0C 05 8D 7D 14 31 C0 B4 04 89 C1 F3 AB BF ?? ?? ?? ?? 57 BE ?? ?? ?? ?? 31 C9 41 FF 4D 0C 8D 9C 8D A0 00 00 00 FF D6}
    condition:
        $a at pe.entry_point
}

rule PEiD_00962_Krypton_v0_2_
{
    meta:
        description = "[Krypton v0.2]"
        ep_only = "true"
    strings:
        $a = {8B 0C 24 E9 0A 7C 01 ?? AD 42 40 BD BE 9D 7A 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_00963_Krypton_v0_3_
{
    meta:
        description = "[Krypton v0.3]"
        ep_only = "true"
    strings:
        $a = {8B 0C 24 E9 C0 8D 01 ?? C1 3A 6E CA 5D 7E 79 6D B3 64 5A 71 EA}
    condition:
        $a at pe.entry_point
}

rule PEiD_00964_Krypton_v0_4_
{
    meta:
        description = "[Krypton v0.4]"
        ep_only = "true"
    strings:
        $a = {54 E8 ?? ?? ?? ?? 5D 8B C5 81 ED 61 34 ?? ?? 2B 85 60 37 ?? ?? 83 E8 06}
    condition:
        $a at pe.entry_point
}

rule PEiD_00965_Krypton_v0_5_
{
    meta:
        description = "[Krypton v0.5]"
        ep_only = "true"
    strings:
        $a = {54 E8 ?? ?? ?? ?? 5D 8B C5 81 ED 71 44 ?? ?? 2B 85 64 60 ?? ?? EB 43 DF}
    condition:
        $a at pe.entry_point
}

rule PEiD_00966_kryptor_5_
{
    meta:
        description = "[kryptor 5]"
        ep_only = "true"
    strings:
        $a = {E8 03 ?? ?? ?? E9 EB 6C 58 40 FF E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00967_kryptor_6_
{
    meta:
        description = "[kryptor 6]"
        ep_only = "true"
    strings:
        $a = {E8 03 ?? ?? ?? E9 EB 68 58 33 D2 74 02 E9 E9 40 42 75 02}
    condition:
        $a at pe.entry_point
}

rule PEiD_00968_kryptor_9_
{
    meta:
        description = "[kryptor 9]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5E B9 ?? ?? ?? ?? 2B C0 02 04 0E D3 C0 49 79 F8 41 8D 7E 2C 33 46 ?? 66 B9}
    condition:
        $a at pe.entry_point
}

rule PEiD_00969_LamCrypt_1_0____LaZaRuS_
{
    meta:
        description = "[LamCrypt 1.0 -> LaZaRuS]"
        ep_only = "false"
    strings:
        $a = {60 66 9C BB 00 ?? ?? 00 80 B3 00 10 40 00 90 4B 83 FB FF 75 F3 66 9D 61 B8}
    condition:
        $a
}

rule PEiD_00970_LameCrypt____LaZaRus_
{
    meta:
        description = "[LameCrypt -> LaZaRus]"
        ep_only = "true"
    strings:
        $a = {60 66 9C BB 00 ?? ?? 00 80 B3 00 10 40 00 90 4B 83 FB FF 75 F3 66 9D 61 B8 ?? ?? 40 00 FF E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_00971_LameCrypt_v1_0_
{
    meta:
        description = "[LameCrypt v1.0]"
        ep_only = "true"
    strings:
        $a = {60 66 9C BB ?? ?? ?? ?? 80 B3 00 10 40 00 90 4B 83 FB FF 75 F3 66 9D 61}
    condition:
        $a at pe.entry_point
}

rule PEiD_00972_LamerStop_v1_0c__c__Stefan_Esser_
{
    meta:
        description = "[LamerStop v1.0c (c) Stefan Esser]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? 05 ?? ?? CD 21 33 C0 8E C0 26 ?? ?? ?? 2E ?? ?? ?? 26 ?? ?? ?? 2E ?? ?? ?? BA ?? ?? FA}
    condition:
        $a at pe.entry_point
}

rule PEiD_00973_Lattice_C_v1_01_
{
    meta:
        description = "[Lattice C v1.01]"
        ep_only = "true"
    strings:
        $a = {FA B8 ?? ?? 05 ?? ?? B1 ?? D3 E8 8C CB 03 C3 8E D8 8E D0 26 ?? ?? ?? ?? 2B D8 F7 ?? ?? ?? 75 ?? B1 ?? D3 E3 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_00974_Lattice_C_v3_0_
{
    meta:
        description = "[Lattice C v3.0]"
        ep_only = "true"
    strings:
        $a = {FA B8 ?? ?? 8E D8 B8 ?? ?? 8E}
    condition:
        $a at pe.entry_point
}

rule PEiD_00975_LaunchAnywhere_4_0_0_1_
{
    meta:
        description = "[LaunchAnywhere 4.0.0.1]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 53 83 EC 48 55 B8 FF FF FF FF 50 50 68 E0 3E 42 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 68 C0 69 44 00 E8 E4 80 FF FF 59 E8 4E 29 00 00 E8 C9 0D 00 00 85 C0 75 08 6A FF E8 6E 2B 00 00 59 E8 A8 2C 00 00 E8 23 2E 00 00 FF 15 4C C2 44 00 89 C3}
    condition:
        $a
}

rule PEiD_00976_LaunchAnywhere_v4_0_0_1_
{
    meta:
        description = "[LaunchAnywhere v4.0.0.1]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 53 83 EC 48 55 B8 FF FF FF FF 50 50 68 E0 3E 42 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 68 C0 69 44 00 E8 E4 80 FF FF 59 E8 4E 29 00 00 E8 C9 0D 00 00 85 C0 75 08 6A FF E8 6E 2B 00 00 59 E8 A8 2C 00 00 E8 23 2E 00 00 FF 15 4C C2 44 00 89 C3 EB 19 3C 22 75 14 89 C0 8D 40 00 43 8A 03 84 C0 74 04 3C 22 75 F5 3C 22 75 01 43 8A 03 84 C0 74 0B 3C 20 74 07 3C 09 75 D9 EB 01 43 8A 03 84 C0 74 04 3C 20 7E F5 8D 45 B8 50 FF 15 E4 C1 44 00 8B 45 E4 25 01 00 00 00 74 06 0F B7 45 E8 EB 05 B8 0A 00 00 00 50 53 6A 00 6A 00 FF 15 08 C2 44 00 50 E8 63 15 FF FF 50 E8 EE 2A 00 00 59 8D 65 FC 5B}
    condition:
        $a at pe.entry_point
}

rule PEiD_00977_Launcher_Generator_1_03_
{
    meta:
        description = "[Launcher Generator 1.03]"
        ep_only = "false"
    strings:
        $a = {68 00 20 40 00 68 10 20 40 00 6A 00 6A 00 6A 20 6A 00 6A 00 6A 00 68 F0 22 40 00 6A 00 E8 93 00 00 00 85 C0 0F 84 7E 00 00 00 B8 00 00 00 00 3B 05 68 20 40 00 74 13 6A ?? 68 60 23 40 00 68 20 23 40 00 6A 00 E8 83 00 00 00 A1 58 20 40 00 3B 05 6C 20 40 00}
    condition:
        $a
}

rule PEiD_00978_Launcher_Generator_v1_03_
{
    meta:
        description = "[Launcher Generator v1.03]"
        ep_only = "false"
    strings:
        $a = {68 00 20 40 00 68 10 20 40 00 6A 00 6A 00 6A 20 6A 00 6A 00 6A 00 68 F0 22 40 00 6A 00 E8 93 00 00 00 85 C0 0F 84 7E 00 00 00 B8 00 00 00 00 3B 05 68 20 40 00 74 13 6A ?? 68 60 23 40 00 68 20 23 40 00 6A 00 E8 83 00 00 00 A1 58 20 40 00 3B 05 6C 20 40 00 74 51 C1 E0 02 A3 5C 20 40 00 BB 70 21 40 00 03 C3 8B 18 68 60 20 40 00 53 B8 F0 21 40 00 03 05 5C 20 40 00 8B D8 8B 03 05 70 20 40 00 50 B8 70 22 40 00 03 05 5C 20 40 00 FF 30 FF 35 00 20 40 00 E8 26 00 00 00 A1 58 20 40 00 40 A3 58 20 40 00 EB A2 6A FF E8 00 00 00 00 FF 25 5C 30 40 00 FF 25 60 30 40 00 FF 25 64 30 40 00 FF 25 68 30 40 00 FF 25 6C 30 40 00 FF 25 74 30 40 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_00979_LCC_Win32_DLL_
{
    meta:
        description = "[LCC Win32 DLL]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 53 56 57 83 7D 0C 01 75 05 E8 17 ?? ?? ?? FF 75 10 FF 75 0C FF 75 08 A1}
    condition:
        $a at pe.entry_point
}

rule PEiD_00980_LCC_Win32_v1_x_
{
    meta:
        description = "[LCC Win32 v1.x]"
        ep_only = "true"
    strings:
        $a = {64 A1 ?? ?? ?? ?? 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 9A 10 40 ?? 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_00981_LCC_Win32_
{
    meta:
        description = "[LCC-Win32]"
        ep_only = "true"
    strings:
        $a = {64 A1 00 00 00 00 55 89 E5 6A FF 68 10 30 40 00 68 9A 10 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_00982_LGLZ_v1_04__com_
{
    meta:
        description = "[LGLZ v1.04 [com]"
        ep_only = "true"
    strings:
        $a = {BF ?? ?? 3B FC 72 19 B4 09 BA 12 01 CD 21 B4 4C CD 21}
    condition:
        $a at pe.entry_point
}

rule PEiD_00983_LGLZ_v1_04b_
{
    meta:
        description = "[LGLZ v1.04b]"
        ep_only = "true"
    strings:
        $a = {FC 1E 06 0E 8C C8 ?? ?? ?? ?? BA ?? ?? 03 C2 8B D8 05 ?? ?? 8E DB 8E C0 33 F6 33 FF B9 ?? ?? F3 A5 4B 48 4A 79}
    condition:
        $a at pe.entry_point
}

rule PEiD_00984_Libraries_by_John_Socha_
{
    meta:
        description = "[Libraries by John Socha]"
        ep_only = "true"
    strings:
        $a = {BB ?? ?? 8E DB 2E 89 ?? ?? ?? 8D ?? ?? ?? 25 ?? ?? FA 8E D3 8B E0 FB 26 A1 A3 ?? ?? B4 30 CD 21}
    condition:
        $a at pe.entry_point
}

rule PEiD_00985_LOCK98_V1_00_28____keenvim_
{
    meta:
        description = "[LOCK98 V1.00.28 -> keenvim]"
        ep_only = "true"
    strings:
        $a = {55 E8 00 00 00 00 5D 81 ?? ?? ?? ?? ?? EB 05 E9 ?? ?? ?? ?? EB 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_00986_Lockless_Intro_Pack_
{
    meta:
        description = "[Lockless Intro Pack]"
        ep_only = "true"
    strings:
        $a = {2C E8 ?? ?? ?? ?? 5D 8B C5 81 ED F6 73 ?? ?? 2B 85 ?? ?? ?? ?? 83 E8 06 89 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_00987_Lotus_Word_Pro_document_file_
{
    meta:
        description = "[Lotus Word Pro document file]"
        ep_only = "false"
    strings:
        $a = {57 6F 72 64 50 72 6F ?? ?? ?? ?? ?? ?? ?? ?? ?? 4C 57 50 37}
    condition:
        $a
}

rule PEiD_00988_LSI_C_86_Run_Time_Libray_
{
    meta:
        description = "[LSI C-86 Run-Time Libray]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? 8E C0 06 17 BC ?? ?? 26 8C ?? ?? ?? B4 30 CD 21 26 A3 ?? ?? FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_00989_LTC_v1_3_
{
    meta:
        description = "[LTC v1.3]"
        ep_only = "true"
    strings:
        $a = {54 E8 00 00 00 00 5D 8B C5 81 ED F6 73 40 00 2B 85 87 75 40 00 83 E8 06}
    condition:
        $a at pe.entry_point
}

rule PEiD_00990_LY_WGKX____www_szleyu_com_
{
    meta:
        description = "[LY_WGKX -> www.szleyu.com]"
        ep_only = "false"
    strings:
        $a = {4D 79 46 75 6E 00 62 73}
    condition:
        $a
}

rule PEiD_00991_LZEXE_v0_91__v1_00a__1__
{
    meta:
        description = "[LZEXE v0.91, v1.00a (1)]"
        ep_only = "true"
    strings:
        $a = {06 0E 1F 8B ?? ?? ?? 8B F1 4E 89 F7}
    condition:
        $a at pe.entry_point
}

rule PEiD_00992_LZEXE_v0_91__v1_00a__2__
{
    meta:
        description = "[LZEXE v0.91, v1.00a (2)]"
        ep_only = "true"
    strings:
        $a = {BF ?? ?? 06 89 F9 0E 41 1F 8C CB 89 FE}
    condition:
        $a at pe.entry_point
}

rule PEiD_00993_Macromedia_Windows_Flash_Projector_Player_5_0_
{
    meta:
        description = "[Macromedia Windows Flash Projector/Player 5.0]"
        ep_only = "false"
    strings:
        $a = {83 EC 44 56 FF 15 70 61 44 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C 3C 20 7E 08 8A 46 01 46 3C 20 7F F8 8A 06 84 C0 74 0C 3C 20 7F 08 8A 46 01 46 84 C0 75 F4 8D 44 24 04 C7 44 24 30 00}
    condition:
        $a
}

rule PEiD_00994_Macromedia_Windows_Flash_Projector_Player_v3_0_
{
    meta:
        description = "[Macromedia Windows Flash Projector/Player v3.0]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 44 56 FF 15 94 13 42 00 8B F0 B1 22 8A 06 3A C1 75 13 8A 46 01 46 3A C1 74 04 84 C0 75 F4 38 0E 75 0D 46 EB 0A 3C 20 7E 06}
    condition:
        $a at pe.entry_point
}

rule PEiD_00995_Macromedia_Windows_Flash_Projector_Player_v4_0_
{
    meta:
        description = "[Macromedia Windows Flash Projector/Player v4.0]"
        ep_only = "true"
    strings:
        $a = {83 EC 44 56 FF 15 24 41 43 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00996_Macromedia_Windows_Flash_Projector_Player_v5_0_
{
    meta:
        description = "[Macromedia Windows Flash Projector/Player v5.0]"
        ep_only = "true"
    strings:
        $a = {83 EC 44 56 FF 15 70 61 44 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C 3C 20 7E 08 8A 46 01 46 3C 20 7F F8 8A 06 84 C0 74 0C 3C 20 7F 08 8A 46 01 46 84 C0 75 F4 8D 44 24 04 C7 44 24 30 00 00 00 00 50 FF 15 80 61 44 00 F6 44 24 30 01 74 0B 8B 44 24 34 25 FF FF 00 00 EB 05 B8 0A 00 00 00 50 56 6A 00 6A 00 FF 15 74 61 44 00 50 E8 18 00 00 00 50 FF 15 78 61 44 00 5E 83 C4 44 C3 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_00997_Macromedia_Windows_Flash_Projector_Player_v6_0_
{
    meta:
        description = "[Macromedia Windows Flash Projector/Player v6.0]"
        ep_only = "true"
    strings:
        $a = {83 EC 44 56 FF 15 24 81 49 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_00998_MarjinZ_EXE_Scrambler_SE___by_MarjinZ_
{
    meta:
        description = "[MarjinZ EXE-Scrambler SE - by MarjinZ]"
        ep_only = "false"
    strings:
        $a = {E8 A3 02 00 00 E9 35 FD FF FF FF 25 C8 20 00 10 6A 14 68 C0 21 00 10 E8 E4 01 00 00 FF 35 7C 33 00 10 8B 35 8C 20 00 10 FF D6 59 89 45 E4 83 F8 FF 75 0C FF 75 08 FF 15 88 20 00 10 59 EB 61 6A 08 E8 02 03 00 00 59 83 65 FC 00 FF 35 7C 33 00 10 FF D6 89 45 E4 FF 35 78 33 00 10 FF D6 89 45 E0 8D 45 E0 50 8D 45 E4 50 FF 75 08 E8 D1 02 00 00 89 45 DC FF 75 E4 8B 35 74 20 00 10 FF D6 A3 7C 33 00 10 FF 75 E0 FF D6 83 C4 1C A3 78 33 00 10 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 DC E8 A0 01 00 00 C3}
    condition:
        $a
}

rule PEiD_00999_MaskPE_1_6____yzkzero_
{
    meta:
        description = "[MaskPE 1.6 -> yzkzero]"
        ep_only = "false"
    strings:
        $a = {36 81 2C 24 ?? ?? ?? 00 C3 60}
    condition:
        $a
}

rule PEiD_01000_MaskPE_V2_0____yzkzero_
{
    meta:
        description = "[MaskPE V2.0 -> yzkzero]"
        ep_only = "false"
    strings:
        $a = {B8 18 00 00 00 64 8B 18 83 C3 30 C3 40 3E 0F B6 00 C1 E0 ?? 83 C0 ?? 36 01 04 24 C3}
    condition:
        $a
}

rule PEiD_01001_MASM___TASM_
{
    meta:
        description = "[MASM / TASM]"
        ep_only = "true"
    strings:
        $a = {6A 00 E8 ?? 0? 00 00 A3 ?? 32 40 00 E8 ?? 0? 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01002_MASM___TASM_
{
    meta:
        description = "[MASM / TASM]"
        ep_only = "false"
    strings:
        $a = {6A 00 E8 ?? 0? 00 00 A3 ?? ?? 40 00 ?? ?? ?? ?0 ?0 ?? ?? 00 00 00 ?? ?? 0? ?? ?? ?0 ?? ?? ?0 ?0 ?? ?? ?? ?0 ?? 0? ?? ?0 ?0 00}
    condition:
        $a
}

rule PEiD_01003_MASM___TASM_
{
    meta:
        description = "[MASM / TASM]"
        ep_only = "false"
    strings:
        $a = {6A 00 E8 ?? ?? 00 00 A3 ?? 32 40 00 E8 ?? ?? 00 00}
    condition:
        $a
}

rule PEiD_01004_MASM_TASM___sig1_h__
{
    meta:
        description = "[MASM/TASM - sig1(h)]"
        ep_only = "false"
    strings:
        $a = {CC FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00}
    condition:
        $a
}

rule PEiD_01005_MASM_TASM___sig2_h__
{
    meta:
        description = "[MASM/TASM - sig2(h)]"
        ep_only = "false"
    strings:
        $a = {C2 ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00}
    condition:
        $a
}

rule PEiD_01006_MASM_TASM___sig4__h__
{
    meta:
        description = "[MASM/TASM - sig4 (h)]"
        ep_only = "false"
    strings:
        $a = {C3 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00}
    condition:
        $a
}

rule PEiD_01007_MASM_TASM___sig4__h__
{
    meta:
        description = "[MASM/TASM - sig4 (h)]"
        ep_only = "false"
    strings:
        $a = {FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00}
    condition:
        $a
}

rule PEiD_01008_MASM32_
{
    meta:
        description = "[MASM32]"
        ep_only = "true"
    strings:
        $a = {6A ?? 68 00 30 40 00 68 ?? 30 40 00 6A 00 E8 07 00 00 00 6A 00 E8 06 00 00 00 FF 25 08 20}
    condition:
        $a at pe.entry_point
}

rule PEiD_01009_Matrix_Dongle____TDi_GmbH_
{
    meta:
        description = "[Matrix Dongle -> TDi GmbH]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 E8 B6 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? E8 00 00 00 00 5B 2B D9 8B F8 8B 4C 24 2C 33 C0 2B CF F2 AA 8B 3C 24 8B 0A 2B CF 89 5C 24 20 80 37 A2 47 49 75 F9 8D 64 24 04 FF 64 24 FC 60 C7 42 08 ?? ?? ?? ?? E8 C5 FF FF FF C3 C2 F7 29 4E 29 5A 29 E6 86 8A 89 63 5C A2 65 E2 A3 A2}
    condition:
        $a
}

rule PEiD_01010_Matrix_Dongle____TDi_GmbH_
{
    meta:
        description = "[Matrix Dongle -> TDi GmbH]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 E8 00 00 00 00 59 5A 2B CA 2B D1 E8 1A FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01011_MEGALITE_v1_20a_
{
    meta:
        description = "[MEGALITE v1.20a]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 2D 73 ?? 72 ?? B4 09 BA ?? ?? CD 21 CD 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01012_MESS_v1_20_
{
    meta:
        description = "[MESS v1.20]"
        ep_only = "true"
    strings:
        $a = {?? ?? ?? ?? FA B9 ?? ?? F3 ?? ?? E3 ?? EB ?? EB ?? B6}
    condition:
        $a at pe.entry_point
}

rule PEiD_01013_MetaWare_High_C___Phar_Lap_DOS_Extender_1983_89_
{
    meta:
        description = "[MetaWare High C + Phar Lap DOS Extender 1983-89]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? 8E D8 B8 ?? ?? CD 21 A3 ?? ?? 3C 03 7D ?? B4 09}
    condition:
        $a at pe.entry_point
}

rule PEiD_01014_MetaWare_High_C_Run_Time_Library___Phar_Lap_DOS_Extender_1983_89_
{
    meta:
        description = "[MetaWare High C Run-Time Library + Phar Lap DOS Extender 1983-89]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? 50 B8 ?? ?? 50 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01015_Metrowerks_CodeWarrior__DLL__v2_0_
{
    meta:
        description = "[Metrowerks CodeWarrior (DLL) v2.0]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 53 56 57 8B 75 0C 8B 5D 10 83 FE 01 74 05 83 FE 02 75 12 53 56 FF 75 08 E8 6E FF FF FF 09 C0 75 04 31 C0 EB 21 53 56 FF 75 08 E8 ?? ?? ?? ?? 89 C7 09 F6 74 05 83 FE 03 75 0A 53 56 FF 75 08 E8 47 FF FF FF 89 F8 8D 65 F4 5F 5E 5B 5D C2 0C 00 C9}
    condition:
        $a
}

rule PEiD_01016_Metrowerks_CodeWarrior_v2_0__Console__
{
    meta:
        description = "[Metrowerks CodeWarrior v2.0 (Console)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 55 B8 FF FF FF FF 50 50 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? 00 00 E8 ?? ?? 00 00 E8}
    condition:
        $a
}

rule PEiD_01017_Metrowerks_CodeWarrior_v2_0__GUI__
{
    meta:
        description = "[Metrowerks CodeWarrior v2.0 (GUI)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 53 56 83 EC 44 55 B8 FF FF FF FF 50 50 68 ?? ?? 40 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 68 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? 00 00 E8 ?? ?? 00 00 E8}
    condition:
        $a
}

rule PEiD_01018_MEW_10_by_Northfox_
{
    meta:
        description = "[MEW 10 by Northfox]"
        ep_only = "false"
    strings:
        $a = {33 C0 E9 ?? ?? FF FF ?? 1C ?? ?? 40}
    condition:
        $a
}

rule PEiD_01019_Mew_10_exe_coder_1_0____Northfox__HCC__
{
    meta:
        description = "[Mew 10 exe-coder 1.0 -> Northfox [HCC]]"
        ep_only = "true"
    strings:
        $a = {33 C0 E9 ?? ?? FF FF 6A ?? ?? ?? ?? ?? 70}
    condition:
        $a at pe.entry_point
}

rule PEiD_01020_MEW_11_SE_1_0____Northfox_
{
    meta:
        description = "[MEW 11 SE 1.0 -> Northfox]"
        ep_only = "false"
    strings:
        $a = {E9 ?? ?? ?? ?? 00 00 00 02 00 00 00 0C 00}
    condition:
        $a
}

rule PEiD_01021_MEW_11_SE_1_1____Northfox_
{
    meta:
        description = "[MEW 11 SE 1.1 -> Northfox]"
        ep_only = "false"
    strings:
        $a = {E9 ?? ?? ?? ?? 0C ?? ?? ?? 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01022_MEW_11_SE_1_2_
{
    meta:
        description = "[MEW 11 SE 1.2]"
        ep_only = "false"
    strings:
        $a = {E9 ?? ?? ?? FF 0C ?? 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 0C ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01023_MEW_11_SE_v1_0____Northfox_
{
    meta:
        description = "[MEW 11 SE v1.0 -> Northfox]"
        ep_only = "true"
    strings:
        $a = {E9 ?? ?? ?? ?? 00 00 00 02 00 00 00 0C ?0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01024_MEW_11_SE_v1_1_
{
    meta:
        description = "[MEW 11 SE v1.1]"
        ep_only = "false"
    strings:
        $a = {E9 ?? ?? ?? FF 0C ?? 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01025_Mew_11_SE_v1_2__Eng_____Northfox_
{
    meta:
        description = "[Mew 11 SE v1.2 (Eng) -> Northfox]"
        ep_only = "true"
    strings:
        $a = {E9 ?? ?? ?? FF 0C ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_01026_MEW_11_SE_v1_2____Northfox_HCC_
{
    meta:
        description = "[MEW 11 SE v1.2 -> Northfox[HCC]"
        ep_only = "true"
    strings:
        $a = {E9 ?? ?? ?? FF 0C ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 0C ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01027_MEW_11_SE_v1_2_
{
    meta:
        description = "[MEW 11 SE v1.2]"
        ep_only = "false"
    strings:
        $a = {E9 ?? ?? ?? FF 0C ?? 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 0C ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01028_MEW_5_1_0____Northfox_
{
    meta:
        description = "[MEW 5 1.0 -> Northfox]"
        ep_only = "true"
    strings:
        $a = {BE 5B 00 40 00 AD 91 AD 93 53 AD 96 56 5F AC C0 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01029_Mew_5_0_1____NorthFox___HCC_
{
    meta:
        description = "[Mew 5.0.1 -> NorthFox / HCC]"
        ep_only = "true"
    strings:
        $a = {BE 5B 00 40 00 AD 91 AD 93 53 AD 96 56 5F AC C0 C0 ?? 04 ?? C0 C8 ?? AA E2 F4 C3 00 ?? ?? 00 ?? ?? ?? 00 00 10 40 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01030_MicroJoiner_1_1____coban2k_
{
    meta:
        description = "[MicroJoiner 1.1 -> coban2k]"
        ep_only = "true"
    strings:
        $a = {BE 0C 70 40 00 BB F8 11 40 00 33 ED 83 EE 04 39 2E 74 11}
    condition:
        $a at pe.entry_point
}

rule PEiD_01031_MicroJoiner_1_5____coban2k_
{
    meta:
        description = "[MicroJoiner 1.5 -> coban2k]"
        ep_only = "true"
    strings:
        $a = {BF 05 10 40 00 83 EC 30 8B EC E8 C8 FF FF FF E8 C3 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01032_MicroJoiner_1_6____coban2k_
{
    meta:
        description = "[MicroJoiner 1.6 -> coban2k]"
        ep_only = "true"
    strings:
        $a = {33 C0 64 8B 38 48 8B C8 F2 AF AF 8B 1F 66 33 DB 66 81 3B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01033_MicroJoiner_1_7____coban2k_
{
    meta:
        description = "[MicroJoiner 1.7 -> coban2k]"
        ep_only = "true"
    strings:
        $a = {BF 00 10 40 00 8D 5F 21 6A 0A 58 6A 04 59 60 57 E8 8E 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01034_Microsoft__R__Full_text_index_file_
{
    meta:
        description = "[Microsoft (R) Full-text index file]"
        ep_only = "false"
    strings:
        $a = {6C 6C 2D 74 65 78 74 20 69 6E 64 65 78}
    condition:
        $a
}

rule PEiD_01035_Microsoft__R__Incremental_Linker_Version_5_12_8078__MASM_TASM__
{
    meta:
        description = "[Microsoft (R) Incremental Linker Version 5.12.8078 (MASM/TASM)]"
        ep_only = "false"
    strings:
        $a = {6A 00 68 00 30 40 00 68 1E 30 40 00 6A 00 E8 0D 00 00 00 6A 00 E8 00 00 00 00 FF 25 00 20 40 00 FF 25 08 20 40}
    condition:
        $a
}

rule PEiD_01036_Microsoft_Access_Database_file_
{
    meta:
        description = "[Microsoft Access Database file]"
        ep_only = "false"
    strings:
        $a = {00 01 00 00 53 74 61 6E 64 61 72 64 20 4A 65 74 20 44 42 00}
    condition:
        $a
}

rule PEiD_01037_Microsoft_Basic_Compiler_v5_60_1982_97_
{
    meta:
        description = "[Microsoft Basic Compiler v5.60 1982-97]"
        ep_only = "true"
    strings:
        $a = {9A ?? ?? ?? ?? 9A ?? ?? ?? ?? 9A ?? ?? ?? ?? 33 DB BA ?? ?? 9A ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 33 DB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01038_Microsoft_C__1988_1989__
{
    meta:
        description = "[Microsoft C (1988/1989)]"
        ep_only = "true"
    strings:
        $a = {B4 30 CD 21 3C 02 73 ?? CD 20 BF ?? ?? 8B ?? ?? ?? 2B F7 81 ?? ?? ?? 72}
    condition:
        $a at pe.entry_point
}

rule PEiD_01039_Microsoft_C__1990_1992__
{
    meta:
        description = "[Microsoft C (1990/1992)]"
        ep_only = "true"
    strings:
        $a = {B4 30 CD 21 3C 02 73 ?? 33 C0 06 50 CB BF ?? ?? 8B 36 ?? ?? 2B F7 81 FE ?? ?? 72 ?? BE ?? ?? FA 8E D7}
    condition:
        $a at pe.entry_point
}

rule PEiD_01040_Microsoft_C_for_Windows__1__
{
    meta:
        description = "[Microsoft C for Windows (1)]"
        ep_only = "true"
    strings:
        $a = {33 ED 55 9A ?? ?? ?? ?? 0B C0 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_01041_Microsoft_C_for_Windows__2__
{
    meta:
        description = "[Microsoft C for Windows (2)]"
        ep_only = "true"
    strings:
        $a = {8C D8 ?? 45 55 8B EC 1E 8E D8 57 56 89}
    condition:
        $a at pe.entry_point
}

rule PEiD_01042_Microsoft_C_Library_1985_
{
    meta:
        description = "[Microsoft C Library 1985]"
        ep_only = "true"
    strings:
        $a = {BF ?? ?? 8B 36 ?? ?? 2B F7 81 FE ?? ?? 72 ?? BE ?? ?? FA 8E D7 81 C4 ?? ?? FB 73}
    condition:
        $a at pe.entry_point
}

rule PEiD_01043_Microsoft_C_v1_04_
{
    meta:
        description = "[Microsoft C v1.04]"
        ep_only = "true"
    strings:
        $a = {FA B8 ?? ?? 8E D8 8E D0 26 8B ?? ?? ?? 2B D8 F7 ?? ?? ?? 75 ?? B1 04 D3 E3 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01044_Microsoft_C____1990_1992__
{
    meta:
        description = "[Microsoft C++ (1990/1992)]"
        ep_only = "true"
    strings:
        $a = {B8 00 30 CD 21 3C 03 73 ?? 0E 1F BA ?? ?? B4 09 CD 21 06 33 C0 50 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01045_Microsoft_C_
{
    meta:
        description = "[Microsoft C]"
        ep_only = "true"
    strings:
        $a = {B4 30 CD 21 3C 02 73 ?? B8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01046_Microsoft_CAB_SFX_module_
{
    meta:
        description = "[Microsoft CAB SFX module]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 44 56 FF 15 ?? 10 00 01 8B F0 8A 06 3C 22 75 14 8A 46 01 46 84 C0 74 04 3C 22 75 F4 80 3E 22 75 0D ?? EB 0A 3C 20}
    condition:
        $a at pe.entry_point
}

rule PEiD_01047_Microsoft_CAB_SFX_
{
    meta:
        description = "[Microsoft CAB SFX]"
        ep_only = "true"
    strings:
        $a = {E8 0A 00 00 00 E9 7A FF FF FF CC CC CC CC CC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01048_Microsoft_FORTRAN_
{
    meta:
        description = "[Microsoft FORTRAN]"
        ep_only = "true"
    strings:
        $a = {FC 1E B8 ?? ?? 8E D8 9A ?? ?? ?? ?? 81 ?? ?? ?? 8B EC 8C DB 8E C3 BB ?? ?? B9 ?? ?? 9A ?? ?? ?? ?? 80 ?? ?? ?? ?? 74 ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01049_Microsoft_Resource_Cursors_file_
{
    meta:
        description = "[Microsoft Resource Cursors file]"
        ep_only = "false"
    strings:
        $a = {00 00 02 00 01 00 20 20 00 00 ?? 00 ?? 00 E8 02 00 00 16}
    condition:
        $a
}

rule PEiD_01050_Microsoft_Visual_Basic_5_0_
{
    meta:
        description = "[Microsoft Visual Basic 5.0]"
        ep_only = "false"
    strings:
        $a = {FF FF FF 00 00 00 00 00 00 30 00 00 00 40 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01051_Microsoft_Visual_Basic_v5_0___v6_0_
{
    meta:
        description = "[Microsoft Visual Basic v5.0 - v6.0]"
        ep_only = "false"
    strings:
        $a = {68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 00 00 ?? 00 00 00 30 ?? 00}
    condition:
        $a
}

rule PEiD_01052_Microsoft_Visual_Basic_v5_0___v6_0_
{
    meta:
        description = "[Microsoft Visual Basic v5.0 - v6.0]"
        ep_only = "false"
    strings:
        $a = {FF 25 ?? ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? FF FF FF}
    condition:
        $a
}

rule PEiD_01053_Microsoft_Visual_Basic_v5_0_v6_0_
{
    meta:
        description = "[Microsoft Visual Basic v5.0/v6.0]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 00 00 00 00 00 00 30 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01054_Microsoft_Visual_Basic_v5_0_
{
    meta:
        description = "[Microsoft Visual Basic v5.0]"
        ep_only = "true"
    strings:
        $a = {?? ?? ?? ?? ?? ?? ?? FF FF FF 00 00 00 00 00 00 30 00 00 00 40 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01055_Microsoft_Visual_Basic_v6_0_DLL_
{
    meta:
        description = "[Microsoft Visual Basic v6.0 DLL]"
        ep_only = "true"
    strings:
        $a = {5A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E9 ?? ?? FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01056_Microsoft_Visual_Basic_v6_0_
{
    meta:
        description = "[Microsoft Visual Basic v6.0]"
        ep_only = "false"
    strings:
        $a = {FF 25 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? FF FF FF ?? ?? ?? ?? ?? ?? 30}
    condition:
        $a
}

rule PEiD_01057_Microsoft_Visual_C_2_0_
{
    meta:
        description = "[Microsoft Visual C 2.0]"
        ep_only = "true"
    strings:
        $a = {64 A1 00 00 00 00 55 8B EC 6A FF 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_01058_Microsoft_Visual_C_5_0_
{
    meta:
        description = "[Microsoft Visual C 5.0]"
        ep_only = "false"
    strings:
        $a = {64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 C4 A8 53 56 57}
    condition:
        $a
}

rule PEiD_01059_Microsoft_Visual_C_v2_0_
{
    meta:
        description = "[Microsoft Visual C v2.0]"
        ep_only = "true"
    strings:
        $a = {53 56 57 BB ?? ?? ?? ?? 8B ?? ?? ?? 55 3B FB 75}
    condition:
        $a at pe.entry_point
}

rule PEiD_01060_Microsoft_Visual_C____Basic__NET_
{
    meta:
        description = "[Microsoft Visual C# / Basic .NET]"
        ep_only = "true"
    strings:
        $a = {FF 25 00 20 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01061_Microsoft_Visual_C__v7_0___Basic__NET_
{
    meta:
        description = "[Microsoft Visual C# v7.0 / Basic .NET]"
        ep_only = "false"
    strings:
        $a = {FF 25 00 20 40 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01062_Microsoft_Visual_C____3_0_old_crap__
{
    meta:
        description = "[Microsoft Visual C++ (3.0 old crap)]"
        ep_only = "true"
    strings:
        $a = {64 A1 00 00 00 00 55 ?? ?? 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 ?? ?? ?? ?? ?? 00 00 83 EC 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_01063_Microsoft_Visual_C___4_2_
{
    meta:
        description = "[Microsoft Visual C++ 4.2]"
        ep_only = "true"
    strings:
        $a = {64 A1 00 00 00 00 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 64 ?? ?? ?? ?? ?? ?? 83 ?? ?? 53 56 57 89}
    condition:
        $a at pe.entry_point
}

rule PEiD_01064_Microsoft_Visual_C___5_0___7_1_
{
    meta:
        description = "[Microsoft Visual C++ 5.0 - 7.1]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 81 EC 04 01 00 00 68 04 01 00 00 8D 85 FC FE FF FF 50 6A 00 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D FC FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? 8B E5 5D C2 10 00}
    condition:
        $a
}

rule PEiD_01065_Microsoft_Visual_C___6_0___8_0_
{
    meta:
        description = "[Microsoft Visual C++ 6.0 - 8.0]"
        ep_only = "false"
    strings:
        $a = {3D 00 10 00 00 73 0E F7 D8 03 C4 83 C0 04 85 00 94 8B 00 50 C3 51 8D 4C 24 08 81 E9 00 10 00 00 2D 00 10 00 00 85 01 3D 00 10 00 00 73 EC 2B C8 8B C4 85 01 8B E1 8B 08 8B 40 04 50 C3}
    condition:
        $a
}

rule PEiD_01066_Microsoft_Visual_C___6_0___8_0_
{
    meta:
        description = "[Microsoft Visual C++ 6.0 - 8.0]"
        ep_only = "false"
    strings:
        $a = {68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 8B 45 F8 89 65 E8 50 8B 45 FC C7 45 FC FF FF FF FF 89 45 F8 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B C9 51 C3}
    condition:
        $a
}

rule PEiD_01067_Microsoft_Visual_C___6_0___8_0_
{
    meta:
        description = "[Microsoft Visual C++ 6.0 - 8.0]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 8B 45 F8 89 65 E8 50 8B 45 FC C7 45 FC FF FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B C9 51}
    condition:
        $a at pe.entry_point
}

rule PEiD_01068_Microsoft_Visual_C___6_0___8_0_
{
    meta:
        description = "[Microsoft Visual C++ 6.0 - 8.0]"
        ep_only = "false"
    strings:
        $a = {68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 8B 45 F8 89 65 E8 50 8B 45 FC C7 45 FC FF FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B C9 51 C3}
    condition:
        $a
}

rule PEiD_01069_Microsoft_Visual_C___6_0___8_0_
{
    meta:
        description = "[Microsoft Visual C++ 6.0 - 8.0]"
        ep_only = "false"
    strings:
        $a = {8B 44 24 08 85 C0 0F 84 ?? ?? ?? ?? 83 F8 01 8B 0D ?? ?? ?? ?? 8B 09 89 0D ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 68 80 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 59 A3 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 83 20 00 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8}
    condition:
        $a
}

rule PEiD_01070_Microsoft_Visual_C___6_0___8_0_
{
    meta:
        description = "[Microsoft Visual C++ 6.0 - 8.0]"
        ep_only = "false"
    strings:
        $a = {8B 44 24 08 8B 4C 24 10 0B C8 8B 4C 24 0C 75 09 8B 44 24 04 F7 E1 C2 10 00 53 F7 E1 8B D8 8B 44 24 08 F7 64 24 14 03 D8 8B 44 24 08 F7 E1 03 D3 5B C2 10 00}
    condition:
        $a
}

rule PEiD_01071_Microsoft_Visual_C___6_0_DLL__Debug__
{
    meta:
        description = "[Microsoft Visual C++ 6.0 DLL (Debug)]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 ?? ?? 83}
    condition:
        $a
}

rule PEiD_01072_Microsoft_Visual_C___6_0_DLL_
{
    meta:
        description = "[Microsoft Visual C++ 6.0 DLL]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 75 09 83 3D ?? ?? ?? ?? ?? EB 26 83 FE 01 74 05 83 FE 02 75 22 A1 ?? ?? ?? ?? 85 C0 74 09 57 56 53 FF D0 85 C0 74 0C 57 56 53 E8 15 FF FF FF 85 C0 75 04 33 C0 EB 4E}
    condition:
        $a
}

rule PEiD_01073_Microsoft_Visual_C___6_0_SFX_Custom_
{
    meta:
        description = "[Microsoft Visual C++ 6.0 SFX Custom]"
        ep_only = "true"
    strings:
        $a = {E8 21 48 00 00 E9 16 FE FF FF 51 C7 01 08 B4 00 30 E8 A4 48 00 00 59 C3 56 8B F1 E8 EA FF FF FF F6 ?? ?? ?? ?? 74 07 56 E8 F6 04 00 00 59 8B C6 5E C2 04 00 8B 44 24 04 83 C1 09 51 83 C0 09 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_01074_Microsoft_Visual_C___7_0_Custom_
{
    meta:
        description = "[Microsoft Visual C++ 7.0 Custom]"
        ep_only = "true"
    strings:
        $a = {60 BE 00 B0 44 00 8D BE 00 60 FB FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73}
    condition:
        $a at pe.entry_point
}

rule PEiD_01075_Microsoft_Visual_C___7_0_DLL_
{
    meta:
        description = "[Microsoft Visual C++ 7.0 DLL]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 53 8B 5D 08 56 8B 75 0C 85 F6 57 8B 7D 10 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01}
    condition:
        $a
}

rule PEiD_01076_Microsoft_Visual_C___7_0_MFC_
{
    meta:
        description = "[Microsoft Visual C++ 7.0 MFC]"
        ep_only = "true"
    strings:
        $a = {6A 60 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BF 94 00 00 00 8B C7 E8 ?? ?? ?? ?? 89}
    condition:
        $a at pe.entry_point
}

rule PEiD_01077_Microsoft_Visual_C___7_0_
{
    meta:
        description = "[Microsoft Visual C++ 7.0]"
        ep_only = "true"
    strings:
        $a = {6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 40 89 45 E4 8B 75 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_01078_Microsoft_Visual_C___7_0_
{
    meta:
        description = "[Microsoft Visual C++ 7.0]"
        ep_only = "true"
    strings:
        $a = {6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BF 94 00 00 00 8B C7 E8 ?? ?? ?? ?? 89}
    condition:
        $a at pe.entry_point
}

rule PEiD_01079_Microsoft_Visual_C___7_1_
{
    meta:
        description = "[Microsoft Visual C++ 7.1]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 0F 85 AB 00 00 00 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 FC 8B 73 0C 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 0B C0 74 7B 83 FE FF 74 7D 8D 0C 76 8B 44 8F 04 0B C0 74 59 56 55}
    condition:
        $a
}

rule PEiD_01080_Microsoft_Visual_C___7_1_
{
    meta:
        description = "[Microsoft Visual C++ 7.1]"
        ep_only = "false"
    strings:
        $a = {8B FF 55 8B EC 56 33 F6 39 75 0C 0F 84 ?? ?? ?? ?? 83 7D 0C 01 A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 39 75 0C 0F 84 ?? ?? ?? ?? 33 C0 40 5E 5D C2 0C 00}
    condition:
        $a
}

rule PEiD_01081_Microsoft_Visual_C___7_1_
{
    meta:
        description = "[Microsoft Visual C++ 7.1]"
        ep_only = "false"
    strings:
        $a = {8B FF 55 8B EC 56 33 F6 39 75 0C 0F 84 ?? ?? ?? ?? 83 7D 0C 01 A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 68 80 00 00 00 FF 15 ?? ?? ?? ?? 3B C6 59 A3 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 89 30 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? A3}
    condition:
        $a
}

rule PEiD_01082_Microsoft_Visual_C___7_1_
{
    meta:
        description = "[Microsoft Visual C++ 7.1]"
        ep_only = "false"
    strings:
        $a = {8B FF 55 8B EC 56 33 F6 39 75 0C 0F 84 ?? ?? ?? ?? 83 7D 0C 01 A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 68 80 00 00 00 FF 15 ?? ?? ?? ?? 3B C6 59 A3 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 89 30 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? 59 59 33 C0 40 5E 5D C2 0C 00}
    condition:
        $a
}

rule PEiD_01083_Microsoft_Visual_C___7_1_
{
    meta:
        description = "[Microsoft Visual C++ 7.1]"
        ep_only = "false"
    strings:
        $a = {8B FF 55 8B EC 56 33 F6 39 75 0C 0F 84 ?? ?? ?? ?? 83 7D 0C 01 A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 75 44 68 80 00 00 00 FF 15 ?? ?? ?? ?? 3B C6 59 A3 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 89 30 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8}
    condition:
        $a
}

rule PEiD_01084_Microsoft_Visual_C___7_1_
{
    meta:
        description = "[Microsoft Visual C++ 7.1]"
        ep_only = "false"
    strings:
        $a = {8B FF 55 8B EC 56 33 F6 39 75 0C 75 0E 39 35 ?? ?? ?? ?? 7E 2D FF 0D ?? ?? ?? ?? 83 7D 0C 01 A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 75 3D 68 80 00 00 00 FF 15 ?? ?? ?? ?? 3B C6 59 A3 ?? ?? ?? ?? 75 04 33 C0 EB 67 89 30 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68}
    condition:
        $a
}

rule PEiD_01085_Microsoft_Visual_C___8_0__MFC__
{
    meta:
        description = "[Microsoft Visual C++ 8.0 (MFC)]"
        ep_only = "true"
    strings:
        $a = {48 83 EC 28 E8 ?? ?? 00 00 48 83 C4 28 E9 0E FD FF FF CC CC CC CC CC CC CC CC CC CC CC CC CC CC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01086_Microsoft_Visual_C___8_0__MFC__
{
    meta:
        description = "[Microsoft Visual C++ 8.0 (MFC)]"
        ep_only = "true"
    strings:
        $a = {C0 ?? ?? 00 00 00 00 00 00 ?? ?? 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? ?? ?? 00 00 00 00 00 ?? 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 ?? 00 00 00 00 00 ?? ?? ?? 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01087_Microsoft_Visual_C___8_0__Debug_
{
    meta:
        description = "[Microsoft Visual C++ 8.0 [Debug]"
        ep_only = "true"
    strings:
        $a = {E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01088_Microsoft_Visual_C___8_0__Debug__
{
    meta:
        description = "[Microsoft Visual C++ 8.0 [Debug]]"
        ep_only = "true"
    strings:
        $a = {E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01089_Microsoft_Visual_C___8_0_
{
    meta:
        description = "[Microsoft Visual C++ 8.0]"
        ep_only = "true"
    strings:
        $a = {48 83 EC 28 E8 ?? ?? 00 00 48 83 C4 28 E9 ?? ?? FF FF CC CC CC CC CC CC CC CC CC CC CC CC CC CC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01090_Microsoft_Visual_C___8_0_
{
    meta:
        description = "[Microsoft Visual C++ 8.0]"
        ep_only = "false"
    strings:
        $a = {83 3D ?? ?? ?? ?? 00 74 1A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 74 0B FF 74 24 04 FF 15 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 59 75 54 56 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 8B C6 BF}
    condition:
        $a
}

rule PEiD_01091_Microsoft_Visual_C___8_
{
    meta:
        description = "[Microsoft Visual C++ 8]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? 00 00 E9 ?? ?? FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01092_Microsoft_Visual_C_______
{
    meta:
        description = "[Microsoft Visual C++ ?.?]"
        ep_only = "true"
    strings:
        $a = {83 ?? ?? 6A 00 FF 15 F8 10 0B B0 8D ?? ?? ?? 51 6A 08 6A 00 6A 00 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_01093_Microsoft_Visual_C___DLL_
{
    meta:
        description = "[Microsoft Visual C++ DLL]"
        ep_only = "true"
    strings:
        $a = {53 55 56 8B 74 24 14 85 F6 57 B8 01 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01094_Microsoft_Visual_C___DLL_
{
    meta:
        description = "[Microsoft Visual C++ DLL]"
        ep_only = "true"
    strings:
        $a = {53 56 57 BB 01 ?? ?? ?? 8B ?? 24 14}
    condition:
        $a at pe.entry_point
}

rule PEiD_01095_Microsoft_Visual_C___DLL_
{
    meta:
        description = "[Microsoft Visual C++ DLL]"
        ep_only = "true"
    strings:
        $a = {53 B8 01 00 00 00 8B 5C 24 0C 56 57 85 DB 55 75 12 83 3D ?? ?? ?? ?? ?? 75 09 33 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01096_Microsoft_Visual_C___DLL_
{
    meta:
        description = "[Microsoft Visual C++ DLL]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 56 57 BF 01 00 00 00 8B 75 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_01097_Microsoft_Visual_C___v4_2_DLL_
{
    meta:
        description = "[Microsoft Visual C++ v4.2 DLL]"
        ep_only = "true"
    strings:
        $a = {53 B8 ?? ?? ?? ?? 8B ?? ?? ?? 56 57 85 DB 55 75}
    condition:
        $a at pe.entry_point
}

rule PEiD_01098_Microsoft_Visual_C___v4_2_
{
    meta:
        description = "[Microsoft Visual C++ v4.2]"
        ep_only = "true"
    strings:
        $a = {64 A1 00 00 00 00 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 64 ?? ?? ?? ?? ?? ?? 83 ?? ?? 53 56 57 89 ?? ?? C7}
    condition:
        $a at pe.entry_point
}

rule PEiD_01099_Microsoft_Visual_C___v4_2_
{
    meta:
        description = "[Microsoft Visual C++ v4.2]"
        ep_only = "true"
    strings:
        $a = {64 A1 00 00 00 00 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 64 ?? ?? ?? ?? ?? ?? 83 ?? ?? 53 56 57 89 ?? ?? FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01100_Microsoft_Visual_C___v4_x_
{
    meta:
        description = "[Microsoft Visual C++ v4.x]"
        ep_only = "true"
    strings:
        $a = {64 A1 00 00 00 00 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 64 89 25 00 00 00 00 83 EC ?? 53 56 57}
    condition:
        $a at pe.entry_point
}

rule PEiD_01101_Microsoft_Visual_C___v5_0_v6_0__MFC__
{
    meta:
        description = "[Microsoft Visual C++ v5.0/v6.0 (MFC)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_01102_Microsoft_Visual_C___v5_0_
{
    meta:
        description = "[Microsoft Visual C++ v5.0]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 68 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 53 56 57}
    condition:
        $a at pe.entry_point
}

rule PEiD_01103_Microsoft_Visual_C___v6_0_DLL_
{
    meta:
        description = "[Microsoft Visual C++ v6.0 DLL]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 8B 5D 08 56 8B 75 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_01104_Microsoft_Visual_C___v6_0_DLL_
{
    meta:
        description = "[Microsoft Visual C++ v6.0 DLL]"
        ep_only = "true"
    strings:
        $a = {55 8D 6C ?? ?? 81 EC ?? ?? ?? ?? 8B 45 ?? 83 F8 01 56 0F 84 ?? ?? ?? ?? 85 C0 0F 84}
    condition:
        $a at pe.entry_point
}

rule PEiD_01105_Microsoft_Visual_C___v6_0_DLL_
{
    meta:
        description = "[Microsoft Visual C++ v6.0 DLL]"
        ep_only = "true"
    strings:
        $a = {83 7C 24 08 01 75 09 8B 44 24 04 A3 ?? ?? 00 10 E8 8B FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01106_Microsoft_Visual_C___v6_0_SPx_
{
    meta:
        description = "[Microsoft Visual C++ v6.0 SPx]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 44 56 FF 15 ?? ?? ?? ?? 6A 01 8B F0 FF 15}
    condition:
        $a at pe.entry_point
}

rule PEiD_01107_Microsoft_Visual_C___v6_0_SPx_
{
    meta:
        description = "[Microsoft Visual C++ v6.0 SPx]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 44 56 FF 15 ?? ?? ?? ?? 8B F0 8A ?? 3C 22}
    condition:
        $a at pe.entry_point
}

rule PEiD_01108_Microsoft_Visual_C___v6_0_
{
    meta:
        description = "[Microsoft Visual C++ v6.0]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC ?? 53 56 57}
    condition:
        $a
}

rule PEiD_01109_Microsoft_Visual_C___v6_0_
{
    meta:
        description = "[Microsoft Visual C++ v6.0]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 50 53 56 57 BE ?? ?? ?? ?? 8D 7D F4 A5 A5 66 A5 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01110_Microsoft_Visual_C___v6_0_
{
    meta:
        description = "[Microsoft Visual C++ v6.0]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? 00 68 ?? ?? ?? 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC ?? 53 56 57 89 65 E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF}
    condition:
        $a
}

rule PEiD_01111_Microsoft_Visual_C___v7_0__64_Bit__
{
    meta:
        description = "[Microsoft Visual C++ v7.0 (64 Bit)]"
        ep_only = "true"
    strings:
        $a = {?? ?? 41 00 00 00 00 00 00 00 63 00 00 00 00 00 ?? 00 ?? ?? ?? ?? ?? 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? 20 ?? ?? 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? ?? ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? ?? ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? ?? ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? ?? ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? ?? ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? 00 ?? 00 ?? ?? ?? 00 ?? 00 ?? 00 ?? 00 ?? 00 ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01112_Microsoft_Visual_C___v7_0__64_Bit__
{
    meta:
        description = "[Microsoft Visual C++ v7.0 (64 Bit)]"
        ep_only = "false"
    strings:
        $a = {?? ?? 41 00 00 00 00 00 00 00 63 00 00 00 00 00 ?? 00 ?? ?? ?? ?? ?? 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? 20 ?? ?? 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? 00}
    condition:
        $a
}

rule PEiD_01113_Microsoft_Visual_C___v7_0_DLL_
{
    meta:
        description = "[Microsoft Visual C++ v7.0 DLL]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 ?? ?? 83}
    condition:
        $a
}

rule PEiD_01114_Microsoft_Visual_C___v7_0_DLL_
{
    meta:
        description = "[Microsoft Visual C++ v7.0 DLL]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 8B 5D 08 56 8B 75 0C 85 F6 57 8B 7D 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_01115_Microsoft_Visual_C___v7_0_
{
    meta:
        description = "[Microsoft Visual C++ v7.0]"
        ep_only = "true"
    strings:
        $a = {6A 0C 68 88 BF 01 10 E8 B8 1C 00 00 33 C0 40 89 45 E4 8B 75 0C 33 FF 3B F7 75 0C 39 3D 6C 1E 12 10 0F 84 B3 00 00 00 89 7D FC 3B F0 74 05 83 FE 02 75 31 A1 98 36 12 10 3B C7 74 0C FF 75 10 56}
    condition:
        $a at pe.entry_point
}

rule PEiD_01116_Microsoft_Visual_C___v7_0_
{
    meta:
        description = "[Microsoft Visual C++ v7.0]"
        ep_only = "true"
    strings:
        $a = {6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BF ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 89 65 ?? 8B F4 89 3E 56 FF 15 ?? ?? ?? ?? 8B 4E ?? 89 0D ?? ?? ?? ?? 8B 46 ?? A3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01117_Microsoft_Visual_C___v7_1_DLL_
{
    meta:
        description = "[Microsoft Visual C++ v7.1 DLL]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 8B 5D 08 56 8B 75 0C 85 F6 57 8B 7D 10 75 09 83 3D ?? ?? 40 00 00 EB 26 83 FE 01 74 05 83 FE 02 75 22 A1}
    condition:
        $a at pe.entry_point
}

rule PEiD_01118_Microsoft_Visual_C___v7_1_DLL_
{
    meta:
        description = "[Microsoft Visual C++ v7.1 DLL]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 C4 E4 53 56 57 89 65 E8 C7 45 E4 01 00 00 00 C7 45 FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01119_Microsoft_Visual_C___v7_1_DLL_
{
    meta:
        description = "[Microsoft Visual C++ v7.1 DLL]"
        ep_only = "true"
    strings:
        $a = {6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 40 89 45 E4}
    condition:
        $a at pe.entry_point
}

rule PEiD_01120_Microsoft_Visual_C___v7_1_DLL_
{
    meta:
        description = "[Microsoft Visual C++ v7.1 DLL]"
        ep_only = "true"
    strings:
        $a = {83 7C 24 08 01 75 ?? ?? ?? 24 04 50 A3 ?? ?? ?? 50 FF 15 00 10 ?? 50 33 C0 40 C2 0C 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01121_Microsoft_Visual_C___v7_1_EXE_
{
    meta:
        description = "[Microsoft Visual C++ v7.1 EXE]"
        ep_only = "true"
    strings:
        $a = {6A ?? 68 ?? ?? ?? 01 E8 ?? ?? 00 00 66 81 3D 00 00 00 01 4D 5A 75 ?? A1 3C 00 00 01 ?? ?? 00 00 00 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01122_Microsoft_Visual_C___V8_0_
{
    meta:
        description = "[Microsoft Visual C++ V8.0]"
        ep_only = "true"
    strings:
        $a = {6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BB 94 00 00 00 53 6A 00 8B ?? ?? ?? ?? ?? FF D7 50 FF ?? ?? ?? ?? ?? 8B F0 85 F6 75 0A 6A 12 E8 ?? ?? ?? ?? 59 EB 18 89 1E 56 FF ?? ?? ?? ?? ?? 56 85 C0 75 14 50 FF D7 50 FF ?? ?? ?? ?? ?? B8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01123_Microsoft_Visual_C___vx_x_
{
    meta:
        description = "[Microsoft Visual C++ vx.x]"
        ep_only = "true"
    strings:
        $a = {53 55 56 8B ?? ?? ?? 85 F6 57 B8 ?? ?? ?? ?? 75 ?? 8B ?? ?? ?? ?? ?? 85 C9 75 ?? 33 C0 5F 5E 5D 5B C2}
    condition:
        $a at pe.entry_point
}

rule PEiD_01124_Microsoft_Visual_C___vx_x_
{
    meta:
        description = "[Microsoft Visual C++ vx.x]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 56 57 BF ?? ?? ?? ?? 8B ?? ?? 3B F7 0F}
    condition:
        $a at pe.entry_point
}

rule PEiD_01125_Microsoft_Visual_C___
{
    meta:
        description = "[Microsoft Visual C++]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00}
    condition:
        $a
}

rule PEiD_01126_Microsoft_Visual_C___
{
    meta:
        description = "[Microsoft Visual C++]"
        ep_only = "true"
    strings:
        $a = {8B 44 24 08 56 83 E8 ?? 74 ?? 48 75}
    condition:
        $a at pe.entry_point
}

rule PEiD_01127_Microsoft_Visual_C___
{
    meta:
        description = "[Microsoft Visual C++]"
        ep_only = "true"
    strings:
        $a = {8B 44 24 08 83 ?? ?? 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_01128_Microsoft_Visual_Studio__NET_
{
    meta:
        description = "[Microsoft Visual Studio .NET]"
        ep_only = "true"
    strings:
        $a = {FF 25 00 20 40 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01129_Microsoft_WAV_Audio_file_
{
    meta:
        description = "[Microsoft WAV Audio file]"
        ep_only = "false"
    strings:
        $a = {52 49 46 46 ?? ?? ?? ?? 57 41 56 45 66 6D 74}
    condition:
        $a
}

rule PEiD_01130_Microsoft_Windows_Shortcut_file_
{
    meta:
        description = "[Microsoft Windows Shortcut file]"
        ep_only = "false"
    strings:
        $a = {4C 00 00 00 01 14 02 00 00 00}
    condition:
        $a
}

rule PEiD_01131_Microsoft_Windows_Update_CAB_SFX_module_
{
    meta:
        description = "[Microsoft Windows Update CAB SFX module]"
        ep_only = "false"
    strings:
        $a = {E9 C5 FA FF FF 55 8B EC 56 8B 75 08 68 04 08 00 00 FF D6 59 33 C9 3B C1 75 0F 51 6A 05 FF 75 28 E8 2E 11 00 00 33 C0 EB 69 8B 55 0C 83 88 88 00 00 00 FF 83 88 84 00 00 00 FF 89 50 04 8B 55 10 89 50 0C 8B 55 14 89 50 10 8B 55 18 89 50 14 8B 55 1C 89 50 18}
    condition:
        $a
}

rule PEiD_01132_Microsoft_Windows_Update_CAB_SFX_module_
{
    meta:
        description = "[Microsoft Windows Update CAB SFX module]"
        ep_only = "false"
    strings:
        $a = {E9 C5 FA FF FF 55 8B EC 56 8B 75 08 68 04 08 00 00 FF D6 59 33 C9 3B C1 75 0F 51 6A 05 FF 75 28 E8 2E 11 00 00 33 C0 EB 69 8B 55 0C 83 88 88 00 00 00 FF 83 88 84 00 00 00 FF 89 50 04 8B 55 10 89 50 0C 8B 55 14 89 50 10 8B 55 18 89 50 14 8B 55 1C 89 50 18 8B 55 20 89 50 1C 8B 55 24 89 50 20 8B 55 28 89 48 48 89 48 44 89 48 4C B9 FF FF 00 00 89 70 08 89 10 66 C7 80 B2 00 00 00 0F 00 89 88 A0 00 00 00 89 88 A8 00 00 00 89 88 A4 00 00}
    condition:
        $a
}

rule PEiD_01133_MIDI_Music_file_
{
    meta:
        description = "[MIDI Music file]"
        ep_only = "false"
    strings:
        $a = {4D 54 68 64 00 00 00 06 ?? ?? ?? ?? ?? ?? 4D 54}
    condition:
        $a
}

rule PEiD_01134_MinGW_3_2_x__Dll_main__
{
    meta:
        description = "[MinGW 3.2.x (Dll_main)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 83 EC 18 89 75 FC 8B 75 0C 89 5D F8 83 FE 01 74 5C 89 74 24 04 8B 55 10 89 54 24 08 8B 55 08 89 14 24 E8 96 01 00 00 83 EC 0C 83 FE 01 89 C3 74 2C 85 F6 75 0C 8B 0D 00 30 00 10 85 C9 75 10 31 DB 89 D8 8B 5D F8 8B 75 FC 89 EC 5D C2 0C 00 E8 59 00}
    condition:
        $a
}

rule PEiD_01135_MinGW_3_2_x__Dll_WinMain__
{
    meta:
        description = "[MinGW 3.2.x (Dll_WinMain)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 83 EC 18 89 75 FC 8B 75 0C 89 5D F8 83 FE 01 74 5C 89 74 24 04 8B 55 10 89 54 24 08 8B 55 08 89 14 24 E8 76 01 00 00 83 EC 0C 83 FE 01 89 C3 74 2C 85 F6 75 0C 8B 0D 00 30 00 10 85 C9 75 10 31 DB 89 D8 8B 5D F8 8B 75 FC 89 EC 5D C2 0C 00 E8 59 00}
    condition:
        $a
}

rule PEiD_01136_MinGW_3_2_x__main__
{
    meta:
        description = "[MinGW 3.2.x (main)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 E4 40 40 00 E8 68 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 E4 40 40 00 E8 48 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 55 08 89 14 24 FF 15 00 41 40 00 89 EC 5D}
    condition:
        $a
}

rule PEiD_01137_MinGW_3_2_x__WinMain__
{
    meta:
        description = "[MinGW 3.2.x (WinMain)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 FC 40 40 00 E8 68 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 FC 40 40 00 E8 48 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 55 08 89 14 24 FF 15 18 41 40 00 89 EC 5D}
    condition:
        $a
}

rule PEiD_01138_MinGW_GCC_2_x_
{
    meta:
        description = "[MinGW GCC 2.x]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 ?? ?? ?? ?? ?? ?? FF FF ?? ?? ?? ?? ?? 00 ?? ?? 00 ?? ?? ?? 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01139_MinGW_GCC_3_x_
{
    meta:
        description = "[MinGW GCC 3.x]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 ?? 00 00 00 FF 15 ?? ?? ?? ?? E8 ?? ?? FF FF ?? ?? ?? ?? ?? ?? ?? ?? 55}
    condition:
        $a at pe.entry_point
}

rule PEiD_01140_MinGW_GCC_DLL_v2xx_
{
    meta:
        description = "[MinGW GCC DLL v2xx]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01141_MinGW_GCC_v2_x_
{
    meta:
        description = "[MinGW GCC v2.x]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 E8 ?? ?? ?? ?? C9 C3 ?? ?? 45 58 45}
    condition:
        $a at pe.entry_point
}

rule PEiD_01142_MinGW_v3_2_x___mainCRTStartup__
{
    meta:
        description = "[MinGW v3.2.x (_mainCRTStartup)]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 6A 00 6A 00 6A 00 6A 00 E8 0D 00 00 00 B8 00 00 00 00 C9 C3 90 90 90 90 90 90 FF 25 38 20 40 00 90 90 00 00 00 00 00 00 00 00 FF FF FF FF 00 00 00 00 FF FF FF FF 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01143_MinGW_v3_2_x__Dll_main__
{
    meta:
        description = "[MinGW v3.2.x (Dll_main)]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 18 89 75 FC 8B 75 0C 89 5D F8 83 FE 01 74 5C 89 74 24 04 8B 55 10 89 54 24 08 8B 55 08 89 14 24 E8 96 01 00 00 83 EC 0C 83 FE 01 89 C3 74 2C 85 F6 75 0C 8B 0D 00 30 00 10 85 C9 75 10 31 DB 89 D8 8B 5D F8 8B 75 FC 89 EC 5D C2 0C 00 E8 59 00 00 00 EB EB 8D B4 26 00 00 00 00 85 C0 75 D0 E8 47 00 00 00 EB C9 90 8D 74 26 00 C7 04 24 80 00 00 00 E8 F4 05 00 00 A3 00 30 00 10 85 C0 74 1A C7 00 00 00 00 00 A3 10 30 00 10 E8 3B 02 00 00 E8 C6 01 00 00 E9 75 FF FF FF E8 BC 05 00 00 C7 00 0C 00 00 00 31 C0 EB 98 89 F6 55 89 E5 83 EC 08 89 5D FC 8B 15 00 30 00 10 85 D2 74 29 8B 1D 10 30 00 10 83 EB 04 39 D3 72 0D 8B 03 85 C0 75 2A 83 EB 04 39 D3 73 F3 89 14 24 E8 6B 05 00 00 31 C0 A3 00 30 00 10 C7 04 24 00 00 00 00 E8 48 05 00 00 8B 5D FC 89 EC 5D C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01144_MinGW_v3_2_x__Dll_mainCRTStartup__
{
    meta:
        description = "[MinGW v3.2.x (Dll_mainCRTStartup)]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 6A 00 6A 00 6A 00 6A 00 E8 0D 00 00 00 B8 00 00 00 00 C9 C3 90 90 90 90 90 90 FF 25 38 20 00 10 90 90 00 00 00 00 00 00 00 00 FF FF FF FF 00 00 00 00 FF FF FF FF 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01145_MinGW_v3_2_x__Dll_WinMain__
{
    meta:
        description = "[MinGW v3.2.x (Dll_WinMain)]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 18 89 75 FC 8B 75 0C 89 5D F8 83 FE 01 74 5C 89 74 24 04 8B 55 10 89 54 24 08 8B 55 08 89 14 24 E8 76 01 00 00 83 EC 0C 83 FE 01 89 C3 74 2C 85 F6 75 0C 8B 0D 00 30 00 10 85 C9 75 10 31 DB 89 D8 8B 5D F8 8B 75 FC 89 EC 5D C2 0C 00 E8 59 00 00 00 EB EB 8D B4 26 00 00 00 00 85 C0 75 D0 E8 47 00 00 00 EB C9 90 8D 74 26 00 C7 04 24 80 00 00 00 E8 A4 05 00 00 A3 00 30 00 10 85 C0 74 1A C7 00 00 00 00 00 A3 10 30 00 10 E8 1B 02 00 00 E8 A6 01 00 00 E9 75 FF FF FF E8 6C 05 00 00 C7 00 0C 00 00 00 31 C0 EB 98 89 F6 55 89 E5 83 EC 08 89 5D FC 8B 15 00 30 00 10 85 D2 74 29 8B 1D 10 30 00 10 83 EB 04 39 D3 72 0D 8B 03 85 C0 75 2A 83 EB 04 39 D3 73 F3 89 14 24 E8 1B 05 00 00 31 C0 A3 00 30 00 10 C7 04 24 00 00 00 00 E8 F8 04 00 00 8B 5D FC 89 EC 5D C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01146_MinGW_v3_2_x__main__
{
    meta:
        description = "[MinGW v3.2.x (main)]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 E4 40 40 00 E8 68 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 E4 40 40 00 E8 48 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 55 08 89 14 24 FF 15 00 41 40 00 89 EC 5D C3 8D 76 00 8D BC 27 00 00 00 00 55 89 E5 83 EC 08 8B 55 08 89 14 24 FF 15 F4 40 40 00 89 EC 5D C3 8D 76 00 8D BC 27 00 00 00 00 55 89 E5 53 83 EC 24 C7 04 24 A0 11 40 00 E8 8D 07 00 00 83 EC 04 E8 85 02 00 00 C7 04 24 00 20 40 00 8B 15 10 20 40 00 8D 4D F8 C7 45 F8 00 00 00 00 89 4C 24 10 89 54 24 0C 8D 55 F4 89 54 24 08 C7 44 24 04 04 20 40 00 E8 02 07 00 00 A1 20 20 40 00 85 C0 74 76 A3 30 20 40 00 A1 F0 40 40 00 85 C0 74 1F 89 04 24 E8 C3 06 00 00 8B 1D 20 20 40 00 89 04 24 89 5C 24 04 E8 C1 06 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01147_MinGW_v3_2_x__WinMain__
{
    meta:
        description = "[MinGW v3.2.x (WinMain)]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 FC 40 40 00 E8 68 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 FC 40 40 00 E8 48 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 55 08 89 14 24 FF 15 18 41 40 00 89 EC 5D C3 8D 76 00 8D BC 27 00 00 00 00 55 89 E5 83 EC 08 8B 55 08 89 14 24 FF 15 0C 41 40 00 89 EC 5D C3 8D 76 00 8D BC 27 00 00 00 00 55 89 E5 53 83 EC 24 C7 04 24 A0 11 40 00 E8 5D 08 00 00 83 EC 04 E8 55 03 00 00 C7 04 24 00 20 40 00 8B 15 10 20 40 00 8D 4D F8 C7 45 F8 00 00 00 00 89 4C 24 10 89 54 24 0C 8D 55 F4 89 54 24 08 C7 44 24 04 04 20 40 00 E8 D2 07 00 00 A1 20 20 40 00 85 C0 74 76 A3 30 20 40 00 A1 08 41 40 00 85 C0 74 1F 89 04 24 E8 93 07 00 00 8B 1D 20 20 40 00 89 04 24 89 5C 24 04 E8 91 07 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01148_MingWin32___Dev_C___v4_9_9_1__h__
{
    meta:
        description = "[MingWin32 - Dev C++ v4.9.9.1 (h)]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 ?? ?? ?? 00 E8 C8 FE FF FF 90 8D B4 26 00 00 00 00 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 ?? ?? ?? 00 E8 A8 FE FF FF 90 8D B4 26 00 00 00 00 55 8B 0D ?? ?? ?? 00 89 E5 5D FF E1 8D 74 26 00 55 8B 0D ?? ?? ?? 00 89 E5 5D FF E1 90 90 90 90 55 89 E5 5D E9 ?? ?? 00 00 90 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01149_MingWin32_v_____h__
{
    meta:
        description = "[MingWin32 v?.? (h)]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 ?? 00 00 00 FF 15 ?? ?? ?? 00 E8 ?? FE FF FF 90 8D B4 26 00 00 00 00 55}
    condition:
        $a at pe.entry_point
}

rule PEiD_01150_Minke_1_0_1___by_Codius_
{
    meta:
        description = "[Minke 1.0.1 - by Codius]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 ?? ?? ?? ?? ?? 10 E8 7A F6 FF FF BE 68 66 00 10 33 C0 55 68 DB 40 00 10 64 FF 30 64 89 20 E8 FA F8 FF FF BA EC 40 00 10 8B C6 E8 F2 FA FF FF 8B D8 B8 6C 66 00 10 8B 16 E8 88 F2 FF FF B8 6C 66 00 10 E8 76 F2 FF FF 8B D0 8B C3 8B 0E E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01151_Minke_1_0_1___by_Codius_
{
    meta:
        description = "[Minke 1.0.1 - by Codius]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 ?? ?? ?? ?? ?? 10 E8 7A F6 FF FF BE 68 66 00 10 33 C0 55 68 DB 40 00 10 64 FF 30 64 89 20 E8 FA F8 FF FF BA EC 40 00 10 8B C6 E8 F2 FA FF FF 8B D8 B8 6C 66 00 10 8B 16 E8 88 F2 FF FF B8 6C 66 00 10 E8 76 F2 FF FF 8B D0 8B C3 8B 0E E8 E3 E4 FF FF E8 2A F9 FF FF E8 C1 F8 FF FF B8 6C 66 00 10 8B 16 E8 6D FA FF FF E8 14 F9 FF FF E8 AB F8 FF FF 8B 06 E8 B8 E3 FF FF 8B D8 B8 6C 66 00 10 E8 38 F2 FF FF 8B D3 8B 0E E8 A7 E4 FF ?? ?? ?? ?? C4 FB FF FF E8 E7 F8 FF FF 8B C3 E8 B0 E3 FF FF E8 DB F8 FF FF 33 C0 5A 59 59 64 89 10 68 E2 40 00 10 C3 E9 50 EB FF FF EB F8 5E 5B E8 BB EF FF FF 00 00 00 43 41 31 38}
    condition:
        $a at pe.entry_point
}

rule PEiD_01152_Minke_V1_0_1____Codius___Sign_by_fly_
{
    meta:
        description = "[Minke V1.0.1 -> Codius ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {26 3D 4F 38 C2 82 37 B8 F3 24 42 03 17 9B 3A 83 01 00 00 CC 00 00 00 00 06 00 00 00 01 64 53 74 75 62 00 10 55 54 79 70 65 73 00 00 C7 53 79 73 74 65 6D 00 00 81 53 79 73 49 6E 69 74 00 0C 4B 57 69 6E 64 6F 77 73 00 00 8A 75 46 75 6E 63 74 69 6F 6E 73}
    condition:
        $a
}

rule PEiD_01153_mkfpack____llydd_
{
    meta:
        description = "[mkfpack -> llydd]"
        ep_only = "false"
    strings:
        $a = {E8 00 00 00 00 5B 81 EB 05 00 00 00 8B 93 9F 08 00 00 53 6A 40 68 00 10 00 00 52 6A 00 FF 93 32 08 00 00 5B 8B F0 8B BB 9B 08 00 00 03 FB 56 57 E8 86 08 00 00 83 C4 08 8D 93 BB 08 00 00 52 53 FF E6}
    condition:
        $a
}

rule PEiD_01154_modified_HACKSTOP_v1_11f_
{
    meta:
        description = "[modified HACKSTOP v1.11f]"
        ep_only = "true"
    strings:
        $a = {52 B4 30 CD 21 52 FA ?? FB 3D ?? ?? EB ?? CD 20 0E 1F B4 09 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01155_MoleBox_v2_3_0____Teggo_
{
    meta:
        description = "[MoleBox v2.3.0 -> Teggo]"
        ep_only = "false"
    strings:
        $a = {42 04 E8 ?? ?? 00 00 A3 ?? ?? ?? 00 8B 4D F0 8B 11 89 15 ?? ?? ?? 00 ?? 45 FC A3 ?? ?? ?? 00 5F 5E 8B E5 5D C3 CC CC CC CC CC CC CC CC CC CC CC E8 EB FB FF FF 58 E8 ?? 07 00 00 58 89 44 24 20 61 58 FF D0 E8 ?? ?? 00 00 CC CC CC CC CC CC CC}
    condition:
        $a
}

rule PEiD_01156_MoleBox_v2_5_4____Teggo_
{
    meta:
        description = "[MoleBox v2.5.4 -> Teggo]"
        ep_only = "false"
    strings:
        $a = {?? ?? ?? 00 8B 4D F0 8B 11 89 15 ?? ?? ?? 00 8B 45 FC A3 ?? ?? ?? 00 5F 5E 8B E5 5D C3 CC CC CC E8 EB FB FF FF 58 E8 ?? 07 00 00 58 89 44 24 24 61 58 58 FF D0 E8 ?? ?? 00 00 6A 00 FF 15 ?? ?? ?? 00 CC CC CC CC CC CC CC CC CC CC CC CC CC CC}
    condition:
        $a
}

rule PEiD_01157_MoleBox_V2_X____MoleStudio_com_
{
    meta:
        description = "[MoleBox V2.X -> MoleStudio.com]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 60 E8 4F 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01158_Morphine_2_7____Holy_Father___Ratter_29A__h__
{
    meta:
        description = "[Morphine 2.7 -> Holy_Father & Ratter/29A (h)]"
        ep_only = "false"
    strings:
        $a = {?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63}
    condition:
        $a
}

rule PEiD_01159_Morphine_2_7____Holy_Father___Ratter_29A_
{
    meta:
        description = "[Morphine 2.7 -> Holy_Father & Ratter/29A]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01160_Morphine_3_3____Holy_Father___Ratter_29A_
{
    meta:
        description = "[Morphine 3.3 -> Holy_Father & Ratter/29A]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 52 6E 45 6C 33 32 2E 64 4C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72}
    condition:
        $a
}

rule PEiD_01161_Morphine_3_3____Silent_Software___Silent_Shield__c_2005__h__
{
    meta:
        description = "[Morphine 3.3 -> Silent Software & Silent Shield (c)2005 (h)]"
        ep_only = "false"
    strings:
        $a = {28 ?? ?? ?? 00 00 00 00 00 00 00 00 40 ?? ?? ?? 34 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 4B 65 52 6E 45 6C 33 32 2E 64 4C 6C 00 00 47 65 74 50 72 6F 63}
    condition:
        $a
}

rule PEiD_01162_Morphine_v1_2___v1_3_
{
    meta:
        description = "[Morphine v1.2 - v1.3]"
        ep_only = "false"
    strings:
        $a = {FF 25 34 ?? 5A 00 8B C0 FF 25 38 ?? 5A 00 8B C0}
    condition:
        $a
}

rule PEiD_01163_Morphine_v2_7____Holy_Father___Ratter_29A__h__
{
    meta:
        description = "[Morphine v2.7 -> Holy_Father & Ratter/29A (h)]"
        ep_only = "false"
    strings:
        $a = {?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01164_Morphine_v2_7____Holy_Father___Ratter_29A_
{
    meta:
        description = "[Morphine v2.7 -> Holy_Father & Ratter/29A]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01165_Morphine_V3_3____Holy_Father___Ratter_29A_
{
    meta:
        description = "[Morphine V3.3 -> Holy_Father & Ratter/29A]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 52 6E 45 6C 33 32 2E 64 4C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41}
    condition:
        $a
}

rule PEiD_01166_Morphine_v3_3____Silent_Software___Silent_Shield__c_2005__h__
{
    meta:
        description = "[Morphine v3.3 -> Silent Software & Silent Shield (c)2005 (h)]"
        ep_only = "false"
    strings:
        $a = {28 ?? ?? ?? 00 00 00 00 00 00 00 00 40 ?? ?? ?? 34 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 4B 65 52 6E 45 6C 33 32 2E 64 4C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41}
    condition:
        $a
}

rule PEiD_01167_Morphnah_Beta____Kas_
{
    meta:
        description = "[Morphnah Beta -> Kas]"
        ep_only = "true"
    strings:
        $a = {2E 6E 61 68 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 A0 00 00 E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01168_mPack_0_0_3____DeltaAziz_
{
    meta:
        description = "[mPack 0.0.3 -> DeltaAziz]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 33 C0 89 45 F0 B8 A8 76 00 10 E8 67 C4 FF FF 33 C0 55 68 C2 78 00 10 64 FF 30 64 89 20 8D 55 F0 33 C0 E8 93 C8 FF FF 8B 45 F0 E8 87 CB FF FF A3 08 A5 00 10 33 C0 55 68 A5 78 00 10 64 FF 30 64 89 20 A1 08 A5 00 10 E8 FA C9 FF FF 83 F8 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01169_mPack_0_0_3____DeltaAziz_
{
    meta:
        description = "[mPack 0.0.3 -> DeltaAziz]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 33 C0 89 45 F0 B8 A8 76 00 10 E8 67 C4 FF FF 33 C0 55 68 C2 78 00 10 64 FF 30 64 89 20 8D 55 F0 33 C0 E8 93 C8 FF FF 8B 45 F0 E8 87 CB FF FF A3 08 A5 00 10 33 C0 55 68 A5 78 00 10 64 FF 30 64 89 20 A1 08 A5 00 10 E8 FA C9 FF FF 83 F8 FF 75 0A E8 88 B2 FF FF E9 1B 01 00 00 C7 05 14 A5 00 10 32 00 00 00 A1 08 A5 00 10 8B 15 14 A5 00 10 E8 C9 C9 FF FF BA 14 A5 00 10 A1 08 A5 00 10 B9 04 00 00 00 E8 C5 C9 FF FF 83 3D 14 A5 00 10 32 77 0A E8 47 B2 FF FF E9 DA 00 00 00 A1 08 A5 00 10 8B 15 14 A5 00 10 E8 92 C9 FF FF BA 18 A5}
    condition:
        $a at pe.entry_point
}

rule PEiD_01170_mPACK_v0_0_2____DeltaAziz__h__
{
    meta:
        description = "[mPACK v0.0.2 -> DeltaAziz (h)]"
        ep_only = "true"
    strings:
        $a = {E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 E8 AA 00 00 00 4E ?? ?? 00 00 00 00 00 00 00 00 00 5E ?? ?? 00 4E ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 ?? ?? 00 00 ?? ?? 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 ?? ?? ?? 0C ?? ?? ?? CC E4 ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 5D 68 00 FE 9F 07 53 E8 5D 00 00 00 EB FF 71 E8 C2 50 00 EB D6 5E F3 68 89 74 24 48 74 24 58 FF 8D 74 24 58 5E 83 C6 4C 75 F4 59 8D 71 E8 75 09 81 F6 EB FF 51 B9 01 00 83 EE FC 49 FF 71 C7 75 19 8B 74 24 00 00 81 36 50 56 8B 36 EB FF 77 C4 36 81 F6 EB 87 34 24 8B 8B 1C 24 83 EC FC EB 01 E8 83 EC FC E9 E7 00 00 00 5B EB FF F3 EB FF C3 83 EB FD}
    condition:
        $a at pe.entry_point
}

rule PEiD_01171_mPack_V0_03____DeltaAziz_
{
    meta:
        description = "[mPack V0.03 -> DeltaAziz]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 ?? ?? 33 C0 89 45 F0 B8 ?? ?? ?? ?? E8 67 C4 FF FF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 33 C0 E8 93 C8 FF FF 8B 45 F0 E8 87 CB FF FF A3 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? E8 FA C9 FF FF 83 F8 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01172_MPEG_movie_file_
{
    meta:
        description = "[MPEG movie file]"
        ep_only = "false"
    strings:
        $a = {00 00 01 BA 2F FF FD E6 C1 80 18 61 00 00 01 BB}
    condition:
        $a
}

rule PEiD_01173_MS_FORTRAN_Library_19___
{
    meta:
        description = "[MS FORTRAN Library 19??]"
        ep_only = "true"
    strings:
        $a = {FC 1E B8 ?? ?? 8E D8 9A ?? ?? ?? ?? 81 ?? ?? ?? 8B EC 8C DB 8E C3 BB ?? ?? 9A ?? ?? ?? ?? 9B DB E3 9B D9 2E ?? ?? 33 C9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01174_MS_FORTRAN_Library_19___
{
    meta:
        description = "[MS FORTRAN Library 19??]"
        ep_only = "true"
    strings:
        $a = {FC 1E B8 ?? ?? 8E D8 9A ?? ?? ?? ?? 81 ?? ?? ?? 8B EC B8 ?? ?? 8E C0 26 C7 ?? ?? ?? ?? ?? 26}
    condition:
        $a at pe.entry_point
}

rule PEiD_01175_MS_Run_Time_Library__OS_2____FORTRAN_Compiler_1989_
{
    meta:
        description = "[MS Run-Time Library (OS/2) & FORTRAN Compiler 1989]"
        ep_only = "true"
    strings:
        $a = {B4 30 CD 21 86 E0 2E A3 ?? ?? 3D ?? ?? 73}
    condition:
        $a at pe.entry_point
}

rule PEiD_01176_MS_Run_Time_Library_1987_
{
    meta:
        description = "[MS Run-Time Library 1987]"
        ep_only = "true"
    strings:
        $a = {B4 30 CD 21 3C 02 73 ?? 9A ?? ?? ?? ?? B8 ?? ?? 50 9A ?? ?? ?? ?? 92}
    condition:
        $a at pe.entry_point
}

rule PEiD_01177_MS_Run_Time_Library_1988__04__
{
    meta:
        description = "[MS Run-Time Library 1988 (04)]"
        ep_only = "true"
    strings:
        $a = {1E B8 ?? ?? 8E D8 B4 30 CD 21 3C 02 73 ?? BA ?? ?? E8 ?? ?? 06 33 C0 50 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01178_MS_Run_Time_Library_1990__07__
{
    meta:
        description = "[MS Run-Time Library 1990 (07)]"
        ep_only = "true"
    strings:
        $a = {2E 8C 1E ?? ?? BB ?? ?? 8E DB 1E E8 ?? ?? 1F 8B 1E ?? ?? 0B DB 74 ?? 8C D1 8B D4 FA 8E D3 BC ?? ?? FB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01179_MS_Run_Time_Library_1990__10__
{
    meta:
        description = "[MS Run-Time Library 1990 (10)]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? 2E FF 2E ?? ?? BB ?? ?? E8 ?? ?? CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01180_MS_Run_Time_Library_1990__1992__09__
{
    meta:
        description = "[MS Run-Time Library 1990, 1992 (09)]"
        ep_only = "true"
    strings:
        $a = {B4 30 CD 21 3C 02 73 ?? C3 8C DF 8B 36 ?? ?? 2E}
    condition:
        $a at pe.entry_point
}

rule PEiD_01181_MS_Run_Time_Library_1992__11__
{
    meta:
        description = "[MS Run-Time Library 1992 (11)]"
        ep_only = "true"
    strings:
        $a = {B4 51 CD 21 8E DB B8 ?? ?? 83 E8 ?? 8E C0 33 F6 33 FF B9 ?? ?? FC F3 A5}
    condition:
        $a at pe.entry_point
}

rule PEiD_01182_MS_Run_Time_Library_1992__13__
{
    meta:
        description = "[MS Run-Time Library 1992 (13)]"
        ep_only = "true"
    strings:
        $a = {BF ?? ?? 8E DF FA 8E D7 81 C4 ?? ?? FB 33 DB B8 ?? ?? CD 21}
    condition:
        $a at pe.entry_point
}

rule PEiD_01183_MS_Run_Time_Library_1992__14__
{
    meta:
        description = "[MS Run-Time Library 1992 (14)]"
        ep_only = "true"
    strings:
        $a = {1E 06 8C C8 8E D8 8C C0 A3 ?? ?? 83 C0 ?? A3 ?? ?? B4 30}
    condition:
        $a at pe.entry_point
}

rule PEiD_01184_MS_Visual_C___v_8__h_good_sig__but_is_it_MSVC___
{
    meta:
        description = "[MS Visual C++ v.8 (h-good sig, but is it MSVC?)]"
        ep_only = "false"
    strings:
        $a = {E8 ?? ?? ?? ?? E9 8D FE FF FF CC CC CC CC CC 66 81 3D 00 00 00 01 4D 5A 74 04 33 C0 EB 51 A1 3C 00 00 01 81 B8 00 00 00 01 50 45 00 00 75 EB 0F B7 88 18 00 00 01 81 F9 0B 01 00 00 74 1B 81 F9 0B 02 00 00 75 D4 83 B8 84 00 00 01 0E 76 CB 33 C9 39 88 F8 00}
    condition:
        $a
}

rule PEiD_01185_MS_Visual_C___v_8__h_good_sig__but_is_it_MSVC___
{
    meta:
        description = "[MS Visual C++ v.8 (h-good sig, but is it MSVC?)]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? E9 8D FE FF FF CC CC CC CC CC 66 81 3D 00 00 00 01 4D 5A 74 04 33 C0 EB 51 A1 3C 00 00 01 81 B8 00 00 00 01 50 45 00 00 75 EB 0F B7 88 18 00 00 01 81 F9 0B 01 00 00 74 1B 81 F9 0B 02 00 00 75 D4 83 B8 84 00 00 01 0E 76 CB 33 C9 39 88 F8 00 00 01 EB 11 83 B8 74 00 00 01 0E 76 B8 33 C9 39 88 E8 00 00 01 0F 95 C1 8B C1 6A 01 A3 ?? ?? ?? 01 E8 ?? ?? 00 00 50 FF ?? ?? ?? 00 01 83 0D ?? ?? ?? 01 FF 83 0D ?? ?? ?? 01 FF 59 59 FF 15 ?? ?? 00 01 8B 0D ?? ?? ?? 01 89 08 FF 15 ?? ?? 00 01 8B 0D ?? ?? ?? 01 89 08 A1 ?? ?? 00 01 8B 00 A3 ?? ?? ?? 01 E8 ?? ?? 00 00 83 3D ?? ?? ?? 01 00 75 0C 68 ?? ?? ?? 01 FF 15 ?? ?? 00 01 59 E8 ?? ?? 00 00 33 C0 C3 CC CC CC CC CC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01186_MS_Visual_C___v_8_DLL__h_small_sig1__
{
    meta:
        description = "[MS Visual C++ v.8 DLL (h-small sig1)]"
        ep_only = "true"
    strings:
        $a = {8B FF 55 8B EC 83 7D 0C 01 75 05 E8 ?? ?? ?? FF 5D E9 D6 FE FF FF CC CC CC CC CC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01187_MS_Visual_C___v_8_DLL__h_small_sig2__
{
    meta:
        description = "[MS Visual C++ v.8 DLL (h-small sig2)]"
        ep_only = "true"
    strings:
        $a = {8B FF 55 8B EC 53 8B 5D 08 56 8B 75 0C 85 F6 57 8B 7D 10 0F 84 ?? ?? 00 00 83 FE 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01188_MSLRH_0_32a__fake__BJFNT_1_3_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake .BJFNT 1.3) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {EB 03 3A 4D 3A 1E EB 02 CD 20 9C EB 02 CD 20 EB 02 CD 20 60 EB 02 C7 05 EB 02 CD 20 E8 03 00 00 00 E9 EB 04 58 40 50 C3 61 9D 1F EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50}
    condition:
        $a
}

rule PEiD_01189_MSLRH_0_32a__fake_ASPack_2_11d_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake ASPack 2.11d) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {60 E8 02 00 00 00 EB 09 5D 55 81 ED 39 39 44 00 C3 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75}
    condition:
        $a
}

rule PEiD_01190_MSLRH_0_32a__fake_ASPack_2_12_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake ASPack 2.12) -> emadicius]"
        ep_only = "true"
    strings:
        $a = {60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 73 00 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01191_MSLRH_0_32a__fake_ASPack_2_12_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake ASPack 2.12) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 A0 02 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03}
    condition:
        $a
}

rule PEiD_01192_MSLRH_0_32a__fake_EXE32Pack_1_3x_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake EXE32Pack 1.3x) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC 56 3B D2 74 02 81 85 57 E8 00 00 00 00 3B DB 74 01 90 83 C4 14 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00}
    condition:
        $a
}

rule PEiD_01193_MSLRH_0_32a__fake_Microsoft_Visual_C_______emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake Microsoft Visual C++) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 CA 37 41 00 68 06 38 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 64 8F 05 00 00 00 00 83 C4 0C 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00}
    condition:
        $a
}

rule PEiD_01194_MSLRH_0_32a__fake_MSVC___6_0_DLL_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake MSVC++ 6.0 DLL) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 5F 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58}
    condition:
        $a
}

rule PEiD_01195_MSLRH_0_32a__fake_MSVC___7_0_DLL_Method_3_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake MSVC++ 7.0 DLL Method 3) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 53 8B 5D 08 56 8B 75 0C 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB}
    condition:
        $a
}

rule PEiD_01196_MSLRH_0_32a__fake_MSVC___DLL_Method_4_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake MSVC++ DLL Method 4) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 56 57 BF 01 00 00 00 8B 75 0C 85 F6 5F 5E 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75}
    condition:
        $a
}

rule PEiD_01197_MSLRH_0_32a__fake_Neolite_2_0_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake Neolite 2.0) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {E9 A6 00 00 00 B0 7B 40 00 78 60 40 00 7C 60 40 00 00 00 00 00 B0 3F 00 00 12 62 40 00 4E 65 6F 4C 69 74 65 20 45 78 65 63 75 74 61 62 6C 65 20 46 69 6C 65 20 43 6F 6D 70 72 65 73 73 6F 72 0D 0A 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 39 38 2C 31}
    condition:
        $a
}

rule PEiD_01198_MSLRH_0_32a__fake_nSPack_1_3_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake nSPack 1.3) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 D3 FE FF FF 8B 06 83 F8 00 74 11 8D B5 DF FE FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74}
    condition:
        $a
}

rule PEiD_01199_MSLRH_0_32a__fake_PC_Guard_4_xx_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake PC-Guard 4.xx) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {FC 55 50 E8 00 00 00 00 5D EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 58 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58}
    condition:
        $a
}

rule PEiD_01200_MSLRH_0_32a__fake_PE_Crypt_1_02_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake PE Crypt 1.02) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {E8 00 00 00 00 5B 83 EB 05 EB 04 52 4E 44 21 85 C0 73 02 F7 05 50 E8 08 00 00 00 EA FF 58 EB 18 EB 01 0F EB 02 CD 20 EB 03 EA CD 20 58 58 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB}
    condition:
        $a
}

rule PEiD_01201_MSLRH_0_32a__fake_PE_Lock_NT_2_04_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake PE Lock NT 2.04) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {EB 03 CD 20 C7 1E EB 03 CD 20 EA 9C EB 02 EB 01 EB 01 EB 60 EB 03 CD 20 EB EB 01 EB E8 03 00 00 00 E9 EB 04 58 40 50 C3 EB 03 CD 20 EB EB 03 CD 20 03 61 9D 83 C4 04 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83}
    condition:
        $a
}

rule PEiD_01202_MSLRH_0_32a__fake_PEBundle_0_2___3_x_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake PEBundle 0.2 - 3.x) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 30 40 00 87 DD 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02}
    condition:
        $a
}

rule PEiD_01203_MSLRH_0_32a__fake_PEBundle_2_0x___2_4x_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake PEBundle 2.0x - 2.4x) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 30 40 00 87 DD 83 BD 9C 38 40 00 01 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29}
    condition:
        $a
}

rule PEiD_01204_MSLRH_0_32a__fake_PECompact_1_4x_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake PECompact 1.4x) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {EB 06 68 2E A8 00 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 00 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A}
    condition:
        $a
}

rule PEiD_01205_MSLRH_0_32a__fake_PESHiELD_0_25_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake PESHiELD 0.25) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {60 E8 2B 00 00 00 0D 0A 0D 0A 0D 0A 52 65 67 69 73 74 41 72 65 64 20 74 6F 3A 20 4E 4F 4E 2D 43 4F 4D 4D 45 52 43 49 41 4C 21 21 0D 0A 0D 0A 0D 00 58 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04}
    condition:
        $a
}

rule PEiD_01206_MSLRH_0_32a__fake_PEtite_2_1_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake PEtite 2.1) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {B8 00 50 40 00 6A 00 68 BB 21 40 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 83 C4 04 61 66 9D 64 8F 05 00 00 00 00 83 C4 08 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB}
    condition:
        $a
}

rule PEiD_01207_MSLRH_0_32a__fake_PEX_0_99_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake PEX 0.99) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {60 E8 01 00 00 00 E8 83 C4 04 E8 01 00 00 00 E9 5D 81 ED FF 22 40 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83}
    condition:
        $a
}

rule PEiD_01208_MSLRH_0_32a__fake_SVKP_1_11_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake SVKP 1.11) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 64 A0 23 00 00 00 83 C5 06 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4}
    condition:
        $a
}

rule PEiD_01209_MSLRH_0_32a__fake_UPX_0_89_6___1_02___1_05___1_24_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake UPX 0.89.6 - 1.02 / 1.05 - 1.24) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {60 BE 00 90 8B 00 8D BE 00 80 B4 FF 57 83 CD FF EB 3A 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 0B 75 19 8B 1E 83 EE FC 11 DB 72 10 58 61 90 EB 05 E8 EB 04 40}
    condition:
        $a
}

rule PEiD_01210_MSLRH_0_32a__fake_WWPack32_1_x_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake WWPack32 1.x) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {53 55 8B E8 33 DB EB 60 0D 0A 0D 0A 57 57 50 61 63 6B 33 32 20 64 65 63 6F 6D 70 72 65 73 73 69 6F 6E 20 72 6F 75 74 69 6E 65 20 76 65 72 73 69 6F 6E 20 31 2E 31 32 0D 0A 28 63 29 20 31 39 39 38 20 50 69 6F 74 72 20 57 61 72 65 7A 61 6B 20 61 6E 64 20 52}
    condition:
        $a
}

rule PEiD_01211_MSLRH_0_32a__fake_yoda_s_cryptor_1_2_____emadicius_
{
    meta:
        description = "[MSLRH 0.32a (fake yoda's cryptor 1.2) -> emadicius]"
        ep_only = "false"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED F3 1D 40 00 B9 7B 09 00 00 8D BD 3B 1E 40 00 8B F7 AC 90 2C 8A C0 C0 78 90 04 62 EB 01 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00}
    condition:
        $a
}

rule PEiD_01212_MSLRH_v0_1____emadicius_
{
    meta:
        description = "[MSLRH v0.1 -> emadicius]"
        ep_only = "false"
    strings:
        $a = {60 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8}
    condition:
        $a
}

rule PEiD_01213_MSLRH_V0_31____emadicius_
{
    meta:
        description = "[MSLRH V0.31 -> emadicius]"
        ep_only = "true"
    strings:
        $a = {60 D1 CB 0F CA C1 CA E0 D1 CA 0F C8 EB 01 F1}
    condition:
        $a at pe.entry_point
}

rule PEiD_01214_MSLRH_v0_31a_
{
    meta:
        description = "[MSLRH v0.31a]"
        ep_only = "false"
    strings:
        $a = {60 D1 CB 0F CA C1 CA E0 D1 CA 0F C8 EB 01 F1 0F C0 C9 D2 D1 0F C1 C0 D3 DA C0 D6 A8 EB 01 DE D0 EC 0F C1 CB D0 CF 0F C1 D1 D2 DB 0F C8 EB 01 BC C0 E9 C6 C1 D0 91 0F CB EB 01 73 0F CA 87 D9 87 D2 D0 CF 87 D9 0F C8 EB 01 C1 EB 01 A2 86 CA D0 E1 0F C0 CB 0F}
    condition:
        $a
}

rule PEiD_01215_MSLRH_v0_31a_
{
    meta:
        description = "[MSLRH v0.31a]"
        ep_only = "false"
    strings:
        $a = {60 D1 CB 0F CA C1 CA E0 D1 CA 0F C8 EB 01 F1 0F C0 C9 D2 D1 0F C1 C0 D3 DA C0 D6 A8 EB 01 DE D0 EC 0F C1 CB D0 CF 0F C1 D1 D2 DB 0F C8 EB 01 BC C0 E9 C6 C1 D0 91 0F CB EB 01 73 0F CA 87 D9 87 D2 D0 CF 87 D9 0F C8 EB 01 C1 EB 01 A2 86 CA D0 E1 0F C0 CB 0F CA C0 C7 91 0F CB C1 D9 0C 86 F9 86 D7 D1 D9 EB 01 A5 EB 01 11 EB 01 1D 0F C1 C2 0F CB 0F C1 C2 EB 01 A1 C0 E9 FD 0F C1 D1 EB 01 E3 0F CA 87 D9 EB 01 F3 0F CB 87 C2 0F C0 F9 D0 F7 EB 01 2F 0F C9 C0 DC C4 EB 01 35 0F CA D3 D1 86 C8 EB 01 01 0F C0 F5 87 C8 D0 DE EB 01 95 EB 01 E1 EB 01 FD EB 01 EC 87 D3 0F CB C1 DB 35 D3 E2 0F C8 86 E2 86 EC C1 FB 12 D2 EE 0F C9 D2 F6 0F CA 87 C3 C1 D3 B3 EB 01 BF D1 CB 87 C9 0F CA 0F C1 DB EB 01 44 C0 CA F2 0F C1 D1 0F CB EB 01 D3 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00}
    condition:
        $a
}

rule PEiD_01216_MSLRH_v0_32a__fake__BJFNT_1_3_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake .BJFNT 1.3) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {EB 03 3A 4D 3A 1E EB 02 CD 20 9C EB 02 CD 20 EB 02 CD 20 60 EB 02 C7 05 EB 02 CD 20 E8 03 00 00 00 E9 EB 04 58 40 50 C3 61 9D 1F EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01217_MSLRH_v0_32a__fake_ASPack_2_11d_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake ASPack 2.11d) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 02 00 00 00 EB 09 5D 55 81 ED 39 39 44 00 C3 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01218_MSLRH_v0_32a__fake_ASPack_2_12_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake ASPack 2.12) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 73 00 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01219_MSLRH_v0_32a__fake_ASPack_2_12_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake ASPack 2.12) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 A0 02 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01220_MSLRH_v0_32a__fake_EXE32Pack_1_3x_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake EXE32Pack 1.3x) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC 56 3B D2 74 02 81 85 57 E8 00 00 00 00 3B DB 74 01 90 83 C4 14 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01221_MSLRH_v0_32a__fake_Microsoft_Visual_C_______emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake Microsoft Visual C++) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 CA 37 41 00 68 06 38 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 64 8F 05 00 00 00 00 83 C4 0C 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01222_MSLRH_v0_32a__fake_MSVC___6_0_DLL_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake MSVC++ 6.0 DLL) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 5F 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01223_MSLRH_v0_32a__fake_MSVC___7_0_DLL_Method_3_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake MSVC++ 7.0 DLL Method 3) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 8B 5D 08 56 8B 75 0C 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01224_MSLRH_v0_32a__fake_MSVC___DLL_Method_4_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake MSVC++ DLL Method 4) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 56 57 BF 01 00 00 00 8B 75 0C 85 F6 5F 5E 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01225_MSLRH_v0_32a__fake_Neolite_2_0_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake Neolite 2.0) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {E9 A6 00 00 00 B0 7B 40 00 78 60 40 00 7C 60 40 00 00 00 00 00 B0 3F 00 00 12 62 40 00 4E 65 6F 4C 69 74 65 20 45 78 65 63 75 74 61 62 6C 65 20 46 69 6C 65 20 43 6F 6D 70 72 65 73 73 6F 72 0D 0A 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 39 38 2C 31 39 39 39 20 4E 65 6F 57 6F 72 78 20 49 6E 63 0D 0A 50 6F 72 74 69 6F 6E 73 20 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 39 37 2D 31 39 39 39 20 4C 65 65 20 48 61 73 69 75 6B 0D 0A 41 6C 6C 20 52 69 67 68 74 73 20 52 65 73 65 72 76 65 64 2E 00 00 00 00 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01226_MSLRH_v0_32a__fake_nSPack_1_3_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake nSPack 1.3) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 D3 FE FF FF 8B 06 83 F8 00 74 11 8D B5 DF FE FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01227_MSLRH_v0_32a__fake_PC_Guard_4_xx_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake PC-Guard 4.xx) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {FC 55 50 E8 00 00 00 00 5D EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 58 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01228_MSLRH_v0_32a__fake_PE_Crypt_1_02_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake PE Crypt 1.02) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 5B 83 EB 05 EB 04 52 4E 44 21 85 C0 73 02 F7 05 50 E8 08 00 00 00 EA FF 58 EB 18 EB 01 0F EB 02 CD 20 EB 03 EA CD 20 58 58 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01229_MSLRH_v0_32a__fake_PE_Lock_NT_2_04_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake PE Lock NT 2.04) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {EB 03 CD 20 C7 1E EB 03 CD 20 EA 9C EB 02 EB 01 EB 01 EB 60 EB 03 CD 20 EB EB 01 EB E8 03 00 00 00 E9 EB 04 58 40 50 C3 EB 03 CD 20 EB EB 03 CD 20 03 61 9D 83 C4 04 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01230_MSLRH_v0_32a__fake_PEBundle_0_2___3_x_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake PEBundle 0.2 - 3.x) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 30 40 00 87 DD 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01231_MSLRH_v0_32a__fake_PEBundle_2_0x___2_4x_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake PEBundle 2.0x - 2.4x) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 30 40 00 87 DD 83 BD 9C 38 40 00 01 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01232_MSLRH_v0_32a__fake_PECompact_1_4x_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake PECompact 1.4x) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 2E A8 00 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 00 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01233_MSLRH_v0_32a__fake_PESHiELD_0_25_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake PESHiELD 0.25) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 2B 00 00 00 0D 0A 0D 0A 0D 0A 52 65 67 69 73 74 41 72 65 64 20 74 6F 3A 20 4E 4F 4E 2D 43 4F 4D 4D 45 52 43 49 41 4C 21 21 0D 0A 0D 0A 0D 00 58 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01234_MSLRH_v0_32a__fake_PEtite_2_1_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake PEtite 2.1) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {B8 00 50 40 00 6A 00 68 BB 21 40 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 83 C4 04 61 66 9D 64 8F 05 00 00 00 00 83 C4 08 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01235_MSLRH_v0_32a__fake_PEX_0_99_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake PEX 0.99) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 01 00 00 00 E8 83 C4 04 E8 01 00 00 00 E9 5D 81 ED FF 22 40 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01236_MSLRH_v0_32a__fake_SVKP_1_11_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake SVKP 1.11) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 64 A0 23 00 00 00 83 C5 06 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01237_MSLRH_v0_32a__fake_UPX_0_89_6___1_02___1_05___1_24_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake UPX 0.89.6 - 1.02 / 1.05 - 1.24) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {60 BE 00 90 8B 00 8D BE 00 80 B4 FF 57 83 CD FF EB 3A 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 0B 75 19 8B 1E 83 EE FC 11 DB 72 10 58 61 90 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01238_MSLRH_v0_32a__fake_WWPack32_1_x_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake WWPack32 1.x) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {53 55 8B E8 33 DB EB 60 0D 0A 0D 0A 57 57 50 61 63 6B 33 32 20 64 65 63 6F 6D 70 72 65 73 73 69 6F 6E 20 72 6F 75 74 69 6E 65 20 76 65 72 73 69 6F 6E 20 31 2E 31 32 0D 0A 28 63 29 20 31 39 39 38 20 50 69 6F 74 72 20 57 61 72 65 7A 61 6B 20 61 6E 64 20 52 61 66 61 6C 20 57 69 65 72 7A 62 69 63 6B 69 0D 0A 0D 0A 5D 5B 90 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01239_MSLRH_v0_32a__fake_yoda_s_cryptor_1_2_____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a (fake yoda's cryptor 1.2) -> emadicius (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED F3 1D 40 00 B9 7B 09 00 00 8D BD 3B 1E 40 00 8B F7 AC 90 2C 8A C0 C0 78 90 04 62 EB 01 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01240_MSLRH_v0_32a____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a -> emadicius (h)]"
        ep_only = "false"
    strings:
        $a = {E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8}
    condition:
        $a
}

rule PEiD_01241_MSLRH_v0_32a____emadicius__h__
{
    meta:
        description = "[MSLRH v0.32a -> emadicius (h)]"
        ep_only = "false"
    strings:
        $a = {E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF FF FF 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C}
    condition:
        $a
}

rule PEiD_01242_MSLRH_v0_32a____emadicius_
{
    meta:
        description = "[MSLRH v0.32a -> emadicius]"
        ep_only = "false"
    strings:
        $a = {EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03}
    condition:
        $a
}

rule PEiD_01243_MSLRH_v32a____emadicius_
{
    meta:
        description = "[MSLRH v32a -> emadicius]"
        ep_only = "false"
    strings:
        $a = {EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 74 04 75 02 EB 02 EB 01 81 74 04 75 02 EB 02 EB 01 81 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08}
    condition:
        $a
}

rule PEiD_01244_MSLRH_
{
    meta:
        description = "[MSLRH]"
        ep_only = "true"
    strings:
        $a = {60 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_01245_MSLRH_
{
    meta:
        description = "[MSLRH]"
        ep_only = "false"
    strings:
        $a = {60 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81}
    condition:
        $a
}

rule PEiD_01246_MSVC___DLL_v_8__typical_OEP_recognized___h__
{
    meta:
        description = "[MSVC++ DLL v.8 (typical OEP recognized - h)]"
        ep_only = "true"
    strings:
        $a = {8B FF 55 8B EC 53 8B 5D 08 56 8B 75 0C 85 F6 57 8B 7D 10 75 09 83 3D ?? ?? ?? ?? 00 EB 26 83 FE 01 74 05 83 FE 02 75 22 A1 ?? ?? ?? ?? 85 C0 74 09 57 56 53 FF D0 85 C0 74 0C 57 56 53 E8 ?? ?? ?? FF 85 C0 75 04 33 C0 EB 4E 57 56 53 E8 ?? ?? ?? FF 83 FE 01 89 45 0C 75 0C 85 C0 75 37 57 50 53 E8 ?? ?? ?? FF 85 F6 74 05 83 FE 03 75 26 57 56 53 E8 ?? ?? ?? FF 85 C0 75 03 21 45 0C 83 7D 0C 00 74 11 A1 ?? ?? ?? ?? 85 C0 74 08 57 56 53 FF D0 89 45 0C 8B 45 0C 5F 5E 5B 5D C2 0C 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01247_MSVC___v_8__procedure_1_recognized___h__
{
    meta:
        description = "[MSVC++ v.8 (procedure 1 recognized - h)]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 83 65 F8 00 83 65 FC 00 53 57 BF 4E E6 40 BB 3B C7 BB 00 00 FF FF 74 0D 85 C3 74 09 F7 D0 A3 ?? ?? ?? ?? EB 60 56 8D 45 F8 50 FF 15 ?? ?? ?? ?? 8B 75 FC 33 75 F8 FF 15 ?? ?? ?? ?? 33 F0 FF 15 ?? ?? ?? ?? 33 F0 FF 15 ?? ?? ?? ?? 33 F0 8D 45 F0 50 FF 15 ?? ?? ?? ?? 8B 45 F4 33 45 F0 33 F0 3B F7 75 07 BE 4F E6 40 BB EB 0B 85 F3 75 07 8B C6 C1 E0 10 0B F0 89 35 ?? ?? ?? ?? F7 D6 89 35 ?? ?? ?? ?? 5E 5F 5B C9 C3}
    condition:
        $a
}

rule PEiD_01248_mucki_s_protector____mucki_
{
    meta:
        description = "[mucki's protector -> mucki]"
        ep_only = "true"
    strings:
        $a = {BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8A 06 F6 D0 88 06 46 E2 F7 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01249_mucki_s_protector_II____mucki_
{
    meta:
        description = "[mucki's protector II -> mucki]"
        ep_only = "true"
    strings:
        $a = {E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 B8 00 00 00 00 00 00 00 31 C0 89 41 14 89 41 18 80 6A 00 E8 85 C0 74 12 64 8B 3D 18 00 00 00 8B 7F 30 0F B6 47 02 85 C0 74 01 C3 C7 04 24 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8A 06 F6 D0 88 06 46 E2}
    condition:
        $a at pe.entry_point
}

rule PEiD_01250_mucki_s_protector_II____mucki_
{
    meta:
        description = "[mucki's protector II -> mucki]"
        ep_only = "true"
    strings:
        $a = {E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 B8 00 00 00 00 00 00 00 31 C0 89 41 14 89 41 18 80 6A 00 E8 85 C0 74 12 64 8B 3D 18 00 00 00 8B 7F 30 0F B6 47 02 85 C0 74 01 C3 C7 04 24 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8A 06 F6 D0 88 06 46 E2 F7 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01251_MZ0oPE_1_0_6b____TaskFall_
{
    meta:
        description = "[MZ0oPE 1.0.6b -> TaskFall]"
        ep_only = "true"
    strings:
        $a = {EB CA 89 03 83 C3 04 87 FE 32 C0 AE 75 FD 87 FE 80 3E FF 75 E2 46 5B 83 C3 04 53 8B 1B 80 3F FF 75 C9 8B E5 61 68 ?? ?? ?? ?? C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01252_MZ0oPE_1_0_6b____TaskFall_
{
    meta:
        description = "[MZ0oPE 1.0.6b -> TaskFall]"
        ep_only = "true"
    strings:
        $a = {EB CA 89 03 83 C3 04 87 FE 32 C0 AE 75 FD 87 FE 80 3E FF 75 E2 46 5B 83 C3 04 53 8B 1B 80 3F FF 75 C9 8B E5 61 68 ?? ?? ?? ?? C3 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01253_MZ0oPE_1_0_6b____TaskFall_
{
    meta:
        description = "[MZ0oPE 1.0.6b -> TaskFall]"
        ep_only = "true"
    strings:
        $a = {EB CA 89 03 83 C3 04 87 FE 32 C0 AE 75 FD 87 FE 80 3E FF 75 E2 46 5B 83 C3 04 53 8B 1B 80 3F FF 75 C9 8B E5 61 68 ?? ?? ?? ?? C3 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4C 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01254_MZ_Crypt_1_0___by_BrainSt0rm_
{
    meta:
        description = "[MZ_Crypt 1.0 - by BrainSt0rm]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 25 14 40 00 8B BD 77 14 40 00 8B 8D 7F 14 40 00 EB 28 83 7F 1C 07 75 1E 8B 77 0C 03 B5 7B 14 40 00 33 C0 EB 0C 50 8A A5 83 14 40 00 30 26 58 40 46 3B 47 10 76 EF 83 C7 28 49 0B C9 75 D4 8B 85 73 14 40 00 89 44 24 1C 61 FF E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01255_N_Joiner_0_1__Asm_Version_____NEX_
{
    meta:
        description = "[N-Joiner 0.1 (Asm Version) -> NEX]"
        ep_only = "true"
    strings:
        $a = {6A 00 68 00 14 40 00 68 00 10 40 00 6A 00 E8 14 00 00 00 6A 00 E8 13 00 00 00 CC FF 25 AC 12 40 00 FF 25 B0 12 40 00 FF 25 B4 12 40 00 FF 25 B8 12 40 00 FF 25 BC 12 40 00 FF 25 C0 12 40 00 FF 25 C4 12 40 00 FF 25 C8 12 40 00 FF 25 CC 12 40 00 FF 25 D0 12 40 00 FF 25 D4 12 40 00 FF 25 D8 12 40 00 FF 25 DC 12 40 00 FF 25 E4 12 40 00 FF 25 EC 12 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01256_N_Joy_1_0____NEX_
{
    meta:
        description = "[N-Joy 1.0 -> NEX]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 B8 9C 3B 40 00 E8 8C FC FF FF 6A 00 68 E4 39 40 00 6A 0A 6A 00 E8 40 FD FF FF E8 EF F5 FF FF 8D 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01257_N_Joy_1_1____NEX_
{
    meta:
        description = "[N-Joy 1.1 -> NEX]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 B8 0C 3C 40 00 E8 24 FC FF FF 6A 00 68 28 3A 40 00 6A 0A 6A 00 E8 D8 FC FF FF E8 7F F5 FF FF 8D 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01258_N_Joy_1_2____NEX_
{
    meta:
        description = "[N-Joy 1.2 -> NEX]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 B8 A4 32 40 00 E8 E8 F1 FF FF 6A 00 68 54 2A 40 00 6A 0A 6A 00 E8 A8 F2 FF FF E8 C7 EA FF FF 8D 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01259_N_Joy_1_3____NEX_
{
    meta:
        description = "[N-Joy 1.3 -> NEX]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 B8 48 36 40 00 E8 54 EE FF FF 6A 00 68 D8 2B 40 00 6A 0A 6A 00 E8 2C EF FF FF E8 23 E7 FF FF 8D 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01260_Naked_Packer_V1_0____BigBoote_
{
    meta:
        description = "[Naked Packer V1.0 -> BigBoote]"
        ep_only = "true"
    strings:
        $a = {60 FC 0F B6 05 ?? ?? ?? ?? 85 C0 75 31 B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 03 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 9A 00 00 00 A3 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 83 3D ?? ?? ?? ?? 00 75 07 61 FF 25 ?? ?? ?? ?? 61 FF 74 24 04 6A 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01261_Naked_Packer_V1_X____BigBoote_
{
    meta:
        description = "[Naked Packer V1.X -> BigBoote]"
        ep_only = "true"
    strings:
        $a = {6A ?? E8 9A 05 00 00 8B D8 53 68 ?? ?? ?? ?? E8 6C FD FF FF B9 05 00 00 00 8B F3 BF ?? ?? ?? ?? 53 F3 A5 E8 8D 05 00 00 8B 3D ?? ?? ?? ?? A1 ?? ?? ?? ?? 66 8B 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? 2B CF 89 45 E8 89 0D ?? ?? ?? ?? 66 89 55 EC 8B 41 3C 33 D2 03 C1}
    condition:
        $a at pe.entry_point
}

rule PEiD_01262_Nakedbind_1_0____nakedcrew_
{
    meta:
        description = "[Nakedbind 1.0 -> nakedcrew]"
        ep_only = "true"
    strings:
        $a = {64 8B 38 48 8B C8 F2 AF AF 8B 1F 66 33 DB 66 81 3B 4D 5A 74 08 81 EB 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01263_NakedPacker_1_0___by_BigBoote_
{
    meta:
        description = "[NakedPacker 1.0 - by BigBoote]"
        ep_only = "true"
    strings:
        $a = {60 FC 0F B6 05 34 ?? ?? ?? 85 C0 75 31 B8 50 ?? ?? ?? 2B 05 04 ?? ?? ?? A3 30 ?? ?? ?? A1 00 ?? ?? ?? 03 05 30 ?? ?? ?? A3 38 ?? ?? ?? E8 9A 00 00 00 A3 50 ?? ?? ?? C6 05 34 ?? ?? ?? 01 83 3D 50 ?? ?? ?? 00 75 07 61 FF 25 38 ?? ?? ?? 61 FF 74 24 04 6A 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01264_NakedPacker_1_0___by_BigBoote_
{
    meta:
        description = "[NakedPacker 1.0 - by BigBoote]"
        ep_only = "false"
    strings:
        $a = {60 FC 0F B6 05 34 ?? ?? ?? 85 C0 75 31 B8 50 ?? ?? ?? 2B 05 04 ?? ?? ?? A3 30 ?? ?? ?? A1 00 ?? ?? ?? 03 05 30 ?? ?? ?? A3 38 ?? ?? ?? E8 9A 00 00 00 A3 50 ?? ?? ?? C6 05 34 ?? ?? ?? 01 83 3D 50 ?? ?? ?? 00 75 07 61 FF 25 38 ?? ?? ?? 61 FF 74 24 04 6A 00 FF 15 44 ?? ?? ?? 50 FF 15 40 ?? ?? ?? C3 FF 74 24 04 6A 00 FF 15 44 ?? ?? ?? 50 FF 15 48 ?? ?? ?? C3 8B 4C 24 04 56 8B 74 24 10 57 85 F6 8B F9 74 0D 8B 54 24 10 8A 02 88 01}
    condition:
        $a
}

rule PEiD_01265_Native_UD_Packer_1_1__Modded_Poison_Ivy_Shellcode_____okkixot_
{
    meta:
        description = "[Native UD Packer 1.1 (Modded Poison Ivy Shellcode) -> okkixot]"
        ep_only = "true"
    strings:
        $a = {31 C0 31 DB 31 C9 EB 0E 6A 00 6A 00 6A 00 6A 00 FF 15 28 41 40 00 FF 15 94 40 40 00 89 C7 68 88 13 00 00 FF 15 98 40 40 00 FF 15 94 40 40 00 81 C7 88 13 00 00 39 F8 73 05 E9 84 00 00 00 6A 40 68 00 10 00 00 FF 35 04 30 40 00 6A 00 FF 15 A4 40 40 00 89 C7 FF 35 04 30 40 00 68 CA 10 40 00 50 FF 15 A8 40 40 00 6A 40 68 00 10 00 00 FF 35 08 30 40 00 6A 00 FF 15 A4 40 40 00 89 C6 68 00 30 40 00 FF 35 04 30 40 00 57 FF 35 08 30 40 00 50 6A 02 FF 15 4E 41 40 00 6A 00 6A 00 6A 00 56 6A 00 6A 00 FF 15 9C 40 40 00 50 6A 00 6A 00 6A 11 50 FF 15 4A 41 40 00 58 6A FF 50 FF 15 AC 40 40 00 6A 00 FF 15 A0 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_01266_nBinder_v3_6_1_
{
    meta:
        description = "[nBinder v3.6.1]"
        ep_only = "false"
    strings:
        $a = {6E 35 36 34 35 36 35 33 32 33 34 35 34 33 5F 6E 62 33 5C 00 5C 6E 35 36 34 35 36 35 33 32 33 34 35 34 33 5F 6E 62 33 5C}
    condition:
        $a
}

rule PEiD_01267_nBinder_v4_0_
{
    meta:
        description = "[nBinder v4.0]"
        ep_only = "false"
    strings:
        $a = {5C 6E 62 34 5F 74 6D 70 5F 30 31 33 32 34 35 34 33 35 30 5C 00 00 00 00 00 00 00 00 00 E9 55 43 4C FF 01 1A 00 00 00 00 96 30 07 77 2C 61 0E EE BA 51 09 99 19 C4 6D 07 8F F4 6A 70 35 A5 63 E9 A3 95 64 9E 32 88 DB 0E A4 B8 DC 79}
    condition:
        $a
}

rule PEiD_01268_nbuild_v1_0__soft_
{
    meta:
        description = "[nbuild v1.0 [soft]"
        ep_only = "true"
    strings:
        $a = {B9 ?? ?? BB ?? ?? C0 ?? ?? 80 ?? ?? 43 E2}
    condition:
        $a at pe.entry_point
}

rule PEiD_01269_NeoLite_v1_0_
{
    meta:
        description = "[NeoLite v1.0]"
        ep_only = "true"
    strings:
        $a = {8B 44 24 04 8D 54 24 FC 23 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 50 FF 25}
    condition:
        $a at pe.entry_point
}

rule PEiD_01270_NeoLite_v1_0_
{
    meta:
        description = "[NeoLite v1.0]"
        ep_only = "true"
    strings:
        $a = {E9 9B 00 00 00 A0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01271_NeoLite_v2_00_
{
    meta:
        description = "[NeoLite v2.00]"
        ep_only = "true"
    strings:
        $a = {8B 44 24 04 23 05 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 FE 05 ?? ?? ?? ?? 0B C0 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_01272_Neolite_v2_0_
{
    meta:
        description = "[Neolite v2.0]"
        ep_only = "true"
    strings:
        $a = {E9 A6 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01273_Netopsystems_FEAD_Optimizer_
{
    meta:
        description = "[Netopsystems FEAD Optimizer]"
        ep_only = "true"
    strings:
        $a = {60 BE 00 50 43 00 8D BE 00 C0 FC FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01274_Netopsystems_FEAD_Optimizer_
{
    meta:
        description = "[Netopsystems FEAD Optimizer]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 58 BB 00 00 40 00 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01275_NFO_v1_0_
{
    meta:
        description = "[NFO v1.0]"
        ep_only = "true"
    strings:
        $a = {8D 50 12 2B C9 B1 1E 8A 02 34 77 88 02 42 E2 F7 C8 8C}
    condition:
        $a at pe.entry_point
}

rule PEiD_01276_nMacro_recorder_1_0_
{
    meta:
        description = "[nMacro recorder 1.0]"
        ep_only = "false"
    strings:
        $a = {5C 6E 6D 72 5F 74 65 6D 70 2E 6E 6D 72 00 00 00 72 62 00 00 58 C7 41 00 10 F8 41 00 11 01 00 00 00 00 00 00 46 E1 00 00 46 E1 00 00 35 00 00 00 F6 88 41 00}
    condition:
        $a
}

rule PEiD_01277_NME_1_1_Public___by_redlime_
{
    meta:
        description = "[NME 1.1 Public - by redlime]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 56 B8 30 35 14 13 E8 9A E6 FF FF 33 C0 55 68 6C 36 14 13 64 FF 30 64 89 20 B8 08 5C 14 13 BA 84 36 14 13 E8 7D E2 FF FF E8 C0 EA FF FF 8B 15 CC 45 14 13 A1 C8 45 14 13 E8 04 F8 FF FF 8B 15 D0 45 14 13 A1 C8 45 14 13 E8 F4 F7 FF FF 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01278_NME_1_1_Public___by_redlime_
{
    meta:
        description = "[NME 1.1 Public - by redlime]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 56 B8 30 35 14 13 E8 9A E6 FF FF 33 C0 55 68 6C 36 14 13 64 FF 30 64 89 20 B8 08 5C 14 13 BA 84 36 14 13 E8 7D E2 FF FF E8 C0 EA FF FF 8B 15 CC 45 14 13 A1 C8 45 14 13 E8 04 F8 FF FF 8B 15 D0 45 14 13 A1 C8 45 14 13 E8 F4 F7 FF FF 8B 15 CC 45 14 13 A1 C8 45 14 13 E8 2C F9 FF FF A3 F8 5A 14 13 8B 15 D0 45 14 13 A1 C8 45 14 13 E8 17 F9 FF FF A3 FC 5A 14 13 B8 04 5C 14 13 E8 20 FB FF FF 8B D8 85 DB 74 48 B8 00 5B 14 13 8B 15 C4 45 14 13 E8 1E E7 FF FF A1 04 5C 14 13 E8 A8 DA FF FF ?? ?? ?? ?? 5C 14 13 50 8B CE 8B D3 B8 00 5B 14 13 ?? ?? ?? ?? FF 8B C6 E8 DF FB FF FF 8B C6 E8 9C DA FF FF B8 00 5B 14 13 E8 72 E7 FF FF 33 C0 5A 59 59 64 89 10 68 73 36 14 13 C3 E9 0F DF FF FF EB F8 5E 5B E8 7E E0 FF FF 00 00 FF FF FF FF 0C 00 00 00 4E 4D 45 20 31 2E 31 20 53 74 75 62}
    condition:
        $a at pe.entry_point
}

rule PEiD_01279_NoName_Packer_
{
    meta:
        description = "[NoName Packer]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 2E 34 46 00 B9 55 4A 46 00 81 E9 26 37 46 00 89 EA 81 C2 26 37 46 00 8D 3A 89 FE 31 C0 E9 D3 02 00 00 CC CC CC CC E9 CA 02 00 00 43 3A 5C 57 69 6E 64 6F 77 73 5C 53 6F 66 74 57 61 72 65 50 72 6F 74 65 63 74 6F 72 5C}
    condition:
        $a at pe.entry_point
}

rule PEiD_01280_NoodleCrypt_2_00__Eng_____NoodleSpa_
{
    meta:
        description = "[NoodleCrypt 2.00 (Eng) -> NoodleSpa]"
        ep_only = "false"
    strings:
        $a = {EB 01 9A E8 76 00 00 00 EB 01 9A E8 65 00 00 00 EB 01 9A E8 7D 00 00 00 EB 01 9A E8 55 00 00 00 EB 01 9A E8 43 04 00 00 EB 01 9A E8 E1 00 00 00 EB 01 9A E8 3D 00 00 00 EB 01 9A E8 EB 01 00 00 EB 01 9A E8 2C 04 00 00 EB 01 9A E8 25 00 00 00 EB 01 9A E8 02}
    condition:
        $a
}

rule PEiD_01281_NoodleCrypt_v2_00__Eng_____NoodleSpa_
{
    meta:
        description = "[NoodleCrypt v2.00 (Eng) -> NoodleSpa]"
        ep_only = "true"
    strings:
        $a = {EB 01 9A E8 76 00 00 00 EB 01 9A E8 65 00 00 00 EB 01 9A E8 7D 00 00 00 EB 01 9A E8 55 00 00 00 EB 01 9A E8 43 04 00 00 EB 01 9A E8 E1 00 00 00 EB 01 9A E8 3D 00 00 00 EB 01 9A E8 EB 01 00 00 EB 01 9A E8 2C 04 00 00 EB 01 9A E8 25 00 00 00 EB 01 9A E8 02 04 00 00 EB 01 9A E8 19 07 00 00 EB 01 9A E8 9C 00 00 00 EB 01 9A E8 9C 06 00 00 E8 00 00 00 00 0F 7E F8 EB 01 9A 8B F8 C3 E8 00 00 00 00 58 EB 01 9A 25 00 F0 FF FF 8B F8 EB 01 9A 0F 6E F8 C3 8B D0 EB 01 9A 81 C2 C8 00 00 00 EB 01 9A B9 00 17 00 00 EB 01 9A C0 0A 06 EB 01 9A 80 2A 15 EB 01 9A 42 E2 EE 0F 6E C0 EB 01 9A 0F 7E C0 EB 01 9A 8B D0 00 85 EB A5 F5 65 4B 45 45 00 85 EB B3 65 07 45 45 00 85 EB 75 C7 C6 00 85 EB 65 CF 8A 00 85 EB D5 FD C0 00 85 EB 7F E5 05 05 05 00 85 EB 7F 61 06 45 45 00 85 EB 7F}
    condition:
        $a at pe.entry_point
}

rule PEiD_01282_NoodleCrypt_v2_0_
{
    meta:
        description = "[NoodleCrypt v2.0]"
        ep_only = "true"
    strings:
        $a = {EB 01 9A E8 3D 00 00 00 EB 01 9A E8 EB 01 00 00 EB 01 9A E8 2C 04 00 00 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01283_NoodleCrypt_v2_0_
{
    meta:
        description = "[NoodleCrypt v2.0]"
        ep_only = "false"
    strings:
        $a = {EB 01 9A E8 ?? 00 00 00 EB 01 9A E8 ?? ?? 00 00 EB 01 9A E8 ?? ?? 00 00 EB 01}
    condition:
        $a
}

rule PEiD_01284_Noodlecrypt2____r_sc_
{
    meta:
        description = "[Noodlecrypt2 -> r!sc]"
        ep_only = "true"
    strings:
        $a = {EB 01 9A E8 76 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01285_North_Star_PE_Shrinker_1_3____Liuxingping_
{
    meta:
        description = "[North Star PE Shrinker 1.3 -> Liuxingping]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5}
    condition:
        $a at pe.entry_point
}

rule PEiD_01286_North_Star_PE_Shrinker_1_3_by_Liuxingping_
{
    meta:
        description = "[North Star PE Shrinker 1.3 by Liuxingping]"
        ep_only = "false"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 73 ?? FF FF 8B 06 83 F8 00 74 11 8D B5 7F ?? FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 C7 06 01 00 00 00 8B D5 8B 85 4F ?? FF FF 2B D0 89 95 4F ?? FF FF 01 95 67 ?? FF FF 8D B5 83 ?? FF FF 01}
    condition:
        $a
}

rule PEiD_01287_North_Star_PE_Shrinker_v1_3_by_Liuxingping_
{
    meta:
        description = "[North Star PE Shrinker v1.3 by Liuxingping]"
        ep_only = "false"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 73 ?? FF FF 8B 06 83 F8 00 74 11 8D B5 7F ?? FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 C7 06 01 00 00 00 8B D5 8B 85 4F ?? FF FF 2B D0 89 95 4F ?? FF FF 01 95 67 ?? FF FF 8D B5 83 ?? FF FF 01 16 8B 36 8B FD 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 A3 ?? FF FF 85 C0 0F 84 06 03 00 00 89 85 63 ?? FF FF E8 00 00 00 00 5B B9 31 89 40 00 81 E9 2E 86 40 00 03 D9 50 53 E8 3D 02 00 00 61 03 BD 47 ?? FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 2D 01 13 8B 33 03 7B 04 57 51 52 53 FF B5 A7 ?? FF FF FF B5 A3 ?? FF FF 56 57 FF 95 63 ?? FF FF 5B 5A 59 5F 83 F9 00 74 05 83 C3 08 EB CE 68 00 80 00 00 6A 00 FF B5 63 ?? FF FF FF 95 A7 ?? FF FF 8D}
    condition:
        $a
}

rule PEiD_01288_Norton_Speed_Disk_Configuration_file_
{
    meta:
        description = "[Norton Speed Disk Configuration file]"
        ep_only = "false"
    strings:
        $a = {4E 6F 72 74 6F 6E 20 53 70 65 65 64}
    condition:
        $a
}

rule PEiD_01289_nPack_1_1_150_2006_Beta____NEOx_
{
    meta:
        description = "[nPack 1.1.150.2006.Beta -> NEOx]"
        ep_only = "true"
    strings:
        $a = {83 3D ?? ?? ?? ?? ?? 75 05 E9 01 00 00 00 C3 E8 41 00 00 00 B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 5E 00 00 00 E8 E0 01 00 00 E8 EC 06 00 00 E8 F7 05 00 00 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? C3 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01290_nPack_1_1_150_2006_Beta____NEOx_
{
    meta:
        description = "[nPack 1.1.150.2006.Beta -> NEOx]"
        ep_only = "true"
    strings:
        $a = {83 3D ?? ?? ?? ?? ?? 75 05 E9 01 00 00 00 C3 E8 41 00 00 00 B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 5E 00 00 00 E8 E0 01 00 00 E8 EC 06 00 00 E8 F7 05 00 00 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? C3 C3 56 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 8B F8 68 ?? ?? ?? ?? 57 FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 5F A3 ?? ?? ?? ?? 5E C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01291_nPack_1_1_250_2006_Beta____NEOx__uinC__
{
    meta:
        description = "[nPack 1.1.250.2006.Beta -> NEOx/[uinC]]"
        ep_only = "false"
    strings:
        $a = {83 3D 04 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 B8 2E ?? ?? ?? 2B 05 08 ?? ?? ?? A3 00 ?? ?? ?? E8 9C 00 00 00 E8 04 02 00 00 E8 FB 06 00 00 E8 1B 06 00 00 A1 00 ?? ?? ?? C7 05 04 ?? ?? ?? 01 00 00 00 01 05 00 ?? ?? ?? FF 35 00}
    condition:
        $a
}

rule PEiD_01292_nPack_1_1_300_2006_Beta____NEOx_
{
    meta:
        description = "[nPack 1.1.300.2006 Beta -> NEOx]"
        ep_only = "true"
    strings:
        $a = {83 3D ?? ?? ?? ?? ?? 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 9C 00 00 00 E8 2D 02 00 00 E8 DD 06 00 00 E8 2C 06 00 00 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? C3 C3 56 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 8B F8 68 ?? ?? ?? ?? 57 FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 5F A3 ?? ?? ?? ?? 5E C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01293_nPack_v1_1_150_200_Beta____NEOx_
{
    meta:
        description = "[nPack v1.1 150-200 Beta -> NEOx]"
        ep_only = "true"
    strings:
        $a = {83 3D 40 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 41 00 00 00 B8 80 ?? ?? ?? 2B 05 08 ?? ?? ?? A3 3C ?? ?? 00 E8 5E 00 00 00 E8 E0 01 00 00 E8 EC 06 00 00 E8 F7 05 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01294_nPack_v1_1_250_Beta____NEOx_
{
    meta:
        description = "[nPack v1.1 250 Beta -> NEOx]"
        ep_only = "true"
    strings:
        $a = {83 3D 04 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 B8 2E ?? ?? ?? 2B 05 08 ?? ?? ?? A3 00 ?? ?? ?? E8 9C 00 00 00 E8 04 02 00 00 E8 FB 06 00 00 E8 1B 06 00 00 A1 00 ?? ?? ?? C7 05 04 ?? ?? ?? 01 00 00 00 01 05 00 ?? ?? ?? FF 35 00 ?? ?? ?? C3 C3 56 57 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_01295_nPack_V1_1_150_2006_Beta____NEOx__uinC_
{
    meta:
        description = "[nPack V1.1.150.2006.Beta -> NEOx/[uinC]"
        ep_only = "true"
    strings:
        $a = {83 3D 40 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 41 00 00 00 B8 80 ?? ?? ?? 2B 05 08 ?? ?? ?? A3 3C ?? ?? ?? E8 5E 00 00 00 E8 E0 01 00 00 E8 EC 06 00 00 E8 F7 05 00 00 A1 3C ?? ?? ?? C7 05 40 ?? ?? ?? 01 00 00 00 01 05 00 ?? ?? ?? FF 35 00 ?? ?? ?? C3 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01296_nPack_V1_1_150_2006_Beta____NEOx__uinC_
{
    meta:
        description = "[nPack V1.1.150.2006.Beta -> NEOx/[uinC]"
        ep_only = "true"
    strings:
        $a = {83 3D 40 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 41 00 00 00 B8 80 ?? ?? ?? 2B 05 08 ?? ?? ?? A3 3C ?? ?? ?? E8 5E 00 00 00 E8 E0 01 00 00 E8 EC 06 00 00 E8 F7 05 00 00 A1 3C ?? ?? ?? C7 05 40 ?? ?? ?? 01 00 00 00 01 05 00 ?? ?? ?? FF 35 00 ?? ?? ?? C3 C3 56 57 68 54 ?? ?? ?? FF 15 00 ?? ?? ?? 8B 35 08 ?? ?? ?? 8B F8 68 44 ?? ?? ?? 57 FF D6 68 38 ?? ?? ?? 57 A3 38 ?? ?? ?? FF D6 5F A3 34 ?? ?? ?? 5E C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01297_nPack_V1_1_200_2006_Beta____NEOx__uinC_
{
    meta:
        description = "[nPack V1.1.200.2006.Beta -> NEOx/[uinC]"
        ep_only = "true"
    strings:
        $a = {83 3D 40 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 41 00 00 00 B8 80 ?? ?? ?? 2B 05 08 ?? ?? ?? A3 3C ?? ?? ?? E8 5E 00 00 00 E8 EC 01 00 00 E8 F8 06 00 00 E8 03 06 00 00 A1 3C ?? ?? ?? C7 05 40 ?? ?? ?? 01 00 00 00 01 05 00 ?? ?? ?? FF 35 00 ?? ?? ?? C3 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01298_nPack_V1_1_250_2006_Beta____NEOx__uinC_
{
    meta:
        description = "[nPack V1.1.250.2006.Beta -> NEOx/[uinC]"
        ep_only = "true"
    strings:
        $a = {83 3D 04 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 B8 2E ?? ?? ?? 2B 05 08 ?? ?? ?? A3 00 ?? ?? ?? E8 9C 00 00 00 E8 04 02 00 00 E8 FB 06 00 00 E8 1B 06 00 00 A1 00 ?? ?? ?? C7 05 04 ?? ?? ?? 01 00 00 00 01 05 00 ?? ?? ?? FF 35 00 ?? ?? ?? C3 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01299_nPack_v1_1_xxx____NEOx_
{
    meta:
        description = "[nPack v1.1.xxx -> NEOx]"
        ep_only = "true"
    strings:
        $a = {83 3D ?? ?? ?? 00 00 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 B8 ?? ?? ?? ?? 2B 05 08 ?? ?? ?? A3 ?? ?? ?? ?? E8 9C 00 00 00 E8 ?? 02 00 00 E8 ?? 06 00 00 E8 ?? 06 00 00 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? 00 01 00 00 00 01 05 00 ?? ?? ?? FF 35 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01300_NSIS_Installer____NullSoft_
{
    meta:
        description = "[NSIS Installer -> NullSoft]"
        ep_only = "true"
    strings:
        $a = {83 EC 20 53 55 56 33 DB 57 89 5C 24 18 C7 44 24 10 ?? ?? ?? ?? C6 44 24 14 20 FF 15 30 70 40 00 53 FF 15 80 72 40 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE}
    condition:
        $a at pe.entry_point
}

rule PEiD_01301_NSPack____Nort_Star_Software___http___www_nsdsn_com__
{
    meta:
        description = "[NSPack -> Nort Star Software - http://www.nsdsn.com/]"
        ep_only = "false"
    strings:
        $a = {83 F9 00 74 28 43 8D B5 ?? ?? FF FF 8B 16 56 51 53 52 56 FF 33 FF 73 04 8B 43 08 03 C2 50 FF 95 ?? ?? FF FF 5A 5B 59 5E 83 C3 0C E2 E1 61 9D E9 ?? ?? ?? FF 8B B5 ?? ?? FF FF 0B F6 0F 84 97 00 00 00 8B 95 ?? ?? FF FF 03 F2 83 3E 00 75 0E 83 7E 04 00 75 08}
    condition:
        $a
}

rule PEiD_01302_NSPack____Nort_Star_Software___url____www_nsdsn_com__
{
    meta:
        description = "[NSPack -> Nort Star Software - url:://www.nsdsn.com/]"
        ep_only = "true"
    strings:
        $a = {83 F9 00 74 28 43 8D B5 ?? ?? FF FF 8B 16 56 51 53 52 56 FF 33 FF 73 04 8B 43 08 03 C2 50 FF 95 ?? ?? FF FF 5A 5B 59 5E 83 C3 0C E2 E1 61 9D E9 ?? ?? ?? FF 8B B5 ?? ?? FF FF 0B F6 0F 84 97 00 00 00 8B 95 ?? ?? FF FF 03 F2 83 3E 00 75 0E 83 7E 04 00 75 08 83 7E 08 00 75 02 EB 7A 8B 5E 08 03 DA 53 52 56 8D BD ?? ?? FF FF 03 7E 04 83 C6 0C 57}
    condition:
        $a at pe.entry_point
}

rule PEiD_01303_NsPacK__Net____LiuXingPing___Sign_by_fly_
{
    meta:
        description = "[NsPacK .Net -> LiuXingPing ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 BB 01 47 65 74 53 79 73 74 65 6D 49 6E 66 6F 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 5E 00 5F 43 6F 72 ?? ?? ?? 4D 61 69 6E 00 6D 73 63 6F 72 65 65 2E 64 6C 6C}
    condition:
        $a
}

rule PEiD_01304_NsPack_1_4____Liuxingping_
{
    meta:
        description = "[NsPack 1.4 -> Liuxingping]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 ?? ?? 40 00 2D ?? ?? 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01305_NsPack_1_4_by_North_Star__Liu_Xing_Ping__
{
    meta:
        description = "[NsPack 1.4 by North Star (Liu Xing Ping)]"
        ep_only = "false"
    strings:
        $a = {8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 2D 01 13 8B 33 03 7B 04 57 51 52 53}
    condition:
        $a
}

rule PEiD_01306_NsPack_2_3____Liu_Xing_Ping_
{
    meta:
        description = "[NsPack 2.3 -> Liu Xing Ping]"
        ep_only = "false"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? FF FF 8B 06 83 F8 00 74 11 8D B5 ?? ?? FF FF 8B 06 83 F8 01 0F 84 4B 02 00 00 C7 06 01 00 00 00 8B D5 8B 85 ?? ?? FF FF 2B D0 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 8B 36 8B FD}
    condition:
        $a
}

rule PEiD_01307_NsPack_2_9____North_Star_
{
    meta:
        description = "[NsPack 2.9 -> North Star]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? FF FF 8A 06 3C 00 74 12 8B F5 8D B5 ?? ?? FF FF 8A 06 3C 01 0F 84 42 02 00 00 C6 06 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 6A 03 00 00 89 85 ?? ?? FF FF E8 00 00 00 00 5B B9 68 03 00 00 03 D9 50 53 E8 B1 02 00 00 61 8B 36 8B FD 03 BD ?? ?? FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 36}
    condition:
        $a at pe.entry_point
}

rule PEiD_01308_nSPack_2_x____North_Star_Liu_Xing_Ping_
{
    meta:
        description = "[nSPack 2.x -> North Star/Liu Xing Ping]"
        ep_only = "true"
    strings:
        $a = {FF FF 8B 4E 08 8D 56 10 8B 36 8B FE 83 F9 00 74 3F 8A 07 47 2C E8 3C 01 77 F7 8B 07 80 7A 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01309_nSPack_2_x_3_x__NET____North_Star_Liu_Xing_Ping_
{
    meta:
        description = "[nSPack 2.x/3.x .NET -> North Star/Liu Xing Ping]"
        ep_only = "true"
    strings:
        $a = {FF 25 A4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01310_nSPack_2_x_3_x__NET___North_Star_Liu_Xing_Ping_
{
    meta:
        description = "[nSPack 2.x/3.x .NET-> North Star/Liu Xing Ping]"
        ep_only = "true"
    strings:
        $a = {FF 25 A4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01311_NsPack_3_0____North_Star_
{
    meta:
        description = "[NsPack 3.0 -> North Star]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? FF FF 66 8B 06 66 83 F8 00 74 15 8B F5 8D B5 ?? ?? FF FF 66 8B 06 66 83 F8 01 0F 84 42 02 00 00 C6 06 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 6A 03 00 00 89 85 ?? ?? FF FF E8 00 00 00 00 5B B9 68 03 00 00 03 D9 50 53 E8 B1 02 00 00 61 8B 36 8B FD 03 BD ?? ?? FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 36}
    condition:
        $a at pe.entry_point
}

rule PEiD_01312_NsPack_3_0_by_North_Star__Liu_Xing_Ping__
{
    meta:
        description = "[NsPack 3.0 by North Star (Liu Xing Ping)]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 55 F9 FF FF 66 8B 06 66 83 F8 00 74 15 8B F5 8D B5 7D F9 FF FF 66 8B 06 66 83 F8 01 0F 84 42 02 00 00 C6 06 01 8B D5 2B 95 11 F9 FF FF 89 95}
    condition:
        $a at pe.entry_point
}

rule PEiD_01313_NsPack_3_1____Liu_Xing_Ping_
{
    meta:
        description = "[NsPack 3.1 -> Liu Xing Ping]"
        ep_only = "false"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? ?? ?? 8A 03 3C 00 74 10 8D 9D ?? ?? FF FF 8A 03 3C 01 0F 84 42 02 00 00 C6 03 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00}
    condition:
        $a
}

rule PEiD_01314_NsPack_3_1____North_Star__h__
{
    meta:
        description = "[NsPack 3.1 -> North Star (h)]"
        ep_only = "false"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? FF FF 8A 03 3C 00 74 10 8D 9D ?? ?? FF FF 8A 03 3C 01 0F 84 42 02 00 00 C6 03 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00}
    condition:
        $a
}

rule PEiD_01315_NsPack_3_1_by_North_Star__Liu_Xing_Ping__
{
    meta:
        description = "[NsPack 3.1 by North Star (Liu Xing Ping)]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? FF FF 8A 03 3C 00 74 10 8D 9D ?? ?? FF FF 8A 03 3C 01 0F 84 42 02 00 00 C6 03 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5}
    condition:
        $a at pe.entry_point
}

rule PEiD_01316_NsPack_3_4____North_Star_
{
    meta:
        description = "[NsPack 3.4 -> North Star]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? FF FF 80 38 01 0F 84 42 02 00 00 C6 00 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 6A 03 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01317_NsPack_3_4____North_Star_
{
    meta:
        description = "[NsPack 3.4 -> North Star]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? FF FF 80 38 01 0F 84 42 02 00 00 C6 00 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 6A 03 00 00 89 85 ?? ?? FF FF E8 00 00 00 00 5B B9 68 03 00 00 03 D9 50 53 E8 B1 02 00 00 61 8B 36 8B FD 03 BD ?? ?? FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 36 01 13 8B 33 03 7B 04 57 51 52 53 FF B5 ?? ?? FF FF FF B5 ?? ?? FF FF 8B D6 8B CF 8B 85 ?? ?? FF FF 05 AA 05 00 00 FF D0 5B 5A 59 5F 83 F9 00 74 05 83 C3 08 EB C5}
    condition:
        $a at pe.entry_point
}

rule PEiD_01318_NsPack_3_x____Liu_Xing_Ping_
{
    meta:
        description = "[NsPack 3.x -> Liu Xing Ping]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01319_NSPack_3_x____Liu_Xing_Ping_
{
    meta:
        description = "[NSPack 3.x -> Liu Xing Ping]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? FF FF ?? 38 01 0F 84 ?? 02 00 00 ?? 00 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01320_NsPack_V1_1____LiuXingPing_
{
    meta:
        description = "[NsPack V1.1 -> LiuXingPing]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 57 84 40 00 2D 50 84 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01321_nSpack_V1_3____LiuXingPing_
{
    meta:
        description = "[nSpack V1.3 -> LiuXingPing]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01322_NsPack_V1_4____LiuXingPing_
{
    meta:
        description = "[NsPack V1.4 -> LiuXingPing]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 B1 85 40 00 2D AA 85 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01323_nSpack_V2_3____LiuXingPing_
{
    meta:
        description = "[nSpack V2.3 -> LiuXingPing]"
        ep_only = "false"
    strings:
        $a = {9C 60 70 61 63 6B 24 40}
    condition:
        $a
}

rule PEiD_01324_NsPack_v2_3____North_Star_
{
    meta:
        description = "[NsPack v2.3 -> North Star]"
        ep_only = "false"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? FF FF 8B 06 83 F8 00 74 11 8D B5 ?? ?? FF FF 8B 06 83 F8 01 0F 84 4B 02 00 00 C7 06 01 00 00 00 8B D5 8B 85 ?? ?? FF FF 2B D0 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 8B 36 8B FD 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 56 03 00 00 89 85 ?? ?? FF FF E8 00 00 00 00 5B B9 54 03 00 00 03 D9 50 53 E8 9D 02 00 00 61}
    condition:
        $a
}

rule PEiD_01325_nSpack_V2_x____LiuXingPing_
{
    meta:
        description = "[nSpack V2.x -> LiuXingPing]"
        ep_only = "false"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5}
    condition:
        $a
}

rule PEiD_01326_NsPack_V2_X____LiuXingPing_
{
    meta:
        description = "[NsPack V2.X -> LiuXingPing]"
        ep_only = "false"
    strings:
        $a = {6E 73 70 61 63 6B 24 40}
    condition:
        $a
}

rule PEiD_01327_NsPacK_V3_0____LiuXingPing_
{
    meta:
        description = "[NsPacK V3.0 -> LiuXingPing]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? ?? ?? 66 8B 06 66 83 F8 00 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_01328_NsPacK_V3_1____LiuXingPing_
{
    meta:
        description = "[NsPacK V3.1 -> LiuXingPing]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? ?? ?? 8A 03 3C 00 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_01329_NsPack_v3_1____North_Star_
{
    meta:
        description = "[NsPack v3.1 -> North Star]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? FF FF 8A 03 3C 00 74 10 8D 9D ?? ?? FF FF 8A 03 3C 01 0F 84 42 02 00 00 C6 03 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 6A 03 00 00 89 85 ?? ?? FF FF E8 00 00 00 00 5B B9 68 03 00 00 03 D9 50 53 E8 B1 02 00 00 61 8B 36 8B FD 03 BD ?? ?? FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 36 01 13 8B 33 03 7B 04 57 51 52 53 FF B5 ?? ?? FF FF FF B5 ?? ?? FF FF 8B D6 8B CF 8B 85 ?? ?? FF FF 05 AA 05 00 00 FF D0 5B 5A 59 5F 83 F9 00 74 05 83 C3 08 EB C5 68 00 80 00 00 6A 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01330_NsPacK_V3_3____LiuXingPing_
{
    meta:
        description = "[NsPacK V3.3 -> LiuXingPing]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? ?? ?? 80 38 00 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_01331_NsPacK_V3_4_V3_5____LiuXingPing_
{
    meta:
        description = "[NsPacK V3.4-V3.5 -> LiuXingPing]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? ?? ?? 80 38 01 0F 84}
    condition:
        $a at pe.entry_point
}

rule PEiD_01332_NsPacK_V3_6____LiuXingPing_
{
    meta:
        description = "[NsPacK V3.6 -> LiuXingPing]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D ?? ?? ?? ?? ?? 83 38 01 0F 84 47 02 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01333_NsPacK_V3_7____LiuXingPing_
{
    meta:
        description = "[NsPacK V3.7 -> LiuXingPing]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D ?? ?? ?? ?? ?? 80 39 01 0F ?? ?? ?? 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01334_NsPack_v3_7____North_Star__h__
{
    meta:
        description = "[NsPack v3.7 -> North Star (h)]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D 83 ED 07 8D 8D ?? ?? ?? FF 80 39 01 0F 84 42 02 00 00 C6 01 01 8B C5 2B 85 ?? ?? ?? FF 89 85 ?? ?? ?? FF 01 85 ?? ?? ?? FF 8D B5 ?? ?? ?? FF 01 06 55 56 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? ?? FF 85 C0 0F 84 69 03 00 00 89 85 ?? ?? ?? FF E8 00 00 00 00 5B B9 67 03 00 00 03 D9 50 53 E8 B0 02 00 00 5E 5D 8B 36 8B FD 03 BD ?? ?? ?? FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 34 01 13 8B 33 03 7B 04 57 51 53 FF B5 ?? ?? ?? FF FF B5 ?? ?? ?? FF 8B D6 8B CF 8B 85 ?? ?? ?? FF 05 AA 05 00 00 FF D0 5B 59 5F 83 F9 00 74 05 83 C3 08 EB C7 68 00 80 00 00 6A 00 FF B5 ?? ?? ?? FF FF 95 ?? ?? ?? FF 8D B5 ?? ?? ?? FF 8B 4E 08 8D 56 10 8B 36 8B FE 83 F9 00 74 3F 8A 07 47 2C E8 3C 01 77 F7 8B 07 80 7A 01 00 74 14 8A 1A 38 1F 75 E9 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 EB 0A 8A 5F 04 86 C4 C1 C0 10 86 C4 2B C7 03 C6 89 07 83 C7 05 80 EB E8 8B C3 E2 C6 E8 3A 01 00 00 8D 8D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01335_NTkrnl_Secure_Suite____NTkrnl_Team__Blue__
{
    meta:
        description = "[NTkrnl Secure Suite -> NTkrnl Team (Blue)]"
        ep_only = "false"
    strings:
        $a = {68 29 19 43 00 E8 01 00 00 00 C3 C3 A2 A9 61 4E A5 0E C7 A6 59 90 6E 4D 4C DB 36 46 FB 6E C4 45 A3 C2 2E 0E 41 59 1A 50 17 39 62 4D B8 61 24 8E CF D1 0E 9E 7A 66 C0 8D 6B 9C 52 7E 96 46 80 AF}
    condition:
        $a
}

rule PEiD_01336_NTkrnl_Secure_Suite____NTkrnl_team__h__
{
    meta:
        description = "[NTkrnl Secure Suite -> NTkrnl team (h)]"
        ep_only = "true"
    strings:
        $a = {34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 10 00 00 50 10 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73}
    condition:
        $a at pe.entry_point
}

rule PEiD_01337_NTkrnl_Secure_Suite____NTkrnl_team__h__
{
    meta:
        description = "[NTkrnl Secure Suite -> NTkrnl team (h)]"
        ep_only = "false"
    strings:
        $a = {34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 10 00 00 50 10 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 79}
    condition:
        $a
}

rule PEiD_01338_NTkrnl_Secure_Suite_0_1_0_15____NTkrnl_Software_
{
    meta:
        description = "[NTkrnl Secure Suite 0.1-0.15 -> NTkrnl Software]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 00 00 00 00 00 00 00 00 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_01339_NTkrnl_Secure_Suite_V0_1____NTkrnl_Software___Sign_by_fly_
{
    meta:
        description = "[NTkrnl Secure Suite V0.1 -> NTkrnl Software ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 00 00 00 00 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 68 ?? ?? ?? ?? E8 01 00 00 00 C3 C3}
    condition:
        $a
}

rule PEiD_01340_NTkrnl_Secure_Suite_V0_1_DLL____NTkrnl_Software___Sign_by_fly_
{
    meta:
        description = "[NTkrnl Secure Suite V0.1 DLL -> NTkrnl Software ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 00 00 00 00 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 8B 44 24 04 05 ?? ?? ?? ?? 50 E8 01 00 00 00 C3 C3}
    condition:
        $a
}

rule PEiD_01341_NTKrnlPacker____Ashkbiz_Danehkar_
{
    meta:
        description = "[NTKrnlPacker -> Ashkbiz Danehkar]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 00 00 00 00 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 10 00 00 50 10 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74}
    condition:
        $a
}

rule PEiD_01342_NTPacker_1_0____ErazerZ_
{
    meta:
        description = "[NTPacker 1.0 -> ErazerZ]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 E0 53 33 C0 89 45 E0 89 45 E4 89 45 E8 89 45 EC B8 ?? ?? 40 00 E8 ?? ?? FF FF 33 C0 55 68 ?? ?? 40 00 64 FF 30 64 89 20 8D 4D EC BA ?? ?? 40 00 A1 ?? ?? 40 00 E8 ?? FC FF FF 8B 55 EC B8 ?? ?? 40 00 E8 ?? ?? FF FF 8D 4D E8 BA ?? ?? 40 00 A1 ?? ?? 40 00 E8 ?? FE FF FF 8B 55 E8 B8 ?? ?? 40 00 E8 ?? ?? FF FF B8 ?? ?? 40 00 E8 ?? FB FF FF 8B D8 A1 ?? ?? 40 00 BA ?? ?? 40 00 E8 ?? ?? FF FF 75 26 8B D3 A1 ?? ?? 40 00 E8 ?? ?? FF FF 84 C0 75 2A 8D 55 E4 33 C0 E8 ?? ?? FF FF 8B 45 E4 8B D3 E8 ?? ?? FF FF EB 14 8D 55 E0 33 C0 E8 ?? ?? FF FF 8B 45 E0 8B D3 E8 ?? ?? FF FF 6A 00 E8 ?? ?? FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? 40 00 8D 45 E0 BA 04 00 00 00 E8 ?? ?? FF FF C3 E9 ?? ?? FF FF EB EB 5B E8 ?? ?? FF FF 00 00 00 FF FF FF FF 01 00 00 00 25 00 00 00 FF FF FF FF 01 00 00 00 5C 00 00 00 FF FF FF FF 06 00 00 00 53 45 52 56 45 52 00 00 FF FF FF FF 01 00 00 00 31}
    condition:
        $a at pe.entry_point
}

rule PEiD_01343_NTPacker_V2_X____ErazerZ___Sign_by_fly_
{
    meta:
        description = "[NTPacker V2.X -> ErazerZ ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {4B 57 69 6E 64 6F 77 73 00 10 55 54 79 70 65 73 00 00 3F 75 6E 74 4D 61 69 6E 46 75 6E 63 74 69 6F 6E 73 00 00 47 75 6E 74 42 79 70 61 73 73 00 00 B7 61 50 4C 69 62 75 00 00 00}
    condition:
        $a
}

rule PEiD_01344_Nullsoft_Install_System_1_xx_
{
    meta:
        description = "[Nullsoft Install System 1.xx]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 2C 53 56 33 F6 57 56 89 75 DC 89 75 F4 BB A4 9E 40 00 FF 15 60 70 40 00 BF C0 B2 40 00 68 04 01 00 00 57 50 A3 AC B2 40 00 FF 15 4C 70 40 00 56 56 6A 03 56 6A 01 68 00 00 00 80 57 FF 15 9C 70 40 00 8B F8 83 FF FF 89 7D EC 0F 84 C3 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01345_Nullsoft_Install_System_1_xx_
{
    meta:
        description = "[Nullsoft Install System 1.xx]"
        ep_only = "false"
    strings:
        $a = {83 EC 0C 53 56 57 FF 15 20 71 40 00 05 E8 03 00 00 BE 60 FD 41 00 89 44 24 10 B3 20 FF 15 28 70 40 00 68 00 04 00 00 FF 15 28 71 40 00 50 56 FF 15 08 71 40 00 80 3D 60 FD 41 00 22 75 08 80 C3 02 BE 61 FD 41 00 8A 06 8B 3D F0 71 40 00 84 C0 74 0F 3A C3 74}
    condition:
        $a
}

rule PEiD_01346_Nullsoft_Install_System_2_0_RC2_
{
    meta:
        description = "[Nullsoft Install System 2.0 RC2]"
        ep_only = "false"
    strings:
        $a = {83 EC 10 53 55 56 57 C7 44 24 14 70 92 40 00 33 ED C6 44 24 13 20 FF 15 2C 70 40 00 55 FF 15 84 72 40 00 BE 00 54 43 00 BF 00 04 00 00 56 57 A3 A8 EC 42 00 FF 15 C4 70 40 00 E8 8D FF FF FF 8B 1D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 5C 71 40 00}
    condition:
        $a
}

rule PEiD_01347_Nullsoft_Install_System_2_06_
{
    meta:
        description = "[Nullsoft Install System 2.06]"
        ep_only = "false"
    strings:
        $a = {83 EC 20 53 55 56 33 DB 57 89 5C 24 18 C7 44 24 10 ?? ?? ?? ?? C6 44 24 14 20 FF 15 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 02 23 00 00 BE ?? ?? ?? ?? 56}
    condition:
        $a
}

rule PEiD_01348_Nullsoft_Install_System_2_0_
{
    meta:
        description = "[Nullsoft Install System 2.0]"
        ep_only = "false"
    strings:
        $a = {83 EC 0C 53 55 56 57 C7 44 24 10 70 92 40 00 33 DB C6 44 24 14 20 FF 15 2C 70 40 00 53 FF 15 84 72 40 00 BE 00 54 43 00 BF 00 04 00 00 56 57 A3 A8 EC 42 00 FF 15 C4 70 40 00 E8 8D FF FF FF 8B 2D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 5C 71 40 00}
    condition:
        $a
}

rule PEiD_01349_Nullsoft_Install_System_2_0_
{
    meta:
        description = "[Nullsoft Install System 2.0]"
        ep_only = "true"
    strings:
        $a = {83 EC 0C 53 55 56 57 C7 44 24 10 ?? ?? ?? ?? 33 DB C6 44 24 14 20 FF 15 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? 56 57 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E8 8D FF FF FF 8B 2D ?? ?? ?? ?? 85 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01350_Nullsoft_Install_System_2_0a0_
{
    meta:
        description = "[Nullsoft Install System 2.0a0]"
        ep_only = "false"
    strings:
        $a = {83 EC 0C 53 56 57 FF 15 B4 10 40 00 05 E8 03 00 00 BE E0 E3 41 00 89 44 24 10 B3 20 FF 15 28 10 40 00 68 00 04 00 00 FF 15 14 11 40 00 50 56 FF 15 10 11 40 00 80 3D E0 E3 41 00 22 75 08 80 C3 02 BE E1 E3 41 00 8A 06 8B 3D 14 12 40 00 84 C0 74 19 3A C3 74}
    condition:
        $a
}

rule PEiD_01351_Nullsoft_Install_System_2_0b4_
{
    meta:
        description = "[Nullsoft Install System 2.0b4]"
        ep_only = "false"
    strings:
        $a = {83 EC 10 53 55 56 57 C7 44 24 14 F0 91 40 00 33 ED C6 44 24 13 20 FF 15 2C 70 40 00 55 FF 15 88 72 40 00 BE 00 D4 42 00 BF 00 04 00 00 56 57 A3 60 6F 42 00 FF 15 C4 70 40 00 E8 9F FF FF FF 8B 1D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 60 71 40 00}
    condition:
        $a
}

rule PEiD_01352_Nullsoft_Install_System_2_0b4_
{
    meta:
        description = "[Nullsoft Install System 2.0b4]"
        ep_only = "false"
    strings:
        $a = {83 EC 14 83 64 24 04 00 53 55 56 57 C6 44 24 13 20 FF 15 30 70 40 00 BE 00 20 7A 00 BD 00 04 00 00 56 55 FF 15 C4 70 40 00 56 E8 7D 2B 00 00 8B 1D 8C 70 40 00 6A 00 56 FF D3 BF 80 92 79 00 56 57 E8 15 26 00 00 85 C0 75 38 68 F8 91 40 00 55 56 FF 15 60 71}
    condition:
        $a
}

rule PEiD_01353_Nullsoft_Install_System_v1_98_
{
    meta:
        description = "[Nullsoft Install System v1.98]"
        ep_only = "true"
    strings:
        $a = {83 EC 0C 53 56 57 FF 15 2C 81 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_01354_Nullsoft_Install_System_v1_xx_
{
    meta:
        description = "[Nullsoft Install System v1.xx]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 2C 53 56 33 F6 57 56 89 75 DC 89 75 F4 BB A4 9E 40 00 FF 15 60 70 40 00 BF C0 B2 40 00 68 04 01 00 00 57 50 A3 AC B2 40 00 FF 15 4C 70 40 00 56 56 6A 03 56 6A 01 68 00 00 00 80 57 FF 15 9C 70 40 00 8B F8 83 FF FF 89 7D EC 0F 84 C3 00 00 00 56 56 56 89 75 E4 E8 C1 C9 FF FF 8B 1D 68 70 40 00 83 C4 0C 89 45 E8 89 75 F0 6A 02 56 6A FC 57 FF D3 89 45 FC 8D 45 F8 56 50 8D 45 E4 6A 04 50 57 FF 15 48 70 40 00 85 C0 75 07 BB 7C 9E 40 00 EB 7A 56 56 56 57 FF D3 39 75 FC 7E 62 BF 74 A2 40 00 B8 00 10 00 00 39 45 FC 7F 03 8B 45 FC 8D 4D F8 56 51 50 57 FF 75 EC FF 15 48 70 40 00 85 C0 74 5A FF 75 F8 57 FF 75 E8 E8 4D C9 FF FF 89 45 E8 8B 45 F8 29 45 FC 83 C4 0C 39 75 F4 75 11 57 E8 D3 F9 FF FF 85 C0 59 74 06 8B 45 F0 89 45 F4 8B 45 F8 01 45 F0 39 75 FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01355_Nullsoft_Install_System_v1_xx_
{
    meta:
        description = "[Nullsoft Install System v1.xx]"
        ep_only = "true"
    strings:
        $a = {83 EC 0C 53 56 57 FF 15 20 71 40 00 05 E8 03 00 00 BE 60 FD 41 00 89 44 24 10 B3 20 FF 15 28 70 40 00 68 00 04 00 00 FF 15 28 71 40 00 50 56 FF 15 08 71 40 00 80 3D 60 FD 41 00 22 75 08 80 C3 02 BE 61 FD 41 00 8A 06 8B 3D F0 71 40 00 84 C0 74 0F 3A C3 74 0B 56 FF D7 8B F0 8A 06 84 C0 75 F1 80 3E 00 74 05 56 FF D7 8B F0 89 74 24 14 80 3E 20 75 07 56 FF D7 8B F0 EB F4 80 3E 2F 75}
    condition:
        $a at pe.entry_point
}

rule PEiD_01356_Nullsoft_Install_System_v2_0_RC2_
{
    meta:
        description = "[Nullsoft Install System v2.0 RC2]"
        ep_only = "false"
    strings:
        $a = {83 EC 10 53 55 56 57 C7 44 24 14 70 92 40 00 33 ED C6 44 24 13 20 FF 15 2C 70 40 00 55 FF 15 84 72 40 00 BE 00 54 43 00 BF 00 04 00 00 56 57 A3 A8 EC 42 00 FF 15 C4 70 40 00 E8 8D FF FF FF 8B 1D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 5C 71 40 00 68 68 92 40 00 56 FF D3 E8 6A FF FF FF 85 C0 0F 84 59 01 00 00 BE 20 E4 42 00 56 FF 15 68 70 40 00 68 5C 92 40 00 56 E8 B9 28 00 00 57 FF 15 BC 70 40 00 BE 00 40 43 00 50 56 FF 15 B8 70 40 00 6A 00 FF 15 44 71 40 00 80 3D 00 40 43 00 22 A3 20 EC 42 00 8B C6 75 0A C6 44 24 13 22 B8 01 40 43 00 8B 3D 18 72 40 00 EB 09 3A 4C 24 13 74 09 50 FF D7 8A 08 84 C9 75 F1 50 FF D7 8B F0 89 74 24 1C EB 05 56 FF D7 8B F0 80 3E 20 74 F6 80 3E 2F 75 44 46 80 3E 53 75 0C 8A 46 01 0C 20 3C 20 75 03 83 CD 02 81 3E 4E 43 52}
    condition:
        $a
}

rule PEiD_01357_Nullsoft_Install_System_v2_0_
{
    meta:
        description = "[Nullsoft Install System v2.0]"
        ep_only = "false"
    strings:
        $a = {83 EC 0C 53 55 56 57 C7 44 24 10 70 92 40 00 33 DB C6 44 24 14 20 FF 15 2C 70 40 00 53 FF 15 84 72 40 00 BE 00 54 43 00 BF 00 04 00 00 56 57 A3 A8 EC 42 00 FF 15 C4 70 40 00 E8 8D FF FF FF 8B 2D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 5C 71 40 00 68 68 92 40 00 56 FF D5 E8 6A FF FF FF 85 C0 0F 84 57 01 00 00 BE 20 E4 42 00 56 FF 15 68 70 40 00 68 5C 92 40 00 56 E8 9C 28 00 00 57 FF 15 BC 70 40 00 BE 00 40 43 00 50 56 FF 15 B8 70 40 00 6A 00 FF 15 44 71 40 00 80 3D 00 40 43 00 22 A3 20 EC 42 00 75 0A C6 44 24 14 22 BE 01 40 43 00 FF 74 24 14 56 E8 8A 23 00 00 50 FF 15 80 71 40 00 8B F8 89 7C 24 18 EB 61 80 F9 20 75 06 40 80 38 20 74 FA 80 38 22 C6 44 24 14 20 75 06 40 C6 44 24 14 22 80 38 2F 75 31 40 80 38 53 75 0E 8A 48 01 80 C9 20 80 F9 20 75 03}
    condition:
        $a
}

rule PEiD_01358_Nullsoft_Install_System_v2_0a0_
{
    meta:
        description = "[Nullsoft Install System v2.0a0]"
        ep_only = "false"
    strings:
        $a = {83 EC 0C 53 56 57 FF 15 B4 10 40 00 05 E8 03 00 00 BE E0 E3 41 00 89 44 24 10 B3 20 FF 15 28 10 40 00 68 00 04 00 00 FF 15 14 11 40 00 50 56 FF 15 10 11 40 00 80 3D E0 E3 41 00 22 75 08 80 C3 02 BE E1 E3 41 00 8A 06 8B 3D 14 12 40 00 84 C0 74 19 3A C3 74 0B 56 FF D7 8B F0 8A 06 84 C0 75 F1 80 3E 00}
    condition:
        $a
}

rule PEiD_01359_Nullsoft_Install_System_v2_0b2__v2_0b3_
{
    meta:
        description = "[Nullsoft Install System v2.0b2, v2.0b3]"
        ep_only = "true"
    strings:
        $a = {83 EC 0C 53 55 56 57 FF 15 ?? 70 40 00 8B 35 ?? 92 40 00 05 E8 03 00 00 89 44 24 14 B3 20 FF 15 2C 70 40 00 BF 00 04 00 00 68 ?? ?? ?? 00 57 FF 15 ?? ?? 40 00 57 FF 15}
    condition:
        $a at pe.entry_point
}

rule PEiD_01360_Nullsoft_Install_System_v2_0b4_
{
    meta:
        description = "[Nullsoft Install System v2.0b4]"
        ep_only = "false"
    strings:
        $a = {83 EC 10 53 55 56 57 C7 44 24 14 F0 91 40 00 33 ED C6 44 24 13 20 FF 15 2C 70 40 00 55 FF 15 88 72 40 00 BE 00 D4 42 00 BF 00 04 00 00 56 57 A3 60 6F 42 00 FF 15 C4 70 40 00 E8 9F FF FF FF 8B 1D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 60 71 40 00 68 E4 91 40 00 56 FF D3 E8 7C FF FF FF 85 C0 0F 84 59 01 00 00 BE E0 66 42 00 56 FF 15 68 70 40 00 68 D8 91 40 00 56 E8 FE 27 00 00 57 FF 15 BC 70 40 00 BE 00 C0 42 00 50 56 FF 15 B8 70 40 00 6A 00 FF 15 44 71 40 00 80 3D 00 C0 42 00 22 A3 E0 6E 42 00 8B C6 75 0A C6 44 24 13 22 B8 01 C0 42 00 8B 3D 10 72 40 00 EB 09 3A 4C 24 13 74 09 50 FF D7 8A 08 84 C9 75 F1 50 FF D7 8B F0 89 74 24 1C EB 05 56 FF D7 8B F0 80 3E 20 74 F6 80 3E 2F 75 44 46 80 3E 53 75 0C 8A 46 01 0C 20 3C 20 75 03 83 CD 02 81 3E 4E 43 52}
    condition:
        $a
}

rule PEiD_01361_Nullsoft_Install_System_v2_0b4_
{
    meta:
        description = "[Nullsoft Install System v2.0b4]"
        ep_only = "false"
    strings:
        $a = {83 EC 14 83 64 24 04 00 53 55 56 57 C6 44 24 13 20 FF 15 30 70 40 00 BE 00 20 7A 00 BD 00 04 00 00 56 55 FF 15 C4 70 40 00 56 E8 7D 2B 00 00 8B 1D 8C 70 40 00 6A 00 56 FF D3 BF 80 92 79 00 56 57 E8 15 26 00 00 85 C0 75 38 68 F8 91 40 00 55 56 FF 15 60 71 40 00 03 C6 50 E8 78 29 00 00 56 E8 47 2B 00 00 6A 00 56 FF D3 56 57 E8 EA 25 00 00 85 C0 75 0D C7 44 24 14 58 91 40 00 E9 72 02 00 00 57 FF 15 24 71 40 00 68 EC 91 40 00 57 E8 43}
    condition:
        $a
}

rule PEiD_01362_Nullsoft_PiMP_Install_System_1_x_
{
    meta:
        description = "[Nullsoft PiMP Install System 1.x]"
        ep_only = "false"
    strings:
        $a = {83 EC 0C 53 56 57 FF 15 ?? ?? 40 00 05 E8 03 00 00 BE ?? ?? ?? 00 89 44 24 10 B3 20 FF 15 28 ?? 40 00 68 00 04 00 00 FF 15 ?? ?? 40 00 50 56 FF 15 ?? ?? 40 00 80 3D ?? ?? ?? 00 22 75 08 80 C3 02 BE ?? ?? ?? 00 8A 06 8B 3D ?? ?? 40 00 84 C0 74 ?? 3A C3 74}
    condition:
        $a
}

rule PEiD_01363_Nullsoft_PIMP_Install_System_v1_3x_
{
    meta:
        description = "[Nullsoft PIMP Install System v1.3x]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC ?? ?? 00 00 56 57 6A ?? BE ?? ?? ?? ?? 59 8D BD}
    condition:
        $a at pe.entry_point
}

rule PEiD_01364_Nullsoft_PiMP_Install_System_v1_x_
{
    meta:
        description = "[Nullsoft PiMP Install System v1.x]"
        ep_only = "false"
    strings:
        $a = {83 EC 0C 53 56 57 FF 15 ?? ?? 40 00 05 E8 03 00 00 BE ?? ?? ?? 00 89 44 24 10 B3 20 FF 15 28 ?? 40 00 68 00 04 00 00 FF 15 ?? ?? 40 00 50 56 FF 15 ?? ?? 40 00 80 3D ?? ?? ?? 00 22 75 08 80 C3 02 BE ?? ?? ?? 00 8A 06 8B 3D ?? ?? 40 00 84 C0 74 ?? 3A C3 74 0B 56 FF D7 8B F0 8A 06 84 C0 75 F1 80 3E 00 74 05 56 FF D7 8B F0 89 74 24 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 80 3E 2F}
    condition:
        $a
}

rule PEiD_01365_Nullsoft_PIMP_Install_System_v1_x_
{
    meta:
        description = "[Nullsoft PIMP Install System v1.x]"
        ep_only = "true"
    strings:
        $a = {83 EC 5C 53 55 56 57 FF 15 ?? ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01366_NX_PE_Packer_v1_0_
{
    meta:
        description = "[NX PE Packer v1.0]"
        ep_only = "true"
    strings:
        $a = {FF 60 FF CA FF 00 BA DC 0D E0 40 00 50 00 60 00 70 00 80 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01367_Obsidium_1_2_0_0____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.2.0.0 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 3F 1E 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01368_Obsidium_1_2_5_0____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.2.5.0 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {E8 0E 00 00 00 8B 54 24 0C 83 82 B8 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01369_Obsidium_1_2_5_0____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.2.5.0 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {E8 0E 00 00 00 8B 54 24 0C 83 82 B8 00 00 00 0D 33 C0 C3 64 67 FF 36 00 00 64 67 89 26 00 00 50 33 C0 8B 00 C3 E9 FA 00 00 00 E8 D5 FF FF FF 58 64 67 8F 06 00 00 83 C4 04 E8 2B 13 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01370_Obsidium_1_2_5_8____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.2.5.8 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? E8 29 00 00 00 EB 02 ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50 EB 03 ?? ?? ?? 33 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01371_Obsidium_1_2_5_8____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.2.5.8 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? E8 29 00 00 00 EB 02 ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50 EB 03 ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 01 ?? E9 FA 00 00 00 EB 02 ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 03 ?? ?? ?? EB 01 ?? 58 EB 01 ?? EB 02 ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 01 ?? E8 7B 21 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01372_Obsidium_1_3_0_0____Obsidium_Software__h__
{
    meta:
        description = "[Obsidium 1.3.0.0 -> Obsidium Software (h)]"
        ep_only = "false"
    strings:
        $a = {EB 04 25 80 34 CA E8 29 00 00 00 EB 02 C1 81 EB 01 3A 8B 54 24 0C EB 02 32 92 83 82 B8 00 00 00 22 EB 02 F2 7F 33 C0 EB 04 65 7E 14 79 C3 EB 04 05 AD 7F 45 EB 04 05 65 0B E8 64 67 FF 36 00 00 EB 04 0D F6 A8 7F 64 67 89 26 00 00 EB 04 8D 68 C7 FB EB 01 6B}
    condition:
        $a
}

rule PEiD_01373_Obsidium_1_3_0_0____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.0.0 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 04 ?? ?? ?? ?? E8 29 00 00 00 EB 02 ?? ?? EB 01 ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 22 EB 02 ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 50 EB 03 ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 01 ?? C3 EB 04 ?? ?? ?? ?? E9 FA 00 00 00 EB 01 ?? E8 D5 FF FF FF EB 02 ?? ?? EB 03 ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 01 ?? 64 67 8F 06 00 00 EB 02 ?? ?? 83 C4 04 EB 02 ?? ?? E8 47 26 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01374_Obsidium_1_3_0_13____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.0.13 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? E8 26 00 00 00 EB 02 ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 21 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 02 ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 01 ?? 33 C0 EB 03}
    condition:
        $a at pe.entry_point
}

rule PEiD_01375_Obsidium_1_3_0_13____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.0.13 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? E8 26 00 00 00 EB 02 ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 21 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 02 ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 01 ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 02 ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 01 ?? E8 D5 FF FF FF EB 03 ?? ?? ?? EB 02 ?? ?? 58 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 03 ?? ?? ?? 83 C4 04 EB 03 ?? ?? ?? E8 13 26 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01376_Obsidium_1_3_0_17____Obsidium_software_
{
    meta:
        description = "[Obsidium 1.3.0.17 -> Obsidium software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 28 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 25 EB 02 ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_01377_Obsidium_1_3_0_17____Obsidium_software_
{
    meta:
        description = "[Obsidium 1.3.0.17 -> Obsidium software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 28 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 25 EB 02 ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 01 ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 02 ?? ?? 58 EB 03 ?? ?? ?? EB 01 ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 02 ?? ?? E8 4F 26 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01378_Obsidium_1_3_0_21____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.0.21 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 03 ?? ?? ?? E8 2E 00 00 00 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 23 EB 01 ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 02 ?? ?? 50 EB 01 ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 01 ?? EB 01 ?? 58 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 03 ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 2B 26 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01379_Obsidium_1_3_0_37____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.0.37 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 26 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 01 ?? 58 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 ?? ?? ?? E8 23 27 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01380_Obsidium_1_3_0_4____Obsidium_Software__h__
{
    meta:
        description = "[Obsidium 1.3.0.4 -> Obsidium Software (h)]"
        ep_only = "false"
    strings:
        $a = {EB 02 ?? ?? E8 25 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 23 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 01 ?? 33 C0 EB 01}
    condition:
        $a
}

rule PEiD_01381_Obsidium_1_3_1_1____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.1.1 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 27 00 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 22 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB 01 ?? 8B 00 EB 03 ?? ?? ?? C3 EB 01 ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 01 ?? EB 03 ?? ?? ?? 58 EB 03 ?? ?? ?? EB 01 ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03}
    condition:
        $a at pe.entry_point
}

rule PEiD_01382_Obsidium_1_3_2_2____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.2.2 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 04 ?? ?? ?? ?? E8 2A 00 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 26 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 02 ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? 8B 00 EB 02 ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 01 ?? EB 01 ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_01383_Obsidium_1_3_3_1____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.1 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? E8 29 00 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 02 ?? ?? 50 EB 01 ?? 33 C0 EB 04 ?? ?? ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 02 ?? ?? E8 D5 FF FF FF EB 01 ?? EB 04 ?? ?? ?? ?? 58 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 02 ?? ?? E8 5F 27 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01384_Obsidium_1_3_3_2____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.2 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? E8 2B 00 00 00 EB 02 ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 02 ?? ?? 50 EB 02 ?? ?? 33 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01385_Obsidium_1_3_3_2____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.2 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? E8 2B 00 00 00 EB 02 ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 02 ?? ?? 50 EB 02 ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 02 ?? ?? C3 EB 04 ?? ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 03 ?? ?? ?? EB 01 ?? 58 EB 01 ?? EB 02 ?? ?? 64 67 8F 06 00 00 EB 02 ?? ?? 83 C4 04 EB 02 ?? ?? E8 3B 27 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01386_Obsidium_1_3_3_3____Obsidium_Software___Sign_By_haggar_
{
    meta:
        description = "[Obsidium 1.3.3.3 -> Obsidium Software * Sign.By.haggar]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 28 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 58 EB 01 ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 2B 27}
    condition:
        $a at pe.entry_point
}

rule PEiD_01387_Obsidium_1_3_3_3____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.3 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 28 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_01388_Obsidium_1_3_3_3____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.3 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 8B ?? 24 0C EB 01 ?? 83 ?? B8 00 00 00 28 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 58 EB 01 ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 2B 27 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01389_Obsidium_1_3_3_4____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.4 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 25 EB 02 ?? ?? 33 C0 EB 02 ?? ?? C3 EB 03 ?? ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 02 ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 50 EB 02 ?? ?? 33 C0 EB 01 ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 02 ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 03 ?? ?? ?? 58 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 03}
    condition:
        $a at pe.entry_point
}

rule PEiD_01390_Obsidium_1_3_3_6____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.6 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? ?? ?? ?? ?? ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 26 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? C3 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_01391_Obsidium_1_3_3_6____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.6 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? ?? ?? ?? ?? ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 26 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? C3 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 50 EB 01 ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 04 ?? ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 01 ?? EB 03 ?? ?? ?? 58 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_01392_Obsidium_1_3_3_7__2007_06_23_____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.7 (2007.06.23) -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 27 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 23 EB 03 ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 01 ?? 50 EB 02 ?? ?? 33 C0 EB 01 ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 01 ?? EB 01 ?? 58 EB 04 ?? ?? ?? ?? EB 01 ?? 64 67 8F 06 00 00 EB 02 ?? ?? 83 C4 04 EB 01 ?? E8 F7 26 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01393_Obsidium_1_3_3_7____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.7 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 2C 00 00 00 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 27 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50 EB 02 ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 ?? ?? ?? E8 23 27 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01394_Obsidium_1_3_3_8____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.8 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 ?? EB 04 ?? ?? ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 01 ?? EB 01 ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_01395_Obsidium_1_3_3_8____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.8 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 ?? EB 04 ?? ?? ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 01 ?? EB 01 ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 57 27 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01396_Obsidium_1_3_3_9____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.9 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 28 EB 02 ?? ?? 33 C0 EB 02 ?? ?? C3 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 01 ?? 50 EB 03}
    condition:
        $a at pe.entry_point
}

rule PEiD_01397_Obsidium_1_3_3_9____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.3.9 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 28 EB 02 ?? ?? 33 C0 EB 02 ?? ?? C3 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 01 ?? 50 EB 03 ?? ?? ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 04 ?? ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 03 ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 CF 27 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01398_Obsidium_1_3_4_1____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.4.1 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? E8 2A 00 00 00 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 21 EB 02 ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 02 ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33}
    condition:
        $a at pe.entry_point
}

rule PEiD_01399_Obsidium_1_3_4_1____Obsidium_Software_
{
    meta:
        description = "[Obsidium 1.3.4.1 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? E8 2A 00 00 00 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 21 EB 02 ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 02 ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 02 ?? ?? E8 D5 FF FF FF EB 01 ?? EB 01 ?? 58 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 02 ?? ?? E8 C3 27 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01400_Obsidium_v1_0_0_61_
{
    meta:
        description = "[Obsidium v1.0.0.61]"
        ep_only = "true"
    strings:
        $a = {E8 AF 1C 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01401_Obsidium_v1_1_1_1_
{
    meta:
        description = "[Obsidium v1.1.1.1]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 E7 1C 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01402_Obsidium_V1_2____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.2 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 77 1E 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01403_Obsidium_V1_2_5_8____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.2.5.8 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? E8 ?? 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01404_Obsidium_V1_2_5_8_V1_3_3_X____Obsidium_Software___Sign_by_fly_
{
    meta:
        description = "[Obsidium V1.2.5.8-V1.3.3.X -> Obsidium Software ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? E8 ?? 00 00 00 EB 02 ?? ?? EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01405_Obsidium_V1_2_X____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.2.X -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {E8 0E 00 00 00 33 C0 8B 54 24 0C 83 82 B8 00 00 00 0D C3 64 67 FF 36 00 00 64 67 89 26 00 00 50 33 C0 8B 00 C3 E9 FA 00 00 00 E8 D5 FF FF FF 58 64 67 8F 06 00 00 83 C4 04 E8 2B 13 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01406_Obsidium_V1_25____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.25 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {E8 0E 00 00 00 8B 54 24 0C 83 82 B8 00 00 00 0D 33 C0 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01407_Obsidium_v1_3_0_0____Obsidium_Software__h__
{
    meta:
        description = "[Obsidium v1.3.0.0 -> Obsidium Software (h)]"
        ep_only = "true"
    strings:
        $a = {EB 04 25 80 34 CA E8 29 00 00 00 EB 02 C1 81 EB 01 3A 8B 54 24 0C EB 02 32 92 83 82 B8 00 00 00 22 EB 02 F2 7F 33 C0 EB 04 65 7E 14 79 C3 EB 04 05 AD 7F 45 EB 04 05 65 0B E8 64 67 FF 36 00 00 EB 04 0D F6 A8 7F 64 67 89 26 00 00 EB 04 8D 68 C7 FB EB 01 6B 50 EB 03 8A 0B 93 33 C0 EB 02 28 B9 8B 00 EB 01 04 C3 EB 04 65 B3 54 0A E9 FA 00 00 00 EB 01 A2 E8 D5 FF FF FF EB 02 2B 49 EB 03 7C 3E 76 58 EB 04 B8 94 92 56 EB 01 72 64 67 8F 06 00 00 EB 02 23 72 83 C4 04 EB 02 A9 CB E8 47 26 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01408_Obsidium_V1_3_0_0____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.3.0.0 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 04 ?? ?? ?? ?? E8 29 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01409_Obsidium_V1_3_0_0____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.3.0.0 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 04 ?? ?? ?? ?? E8 29 00 00 00 EB 02 ?? ?? EB 01 ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 22 EB 02 ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 04 ?? ?? ?? ?? EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01410_Obsidium_V1_3_0_0____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.3.0.0 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 04 ?? ?? ?? ?? E8 ?? 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01411_Obsidium_v1_3_0_37____Obsidium_Software__h__
{
    meta:
        description = "[Obsidium v1.3.0.37 -> Obsidium Software (h)]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 26 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01412_Obsidium_v1_3_0_37____Obsidium_Software__h__
{
    meta:
        description = "[Obsidium v1.3.0.37 -> Obsidium Software (h)]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 26 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 01 ?? 58 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 ?? ?? ?? E8 23 27}
    condition:
        $a at pe.entry_point
}

rule PEiD_01413_Obsidium_v1_3_0_4____Obsidium_Software__h__
{
    meta:
        description = "[Obsidium v1.3.0.4 -> Obsidium Software (h)]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 25 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 23 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 01 ?? 33 C0 EB 01 ?? 8B 00 EB 01 ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 02 ?? ?? E8 D5 FF FF FF EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 58 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 03 ?? ?? ?? 83 C4 04 EB 01 ?? E8 3B 26 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01414_Obsidium_V1_3_0_4____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.3.0.4 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 ?? 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01415_Obsidium_V1_3_0_X____Obsidium_Software___Sign_by_fly_
{
    meta:
        description = "[Obsidium V1.3.0.X -> Obsidium Software ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {EB 03 ?? ?? ?? E8 2E 00 00 00 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 8B ?? ?? ?? EB 04 ?? ?? ?? ?? 83 ?? ?? ?? ?? ?? ?? EB 01 ?? 33 C0 EB 04 ?? ?? ?? ?? C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01416_Obsidium_V1_3_1_1____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.3.1.1 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 27 00 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 22 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33}
    condition:
        $a at pe.entry_point
}

rule PEiD_01417_Obsidium_V1_3_2_2____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.3.2.2 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 04 ?? ?? ?? ?? E8 2A 00 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 26 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 02 ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_01418_Obsidium_v1_3_3_1____Obsidium_Software__h__
{
    meta:
        description = "[Obsidium v1.3.3.1 -> Obsidium Software (h)]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? E8 29 00 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 02 ?? ?? 50 EB 01 ?? 33 C0 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01419_Obsidium_V1_3_3_3____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.3.3.3 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 8B ?? 24 0C EB 01 ?? 83 ?? B8 00 00 00 28 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_01420_Obsidium_V1_3_3_4____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.3.3.4 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 25 EB 02 ?? ?? 33 C0 EB 02 ?? ?? C3 EB 03 ?? ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 02 ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 50 EB 02 ?? ?? 33}
    condition:
        $a at pe.entry_point
}

rule PEiD_01421_Obsidium_V1_3_3_7____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.3.3.7 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 2C 00 00 00 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 27 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_01422_Obsidium_V1_3_4_2____Obsidium_Software_nbsp___nbsp___Sign_By_fly_
{
    meta:
        description = "[Obsidium V1.3.4.2 -> Obsidium Software&nbsp; &nbsp;* Sign.By.fly]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 24 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 01 ?? EB 03 ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 01 ?? E8 C3 27 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01423_Obsidium_V1_3_5_0____Obsidium_Software_
{
    meta:
        description = "[Obsidium V1.3.5.0 -> Obsidium Software]"
        ep_only = "true"
    strings:
        $a = {EB 03 ?? ?? ?? E8 ?? ?? ?? ?? EB 02 ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 20 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 04 ?? ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 01 ?? E8 ?? ?? ?? ?? EB 01 ?? EB 02 ?? ?? 58 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 8F 06 00 00 EB 02 ?? ?? 83 C4 04 EB 01 ?? E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01424_Obsiduim_1_3_0_4____Obsiduim_Software_
{
    meta:
        description = "[Obsiduim 1.3.0.4 -> Obsiduim Software]"
        ep_only = "true"
    strings:
        $a = {EB 02 ?? ?? E8 25 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 23 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64}
    condition:
        $a at pe.entry_point
}

rule PEiD_01425_ocBat2Exe_1_0____OC_
{
    meta:
        description = "[ocBat2Exe 1.0 -> OC]"
        ep_only = "true"
    strings:
        $a = {55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 B8 58 3C 40 00 E8 6C FA FF FF 33 C0 55 68 8A 3F 40 00 64 FF 30 64 89 20 6A 00 6A 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 33 C0 E8 81 E9 FF FF 8B 45 EC E8 41 F6 FF FF 50 E8 F3 FA FF FF 8B F8 83 FF FF 0F 84 83 02 00 00 6A 02 6A 00 6A EE 57 E8 FC FA FF FF 6A 00 68 60 99 4F 00 6A 12 68 18 57 40 00 57 E8 E0 FA FF FF 83 3D 60 99 4F 00 12 0F 85 56 02 00 00 8D 45 E4 50 8D 45 E0 BA 18 57 40 00 B9 40 42 0F 00 E8 61 F4 FF FF 8B 45 E0 B9 12 00 00 00 BA 01 00 00 00 E8 3B F6 FF FF 8B 45 E4 8D 55 E8 E8 04 FB ?? ?? ?? ?? E8 B8 58 99 4F 00 E8 67 F3 FF FF 33 C0 A3 60 99 4F 00 8D 45 DC 50 B9 05 00 00 00 BA 01 00 00 00 A1 58 99 4F 00 E8 04 F6 FF FF 8B 45 DC BA A4 3F 40 00 E8 E3 F4 FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01426_Open_Source_Code_Crypter____p0ke_
{
    meta:
        description = "[Open Source Code Crypter -> p0ke]"
        ep_only = "true"
    strings:
        $a = {55 8B EC B9 09 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 B8 34 44 40 00 E8 28 F8 FF FF 33 C0 55 68 9F 47 40 00 64 FF 30 64 89 20 BA B0 47 40 00 B8 1C 67 40 00 E8 07 FD FF FF 8B D8 85 DB 75 07 6A 00 E8 C2 F8 FF FF BA 28 67 40 00 8B C3 8B 0D 1C 67 40 00 E8 F0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01427_Open_Source_Code_Crypter____p0ke_
{
    meta:
        description = "[Open Source Code Crypter -> p0ke]"
        ep_only = "true"
    strings:
        $a = {55 8B EC B9 09 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 B8 34 44 40 00 E8 28 F8 FF FF 33 C0 55 68 9F 47 40 00 64 FF 30 64 89 20 BA B0 47 40 00 B8 1C 67 40 00 E8 07 FD FF FF 8B D8 85 DB 75 07 6A 00 E8 C2 F8 FF FF BA 28 67 40 00 8B C3 8B 0D 1C 67 40 00 E8 F0 E0 FF FF BE 01 00 00 00 B8 2C 68 40 00 E8 E1 F0 FF FF BF 0A 00 00 00 8D 55 EC 8B C6 E8 92 FC FF FF 8B 4D EC B8 2C 68 40 00 BA BC 47 40 00 E8 54 F2 FF FF A1 2C 68 40 00 E8 52 F3 FF FF 8B D0 B8 20 67 40 00 E8 A2 FC FF FF 8B D8 85 DB 0F 84 52 02 00 00 B8 24 67 40 00 8B 15 20 67 40 00 E8 78 F4 FF FF B8 24 67 40 00 E8 7A F3 FF FF 8B D0 8B C3 8B 0D 20 67 40 00 E8 77 E0 FF FF 8D 55 E8 A1 24 67 40 00 E8 42 FD FF FF 8B 55 E8 B8 24 67 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01428_ORiEN_2_11__DEMO__
{
    meta:
        description = "[ORiEN 2.11 (DEMO)]"
        ep_only = "false"
    strings:
        $a = {E9 5D 01 00 00 CE D1 CE CE 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F}
    condition:
        $a
}

rule PEiD_01429_ORiEN_2_11___2_12____Fisun_Alexander_
{
    meta:
        description = "[ORiEN 2.11 - 2.12 -> Fisun Alexander]"
        ep_only = "false"
    strings:
        $a = {E9 5D 01 00 00 CE D1 CE ?? 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F}
    condition:
        $a
}

rule PEiD_01430_ORiEN_V1_X_V2_X____Fisun_A_V____Sign_by_fly_
{
    meta:
        description = "[ORiEN V1.X-V2.X -> Fisun A.V. ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F 74 65 63 74 69 6F 6E 20 73 79 73 74 65 6D}
    condition:
        $a
}

rule PEiD_01431_ORiEN_v2_11__DEMO__
{
    meta:
        description = "[ORiEN v2.11 (DEMO)]"
        ep_only = "true"
    strings:
        $a = {E9 5D 01 00 00 CE D1 CE CE 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F 74 65 63 74 69 6F 6E 20 73 79 73 74 65 6D 20 2D 0D 0A 2D 2D 2D 2D 2D 2D 20 43 72 65 61 74 65 64 20 62 79 20 41 2E 20 46 69 73 75 6E 2C 20 31 39 39 34 2D 32 30 30 33 20 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 20 57 57 57 3A 20 68 74 74 70 3A 2F 2F 7A 61 6C 65 78 66 2E 6E 61 72 6F 64 2E 72 75 2F 20 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 20 65 2D 6D 61 69 6C 3A 20 7A 61 6C 65 78 66 40 68 6F 74 6D 61 69 6C 2E 72 75 20 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01432_ORiEN_v2_11___2_12____Fisun_Alexander_
{
    meta:
        description = "[ORiEN v2.11 - 2.12 -> Fisun Alexander]"
        ep_only = "true"
    strings:
        $a = {E9 5D 01 00 00 CE D1 CE ?? 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F 74 65 63 74 69 6F 6E 20 73 79 73 74 65 6D 20 2D 0D 0A 2D 2D 2D 2D 2D 2D 20 43 72 65 61 74 65 64 20 62 79 20 41 2E 20 46 69 73 75 6E 2C 20 31 39 39 34 2D 32 30 30 33 20 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 20 57 57 57 3A 20 68 74 74 70 3A 2F 2F 7A 61 6C 65 78 66 2E 6E 61 72 6F 64 2E 72 75 2F 20 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 20 65 2D 6D 61 69 6C 3A 20 7A 61 6C 65 78 66 40 68 6F 74 6D 61 69 6C 2E 72 75 20 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01433_ORiEN_V2_12____Fisun_A_V__
{
    meta:
        description = "[ORiEN V2.12 -> Fisun A.V.]"
        ep_only = "true"
    strings:
        $a = {E9 5D 01 00 00 CE D1 CE CD 0D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01434_Pack_Master_v1_0_
{
    meta:
        description = "[Pack Master v1.0]"
        ep_only = "true"
    strings:
        $a = {60 E8 01 00 00 00 E8 83 C4 04 E8 01 00 00 00 E9 5D 81 ED D3 22 40 00 E8 04 02 00 00 E8 EB 08 EB 02 CD 20 FF 24 24 9A 66 BE 47 46}
    condition:
        $a at pe.entry_point
}

rule PEiD_01435_Pack_Master_v1_0_
{
    meta:
        description = "[Pack Master v1.0]"
        ep_only = "true"
    strings:
        $a = {60 E8 01 ?? ?? ?? E8 83 C4 04 E8 01 ?? ?? ?? E9 5D 81 ED D3 22 40 ?? E8 04 02 ?? ?? E8 EB 08 EB 02 CD 20 FF 24 24 9A 66 BE 47 46}
    condition:
        $a at pe.entry_point
}

rule PEiD_01436_Packanoid____Arkanoid_
{
    meta:
        description = "[Packanoid -> Arkanoid]"
        ep_only = "true"
    strings:
        $a = {BF 00 10 40 00 BE ?? ?? ?? 00 E8 9D 00 00 00 B8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01437_Packanoid_1_0____ackanoid_
{
    meta:
        description = "[Packanoid 1.0 -> ackanoid]"
        ep_only = "true"
    strings:
        $a = {BF 00 ?? 40 00 BE ?? ?? ?? 00 E8 9D 00 00 00 B8 ?? ?? ?? 00 8B 30 8B 78 04 BB ?? ?? ?? 00 8B 43 04 91 E3 1F 51 FF D6 56 96 8B 13 8B 02 91 E3 0D 52 51 56 FF D7 5A 89 02 83 C2 04 EB EE 83 C3 08 5E EB DB B9 ?? ?? 00 00 BE 00 ?? ?? 00 EB 01 00 BF ?? ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01438_Packanoid_1_0____ackanoid_
{
    meta:
        description = "[Packanoid 1.0 -> ackanoid]"
        ep_only = "true"
    strings:
        $a = {BF 00 ?? 40 00 BE ?? ?? ?? 00 E8 9D 00 00 00 B8 ?? ?? ?? 00 8B 30 8B 78 04 BB ?? ?? ?? 00 8B 43 04 91 E3 1F 51 FF D6 56 96 8B 13 8B 02 91 E3 0D 52 51 56 FF D7 5A 89 02 83 C2 04 EB EE 83 C3 08 5E EB DB B9 ?? ?? 00 00 BE 00 ?? ?? 00 EB 01 00 BF ?? ?? ?? 00 EB 21 00 ?? ?? 00 00 ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 00 C0 00 F3 A4 E9 ?? ?? ?? 00 00 ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 00 02 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 00 C0 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C}
    condition:
        $a at pe.entry_point
}

rule PEiD_01439_Packanoid_v1____Arkanoid_
{
    meta:
        description = "[Packanoid v1 -> Arkanoid]"
        ep_only = "true"
    strings:
        $a = {BF ?? ?? ?? ?? BE ?? ?? ?? ?? E8 9D 00 00 00 B8 ?? ?? ?? ?? 8B 30 8B 78 04 BB ?? ?? ?? ?? 8B 43 04 91 E3 1F 51 FF D6 56 96 8B 13 8B 02 91 E3 0D 52 51 56 FF D7 5A 89 02 83 C2 04 EB EE 83 C3 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_01440_Packed_with__PKLITE_v1_50_with_CRC_check__1__
{
    meta:
        description = "[Packed with? PKLITE v1.50 with CRC check (1)]"
        ep_only = "true"
    strings:
        $a = {1F B4 09 BA ?? ?? CD 21 B8 ?? ?? CD 21}
    condition:
        $a at pe.entry_point
}

rule PEiD_01441_PackItBitch_1_0____archphase_
{
    meta:
        description = "[PackItBitch 1.0 -> archphase]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 00 00 00 00 28 ?? ?? ?? 35 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 41 ?? ?? ?? 50 ?? ?? ?? 00 00 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? ?? ?? ?? ?? ?? ?? 79 ?? ?? ?? 7D ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01442_PackItBitch_V1_0___archphase___Sign_by_fly_
{
    meta:
        description = "[PackItBitch V1.0-> archphase ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01443_PackItBitch_V1_0___archphase_
{
    meta:
        description = "[PackItBitch V1.0-> archphase]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_01444_Packman_0_0_0_1____bubba_
{
    meta:
        description = "[Packman 0.0.0.1 -> bubba]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 58 8D A8 ?? FE FF FF 8D 98 ?? ?? ?? FF 8D ?? ?? 01 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01445_Packman_0_0_0_1____Bubbasoft__h__
{
    meta:
        description = "[Packman 0.0.0.1 -> Bubbasoft (h)]"
        ep_only = "false"
    strings:
        $a = {0F 85 ?? FF FF FF 8D B3 ?? ?? ?? ?? EB 3D 8B 46 0C 03 C3 50 FF 55 00 56 8B 36 0B F6 75 02 8B F7 03 F3 03 FB EB 1B D1 C1 D1 E9 73 05 0F B7 C9 EB 05 03 CB 8D 49 02 50 51 50 FF 55 04 AB 58 83 C6 04 8B 0E 85 C9 75 DF 5E 83 C6 14 8B 7E 10 85 FF 75 BC 8D 8B 00 00 ?? ?? B8 00 ?? ?? 00 0B C0 74 34 03 C3 EB 2A 8D 70 08 03 40 04 33 ED 33 D2 66 8B 2E 66 0F A4 EA 04 80 FA 03 75 0D 81 E5 FF 0F 00 00 03 EF 03 EB 01 4D 00 46 46 3B F0 75 DC 8B 38 85 FF 75 D0 61 E9 ?? FE FF FF 02 D2 75 05 8A 16 46 12 D2 C3}
    condition:
        $a
}

rule PEiD_01446_Packman_0_0_0_1____Bubbasoft_
{
    meta:
        description = "[Packman 0.0.0.1 -> Bubbasoft]"
        ep_only = "true"
    strings:
        $a = {0F 85 ?? FF FF FF 8D B3 ?? ?? ?? ?? EB 3D 8B 46 0C 03 C3 50 FF 55 00 56 8B 36 0B F6 75 02 8B F7 03 F3 03 FB EB 1B D1 C1 D1 E9 73 05 0F B7 C9 EB 05 03 CB 8D 49 02 50 51 50 FF 55 04 AB 58 83 C6 04 8B 0E 85 C9 75 DF 5E 83 C6 14 8B 7E 10 85 FF 75 BC 8D 8B 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01447_Packman_Executable_Image_Packer_0_0_0_1____bubba_
{
    meta:
        description = "[Packman Executable Image Packer 0.0.0.1 -> bubba]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 58 8D A8 ?? ?? FF FF 8D 98 ?? ?? ?? FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01448_Packman_V0_0_0_1____Bubbasoft_
{
    meta:
        description = "[Packman V0.0.0.1 -> Bubbasoft]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 58 8D ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 8D ?? ?? 48}
    condition:
        $a at pe.entry_point
}

rule PEiD_01449_Packman_V1_0____Brandon_LaCombe_
{
    meta:
        description = "[Packman V1.0 -> Brandon LaCombe]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5B 8D 5B C6 01 1B 8B 13 8D 73 14 6A 08 59 01 16 AD 49 75 FA}
    condition:
        $a at pe.entry_point
}

rule PEiD_01450_Packman_v1_0____Brandon_LaCombe_
{
    meta:
        description = "[Packman v1.0 -> Brandon LaCombe]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5B 8D 5B C6 01 1B 8B 13 8D 73 14 6A 08 59 01 16 AD 49 75 FA 8B E8 C6 06 E9 8B 43 0C 89 46 01 6A 04 68 00 10 00 00 FF 73 08 51 FF 55 08 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01451_PACKWIN_v1_01p_
{
    meta:
        description = "[PACKWIN v1.01p]"
        ep_only = "true"
    strings:
        $a = {8C C0 FA 8E D0 BC ?? ?? FB 06 0E 1F 2E ?? ?? ?? ?? 8B F1 4E 8B FE 8C DB 2E ?? ?? ?? ?? 8E C3 FD F3 A4 53 B8 ?? ?? 50 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01452_PAK_SFX_Archive_
{
    meta:
        description = "[PAK-SFX Archive]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 ?? ?? A1 ?? ?? 2E ?? ?? ?? 2E ?? ?? ?? ?? ?? 8C D7 8E C7 8D ?? ?? BE ?? ?? FC AC 3C 0D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01453_PassEXE_v2_0_
{
    meta:
        description = "[PassEXE v2.0]"
        ep_only = "true"
    strings:
        $a = {06 1E 0E 0E 07 1F BE ?? ?? B9 ?? ?? 87 14 81 ?? ?? ?? EB ?? C7 ?? ?? ?? 84 00 87 ?? ?? ?? FB 1F 58 4A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01454_PassLock_2000_1_0__Eng_____Moonlight_Software_
{
    meta:
        description = "[PassLock 2000 1.0 (Eng) -> Moonlight-Software]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 56 57 BB 00 50 40 00 66 2E F7 05 34 20 40 00 04 00 0F 85 98 00 00 00 E8 1F 01 00 00 C7 43 60 01 00 00 00 8D 83 E4 01 00 00 50 FF 15 F0 61 40 00 83 EC 44 C7 04 24 44 00 00 00 C7 44 24 2C 00 00 00 00 54 FF 15 E8 61 40 00 B8 0A 00 00 00 F7 44 24}
    condition:
        $a at pe.entry_point
}

rule PEiD_01455_PassLock_2000_v1_0__Eng_____Moonlight_Software_
{
    meta:
        description = "[PassLock 2000 v1.0 (Eng) -> Moonlight-Software]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 56 57 BB 00 50 40 00 66 2E F7 05 34 20 40 00 04 00 0F 85 98 00 00 00 E8 1F 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01456_PassLock_2000_v1_0__Eng_____Moonlight_Software_
{
    meta:
        description = "[PassLock 2000 v1.0 (Eng) -> Moonlight-Software]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 56 57 BB 00 50 40 00 66 2E F7 05 34 20 40 00 04 00 0F 85 98 00 00 00 E8 1F 01 00 00 C7 43 60 01 00 00 00 8D 83 E4 01 00 00 50 FF 15 F0 61 40 00 83 EC 44 C7 04 24 44 00 00 00 C7 44 24 2C 00 00 00 00 54 FF 15 E8 61 40 00 B8 0A 00 00 00 F7 44 24 2C 01 00 00 00 74 05 0F B7 44 24 30 83 C4 44 89 43 56 FF 15 D0 61 40 00 E8 9E 00 00 00 89 43 4C FF 15 D4 61 40 00 89 43 48 6A 00 FF 15 E4 61 40 00 89 43 5C E8 F9 00 00 00 E8 AA 00 00 00 B8 FF 00 00 00 72 0D 53 E8 96 00 00 00 5B FF 4B 10 FF 4B 18 5F 5E 5B 5D 50 FF 15 C8 61 40 00 C3 83 7D 0C 01 75 3F E8 81 00 00 00 8D 83 E4 01 00 00 50 FF 15 F0 61 40 00 FF 15 D0 61 40 00 E8 3A 00 00 00 89 43 4C FF 15 D4 61 40 00 89 43 48 8B 45 08 89 43 5C E8 9A 00 00 00 E8 4B 00 00 00 72 11 66 FF 43 5A 8B 45 0C 89 43 60 53}
    condition:
        $a at pe.entry_point
}

rule PEiD_01457_Password_Protector__c__MiniSoft_1992_
{
    meta:
        description = "[Password Protector (c) MiniSoft 1992]"
        ep_only = "true"
    strings:
        $a = {06 0E 0E 07 1F E8 00 00 5B 83 EB 08 BA 27 01 03 D3 E8 3C 02 BA EA}
    condition:
        $a at pe.entry_point
}

rule PEiD_01458_Password_Protector_for_the_UPX_0_30____g0d_
{
    meta:
        description = "[Password Protector for the UPX 0.30 -> g0d]"
        ep_only = "true"
    strings:
        $a = {C8 50 01 00 60 E8 EC 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 55 53 45 52 33 32 2E 64 6C 6C 00 44 69 61 6C 6F 67 42 6F 78 49 6E 64 69 72 65 63 74 50 61 72 61 6D 41 00 53 65 6E 64 4D 65 73 73 61 67 65 41 00 45 6E 64 44 69 61 6C 6F}
    condition:
        $a at pe.entry_point
}

rule PEiD_01459_Password_protector_my_SMT_
{
    meta:
        description = "[Password protector my SMT]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? 5D 8B FD 81 ?? ?? ?? ?? ?? 81 ?? ?? ?? ?? ?? 83 ?? ?? 89 ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 46 80 ?? ?? 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_01460_Patch_Creation_Wizard_1_2_Byte_Patch_
{
    meta:
        description = "[Patch Creation Wizard 1.2 Byte Patch]"
        ep_only = "false"
    strings:
        $a = {E8 7F 03 00 00 6A 00 E8 24 03 00 00 A3 B8 33 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 2C 03 00 00 6A 00 E8 EF 02 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 B8 33 40 00 E8 1B 03 00 00 50 6A 01 68 80 00 00 00 FF 75}
    condition:
        $a
}

rule PEiD_01461_Patch_Creation_Wizard_1_2_Memory_Patch_
{
    meta:
        description = "[Patch Creation Wizard 1.2 Memory Patch]"
        ep_only = "false"
    strings:
        $a = {6A 00 E8 9B 02 00 00 A3 7A 33 40 00 6A 00 68 8E 10 40 00 6A 00 6A 01 50 E8 B5 02 00 00 68 5A 31 40 00 68 12 31 40 00 6A 00 6A 00 6A 04 6A 01 6A 00 6A 00 68 A2 30 40 00 6A 00 E8 51 02 00 00 85 C0 74 31 FF 35 62 31 40 00 6A 00 6A 30 E8 62 02 00 00 E8 0B 01}
    condition:
        $a
}

rule PEiD_01462_Patch_Creation_Wizard_1_2_Seek_and_Destroy_Patch_
{
    meta:
        description = "[Patch Creation Wizard 1.2 Seek and Destroy Patch]"
        ep_only = "false"
    strings:
        $a = {E8 C5 05 00 00 6A 00 E8 5E 05 00 00 A3 CE 39 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 72 05 00 00 6A 00 E8 2F 05 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 CE 39 40 00 E8 61 05 00 00 50 6A 01 68 80 00 00 00 FF 75}
    condition:
        $a
}

rule PEiD_01463_Patch_Creation_Wizard_v1_2_Byte_Patch_
{
    meta:
        description = "[Patch Creation Wizard v1.2 Byte Patch]"
        ep_only = "false"
    strings:
        $a = {E8 7F 03 00 00 6A 00 E8 24 03 00 00 A3 B8 33 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 2C 03 00 00 6A 00 E8 EF 02 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 B8 33 40 00 E8 1B 03 00 00 50 6A 01 68 80 00 00 00 FF 75 08 E8 1D 03 00 00 68 5F 30 40 00 6A 65 FF 75 08 E8 14 03 00 00 68 B0 30 40 00 6A 67 FF 75 08 E8 05 03 00 00 68 01 31 40 00 6A 66 FF 75 08 E8 F6 02 00 00 6A 00 FF 75 08 E8 C8 02 00 00 A3 B4 33 40 00 C7 05 BC 33 40 00 2C 00 00 00 C7 05 C0 33 40 00 10 00 00 00 C7 05 C4 33 40 00 00 08 00 00 68 BC 33 40 00 6A 01 6A FF FF 35 B4 33 40 00 E8 97 02 00 00 C7 05 C4 33 40 00 00 00 00 00 C7 05 E0 33 40 00 00 30 40 00 C7 05 E4 33 40 00 01 00 00 00 68 BC 33 40 00 6A 01 6A FF FF 35 B4 33 40 00 E8 65 02 00 00 EB 5F EB 54}
    condition:
        $a
}

rule PEiD_01464_Patch_Creation_Wizard_v1_2_Memory_Patch_
{
    meta:
        description = "[Patch Creation Wizard v1.2 Memory Patch]"
        ep_only = "false"
    strings:
        $a = {6A 00 E8 9B 02 00 00 A3 7A 33 40 00 6A 00 68 8E 10 40 00 6A 00 6A 01 50 E8 B5 02 00 00 68 5A 31 40 00 68 12 31 40 00 6A 00 6A 00 6A 04 6A 01 6A 00 6A 00 68 A2 30 40 00 6A 00 E8 51 02 00 00 85 C0 74 31 FF 35 62 31 40 00 6A 00 6A 30 E8 62 02 00 00 E8 0B 01 00 00 FF 35 5A 31 40 00 E8 22 02 00 00 FF 35 5E 31 40 00 E8 53 02 00 00 6A 00 E8 22 02 00 00 6A 10 68 F7 30 40 00 68 FE 30 40 00 6A 00 E8 63 02 00 00 6A 00 E8 08 02 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 75 6B 6A 01 FF 35 7A 33 40 00 E8 38 02 00 00 50 6A 01 68 80 00 00 00 FF 75 08 E8 34 02 00 00 68 00 30 40 00 6A 65 FF 75 08 E8 2B 02 00 00 68 51 30 40 00 6A 67 FF 75 08 E8 1C 02 00 00 68 A2 30 40 00 6A 66 FF 75 08 E8 0D 02 00 00 8B 45 08 A3 7E 33 40 00 68 3B 11 40 00 68 E8 03 00 00 68 9A 02 00}
    condition:
        $a
}

rule PEiD_01465_Patch_Creation_Wizard_v1_2_Seek_and_Destroy_Patch_
{
    meta:
        description = "[Patch Creation Wizard v1.2 Seek and Destroy Patch]"
        ep_only = "false"
    strings:
        $a = {E8 C5 05 00 00 6A 00 E8 5E 05 00 00 A3 CE 39 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 72 05 00 00 6A 00 E8 2F 05 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 CE 39 40 00 E8 61 05 00 00 50 6A 01 68 80 00 00 00 FF 75 08 E8 63 05 00 00 68 5F 30 40 00 6A 65 FF 75 08 E8 5A 05 00 00 68 B0 30 40 00 6A 67 FF 75 08 E8 4B 05 00 00 68 01 31 40 00 6A 66 FF 75 08 E8 3C 05 00 00 6A 00 FF 75 08 E8 0E 05 00 00 A3 CA 39 40 00 C7 05 D2 39 40 00 2C 00 00 00 C7 05 D6 39 40 00 10 00 00 00 C7 05 DA 39 40 00 00 08 00 00 68 D2 39 40 00 6A 01 6A FF FF 35 CA 39 40 00 E8 DD 04 00 00 C7 05 DA 39 40 00 00 00 00 00 C7 05 F6 39 40 00 00 30 40 00 C7 05 FA 39 40 00 01 00 00 00 68 D2 39 40 00 6A 01 6A FF FF 35 CA 39 40 00 E8 AB 04 00 00 EB 5F EB 54}
    condition:
        $a
}

rule PEiD_01466_PAV_Cryptor__Pawning_AntiVirus_Cryptor_____masha_dev_
{
    meta:
        description = "[PAV.Cryptor (Pawning AntiVirus Cryptor) -> masha_dev]"
        ep_only = "false"
    strings:
        $a = {53 56 57 55 BB 2C ?? ?? 70 BE 00 30 00 70 BF 20 ?? ?? 70 80 7B 28 00 75 16 83 3F 00 74 11 8B 17 89 D0 33 D2 89 17 8B E8 FF D5 83 3F 00 75 EF 83 3D 04 30 00 70 00 74 06 FF 15 54 30 00 70 80 7B 28 02 75 0A 83 3E 00 75 05 33 C0 89 43 0C FF 15 1C 30 00 70 80 7B 28 01 76 05 83 3E 00 74 22 8B 43 10 85 C0 74 1B FF 15 14 30 00 70 8B 53 10 8B 42 10 3B 42 04 74 0A 85 C0 74 06 50 E8 8F FA FF FF FF 15 20 30 00 70 80 7B 28 01 75 03 FF 53 24 80 7B 28 00 74 05 E8 35 FF FF FF 83 3B 00 75 17 83 3D 10 ?? ?? 70 00 74 06 FF 15 10 ?? ?? 70 8B 06 50 E8 A9 FA FF FF 8B 03 56 8B F0 8B FB B9 0B 00 00 00 F3 A5 5E E9 73 FF FF FF 5D 5F 5E 5B C3 A3 00 30 00 70 E8 26 FF FF FF C3 90 8F 05 04 30 00 70 E9 E9 FF FF FF C3}
    condition:
        $a
}

rule PEiD_01467_PC_Guard_for_Win32_5_00____SofPro_Blagoje_Ceklic__h__
{
    meta:
        description = "[PC Guard for Win32 5.00 -> SofPro/Blagoje Ceklic (h)]"
        ep_only = "false"
    strings:
        $a = {FC 55 50 E8 00 00 00 00 5D 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 B8 ?? ?? ?? 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 2B E8 9C EB 01 D5 9D EB 01 0B 58 60 E8 03 00 00 00 83 EB 0E EB 01 0C}
    condition:
        $a
}

rule PEiD_01468_PC_Guard_for_Win32_v5_00____SofPro_Blagoje_Ceklic__h__
{
    meta:
        description = "[PC Guard for Win32 v5.00 -> SofPro/Blagoje Ceklic (h)]"
        ep_only = "true"
    strings:
        $a = {FC 55 50 E8 00 00 00 00 5D 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 B8 ?? ?? ?? 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 2B E8 9C EB 01 D5 9D EB 01 0B 58 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01469_PC_PE_Encryptor_Alpha_preview_
{
    meta:
        description = "[PC PE Encryptor Alpha preview]"
        ep_only = "true"
    strings:
        $a = {53 51 52 56 57 55 E8 00 00 00 00 5D 8B CD 81 ED 33 30 40 ?? 2B 8D EE 32 40 00 83 E9 0B 89 8D F2 32 40 ?? 80 BD D1 32 40 ?? 01 0F 84}
    condition:
        $a at pe.entry_point
}

rule PEiD_01470_PC_Shrinker_v0_20_
{
    meta:
        description = "[PC Shrinker v0.20]"
        ep_only = "true"
    strings:
        $a = {E8 E8 01 ?? ?? 60 01 AD B3 27 40 ?? 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_01471_PC_Shrinker_v0_29_
{
    meta:
        description = "[PC Shrinker v0.29]"
        ep_only = "true"
    strings:
        $a = {?? BD ?? ?? ?? ?? 01 AD 55 39 40 ?? 8D B5 35 39 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_01472_PC_Shrinker_v0_45_
{
    meta:
        description = "[PC Shrinker v0.45]"
        ep_only = "true"
    strings:
        $a = {?? BD ?? ?? ?? ?? 01 AD E3 38 40 ?? FF B5 DF 38 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_01473_PC_Shrinker_v0_71_
{
    meta:
        description = "[PC Shrinker v0.71]"
        ep_only = "true"
    strings:
        $a = {9C 60 BD ?? ?? ?? ?? 01 AD 54 3A 40 ?? FF B5 50 3A 40 ?? 6A 40 FF 95 88 3A 40 ?? 50 50 2D ?? ?? ?? ?? 89 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_01474_PC_Guard_5_00d_
{
    meta:
        description = "[PC-Guard 5.00d]"
        ep_only = "false"
    strings:
        $a = {FC 55 50 E8 00 00 00 00 5D 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 B8 30 D2 40 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 2B E8 9C EB 01 D5 9D EB 01 0B 58 60 E8 03 00 00 00 83 EB 0E EB 01 0C}
    condition:
        $a
}

rule PEiD_01475_PC_Guard_v3_03d__v3_05d_
{
    meta:
        description = "[PC-Guard v3.03d, v3.05d]"
        ep_only = "true"
    strings:
        $a = {55 50 E8 ?? ?? ?? ?? 5D EB 01 E3 60 E8 03 ?? ?? ?? D2 EB 0B 58 EB 01 48 40 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01476_PC_Guard_v4_05d__v4_10d__v4_15d_
{
    meta:
        description = "[PC-Guard v4.05d, v4.10d, v4.15d]"
        ep_only = "true"
    strings:
        $a = {FC 55 50 E8 00 00 00 00 5D EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01477_PC_Guard_v5_00d_
{
    meta:
        description = "[PC-Guard v5.00d]"
        ep_only = "true"
    strings:
        $a = {FC 55 50 E8 00 00 00 00 5D 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 B8 30 D2 40 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 2B E8 9C EB 01 D5 9D EB 01 0B 58 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 89 85 E1 EA 41 00 9C EB 01 D5 9D EB 01 0B 58 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 89 85 F9 EA 41 00 9C EB 01 D5 9D EB 01 0B 89 9D E5 EA 41 00 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 89 8D E9 EA 41 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 89 95 ED EA 41 00 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 89 B5 F1 EA 41 00 9C EB 01 D5 9D EB 01 0B 89}
    condition:
        $a at pe.entry_point
}

rule PEiD_01478_PCIENC_Cryptor_
{
    meta:
        description = "[PCIENC Cryptor]"
        ep_only = "false"
    strings:
        $a = {06 50 43 49 45 4E}
    condition:
        $a
}

rule PEiD_01479_PCPEC__alpha___preview__
{
    meta:
        description = "[PCPEC \"alpha - preview\"]"
        ep_only = "true"
    strings:
        $a = {53 51 52 56 57 55 E8 00 00 00 00 5D 8B CD 81 ED 33 30 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01480_PCPEC__alpha__
{
    meta:
        description = "[PCPEC [alpha]]"
        ep_only = "true"
    strings:
        $a = {53 51 52 56 57 55 E8 ?? ?? ?? ?? 5D 8B CD 81 ?? ?? ?? ?? ?? 2B ?? ?? ?? ?? ?? 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_01481_PCrypt_v3_51_
{
    meta:
        description = "[PCrypt v3.51]"
        ep_only = "true"
    strings:
        $a = {50 43 52 59 50 54 FF 76 33 2E 35 31 00 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01482_PcShare____________v4_0_____________
{
    meta:
        description = "[PcShare ļ v4.0 -> ޿ɷ]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 90 34 40 00 68 B6 28 40 00 64 A1}
    condition:
        $a at pe.entry_point
}

rule PEiD_01483_PCShrink_0_71_beta_
{
    meta:
        description = "[PCShrink 0.71 beta]"
        ep_only = "true"
    strings:
        $a = {01 AD 54 3A 40 00 FF B5 50 3A 40 00 6A 40 FF 95 88 3A 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01484_PCShrink_v0_40b_
{
    meta:
        description = "[PCShrink v0.40b]"
        ep_only = "true"
    strings:
        $a = {9C 60 BD ?? ?? ?? ?? 01 ?? ?? ?? ?? ?? FF ?? ?? ?? ?? ?? 6A ?? FF ?? ?? ?? ?? ?? 50 50 2D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01485_PDS_graphics_file_format_
{
    meta:
        description = "[PDS graphics file format]"
        ep_only = "false"
    strings:
        $a = {49 4D 41 47 45 49 44 45 4E 54 49 46 49 45 52 20}
    condition:
        $a
}

rule PEiD_01486_PE_Crypt_v1_00_v1_01_
{
    meta:
        description = "[PE Crypt v1.00/v1.01]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? 5B 83 EB 05 EB 04 52 4E 44 21 EB 02 CD 20 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01487_PE_Crypt_v1_02_
{
    meta:
        description = "[PE Crypt v1.02]"
        ep_only = "false"
    strings:
        $a = {E8 ?? ?? ?? ?? 5B 83 EB 05 EB 04 52 4E 44}
    condition:
        $a
}

rule PEiD_01488_PE_Crypt32__Console_v1_0__v1_01__v1_02__
{
    meta:
        description = "[PE Crypt32 (Console v1.0, v1.01, v1.02)]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 5B 83 EB 05 EB 04 52 4E 44 21 EB 02 CD 20 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01489_PE_Crypt32_v1_02_
{
    meta:
        description = "[PE Crypt32 v1.02]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 5B 83 ?? ?? EB ?? 52 4E 44 21}
    condition:
        $a at pe.entry_point
}

rule PEiD_01490_PE_Diminisher_V0_1____Teraphy_
{
    meta:
        description = "[PE Diminisher V0.1 -> Teraphy]"
        ep_only = "true"
    strings:
        $a = {53 51 52 56 57 55 E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01491_PE_Diminisher_v0_1____Teraphy_
{
    meta:
        description = "[PE Diminisher v0.1 -> Teraphy]"
        ep_only = "true"
    strings:
        $a = {53 51 52 56 57 55 E8 00 00 00 00 5D 8B D5 81 ED A2 30 40 00 2B 95 91 33 40 00 81 EA 0B 00 00 00 89 95 9A 33 40 00 80 BD 99 33 40 00 00 74 50 E8 02 01 00 00 8B FD 8D 9D 9A 33 40 00 8B 1B 8D 87}
    condition:
        $a at pe.entry_point
}

rule PEiD_01492_PE_Diminisher_v0_1_
{
    meta:
        description = "[PE Diminisher v0.1]"
        ep_only = "true"
    strings:
        $a = {53 51 52 56 57 55 E8 00 00 00 00 5D 8B D5 81 ED A2 30 40 00 2B 95 91 33 40 00 81 EA 0B 00 00 00 89 95 9A 33 40 00 80 BD 99 33 40 00 00 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_01493_PE_Diminisher_v0_1_
{
    meta:
        description = "[PE Diminisher v0.1]"
        ep_only = "true"
    strings:
        $a = {5D 8B D5 81 ED A2 30 40 ?? 2B 95 91 33 40 ?? 81 EA 0B ?? ?? ?? 89 95 9A 33 40 ?? 80 BD 99}
    condition:
        $a at pe.entry_point
}

rule PEiD_01494_PE_Encrypt_1_0____Liwuyue_
{
    meta:
        description = "[PE Encrypt 1.0 -> Liwuyue]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 D0 53 56 57 8D 75 FC 8B 44 24 30 25 00 00 FF FF 81 38 4D 5A 90 00 74 07 2D 00 10 00 00 EB F1 89 45 FC E8 C8 FF FF FF 2D 0F 05 00 00 89 45 F4 8B 06 8B 40 3C 03 06 8B 40 78 03 06 8B C8 8B 51 20 03 16 8B 59 24 03 1E 89 5D F0 8B 59 1C 03 1E 89 5D EC 8B 41 18 8B C8 49 85 C9 72 5A 41 33 C0 8B D8 C1 E3 02 03 DA 8B 3B 03 3E 81 3F 47 65 74 50 75 40 8B DF 83 C3 04 81 3B 72 6F 63 41 75 33 8B DF 83 C3 08 81 3B 64 64 72 65 75 26 83 C7 0C 66 81 3F 73 73}
    condition:
        $a at pe.entry_point
}

rule PEiD_01495_PE_Intro_v1_0_
{
    meta:
        description = "[PE Intro v1.0]"
        ep_only = "true"
    strings:
        $a = {8B 04 24 9C 60 E8 ?? ?? ?? ?? 5D 81 ED 0A 45 40 ?? 80 BD 67 44 40 ?? ?? 0F 85 48}
    condition:
        $a at pe.entry_point
}

rule PEiD_01496_PE_Lock_NT_v2_01_
{
    meta:
        description = "[PE Lock NT v2.01]"
        ep_only = "true"
    strings:
        $a = {EB 03 CD 20 EB EB 01 EB 1E EB 01 EB EB 02 CD 20 9C EB 03 CD}
    condition:
        $a at pe.entry_point
}

rule PEiD_01497_PE_Lock_NT_v2_02c_
{
    meta:
        description = "[PE Lock NT v2.02c]"
        ep_only = "true"
    strings:
        $a = {EB 02 C7 85 1E EB 03 CD 20 EB EB 01 EB 9C EB 01 EB EB 02 CD}
    condition:
        $a at pe.entry_point
}

rule PEiD_01498_PE_Lock_NT_v2_03_
{
    meta:
        description = "[PE Lock NT v2.03]"
        ep_only = "true"
    strings:
        $a = {EB 02 C7 85 1E EB 03 CD 20 C7 9C EB 02 69 B1 60 EB 02 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01499_PE_Lock_NT_v2_04_
{
    meta:
        description = "[PE Lock NT v2.04]"
        ep_only = "true"
    strings:
        $a = {EB ?? CD ?? ?? ?? ?? ?? CD ?? ?? ?? ?? ?? EB ?? EB ?? EB ?? EB ?? CD ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 50 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01500_PE_Lock_v1_06_
{
    meta:
        description = "[PE Lock v1.06]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 4B 45}
    condition:
        $a at pe.entry_point
}

rule PEiD_01501_Pe_Ninja_____DzA_kRAker__TNT_
{
    meta:
        description = "[Pe Ninja -> +DzA kRAker [TNT]"
        ep_only = "true"
    strings:
        $a = {BE 5B 2A 40 00 BF 35 12 00 00 E8 40 12 00 00 3D 22 83 A3 C6 0F 85 67 0F 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01502_Pe_Ninja_____DzA_kRAker__TNT__
{
    meta:
        description = "[Pe Ninja -> +DzA kRAker [TNT]]"
        ep_only = "true"
    strings:
        $a = {BE 5B 2A 40 00 BF 35 12 00 00 E8 40 12 00 00 3D 22 83 A3 C6 0F 85 67 0F 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01503_PE_Ninja_v1_0_____DzA_kRAker_TNT_
{
    meta:
        description = "[PE Ninja v1.0 -> +DzA kRAker TNT]"
        ep_only = "true"
    strings:
        $a = {BE 5B 2A 40 00 BF 35 12 00 00 E8 40 12 00 00 3D 22 83 A3 C6 0F 85 67 0F 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01504_PE_Pack_v0_99_
{
    meta:
        description = "[PE Pack v0.99]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 83 ED 06 80 BD E0 04 ?? ?? 01 0F 84 F2}
    condition:
        $a at pe.entry_point
}

rule PEiD_01505_PE_Packer_
{
    meta:
        description = "[PE Packer]"
        ep_only = "true"
    strings:
        $a = {FC 8B 35 70 01 40 ?? 83 EE 40 6A 40 68 ?? 30 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_01506_PE_Password_v0_2_SMT_SMF_
{
    meta:
        description = "[PE Password v0.2 SMT/SMF]"
        ep_only = "true"
    strings:
        $a = {E8 04 ?? ?? ?? 8B EC 5D C3 33 C0 5D 8B FD 81 ED 33 26 40 ?? 81 EF ?? ?? ?? ?? 83 EF 05 89 AD 88 27 40 ?? 8D 9D 07 29 40 ?? 8D B5 62 28 40 ?? 46 80}
    condition:
        $a at pe.entry_point
}

rule PEiD_01507_PE_Protect_0_9_
{
    meta:
        description = "[PE Protect 0.9]"
        ep_only = "false"
    strings:
        $a = {E9 ?? 00 00 00 0D 0A 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 50 45 2D 50 52 4F 54 45 43 54 20 30 2E 39 20 28 43 29 6F}
    condition:
        $a
}

rule PEiD_01508_PE_Protect_v0_9_
{
    meta:
        description = "[PE Protect v0.9]"
        ep_only = "true"
    strings:
        $a = {52 51 55 57 64 67 A1 30 00 85 C0 78 0D E8 ?? ?? ?? ?? 58 83 C0 07 C6 ?? C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01509_PE_Protector_0_9_3____CRYPToCRACk_
{
    meta:
        description = "[PE Protector 0.9.3 -> CRYPToCRACk]"
        ep_only = "true"
    strings:
        $a = {5B 81 E3 00 FF FF FF 66 81 3B 4D 5A 75 33 8B F3 03 73 3C 81 3E 50 45 00 00 75 26 0F B7 46 18 8B C8 69 C0 AD 0B 00 00 F7 E0 2D AB 5D 41 4B 69 C9 DE C0 00 00 03 C1 75 09 83 EC 04 0F 85 DD 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01510_PE_Spin_0_b_
{
    meta:
        description = "[PE Spin 0.b]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 72 C8 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 26 E8 01 00 00 00 EA 5A 33 C9}
    condition:
        $a
}

rule PEiD_01511_PE_Spin_v0_4x_
{
    meta:
        description = "[PE Spin v0.4x]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B}
    condition:
        $a
}

rule PEiD_01512_PE_Spin_v0_b_
{
    meta:
        description = "[PE Spin v0.b]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 72 C8 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 26 E8 01 00 00 00 EA 5A 33 C9 8B 95 68 20 40 00 8B 42 3C 03 C2 89 85 76 20 40 00 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 9D 8A 20 40 00 8B 59 24 03 DA 8B 1B 89 9D 8E 20 40 00 53 8F 85 E2 1F 40 00 8D 85 92 20 40 00 6A 0C 5B 6A 17 59 30 0C 03 02 CB 4B 75 F8 40 8D 9D 41 8F 4E 00 50 53 81 2C 24 01 78 0E 00 FF B5 8A 20 40 00 C3 92 EB 15 68 BB ?? 00 00 00 B9 90 08 00 00 8D BD FF 20 40 00 4F 30 1C 39 FE CB E2 F9 68 1D 01 00 00 59 8D BD 2F 28 40 00 C0 0C 39 02 E2 FA 68 A0 20 40 00 50 01 6C 24 04 E8 BD 09 00 00 33 C0 0F 84 C0 08 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01513_PE_Armor_0_46____China_Cracking_Group_
{
    meta:
        description = "[PE-Armor 0.46 -> China Cracking Group]"
        ep_only = "true"
    strings:
        $a = {E8 AA 00 00 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 3D ?? ?? 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B ?? ?? 00 5C ?? ?? 00 6F ?? ?? 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41}
    condition:
        $a at pe.entry_point
}

rule PEiD_01514_PE_Armor_0_46____China_Cracking_Group_
{
    meta:
        description = "[PE-Armor 0.46 -> China Cracking Group]"
        ep_only = "true"
    strings:
        $a = {E8 AA 00 00 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 3D ?? ?? 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B ?? ?? 00 5C ?? ?? 00 6F ?? ?? 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 A2 01 00 00 ?? ?? 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 5D 81 ED 05 00 00 00 8D 75 3D 56 FF 55 31 8D B5 86 00 00 00 56 50 FF 55 2D 89 85 93 00 00 00 6A 04 68 00 10 00 00 FF B5 82 00 00 00 6A 00 FF 95 93 00 00 00 50 8B 9D 7E 00 00 00 03 DD 50 53 E8 04 00 00 00 5A 55 FF E2 60 8B 74 24 24 8B 7C 24 28 FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01515_PE_Armor_0_46____Hying_
{
    meta:
        description = "[PE-Armor 0.46 -> Hying]"
        ep_only = "true"
    strings:
        $a = {E8 AA 00 00 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 3D ?? ?? 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B ?? ?? 00 5C ?? ?? 00 6F ?? ?? 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41}
    condition:
        $a at pe.entry_point
}

rule PEiD_01516_PE_Armor_0_460_0_759____hying_
{
    meta:
        description = "[PE-Armor 0.460-0.759 -> hying]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01517_PE_Armor_0_460_0_759____hying_
{
    meta:
        description = "[PE-Armor 0.460-0.759 -> hying]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00}
    condition:
        $a
}

rule PEiD_01518_PE_Armor_0_49____Hying_
{
    meta:
        description = "[PE-Armor 0.49 -> Hying]"
        ep_only = "true"
    strings:
        $a = {56 52 51 53 55 E8 15 01 00 00 32 ?? ?? 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01519_PE_Armor_0_760_0_765____hying_
{
    meta:
        description = "[PE-Armor 0.760-0.765 -> hying]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 00 08 00 00 00 00 00 00 00 60 E8 00 00 00 00}
    condition:
        $a
}

rule PEiD_01520_PE_Armor_V0_760_V0_765____hying_
{
    meta:
        description = "[PE-Armor V0.760-V0.765 -> hying]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72}
    condition:
        $a at pe.entry_point
}

rule PEiD_01521_PE_Crypt_1_02_
{
    meta:
        description = "[PE-Crypt 1.02]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 5B 83 EB 05 EB 04 52 4E 44 21 85 C0 73 02 F7}
    condition:
        $a at pe.entry_point
}

rule PEiD_01522_PE_Crypter_
{
    meta:
        description = "[PE-Crypter]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D EB 26}
    condition:
        $a at pe.entry_point
}

rule PEiD_01523_PE_PACK_0_99_
{
    meta:
        description = "[PE-PACK 0.99]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 83 ED 06 80 BD E0 04 00 00 01 0F 84 F2}
    condition:
        $a at pe.entry_point
}

rule PEiD_01524_PE_PaCK_1_0_____C__Copyright_1998_by_ANAKiN__h__
{
    meta:
        description = "[PE-PaCK 1.0 -> (C) Copyright 1998 by ANAKiN (h)]"
        ep_only = "false"
    strings:
        $a = {C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 20 2D 3D FE 20 50 45 2D 50 41 43 4B 20 76 31 2E 30 20 2D FE 2D 20 28 43 29 20 43 6F 70}
    condition:
        $a
}

rule PEiD_01525_PE_PaCK_v1_0_____C__Copyright_1998_by_ANAKiN__h__
{
    meta:
        description = "[PE-PaCK v1.0 -> (C) Copyright 1998 by ANAKiN (h)]"
        ep_only = "false"
    strings:
        $a = {C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 20 2D 3D FE 20 50 45 2D 50 41 43 4B 20 76 31 2E 30 20 2D FE 2D 20 28 43 29 20 43 6F 70 79 72 69 67 68 74 20 31 39 39 38 20 62 79 20 41 4E 41 4B 69 4E 20 FE 3D 2D 20 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4}
    condition:
        $a
}

rule PEiD_01526_PE_PACK_v1_0_by_ANAKiN_1998_______
{
    meta:
        description = "[PE-PACK v1.0 by ANAKiN 1998 (???)]"
        ep_only = "true"
    strings:
        $a = {74 ?? E9 ?? ?? ?? ?? 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01527_PE_Protect_0_9_by_Cristoph_Gabler_1998_
{
    meta:
        description = "[PE-Protect 0.9 by Cristoph Gabler 1998]"
        ep_only = "false"
    strings:
        $a = {50 45 2D 50 52 4F 54 45 43 54 20 30 2E 39}
    condition:
        $a
}

rule PEiD_01528_PE_PROTECT_0_9_
{
    meta:
        description = "[PE-PROTECT 0.9]"
        ep_only = "true"
    strings:
        $a = {E9 CF 00 00 00 0D 0A 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4}
    condition:
        $a at pe.entry_point
}

rule PEiD_01529_PE_SHiELD_0_2_
{
    meta:
        description = "[PE-SHiELD 0.2]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 41 4E 41 4B 49 4E 5D 83 ED 06 EB 02 EA 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_01530_Pe123_2006_4_12_
{
    meta:
        description = "[Pe123 2006.4.12]"
        ep_only = "false"
    strings:
        $a = {8B C0 60 9C E8 01 00 00 00 C3 53 E8 72 00 00 00 50 E8 1C 03 00 00 8B D8 FF D3 5B C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B C0 55 8B EC 60 8B 4D 10 8B 7D 0C 8B 75 08 F3 A4 61 5D C2 0C 00 E8 00 00 00 00 58 83 E8 05 C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B}
    condition:
        $a
}

rule PEiD_01531_Pe123_2006_4_4_
{
    meta:
        description = "[Pe123 2006.4.4]"
        ep_only = "false"
    strings:
        $a = {8B C0 EB 01 34 60 EB 01 2A 9C EB 02 EA C8 E8 0F 00 00 00 EB 03 3D 23 23 EB 01 4A EB 01 5B C3 8D 40 00 53 EB 01 6C EB 01 7E EB 01 8F E8 15 01 00 00 50 E8 67 04 00 00 EB 01 9A 8B D8 FF D3 5B C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B C0 55 8B EC 60 8B 4D 10}
    condition:
        $a
}

rule PEiD_01532_Pe123_v2006_4_12_
{
    meta:
        description = "[Pe123 v2006.4.12]"
        ep_only = "true"
    strings:
        $a = {8B C0 60 9C E8 01 00 00 00 C3 53 E8 72 00 00 00 50 E8 1C 03 00 00 8B D8 FF D3 5B C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B C0 55 8B EC 60 8B 4D 10 8B 7D 0C 8B 75 08 F3 A4 61 5D C2 0C 00 E8 00 00 00 00 58 83 E8 05 C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B C0 E8 00 00 00 00 58 C1 E8 0C C1 E0 0C 66 81 38 4D 5A 74 0C 2D 00 10 00 00 66 81 38 4D 5A 75 F4 C3 E8 00 00 00 00 58 83 E8 05 C3 8B C0 55 8B EC 81 C4 4C FE FF FF 53 6A 40 8D 85 44 FF FF FF 50 E8 BC FF FF FF 50 E8 8A FF FF FF 68 F8 00 00 00 8D 85 4C FE FF FF 50 E8 A5 FF FF FF 03 45 80 50 E8 70 FF FF FF E8 97 FF FF FF 03 85 CC FE FF FF 83 C0 34 89 45 FC E8 86 FF FF FF 03 85 CC FE FF FF 83 C0 38 89 45 8C 60 8B 45 FC 8B 00 89 45 F8 89 45 9C 8B 45 8C 8B 00 89 45 88 89 45 98 E8 0D 00 00 00 6B 65 72 6E 65 6C 33}
    condition:
        $a at pe.entry_point
}

rule PEiD_01533_Pe123_v2006_4_4_
{
    meta:
        description = "[Pe123 v2006.4.4]"
        ep_only = "true"
    strings:
        $a = {8B C0 EB 01 34 60 EB 01 2A 9C EB 02 EA C8 E8 0F 00 00 00 EB 03 3D 23 23 EB 01 4A EB 01 5B C3 8D 40 00 53 EB 01 6C EB 01 7E EB 01 8F E8 15 01 00 00 50 E8 67 04 00 00 EB 01 9A 8B D8 FF D3 5B C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B C0 55 8B EC 60 8B 4D 10 8B 7D 0C 8B 75 08 F3 A4 61 5D C2 0C 00 E8 00 00 00 00 58 83 E8 05 C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B C0 E8 00 00 00 00 58 C1 E8 0C C1 E0 0C 66 81 38 4D 5A 74 0C 2D 00 10 00 00 66 81 38 4D 5A 75 F4 C3 E8 00 00 00 00 58 83 E8 05 C3 8B C0 55 8B EC 81 C4 B8 FE FF FF 6A 40 8D 45 B0 50 E8 C0 FF FF FF 50 E8 8E FF FF FF 68 F8 00 00 00 8D 85 B8 FE FF FF 50 E8 A9 FF FF FF 03 45 EC 50 E8 74 FF FF FF E8 9B FF FF FF 03 85 38 FF FF FF 83 C0 34 89 45 FC E8 8A FF FF FF 03 85 38 FF FF FF 83 C0 38 89 45 F4 8B 45 FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01534_PE_Admin_V1_0__EncryptPE_V1_2003_5_18_Sold_____Flying_Cat_
{
    meta:
        description = "[PE_Admin V1.0 (EncryptPE V1.2003.5.18 Sold) -> Flying Cat]"
        ep_only = "true"
    strings:
        $a = {60 9C 64 FF 35 00 00 00 00 E8 79 01 00 00 90 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01535_PEArmor_V0_7X____Hying_
{
    meta:
        description = "[PEArmor V0.7X -> Hying]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? 8D B5 ?? ?? ?? ?? 55 56 81 C5 ?? ?? ?? ?? 55 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01536_PEBundle_v0_2___v2_0x_
{
    meta:
        description = "[PEBundle v0.2 - v2.0x]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB ?? ?? 40 ?? 87 DD 6A 04 68 ?? 10 ?? ?? 68 ?? 02 ?? ?? 6A ?? FF 95}
    condition:
        $a at pe.entry_point
}

rule PEiD_01537_PEBundle_v2_0b5___v2_3_
{
    meta:
        description = "[PEBundle v2.0b5 - v2.3]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB ?? ?? 40 ?? 87 DD 01 AD ?? ?? ?? ?? 01 AD}
    condition:
        $a at pe.entry_point
}

rule PEiD_01538_PEBundle_v2_44_
{
    meta:
        description = "[PEBundle v2.44]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB ?? ?? 40 ?? 87 DD 83 BD}
    condition:
        $a at pe.entry_point
}

rule PEiD_01539_PEBundle_v3_10_
{
    meta:
        description = "[PEBundle v3.10]"
        ep_only = "false"
    strings:
        $a = {9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 20 40 00 87 DD ?? ?? ?? ?? 40 00 01}
    condition:
        $a
}

rule PEiD_01540_PECompact_2_00_alpha_38_
{
    meta:
        description = "[PECompact 2.00 alpha 38]"
        ep_only = "false"
    strings:
        $a = {B8 ?? ?? ?? ?? 80 B8 BF 10 00 10 01 74 7A C6 80 BF 10 00 10 01 9C 55 53 51 57 52 56 8D 98 0F 10 00 10 8B 53 14 8B E8 6A 40 68 00 10 00 00 FF 73 04 6A 00 8B 4B 10 03 CA 8B 01 FF D0 8B F8 50 8B 33 8B 53 14 03 F2 8B 4B 0C 03 CA 8D 85 B7 10 00 10 FF 73 04 8F}
    condition:
        $a
}

rule PEiD_01541_PECompact_2_0beta_student_version____Jeremy_Collake_
{
    meta:
        description = "[PECompact 2.0beta/student version -> Jeremy Collake]"
        ep_only = "false"
    strings:
        $a = {B8 ?? ?? ?? EE 05 12 13 13 12 50 64 FF 35 00 00 00 00 64 89 25 00}
    condition:
        $a
}

rule PEiD_01542_PeCompact_2_53_DLL__Slim_Loader_____BitSum_Technologies_
{
    meta:
        description = "[PeCompact 2.53 DLL (Slim Loader) -> BitSum Technologies]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 32 00 00 08 0C 00 48 E1 01 56 57 53 55 8B 5C 24 1C 85 DB 0F 84 AB 21 E8 BD 0E E6 60 0D 0B 6B 65 72 6E 6C 33 32}
    condition:
        $a at pe.entry_point
}

rule PEiD_01543_PeCompact_2_53_DLL____BitSum_Technologies_
{
    meta:
        description = "[PeCompact 2.53 DLL -> BitSum Technologies]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 00 00 00 08 0C 00 48 E1 01 56 57 53 55 8B 5C 24 1C 85 DB 0F 84 AB 21 E8 BD 0E E6 60 0D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01544_PECompact_2_x____Bitsum_Technologies_
{
    meta:
        description = "[PECompact 2.x -> Bitsum Technologies]"
        ep_only = "false"
    strings:
        $a = {B8 ?? ?? ?? 02 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00}
    condition:
        $a
}

rule PEiD_01545_PeCompact_2_xx__Slim_Loader_____BitSum_Technologies_
{
    meta:
        description = "[PeCompact 2.xx (Slim Loader) -> BitSum Technologies]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 32 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01546_PECompact_v0_90_
{
    meta:
        description = "[PECompact v0.90]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? 40 00 C3 9C 60 BD ?? ?? 00 00 B9 02 00 00 00 B0 90 8D BD 7A 42 40 00 F3 AA 01 AD D9 43 40 00 FF B5}
    condition:
        $a at pe.entry_point
}

rule PEiD_01547_PECompact_v0_92_
{
    meta:
        description = "[PECompact v0.92]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 BD ?? ?? ?? ?? B9 02 ?? ?? ?? B0 90 8D BD A5 4F 40 ?? F3 AA 01 AD 04 51 40 ?? FF B5}
    condition:
        $a at pe.entry_point
}

rule PEiD_01548_PECompact_v0_94_
{
    meta:
        description = "[PECompact v0.94]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 ?? ?? ?? ?? 5D 55 58 81 ED ?? ?? ?? ?? 2B 85 ?? ?? ?? ?? 01 85 ?? ?? ?? ?? 50 B9 02}
    condition:
        $a at pe.entry_point
}

rule PEiD_01549_PECompact_v0_971___v0_976_
{
    meta:
        description = "[PECompact v0.971 - v0.976]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 C3 9C 60 E8 5D 55 5B 81 ED 8B 85 01 85 66 C7 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_01550_PECompact_v0_977_
{
    meta:
        description = "[PECompact v0.977]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB A0 86 40 ?? 87 DD 8B 85 2A 87}
    condition:
        $a at pe.entry_point
}

rule PEiD_01551_PECompact_v0_978_1_
{
    meta:
        description = "[PECompact v0.978.1]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 49 87 40 ?? 87 DD 8B 85 CE 87}
    condition:
        $a at pe.entry_point
}

rule PEiD_01552_PECompact_v0_978_2_
{
    meta:
        description = "[PECompact v0.978.2]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB D1 84 40 ?? 87 DD 8B 85 56 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_01553_PECompact_v0_978_
{
    meta:
        description = "[PECompact v0.978]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 24 88 40 ?? 87 DD 8B 85 A9 88}
    condition:
        $a at pe.entry_point
}

rule PEiD_01554_PECompact_v0_98_
{
    meta:
        description = "[PECompact v0.98]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB D7 84 40 ?? 87 DD 8B 85 5C 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_01555_PECompact_v0_99_
{
    meta:
        description = "[PECompact v0.99]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 2F 85 40 ?? 87 DD 8B 85 B4 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_01556_PECompact_v1_00_
{
    meta:
        description = "[PECompact v1.00]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB C4 84 40 ?? 87 DD 8B 85 49 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_01557_PECompact_v1_10b1_
{
    meta:
        description = "[PECompact v1.10b1]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 28 63 40 ?? 87 DD 8B 85 AD 63}
    condition:
        $a at pe.entry_point
}

rule PEiD_01558_PECompact_v1_10b2_
{
    meta:
        description = "[PECompact v1.10b2]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 94 60}
    condition:
        $a at pe.entry_point
}

rule PEiD_01559_PECompact_v1_10b3_
{
    meta:
        description = "[PECompact v1.10b3]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 95 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 BB 95}
    condition:
        $a at pe.entry_point
}

rule PEiD_01560_PECompact_v1_10b4_
{
    meta:
        description = "[PECompact v1.10b4]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 95 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 BB 44}
    condition:
        $a at pe.entry_point
}

rule PEiD_01561_PECompact_v1_10b5_
{
    meta:
        description = "[PECompact v1.10b5]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 95 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 BB 49}
    condition:
        $a at pe.entry_point
}

rule PEiD_01562_PECompact_v1_10b6_
{
    meta:
        description = "[PECompact v1.10b6]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 ?? 00 87 DD 8B 85 9A 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 01 85 92 60 40 ?? BB B7}
    condition:
        $a at pe.entry_point
}

rule PEiD_01563_PECompact_v1_10b7_
{
    meta:
        description = "[PECompact v1.10b7]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 9A 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 01 85 92 60 40 ?? BB 14}
    condition:
        $a at pe.entry_point
}

rule PEiD_01564_PECompact_v1_20___v1_20_1_
{
    meta:
        description = "[PECompact v1.20 - v1.20.1]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 70 40 ?? 87 DD 8B 85 9A 70 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_01565_PECompact_v1_22_
{
    meta:
        description = "[PECompact v1.22]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 70 40 ?? 87 DD 8B 85 A6 70 40 ?? 01 85 03 70 40 ?? 66 C7 85 ?? 70 40 ?? 90 90 01 85 9E 70 40 ?? BB F3 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_01566_PECompact_v1_23b3___v1_24_1_
{
    meta:
        description = "[PECompact v1.23b3 - v1.24.1]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 70 40 ?? 87 DD 8B 85 A6 70 40 ?? 01 85 03 70 40 ?? 66 C7 85 70 40 90 ?? 90 01 85 9E 70 40 BB ?? D2 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_01567_PECompact_v1_24_2___v1_24_3_
{
    meta:
        description = "[PECompact v1.24.2 - v1.24.3]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 70 40 ?? 87 DD 8B 85 A6 70 40 ?? 01 85 03 70 40 ?? 66 C7 85 70 40 90 ?? 90 01 85 9E 70 40 BB ?? D2 09}
    condition:
        $a at pe.entry_point
}

rule PEiD_01568_PECompact_v1_25_
{
    meta:
        description = "[PECompact v1.25]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 70 40 ?? 87 DD 8B 85 A6 70 40 ?? 01 85 03 70 40 ?? 66 C7 85 70 40 90 ?? 90 01 85 9E 70 40 BB ?? F3 0D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01569_PECompact_v1_26b1___v1_26b2_
{
    meta:
        description = "[PECompact v1.26b1 - v1.26b2]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 70 40 ?? 87 DD 8B 85 A6 70 40 ?? 01 85 03 70 40 ?? 66 C7 85 70 40 90 ?? 90 01 85 9E 70 40 BB ?? 05 0E}
    condition:
        $a at pe.entry_point
}

rule PEiD_01570_PECompact_v1_33_
{
    meta:
        description = "[PECompact v1.33]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 80 40 ?? 87 DD 8B 85 A6 80 40 ?? 01 85 03 80 40 ?? 66 C7 85 00 80 40 ?? 90 90 01 85 9E 80 40 ?? BB E8 0E}
    condition:
        $a at pe.entry_point
}

rule PEiD_01571_PECompact_v1_34___v1_40b1_
{
    meta:
        description = "[PECompact v1.34 - v1.40b1]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 80 40 ?? 87 DD 8B 85 A6 80 40 ?? 01 85 03 80 40 ?? 66 C7 85 ?? 00 80 ?? 40 90 90 01 85 9E 80 ?? 40 BB F8 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_01572_PECompact_v1_40___v1_45_
{
    meta:
        description = "[PECompact v1.40 - v1.45]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB C3 11}
    condition:
        $a at pe.entry_point
}

rule PEiD_01573_PECompact_v1_40b2___v1_40b4_
{
    meta:
        description = "[PECompact v1.40b2 - v1.40b4]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 86 11}
    condition:
        $a at pe.entry_point
}

rule PEiD_01574_PECompact_v1_40b5___v1_40b6_
{
    meta:
        description = "[PECompact v1.40b5 - v1.40b6]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 8A 11}
    condition:
        $a at pe.entry_point
}

rule PEiD_01575_PECompact_v1_46_
{
    meta:
        description = "[PECompact v1.46]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 60 12}
    condition:
        $a at pe.entry_point
}

rule PEiD_01576_PECompact_v1_47___v1_50_
{
    meta:
        description = "[PECompact v1.47 - v1.50]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 5B 12}
    condition:
        $a at pe.entry_point
}

rule PEiD_01577_PECompact_v1_4x__
{
    meta:
        description = "[PECompact v1.4x+]"
        ep_only = "false"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81}
    condition:
        $a
}

rule PEiD_01578_PECompact_v1_55_
{
    meta:
        description = "[PECompact v1.55]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 80 40 ?? 87 DD 8B 85 A2 80 40 ?? 01 85 03 80 40 ?? 66 C7 85 ?? 80 40 ?? 90 90 01 85 9E 80 40 ?? BB 2D 12}
    condition:
        $a at pe.entry_point
}

rule PEiD_01579_PECompact_v1_56_
{
    meta:
        description = "[PECompact v1.56]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 90 40 ?? 87 DD 8B 85 A2 90 40 ?? 01 85 03 90 40 ?? 66 C7 85 ?? 90 40 ?? 90 90 01 85 9E 90 40 ?? BB 2D 12}
    condition:
        $a at pe.entry_point
}

rule PEiD_01580_PECompact_v1_60___v1_65_
{
    meta:
        description = "[PECompact v1.60 - v1.65]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 80 40 ?? 87 DD 8B 85 D2 80 40 ?? 01 85 33 80 40 ?? 66 C7 85 ?? 80 40 ?? 90 90 01 85 CE 80 40 ?? BB BB 12}
    condition:
        $a at pe.entry_point
}

rule PEiD_01581_PECompact_v1_66_
{
    meta:
        description = "[PECompact v1.66]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 ?? 87 DD 8B 85 E6 90 40 ?? 01 85 33 90 40 ?? 66 C7 85 ?? 90 40 ?? 90 90 01 85 DA 90 40 ?? 01 85 DE 90 40 ?? 01 85 E2 90 40 ?? BB 5B 11}
    condition:
        $a at pe.entry_point
}

rule PEiD_01582_PECompact_v1_67_
{
    meta:
        description = "[PECompact v1.67]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 87 DD 8B 85 E6 90 40 01 85 33 90 40 66 C7 85 90 40 90 90 01 85 DA 90 40 01 85 DE 90 40 01 85 E2 90 40 BB 8B 11}
    condition:
        $a at pe.entry_point
}

rule PEiD_01583_PECompact_v1_68___v1_84_
{
    meta:
        description = "[PECompact v1.68 - v1.84]"
        ep_only = "true"
    strings:
        $a = {EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 87 DD 8B 85 E6 90 40 01 85 33 90 40 66 C7 85 90 40 90 90 01 85 DA 90 40 01 85 DE 90 40 01 85 E2 90 40 BB 7B 11}
    condition:
        $a at pe.entry_point
}

rule PEiD_01584_PECompact_v1_84_
{
    meta:
        description = "[PECompact v1.84]"
        ep_only = "true"
    strings:
        $a = {33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81}
    condition:
        $a at pe.entry_point
}

rule PEiD_01585_PECompact_v2_0_beta____Jeremy_Collake_
{
    meta:
        description = "[PECompact v2.0 beta -> Jeremy Collake]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 05 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 CC 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01586_PECompact_v2_00_alpha_38_
{
    meta:
        description = "[PECompact v2.00 alpha 38]"
        ep_only = "false"
    strings:
        $a = {B8 ?? ?? ?? ?? 80 B8 BF 10 00 10 01 74 7A C6 80 BF 10 00 10 01 9C 55 53 51 57 52 56 8D 98 0F 10 00 10 8B 53 14 8B E8 6A 40 68 00 10 00 00 FF 73 04 6A 00 8B 4B 10 03 CA 8B 01 FF D0 8B F8 50 8B 33 8B 53 14 03 F2 8B 4B 0C 03 CA 8D 85 B7 10 00 10 FF 73 04 8F 00 50 57 56 FF D1 58 03 43 08 8B F8 8B 53 14 8B F0 8B 46 FC 83 C0 04 2B F0 89 56 08 8B 4B 10 89 4E 18 FF D7 89 85 BB 10 00 10 5E 5A 5F 59 5B 5D 9D FF E0 8B 80 BB 10 00 10 FF E0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01587_PeCompact_v2_08____Bitsum_Technologies_signature_by_loveboom__
{
    meta:
        description = "[PeCompact v2.08 -> Bitsum Technologies(signature by loveboom)]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01588_PECompact_v2_0_
{
    meta:
        description = "[PECompact v2.0]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01589_PECompact_v2_5_Retail__Slim_Loader_____Bitsum_Technologies_
{
    meta:
        description = "[PECompact v2.5 Retail (Slim Loader) -> Bitsum Technologies]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? 01 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 32 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01590_PECompact_v2_5_Retail____Bitsum_Technologies_
{
    meta:
        description = "[PECompact v2.5 Retail -> Bitsum Technologies]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? 01 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01591_PECompact_V2_X____Bitsum_Technologies_
{
    meta:
        description = "[PECompact V2.X -> Bitsum Technologies]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43}
    condition:
        $a at pe.entry_point
}

rule PEiD_01592_PECompact_v2_xx_
{
    meta:
        description = "[PECompact v2.xx]"
        ep_only = "false"
    strings:
        $a = {B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00}
    condition:
        $a
}

rule PEiD_01593_PeCompact2_2_53_2_76____BitSum_Technologies_
{
    meta:
        description = "[PeCompact2 2.53-2.76 -> BitSum Technologies]"
        ep_only = "false"
    strings:
        $a = {B8 ?? ?? ?? ?? 55 53 51 57 56 52 8D 98 C9 11 00 10 8B 53 18 52 8B E8 6A 40 68 00 10 00 00 FF 73 04 6A 00 8B 4B 10 03 CA 8B 01 FF D0 5A 8B F8 50 52 8B 33 8B 43 20 03 C2 8B 08 89 4B 20 8B 43 1C 03 C2 8B 08 89 4B 1C 03 F2 8B 4B 0C 03 CA 8D 43 1C 50 57 56 FF}
    condition:
        $a
}

rule PEiD_01594_PECrc32_0_88____ZhouJinYu_
{
    meta:
        description = "[PECrc32 0.88 -> ZhouJinYu]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED B6 A4 45 00 8D BD B0 A4 45 00 81 EF 82 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01595_PEcrypt___by_archphase_
{
    meta:
        description = "[PEcrypt - by archphase]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 E0 53 56 33 C0 89 45 E4 89 45 E0 89 45 EC ?? ?? ?? ?? 64 82 40 00 E8 7C C7 FF FF 33 C0 55 68 BE 84 40 00 64 FF 30 64 89 20 68 CC 84 40 00 ?? ?? ?? ?? 00 A1 10 A7 40 00 50 E8 1D C8 FF FF 8B D8 85 DB 75 39 E8 3A C8 FF FF 6A 00 6A 00 68 A0 A9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01596_PEcrypt___by_archphase_
{
    meta:
        description = "[PEcrypt - by archphase]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 E0 53 56 33 C0 89 45 E4 89 45 E0 89 45 EC ?? ?? ?? ?? 64 82 40 00 E8 7C C7 FF FF 33 C0 55 68 BE 84 40 00 64 FF 30 64 89 20 68 CC 84 40 00 ?? ?? ?? ?? 00 A1 10 A7 40 00 50 E8 1D C8 FF FF 8B D8 85 DB 75 39 E8 3A C8 FF FF 6A 00 6A 00 68 A0 A9 40 00 68 00 04 00 00 50 6A 00 68 00 13 00 00 E8 FF C7 FF FF 6A 00 68 E0 84 40 00 A1 A0 A9 40 00 50 6A 00 E8 ?? ?? ?? ?? E9 7D 01 00 00 53 A1 10 A7 40 00 50 E8 42 C8 FF FF 8B F0 85 F6 75 18 6A 00 68 E0 84 40 00 68 E4 84 40 00 6A 00 E8 71 C8 FF FF E9 53 01 00 00 53 6A 00 E8 2C C8 FF FF A3 ?? ?? ?? ?? 83 3D 48 A8 40 00 00 75 18 6A 00 68 E0 84 40 00 68 F8 84 40 00 6A 00 E8 43 C8 FF FF E9 25 01 00 00 56 E8 F8 C7 FF FF A3 4C A8 40 00 A1 48 A8 40 00 E8 91 A1 FF FF 8B D8 8B 15 48 A8 40 00 85 D2 7C 16 42 33 C0 8B 0D 4C A8 40 00 03 C8 8A 09 8D 34 18 88 0E 40 4A 75 ED 8B 15 48 A8 40 00 85 D2 7C 32 42 33 C0 8D 34 18 8A 0E 80 F9 01 75 05 C6 06 FF EB 1C 8D 0C 18 8A 09 84 ?? ?? ?? ?? ?? 00 EB 0E 8B 0D 4C A8 40 00 03 C8 0F B6 09 49 88 0E 40 4A 75 D1 8D ?? ?? ?? ?? E8 A5 A3 FF FF 8B 45 E8 8D 55 EC E8 56 D5 FF FF 8D 45 EC BA 18 85 40 00 E8 79 BA FF FF 8B 45 EC E8 39 BB FF FF 8B D0 B8 54 A8 40 00 E8 31 A6 FF FF BA 01 00 00 00 B8 54 A8 40 00 E8 12 A9 FF FF E8 DD A1 FF FF 68 50 A8 40 00 8B D3 8B 0D 48 A8 40 00 B8 54 A8 40 00 E8 56 A7 FF FF E8 C1 A1 FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01597_PEEncrypt_v4_0b__JunkCode__
{
    meta:
        description = "[PEEncrypt v4.0b (JunkCode)]"
        ep_only = "true"
    strings:
        $a = {66 ?? ?? 00 66 83 ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01598_PEiD_Bundle_v1_00___v1_01____BoB___BobSoft_
{
    meta:
        description = "[PEiD-Bundle v1.00 - v1.01 -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? 02 00 00 8B 44 24 04 52 48 66 31 C0 66 81 38 4D 5A 75 F5 8B 50 3C 81 3C 02 50 45 00 00 75 E9 5A C2 04 00 60 89 DD 89 C3 8B 45 3C 8B 54 28 78 01 EA 52 8B 52 20 01 EA 31 C9 41 8B 34 8A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01599_PEiD_Bundle_V1_00____BoB___BobSoft_
{
    meta:
        description = "[PEiD-Bundle V1.00 -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {60 E8 21 02 00 00 8B 44 24 04 52 48 66 31 C0 66 81 38 4D 5A 75 F5 8B 50 3C 81 3C 02 50 45 00 00 75 E9 5A C2 04 00 60 89 DD 89 C3 8B 45 3C 8B 54 28 78 01 EA 52 8B 52 20 01 EA 31 C9 41 8B 34 8A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01600_PEiD_Bundle_V1_01____BoB___BobSoft_
{
    meta:
        description = "[PEiD-Bundle V1.01 -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {60 E8 23 02 00 00 8B 44 24 04 52 48 66 31 C0 66 81 38 4D 5A 75 F5 8B 50 3C 81 3C 02 50 45 00 00 75 E9 5A C2 04 00 60 89 DD 89 C3 8B 45 3C 8B 54 28 78 01 EA 52 8B 52 20 01 EA 31 C9 41 8B 34 8A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01601_PEiD_Bundle_v1_02___v1_04____BoB___BobSoft_
{
    meta:
        description = "[PEiD-Bundle v1.02 - v1.04 -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 36 ?? ?? ?? 2E ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 80 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 44}
    condition:
        $a at pe.entry_point
}

rule PEiD_01602_PEiD_Bundle_V1_02____BoB___BobSoft_
{
    meta:
        description = "[PEiD-Bundle V1.02 -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {60 E8 9C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 36 ?? ?? ?? 2E ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 80 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 44}
    condition:
        $a at pe.entry_point
}

rule PEiD_01603_PEiD_Bundle_V1_02_DLL____BoB___BobSoft_
{
    meta:
        description = "[PEiD-Bundle V1.02 DLL -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 9C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 00 08 00 39 00 08 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 80 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01604_PEiD_Bundle_v1_04____BoB___BobSoft_
{
    meta:
        description = "[PEiD-Bundle v1.04 -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {60 E8 A0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 36 ?? ?? ?? 2E ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 80 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 44}
    condition:
        $a at pe.entry_point
}

rule PEiD_01605_Pelles_C_2_8_x_4_5_x____Pelle_Orinius_
{
    meta:
        description = "[Pelles C 2.8.x-4.5.x -> Pelle Orinius]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01606_Pelles_C_2_80__2_90_EXE__X86_CRT_LIB__
{
    meta:
        description = "[Pelles C 2.80 -2.90 EXE (X86 CRT-LIB)]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC ?? 83 EC ?? 53 56 57 89 65 E8 68 00 00 00 ?? E8 ?? ?? ?? ?? 59 A3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01607_Pelles_C_2_90_EXE__X86_CRT_LIB__
{
    meta:
        description = "[Pelles C 2.90 EXE (X86 CRT-LIB)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC ?? 83 EC ?? 53 56 57 89 65 E8 68 00 00 00 02 E8 ?? ?? ?? ?? 59 A3}
    condition:
        $a
}

rule PEiD_01608_Pelles_C_2_90__3_00__4_00_DLL__X86_CRT_LIB__
{
    meta:
        description = "[Pelles C 2.90, 3.00, 4.00 DLL (X86 CRT-LIB)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 53 56 57 8B 5D 0C 8B 75 10 BF 01 00 00 00 85 DB 75 10 83 3D ?? ?? ?? ?? 00 75 07 31 C0 E9 ?? ?? ?? ?? 83 FB 01 74 05 83 FB 02 75 ?? 85 FF 74}
    condition:
        $a
}

rule PEiD_01609_Pelles_C_2_x_4_x_DLL____Pelle_Orinius_
{
    meta:
        description = "[Pelles C 2.x-4.x DLL -> Pelle Orinius]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 53 56 57 8B 5D 0C 8B 75 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_01610_Pelles_C_3_00__4_00__4_50_EXE__X86_CRT_DLL__
{
    meta:
        description = "[Pelles C 3.00, 4.00, 4.50 EXE (X86 CRT-DLL)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC ?? 53 56 57 89 65 E8 C7 45 FC ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 BE ?? ?? ?? ?? EB}
    condition:
        $a
}

rule PEiD_01611_Pelles_C_3_00__4_00__4_50_EXE__X86_CRT_LIB__
{
    meta:
        description = "[Pelles C 3.00, 4.00, 4.50 EXE (X86 CRT-LIB)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC ?? 53 56 57 89 65 E8 68 00 00 00 02 E8 ?? ?? ?? ?? 59 A3}
    condition:
        $a
}

rule PEiD_01612_Pelles_C_4_50_DLL__X86_CRT_LIB__
{
    meta:
        description = "[Pelles C 4.50 DLL (X86 CRT-LIB)]"
        ep_only = "false"
    strings:
        $a = {55 89 E5 53 56 57 8B 5D 0C 8B 75 10 85 DB 75 0D 83 3D ?? ?? ?? ?? 00 75 04 31 C0 EB 57 83 FB 01 74 05 83 FB 02 75}
    condition:
        $a
}

rule PEiD_01613_PELOCKnt_2_04_
{
    meta:
        description = "[PELOCKnt 2.04]"
        ep_only = "true"
    strings:
        $a = {EB 03 CD 20 C7 1E EB 03 CD 20 EA 9C EB 02 EB 01 EB 01 EB 60}
    condition:
        $a at pe.entry_point
}

rule PEiD_01614_PEMangle_
{
    meta:
        description = "[PEMangle]"
        ep_only = "true"
    strings:
        $a = {60 9C BE ?? ?? ?? ?? 8B FE B9 ?? ?? ?? ?? BB 44 52 4F 4C AD 33 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01615_PEncrypt_1_0____JunkCode_
{
    meta:
        description = "[PEncrypt 1.0 -> JunkCode]"
        ep_only = "true"
    strings:
        $a = {60 9C BE 00 10 40 00 8B FE B9 ?? ?? ?? ?? BB 78 56 34 12 AD 33 C3 AB E2 FA 9D 61 E9 ?? ?? ?? FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01616_PEncrypt_2_0____junkcode_
{
    meta:
        description = "[PEncrypt 2.0 -> junkcode]"
        ep_only = "true"
    strings:
        $a = {EB 25 00 00 F7 BF 00 00 00 00 00 00 00 00 00 00 12 00 E8 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 00 00 E8 00 00 00 00 5D 81 ED 2C 10 40 00 8D B5 14 10 40 00 E8 33 00 00 00 89 85 10 10 40 00 BF 00 00 40 00 8B F7 03 7F 3C 8B 4F 54 51 56 8D 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_01617_PEncrypt_2_0____junkcode_
{
    meta:
        description = "[PEncrypt 2.0 -> junkcode]"
        ep_only = "true"
    strings:
        $a = {EB 25 00 00 F7 BF 00 00 00 00 00 00 00 00 00 00 12 00 E8 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 00 00 E8 00 00 00 00 5D 81 ED 2C 10 40 00 8D B5 14 10 40 00 E8 33 00 00 00 89 85 10 10 40 00 BF 00 00 40 00 8B F7 03 7F 3C 8B 4F 54 51 56 8D 85 23 10 40 00 50 6A 04 51 56 FF 95 10 10 40 00 5E 59 C6 06 00 46 E2 FA E9 AE 00 00 00 55 E8 00 00 00 00 5D 81 ED 77 10 40 00 8B D6 80 3E 00 74 03 46 EB F8 46 2B F2 8B CE 33 C0 66 89 85 06 10 40 00 8B B5 02 10 40 00 83 C6 3C 66 AD 03 85 02 10 40 00 8B 70 78 03 B5 02 10 40 00 83 C6 1C AD 03 85 02 10 40 00 89 85 08 10 40 00 AD 03 85 02 10 40 00 50 AD 03 85 02 10 40 00 89 85 0C 10 40 00 5E 56 AD 03 85 02 10 40 00 8B F0 8B FA 51 FC F3 A6 59 74 0D 5E 83 C6 04 66 FF 85 06 10 40 00 EB E0 5E 0F B7 85 06 10 40 00 D1 E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01618_PEncrypt_v1_0_
{
    meta:
        description = "[PEncrypt v1.0]"
        ep_only = "true"
    strings:
        $a = {60 9C BE 00 10 40 00 8B FE B9 28 03 00 00 BB 78 56 34 12 AD 33 C3 AB E2 FA 9D 61}
    condition:
        $a at pe.entry_point
}

rule PEiD_01619_PEncrypt_v3_0_
{
    meta:
        description = "[PEncrypt v3.0]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 5D 81 ED 05 10 40 00 8D B5 24 10 40 00 8B FE B9 0F 00 00 00 BB ?? ?? ?? ?? AD 33 C3 E2 FA}
    condition:
        $a at pe.entry_point
}

rule PEiD_01620_PEncrypt_v3_1_
{
    meta:
        description = "[PEncrypt v3.1]"
        ep_only = "true"
    strings:
        $a = {E9 ?? ?? ?? 00 F0 0F C6}
    condition:
        $a at pe.entry_point
}

rule PEiD_01621_PEnguinCrypt_v1_0_
{
    meta:
        description = "[PEnguinCrypt v1.0]"
        ep_only = "true"
    strings:
        $a = {B8 93 ?? ?? 00 55 50 67 64 FF 36 00 00 67 64 89 26 00 00 BD 4B 48 43 42 B8 04 00 00 00 CC 3C 04 75 04 90 90 C3 90 67 64 8F 06 00 00 58 5D BB 00 00 40 00 33 C9 33 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01622_PENightMare_2_Beta_
{
    meta:
        description = "[PENightMare 2 Beta]"
        ep_only = "true"
    strings:
        $a = {60 E9 ?? ?? ?? ?? EF 40 03 A7 07 8F 07 1C 37 5D 43 A7 04 B9 2C 3A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01623_PENightMare_v1_3_
{
    meta:
        description = "[PENightMare v1.3]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D B9 ?? ?? ?? ?? 80 31 15 41 81 F9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01624_PENinja_modified_
{
    meta:
        description = "[PENinja modified]"
        ep_only = "true"
    strings:
        $a = {5D 8B C5 81 ED B2 2C 40 00 2B 85 94 3E 40 00 2D 71 02 00 00 89 85 98 3E 40 00 0F B6 B5 9C 3E 40 00 8B FD}
    condition:
        $a at pe.entry_point
}

rule PEiD_01625_PENinja_
{
    meta:
        description = "[PENinja]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01626_PEQuake_0_06_by_fORGAT_
{
    meta:
        description = "[PEQuake 0.06 by fORGAT]"
        ep_only = "false"
    strings:
        $a = {E8 A5 00 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 3D ?? 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4A ?? 00 00 5B ?? 00 00 6E ?? 00 00 00 00 00 00 6B 45 72 4E 65 4C 33 32 2E 64 4C 6C 00 00 00 47 65 74 50 72 6F 63 41 64}
    condition:
        $a
}

rule PEiD_01627_PEQuake_0_06___forgat_
{
    meta:
        description = "[PEQuake 0.06-> forgat]"
        ep_only = "false"
    strings:
        $a = {E8 A5 00 00 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 3D ?? ?? 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4A ?? ?? 00 5B ?? ?? 00 6E ?? ?? 00 00 00 00 00 6B 45 72 4E 65 4C 33 32 2E 64 4C 6C 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 ?? ?? 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01628_PEQuake_V0_06____forgat_
{
    meta:
        description = "[PEQuake V0.06 -> forgat]"
        ep_only = "true"
    strings:
        $a = {E8 A5 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01629_PEQuake_v0_06____forgot_us__h__
{
    meta:
        description = "[PEQuake v0.06 -> forgot/us (h)]"
        ep_only = "true"
    strings:
        $a = {E8 A5 00 00 00 2D ?? ?? ?? 00 00 00 00 00 00 00 00 3D ?? ?? ?? 2D ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 45 72 4E 65 4C 33 32 2E 64 4C 6C 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 ?? ?? 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 5D 81 ED 05 00 00 00 8D 75 3D 56 FF 55 31 8D B5 81 00 00 00 56 50 FF 55 2D 89 85 8E 00 00 00 6A 04 68 00 10 00 00 68 ?? ?? 00 00 6A 00 FF 95 8E 00 00 00 50 8B 9D 7D 00 00 00 03 DD 50 53 E8 04 00 00 00 5A 55 FF E2 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01630_PEQuake_v0_06_by_fORGAT_
{
    meta:
        description = "[PEQuake v0.06 by fORGAT]"
        ep_only = "false"
    strings:
        $a = {E8 A5 00 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 3D ?? 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4A ?? 00 00 5B ?? 00 00 6E ?? 00 00 00 00 00 00 6B 45 72 4E 65 4C 33 32 2E 64 4C 6C 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 ?? ?? 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 5D 81 ED 05 00 00 00 8D 75 3D 56 FF 55 31 8D B5 81 00 00 00 56 50 FF 55 2D 89 85 8E 00 00 00 6A 04 68 00 10 00 00 68 ?? ?? 00 00 6A 00 FF 95 8E 00 00 00 50 8B 9D 7D 00 00 00 03 DD 50 53 E8 04 00 00 00 5A 55 FF E2 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB}
    condition:
        $a
}

rule PEiD_01631_PerlApp_6_0_2____ActiveState_
{
    meta:
        description = "[PerlApp 6.0.2 -> ActiveState]"
        ep_only = "false"
    strings:
        $a = {68 2C EA 40 00 FF D3 83 C4 0C 85 C0 0F 85 CD 00 00 00 6A 09 57 68 20 EA 40 00 FF D3 83 C4 0C 85 C0 75 12 8D 47 09 50 FF 15 1C D1 40 00 59 A3 B8 07 41 00 EB 55 6A 08 57 68 14 EA 40 00 FF D3 83 C4 0C 85 C0 75 11 8D 47 08 50 FF 15 1C D1 40 00 59 89 44 24 10 EB 33 6A 09 57 68 08 EA 40 00 FF D3 83 C4 0C 85 C0 74 22 6A 08 57 68 FC E9 40 00 FF D3 83 C4 0C 85 C0 74 11 6A 0B 57 68 F0 E9 40 00 FF D3 83 C4 0C 85 C0 75 55}
    condition:
        $a
}

rule PEiD_01632_PerlApp_6_0_2____ActiveState_
{
    meta:
        description = "[PerlApp 6.0.2 -> ActiveState]"
        ep_only = "false"
    strings:
        $a = {68 9C E1 40 00 FF 15 A4 D0 40 00 85 C0 59 74 0F 50 FF 15 1C D1 40 00 85 C0 59 89 45 FC 75 62 6A 00 8D 45 F8 FF 75 0C F6 45 14 01 50 8D 45 14 50 E8 9B 01 00 00 83 C4 10 85 C0 0F 84 E9 00 00 00 8B 45 F8 83 C0 14 50 FF D6 85 C0 59 89 45 FC 75 0E FF 75 14 FF 15 78 D0 40 00 E9 C9 00 00 00 68 8C E1 40 00 FF 75 14 50}
    condition:
        $a
}

rule PEiD_01633_PESHiELD_v0_2___v0_2b___v0_2b2_
{
    meta:
        description = "[PESHiELD v0.2 / v0.2b / v0.2b2]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 41 4E 41 4B 49 4E 5D 83 ED 06 EB 02 EA 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_01634_PESHiELD_v0_251_
{
    meta:
        description = "[PESHiELD v0.251]"
        ep_only = "true"
    strings:
        $a = {5D 83 ED 06 EB 02 EA 04 8D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01635_PESHiELD_v0_25_
{
    meta:
        description = "[PESHiELD v0.25]"
        ep_only = "true"
    strings:
        $a = {60 E8 2B 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01636_PEShit_
{
    meta:
        description = "[PEShit]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 F9 00 7E 06 80 30 ?? 40 E2 F5 E9 ?? ?? ?? FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01637_PESpin_0_1____Cyberbob__h__
{
    meta:
        description = "[PESpin 0.1 -> Cyberbob (h)]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 5C CB 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF}
    condition:
        $a
}

rule PEiD_01638_PESpin_0_3____Cyberbob__h__
{
    meta:
        description = "[PESpin 0.3 -> Cyberbob (h)]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 B7 CD 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF}
    condition:
        $a
}

rule PEiD_01639_PESpin_0_7____Cyberbob__h__
{
    meta:
        description = "[PESpin 0.7 -> Cyberbob (h)]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF}
    condition:
        $a
}

rule PEiD_01640_PESpin_1_0____Cyberbob__h__
{
    meta:
        description = "[PESpin 1.0 -> Cyberbob (h)]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 C8 DC 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF}
    condition:
        $a
}

rule PEiD_01641_PESpin_1_1____Cyberbob__h__
{
    meta:
        description = "[PESpin 1.1 -> Cyberbob (h)]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 7D DE 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF}
    condition:
        $a
}

rule PEiD_01642_PESPin_1_3____Cyberbob__h__
{
    meta:
        description = "[PESPin 1.3 -> Cyberbob (h)]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 AC DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF}
    condition:
        $a
}

rule PEiD_01643_PESpin_1_304____Cyberbob__h__
{
    meta:
        description = "[PESpin 1.304 -> Cyberbob (h)]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08}
    condition:
        $a
}

rule PEiD_01644_PESpin_1_3beta____Cyberbob__h__
{
    meta:
        description = "[PESpin 1.3beta -> Cyberbob (h)]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 71 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF}
    condition:
        $a
}

rule PEiD_01645_PESpin_1_3x____Cyberbob_
{
    meta:
        description = "[PESpin 1.3x -> Cyberbob]"
        ep_only = "true"
    strings:
        $a = {EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_01646_PESpin_v0_1____Cyberbob__h__
{
    meta:
        description = "[PESpin v0.1 -> Cyberbob (h)]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 5C CB 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 8B 95 B3 28 40 00 8B 42 3C 03 C2 89 85 BD 28 40 00 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 9D D1 28 40 00 53 8F 85 C4 27 40 00 BB ?? 00 00 00 B9 A5 08 00 00 8D BD 75 29 40 00 4F 30 1C 39 FE CB E2 F9 68 2D 01 00 00 59 8D BD AA 30 40 00 C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 07 4F 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D C4 28 40 00 8B D6 B9 10 00 00 00 AC 84 C0 74 06 C0 4E FF 03 E2 F5 E8 00 00 00 00 59 81 C1 1D 00 00 00 52 51 C1 E9 05 23 D1 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01647_PESpin_v0_3__Eng_____cyberbob_
{
    meta:
        description = "[PESpin v0.3 (Eng) -> cyberbob]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 B7 CD 46}
    condition:
        $a at pe.entry_point
}

rule PEiD_01648_PESpin_v0_3__Eng_____cyberbob_
{
    meta:
        description = "[PESpin v0.3 (Eng) -> cyberbob]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 B7 CD 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 8B 95 CB 2C 40 00 8B 42 3C 03 C2 89 85 D5 2C 40 00 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 9D E9 2C 40 00 53 8F 85 B6 2B 40 00 BB ?? 00 00 00 B9 75 0A 00 00 8D BD 7E 2D 40 00 4F 30 1C 39 FE CB E2 F9 68 3C 01 00 00 59 8D BD B6 36 40 00 C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 1F 53 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B9 08 00 00 00 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D DC 2C 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01649_PESpin_v0_3____Cyberbob__h__
{
    meta:
        description = "[PESpin v0.3 -> Cyberbob (h)]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 B7 CD 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 8B 95 CB 2C 40 00 8B 42 3C 03 C2 89 85 D5 2C 40 00 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 9D E9 2C 40 00 53 8F 85 B6 2B 40 00 BB ?? 00 00 00 B9 75 0A 00 00 8D BD 7E 2D 40 00 4F 30 1C 39 FE CB E2 F9 68 3C 01 00 00 59 8D BD B6 36 40 00 C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 1F 53 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B9 08 00 00 00 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D DC 2C 40 00 8B D6 B9 10 00 00 00 AC 84 C0 74 06 C0 4E FF 03 E2 F5 E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01650_PESpin_v0_7____Cyberbob__h__
{
    meta:
        description = "[PESpin v0.7 -> Cyberbob (h)]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 88 39 40 00 8B 42 3C 03 C2 89 85 92 39 40 00 EB 01 DB 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D A6 39 40 00 53 8F 85 4A 38 40 00 BB ?? 00 00 00 B9 EC 0A 00 00 8D BD 36 3A 40 00 4F EB 01 AB 30 1C 39 FE CB E2 F9 EB 01 C8 68 CB 00 00 00 59 8D BD 56 44 40 00 E8 03 00 00 00 EB 04 FA EB FB 68 83 04 24 0C C3 8D C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 B3 5F 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B9 08 00 00 00 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D 99 39 40 00 8B D6 B9 10 00 00 00 AC 84 C0 74 06 C0 4E FF 03 E2 F5 E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01651_PESpin_v0_7____Cyberbob_
{
    meta:
        description = "[PESpin v0.7 -> Cyberbob]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 88 39 40 00 8B 42 3C 03 C2 89 85 92 39 40 00 EB 01 DB 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D A6 39 40 00 53 8F 85 4A 38 40 00 BB ?? 00 00 00 B9 EC 0A 00 00 8D BD 36 3A 40 00 4F EB 01 AB 30 1C 39 FE CB E2 F9 EB 01 C8 68 CB 00 00 00 59 8D BD 56 44 40 00 E8 03 00 00 00 EB 04 FA EB FB 68 83 04 24 0C C3 8D C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 B3 5F 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B9 08 00 00 00 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D 99 39 40 00 8B D6 B9 10 00 00 00 AC 84 C0 74 06 C0 4E FF 03 E2 F5 E8 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01652_PESpin_V0_71____cyberbob_
{
    meta:
        description = "[PESpin V0.71 -> cyberbob]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E}
    condition:
        $a at pe.entry_point
}

rule PEiD_01653_PESpin_v1_0____Cyberbob__h__
{
    meta:
        description = "[PESpin v1.0 -> Cyberbob (h)]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 C8 DC 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 D2 42 40 00 8B 42 3C 03 C2 89 85 DC 42 40 00 EB 02 12 77 F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 9A 72 ED 1F EB 07 F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D F0 42 40 00 53 8F 85 94 41 40 00 BB ?? 00 00 00 B9 8C 0B 00 00 8D BD 80 43 40 00 4F EB 01 AB 30 1C 39 FE CB E2 F9 EB 01 C8 68 CB 00 00 00 59 8D BD 40 4E 40 00 E8 03 00 00 00 EB 04 FA EB FB 68 83 04 24 0C C3 8D C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 FD 68 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B9 08 00 00 00 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01654_PESpin_v1_1____Cyberbob__h__
{
    meta:
        description = "[PESpin v1.1 -> Cyberbob (h)]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 7D DE 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 C3 4B 40 00 8B 42 3C 03 C2 89 85 CD 4B 40 00 EB 02 12 77 F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 9A 72 ED 1F EB 07 F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D E1 4B 40 00 53 8F 85 D7 49 40 00 BB ?? 00 00 00 B9 FE 11 00 00 8D BD 71 4C 40 00 4F EB 07 FA EB 01 FF EB 04 E3 EB F8 69 30 1C 39 FE CB 49 9C C1 2C 24 06 F7 14 24 83 24 24 01 50 52 B8 83 B2 DC 12 05 44 4D 23 ED F7 64 24 08 8D 84 28 BD 2D 40 00 89 44 24 08 5A 58 8D 64 24 04 FF 64 24 FC FF EA EB 01 C8 E8 01 00 00 00 68 58 FE 48 1F 0F 84 94 02 00 00 75 01 9A 81 70 03 E8 98 68 EA 83 C0 21 80 40 FB EB A2 40 02 00 E0 91 32 68 CB 00 00 00 59 8D BD A3 5D 40 00 E8 03 00 00 00 EB 04 FA EB FB 68 83 04 24 0C C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01655_PESpin_V1_1____cyberbob_
{
    meta:
        description = "[PESpin V1.1 -> cyberbob]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 7D DE 46 00 0B E4 74 9E}
    condition:
        $a at pe.entry_point
}

rule PEiD_01656_PESpin_v1_1_by_cyberbob_
{
    meta:
        description = "[PESpin v1.1 by cyberbob]"
        ep_only = "false"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 7D DE 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 C3 4B 40 00 8B 42 3C 03 C2 89 85 CD 4B 40 00 EB 02 12 77 F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 9A 72 ED 1F EB 07 F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D E1 4B 40 00 53 8F 85 D7 49 40 00 BB ?? 00 00 00 B9 FE 11 00 00 8D BD 71 4C 40 00 4F EB 07 FA EB 01 FF EB 04 E3 EB F8 69 30 1C 39 FE CB 49 9C}
    condition:
        $a
}

rule PEiD_01657_PESPin_v1_3____Cyberbob__h__
{
    meta:
        description = "[PESPin v1.3 -> Cyberbob (h)]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 AC DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 0D 4F 40 00 8B 42 3C 03 C2 89 85 17 4F 40 00 EB 02 12 77 F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 9A 72 ED 1F EB 07 F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D 2B 4F 40 00 53 8F 85 21 4D 40 00 EB 07 FA EB 01 FF EB 04 E3 EB F8 69 8B 59 38 03 DA 8B 3B 89 BD D0 4F 40 00 8D 5B 04 8B 1B 89 9D D5 4F 40 00 E8 00 00 00 00 58 01 68 05 68 F7 65 0F E2 B8 77 CE 2F B1 35 73 CE 2F B1 03 E0 F7 D8 81 2C 04 13 37 CF E1 FF 64 24 FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01658_PESpin_v1_304____Cyberbob__h__
{
    meta:
        description = "[PESpin v1.304 -> Cyberbob (h)]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 CD 4E 40 00 8B 42 3C 03 C2 89 85 D7 4E 40 00 EB 02 12 77 F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 9A 72 ED 1F EB 07 F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D EB 4E 40 00 53 8F 85 E1 4C 40 00 EB 07 FA EB 01 FF EB 04 E3 EB F8 69 8B 59 38 03 DA 8B 3B 89 BD 90 4F 40 00 8D 5B 04 8B 1B 89 9D 95 4F 40 00 E8 00 00 00 00 58 01 68 05 68 D3 65 0F E2 B8 77 CE 2F B1 35 73 CE 2F B1 03 E0 F7 D8 81 2C 04 13 37 CF E1 FF 64 24 FC FF 25 10 BB ?? 00 00 00 B9 84 12 00 00 8D BD C6 4F 40 00 4F EB 07 FA EB 01 FF EB 04 E3 EB F8 69 30 1C 39 FE CB 49 9C EB 04 01 EB 04 CD EB FB 2B C1 2C 24 06 F7 14 24 83 24 24 01 50 52 B8 79 B2 DC 12 05 44 4D 23 ED F7 64 24 08 8D 84 28 20 2F 40 00 89 44 24 08 5A 58 8D 64 24 04 FF 64 24 FC FF EA EB EB 01 C8 E8 01 00 00 00 68 58 FE 48 1F 0F 84 94 02 00 00 75 01 9A 81 70 03 E8 98 68 EA 83 C0 21 80 40 FB EB A2 40 02 00 E0 91 32 68 CB 00 00 00 59 8D BD 7E 61 40 00 E8 03 00 00 00 EB 04 FA EB FB 68 83 04 24 0C C3 8D C0 0C 39 02 49 9C E8 03 00 00 00 EB 04 8D EB FB FF 83 04 24 0C C3 A3 C1 2C 24 06 F7 14 24 83 24 24 01 50 52 B8 61 B2 DC 12 05 44 4D 23 ED F7 64 24 08 8D 84 28 B2 2F 40 00 89 44 24 08 5A 58 8D 64 24 04 FF 64 24 FC 9A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01659_PESpin_v1_304____Cyberbob_
{
    meta:
        description = "[PESpin v1.304 -> Cyberbob]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01660_PESpin_v1_3beta____Cyberbob__h__
{
    meta:
        description = "[PESpin v1.3beta -> Cyberbob (h)]"
        ep_only = "true"
    strings:
        $a = {EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 71 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 ?? 4E 40 00 8B 42 3C 03 C2 89 85 ?? 4E 40 00 EB 02 12 77 F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 9A 72 ED 1F EB 07 F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D ?? 4E 40 00 53 8F 85 ?? 4C 40 00 EB 07 FA EB 01 FF EB 04 E3 EB F8 69 8B 59 38 03 DA 8B 3B 89 BD ?? 4F 40 00 8D 5B 04 8B 1B 89 9D ?? 4F 40 00 E8 00 00 00 00 58 01 68 05 68 BC 65 0F E2 B8 77 CE 2F B1 35 73 CE 2F B1 03 E0 F7 D8 81 2C 04 13 37 CF E1 FF 64 24 FC FF 25 10 BB ?? 00 00 00 B9 84 12 00 00 8D BD ?? 4F 40 00 4F EB 07 FA EB 01 FF EB 04 E3 EB F8 69 30 1C 39 FE CB 49 9C}
    condition:
        $a at pe.entry_point
}

rule PEiD_01661_PEStubOEP_v1_x_
{
    meta:
        description = "[PEStubOEP v1.x]"
        ep_only = "false"
    strings:
        $a = {40 48 BE 00 ?? ?? 00 40 48 60 33 C0 B8 ?? ?? ?? 00 FF E0 C3 C3}
    condition:
        $a
}

rule PEiD_01662_PeStubOEP_v1_x_
{
    meta:
        description = "[PeStubOEP v1.x]"
        ep_only = "false"
    strings:
        $a = {90 33 C9 33 D2 B8 ?? ?? ?? 00 B9 FF}
    condition:
        $a
}

rule PEiD_01663_PeStubOEP_v1_x_
{
    meta:
        description = "[PeStubOEP v1.x]"
        ep_only = "false"
    strings:
        $a = {E8 05 00 00 00 33 C0 40 48 C3 E8 05}
    condition:
        $a
}

rule PEiD_01664_Petite_1_2_____c_1998_Ian_Luck__h__
{
    meta:
        description = "[Petite 1.2 -> (c)1998 Ian Luck (h)]"
        ep_only = "true"
    strings:
        $a = {66 9C 60 E8 CA 00 00 00 03 00 04 00 05 00 06 00 07 00 08 00 09 00 0A 00 0B 00 0D 00 0F 00 11 00 13 00 17 00 1B 00 1F 00 23 00 2B 00 33 00 3B 00 43 00 53 00 63 00 73 00 83 00 A3 00 C3 00 E3 00 02 01 00 00 00 00 00 00 00 00 00 00 00 00 01 01 01 01 02 02 02 02 03 03 03 03 04 04 04 04 05 05 05 05 00 70 70 01 00 02 00 03 00 04 00 05 00 07 00 09 00 0D 00 11 00 19 00 21 00 31 00 41 00 61 00 81 00 C1 00 01 01 81 01 01 02 01 03 01 04 01 06 01 08 01 0C 01 10 01 18 01 20 01 30 01 40 01 60 00 00 00 00 01 01 02 02 03 03 04 04 05 05 06 06 07 07 08 08 09 09 0A 0A 0B 0B 0C 0C 0D 0D 10 11 12 00 08 07 09 06 0A 05 0B 04 0C 03 0D 02 0E 01 0F 58 2C 08 50 8B C8 8B D0 81 C1 ?? D2 00 00 81 C2 ?? ?? 00 00 89 20 8B E1 50 81 2C 24 00 ?? ?? ?? FF 30 50 80 04 24}
    condition:
        $a at pe.entry_point
}

rule PEiD_01665_Petite_1_2_____c_1998_Ian_Luck_
{
    meta:
        description = "[Petite 1.2 -> (c)1998 Ian Luck]"
        ep_only = "true"
    strings:
        $a = {66 9C 60 E8 CA 00 00 00 03 00 04 00 05 00 06 00 07 00 08 00 09 00 0A 00 0B 00 0D 00 0F 00 11 00 13 00 17 00 1B 00 1F 00 23 00 2B 00 33 00 3B 00 43 00 53 00 63 00 73 00 83 00 A3 00 C3 00 E3 00 02 01 00 00 00 00 00 00 00 00 00 00 00 00 01 01 01 01 02 02 02}
    condition:
        $a at pe.entry_point
}

rule PEiD_01666_Petite_1_2_
{
    meta:
        description = "[Petite 1.2]"
        ep_only = "true"
    strings:
        $a = {66 9C 60 E8 CA 00 00 00 03 00 04 00 05 00 06 00 07 00 08 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01667_Petite_1_3_____c_1998_Ian_Luck__h__
{
    meta:
        description = "[Petite 1.3 -> (c)1998 Ian Luck (h)]"
        ep_only = "true"
    strings:
        $a = {?? ?? ?? ?? ?? ?? 9C 60 50 8D 88 00 ?? ?? ?? 8D 90 ?? ?? 00 00 8B DC 8B E1 68 00 00 ?? ?? 53 50 80 04 24 08 50 80 04 24 42 50 80 04 24 61 50 80 04 24 9D 50 80 04 24 BB 83 3A 00 0F 84 DA 14 00 00 8B 44 24 18 F6 42 03 80 74 19 FD 80 72 03 80 8B F0 8B F8 03 72 04 03 7A 08 8B 0A F3 A5 83 C2 0C FC EB D4 8B 7A 08 03 F8 8B 5A 04 85 DB 74 13 52 53 57 03 02 50 E8 7B 00 00 00 85 C0 74 2E 5F 5F 58 5A 8B 4A 0C C1 F9 02 F3 AB 8B 4A 0C 83 E1 03 F3 AA 83 C2 10 EB A0 45 52 52 4F 52 21 00 43 6F 72 72 75 70 74 20 44 61 74 61 21 00 8B 64 24 24 8B 04 24 83 C4 26 8B D0 66 81 C2 6D 01 6A 10 8B D8 66 05 66 01 50 52 6A 00 8B 13 FF 14 1A 6A FF FF 93 ?? ?? 00 00 56 57 8B 7C 24 0C 8B 74 24 10 8B 4C 24 14 C1 F9 02 F3 A5 8B 4C 24 14 83 E1 03 F3 A4 5F 5E C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01668_Petite_1_3_____c_1998_Ian_Luck_
{
    meta:
        description = "[Petite 1.3 -> (c)1998 Ian Luck]"
        ep_only = "true"
    strings:
        $a = {?? ?? ?? ?? ?? ?? 9C 60 50 8D 88 00 ?? ?? ?? 8D 90 ?? ?? 00 00 8B DC 8B E1 68 00 00 ?? ?? 53 50 80 04 24 08 50 80 04 24 42 50 80 04 24 61 50 80 04 24 9D 50 80 04 24 BB 83 3A 00 0F 84 DA 14 00 00 8B 44 24 18 F6 42 03 80 74 19 FD 80 72 03 80 8B F0 8B F8 03}
    condition:
        $a at pe.entry_point
}

rule PEiD_01669_Petite_1_3_
{
    meta:
        description = "[Petite 1.3]"
        ep_only = "false"
    strings:
        $a = {66 9C 60 50 8D 88 00 F0 00 00 8D 90 04 16 00 00 8B DC 8B E1}
    condition:
        $a
}

rule PEiD_01670_Petite_1_4_____c_1998_99_Ian_Luck__h__
{
    meta:
        description = "[Petite 1.4 -> (c)1998-99 Ian Luck (h)]"
        ep_only = "true"
    strings:
        $a = {?? ?? ?? ?? ?? 66 9C 60 50 8B D8 03 00 68 54 BC 00 00 6A 00 FF 50 14 8B CC 8D A0 54 BC 00 00 50 8B C3 8D 90 ?? 16 00 00 68 00 00 ?? ?? 51 50 80 04 24 08 50 80 04 24 42 50 80 04 24 61 50 80 04 24 9D 50 80 04 24 BB 83 3A 00 0F 84 D8 14 00 00 8B 44 24 18 F6 42 03 80 74 19 FD 80 72 03 80 8B F0 8B F8 03 72 04 03 7A 08 8B 0A F3 A5 83 C2 0C FC EB D4 8B 7A 08 03 F8 8B 5A 04 85 DB 74 13 52 53 57 03 02 50 E8 79 00 00 00 85 C0 74 30 5F 5F 58 5A 8B 4A 0C C1 F9 02 33 C0 F3 AB 8B 4A 0C 83 E1 03 F3 AA 83 C2 10 EB 9E 45 52 52 4F 52 21 00 43 6F 72 72 75 70 74 20 44 61 74 61 21 00 8B 64 24 24 8B 04 24 83 C4 26 8B D0 66 81 C2 7E 01 6A 10 8B D8 66 05 77 01 50 52 6A 00 03 1B FF 13 6A FF FF 53 08 56 57 8B 7C 24 0C 8B 74 24 10 8B 4C 24 14 C1 F9 02 F3 A5 8B 4C 24 14 83 E1 03 F3 A4 5F 5E C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01671_Petite_1_4_____c_1998_99_Ian_Luck_
{
    meta:
        description = "[Petite 1.4 -> (c)1998-99 Ian Luck]"
        ep_only = "true"
    strings:
        $a = {?? ?? ?? ?? ?? 66 9C 60 50 8B D8 03 00 68 54 BC 00 00 6A 00 FF 50 14 8B CC 8D A0 54 BC 00 00 50 8B C3 8D 90 ?? 16 00 00 68 00 00 ?? ?? 51 50 80 04 24 08 50 80 04 24 42 50 80 04 24 61 50 80 04 24 9D 50 80 04 24 BB 83 3A 00 0F 84 D8 14 00 00 8B 44 24 18 F6}
    condition:
        $a at pe.entry_point
}

rule PEiD_01672_Petite_1_4_
{
    meta:
        description = "[Petite 1.4]"
        ep_only = "false"
    strings:
        $a = {66 9C 60 50 8B D8 03 00 68 54 BC 00 00 6A 00 FF 50 14 8B CC}
    condition:
        $a
}

rule PEiD_01673_Petite_2_1_
{
    meta:
        description = "[Petite 2.1]"
        ep_only = "false"
    strings:
        $a = {64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 8B D8}
    condition:
        $a
}

rule PEiD_01674_Petite_2_2_____c_1998_99_Ian_Luck__h__
{
    meta:
        description = "[Petite 2.2 -> (c)1998-99 Ian Luck (h)]"
        ep_only = "true"
    strings:
        $a = {?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 68 00 00 ?? ?? 8B 3C 24 8B 30 66 81 C7 80 07 8D 74 06 08 89 38 8B 5E 10 50 56 6A 02 68 80 08 00 00 57 6A ?? 6A 06 56 6A 04 68 80 08 00 00 57 FF D3 83 EE 08 59 F3 A5 59 66 83 C7 68 81 C6 ?? ?? 00 00 F3 A5 FF D3 58 8D 90 B8 01 00 00 8B 0A 0F BA F1 1F 73 16 8B 04 24 FD 8B F0 8B F8 03 72 04 03 7A 08 F3 A5 83 C2 0C FC EB E2 83 C2 10 8B 5A F4 85 DB 74 D8 8B 04 24 8B 7A F8 03 F8 52 8D 34 01 EB 17 58 58 58 5A 74 C4 E9 1C FF FF FF 02 D2 75 07 8A 16 83 EE FF 12 D2 C3 81 FB 00 00 01 00 73 0E 68 60 C0 FF FF 68 60 FC FF FF B6 05 EB 22 81 FB 00 00 04 00 73 0E 68 80 81 FF FF 68 80 F9 FF FF B6 07 EB 0C 68 00 83 FF FF 68 00 FB FF FF B6 08 6A 00 32 D2 4B A4 33 C9 83 FB 00 7E A4 E8 AA FF FF FF 72 17 A4 30 5F FF 4B EB ED 41 E8 9B FF FF FF 13 C9 E8 94 FF FF FF 72 F2 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01675_Petite_2_2_____c_1998_99_Ian_Luck_
{
    meta:
        description = "[Petite 2.2 -> (c)1998-99 Ian Luck]"
        ep_only = "true"
    strings:
        $a = {?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 68 00 00 ?? ?? 8B 3C 24 8B 30 66 81 C7 80 07 8D 74 06 08 89 38 8B 5E 10 50 56 6A 02 68 80 08 00 00 57 6A ?? 6A 06 56 6A 04 68 80 08 00 00 57 FF D3 83 EE 08 59 F3 A5 59 66}
    condition:
        $a at pe.entry_point
}

rule PEiD_01676_PEtite_v1_2_
{
    meta:
        description = "[PEtite v1.2]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 CA ?? ?? ?? 03 ?? 04 ?? 05 ?? 06 ?? 07 ?? 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_01677_PEtite_v1_3_
{
    meta:
        description = "[PEtite v1.3]"
        ep_only = "true"
    strings:
        $a = {?? ?? ?? ?? ?? 66 9C 60 50 8D 88 ?? F0 ?? ?? 8D 90 04 16 ?? ?? 8B DC 8B E1 68 ?? ?? ?? ?? 53 50 80 04 24 08 50 80 04 24 42}
    condition:
        $a at pe.entry_point
}

rule PEiD_01678_PEtite_v1_4_
{
    meta:
        description = "[PEtite v1.4]"
        ep_only = "true"
    strings:
        $a = {66 9C 60 50 8B D8 03 ?? 68 54 BC ?? ?? 6A ?? FF 50 14 8B CC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01679_PEtite_v1_4_
{
    meta:
        description = "[PEtite v1.4]"
        ep_only = "true"
    strings:
        $a = {?? ?? ?? ?? ?? 66 9C 60 50 8B D8 03 00 68 54 BC 00 00 6A 00 FF 50 14 8B CC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01680_Petite_v1_4_
{
    meta:
        description = "[Petite v1.4]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 66 9C 60 50 8B D8 03 00 68 ?? ?? ?? ?? 6A 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01681_PEtite_v2_0_
{
    meta:
        description = "[PEtite v2.0]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 66 9C 60 50 8B D8 03 ?? 68 54 BC ?? ?? 6A ?? FF 50 18 8B CC 8D A0 54 BC ?? ?? 8B C3 8D 90 E0 15 ?? ?? 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_01682_Petite_v2_1__1__
{
    meta:
        description = "[Petite v2.1 (1)]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 ?? ?? ?? ?? ?? ?? 64 ?? ?? ?? ?? ?? ?? 66 9C 60 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_01683_Petite_v2_1__2__
{
    meta:
        description = "[Petite v2.1 (2)]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 64 ?? ?? ?? ?? ?? ?? 64 ?? ?? ?? ?? ?? ?? 66 9C 60 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_01684_PEtite_v2_1_
{
    meta:
        description = "[PEtite v2.1]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 66 9C 60 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_01685_Petite_v2_2____www_un4seen_com_petite_
{
    meta:
        description = "[Petite v2.2 -> www.un4seen.com/petite]"
        ep_only = "false"
    strings:
        $a = {B8 00 ?0 4? 00 6? 00 ?? ?? 0? ?? ?? ?? ?? ?? 00 00}
    condition:
        $a
}

rule PEiD_01686_Petite_v2_2____www_un4seen_com_petite_
{
    meta:
        description = "[Petite v2.2 -> www.un4seen.com/petite]"
        ep_only = "true"
    strings:
        $a = {B8 00 ?? ?? 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01687_PEtite_v2_2____www_un4seen_com_petite_
{
    meta:
        description = "[PEtite v2.2 -> www.un4seen.com/petite]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 66 9C 60 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_01688_Petite_v_____after_v1_4__
{
    meta:
        description = "[Petite v?.? (after v1.4)]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 66 9C 60 50 8D ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_01689_PEtite_vx_x_
{
    meta:
        description = "[PEtite vx.x]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 66 9C 60 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_01690_PeX_0_99__Eng_____bart_CrackPl_
{
    meta:
        description = "[PeX 0.99 (Eng) -> bart/CrackPl]"
        ep_only = "false"
    strings:
        $a = {E9 F5 00 00 00 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4}
    condition:
        $a
}

rule PEiD_01691_PeX_0_99____bart_CrackPl_
{
    meta:
        description = "[PeX 0.99 -> bart^CrackPl]"
        ep_only = "true"
    strings:
        $a = {E9 F5 ?? ?? ?? 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4}
    condition:
        $a at pe.entry_point
}

rule PEiD_01692_PeX_v0_99__Eng_____bart_CrackPl_
{
    meta:
        description = "[PeX v0.99 (Eng) -> bart/CrackPl]"
        ep_only = "true"
    strings:
        $a = {E9 F5 00 00 00 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 20 50 65 58 20 28 63 29 20 62 79 20 62 61 72 74 5E 43 72 61 63 6B 50 6C 20 62 65 74 61 20 72 65 6C 65 61 73 65 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 60 E8 01 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01693_pex_V0_99____params_
{
    meta:
        description = "[pex V0.99 -> params]"
        ep_only = "true"
    strings:
        $a = {E9 F5 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01694_PEX_v0_99_
{
    meta:
        description = "[PEX v0.99]"
        ep_only = "true"
    strings:
        $a = {60 E8 01 ?? ?? ?? ?? 83 C4 04 E8 01 ?? ?? ?? ?? 5D 81}
    condition:
        $a at pe.entry_point
}

rule PEiD_01695_PEZip_1_0_by_BaGIE_
{
    meta:
        description = "[PEZip 1.0 by BaGIE]"
        ep_only = "false"
    strings:
        $a = {D9 D0 F8 74 02 23 DB F5 F5 50 51 52 53 8D 44 24 10 50 55 56 57 D9 D0 22 C9 C1 F7 A0 55 66 C1 C8 B0 5D 81 E6 FF FF FF FF F8 77 07 52 76 03 72 01 90 5A C1 E0 60 90 BD 1F 01 00 00 87 E8 E2 07 E3 05 17 5D 47 E4 42 41 7F 06 50 66 83 EE 00 58 25 FF FF FF FF 51}
    condition:
        $a
}

rule PEiD_01696_PEZip_v1_0_by_BaGIE_
{
    meta:
        description = "[PEZip v1.0 by BaGIE]"
        ep_only = "false"
    strings:
        $a = {D9 D0 F8 74 02 23 DB F5 F5 50 51 52 53 8D 44 24 10 50 55 56 57 D9 D0 22 C9 C1 F7 A0 55 66 C1 C8 B0 5D 81 E6 FF FF FF FF F8 77 07 52 76 03 72 01 90 5A C1 E0 60 90 BD 1F 01 00 00 87 E8 E2 07 E3 05 17 5D 47 E4 42 41 7F 06 50 66 83 EE 00 58 25 FF FF FF FF 51 0F B6 C9 66 83 F6 00 3D CB 60 47 92 50 40 58 FC E2 EE 59 F8 7C 08 53 74 04 78 02 84 C9 5B 66 0B ED F8 F5 BA 9F FA FF FF 52 57 77 04 78 02 84 E4 5F 5A 50 80 EF 00 58 50 81 E0 FF FF FF FF 58 3C EF FC 7A 05 3D DF DA AC D1 05 00 00 00 00 73 05 71 03 7E 01 90 EB 02 EB 05 E8 F9 FF FF FF 83 C0 00 7B 06 53 66 BB 74 EF 5B F8 8B 3C 24 83 C4 04 51 0F B6 C9 66 C1 C7 30 0B D2 53 66 83 FD F6 5B 55 6A 97 83 C4 04 5D E2 E8 59 53 55 51 66 83 E9 00 59 5D 5B F8 01 FA 22 C9 7A 02 8D 3F 79 08 71 06 52 66 A9 6E E3 5A 51 0F B6}
    condition:
        $a
}

rule PEiD_01697_PGMPACK_v0_13_
{
    meta:
        description = "[PGMPACK v0.13]"
        ep_only = "true"
    strings:
        $a = {FA 1E 17 50 B4 30 CD 21 3C 02 73 ?? B4 4C CD 21 FC BE ?? ?? BF ?? ?? E8 ?? ?? E8 ?? ?? BB ?? ?? BA ?? ?? 8A C3 8B F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01698_PGMPACK_v0_14_
{
    meta:
        description = "[PGMPACK v0.14]"
        ep_only = "true"
    strings:
        $a = {1E 17 50 B4 30 CD 21 3C 02 73 ?? B4 4C CD 21 FC BE ?? ?? BF ?? ?? E8 ?? ?? E8 ?? ?? BB ?? ?? BA ?? ?? 8A C3 8B F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01699_Phoenix_Protector_v1_0_v1_1____NTCore_com_
{
    meta:
        description = "[Phoenix Protector v1.0/v1.1 -> NTCore.com]"
        ep_only = "true"
    strings:
        $a = {02 6F ?? ?? ?? 0A 0A 06 8D ?? ?? ?? 01 0B 16 0C 38 36 00 00 00 02 08 6F ?? ?? ?? 0A 0D 09 06 08 59 61 D2 13 04 09 1E 63 08 61 D2 13 05 07 08 11 05 1E 62 11 04 60 D1 9D 08 17 58 0C 08 07 8E 69 38 0B 00 00 00 28 ?? ?? ?? 0A 2A 38 EC FF FF FF 3F C0 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01700_Phonebook_configuration_file_Version__v3__v4_
{
    meta:
        description = "[Phonebook configuration file Version %v3.%v4]"
        ep_only = "false"
    strings:
        $a = {50 68 6F 6E 65 62 6F 6F 6B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 63 6F}
    condition:
        $a
}

rule PEiD_01701_Pi_Cryptor_1_0___by_Scofield_
{
    meta:
        description = "[Pi Cryptor 1.0 - by Scofield]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 EC 53 56 57 31 C0 89 45 EC B8 40 1E 06 00 E8 48 FA FF FF 33 C0 55 68 36 1F 06 00 64 FF 30 64 89 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 31 C0 E8 4E F4 FF FF 8B 45 EC E8 F6 F7 FF FF 50 E8 CC FA FF FF 8B D8 83 FB FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01702_Pi_Cryptor_1_0___by_Scofield_
{
    meta:
        description = "[Pi Cryptor 1.0 - by Scofield]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 EC 53 56 57 31 C0 89 45 EC B8 40 1E 06 00 E8 48 FA FF FF 33 C0 55 68 36 1F 06 00 64 FF 30 64 89 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 31 C0 E8 4E F4 FF FF 8B 45 EC E8 F6 F7 FF FF 50 E8 CC FA FF FF 8B D8 83 FB FF 74 4E 6A 00 53 E8 CD FA FF FF 8B F8 81 EF AC 26 00 00 6A 00 6A 00 68 AC 26 00 00 53 E8 DE FA FF FF 89 F8 E8 E3 F1 FF FF 89 C6 6A 00 68 28 31 06 00 57 56 53 E8 AE FA FF FF 53 E8 80 FA FF FF 89 FA 81 EA 72 01 00 00 8B C6 E8 55 FE FF FF 89 C6 89 F0 09 C0 74 05 E8 A8 FB FF FF 31 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01703_Pi_Cryptor_1_0___by_Scofield_
{
    meta:
        description = "[Pi Cryptor 1.0 - by Scofield]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 EC 53 56 57 31 C0 89 45 EC B8 40 1E 06 00 E8 48 FA FF FF 33 C0 55 68 36 1F 06 00 64 FF 30 64 89 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 31 C0 E8 4E F4 FF FF 8B 45 EC E8 F6 F7 FF FF 50 E8 CC FA FF FF 8B D8 83 FB FF 74 4E 6A 00 53 E8 CD FA FF FF 8B F8 81 EF AC 26 00 00 6A 00 6A 00 68 AC 26 00 00 53 E8 DE FA FF FF 89 F8 E8 E3 F1 FF FF 89 C6 6A 00 68 28 31 06 00 57 56 53 E8 AE FA FF FF 53 E8 80 FA FF FF 89 FA 81 EA 72 01 00 00 8B C6 E8 55 FE FF FF 89 C6 89 F0 09 C0 74 05 E8 A8 FB FF FF 31 C0 5A 59 59 64 89 10 68 3D 1F 06 00 8D 45 EC E8 C3 F6 FF FF C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01704_Pi_Cryptor_1_0___by_Scofield_
{
    meta:
        description = "[Pi Cryptor 1.0 - by Scofield]"
        ep_only = "false"
    strings:
        $a = {89 55 F8 BB 01 00 00 00 8A 04 1F 24 0F 8B 55 FC 8A 14 32 80 E2 0F 32 C2 8A 14 1F 80 E2 F0 02 D0 88 14 1F 46 8D 45 F4 8B 55 FC E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 3B F0 7E 05 BE 01 00 00 00 43 FF 4D F8 75 C2 ?? ?? ?? ?? 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9}
    condition:
        $a
}

rule PEiD_01705_PIRIT_v1_5_
{
    meta:
        description = "[PIRIT v1.5]"
        ep_only = "true"
    strings:
        $a = {B4 4D CD 21 E8 ?? ?? FD E8 ?? ?? B4 51 CD 21}
    condition:
        $a at pe.entry_point
}

rule PEiD_01706_PKLITE_v1_00__v1_03_
{
    meta:
        description = "[PKLITE v1.00, v1.03]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? BA ?? ?? 8C DB 03 D8 3B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01707_PKLITE_v1_00c__1__
{
    meta:
        description = "[PKLITE v1.00c (1)]"
        ep_only = "true"
    strings:
        $a = {2E 8C 1E ?? ?? 8B 1E ?? ?? 8C DA 81 C2 ?? ?? 3B DA 72 ?? 81 EB ?? ?? 83 EB ?? FA 8E D3 BC ?? ?? FB FD BE ?? ?? 8B FE}
    condition:
        $a at pe.entry_point
}

rule PEiD_01708_PKLITE_v1_00c__2__
{
    meta:
        description = "[PKLITE v1.00c (2)]"
        ep_only = "true"
    strings:
        $a = {BA ?? ?? A1 ?? ?? 2D ?? ?? 8C CB 81 C3 ?? ?? 3B C3 77 ?? 05 ?? ?? 3B C3 77 ?? B4 09 BA ?? ?? CD 21 CD 20 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01709_PKLITE_v1_12__v1_15__v1_20__1__
{
    meta:
        description = "[PKLITE v1.12, v1.15, v1.20 (1)]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 73 ?? 2D ?? ?? FA 8E D0 FB 2D ?? ?? 8E C0 50 B9 ?? ?? 33 FF 57 BE ?? ?? FC F3 A5 CB B4 09 BA ?? ?? CD 21 CD 20}
    condition:
        $a at pe.entry_point
}

rule PEiD_01710_PKLITE_v1_12__v1_15__v1_20__2__
{
    meta:
        description = "[PKLITE v1.12, v1.15, v1.20 (2)]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? BA ?? ?? 3B C4 73}
    condition:
        $a at pe.entry_point
}

rule PEiD_01711_PKLITE_v1_14__v1_15__v1_20__3__
{
    meta:
        description = "[PKLITE v1.14, v1.15, v1.20 (3)]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? BA ?? ?? 05 ?? ?? 3B ?? ?? ?? 72 ?? B4 09 BA ?? 01 CD 21 CD 20 4E 6F}
    condition:
        $a at pe.entry_point
}

rule PEiD_01712_PKLITE_v1_14__v1_20_
{
    meta:
        description = "[PKLITE v1.14, v1.20]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 72 ?? B4 09 BA ?? ?? CD 21 CD 20}
    condition:
        $a at pe.entry_point
}

rule PEiD_01713_PKLITE_v1_20_
{
    meta:
        description = "[PKLITE v1.20]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 72 ?? B4 09 BA ?? ?? CD 21 B4 4C CD 21}
    condition:
        $a at pe.entry_point
}

rule PEiD_01714_PKLITE_v1_50__1__
{
    meta:
        description = "[PKLITE v1.50 (1)]"
        ep_only = "true"
    strings:
        $a = {50 B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 72 ?? B4 ?? BA ?? ?? CD 21 B8 ?? ?? CD 21}
    condition:
        $a at pe.entry_point
}

rule PEiD_01715_PKLITE_v1_50__Device_driver_compression__
{
    meta:
        description = "[PKLITE v1.50 (Device driver compression)]"
        ep_only = "true"
    strings:
        $a = {B4 09 BA 14 01 CD 21 B8 00 4C CD 21 F8 9C 50 53 51 52 56 57 55 1E 06 BB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01716_PKLITE_v2_00c_
{
    meta:
        description = "[PKLITE v2.00c]"
        ep_only = "true"
    strings:
        $a = {50 B8 ?? ?? BA ?? ?? 3B C4 73 ?? 8B C4 2D ?? ?? 25 ?? ?? 8B F8 B9 ?? ?? BE ?? ?? FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01717_PKLITE32_1_1____PKWARE_Inc__
{
    meta:
        description = "[PKLITE32 1.1 -> PKWARE Inc.]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 00 00 00 00 E8 ?? ?? ?? ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01718_PKLITE32_1_1_
{
    meta:
        description = "[PKLITE32 1.1]"
        ep_only = "true"
    strings:
        $a = {50 4B 4C 49 54 45 33 32 20 43 6F 70 79 72 69 67 68 74 20 31}
    condition:
        $a at pe.entry_point
}

rule PEiD_01719_PKLITE32_v1_1_
{
    meta:
        description = "[PKLITE32 v1.1]"
        ep_only = "true"
    strings:
        $a = {55 8B EC A1 ?? ?? ?? ?? 85 C0 74 09 B8 01 00 00 00 5D C2 0C 00 8B 45 0C 57 56 53 8B 5D 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_01720_PKLITE32_v1_1_
{
    meta:
        description = "[PKLITE32 v1.1]"
        ep_only = "false"
    strings:
        $a = {55 8B EC A1 ?? ?? ?? ?? 85 C0 74 09 B8 01 ?? ?? ?? 5D C2 0C ?? 8B 45 0C 57 56 53 8B 5D 10}
    condition:
        $a
}

rule PEiD_01721_PKLITE32_v1_1_
{
    meta:
        description = "[PKLITE32 v1.1]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 00 00 00 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01722_PKLITE32_v1_1_
{
    meta:
        description = "[PKLITE32 v1.1]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? 2B 44 24 0C 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_01723_Pksmart_1_0b_
{
    meta:
        description = "[Pksmart 1.0b]"
        ep_only = "true"
    strings:
        $a = {BA ?? ?? 8C C8 8B C8 03 C2 81 ?? ?? ?? 51 B9 ?? ?? 51 1E 8C D3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01724_PKTINY_v1_0_with_TINYPROG_v3_8_
{
    meta:
        description = "[PKTINY v1.0 with TINYPROG v3.8]"
        ep_only = "true"
    strings:
        $a = {2E C6 06 ?? ?? ?? 2E C6 06 ?? ?? ?? 2E C6 06 ?? ?? ?? E9 ?? ?? E8 ?? ?? 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_01725_PKZIP_SFX_v1_1_1989_90_
{
    meta:
        description = "[PKZIP-SFX v1.1 1989-90]"
        ep_only = "true"
    strings:
        $a = {FC 2E 8C 0E ?? ?? A1 ?? ?? 8C CB 81 C3 ?? ?? 3B C3 72 ?? 2D ?? ?? 2D ?? ?? FA BC ?? ?? 8E D0 FB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01726_PLINK86_1984__1985_
{
    meta:
        description = "[PLINK86 1984, 1985]"
        ep_only = "true"
    strings:
        $a = {FA 8C C7 8C D6 8B CC BA ?? ?? 8E C2 26}
    condition:
        $a at pe.entry_point
}

rule PEiD_01727_PluginToExe_v1_00____BoB___BobSoft_
{
    meta:
        description = "[PluginToExe v1.00 -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 29 C0 5D 81 ED D1 40 40 00 50 FF 95 B8 40 40 00 89 85 09 40 40 00 FF 95 B4 40 40 00 89 85 11 40 40 00 50 FF 95 C0 40 40 00 8A 08 80 F9 22 75 07 50 FF 95 C4 40 40 00 89 85 0D 40 40 00 8B 9D 09 40 40 00 60 6A 00 6A 01 53 81 C3 ?? ?? ?? 00 FF D3 61 6A 00 68 44 69 45 50 FF B5 0D 40 40 00 6A 00 81 C3 ?? ?? ?? 00 FF D3 83 C4 10 FF 95 B0 40 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01728_PluginToExe_v1_01____BoB___BobSoft_
{
    meta:
        description = "[PluginToExe v1.01 -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 29 C0 5D 81 ED C6 41 40 00 50 8F 85 71 40 40 00 50 FF 95 A5 41 40 00 89 85 6D 40 40 00 FF 95 A1 41 40 00 50 FF 95 B5 41 40 00 80 38 00 74 16 8A 08 80 F9 22 75 07 50 FF 95 B9 41 40 00 89 85 75 40 40 00 EB 6C 6A 01 8F 85 71 40 40 00 6A 58 6A 40 FF 95 A9 41 40 00 89 85 69 40 40 00 89 C7 68 00 08 00 00 6A 40 FF 95 A9 41 40 00 89 47 1C C7 07 58 00 00 00 C7 47 20 00 08 00 00 C7 47 18 01 00 00 00 C7 47 34 04 10 88 00 8D 8D B9 40 40 00 89 4F 0C 8D 8D DB 40 40 00 89 4F 30 FF B5 69 40 40 00 FF 95 95 41 40 00 FF 77 1C 8F 85 75 40 40 00 8B 9D 6D 40 40 00 60 6A 00 6A 01 53 81 C3 ?? ?? ?? 00 FF D3 61 6A 00 68 44 69 45 50 FF B5 75 40 40 00 6A 00 81 C3 ?? ?? 00 00 FF D3 83 C4 10 83 BD 71 40 40 00 00 74 10 FF 77 1C FF 95 AD 41 40 00 57 FF 95 AD 41 40 00 6A 00 FF 95 9D 41 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01729_PluginToExe_v1_02____BoB___BobSoft_
{
    meta:
        description = "[PluginToExe v1.02 -> BoB / BobSoft]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 29 C0 5D 81 ED 32 42 40 00 50 8F 85 DD 40 40 00 50 FF 95 11 42 40 00 89 85 D9 40 40 00 FF 95 0D 42 40 00 50 FF 95 21 42 40 00 80 38 00 74 16 8A 08 80 F9 22 75 07 50 FF 95 25 42 40 00 89 85 E1 40 40 00 EB 6C 6A 01 8F 85 DD 40 40 00 6A 58 6A 40 FF 95 15 42 40 00 89 85 D5 40 40 00 89 C7 68 00 08 00 00 6A 40 FF 95 15 42 40 00 89 47 1C C7 07 58 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01730_PMODE_W_v_1_12__1_16__1_21__1_33_DOS_extender_
{
    meta:
        description = "[PMODE/W v.1.12, 1.16, 1.21, 1.33 DOS extender]"
        ep_only = "true"
    strings:
        $a = {FC 16 07 BF ?? ?? 8B F7 57 B9 ?? ?? F3 A5 06 1E 07 1F 5F BE ?? ?? 06 0E A4}
    condition:
        $a at pe.entry_point
}

rule PEiD_01731_PocketPC_ARM__h__
{
    meta:
        description = "[PocketPC ARM (h)]"
        ep_only = "true"
    strings:
        $a = {F0 41 2D E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A0 E1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 50 E3 ?? 00 00 0A ?? ?? ?? ?? ?? ?? A0 ?? ?? ?? ?? ?? ?? ?? A0 ?? ?? ?? A0 E1 00 80 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A0 E1}
    condition:
        $a at pe.entry_point
}

rule PEiD_01732_PocketPC_ARM_
{
    meta:
        description = "[PocketPC ARM]"
        ep_only = "true"
    strings:
        $a = {F0 40 2D E9 00 40 A0 E1 01 50 A0 E1 02 60 A0 E1 03 70 A0 E1 ?? 00 00 EB 07 30 A0 E1 06 20 A0 E1 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? EB F0 40 BD E8 ?? 00 00 EA ?? 40 2D E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01733_PocketPC_ARM_
{
    meta:
        description = "[PocketPC ARM]"
        ep_only = "true"
    strings:
        $a = {F0 40 2D E9 00 40 A0 E1 01 50 A0 E1 02 60 A0 E1 03 70 A0 E1 ?? 00 00 EB 07 30 A0 E1 06 20 A0 E1 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? EB F0 40 BD E8 ?? 00 00 EA ?? 40 2D E9 ?? ?? 9F E5 ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? 9F E5 00 ?? ?? ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01734_PocketPC_MIB_
{
    meta:
        description = "[PocketPC MIB]"
        ep_only = "true"
    strings:
        $a = {E8 FF BD 27 14 00 BF AF 18 00 A4 AF 1C 00 A5 AF 20 00 A6 AF 24 00 A7 AF ?? ?? ?? 0C 00 00 00 00 18 00 A4 8F 1C 00 A5 8F 20 00 A6 8F ?? ?? ?? 0C 24 00 A7 8F ?? ?? ?? 0C 25 20 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 ?? FF BD 27 18 00 ?? AF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01735_PocketPC_MIB_
{
    meta:
        description = "[PocketPC MIB]"
        ep_only = "true"
    strings:
        $a = {E8 FF BD 27 14 00 BF AF 18 00 A4 AF 1C 00 A5 AF 20 00 A6 AF 24 00 A7 AF ?? ?? ?? 0C 00 00 00 00 18 00 A4 8F 1C 00 A5 8F 20 00 A6 8F ?? ?? ?? 0C 24 00 A7 8F ?? ?? ?? 0C 25 20 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 ?? FF BD 27 18 00 ?? AF ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01736_PocketPC_SHA_
{
    meta:
        description = "[PocketPC SHA]"
        ep_only = "true"
    strings:
        $a = {86 2F 96 2F A6 2F B6 2F 22 4F 43 68 53 6B 63 6A 73 69 F0 7F 0B D0 0B 40 09 00 09 D0 B3 65 A3 66 93 67 0B 40 83 64 03 64 04 D0 0B 40 09 00 10 7F 26 4F F6 6B F6 6A F6 69 0B 00 F6 68 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 22 4F F0 7F 0A D0 06 D4 06 D5 0B 40 09}
    condition:
        $a at pe.entry_point
}

rule PEiD_01737_Pohernah_1_0_0___by_Kas_
{
    meta:
        description = "[Pohernah 1.0.0 - by Kas]"
        ep_only = "true"
    strings:
        $a = {58 60 E8 00 00 00 00 5D 81 ED 20 25 40 00 8B BD 86 25 40 00 8B 8D 8E 25 40 00 6B C0 05 83 F0 04 89 85 92 25 40 00 83 F9 00 74 2D 81 7F 1C AB 00 00 00 75 1E 8B 77 0C 03 B5 8A 25 40 00 31 C0 3B 47 10 74 0E 50 8B 85 92 25 40 00 30 06 58 40 46 EB ED 83 C7 28}
    condition:
        $a at pe.entry_point
}

rule PEiD_01738_Pohernah_1_0_0___by_Kas_
{
    meta:
        description = "[Pohernah 1.0.0 - by Kas]"
        ep_only = "true"
    strings:
        $a = {58 60 E8 00 00 00 00 5D 81 ED 20 25 40 00 8B BD 86 25 40 00 8B 8D 8E 25 40 00 6B C0 05 83 F0 04 89 85 92 25 40 00 83 F9 00 74 2D 81 7F 1C AB 00 00 00 75 1E 8B 77 0C 03 B5 8A 25 40 00 31 C0 3B 47 10 74 0E 50 8B 85 92 25 40 00 30 06 58 40 46 EB ED 83 C7 28 49 EB CE 8B 85 82 25 40 00 89 44 24 1C 61 FF E0}
    condition:
        $a at pe.entry_point
}

rule PEiD_01739_Pohernah_1_0_1___by_Kas_
{
    meta:
        description = "[Pohernah 1.0.1 - by Kas]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED F1 26 40 00 8B BD 18 28 40 00 8B 8D 20 28 40 00 B8 38 28 40 00 01 E8 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 1C 28 40 00 31 C0 51 31 C9 66 B9 FA 00 66 83 F9 00 74 49 8B 57 0C 03 95 1C 28 40 00 8B 85 24 28 40 00 83 F8 02 75 06 81 C2 00 02 00 00 51 8B 4F 10 83 F8 02 75 06 81 E9 00 02 00 00 57 BF C8 00 00 00 89 CE E8 27 00 00 00 89 C1 5F B8 38 28 40 00 01 E8 E8 24 00 00 00 59 49 EB B1 59 83 C7 28 49 EB 8A 8B 85 14 28 40 00 89 44 24 1C 61 FF E0 56 57 4F F7 D7 21 FE 89 F0 5F 5E C3 60 83 F0 05 40 90 48 83 F0 05 89 C6 89 D7 60 E8 0B 00 00 00 61 83 C7 08 83 E9 07 E2 F1 61 C3 57 8B 1F 8B 4F 04 68 B9 79 37 9E 5A 42 89 D0 48 C1 E0 05 BF 20 00 00 00 4A 89 DD C1 E5 04 29 E9 8B 6E 08 31 DD 29 E9 89 DD C1 ED 05 31 C5 29 E9 2B 4E 0C 89 CD C1 E5 04 29 EB 8B 2E 31 CD 29 EB 89 CD C1 ED 05 31 C5 29 EB 2B 5E 04 29 D0 4F 75 C8 5F 89 1F 89 4F 04 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01740_Pohernah_1_0_2___by_Kas_
{
    meta:
        description = "[Pohernah 1.0.2 - by Kas]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED DE 26 40 00 8B BD 05 28 40 00 8B 8D 0D 28 40 00 B8 25 28 40 00 01 E8 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 09 28 40 00 31 C0 51 31 C9 66 B9 F7 00 66 83 F9 00 74 49 8B 57 0C 03 95 09 28 40 00 8B 85 11 28 40 00 83 F8 02 75 06 81 C2 00 02 00 00 51 8B 4F 10 83 F8 02 75 06 81 E9 00 02 00 00 57 BF C8 00 00 00 89 CE E8 27 00 00 00 89 C1 5F B8 25 28 40 00 01 E8 E8 24 00 00 00 59 49 EB B1 59 83 C7 28 49 EB 8A 8B 85 01 28 40 00 89 44 24 1C 61 FF E0 56 57 4F F7 D7 21 FE 89 F0 5F 5E C3 60 83 F0 05 40 90 48 83 F0 05 89 C6 89 D7 60 E8 0B 00 00 00 61 83 C7 08 83 E9 07 E2 F1 61 C3 57 8B 1F 8B 4F 04 68 B9 79 37 9E 5A 42 89 D0 48 C1 E0 05 BF 20 00 00 00 4A 89 DD C1 E5 04 29 E9 8B 6E 08 31 DD 29 E9 89 DD C1 ED 05 31 C5 29 E9 2B 4E 0C 89 CD C1 E5 04 29 EB 8B 2E 31 CD 29 EB 89 CD C1 ED 05 31 C5 29 EB 2B 5E 04 29 D0 4F 75 C8 5F 89 1F 89 4F 04 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01741_Pohernah_1_0_3___by_Kas_
{
    meta:
        description = "[Pohernah 1.0.3 - by Kas]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 2A 27 40 00 31 C0 40 83 F0 06 40 3D 40 1F 00 00 75 07 BE 6A 27 40 00 EB 02 EB EB 8B 85 9E 28 40 00 83 F8 01 75 17 31 C0 01 EE 3D 99 00 00 00 74 0C 8B 8D 86 28 40 00 30 0E 40 46 EB ED}
    condition:
        $a at pe.entry_point
}

rule PEiD_01742_Pohernah_Crypter_V1_0_1____Kas_
{
    meta:
        description = "[Pohernah Crypter V1.0.1 -> Kas]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED F1 26 40 00 8B BD 18 28 40 00 8B 8D 20 28 40 00 B8 38 28 40 00 01 E8 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 1C 28 40 00 31 C0 51 31 C9 66 B9 FA 00 66 83 F9 00 74 49 8B 57 0C 03 95 1C 28 40 00 8B 85 24}
    condition:
        $a at pe.entry_point
}

rule PEiD_01743_Pohernah_Crypter_V1_0_2____Kas_
{
    meta:
        description = "[Pohernah Crypter V1.0.2 -> Kas]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED DE 26 40 00 8B BD 05 28 40 00 8B 8D 0D 28 40 00 B8 25 28 40 00 01 E8 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 09 28 40 00 31 C0 51 31 C9 66 B9 F7 00 66 83 F9 00 74 49 8B 57 0C 03 95 09 28 40 00 8B 85 11}
    condition:
        $a at pe.entry_point
}

rule PEiD_01744_PolyBox_C____Anskya_
{
    meta:
        description = "[PolyBox C -> Anskya]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 56 B8 E4 41 00 10 E8 3A E1 FF FF 33 C0 55 68 11 44 00 10 64 FF 30 64 89 20 EB 08 FC FC FC FC FC FC 27 54 6A 0A 68 20 44 00 10 A1 1C 71 00 10 50 E8 CC E1 ?? ?? ?? ?? 85 DB 0F 84 77 01 00 00 53 A1 1C 71 00 10 50 E8 1E E2 FF FF 8B F0 85 F6 0F 84 61 01 00 00 53 A1 1C 71 00 10 50 E8 E0 E1 FF FF 85 C0 0F 84 4D 01 00 00 50 E8 DA E1 FF FF 8B D8 85 DB 0F 84 3D 01 00 00 56 B8 70 80 00 10 B9 01 00 00 00 8B 15 98 41 00 10 E8 9E DE FF FF 83 C4 04 A1 70 80 00 10 8B CE 8B D3 E8 E1 E1 FF FF 6A 00 6A 00 A1 70 80 00 10 B9 30 44 00 10 8B D6 E8 F8 FD FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01745_PolyBox_D____Anskya_
{
    meta:
        description = "[PolyBox D -> Anskya]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 33 C9 51 51 51 51 51 53 33 C0 55 68 84 2C 40 00 64 FF 30 64 89 20 C6 45 FF 00 B8 B8 46 40 00 BA 24 00 00 00 E8 8C F3 FF FF 6A 24 BA B8 46 40 00 8B 0D B0 46 40 00 A1 94 46 40 00 E8 71 FB FF FF 84 C0 0F 84 6E 01 00 00 8B 1D D0 46 40 00 8B C3 83 C0 24 03 05 D8 46 40 00 3B 05 B4 46 40 00 0F 85 51 01 00 00 8D 45 F4 BA B8 46 40 00 B9 10 00 00 00 E8 A2 EC FF FF 8B 45 F4 BA 9C 2C 40 00 E8 F1 ED FF FF}
    condition:
        $a
}

rule PEiD_01746_PolyCrypt_PE___2_1_4b_2_1_5____JLab_Software_Creations__h_oep__
{
    meta:
        description = "[PolyCrypt PE - 2.1.4b/2.1.5 -> JLab Software Creations (h-oep)]"
        ep_only = "false"
    strings:
        $a = {91 8B F4 AD FE C9 80 34 08 ?? E2 FA C3 60 E8 ED FF FF FF EB}
    condition:
        $a
}

rule PEiD_01747_PolyCrypt_PE___2_1_4b_2_1_5____JLab_Software_Creations__h_signed__
{
    meta:
        description = "[PolyCrypt PE - 2.1.4b/2.1.5 -> JLab Software Creations (h-signed)]"
        ep_only = "false"
    strings:
        $a = {50 6F 6C 79 43 72 79 70 74 20 50 45 20 28 63 29 20 32 30 30 34 2D 32 30 30 35 2C 20 4A 4C 61 62 53 6F 66 74 77 61 72 65 2E 00 50 00 43 00 50 00 45}
    condition:
        $a
}

rule PEiD_01748_PolyCryptor_by_SMT_Version__v3__v4_
{
    meta:
        description = "[PolyCryptor by SMT Version %v3.%v4]"
        ep_only = "true"
    strings:
        $a = {EB ?? 28 50 6F 6C 79 53 63 72 79 70 74 20 ?? ?? ?? 20 62 79 20 53 4D 54 29}
    condition:
        $a at pe.entry_point
}

rule PEiD_01749_PolyEnE_V0_01_____Lennart_Hedlund_
{
    meta:
        description = "[PolyEnE V0.01+ -> Lennart Hedlund]"
        ep_only = "false"
    strings:
        $a = {50 6F 6C 79 45 6E 45 00 4D 65 73 73 61 67 65 42 6F 78 41 00 55 53 45 52 33 32 2E 64 6C 6C}
    condition:
        $a
}

rule PEiD_01750_PoPa_0_01__Packer_on_Pascal_____bagie_
{
    meta:
        description = "[PoPa 0.01 (Packer on Pascal) -> bagie]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 EC 53 56 57 33 C0 89 45 EC B8 A4 3E 00 10 E8 30 F6 FF FF 33 C0 55 68 BE 40 00 10 ?? ?? ?? ?? 89 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 33 C0 E8 62 E7 FF FF 8B 45 EC E8 32 F2 FF FF 50 E8 B4 F6 FF FF A3 64 66 00 10 33 D2 55 68 93 40 00 10 64 FF 32 64 89 22 83 3D 64 66 00 10 FF 0F 84 3A 01 00 00 6A 00 6A 00 6A 00 A1 64 66 00 10 50 E8 9B F6 FF FF 83 E8 10 50 A1 64 66 00 10 50 E8 BC F6 FF FF 6A 00 68 80 66 00 10 6A 10 68 68 66 00 10 A1 64 66 00 10 50 E8 8B F6 FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01751_PowerBASIC_CC_3_0x_
{
    meta:
        description = "[PowerBASIC/CC 3.0x]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 56 57 BB 00 ?? ?? 00 66 2E F7 05 ?? ?? ?? 00 04 00 0F 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_01752_PowerBASIC_CC_4_0_
{
    meta:
        description = "[PowerBASIC/CC 4.0]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 56 57 BB 00 ?? 40 00 66 2E F7 05 ?? ?? 40 00 04 00 75 05 E9 68 05 00 00 E9 6E 03}
    condition:
        $a at pe.entry_point
}

rule PEiD_01753_PowerBASIC_Win_7_0x_
{
    meta:
        description = "[PowerBASIC/Win 7.0x]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 56 57 BB 00 ?? 40 00 66 2E F7 05 ?? ?? 40 00 04 00 0F 85 DB 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01754_PowerBASIC_Win_8_00_
{
    meta:
        description = "[PowerBASIC/Win 8.00]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 53 56 57 BB 00 ?? ?? 00 66 2E F7 05 ?? ?? 40 00 04 00 75 05 E9 14 04 00 00 E9 19 02}
    condition:
        $a at pe.entry_point
}

rule PEiD_01755_PPC_PROTECT_1_1X____Alexey_Gorchakov_
{
    meta:
        description = "[PPC-PROTECT 1.1X -> Alexey Gorchakov]"
        ep_only = "true"
    strings:
        $a = {FF 5F 2D E9 20 00 9F E5 00 00 90 E5 18 00 8F E5 18 00 9F E5 00 00 90 E5 10 00 8F E5 01 00 A0 E3 00 00 00 EB 02 00 00 EA 04 F0 1F E5}
    condition:
        $a at pe.entry_point
}

rule PEiD_01756_Prepared_by_SLR__OPTLINK__
{
    meta:
        description = "[Prepared by SLR (OPTLINK)]"
        ep_only = "true"
    strings:
        $a = {87 C0 55 56 57 52 51 53 50 9C FC 8C DA 83 ?? ?? 16 07 0E 1F}
    condition:
        $a at pe.entry_point
}

rule PEiD_01757_PrincessSandy_1_0_eMiNENCE_Process_Patcher_Patch_
{
    meta:
        description = "[PrincessSandy 1.0 eMiNENCE Process Patcher Patch]"
        ep_only = "false"
    strings:
        $a = {68 27 11 40 00 E8 3C 01 00 00 6A 00 E8 41 01 00 00 A3 00 20 40 00 8B 58 3C 03 D8 0F B7 43 14 0F B7 4B 06 8D 7C 18 18 81 3F 2E 4C 4F 41 74 0B 83 C7 28 49 75 F2 E9 A7 00 00 00 8B 5F 0C 03 1D 00 20 40 00 89 1D 04 20 40 00 8B FB 83 C7 04 68 4C 20 40 00 68 08}
    condition:
        $a
}

rule PEiD_01758_PrincessSandy_v1_0_eMiNENCE_Process_Patcher_Patch_
{
    meta:
        description = "[PrincessSandy v1.0 eMiNENCE Process Patcher Patch]"
        ep_only = "false"
    strings:
        $a = {68 27 11 40 00 E8 3C 01 00 00 6A 00 E8 41 01 00 00 A3 00 20 40 00 8B 58 3C 03 D8 0F B7 43 14 0F B7 4B 06 8D 7C 18 18 81 3F 2E 4C 4F 41 74 0B 83 C7 28 49 75 F2 E9 A7 00 00 00 8B 5F 0C 03 1D 00 20 40 00 89 1D 04 20 40 00 8B FB 83 C7 04 68 4C 20 40 00 68 08 20 40 00 6A 00 6A 00 6A 20 6A 00 6A 00 6A 00 57 6A 00 E8 CE 00 00 00 85 C0 74 78 BD 50 C3 00 00 8B 3D 04 20 40 00 8B 07 8D 3C 07 83 C7 04 89 3D 04 20 40 00 8B 0F 83 C7 04 8B 1F 83 C7 04 4D 85 ED 74 57 60 6A 00 51 68 5C 20 40 00 53 FF 35 4C 20 40 00 E8 93 00 00 00 85 C0 61 74 E1 8B C1 60 BE 5C 20 40 00 F3 A6 74 03 61 EB D2 60 6A 00 50 57 53 FF 35 4C 20 40 00 E8 7A 00 00 00 85 C0 74 20 61 83 3C 07 00 74 2D 03 F8 EB A8 B8 5E 21 40 00 EB 13 B8 7C 21 40 00 EB 0C B8 9E 21 40 00 EB 05 B8 CF 21 40 00 6A 00 68 56}
    condition:
        $a
}

rule PEiD_01759_Private_EXE_Protector_1_8____SetiSoft__h__
{
    meta:
        description = "[Private EXE Protector 1.8 -> SetiSoft (h)]"
        ep_only = "false"
    strings:
        $a = {A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 89 E8 B3 01 56 89 FE 29 C6 F3 A4 5E EB 8E 00 D2 75 05 8A 16 46 10 D2 C3 31 C9 41 E8 EE FF FF FF 11 C9 E8 E7 FF FF FF 72 F2 C3 31 FF 31 F6 C3}
    condition:
        $a
}

rule PEiD_01760_Private_EXE_Protector_1_8_
{
    meta:
        description = "[Private EXE Protector 1.8]"
        ep_only = "false"
    strings:
        $a = {BB DC EE 0D 76 D9 D0 8D 16 85 D8 90 D9 D0}
    condition:
        $a
}

rule PEiD_01761_Private_EXE_Protector_1_9_7____SetiSoft__h__
{
    meta:
        description = "[Private EXE Protector 1.9.7 -> SetiSoft (h)]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 F4 FC 53 57 56 8B 74 24 20 8B 7C 24 24 66 81 3E 4A 43 0F 85 A5 02 00 00 83 C6 0A 33 DB BA 00 00 00 80 C7 44 24 14 08 00 00 00 43 8D A4 24 00 00 00 00 8B FF 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 73 2C 8B 4C 24 10 33 C0 8D A4 24 00 00 00 00 05}
    condition:
        $a
}

rule PEiD_01762_Private_EXE_Protector_1_9_7____SetiSoft__h__
{
    meta:
        description = "[Private EXE Protector 1.9.7 -> SetiSoft (h)]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 F4 FC 53 57 56 8B 74 24 20 8B 7C 24 24 66 81 3E 4A 43 0F 85 A5 02 00 00 83 C6 0A 33 DB BA 00 00 00 80 C7 44 24 14 08 00 00 00 43 8D A4 24 00 00 00 00 8B FF 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 73 2C 8B 4C 24 10 33 C0 8D A4 24 00 00 00 00 05 00 00 00 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 13 C0 49 75 EF 02 44 24 0C 88 07 47 EB C6 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 0F 82 6E 01 00 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 0F 83 DC 00 00 00 B9 04 00 00 00 33 C0 8D A4 24 00 00 00 00 8D 64 24 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 13 C0 49 75 EF 48 74 B1 0F 89 EF 01 00 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 73 42 BD 00 01 00 00 B9 08 00 00 00 33 C0 8D A4 24 00 00 00 00 05 00 00 00 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 13 C0 49 75 EF 88 07 47 4D 75 D6}
    condition:
        $a
}

rule PEiD_01763_Private_Exe_Protector_1_x____setisoft_
{
    meta:
        description = "[Private Exe Protector 1.x -> setisoft]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? B9 ?? 90 01 ?? BE ?? 10 40 ?? 68 50 91 41 ?? 68 01 ?? ?? ?? C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01764_Private_EXE_Protector_2_0____SetiSoft_
{
    meta:
        description = "[Private EXE Protector 2.0 -> SetiSoft]"
        ep_only = "true"
    strings:
        $a = {89 ?? ?? 38 00 00 00 8B ?? 00 00 00 00 81 ?? ?? ?? ?? ?? 89 ?? 00 00 00 00 81 ?? 04 00 00 00 81 ?? 04 00 00 00 81 ?? 00 00 00 00 0F 85 D6 FF FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01765_Private_exe_Protector_2_15____SetiSoft_Team_
{
    meta:
        description = "[Private exe Protector 2.15 -> SetiSoft Team]"
        ep_only = "true"
    strings:
        $a = {00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01766_Private_exe_Protector_V1_8X_V1_9X____SetiSoft_Team_
{
    meta:
        description = "[Private exe Protector V1.8X-V1.9X -> SetiSoft Team]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73}
    condition:
        $a
}

rule PEiD_01767_Private_exe_Protector_V2_0____SetiSoft_Team___Sign_by_fly_
{
    meta:
        description = "[Private exe Protector V2.0 -> SetiSoft Team ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_01768_Private_EXE_v2_0a_
{
    meta:
        description = "[Private EXE v2.0a]"
        ep_only = "true"
    strings:
        $a = {53 E8 00 00 00 00 5B 8B C3 2D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01769_Private_EXE_v2_0a_
{
    meta:
        description = "[Private EXE v2.0a]"
        ep_only = "false"
    strings:
        $a = {53 E8 ?? ?? ?? ?? 5B 8B C3 2D}
    condition:
        $a
}

rule PEiD_01770_Private_Personal_Packer__PPP__1_0_2____ConquestOfTroy_com_
{
    meta:
        description = "[Private Personal Packer (PPP) 1.0.2 -> ConquestOfTroy.com]"
        ep_only = "true"
    strings:
        $a = {E8 17 00 00 00 E8 68 00 00 00 FF 35 2C 37 00 10 E8 ED 01 00 00 6A 00 E8 2E 04 00 00 E8 41 04 00 00 A3 74 37 00 10 6A 64 E8 5F 04 00 00 E8 30 04 00 00 A3 78 37 00 10 6A 64 E8 4E 04 00 00 E8 1F 04 00 00 A3 7C 37 00 10 A1 74 37 00 10 8B 1D 78 37 00 10 2B D8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01771_Private_Personal_Packer__PPP__1_0_2____ConquestOfTroy_com_
{
    meta:
        description = "[Private Personal Packer (PPP) 1.0.2 -> ConquestOfTroy.com]"
        ep_only = "true"
    strings:
        $a = {E8 17 00 00 00 E8 68 00 00 00 FF 35 2C 37 00 10 E8 ED 01 00 00 6A 00 E8 2E 04 00 00 E8 41 04 00 00 A3 74 37 00 10 6A 64 E8 5F 04 00 00 E8 30 04 00 00 A3 78 37 00 10 6A 64 E8 4E 04 00 00 E8 1F 04 00 00 A3 7C 37 00 10 A1 74 37 00 10 8B 1D 78 37 00 10 2B D8 8B 0D 7C 37 00 10 2B C8 83 FB 64 73 0F 81 F9 C8 00 00 00 73 07 6A 00 E8 D9 03 00 00 C3 6A 0A 6A 07 6A 00 E8 D3 03 00 00 A3 20 37 00 10 50 6A 00 E8 DE 03 00 00 A3 24 37 00 10 FF 35 20 37 00 10 6A 00 E8 EA 03 00 00 A3 30 37 00 10 FF 35 24 37 00 10 E8 C2 03 00 00 A3 28 37 00 10 8B 0D 30 37 00 10 8B 3D 28 37 00 10 EB 09 49 C0 04 39 55 80 34 39 24 0B C9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01772_Private_Personal_Packer__PPP__1_0_3____ConquestOfTroy_com_
{
    meta:
        description = "[Private Personal Packer (PPP) 1.0.3 -> ConquestOfTroy.com]"
        ep_only = "true"
    strings:
        $a = {E8 19 00 00 00 90 90 E8 68 00 00 00 FF 35 2C 37 00 10 E8 ED 01 00 00 6A 00 E8 2E 04 00 00 E8 41 04 00 00 A3 74 37 00 10 6A 64 E8 5F 04 00 00 E8 30 04 00 00 A3 78 37 00 10 6A 64 E8 4E 04 00 00 E8 1F 04 00 00 A3 7C 37 00 10 A1 74 37 00 10 8B 1D 78 37 00 10 2B D8 8B 0D 7C 37 00 10 2B C8 83 FB 64 73 0F 81 F9 C8 00 00 00 73 07 6A 00 E8 D9 03 00 00 C3 6A 0A 6A 07 6A 00 E8 D3 03 00 00 A3 20 37 00 10 50 6A 00 E8 DE 03 00 00 A3 24 37 00 10 FF 35 20 37 00 10 6A 00 E8 EA 03 00 00 A3 30 37 00 10 FF 35 24 37 00 10 E8 C2 03 00 00 A3 28 37 00 10 8B 0D 30 37 00 10 8B 3D 28 37 00 10 EB 09 49 C0 04 39 55 80 34 39 24 0B C9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01773_Private_Personal_Packer__PPP__v1_0_2_____ConquestOfTroy_com_
{
    meta:
        description = "[Private Personal Packer (PPP) v1.0.2 --> ConquestOfTroy.com]"
        ep_only = "true"
    strings:
        $a = {E8 17 00 00 00 E8 68 00 00 00 FF 35 2C 37 00 10 E8 ED 01 00 00 6A 00 E8 2E 04 00 00 E8 41 04 00 00 A3 74 37 00 10 6A 64 E8 5F 04 00 00 E8 30 04 00 00 A3 78 37 00 10 6A 64 E8 4E 04 00 00 E8 1F 04 00 00 A3 7C 37 00 10 A1 74 37 00 10 8B 1D 78 37 00 10 2B D8 8B 0D 7C 37 00 10 2B C8 83 FB 64 73 0F 81 F9 C8 00 00 00 73 07 6A 00 E8 D9 03 00 00 C3 6A 0A 6A 07 6A 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01774_PrivateEXE_v2_0a_
{
    meta:
        description = "[PrivateEXE v2.0a]"
        ep_only = "true"
    strings:
        $a = {06 60 C8 ?? ?? ?? 0E 68 ?? ?? 9A ?? ?? ?? ?? 3D ?? ?? 0F ?? ?? ?? 50 50 0E 68 ?? ?? 9A ?? ?? ?? ?? 0E}
    condition:
        $a at pe.entry_point
}

rule PEiD_01775_PrivateEXE_v2_0a_
{
    meta:
        description = "[PrivateEXE v2.0a]"
        ep_only = "true"
    strings:
        $a = {53 E8 ?? ?? ?? ?? 5B 8B C3 2D ?? ?? ?? ?? 50 81 ?? ?? ?? ?? ?? 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01776_PRO_MIDI_Music_file_
{
    meta:
        description = "[PRO-MIDI Music file]"
        ep_only = "false"
    strings:
        $a = {52 49 46 46 ?? ?? ?? ?? 52 4D 49 44}
    condition:
        $a
}

rule PEiD_01777_PRO_PACK_v2_08__emphasis_on_packed_size__locked_
{
    meta:
        description = "[PRO-PACK v2.08, emphasis on packed size, locked]"
        ep_only = "true"
    strings:
        $a = {83 EC ?? 8B EC BE ?? ?? FC E8 ?? ?? 05 ?? ?? 8B C8 E8 ?? ?? 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01778_PRO_PACK_v2_08_
{
    meta:
        description = "[PRO-PACK v2.08]"
        ep_only = "true"
    strings:
        $a = {8C D3 8E C3 8C CA 8E DA 8B 0E ?? ?? 8B F1 83 ?? ?? 8B FE D1 ?? FD F3 A5 53}
    condition:
        $a at pe.entry_point
}

rule PEiD_01779_ProActivate_V1_0X____TurboPower_Software_Company___Sign_by_fly_
{
    meta:
        description = "[ProActivate V1.0X -> TurboPower Software Company ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {55 8B EC B9 0E 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 B8 ?? ?? ?? ?? 90 90 90 90 90 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 83 C0 05 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 0D 00 00 00 E8 85 E2 FF FF 81 3D ?? ?? ?? ?? 21 7E 7E 40 75 7A 81 3D ?? ?? ?? ?? 43 52 43 33 75 6E 81 3D ?? ?? ?? ?? 32 40 7E 7E 75 62 81 3D ?? ?? ?? ?? 21 7E 7E 40 75 56 81 3D ?? ?? ?? ?? 43 52 43 33 75 4A 81 3D ?? ?? ?? ?? 32 40 7E 7E 75 3E 81 3D ?? ?? ?? ?? 21 7E 7E 40 75 32 81 3D ?? ?? ?? ?? 43 52 43 33}
    condition:
        $a at pe.entry_point
}

rule PEiD_01780_ProActivate_V1_0X____TurboPower_Software_Company_
{
    meta:
        description = "[ProActivate V1.0X -> TurboPower Software Company]"
        ep_only = "true"
    strings:
        $a = {55 8B EC B9 0E 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 B8 ?? ?? ?? ?? 90 90 90 90 90 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 83 C0 05 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 0D 00 00 00 E8 85 E2 FF FF 81 3D ?? ?? ?? ?? 21 7E 7E 40 75 7A 81 3D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01781_Program_Protector_XP_v1_0_
{
    meta:
        description = "[Program Protector XP v1.0]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? 58 83 D8 05 89 C3 81 C3 ?? ?? ?? ?? 8B 43 64 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_01782_Protect_Shareware_1_1____eCompserv_CMS_
{
    meta:
        description = "[Protect Shareware 1.1 -> eCompserv CMS]"
        ep_only = "false"
    strings:
        $a = {53 00 74 00 72 00 69 00 6E 00 67 00 46 00 69 00 6C 00 65 00 49 00 6E 00 66 00 6F 00 00 00 ?? 01 00 00 01 00 30 00 34 00 30 00 39 00 30 00 34 00 42 00 30 00 00 00 34 00 ?? 00 01 00 43 00 6F 00 6D 00 70 00 61 00 6E 00 79 00 4E 00 61 00 6D 00 65 00 00 00 00}
    condition:
        $a
}

rule PEiD_01783_Protect_Shareware_V1_1____eCompserv_CMS_
{
    meta:
        description = "[Protect Shareware V1.1 -> eCompserv CMS]"
        ep_only = "false"
    strings:
        $a = {53 00 74 00 72 00 69 00 6E 00 67 00 46 00 69 00 6C 00 65 00 49 00 6E 00 66 00 6F 00 00 00 ?? 01 00 00 01 00 30 00 34 00 30 00 39 00 30 00 34 00 42 00 30 00 00 00 34 00 ?? 00 01 00 43 00 6F 00 6D 00 70 00 61 00 6E 00 79 00 4E 00 61 00 6D 00 65 00 00 00 00 00 4A 00 76 00 77 00}
    condition:
        $a
}

rule PEiD_01784_PROTECT__EXE_COM_v5_0_
{
    meta:
        description = "[PROTECT! EXE/COM v5.0]"
        ep_only = "true"
    strings:
        $a = {1E 0E 0E 1F 07}
    condition:
        $a at pe.entry_point
}

rule PEiD_01785_PROTECT__EXE_COM_v6_0_
{
    meta:
        description = "[PROTECT! EXE/COM v6.0]"
        ep_only = "true"
    strings:
        $a = {1E B4 30 CD 21 3C 02 73 ?? CD 20 BE ?? ?? E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01786_Protection_Plus_vx_x_
{
    meta:
        description = "[Protection Plus vx.x]"
        ep_only = "true"
    strings:
        $a = {50 60 29 C0 64 FF 30 E8 ?? ?? ?? ?? 5D 83 ED 3C 89 E8 89 A5 14 ?? ?? ?? 2B 85 1C ?? ?? ?? 89 85 1C ?? ?? ?? 8D 85 27 03 ?? ?? 50 8B ?? 85 C0 0F 85 C0 ?? ?? ?? 8D BD 5B 03 ?? ?? 8D B5 43 03 ?? ?? E8 DD ?? ?? ?? 89 85 1F 03 ?? ?? 6A 40 68 ?? 10 ?? ?? 8B 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_01787_Protection_Plus_vx_x_
{
    meta:
        description = "[Protection Plus vx.x]"
        ep_only = "true"
    strings:
        $a = {50 60 29 C0 64 FF 30 E8 ?? ?? ?? ?? 5D 83 ED 3C 89 E8 89 A5 14 ?? ?? ?? 2B 85 1C ?? ?? ?? 89 85 1C ?? ?? ?? 8D 85 27 03 ?? ?? 50 8B ?? 85 C0 0F 85 C0 ?? ?? ?? 8D BD 5B 03 ?? ?? 8D B5 43 03 ?? ?? E8 DD ?? ?? ?? 89 85 1F 03 ?? ?? 6A 40 68 ?? 10 ?? ?? 8B 85 28 ?? ?? ?? 50 6A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01788_Protector_v1_1_11__DDeM____PE_Engine_v0_9__DDeM____CI_v0_9_2__
{
    meta:
        description = "[Protector v1.1.11 (DDeM -> PE Engine v0.9, DDeM -> CI v0.9.2)]"
        ep_only = "true"
    strings:
        $a = {53 51 56 E8 00 00 00 00 5B 81 EB 08 10 00 00 8D B3 34 10 00 00 B9 F3 03 00 00 BA 63 17 2A EE 31 16 83 C6 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_01789_PS_AdobeFont_v_1_0_
{
    meta:
        description = "[PS-AdobeFont v.1.0]"
        ep_only = "false"
    strings:
        $a = {80 01 ?? ?? 00 00 25 21 50 53 2D 41 64 6F 62 65 46 6F 6E 74 2D 31 2E 30 3A}
    condition:
        $a
}

rule PEiD_01790_pscrambler_1_2____by_p0ke_
{
    meta:
        description = "[pscrambler 1.2 -> by p0ke]"
        ep_only = "true"
    strings:
        $a = {55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 ?? ?? ?? ?? 10 E8 2D F3 FF FF 33 C0 55 68 E8 31 00 10 64 FF 30 64 89 20 8D 45 E0 E8 53 F5 FF FF 8B 45 E0 8D 55 E4 E8 30 F6 FF FF 8B 45 E4 8D 55 E8 E8 A9 F4 FF FF 8B 45 E8 8D 55 EC E8 EE F7 FF FF 8B 55 EC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01791_pscrambler_1_2____by_p0ke_
{
    meta:
        description = "[pscrambler 1.2 -> by p0ke]"
        ep_only = "true"
    strings:
        $a = {55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 ?? ?? ?? ?? 10 E8 2D F3 FF FF 33 C0 55 68 E8 31 00 10 64 FF 30 64 89 20 8D 45 E0 E8 53 F5 FF FF 8B 45 E0 8D 55 E4 E8 30 F6 FF FF 8B 45 E4 8D 55 E8 E8 A9 F4 FF FF 8B 45 E8 8D 55 EC E8 EE F7 FF FF 8B 55 EC B8 C4 54 00 10 E8 D9 EC FF FF 83 3D C4 54 00 10 00 0F 84 05 01 00 00 80 3D A0 40 00 10 00 74 41 A1 C4 54 00 10 E8 D9 ED FF FF E8 48 E0 FF FF 8B D8 A1 C4 54 00 10 E8 C8 ED FF FF 50 B8 C4 54 00 10 E8 65 EF FF FF 8B D3 59 E8 69 E1 FF FF 8B C3 E8 12 FA FF FF 8B C3 E8 33 E0 FF FF E9 AD 00 00 00 B8 05 01 00 00 E8 0C E0 FF FF 8B D8 53 68 05 01 00 00 E8 57 F3 FF FF 8D 45 DC 8B D3 E8 39 ED FF FF 8B 55 DC B8 14 56 00 10 B9 00 32 00 10 E8 BB ED FF FF 8B 15 14 56 00 10 B8 C8 54 00 10 E8 53 E5 FF FF BA 01 00 00 00 B8 C8 54 00 10 E8 8C E8 FF FF E8 DF E0 FF FF 85 C0 75 52 6A 00 A1 C4 54 00 10 E8 3B ED FF FF 50 B8 C4 54 00 10 E8 D8 EE FF FF 8B D0 B8 C8 54 00 10 59 E8 3B E6 FF FF E8 76 E0 FF FF B8 C8 54 00 10 E8 4C E6 FF FF E8 67 E0 FF FF 6A 00 6A 00 6A 00 A1 14 56 00 10 E8 53 EE FF FF 50 6A 00 6A 00 E8 41 F3 FF FF 80 3D 9C 40 00 10 00 74 05 E8 EF FB FF FF 33 C0 5A 59 59 64 89 10 68 EF 31 00 10 8D 45 DC BA 05 00 00 00 E8 7D EB FF FF C3 E9 23 E9 FF FF EB EB 5B E8 63 EA FF FF 00 00 00 FF FF FF FF 08 00 00 00 74 65 6D 70 2E 65 78 65}
    condition:
        $a at pe.entry_point
}

rule PEiD_01792_PseudoSigner_0_1____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01793_PseudoSigner_0_1__32Lite_0_03_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [32Lite 0.03] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 06 FC 1E 07 BE 90 90 90 90 6A 04 68 90 10 90 90 68 ?? ?? ?? ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01794_PseudoSigner_0_1__ACProtect_1_09______Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [ACProtect 1.09] --> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 08 00 90 90 90 EB 06 00 00 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01795_PseudoSigner_0_1__ACProtect_1_09__
{
    meta:
        description = "[PseudoSigner 0.1 [ACProtect 1.09]]"
        ep_only = "true"
    strings:
        $a = {60 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01796_PseudoSigner_0_1__Armadillo_3_00_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Armadillo 3.00] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 E8 2A 00 00 00 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 85 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01797_PseudoSigner_0_1__ASPack_2_xx_Heuristic__
{
    meta:
        description = "[PseudoSigner 0.1 [ASPack 2.xx Heuristic]]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 A8 03 00 00 61 75 08 B8 01 00 00 00 C2 0C 00 68 00 00 00 00 C3 8B 85 26 04 00 00 8D 8D 3B 04 00 00 51 50 FF 95}
    condition:
        $a at pe.entry_point
}

rule PEiD_01798_PseudoSigner_0_1__ASProtect_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [ASProtect] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 90 90 90 90 90 90 5D 90 90 90 90 90 90 90 90 90 90 90 03 DD E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01799_PseudoSigner_0_1__Borland_Delphi_3_0______Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Borland Delphi 3.0] --> Anorganix]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01800_PseudoSigner_0_1__Borland_Delphi_3_0__
{
    meta:
        description = "[PseudoSigner 0.1 [Borland Delphi 3.0]]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01801_PseudoSigner_0_1__Borland_Delphi_5_0_KOL_MCK______Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Borland Delphi 5.0 KOL/MCK] --> Anorganix]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 FF 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 EB 04 00 00 00 01 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 EB 08 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 08 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 08 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0E 00 90 90 90 90 90 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0A 00 00 00 90 90 90 90 90 00 00 00 01 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01802_PseudoSigner_0_1__Borland_Delphi_5_0_KOL_MCK__
{
    meta:
        description = "[PseudoSigner 0.1 [Borland Delphi 5.0 KOL/MCK]]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 FF 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 EB 04 00 00 00 01 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01803_PseudoSigner_0_1__Borland_Delphi_6_0___7_0__
{
    meta:
        description = "[PseudoSigner 0.1 [Borland Delphi 6.0 - 7.0]]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 53 8B D8 33 C0 A3 09 09 09 00 6A 00 E8 09 09 00 FF A3 09 09 09 00 A1 09 09 09 00 A3 09 09 09 00 33 C0 A3 09 09 09 00 33 C0 A3 09 09 09 00 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01804_PseudoSigner_0_1__CD_Cops_II_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [CD-Cops II] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {53 60 BD 90 90 90 90 8D 45 90 8D 5D 90 E8 00 00 00 00 8D 01 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01805_PseudoSigner_0_1__Code_Lock_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Code-Lock] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {43 4F 44 45 2D 4C 4F 43 4B 2E 4F 43 58 00 01 28 01 50 4B 47 05 4C 3F B4 04 4D 4C 47 4B E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01806_PseudoSigner_0_1__CodeSafe_2_0_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [CodeSafe 2.0] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0B 83 EC 10 53 56 57 E8 C4 01 00 85 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01807_PseudoSigner_0_1__Crunch_PE_Heuristic_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Crunch/PE Heuristic] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {55 E8 0E 00 00 00 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85 00 00 00 00 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01808_PseudoSigner_0_1__DEF_1_0_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [DEF 1.0] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {BE 00 01 40 00 6A 05 59 80 7E 07 00 74 11 8B 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 83 C1 01 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01809_PseudoSigner_0_1__DxPack_1_0_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [DxPack 1.0] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 8B FD 81 ED 90 90 90 90 2B B9 00 00 00 00 81 EF 90 90 90 90 83 BD 90 90 90 90 90 0F 84 00 00 00 00 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01810_PseudoSigner_0_1__ExeSmasher_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [ExeSmasher] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {9C FE 03 90 60 BE 90 90 41 90 8D BE 90 10 FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 FE 0B E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01811_PseudoSigner_0_1__FSG_1_0_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [FSG 1.0] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 BB D0 01 40 00 BF 00 10 40 00 BE 90 90 90 90 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01812_PseudoSigner_0_1__FSG_1_31_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [FSG 1.31] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {BE 90 90 90 00 BF 90 90 90 00 BB 90 90 90 00 53 BB 90 90 90 00 B2 80 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01813_PseudoSigner_0_1__Gleam_1_00_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Gleam 1.00] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0B 83 EC 0C 53 56 57 E8 24 02 00 FF E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01814_PseudoSigner_0_1__JDPack_1_x___JDProtect_0_9_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [JDPack 1.x / JDProtect 0.9] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 E8 22 00 00 00 5D 8B D5 81 ED 90 90 90 90 2B 95 90 90 90 90 81 EA 06 90 90 90 89 95 90 90 90 90 83 BD 45 00 01 00 01 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01815_PseudoSigner_0_1__LCC_Win32_1_x_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [LCC Win32 1.x] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {64 A1 01 00 00 00 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 9A 10 40 90 50 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01816_PseudoSigner_0_1__LCC_Win32_DLL_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [LCC Win32 DLL] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 53 56 57 83 7D 0C 01 75 05 E8 17 90 90 90 FF 75 10 FF 75 0C FF 75 08 A1 ?? ?? ?? ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01817_PseudoSigner_0_1__Lockless_Intro_Pack_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Lockless Intro Pack] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {2C E8 EB 1A 90 90 5D 8B C5 81 ED F6 73 90 90 2B 85 90 90 90 90 83 E8 06 89 85 FF 01 EC AD E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01818_PseudoSigner_0_1__LTC_1_3_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [LTC 1.3] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {54 E8 00 00 00 00 5D 8B C5 81 ED F6 73 40 00 2B 85 87 75 40 00 83 E8 06 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01819_PseudoSigner_0_1__Macromedia_Flash_Projector_6_0_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Macromedia Flash Projector 6.0] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 83 EC 44 56 FF 15 24 81 49 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01820_PseudoSigner_0_1__MEW_11_SE_1_0_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [MEW 11 SE 1.0] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {E9 09 00 00 00 00 00 00 02 00 00 00 0C 90 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01821_PseudoSigner_0_1__Microsoft_Visual_Basic_5_0___6_0_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Microsoft Visual Basic 5.0 - 6.0] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? E8 0A 00 00 00 00 00 00 00 00 00 30 00 00 00 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01822_PseudoSigner_0_1__Microsoft_Visual_Basic_6_0_DLL__
{
    meta:
        description = "[PseudoSigner 0.1 [Microsoft Visual Basic 6.0 DLL]]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 5A 68 90 90 90 90 68 90 90 90 90 52 E9 90 90 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01823_PseudoSigner_0_1__Microsoft_Visual_C___5_0___MFC______Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Microsoft Visual C++ 5.0+ (MFC)] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01824_PseudoSigner_0_1__Microsoft_Visual_C___6_0__Debug_Version_______Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Microsoft Visual C++ 6.0 (Debug Version)] --> Anorganix]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 51 90 90 90 01 01 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 10 01 90 90 90 90 90 90 90 90 E8 00 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01825_PseudoSigner_0_1__Microsoft_Visual_C___6_0__Debug_Version___
{
    meta:
        description = "[PseudoSigner 0.1 [Microsoft Visual C++ 6.0 (Debug Version)]]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 51 90 90 90 01 01 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01826_PseudoSigner_0_1__Microsoft_Visual_C___6_20__
{
    meta:
        description = "[PseudoSigner 0.1 [Microsoft Visual C++ 6.20]]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 55 8B EC 83 EC 50 53 56 57 BE 90 90 90 90 8D 7D F4 A5 A5 66 A5 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01827_PseudoSigner_0_1__Microsoft_Visual_C___7_0_DLL_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Microsoft Visual C++ 7.0 DLL] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {55 8D 6C 01 00 81 EC 00 00 00 00 8B 45 90 83 F8 01 56 0F 84 00 00 00 00 85 C0 0F 84 ?? ?? ?? ?? E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01828_PseudoSigner_0_1__MinGW_GCC_2_x_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [MinGW GCC 2.x] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 E8 02 00 00 00 C9 C3 90 90 45 58 45 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01829_PseudoSigner_0_1__Morphine_1_2______Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Morphine 1.2] --> Anorganix]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 EB 08 E8 90 00 00 00 66 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 51 66 90 90 90 59 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 E2 90 90 90 EB 08 82 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 01 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01830_PseudoSigner_0_1__Morphine_1_2__
{
    meta:
        description = "[PseudoSigner 0.1 [Morphine 1.2]]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 EB 08 E8 90 00 00 00 66 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 51 66 90 90 90 59 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01831_PseudoSigner_0_1__Neolite_2_0______Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Neolite 2.0] --> Anorganix]"
        ep_only = "true"
    strings:
        $a = {E9 A6 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01832_PseudoSigner_0_1__Neolite_2_0__
{
    meta:
        description = "[PseudoSigner 0.1 [Neolite 2.0]]"
        ep_only = "true"
    strings:
        $a = {E9 A6 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01833_PseudoSigner_0_1__NorthStar_PE_Shrinker_1_3_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [NorthStar PE Shrinker 1.3] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 00 00 00 00 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01834_PseudoSigner_0_1__Pack_Master_1_0__PEX_Clone_______Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Pack Master 1.0 (PEX Clone)] --> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 E8 01 01 00 00 E8 83 C4 04 E8 01 90 90 90 E9 5D 81 ED D3 22 40 90 E8 04 02 90 90 E8 EB 08 EB 02 CD 20 FF 24 24 9A 66 BE 47 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 FF FF E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01835_PseudoSigner_0_1__Pack_Master_1_0__PEX_Clone___
{
    meta:
        description = "[PseudoSigner 0.1 [Pack Master 1.0 (PEX Clone)]]"
        ep_only = "true"
    strings:
        $a = {60 E8 01 01 00 00 E8 83 C4 04 E8 01 90 90 90 E9 5D 81 ED D3 22 40 90 E8 04 02 90 90 E8 EB 08 EB 02 CD 20 FF 24 24 9A 66 BE 47 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01836_PseudoSigner_0_1__PE_Intro_1_0_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [PE Intro 1.0] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {8B 04 24 9C 60 E8 14 00 00 00 5D 81 ED 0A 45 40 90 80 BD 67 44 40 90 90 0F 85 48 FF ED 0A E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01837_PseudoSigner_0_1__PE_Pack_0_99_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [PE Pack 0.99] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 E8 11 00 00 00 5D 83 ED 06 80 BD E0 04 90 90 01 0F 84 F2 FF CC 0A E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01838_PseudoSigner_0_1__PE_Protect_0_9_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [PE Protect 0.9] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {52 51 55 57 64 67 A1 30 00 85 C0 78 0D E8 07 00 00 00 58 83 C0 07 C6 90 C3 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01839_PseudoSigner_0_1__PECompact_1_4___
{
    meta:
        description = "[PseudoSigner 0.1 [PECompact 1.4+]]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 EB 06 68 90 90 90 90 C3 9C 60 E8 02 90 90 90 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81}
    condition:
        $a at pe.entry_point
}

rule PEiD_01840_PseudoSigner_0_1__PENightMare_2_Beta_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [PENightMare 2 Beta] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 E9 10 00 00 00 EF 40 03 A7 07 8F 07 1C 37 5D 43 A7 04 B9 2C 3A E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01841_PseudoSigner_0_1__PENinja_1_31_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [PENinja 1.31] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01842_PseudoSigner_0_1__PESHiELD_0_25_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [PESHiELD 0.25] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 E8 2B 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 CC CC E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01843_PseudoSigner_0_1__PEtite_2_x__level_0___
{
    meta:
        description = "[PseudoSigner 0.1 [PEtite 2.x (level 0)]]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 B8 00 90 90 00 6A 00 68 90 90 90 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 8B D8 03 00 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_01844_PseudoSigner_0_1__PEX_0_99_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [PEX 0.99] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 E8 01 00 00 00 55 83 C4 04 E8 01 00 00 00 90 5D 81 FF FF FF 00 01 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01845_PseudoSigner_0_1__REALBasic_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [REALBasic] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 90 90 90 90 90 90 90 90 90 90 50 90 90 90 90 90 00 01 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01846_PseudoSigner_0_1__Ste_lth_PE_1_01__
{
    meta:
        description = "[PseudoSigner 0.1 [Ste@lth PE 1.01]]"
        ep_only = "true"
    strings:
        $a = {0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 BA ?? ?? ?? ?? FF E2 BA E0 10 40 00 B8 68 24 1A 40 89 02 83 C2 03 B8 40 00 E8 EE 89 02 83 C2 FD FF E2 2D 3D 5B 20 48 69 64 65 50 45 20 5D 3D 2D 90 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01847_PseudoSigner_0_1__UPX_0_6_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [UPX 0.6] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 58 83 E8 3D 50 8D B8 00 00 00 FF 57 8D B0 E8 00 00 00 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01848_PseudoSigner_0_1__VBOX_4_3_MTE_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [VBOX 4.3 MTE] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01849_PseudoSigner_0_1__Video_Lan_Client_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Video-Lan-Client] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 90 90 90 90 90 90 90 90 90 90 90 90 90 90 01 FF FF 01 01 01 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 00 01 00 01 90 90 00 01 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01850_PseudoSigner_0_1__VOB_ProtectCD_5_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [VOB ProtectCD 5] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {36 3E 26 8A C0 60 E8 00 00 00 00 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01851_PseudoSigner_0_1__WATCOM_C_C___EXE_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [WATCOM C/C++ EXE] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {E9 00 00 00 00 90 90 90 90 57 41 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01852_PseudoSigner_0_1__XCR_0_11_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [XCR 0.11] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 8B F0 33 DB 83 C3 01 83 C0 01 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01853_PseudoSigner_0_1__Yoda_s_Protector_1_02_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.1 [Yoda's Protector 1.02] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {E8 03 00 00 00 EB 01 90 90 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01854_PseudoSigner_0_2___BJFNT_1_1b__
{
    meta:
        description = "[PseudoSigner 0.2 [.BJFNT 1.1b]]"
        ep_only = "true"
    strings:
        $a = {EB 01 EA 9C EB 01 EA 53 EB 01 EA 51 EB 01 EA 52 EB 01 EA 56 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01855_PseudoSigner_0_2___BJFNT_1_2__
{
    meta:
        description = "[PseudoSigner 0.2 [.BJFNT 1.2]]"
        ep_only = "true"
    strings:
        $a = {EB 02 69 B1 83 EC 04 EB 03 CD 20 EB EB 01 EB 9C EB 01 EB EB 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01856_PseudoSigner_0_2__32Lite_0_03_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.2 [32Lite 0.03] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {60 06 FC 1E 07 BE 90 90 90 90 6A 04 68 90 10 90 90 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_01857_PseudoSigner_0_2__Armadillo_3_00__
{
    meta:
        description = "[PseudoSigner 0.2 [Armadillo 3.00]]"
        ep_only = "true"
    strings:
        $a = {60 E8 2A 00 00 00 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_01858_PseudoSigner_0_2__ASProtect__
{
    meta:
        description = "[PseudoSigner 0.2 [ASProtect]]"
        ep_only = "true"
    strings:
        $a = {60 90 90 90 90 90 90 5D 90 90 90 90 90 90 90 90 90 90 90 03 DD}
    condition:
        $a at pe.entry_point
}

rule PEiD_01859_PseudoSigner_0_2__Borland_C___1999_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.2 [Borland C++ 1999] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 90 90 90 90 A1 ?? ?? ?? ?? A3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01860_PseudoSigner_0_2__Borland_C___DLL__Method_2___
{
    meta:
        description = "[PseudoSigner 0.2 [Borland C++ DLL (Method 2)]]"
        ep_only = "true"
    strings:
        $a = {EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 90 90 90 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01861_PseudoSigner_0_2__Borland_Delphi_DLL__
{
    meta:
        description = "[PseudoSigner 0.2 [Borland Delphi DLL]]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 B4 B8 90 90 90 90 E8 00 00 00 00 E8 00 00 00 00 8D 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01862_PseudoSigner_0_2__Borland_Delphi_Setup_Module__
{
    meta:
        description = "[PseudoSigner 0.2 [Borland Delphi Setup Module]]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 90 53 56 57 33 C0 89 45 F0 89 45 D4 89 45 D0 E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01863_PseudoSigner_0_2__CD_Cops_II__
{
    meta:
        description = "[PseudoSigner 0.2 [CD-Cops II]]"
        ep_only = "true"
    strings:
        $a = {53 60 BD 90 90 90 90 8D 45 90 8D 5D 90 E8 00 00 00 00 8D 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01864_PseudoSigner_0_2__Code_Lock__
{
    meta:
        description = "[PseudoSigner 0.2 [Code-Lock]]"
        ep_only = "true"
    strings:
        $a = {43 4F 44 45 2D 4C 4F 43 4B 2E 4F 43 58 00 01 28 01 50 4B 47 05 4C 3F B4 04 4D 4C 47 4B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01865_PseudoSigner_0_2__CodeSafe_2_0__
{
    meta:
        description = "[PseudoSigner 0.2 [CodeSafe 2.0]]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0B 83 EC 10 53 56 57 E8 C4 01 00 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_01866_PseudoSigner_0_2__Crunch_PE_Heuristic__
{
    meta:
        description = "[PseudoSigner 0.2 [Crunch/PE Heuristic]]"
        ep_only = "true"
    strings:
        $a = {55 E8 0E 00 00 00 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01867_PseudoSigner_0_2__DEF_1_0__
{
    meta:
        description = "[PseudoSigner 0.2 [DEF 1.0]]"
        ep_only = "true"
    strings:
        $a = {BE 00 01 40 00 6A 05 59 80 7E 07 00 74 11 8B 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 83 C1 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01868_PseudoSigner_0_2__DxPack_1_0__
{
    meta:
        description = "[PseudoSigner 0.2 [DxPack 1.0]]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 8B FD 81 ED 90 90 90 90 2B B9 00 00 00 00 81 EF 90 90 90 90 83 BD 90 90 90 90 90 0F 84 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01869_PseudoSigner_0_2__ExeSmasher__
{
    meta:
        description = "[PseudoSigner 0.2 [ExeSmasher]]"
        ep_only = "true"
    strings:
        $a = {9C FE 03 90 60 BE 90 90 41 90 8D BE 90 10 FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 FE 0B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01870_PseudoSigner_0_2__FSG_1_0__
{
    meta:
        description = "[PseudoSigner 0.2 [FSG 1.0]]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 BB D0 01 40 00 BF 00 10 40 00 BE 90 90 90 90 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01871_PseudoSigner_0_2__FSG_1_31__
{
    meta:
        description = "[PseudoSigner 0.2 [FSG 1.31]]"
        ep_only = "true"
    strings:
        $a = {BE 90 90 90 00 BF 90 90 90 00 BB 90 90 90 00 53 BB 90 90 90 00 B2 80}
    condition:
        $a at pe.entry_point
}

rule PEiD_01872_PseudoSigner_0_2__Gleam_1_00__
{
    meta:
        description = "[PseudoSigner 0.2 [Gleam 1.00]]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0B 83 EC 0C 53 56 57 E8 24 02 00 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01873_PseudoSigner_0_2__JDPack_1_x___JDProtect_0_9__
{
    meta:
        description = "[PseudoSigner 0.2 [JDPack 1.x / JDProtect 0.9]]"
        ep_only = "true"
    strings:
        $a = {60 E8 22 00 00 00 5D 8B D5 81 ED 90 90 90 90 2B 95 90 90 90 90 81 EA 06 90 90 90 89 95 90 90 90 90 83 BD 45 00 01 00 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01874_PseudoSigner_0_2__LCC_Win32_1_x__
{
    meta:
        description = "[PseudoSigner 0.2 [LCC Win32 1.x]]"
        ep_only = "true"
    strings:
        $a = {64 A1 01 00 00 00 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 9A 10 40 90 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_01875_PseudoSigner_0_2__LCC_Win32_DLL_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.2 [LCC Win32 DLL] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 53 56 57 83 7D 0C 01 75 05 E8 17 90 90 90 FF 75 10 FF 75 0C FF 75 08 A1}
    condition:
        $a at pe.entry_point
}

rule PEiD_01876_PseudoSigner_0_2__Lockless_Intro_Pack__
{
    meta:
        description = "[PseudoSigner 0.2 [Lockless Intro Pack]]"
        ep_only = "true"
    strings:
        $a = {2C E8 EB 1A 90 90 5D 8B C5 81 ED F6 73 90 90 2B 85 90 90 90 90 83 E8 06 89 85 FF 01 EC AD}
    condition:
        $a at pe.entry_point
}

rule PEiD_01877_PseudoSigner_0_2__Macromedia_Flash_Projector_6_0__
{
    meta:
        description = "[PseudoSigner 0.2 [Macromedia Flash Projector 6.0]]"
        ep_only = "true"
    strings:
        $a = {90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 83 EC 44 56 FF 15 24 81 49 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_01878_PseudoSigner_0_2__MEW_11_SE_1_0__
{
    meta:
        description = "[PseudoSigner 0.2 [MEW 11 SE 1.0]]"
        ep_only = "true"
    strings:
        $a = {E9 09 00 00 00 00 00 00 02 00 00 00 0C 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01879_PseudoSigner_0_2__Microsoft_Visual_Basic_5_0___6_0__
{
    meta:
        description = "[PseudoSigner 0.2 [Microsoft Visual Basic 5.0 - 6.0]]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? E8 0A 00 00 00 00 00 00 00 00 00 30 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01880_PseudoSigner_0_2__Microsoft_Visual_C___7_0_DLL_____Anorganix_
{
    meta:
        description = "[PseudoSigner 0.2 [Microsoft Visual C++ 7.0 DLL] -> Anorganix]"
        ep_only = "true"
    strings:
        $a = {55 8D 6C 01 00 81 EC 00 00 00 00 8B 45 90 83 F8 01 56 0F 84 00 00 00 00 85 C0 0F 84}
    condition:
        $a at pe.entry_point
}

rule PEiD_01881_PseudoSigner_0_2__MinGW_GCC_2_x__
{
    meta:
        description = "[PseudoSigner 0.2 [MinGW GCC 2.x]]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 E8 02 00 00 00 C9 C3 90 90 45 58 45}
    condition:
        $a at pe.entry_point
}

rule PEiD_01882_PseudoSigner_0_2__NorthStar_PE_Shrinker_1_3__
{
    meta:
        description = "[PseudoSigner 0.2 [NorthStar PE Shrinker 1.3]]"
        ep_only = "true"
    strings:
        $a = {9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01883_PseudoSigner_0_2__PE_Intro_1_0__
{
    meta:
        description = "[PseudoSigner 0.2 [PE Intro 1.0]]"
        ep_only = "true"
    strings:
        $a = {8B 04 24 9C 60 E8 14 00 00 00 5D 81 ED 0A 45 40 90 80 BD 67 44 40 90 90 0F 85 48 FF ED 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01884_PseudoSigner_0_2__PE_Pack_0_99__
{
    meta:
        description = "[PseudoSigner 0.2 [PE Pack 0.99]]"
        ep_only = "true"
    strings:
        $a = {60 E8 11 00 00 00 5D 83 ED 06 80 BD E0 04 90 90 01 0F 84 F2 FF CC 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01885_PseudoSigner_0_2__PE_Protect_0_9__
{
    meta:
        description = "[PseudoSigner 0.2 [PE Protect 0.9]]"
        ep_only = "true"
    strings:
        $a = {52 51 55 57 64 67 A1 30 00 85 C0 78 0D E8 07 00 00 00 58 83 C0 07 C6 90 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01886_PseudoSigner_0_2__PENightMare_2_Beta__
{
    meta:
        description = "[PseudoSigner 0.2 [PENightMare 2 Beta]]"
        ep_only = "true"
    strings:
        $a = {60 E9 10 00 00 00 EF 40 03 A7 07 8F 07 1C 37 5D 43 A7 04 B9 2C 3A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01887_PseudoSigner_0_2__PESHiELD_0_25__
{
    meta:
        description = "[PseudoSigner 0.2 [PESHiELD 0.25]]"
        ep_only = "true"
    strings:
        $a = {60 E8 2B 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 CC CC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01888_PseudoSigner_0_2__PEX_0_99__
{
    meta:
        description = "[PseudoSigner 0.2 [PEX 0.99]]"
        ep_only = "true"
    strings:
        $a = {60 E8 01 00 00 00 55 83 C4 04 E8 01 00 00 00 90 5D 81 FF FF FF 00 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01889_PseudoSigner_0_2__REALBasic__
{
    meta:
        description = "[PseudoSigner 0.2 [REALBasic]]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 90 90 90 90 90 90 90 90 90 90 50 90 90 90 90 90 00 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01890_PseudoSigner_0_2__UPX_0_6__
{
    meta:
        description = "[PseudoSigner 0.2 [UPX 0.6]]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 58 83 E8 3D 50 8D B8 00 00 00 FF 57 8D B0 E8 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01891_PseudoSigner_0_2__Video_Lan_Client__
{
    meta:
        description = "[PseudoSigner 0.2 [Video-Lan-Client]]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 90 90 90 90 90 90 90 90 90 90 90 90 90 90 01 FF FF 01 01 01 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 00 01 00 01 90 90 00 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01892_PseudoSigner_0_2__VOB_ProtectCD_5__
{
    meta:
        description = "[PseudoSigner 0.2 [VOB ProtectCD 5]]"
        ep_only = "true"
    strings:
        $a = {36 3E 26 8A C0 60 E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01893_PseudoSigner_0_2__Watcom_C_C___DLL__
{
    meta:
        description = "[PseudoSigner 0.2 [Watcom C/C++ DLL]]"
        ep_only = "true"
    strings:
        $a = {53 56 57 55 8B 74 24 14 8B 7C 24 18 8B 6C 24 1C 83 FF 03 0F 87 01 00 00 00 F1}
    condition:
        $a at pe.entry_point
}

rule PEiD_01894_PseudoSigner_0_2__WATCOM_C_C___EXE__
{
    meta:
        description = "[PseudoSigner 0.2 [WATCOM C/C++ EXE]]"
        ep_only = "true"
    strings:
        $a = {E9 00 00 00 00 90 90 90 90 57 41}
    condition:
        $a at pe.entry_point
}

rule PEiD_01895_PseudoSigner_0_2__ZCode_1_01__
{
    meta:
        description = "[PseudoSigner 0.2 [ZCode 1.01]]"
        ep_only = "true"
    strings:
        $a = {E9 12 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E9 FB FF FF FF C3 68 00 00 00 00 64 FF 35 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01896_PUNiSHER_1_5__DEMO_____FEUERRADER_AHTeam_
{
    meta:
        description = "[PUNiSHER 1.5 (DEMO) -> FEUERRADER/AHTeam]"
        ep_only = "false"
    strings:
        $a = {EB 04 83 A4 BC CE 60 EB 04 80 BC 04 11 E8 00 00 00 00 81 2C 24 CA C2 41 00 EB 04 64 6B 88 18 5D E8 00 00 00 00 EB 04 64 6B 88 18 81 2C 24 86 00 00 00 EB 04 64 6B 88 18 8B 85 9C C2 41 00 EB 04 64 6B 88 18 29 04 24 EB 04 64 6B 88 18 EB 04 64 6B 88 18 8B 04}
    condition:
        $a
}

rule PEiD_01897_PUNiSHER_v1_5__DEMO_____FEUERRADER_AHTeam_
{
    meta:
        description = "[PUNiSHER v1.5 (DEMO) -> FEUERRADER/AHTeam]"
        ep_only = "true"
    strings:
        $a = {EB 04 83 A4 BC CE 60 EB 04 80 BC 04 11 E8 00 00 00 00 81 2C 24 CA C2 41 00 EB 04 64 6B 88 18 5D E8 00 00 00 00 EB 04 64 6B 88 18 81 2C 24 86 00 00 00 EB 04 64 6B 88 18 8B 85 9C C2 41 00 EB 04 64 6B 88 18 29 04 24 EB 04 64 6B 88 18 EB 04 64 6B 88 18 8B 04 24 EB 04 64 6B 88 18 89 85 9C C2 41 00 EB 04 64 6B 88 18 58 68 9F 6F 56 B6 50 E8 5D 00 00 00 EB FF 71 78 C2 50 00 EB D3 5B F3 68 89 5C 24 48 5C 24 58 FF 8D 5C 24 58 5B 83 C3 4C 75 F4 5A 8D 71 78 75 09 81 F3 EB FF 52 BA 01 00 83 EB FC 4A FF 71 0F 75 19 8B 5C 24 00 00 81 33 50 53 8B 1B 0F FF C6 75 1B 81 F3 EB 87 1C 24 8B 8B 04 24 83 EC FC EB 01 E8 83 EC FC E9 E7 00 00 00 58 EB FF F0 EB FF C0 83 E8 FD EB FF 30 E8 C9 00 00 00 89 E0 EB FF D0 EB FF 71 0F 83 C0 01 EB FF 70 F0 71 EE EB FA EB 83 C0 14 EB FF 70 ED}
    condition:
        $a at pe.entry_point
}

rule PEiD_01898_PUNiSHER_V1_5____FEUERRADER_
{
    meta:
        description = "[PUNiSHER V1.5 -> FEUERRADER]"
        ep_only = "false"
    strings:
        $a = {3F 00 00 80 66 20 ?? 00 7E 20 ?? 00 92 20 ?? 00 A4 20 ?? 00 00 00 00 00 4B 45 52 4E 45 4C 33 32}
    condition:
        $a
}

rule PEiD_01899_PUNiSHER_V1_5_Demo____FEUERRADER_
{
    meta:
        description = "[PUNiSHER V1.5 Demo -> FEUERRADER]"
        ep_only = "true"
    strings:
        $a = {EB 04 83 A4 BC CE 60 EB 04 80 BC 04 11 E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01900_PuNkMoD_1_x____PuNkDuDe_
{
    meta:
        description = "[PuNkMoD 1.x -> PuNkDuDe]"
        ep_only = "true"
    strings:
        $a = {94 B9 ?? ?? 00 00 BC ?? ?? ?? ?? 80 34 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_01901_PureBasic_4_x____Neil_Hodgson_
{
    meta:
        description = "[PureBasic 4.x -> Neil Hodgson]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? 00 00 68 00 00 00 00 68 ?? ?? ?? 00 E8 ?? ?? ?? 00 83 C4 0C 68 00 00 00 00 E8 ?? ?? ?? 00 A3 ?? ?? ?? 00 68 00 00 00 00 68 00 10 00 00 68 00 00 00 00 E8 ?? ?? ?? 00 A3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01902_PureBasic_4_x_DLL____Neil_Hodgson_
{
    meta:
        description = "[PureBasic 4.x DLL -> Neil Hodgson]"
        ep_only = "true"
    strings:
        $a = {83 7C 24 08 01 75 0E 8B 44 24 04 A3 ?? ?? ?? 10 E8 22 00 00 00 83 7C 24 08 02 75 00 83 7C 24 08 00 75 05 E8 ?? 00 00 00 83 7C 24 08 03 75 00 B8 01 00 00 00 C2 0C 00 68 00 00 00 00 68 00 10 00 00 68 00 00 00 00 E8 ?? 0F 00 00 A3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01903_PureBasic_DLL____Neil_Hodgson_
{
    meta:
        description = "[PureBasic DLL -> Neil Hodgson]"
        ep_only = "true"
    strings:
        $a = {83 7C 24 08 01 75 ?? 8B 44 24 04 A3 ?? ?? ?? 10 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01904_R_SC_s_Process_Patcher_1_4_
{
    meta:
        description = "[R!SC's Process Patcher 1.4]"
        ep_only = "false"
    strings:
        $a = {E8 E1 01 00 00 80 38 22 75 13 80 38 00 74 2E 80 38 20 75 06 80 78 FF 22 74 18 40 EB ED 80 38 00 74 1B EB 19 40 80 78 FF 20 75 F9 80 38 00 74 0D EB 0B 40 80 38 00 74 05 80 38 22 74 00 8B F8 B8 04 60 40 00 68 00 20 40 00 C7 05 A2 20 40 00 44 00 00 00 68 92}
    condition:
        $a
}

rule PEiD_01905_R_SC_s_Process_Patcher_1_5_1_
{
    meta:
        description = "[R!SC's Process Patcher 1.5.1]"
        ep_only = "false"
    strings:
        $a = {68 00 20 40 00 E8 C3 01 00 00 80 38 00 74 0D 66 81 78 FE 22 20 75 02 EB 03 40 EB EE 8B F8 B8 04 60 40 00 68 C4 20 40 00 68 D4 20 40 00 6A 00 6A 00 6A 04 6A 00 6A 00 6A 00 57 50 E8 9F 01 00 00 85 C0 0F 84 39 01 00 00 BE 00 60 40 00 8B 06 A3 28 21 40 00 83}
    condition:
        $a
}

rule PEiD_01906_R_SC_s_Process_Patcher_v1_4_
{
    meta:
        description = "[R!SC's Process Patcher v1.4]"
        ep_only = "false"
    strings:
        $a = {E8 E1 01 00 00 80 38 22 75 13 80 38 00 74 2E 80 38 20 75 06 80 78 FF 22 74 18 40 EB ED 80 38 00 74 1B EB 19 40 80 78 FF 20 75 F9 80 38 00 74 0D EB 0B 40 80 38 00 74 05 80 38 22 74 00 8B F8 B8 04 60 40 00 68 00 20 40 00 C7 05 A2 20 40 00 44 00 00 00 68 92 20 40 00 68 A2 20 40 00 6A 00 6A 00 6A 04 6A 00 6A 00 6A 00 57 50 E8 7C 01 00 00 85 C0 0F 84 2A 01 00 00 B8 00 60 40 00 8B 00 A3 1C 22 40 00 BE 40 60 40 00 83 7E FC 00 0F 84 F6 00 00 00 8B 3E 83 C6 04 85 FF 0F 84 83 00 00 00 81 FF 72 21 73 63 0F 84 DD 00 00 00 33 DB 66 8B 1E 8B CF 8D 7E 02 C7 05 EA 21 40 00 00 00 00 00 83 05 EA 21 40 00 01 50 A1 1C 22 40 00 39 05 EA 21 40 00 58 0F 84 C1 00 00 00 60 6A 00 53 68 EA 20 40 00 51 FF 35 92 20 40 00 E8 EB 00 00 00 61 60 FC BE EA 20 40 00 8B CB F3 A6 61 75 C2 03}
    condition:
        $a
}

rule PEiD_01907_R_SC_s_Process_Patcher_v1_5_1_
{
    meta:
        description = "[R!SC's Process Patcher v1.5.1]"
        ep_only = "false"
    strings:
        $a = {68 00 20 40 00 E8 C3 01 00 00 80 38 00 74 0D 66 81 78 FE 22 20 75 02 EB 03 40 EB EE 8B F8 B8 04 60 40 00 68 C4 20 40 00 68 D4 20 40 00 6A 00 6A 00 6A 04 6A 00 6A 00 6A 00 57 50 E8 9F 01 00 00 85 C0 0F 84 39 01 00 00 BE 00 60 40 00 8B 06 A3 28 21 40 00 83 C6 40 83 7E FC 00 0F 84 8F 00 00 00 8B 3E 83 C6 04 85 FF 0F 84 E5 00 00 00 81 FF 72 21 73 63 74 7A 0F B7 1E 8B CF 8D 7E 02 C7 05 24 21 40 00 00 00 00 00 83 05 24 21 40 00 01 50 A1 28 21 40 00 39 05 24 21 40 00 58 0F 84 D8 00 00 00 60 6A 00 53 68 2C 21 40 00 51 FF 35 C4 20 40 00 E8 0A 01 00 00 61 60 FC BE 2C 21 40 00 8B CB F3 A6 61 75 C2 03 FB 60 E8 3E 00 00 00 6A 00 53 57 51 FF 35 C4 20 40 00 E8 FB 00 00 00 85 C0 0F 84 A2 00 00 00 61 03 FB 8B F7 E9 71 FF FF FF 60 FF 35 C8 20 40 00 E8 CB 00 00 00 61 C7 05}
    condition:
        $a
}

rule PEiD_01908_RAR_Configuration_file_
{
    meta:
        description = "[RAR Configuration file]"
        ep_only = "false"
    strings:
        $a = {52 41 52 20 43 4F 4E 46 49 47}
    condition:
        $a
}

rule PEiD_01909_RAR_SFX_
{
    meta:
        description = "[RAR SFX]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 00 00 00 00 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_01910_RatPacker__Glue__stub_
{
    meta:
        description = "[RatPacker (Glue) stub]"
        ep_only = "true"
    strings:
        $a = {40 20 FF 00 00 00 00 00 00 00 ?? BE 00 60 40 00 8D BE 00 B0 FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01911_RatPacker__Glue__stub_
{
    meta:
        description = "[RatPacker (Glue) stub]"
        ep_only = "false"
    strings:
        $a = {40 20 FF ?? ?? ?? ?? ?? ?? ?? ?? BE ?? 60 40 ?? 8D BE ?? B0 FF FF}
    condition:
        $a
}

rule PEiD_01912_RAZOR_1911_encruptor_
{
    meta:
        description = "[RAZOR 1911 encruptor]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? BF ?? ?? 3B FC 72 ?? B4 4C CD 21 BE ?? ?? B9 ?? ?? FD F3 A5 FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01913_RCryptor_1_5_by_Vaska__UsAr_sign__individual_version__21_03_2007_22_15__
{
    meta:
        description = "[RCryptor 1.5 by Vaska (UsAr sign (individual version) 21.03.2007 22:15)]"
        ep_only = "true"
    strings:
        $a = {83 2C 24 4F 68 40 A1 14 13 FF 54 24 04 83 44 24 04 4F B8 00 10 14 13 3D 24 C0 14 13 74 06 80 30 2B 40 EB F3 B8 8C 20 18 13 3D B9 27 18 13 74 06 80 30 19 40 EB F3 E8 00 00 00 00 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01914_RCryptor_1_6_by_Vaska__Damrai_sign_20_03_2007_20_41__
{
    meta:
        description = "[RCryptor 1.6 by Vaska (Damrai sign 20.03.2007 20:41)]"
        ep_only = "true"
    strings:
        $a = {33 D0 68 40 A1 14 13 FF D2 B8 00 10 14 13 3D 24 C0 14 13 74 06 80 30 BB 40 EB F3 33 C0 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01915_RCryptor_1_6c_by_Vaska__UsAr_sign_21_03_2007_22_25__
{
    meta:
        description = "[RCryptor 1.6c by Vaska (UsAr sign 21.03.2007 22:25)]"
        ep_only = "true"
    strings:
        $a = {8B C7 03 04 24 2B C7 80 38 50 0F 85 1B 8B 1F FF 68 40 A1 14 13 B8 00 10 14 13 3D 24 C0 14 13 74 06 80 30 F2 40 EB F3 B8 8C 20 18 13 3D B9 27 18 13 74 06 80 30 E8 40 EB F3 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01916_RCryptor_1_6d_by_Vaska__UsAr_sign_21_03_2007_22_22__
{
    meta:
        description = "[RCryptor 1.6d by Vaska (UsAr sign 21.03.2007 22:22)]"
        ep_only = "true"
    strings:
        $a = {60 90 61 61 80 7F F0 45 90 60 0F 85 1B 8B 1F FF 68 40 A1 14 13 B8 00 10 14 13 90 3D 24 C0 14 13 74 06 80 30 F6 40 EB F3 B8 8C 20 18 13 90 3D B9 27 18 13 74 06 80 30 89 40 EB F3 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01917_RCryptor_2_0____Vaska_
{
    meta:
        description = "[RCryptor 2.0 -> Vaska]"
        ep_only = "true"
    strings:
        $a = {F7 D1 83 F1 FF 6A 00 F7 D1 83 F1 FF 81 04 24 ?? ?? ?? ?? F7 D1 83 F1 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01918_RCryptor_by_Vaska_unknown_ver__sign_from_pinch_21_03_2006_23_05__
{
    meta:
        description = "[RCryptor by Vaska unknown ver (sign from pinch 21.03.2006 23:05)]"
        ep_only = "true"
    strings:
        $a = {90 58 90 50 90 8B 00 90 3C 50 90 58 0F 85 67 D6 EF 11 50 68 00 10 14 13 B8 00 10 14 13 3D 00 64 14 13 74 06 80 30 BC 40 EB F3 E8 00 00 00 00 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01919_RCryptor_v1_1_____Vaska_
{
    meta:
        description = "[RCryptor v1.1 --> Vaska]"
        ep_only = "false"
    strings:
        $a = {8B 04 24 83 E8 4F 68 ?? ?? ?? ?? FF D0}
    condition:
        $a
}

rule PEiD_01920_RCryptor_v1_1____Vaska_
{
    meta:
        description = "[RCryptor v1.1 -> Vaska]"
        ep_only = "false"
    strings:
        $a = {8B 04 24 83 E8 4F 68 ?? ?? ?? ?? FF D0 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3}
    condition:
        $a
}

rule PEiD_01921_RCryptor_v1_3___v1_4_____Vaska_
{
    meta:
        description = "[RCryptor v1.3 / v1.4 --> Vaska]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 8B 44 24 04 83 E8 4F 68 ?? ?? ?? ?? FF D0 58 59 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_01922_RCryptor_v1_3___v1_4____Vaska_
{
    meta:
        description = "[RCryptor v1.3 / v1.4 -> Vaska]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 8B 44 24 04 83 E8 4F 68 ?? ?? ?? ?? FF D0 58 59 50 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01923_RCryptor_v1_3b_____Vaska_
{
    meta:
        description = "[RCryptor v1.3b --> Vaska]"
        ep_only = "true"
    strings:
        $a = {61 83 EF 4F 60 68 ?? ?? ?? ?? FF D7}
    condition:
        $a at pe.entry_point
}

rule PEiD_01924_RCryptor_v1_3b____Vaska_
{
    meta:
        description = "[RCryptor v1.3b -> Vaska]"
        ep_only = "true"
    strings:
        $a = {61 83 EF 4F 60 68 ?? ?? ?? ?? FF D7 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01925_RCryptor_v1_5__Private_____Vaska_
{
    meta:
        description = "[RCryptor v1.5 (Private) -> Vaska]"
        ep_only = "true"
    strings:
        $a = {83 2C 24 4F 68 ?? ?? ?? ?? FF 54 24 04 83 44 24 04 4F B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01926_RCryptor_v1_5_____Vaska_
{
    meta:
        description = "[RCryptor v1.5 --> Vaska]"
        ep_only = "true"
    strings:
        $a = {83 2C 24 4F 68 ?? ?? ?? ?? FF 54 24 04 83 44 24 04 4F}
    condition:
        $a at pe.entry_point
}

rule PEiD_01927_RCryptor_V1_5____Vaska___Sign_by_fly_
{
    meta:
        description = "[RCryptor V1.5 -> Vaska ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {83 2C 24 4F 68 ?? ?? ?? ?? FF 54 24 04 83 44 24 04 4F B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? ?? EB F3 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01928_RCryptor_v1_6____Vaska_
{
    meta:
        description = "[RCryptor v1.6 -> Vaska]"
        ep_only = "true"
    strings:
        $a = {33 D0 68 ?? ?? ?? ?? FF D2 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01929_RCryptor_v1_6____Vaska_
{
    meta:
        description = "[RCryptor v1.6 -> Vaska]"
        ep_only = "true"
    strings:
        $a = {33 D0 68 ?? ?? ?? ?? FF D2}
    condition:
        $a at pe.entry_point
}

rule PEiD_01930_RCryptor_v1_6b___v1_6c_____Vaska_
{
    meta:
        description = "[RCryptor v1.6b / v1.6c --> Vaska]"
        ep_only = "true"
    strings:
        $a = {8B C7 03 04 24 2B C7 80 38 50 0F 85 1B 8B 1F FF 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_01931_RCryptor_v1_6b___v1_6c____Vaska_
{
    meta:
        description = "[RCryptor v1.6b / v1.6c -> Vaska]"
        ep_only = "true"
    strings:
        $a = {8B C7 03 04 24 2B C7 80 38 50 0F 85 1B 8B 1F FF 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01932_RCryptor_V1_6c____Vaska___Sign_by_fly_
{
    meta:
        description = "[RCryptor V1.6c -> Vaska ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {8B C7 03 04 24 2B C7 80 38 50 0F 85 1B 8B 1F FF 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01933_RCryptor_v1_6d_____Vaska_
{
    meta:
        description = "[RCryptor v1.6d --> Vaska]"
        ep_only = "true"
    strings:
        $a = {60 90 61 61 80 7F F0 45 90 60 0F 85 1B 8B 1F FF 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_01934_RCryptor_V1_6d____Vaska___Sign_by_fly_
{
    meta:
        description = "[RCryptor V1.6d -> Vaska ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 90 61 61 80 7F F0 45 90 60 0F 85 1B 8B 1F FF 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? 90 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 B8 ?? ?? ?? ?? 90 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01935_RCryptor_v1_6d____Vaska_
{
    meta:
        description = "[RCryptor v1.6d -> Vaska]"
        ep_only = "true"
    strings:
        $a = {60 90 61 61 80 7F F0 45 90 60 0F 85 1B 8B 1F FF 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? 90 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01936_RCryptor_v1_6x____Vaska_
{
    meta:
        description = "[RCryptor v1.6x -> Vaska]"
        ep_only = "true"
    strings:
        $a = {60 90 61 61 80 7F F0 45 90 60 0F 85 1B 8B 1F FF 68 ?? ?? ?? ?? C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01937_RCryptor_v1_______Vaska_
{
    meta:
        description = "[RCryptor v1.?? -> Vaska]"
        ep_only = "true"
    strings:
        $a = {90 58 90 50 90 8B 00 90 3C 50 90 58 0F 85 67 D6 EF 11 50 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01938_RCryptor_v1_______Vaska_
{
    meta:
        description = "[RCryptor v1.?? -> Vaska]"
        ep_only = "true"
    strings:
        $a = {90 58 90 50 90 8B 00 90 3C 50 90 58 0F 85 67 D6 EF 11 50 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_01939_RCryptor_v2_0__Hide_EP______Vaska_
{
    meta:
        description = "[RCryptor v2.0 (Hide EP) --> Vaska]"
        ep_only = "true"
    strings:
        $a = {F7 D1 83 F1 FF 6A 00 F7 D1 83 F1 FF 81 04 24 DC 20 ?? 00 F7 D1 83 F1 FF E8 00 00 00 00 F7 D1 83 F1 FF C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01940_RCryptor_v2_0_____Vaska_
{
    meta:
        description = "[RCryptor v2.0 --> Vaska]"
        ep_only = "true"
    strings:
        $a = {F7 D1 83 F1 FF 6A 00 F7 D1 83 F1 FF 81 04 24 ?? 02 00 00 F7 D1 83 F1 FF 59 BA 32 21 ?? 00 F7 D1 83 F1 FF F7 D1 83 F1 FF 80 02 E3 F7 D1 83 F1 FF C0 0A 05 F7 D1 83 F1 FF 80 02 6F F7 D1 83 F1 FF 80 32 A4 F7 D1 83 F1 FF 80 02 2D F7 D1 83 F1 FF 42 49 85 C9 75 CD 1C 4F 8D 5B FD 62 1E 1C 4F 8D 5B FD 4D 9D B9 ?? ?? ?? 1E 1C 4F 8D 5B FD 22 1C 4F 8D 5B FD 8E A2 B9 B9 E2 83 DB E2 E5 4D CD 1E BF 60 AB 1F 4D DB 1E 1E 3D 1E 92 1B 8E DC 7D EC A4 E2 4D E5 20 C6 CC B2 8E EC 2D 7D DC 1C 4F 8D 5B FD 83 56 8E E0 3A 7D D0 8E 9D 6E 7D D6 4D 25 06 C2 AB 20 CC 3A 4D 2D 9D 6B 0B 81 45 CC 18 4D 2D 1F A1 A1 6B C2 CC F7 E2 4D 2D 9E 8B 8B CC DE 2E 2D F7 1E AB 7D 45 92 30 8E E6 B9 7D D6 8E 9D 27 DA FD FD 1E 1E 8E DF B8 7D CF 8E A3 4D 7D DC 1C 4F 8D 5B FD 33 D7 1E 1E 1E A6 0B 41 A1 A6 42 61 6B 41 6B 4C 45 1E 21 F6 26 BC E2 62 1E 62 1E 62 1E 23 63 59 ?? 1E 62 1E 62 1E 33 D7 1E 1E 1E 85 6B C2 41 AB C2 9F 23 6B C2 41 A1 1E C0 FD F0 FD 30 20 33 9E 1E 1E 1E 85 A2 0B 8B C2 27 41 EB A1 A2 C2 1E C0 FD F0 FD 30 62 1E 33 7E 1E 1E 1E C6 2D 42 AB 9F 23 6B C2 41 A1 1E C0 FD F0 FD 30 C0 FD F0 8E 1D 1C 4F 8D 5B FD E0 00 33 5E 1E 1E 1E BF 0B EC C2 E6 42 A2 C2 45 1E C0 FD F0 FD 30 CE 36 CC F2 1C 4F 8D 5B FD}
    condition:
        $a at pe.entry_point
}

rule PEiD_01941_RE_Crypt_0_7x____Crudd__RET__
{
    meta:
        description = "[RE-Crypt 0.7x -> Crudd [RET]]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED F3 1D 40 00 B9 7B 09 00 00 8D BD 3B 1E 40 00 8B F7 61 60 E8 00 00 00 00 5D 55 81 04 24 0A 00 00 00 C3 8B F5 81 C5 ?? ?? 00 00 89 6D 34 89 75 38 8B 7D 38 81 E7 00 FF FF FF 81 C7 48 00 00 00 47 03 7D 60 8B 4D 5C 83 F9 00 7E 0F 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01942_RE_Crypt_v0_7x____Crudd__RET_
{
    meta:
        description = "[RE-Crypt v0.7x -> Crudd [RET]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 55 81 04 24 0A 00 00 00 C3 8B F5 81 C5 ?? ?? 00 00 89 6D 34 89 75 38 8B 7D 38 81 E7 00 FF FF FF 81 C7 48 00 00 00 47 03 7D 60 8B 4D 5C 83 F9 00 7E 0F 8B 17 33 55 58 89 17 83 C7 04 83 C1 FC EB EC 8B}
    condition:
        $a at pe.entry_point
}

rule PEiD_01943_RE_Crypt_v0_7x____Crudd__RET_
{
    meta:
        description = "[RE-Crypt v0.7x -> Crudd [RET]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED F3 1D 40 00 B9 7B 09 00 00 8D BD 3B 1E 40 00 8B F7 61 60 E8 00 00 00 00 5D 55 81 04 24 0A 00 00 00 C3 8B F5 81 C5 ?? ?? 00 00 89 6D 34 89 75 38 8B 7D 38 81 E7 00 FF FF FF 81 C7 48 00 00 00 47 03 7D 60 8B 4D 5C 83 F9 00 7E 0F 8B 17 33 55 58 89 17 83 C7 04 83 C1 FC EB EC}
    condition:
        $a at pe.entry_point
}

rule PEiD_01944_REALbasic_
{
    meta:
        description = "[REALbasic]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 50 ?? ?? ?? ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01945_REC_v0_32_
{
    meta:
        description = "[REC v0.32]"
        ep_only = "true"
    strings:
        $a = {06 1E 52 B8 ?? ?? 1E CD 21 86 E0 3D}
    condition:
        $a at pe.entry_point
}

rule PEiD_01946_REC_v0_34__3_
{
    meta:
        description = "[REC v0.34 [3]"
        ep_only = "true"
    strings:
        $a = {06 1E B4 30 CD 21 3C 02 73 ?? 33 C0 06 50 CB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01947_REC__C0ded_by_ROSE_
{
    meta:
        description = "[REC, C0ded by ROSE]"
        ep_only = "true"
    strings:
        $a = {06 1E 0E 0E 07 1F B4 30 CD 21 86 E0 3D 00 03 73 ?? CD 20 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01948_REC_Small_v1_02_
{
    meta:
        description = "[REC.Small v1.02]"
        ep_only = "true"
    strings:
        $a = {8C D8 1E E8 ?? ?? 83 ?? ?? 5D B9 ?? ?? 81 ?? ?? ?? 40 8E D8 2B DB B2 ?? ?? ?? FE C2 43 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_01949_Reflexive_Arcade_Wrapper_
{
    meta:
        description = "[Reflexive Arcade Wrapper]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 98 68 42 00 68 14 FA 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 F8 50 42 00 33 D2 8A D4 89 15 3C E8 42 00 8B C8 81 E1 FF 00 00 00 89 0D 38 E8 42 00 C1 E1 08 03 CA 89 0D 34 E8 42 00 C1 E8 10 A3 30 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01950_Reflexive_Arcade_Wrapper_
{
    meta:
        description = "[Reflexive Arcade Wrapper]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 98 68 42 00 68 14 FA 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 F8 50 42 00 33 D2 8A D4 89 15 3C E8 42 00 8B C8 81 E1 FF 00 00 00 89 0D 38 E8 42 00 C1 E1 08 03 CA 89 0D 34 E8 42 00 C1 E8 10 A3 30 E8 42 00 33 F6 56 E8 58 43 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 23 40 00 00 FF 15 18 51 42 00 A3 44 FE 42 00 E8 E1 3E 00 00 A3 78 E8 42 00 E8 8A 3C 00 00 E8 CC 3B 00 00 E8 3E F5 FF FF 89 75 D0 8D 45 A4 50 FF 15 14 51 42 00 E8 5D 3B 00 00 89 45 9C F6 45 D0 01 74 06 0F B7 45 D4 EB 03 6A 0A 58 50 FF 75 9C 56 56 FF 15 10 51 42 00 50 E8 0D 6E FE FF 89 45 A0 50 E8 2C F5 FF FF 8B 45 EC 8B 08 8B 09 89 4D 98 50 51 E8 9B 39 00 00 59 59 C3 8B 65 E8 FF 75 98 E8 1E F5 FF FF 83 3D 80 E8 42 00 01 75 05 E8 F3 43 00 00 FF 74 24 04 E8 23 44 00 00 68 FF 00 00 00 FF 15 B0 B8 42 00 59 59 C3 83 3D 80 E8 42 00 01 75 05 E8 CE 43 00 00 FF 74 24 04 E8 FE 43 00 00 59 68 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01951_Reg2Exe_2_20_2_21___by_Jan_Vorel_
{
    meta:
        description = "[Reg2Exe 2.20/2.21 - by Jan Vorel]"
        ep_only = "true"
    strings:
        $a = {6A 00 E8 7D 12 00 00 A3 A0 44 40 00 E8 79 12 00 00 6A 0A 50 6A 00 FF 35 A0 44 40 00 E8 0F 00 00 00 50 E8 69 12 00 00 CC CC CC CC CC CC CC CC CC 68 2C 02 00 00 68 00 00 00 00 68 B0 44 40 00 E8 3A 12 00 00 83 C4 0C 8B 44 24 04 A3 B8 44 40 00 68 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01952_Reg2Exe_2_20_2_21___by_Jan_Vorel_
{
    meta:
        description = "[Reg2Exe 2.20/2.21 - by Jan Vorel]"
        ep_only = "true"
    strings:
        $a = {6A 00 E8 7D 12 00 00 A3 A0 44 40 00 E8 79 12 00 00 6A 0A 50 6A 00 FF 35 A0 44 40 00 E8 0F 00 00 00 50 E8 69 12 00 00 CC CC CC CC CC CC CC CC CC 68 2C 02 00 00 68 00 00 00 00 68 B0 44 40 00 E8 3A 12 00 00 83 C4 0C 8B 44 24 04 A3 B8 44 40 00 68 00 00 00 00 68 A0 0F 00 00 68 00 00 00 00 E8 32 12 00 00 A3 B0 44 40 00 68 F4 01 00 00 68 BC 44 40 00 FF 35 B8 44 40 00 E8 1E 12 00 00 B8 BC 44 40 00 89 C1 8A 30 40 80 FE 5C 75 02 89 C1 80 FE 00 75 F1 C6 01 00 E8 EC 18 00 00 E8 28 16 00 00 E8 4A 12 00 00 68 00 FA 00 00 68 08 00 00 00 FF 35 B0 44 40 00 E8 E7 11 00 00 A3 B4 44 40 00 8B 15 D4 46 40 00 E8 65 0A 00 00 BB 00 00 10 00 B8 01 00 00 00 E8 72 0A 00 00 74 09 C7 00 01 00 00 00 83 C0 04 A3 D4 46 40 00 FF 35 B4 44 40 00 E8 26 05 00 00 8D 0D B8 46 40 00 5A E8 CF 0F 00 00 FF 35 B4 44 40 00 FF 35 B8 46 40 00 E8 EE 06 00 00 8D 0D B4 46 40 00 5A E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01953_Reg2Exe_2_22_2_23___by_Jan_Vorel_
{
    meta:
        description = "[Reg2Exe 2.22/2.23 - by Jan Vorel]"
        ep_only = "true"
    strings:
        $a = {6A 00 E8 2F 1E 00 00 A3 C4 35 40 00 E8 2B 1E 00 00 6A 0A 50 6A 00 FF 35 C4 35 40 00 E8 07 00 00 00 50 E8 1B 1E 00 00 CC 68 48 00 00 00 68 00 00 00 00 68 C8 35 40 00 E8 76 16 00 00 83 C4 0C 8B 44 24 04 A3 CC 35 40 00 68 00 00 00 00 68 A0 0F 00 00 68 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01954_Reg2Exe_2_22_2_23___by_Jan_Vorel_
{
    meta:
        description = "[Reg2Exe 2.22/2.23 - by Jan Vorel]"
        ep_only = "true"
    strings:
        $a = {6A 00 E8 2F 1E 00 00 A3 C4 35 40 00 E8 2B 1E 00 00 6A 0A 50 6A 00 FF 35 C4 35 40 00 E8 07 00 00 00 50 E8 1B 1E 00 00 CC 68 48 00 00 00 68 00 00 00 00 68 C8 35 40 00 E8 76 16 00 00 83 C4 0C 8B 44 24 04 A3 CC 35 40 00 68 00 00 00 00 68 A0 0F 00 00 68 00 00 00 00 E8 EC 1D 00 00 A3 C8 35 40 00 E8 62 1D 00 00 E8 92 1A 00 00 E8 80 16 00 00 E8 13 14 00 00 68 01 00 00 00 68 08 36 40 00 68 00 00 00 00 8B 15 08 36 40 00 E8 71 3F 00 00 B8 00 00 10 00 BB 01 00 00 00 E8 82 3F 00 00 FF 35 48 31 40 00 B8 00 01 00 00 E8 0D 13 00 00 8D 0D EC 35 40 00 5A E8 F2 13 00 00 68 00 01 00 00 FF 35 EC 35 40 00 E8 84 1D 00 00 A3 F4 35 40 00 FF 35 48 31 40 00 FF 35 F4 35 40 00 FF 35 EC 35 40 00 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01955_Reg2Exe_2_24___by_Jan_Vorel_
{
    meta:
        description = "[Reg2Exe 2.24 - by Jan Vorel]"
        ep_only = "true"
    strings:
        $a = {6A 00 E8 CF 20 00 00 A3 F4 45 40 00 E8 CB 20 00 00 6A 0A 50 6A 00 FF 35 F4 45 40 00 E8 07 00 00 00 50 E8 BB 20 00 00 CC 68 48 00 00 00 68 00 00 00 00 68 F8 45 40 00 E8 06 19 00 00 83 C4 0C 8B 44 24 04 A3 FC 45 40 00 68 00 00 00 00 68 A0 0F 00 00 68 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01956_Reg2Exe_2_24___by_Jan_Vorel_
{
    meta:
        description = "[Reg2Exe 2.24 - by Jan Vorel]"
        ep_only = "true"
    strings:
        $a = {6A 00 E8 CF 20 00 00 A3 F4 45 40 00 E8 CB 20 00 00 6A 0A 50 6A 00 FF 35 F4 45 40 00 E8 07 00 00 00 50 E8 BB 20 00 00 CC 68 48 00 00 00 68 00 00 00 00 68 F8 45 40 00 E8 06 19 00 00 83 C4 0C 8B 44 24 04 A3 FC 45 40 00 68 00 00 00 00 68 A0 0F 00 00 68 00 00 00 00 E8 8C 20 00 00 A3 F8 45 40 00 E8 02 20 00 00 E8 32 1D 00 00 E8 20 19 00 00 E8 A3 16 00 00 68 01 00 00 00 68 38 46 40 00 68 00 00 00 00 8B 15 38 46 40 00 E8 71 4F 00 00 B8 00 00 10 00 BB 01 00 00 00 E8 82 4F 00 00 FF 35 48 41 40 00 B8 00 01 00 00 E8 9D 15 00 00 8D 0D 1C 46 40 00 5A E8 82 16 00 00 68 00 01 00 00 FF 35 1C 46 40 00 E8 24 20 00 00 A3 24 46 40 00 FF 35 48 41 40 00 FF 35 24 46 40 00 FF 35 1C 46 40 00 E8 DC 10 00 00 8D 0D 14 46 40 00 5A E8 4A 16}
    condition:
        $a at pe.entry_point
}

rule PEiD_01957_Reg2Exe_2_25___by_Jan_Vorel_
{
    meta:
        description = "[Reg2Exe 2.25 - by Jan Vorel]"
        ep_only = "true"
    strings:
        $a = {68 68 00 00 00 68 00 00 00 00 68 70 7D 40 00 E8 AE 20 00 00 83 C4 0C 68 00 00 00 00 E8 AF 52 00 00 A3 74 7D 40 00 68 00 00 00 00 68 00 10 00 00 68 00 00 00 00 E8 9C 52 00 00 A3 70 7D 40 00 E8 24 50 00 00 E8 E2 48 00 00 E8 44 34 00 00 E8 54 28 00 00 E8 98}
    condition:
        $a at pe.entry_point
}

rule PEiD_01958_Reg2Exe_2_25___by_Jan_Vorel_
{
    meta:
        description = "[Reg2Exe 2.25 - by Jan Vorel]"
        ep_only = "true"
    strings:
        $a = {68 68 00 00 00 68 00 00 00 00 68 70 7D 40 00 E8 AE 20 00 00 83 C4 0C 68 00 00 00 00 E8 AF 52 00 00 A3 74 7D 40 00 68 00 00 00 00 68 00 10 00 00 68 00 00 00 00 E8 9C 52 00 00 A3 70 7D 40 00 E8 24 50 00 00 E8 E2 48 00 00 E8 44 34 00 00 E8 54 28 00 00 E8 98 27 00 00 E8 93 20 00 00 68 01 00 00 00 68 D0 7D 40 00 68 00 00 00 00 8B 15 D0 7D 40 00 E8 89 8F 00 00 B8 00 00 10 00 68 01 00 00 00 E8 9A 8F 00 00 FF 35 A4 7F 40 00 68 00 01 00 00 E8 3A 23 00 00 8D 0D A8 7D 40 00 5A E8 5E 1F 00 00 FF 35 A8 7D 40 00 68 00 01 00 00 E8 2A 52 00 00 A3 B4 7D 40 00 FF 35 A4 7F 40 00 FF 35 B4 7D 40 00 FF 35 A8 7D 40 00 E8 5C 0C 00 00 8D 0D A0 7D 40 00 5A E8 26 1F 00 00 FF 35}
    condition:
        $a at pe.entry_point
}

rule PEiD_01959_ReversingLabsProtector_0_7_4_beta____Ap0x_
{
    meta:
        description = "[ReversingLabsProtector 0.7.4 beta -> Ap0x]"
        ep_only = "true"
    strings:
        $a = {68 00 00 41 00 E8 01 00 00 00 C3 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01960_RJcrush_v1_00_
{
    meta:
        description = "[RJcrush v1.00]"
        ep_only = "true"
    strings:
        $a = {06 FC 8C C8 BA ?? ?? 03 D0 52 BA ?? ?? 52 BA ?? ?? 03 C2 8B D8 05 ?? ?? 8E DB 8E C0 33 F6 33 FF B9}
    condition:
        $a at pe.entry_point
}

rule PEiD_01961_RJoiner_1_2_by_Vaska__25_03_2007_16_58__
{
    meta:
        description = "[RJoiner 1.2 by Vaska (25.03.2007 16:58)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 0C 02 00 00 8D 85 F4 FD FF FF 56 50 68 04 01 00 00 FF 15 14 10 40 00 90 8D 85 F4 FD FF FF 50 FF 15 10 10 40 00 90 BE 00 20 40 00 90 83 3E FF 0F 84 84 00 00 00 53 57 33 FF 8D 46}
    condition:
        $a at pe.entry_point
}

rule PEiD_01962_RJoiner_1_2a____Vaska_
{
    meta:
        description = "[RJoiner 1.2a -> Vaska]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 0C 01 00 00 8D 85 F4 FE FF FF 56 50 68 04 01 00 00 FF 15 0C 10 40 00 94 90 94 8D 85 F4 FE FF FF 50 FF 15 08 10 40 00 94 90 94 BE 00 20 40 00 94 90 94 83 3E FF 74 7D 53 57 33 DB 8D 7E 04 94 90 94 53 68 80 00 00 00 6A 02 53 6A 01 68 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01963_RJoiner_1_2a____Vaska_
{
    meta:
        description = "[RJoiner 1.2a -> Vaska]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 0C 01 00 00 8D 85 F4 FE FF FF 56 50 68 04 01 00 00 FF 15 0C 10 40 00 94 90 94 8D 85 F4 FE FF FF 50 FF 15 08 10 40 00 94 90 94 BE 00 20 40 00 94 90 94 83 3E FF 74 7D 53 57 33 DB 8D 7E 04 94 90 94 53 68 80 00 00 00 6A 02 53 6A 01 68 00 00 00 C0 57 FF 15 04 10 40 00 89 45 F8 94 90 94 8B 06 8D 74 06 04 94 90 94 8D 45 FC 53 50 8D 46 04 FF 36 50 FF 75 F8 FF 15 00 10 40 00 94 90 94 FF 75 F8 FF 15 10 10 40 00 94 90 94 8D 85 F4 FE FF FF 6A 0A 50 53 57 68 20 10 40 00 53 FF 15 18 10 40 00 94 90 94 8B 06 8D 74 06 04 94 90 94 83 3E FF 75 89 5F 5B 33 C0 5E C9 C2 10 00 CC CC 24 11}
    condition:
        $a at pe.entry_point
}

rule PEiD_01964_RJoiner_by_Vaska__Sign_from_pinch_25_03_2007_17_00__
{
    meta:
        description = "[RJoiner by Vaska (Sign from pinch 25.03.2007 17:00)]"
        ep_only = "true"
    strings:
        $a = {E8 03 FD FF FF 6A 00 E8 0C 00 00 00 FF 25 6C 10 40 00 FF 25 70 10 40 00 FF 25 74 10 40 00 FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_01965_RLP_0_7_3beta____ap0x__h__
{
    meta:
        description = "[RLP 0.7.3beta -> ap0x (h)]"
        ep_only = "false"
    strings:
        $a = {60 8B DD E8 00 00 00 00 5D 95 32 C0 95 89 9D 80 00 00 00 B8 42 31 40 00 BB 41 30 40 00 2B C3 03 C5 33 D2 8A 10 40 B9 ?? ?? 00 00 8B F9 30 10 8A 10 40 49 75 F8 64 EF 86 3D 30 00 00 0F B9 FF 4B 89 52 5C 4C BD 77 C2 0C CE 88 4E 2D E8 00 00 00 5D 0D DB 5E 56}
    condition:
        $a
}

rule PEiD_01966_RLP_V0_7_3_beta____ap0x___Sign_by_fly_
{
    meta:
        description = "[RLP V0.7.3.beta -> ap0x ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {2E 72 6C 70 00 00 00 00 00 50 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 20 00 00 E0}
    condition:
        $a
}

rule PEiD_01967_RLP_v0_7_3beta____ap0x__h__
{
    meta:
        description = "[RLP v0.7.3beta -> ap0x (h)]"
        ep_only = "false"
    strings:
        $a = {60 8B DD E8 00 00 00 00 5D 95 32 C0 95 89 9D 80 00 00 00 B8 42 31 40 00 BB 41 30 40 00 2B C3 03 C5 33 D2 8A 10 40 B9 ?? ?? 00 00 8B F9 30 10 8A 10 40 49 75 F8 64 EF 86 3D 30 00 00 0F B9 FF 4B 89 52 5C 4C BD 77 C2 0C CE 88 4E 2D E8 00 00 00 5D 0D DB 5E 56 41 87 FC 0F F3 05 40 81 68 4B 93 71 40 BB 87 3C 40 40 8B 88 06 75 70 40 40 8B BB B3 43 C4 8F 93 2B F3 4A 88 06 07 30 F5 EA 2A 35 F0 4B 8A C3 07 C1 C6 02 C4 34 C0 74 74 32 02 C4 45 0B 3C 96 BE 0A 82 C3 DE 36 A9 7E 5A 51 A6 BC 63 A8 66 CB 30 58 20 8C CC 85 53 9F C1 E4 10 80 11 20 1E 48 D2 E8 F7 28 5C 26 89 5C 94 89 5A F8 1C 0B 74 7E 33 4E 9B 29 56 F2 2B 84 42 8A 95 16 76 64 08 7B 70 8F A0 0B A8 3A C1 C7 B5 3E D9 70}
    condition:
        $a
}

rule PEiD_01968_RLPack_____Ap0x_
{
    meta:
        description = "[RLPack --> Ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 2C 0A 00 00 8D 9D 22 02 00 00 33 FF E8 83 01 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 CD 09 00 00 89 85 14 0A 00 00 EB 14 60 FF B5 14 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01969_RLPack_____Ap0x_
{
    meta:
        description = "[RLPack --> Ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 5A 0A 00 00 8D 9D 40 02 00 00 33 FF E8 83 01 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 EB 09 00 00 89 85 3A 0A 00 00 EB 14 60 FF B5 3A 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01970_RLPack_____Ap0x_
{
    meta:
        description = "[RLPack --> Ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 EB 03 0C 00 00 EB 03 0C 00 00 8D B5 CB 22 00 00 8D 9D F0 02 00 00 33 FF E8 47 02 00 00 EB 03 15 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 9B 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01971_RLPack____Ap0x_
{
    meta:
        description = "[RLPack -> Ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 2C 0A 00 00 8D 9D 22 02 00 00 33 FF E8 ?? ?? ?? ?? 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 CD 09 00 00 89 85 ?? ?? ?? ?? EB 14 60 FF B5 14 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01972_RLPack____Ap0x_
{
    meta:
        description = "[RLPack -> Ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 5A 0A 00 00 8D 9D 40 02 00 00 33 FF E8 ?? ?? ?? ?? 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 EB 09 00 00 89 85 ?? ?? ?? ?? EB 14 60 FF B5 3A 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01973_RLPack____Ap0x_
{
    meta:
        description = "[RLPack -> Ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 8D B5 CB 22 00 00 8D 9D F0 02 00 00 33 FF E8 ?? ?? ?? ?? EB 03 ?? ?? ?? 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 9B 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01974_RLPack_1_0_beta____ap0x__h__
{
    meta:
        description = "[RLPack 1.0 beta -> ap0x (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8D 64 24 04 8B 6C 24 FC 8D B5 4C 02 00 00 8D 9D 13 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 F9 01 00 00 89 85 48 02 00 00 5B FF B5 48 02 00 00 56 FF D3 83 C4 08 8B B5 48 02 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 83 C0 04 89 85 44 02 00 00 EB 7A 56 FF 95 F1 01 00 00 89 85 40 02 00 00 8B C6 EB 4F 8B 85 44 02 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 44 02 00 00 C7 00 20 20 20 00 EB 06 FF B5 44 02 00 00 FF B5 40 02 00 00 FF 95 F5 01 00 00 89 07 83 C7 04 8B 85 44 02 00 00 EB 01 40 80 38 00 75 FA 40 89 85 44 02 00 00 80 38 00 75 AC EB 01 46 80 3E 00 75 FA 46 40 8B 38 83 C0 04 89 85 44 02 00 00 80 3E 01 75 81 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 48 02 00 00 FF 95 FD 01 00 00 61 68 ?? ?? ?? ?? C3 60 8B 74 24 24 8B 7C}
    condition:
        $a at pe.entry_point
}

rule PEiD_01975_RLPack_1_0_beta____ap0x_
{
    meta:
        description = "[RLPack 1.0 beta -> ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8D 64 24 04 8B 6C 24 FC 8D B5 4C 02 00 00 8D 9D 13 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 8D 74 37 04 53 6A 40 68 00 10 00 00 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_01976_RLPack_1_0_beta____ap0x_
{
    meta:
        description = "[RLPack 1.0 beta -> ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8D 64 24 04 8B 6C 24 FC 8D B5 4C 02 00 00 8D 9D 13 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 F9 01 00 00 89 85 48 02 00 00 5B FF B5}
    condition:
        $a at pe.entry_point
}

rule PEiD_01977_RLPack_1_1_BasicEdition____ap0x_
{
    meta:
        description = "[RLPack 1.1 BasicEdition -> ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 4A 02 00 00 8D 9D 11 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 8D 74 37 04 53 6A 40 68 00 10 00 00 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_01978_RLPack_1_16__aPLib_compression_____ap0x__h__
{
    meta:
        description = "[RLPack 1.16 (aPLib compression) -> ap0x (h)]"
        ep_only = "false"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 53 03 00 00 8D 9D 02 02 00 00 33 FF E8 45 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 E8 02 00 00 89 85 4F 03 00 00 5B FF B5 4F 03 00 00 56 FF D3 83 C4 08 8B B5 4F 03 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 E8 CD 00 00 00 83 C0 04 89 85 4B 03 00 00 E9 93 00 00 00 56 FF 95 E0 02 00 00 85 C0 0F 84 AE 00 00 00 89 85 47 03 00 00 8B C6 EB 5B 8B 85 4B 03 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 4B 03 00 00 C7 00 20 20 20 00 EB 06 FF B5 4B 03 00 00 FF B5 47 03 00 00 FF 95 E4 02 00 00 85 C0 74 6B 89 07 83 C7 04 8B}
    condition:
        $a
}

rule PEiD_01979_RLPack_1_16__LZMA_compression_____ap0x__h__
{
    meta:
        description = "[RLPack 1.16 (LZMA compression) -> ap0x (h)]"
        ep_only = "false"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 5A 0A 00 00 8D 9D 40 02 00 00 33 FF E8 83 01 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 EB 09 00 00 89 85 3A 0A 00 00 EB 14 60 FF B5 3A 0A 00 00 FF 34 37 FF 74 37 04 FF D3 61 83 C7 08 83 3C 37 00 75 E6 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 EB 09 00 00 89 85 56 0A 00 00 5B 60 FF B5 3A 0A 00 00 56 FF B5 56 0A 00 00 FF D3 61 8B B5 56 0A 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 E8 E7 00 00 00 83 C0 04 89 85 52 0A 00 00 E9 97 00 00 00 56 FF 95 E3 09 00 00 89 85 4E 0A 00 00 85 C0 0F 84 C2}
    condition:
        $a
}

rule PEiD_01980_RLPack_1_17__
{
    meta:
        description = "[RLPack 1.17+]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? 00 00 8D 9D ?? ?? 00 00 33 FF E8 ?? ?? ?? ?? EB 0F FF 74 37 04 FF 34 37 FF D3}
    condition:
        $a at pe.entry_point
}

rule PEiD_01981_RLPack_1_18__aPlib_0_43_____ap0x_
{
    meta:
        description = "[RLPack 1.18 (aPlib 0.43) -> ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 ?? 83 C7 ?? 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 BD 0A 04 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 A7 03 00 00 89 85 16 04 00 00 5B FF B5 16 04 00 00 56 FF D3 83 C4 ?? 8B B5 16 04 00 00 8B C6 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01982_RLPack_1_18__LZMA_4_30_____ap0x_
{
    meta:
        description = "[RLPack 1.18 (LZMA 4.30) -> ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A 00 00 FF 34 37 FF 74 37 04 FF D3 61 83 C7 ?? 83 3C 37 00 75 E6 83 BD 0D 0B 00 00 00 74 0E 83 BD 11 0B 00 00 00 74 05 E8 F6 01 00 00 8D 74 37 04 53 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 AA 0A 00 00 89 85 1D 0B 00 00 5B 60 FF B5 F9 0A 00 00 56 FF B5 1D 0B 00 00 FF D3 61 8B B5 1D 0B 00 00 8B C6 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01983_RLPack_1_18_Dll__aPlib_0_43_____ap0x_
{
    meta:
        description = "[RLPack 1.18 Dll (aPlib 0.43) -> ap0x]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 5C 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 ?? 83 C7 ?? 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 BD 0A 04 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 A7 03 00 00 89 85 16 04 00 00 5B FF B5 16 04 00 00 56 FF D3 83 C4 ?? 8B B5 16 04 00 00 8B C6 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01984_RLPack_1_18_Dll__LZMA_4_30_____ap0x_
{
    meta:
        description = "[RLPack 1.18 Dll (LZMA 4.30) -> ap0x]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 ?? 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8 9F 01 00 00 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A 00 00 FF 34 37 FF 74 37 04 FF D3 61 83 C7 08 83 3C 37 00 75 E6 83 BD 0D 0B 00 00 00 74 0E 83 BD 11 0B 00 00 00 74 05 E8 F6 01 00 00 8D 74 37 04 53 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 AA 0A 00 00 89 85 1D 0B 00 00 5B 60 FF B5 F9 0A 00 00 56 FF B5 1D 0B 00 00 FF D3 61 8B B5 1D 0B 00 00 8B C6 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_01985_RLPack_1_20_Basic_Edition__aPLib_____Ap0x_
{
    meta:
        description = "[RLPack 1.20 Basic Edition [aPLib] -> Ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 92 05 00 00 EB 0C 8B 85 8E 05 00 00 89 85 92 05 00 00 8D B5 BA 05 00 00 8D 9D 41 04 00 00 33 FF E8 38 01 00 00 EB 1B 8B 85 92 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 9E 05 00 00 00 74 0E 83 BD A2 05 00 00 00 74 05 E8 D6 01 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_01986_RLPack_1_20_Basic_Edition__LZMA_____Ap0x_
{
    meta:
        description = "[RLPack 1.20 Basic Edition [LZMA] -> Ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 9C 0C 00 00 EB 0C 8B 85 98 0C 00 00 89 85 9C 0C 00 00 8D B5 C4 0C 00 00 8D 9D 82 04 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 2D 0C 00 00 89 85 94 0C 00 00 E8 59 01 00 00 EB 20 60 8B 85 9C 0C 00 00 FF B5 94 0C 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_01987_RLPack_Full_Edition_1_17__LZMA__
{
    meta:
        description = "[RLPack Full Edition 1.17 (LZMA)]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 73 26 00 00 8D 9D 58 03 00 00 33 FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01988_RLPack_Full_Edition_1_17____Ap0x_
{
    meta:
        description = "[RLPack Full Edition 1.17 -> Ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_01989_RLPack_Full_Edition_1_17__aPLib__
{
    meta:
        description = "[RLPack Full Edition 1.17 [aPLib]]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 74 1F 00 00 8D 9D 1E 03 00 00 33 FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 0F FF 74 37 04 FF 34}
    condition:
        $a at pe.entry_point
}

rule PEiD_01990_RLPack_Full_Edition_1_17_DLL__LZMA__
{
    meta:
        description = "[RLPack Full Edition 1.17 DLL (LZMA)]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 5A 0A 00 00 8D 9D 40 02 00 00 33 FF E8 ?? ?? ?? ?? 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 EB 09 00 00 89 85}
    condition:
        $a at pe.entry_point
}

rule PEiD_01991_RLPack_Full_Edition_1_17_DLL____Ap0x_
{
    meta:
        description = "[RLPack Full Edition 1.17 DLL -> Ap0x]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_01992_RLPack_Full_Edition_1_17_DLL__aPLib__
{
    meta:
        description = "[RLPack Full Edition 1.17 DLL [aPLib]]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 53 03 00 00 8D 9D 02 02 00 00 33 FF E8 ?? ?? ?? ?? EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75}
    condition:
        $a at pe.entry_point
}

rule PEiD_01993_RLPack_Full_Edition_1_17_iBox__LZMA__
{
    meta:
        description = "[RLPack Full Edition 1.17 iBox (LZMA)]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 67 30 00 00 8D 9D 66 03 00 00 33 FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A}
    condition:
        $a at pe.entry_point
}

rule PEiD_01994_RLPack_Full_Edition_1_17_iBox__aPLib__
{
    meta:
        description = "[RLPack Full Edition 1.17 iBox [aPLib]]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 79 29 00 00 8D 9D 2C 03 00 00 33 FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 0F FF 74 37 04 FF 34}
    condition:
        $a at pe.entry_point
}

rule PEiD_01995_RLPack_V1_0_beta____ap0x___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.0.beta -> ap0x ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8D 64 24 04 8B 6C 24 FC 8D B5 4C 02 00 00 8D 9D 13 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01996_RLPack_V1_11____ap0x___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.11 -> ap0x ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 4A 02 00 00 8D 9D 11 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01997_RLPack_V1_12_V1_14__aPlib_0_43_____ap0x___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.12-V1.14 (aPlib 0.43) -> ap0x ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF EB 0F FF ?? ?? ?? FF ?? ?? ?? D3 83 C4 ?? 83 C7 ?? 83 3C 37 00 75 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_01998_RLPack_V1_12_V1_14__LZMA_4_30_____ap0x___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.12-V1.14 (LZMA 4.30) -> ap0x ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB ?? 60}
    condition:
        $a at pe.entry_point
}

rule PEiD_01999_RLPack_V1_15_V1_17__aPlib_0_43_____ap0x___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.15-V1.17 (aPlib 0.43) -> ap0x ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8 45 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_02000_RLPack_V1_15_V1_17__LZMA_4_30_____ap0x___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.15-V1.17 (LZMA 4.30) -> ap0x ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8 83 01 00 00 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB 14}
    condition:
        $a at pe.entry_point
}

rule PEiD_02001_RLPack_V1_15_V1_17_Dll____ap0x___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.15-V1.17 Dll -> ap0x ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 ?? 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02002_RLPack_V1_18__aPlib_0_43_____ap0x_
{
    meta:
        description = "[RLPack V1.18 (aPlib 0.43) -> ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 ?? 83 C7 ?? 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 BD 0A 04 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A ?? 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_02003_RLPack_V1_18__LZMA_4_30_____ap0x_
{
    meta:
        description = "[RLPack V1.18 (LZMA 4.30) -> ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A 00 00 FF 34 37 FF 74 37 04 FF D3 61 83 C7 ?? 83 3C 37 00 75 E6}
    condition:
        $a at pe.entry_point
}

rule PEiD_02004_RLPack_v1_18_Basic__aPLib_____Ap0x_
{
    meta:
        description = "[RLPack v1.18 Basic [aPLib] -> Ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_02005_RLPack_v1_18_Basic__LZMA_____Ap0x_
{
    meta:
        description = "[RLPack v1.18 Basic [LZMA] -> Ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_02006_RLPack_v1_18_Basic_DLL__aPLib_____Ap0x_
{
    meta:
        description = "[RLPack v1.18 Basic DLL [aPLib] -> Ap0x]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_02007_RLPack_v1_18_Basic_DLL__LZMA_____Ap0x_
{
    meta:
        description = "[RLPack v1.18 Basic DLL [LZMA] -> Ap0x]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A}
    condition:
        $a at pe.entry_point
}

rule PEiD_02008_RLPack_V1_18_Basic_Edition__aPlib_0_43_____ap0x_
{
    meta:
        description = "[RLPack V1.18 Basic Edition (aPlib 0.43) -> ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_02009_RLPack_V1_18_Basic_Edition__aPLib_or_LZMA_____ap0x_
{
    meta:
        description = "[RLPack V1.18 Basic Edition (aPLib or LZMA) -> ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? 00 00 8D 9D ?? 02 00 00 33 FF E8 ?? 01 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02010_RLPack_V1_18_Basic_Edition__LZMA_4_30_____ap0x_
{
    meta:
        description = "[RLPack V1.18 Basic Edition (LZMA 4.30) -> ap0x]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A 40 68 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02011_RLPack_V1_18_Dll__aPlib_0_43_____ap0x_
{
    meta:
        description = "[RLPack V1.18 Dll (aPlib 0.43) -> ap0x]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 5C 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 ?? 83 C7 ?? 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 BD 0A 04 00 00 00 74 05 E8 D7}
    condition:
        $a at pe.entry_point
}

rule PEiD_02012_RLPack_V1_18_Dll__LZMA_4_30_____ap0x_
{
    meta:
        description = "[RLPack V1.18 Dll (LZMA 4.30) -> ap0x]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 ?? 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8 9F 01 00 00 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A 00 00 FF 34 37 FF 74 37 04 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_02013_RLPack_V1_19__aPlib_0_43_____ap0x___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.19 (aPlib 0.43) -> ap0x ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 3C 04 00 00 EB 0C 8B 85 38 04 00 00 89 85 3C 04 00 00 8D B5 60 04 00 00 8D 9D EB 02 00 00 33 FF E8 52 01 00 00 EB 1B 8B 85 3C 04 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02014_RLPack_V1_19__aPlib_0_43_____ap0x_nbsp___nbsp___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.19 (aPlib 0.43) -> ap0x&nbsp; &nbsp;! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 3C 04 00 00 EB 0C 8B 85 38 04 00 00 89 85 3C 04 00 00 8D B5 60 04 00 00 8D 9D EB 02 00 00 33 FF E8 52 01 00 00 EB 1B 8B 85 3C 04 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 48 04 00 00 00 74 0E 83 BD 4C 04 00 00 00 74 05 E8 B8 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 D1 03 00 00 89 85 5C 04 00 00 5B FF B5 5C 04 00 00 56 FF D3 83 C4 08 8B B5 5C 04 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 E9 94 00 00 00 56 FF 95 C9 03 00 00 85 C0 0F 84 B4 00 00 00 89 85 54 04 00 00 8B C6 EB 5B 8B 85 58 04 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 58 04 00 00 C7 00 20 20 20 00 EB 06 FF B5 58 04 00 00 FF B5 54 04 00 00 FF 95 CD 03 00 00 85 C0 74 71 89 07 83 C7 04 8B 85 58 04 00 00 EB 01 40 80 38 00 75 FA 40 89 85 58 04 00 00 66 81 78 02 00 80 74 A5 80 38 00 75 A0 EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 80 3E 01 0F 85 63 FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 5C 04 00 00 FF 95 D5 03 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02015_RLPack_V1_19__LZMA_4_30_____ap0x___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.19 (LZMA 4.30) -> ap0x ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA 0A 00 00 89 85 41 0B 00 00 E8 76}
    condition:
        $a at pe.entry_point
}

rule PEiD_02016_RLPack_V1_19__LZMA_4_30_____ap0x_nbsp___nbsp___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.19 (LZMA 4.30) -> ap0x&nbsp; &nbsp;! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA 0A 00 00 89 85 41 0B 00 00 E8 76 01 00 00 EB 20 60 8B 85 49 0B 00 00 FF B5 41 0B 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD 55 0B 00 00 00 74 0E 83 BD 59 0B 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 DA 0A 00 00 89 85 69 0B 00 00 5B 60 FF B5 41 0B 00 00 56 FF B5 69 0B 00 00 FF D3 61 8B B5 69 0B 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 E9 98 00 00 00 56 FF 95 D2 0A 00 00 89 85 61 0B 00 00 85 C0 0F 84 C8 00 00 00 8B C6 EB 5F 8B 85 65 0B 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 65 0B 00 00 C7 00 20 20 20 00 EB 06 FF B5 65 0B 00 00 FF B5 61 0B 00 00 FF 95 D6 0A 00 00 85 C0 0F 84 87 00 00 00 89 07 83 C7 04 8B 85 65 0B 00 00 EB 01 40 80 38 00 75 FA 40 89 85 65 0B 00 00 66 81 78 02 00 80 74 A1 80 38 00 75 9C EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 80 3E 01 0F 85 5F FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 69 0B 00 00 FF 95 DE 0A 00 00 68 00 40 00 00 68 00 20 0C 00 FF B5 41 0B 00 00 FF 95 DE 0A 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02017_RLPack_V1_19_Dll__aPlib_0_43_____ap0x___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.19 Dll (aPlib 0.43) -> ap0x ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 89 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 3C 04 00 00 EB 0C 8B 85 38 04 00 00 89 85 3C 04 00 00 8D B5 60 04 00 00 8D 9D EB 02 00 00 33 FF E8 52 01 00 00 EB 1B 8B 85 3C 04 00 00 FF 74 37 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_02018_RLPack_V1_19_Dll__aPlib_0_43_____ap0x_nbsp___nbsp___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.19 Dll (aPlib 0.43) -> ap0x&nbsp; &nbsp;! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 89 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 3C 04 00 00 EB 0C 8B 85 38 04 00 00 89 85 3C 04 00 00 8D B5 60 04 00 00 8D 9D EB 02 00 00 33 FF E8 52 01 00 00 EB 1B 8B 85 3C 04 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 48 04 00 00 00 74 0E 83 BD 4C 04 00 00 00 74 05 E8 B8 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 D1 03 00 00 89 85 5C 04 00 00 5B FF B5 5C 04 00 00 56 FF D3 83 C4 08 8B B5 5C 04 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 E9 94 00 00 00 56 FF 95 C9 03 00 00 85 C0 0F 84 B4 00 00 00 89 85 54 04 00 00 8B C6 EB 5B 8B 85 58 04 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 58 04 00 00 C7 00 20 20 20 00 EB 06 FF B5 58 04 00 00 FF B5 54 04 00 00 FF 95 CD 03 00 00 85 C0 74 71 89 07 83 C7 04 8B 85 58 04 00 00 EB 01 40 80 38 00 75 FA 40 89 85 58 04 00 00 66 81 78 02 00 80 74 A5 80 38 00 75 A0 EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 80 3E 01 0F 85 63 FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 5C 04 00 00 FF 95 D5 03 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02019_RLPack_V1_19_Dll__LZMA_4_30_____ap0x___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.19 Dll (LZMA 4.30) -> ap0x ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 C7 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA}
    condition:
        $a at pe.entry_point
}

rule PEiD_02020_RLPack_V1_19_Dll__LZMA_4_30_____ap0x_nbsp___nbsp___Sign_by_fly_
{
    meta:
        description = "[RLPack V1.19 Dll (LZMA 4.30) -> ap0x&nbsp; &nbsp;! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {80 7C 24 08 01 0F 85 C7 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA 0A 00 00 89 85 41 0B 00 00 E8 76 01 00 00 EB 20 60 8B 85 49 0B 00 00 FF B5 41 0B 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD 55 0B 00 00 00 74 0E 83 BD 59 0B 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 DA 0A 00 00 89 85 69 0B 00 00 5B 60 FF B5 41 0B 00 00 56 FF B5 69 0B 00 00 FF D3 61 8B B5 69 0B 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 E9 98 00 00 00 56 FF 95 D2 0A 00 00 89 85 61 0B 00 00 85 C0 0F 84 C8 00 00 00 8B C6 EB 5F 8B 85 65 0B 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 65 0B 00 00 C7 00 20 20 20 00 EB 06 FF B5 65 0B 00 00 FF B5 61 0B 00 00 FF 95 D6 0A 00 00 85 C0 0F 84 87 00 00 00 89 07 83 C7 04 8B 85 65 0B 00 00 EB 01 40 80 38 00 75 FA 40 89 85 65 0B 00 00 66 81 78 02 00 80 74 A1 80 38 00 75 9C EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 80 3E 01 0F 85 5F FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 69 0B 00 00 FF 95 DE 0A 00 00 68 00 40 00 00 68 00 20 0C 00 FF B5 41 0B 00 00 FF 95 DE 0A 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02021_ROD_High_TECH____Ayman_
{
    meta:
        description = "[ROD High TECH -> Ayman]"
        ep_only = "true"
    strings:
        $a = {60 8B 15 1D 13 40 00 F7 E0 8D 82 83 19 00 00 E8 58 0C 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02022_RosAsm_2050a____Betov_
{
    meta:
        description = "[RosAsm 2050a -> Betov]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 60 8B 5D 08 B9 08 00 00 00 BF ?? ?? ?? ?? 83 C7 07 FD 8A C3 24 0F 04 30 3C 39 76 02 04 07 AA C1 EB 04 E2 EE FC 68 00 10 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? 61 8B E5 5D C2 04 00}
    condition:
        $a
}

rule PEiD_02023_RPolyCrypt_v_1_0__personal_polycryptor__sign_from_pinch_
{
    meta:
        description = "[RPolyCrypt v 1.0 (personal polycryptor) sign from pinch]"
        ep_only = "true"
    strings:
        $a = {50 58 97 97 60 61 8B 04 24 80 78 F3 6A E8 00 00 00 00 58 E8 00 00 00 00 58 91 91 EB 00 0F 85 6B F4 76 6F E8 00 00 00 00 83 C4 04 E8 00 00 00 00 58 90 E8 00 00 00 00 83 C4 04 8B 04 24 80 78 F1}
    condition:
        $a at pe.entry_point
}

rule PEiD_02024_Safe_2_0_
{
    meta:
        description = "[Safe 2.0]"
        ep_only = "false"
    strings:
        $a = {83 EC 10 53 56 57 E8 C4 01 00}
    condition:
        $a
}

rule PEiD_02025_SafeDisc_4_
{
    meta:
        description = "[SafeDisc 4]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 00 00 00 00 00 00 00 00 42 6F 47 5F}
    condition:
        $a
}

rule PEiD_02026_SafeDisc_SafeCast_2_xx___3_xx____Macrovision_
{
    meta:
        description = "[SafeDisc/SafeCast 2.xx - 3.xx -> Macrovision]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 60 BB ?? ?? ?? ?? 33 C9 8A 0D 3D ?? ?? ?? 85 C9 74 0C B8 ?? ?? ?? ?? 2B C3 83 E8 05 EB 0E 51 B9 ?? ?? ?? ?? 8B C1 2B C3 03 41 01 59 C6 03 E9 89 43 01 51 68 09 ?? ?? ?? 33 C0 85 C9 74 05 8B 45 08 EB 00 50 E8 76 00 00 00 83 C4 08 59 83 F8 00 74 1C}
    condition:
        $a
}

rule PEiD_02027_SafeDisc_SafeCast_2_xx___3_xx____Macrovision_
{
    meta:
        description = "[SafeDisc/SafeCast 2.xx - 3.xx -> Macrovision]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 60 BB ?? ?? ?? ?? 33 C9 8A 0D 3D ?? ?? ?? 85 C9 74 0C B8 ?? ?? ?? ?? 2B C3 83 E8 05 EB 0E 51 B9 ?? ?? ?? ?? 8B C1 2B C3 03 41 01 59 C6 03 E9 89 43 01 51 68 09 ?? ?? ?? 33 C0 85 C9 74 05 8B 45 08 EB 00 50 E8 76 00 00 00 83 C4 08 59 83 F8 00 74 1C C6 03 C2 C6 43 01 0C 85 C9 74 09 61 5D B8 00 00 00 00 EB 97 50 A1 29 ?? ?? ?? ?? D0 61 5D EB 46 80 7C 24 08 00 75 3F 51 8B 4C 24 04 89 0D ?? ?? ?? ?? B9 ?? ?? ?? ?? 89 4C 24 04 59 EB 28 50 B8 2D ?? ?? ?? ?? 70 08 8B 40 0C FF D0 B8 2D ?? ?? ?? ?? 30 8B 40 04 FF D0 58 FF 35 ?? ?? ?? ?? C3 72 16 61 13 60 0D E9 ?? ?? ?? ?? CC CC 81 EC E8 02 00 00 53 55 56 57}
    condition:
        $a at pe.entry_point
}

rule PEiD_02028_Safeguard_1_0____Simonzh_
{
    meta:
        description = "[Safeguard 1.0 -> Simonzh]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 EB 29}
    condition:
        $a at pe.entry_point
}

rule PEiD_02029_Sc_Obfuscator____SuperCRacker___Sign_by_fly_
{
    meta:
        description = "[Sc Obfuscator -> SuperCRacker ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 33 C9 8B 1D ?? ?? ?? ?? 03 1D ?? ?? ?? ?? 8A 04 19 84 C0 74 09 3C ?? 74 05 34 ?? 88 04 19 41 3B 0D ?? ?? ?? ?? 75 E7 A1 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? 61 FF 25 ?? ?? ?? ?? 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02030_SC_Obfuscator____SuperCRacker_
{
    meta:
        description = "[SC Obfuscator -> SuperCRacker]"
        ep_only = "true"
    strings:
        $a = {60 33 C9 8B 1D 00 ?? ?? ?? 03 1D 08 ?? ?? ?? 8A 04 19 84 C0 74 09 3C ?? 74 05 34 ?? 88 04 19 41 3B 0D 04 ?? ?? ?? 75 E7 A1 08 ?? ?? ?? 01 05 0C ?? ?? ?? 61 FF 25 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_02031_SCAN__AV_
{
    meta:
        description = "[SCAN /AV]"
        ep_only = "true"
    strings:
        $a = {1E 0E 1F B8 ?? ?? 8E C0 26 8A 1E ?? ?? 80 ?? ?? 72}
    condition:
        $a at pe.entry_point
}

rule PEiD_02032_SCRAM__v0_8a1_
{
    meta:
        description = "[SCRAM! v0.8a1]"
        ep_only = "true"
    strings:
        $a = {B4 30 CD 21 3C 02 77 ?? CD 20 BC ?? ?? B9 ?? ?? 8B FC B2 ?? 58 4C}
    condition:
        $a at pe.entry_point
}

rule PEiD_02033_SCRAM__vC5_
{
    meta:
        description = "[SCRAM! vC5]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? 50 9D 9C 58 25 ?? ?? 75 ?? BA ?? ?? B4 09 CD 21 CD 20}
    condition:
        $a at pe.entry_point
}

rule PEiD_02034_SDC_1_2__Self_Decrypting_Binary_Generator____by_Claes_M_Nyberg_
{
    meta:
        description = "[SDC 1.2 (Self Decrypting Binary Generator) - by Claes M Nyberg]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 A0 91 40 00 E8 DB FE FF FF 55 89 E5 53 83 EC 14 8B 45 08 8B 00 8B 00 3D 91 00 00 C0 77 3B 3D 8D 00 00 C0 72 4B BB 01 00 00 00 C7 44 24 04 00 00 00 00 C7 04 24 08 00 00 00 E8 CE 24 00 00 83 F8 01 0F 84 C4 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02035_SDC_1_2__Self_Decrypting_Binary_Generator____by_Claes_M_Nyberg_
{
    meta:
        description = "[SDC 1.2 (Self Decrypting Binary Generator) - by Claes M Nyberg]"
        ep_only = "true"
    strings:
        $a = {55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 A0 91 40 00 E8 DB FE FF FF 55 89 E5 53 83 EC 14 8B 45 08 8B 00 8B 00 3D 91 00 00 C0 77 3B 3D 8D 00 00 C0 72 4B BB 01 00 00 00 C7 44 24 04 00 00 00 00 C7 04 24 08 00 00 00 E8 CE 24 00 00 83 F8 01 0F 84 C4 00 00 00 85 C0 0F 85 A9 00 00 00 31 C0 83 C4 14 5B 5D C2 04 00 3D 94 00 00 C0 74 56 3D 96 00 00 C0 74 1E 3D 93 00 00 C0 75 E1 EB B5 3D 05 00 00 C0 8D B4 26 00 00 00 00 74 43 3D 1D 00 00 C0 75 CA C7 44 24 04 00 00 00 00 C7 04 24 04 00 00 00 E8 73 24 00 00 83 F8 01 0F 84 99 00 00 00 85 C0 74 A9 C7 04 24 04 00 00 00 FF D0 B8 FF FF FF FF EB 9B 31 DB 8D 74 26 00 E9 69 FF FF FF C7 44 24 04 00 00 00 00 C7 04 24 0B 00 00 00 E8 37 24 00 00 83 F8 01 74 7F 85 C0 0F 84 6D FF FF FF C7 04 24 0B 00 00 00 8D 76 00 FF D0 B8 FF FF FF FF E9 59 FF FF FF C7 04 24 08 00 00 00 FF D0 B8 FF FF FF FF E9 46 FF FF FF C7 44 24 04 01 00 00 00 C7 04 24 08 00 00 00 E8 ED 23 00 00 B8 FF FF FF FF 85 DB 0F 84 25 FF FF FF E8 DB 15 00 00 B8 FF FF FF FF E9 16 FF FF FF C7 44 24 04 01 00 00 00 C7 04 24 04 00 00 00 E8 BD 23 00 00 B8 FF FF FF FF E9 F8 FE FF FF C7 44 24 04 01 00 00 00 C7 04 24 0B 00 00 00 E8 9F 23 00 00 B8 FF FF FF FF E9 DA FE FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_02036_SDProtect____Randy_Li_
{
    meta:
        description = "[SDProtect -> Randy Li]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05}
    condition:
        $a at pe.entry_point
}

rule PEiD_02037_SDProtect________________Randy_Li_
{
    meta:
        description = "[SDProtect() -> Randy Li]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? 00 00 00}
    condition:
        $a
}

rule PEiD_02038_SDProtector_1_1x____Randy_Li_
{
    meta:
        description = "[SDProtector 1.1x -> Randy Li]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1}
    condition:
        $a at pe.entry_point
}

rule PEiD_02039_SDProtector_1_x____Randy_Li_
{
    meta:
        description = "[SDProtector 1.x -> Randy Li]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 20 33 C0 89 41 04 89 41}
    condition:
        $a at pe.entry_point
}

rule PEiD_02040_SDProtector_1_x____Randy_Li_
{
    meta:
        description = "[SDProtector 1.x -> Randy Li]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 20 33 C0 89 41 04 89 41 08 89 41 0C 89 41 10 59 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 33 C0 64 FF 30 64 89 20 9C 80 4C 24 01 01 9D 90 90 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 64 8F 00 58 74 07 75 05 19 32 67 E8 E8 74 27 75 25 EB 00 EB FC 68 39 44 CD 00 59 9C 50 74 0F 75 0D E8 59 C2 04 00 55 8B EC E9 FA FF FF 0E E8 EF FF FF FF 56 57 53 78 03 79 01 E8 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 7B 03 00 00 03 C8 74 C4 75 C2 E8 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02041_SDProtector_Basic_Pro_Edition_1_10____Randy_Li__h__
{
    meta:
        description = "[SDProtector Basic/Pro Edition 1.10 -> Randy Li (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 50 83 EC 08 64 A1 00 00 00 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 83 C4 08 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 64 8F 05 00 00 00 00 64 A3 00 00 00 00 83 C4 08 58 74 07 75 05 19 32 67 E8 E8 74 27 75 25 EB 00 EB FC 68 39 44 CD 00 59 9C 50 74 0F 75 0D E8 59 C2 04 00 55 8B EC E9 FA FF FF 0E E8 EF FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 59 03 00 00 03 C8 74 B8 75 B6 E8 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02042_SDProtector_Basic_Pro_Edition_1_10____Randy_Li_
{
    meta:
        description = "[SDProtector Basic/Pro Edition 1.10 -> Randy Li]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 50 83 EC 08 64 A1 00 00 00 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 83 C4 08 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 64}
    condition:
        $a at pe.entry_point
}

rule PEiD_02043_SDProtector_Basic_Pro_Edition_1_12____Randy_Li__h__
{
    meta:
        description = "[SDProtector Basic/Pro Edition 1.12 -> Randy Li (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 20 33 C0 89 41 04 89 41 08 89 41 0C 89 41 10 59 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 33 C0 64 FF 30 64 89 20 9C 80 4C 24 01 01 9D 90 90 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 64 8F 00 58 74 07 75 05 19 32 67 E8 E8 74 27 75 25 EB 00 EB FC 68 39 44 CD 00 59 9C 50 74 0F 75 0D E8 59 C2 04 00 55 8B EC E9 FA FF FF 0E E8 EF FF FF FF 56 57 53 78 03 79 01 E8 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 7B 03 00 00 03 C8 74 C4 75 C2 E8 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E2}
    condition:
        $a at pe.entry_point
}

rule PEiD_02044_SDProtector_Pro_1_12_
{
    meta:
        description = "[SDProtector Pro 1.12]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 20 33 C0 89 41 04 89 41 08 89 41 0C 89 41 10 59 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02045_SDProtector_Pro_Edition_1_16____Randy_Li__h__
{
    meta:
        description = "[SDProtector Pro Edition 1.16 -> Randy Li (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 18 33 C0 89 41 04 89 41 08 89 41 0C 89 41 10 59 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 33 C0 64 FF 30 64 89 20 9C 80 4C 24 01 01 9D 90 90 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 64 8F 00 58 74 07 75 05 19 32 67 E8 E8 74 27 75 25 EB 00 EB FC 68 39 44 CD 00 59 9C 50 74 0F 75 0D E8 59 C2 04 00 55 8B EC E9 FA FF FF 0E E8 EF FF FF FF 56 57 53 78 03 79 01 E8 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 93 03 00 00 03 C8 74 C4 75 C2 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02046_SDProtector_Pro_Edition_1_16____Randy_Li_
{
    meta:
        description = "[SDProtector Pro Edition 1.16 -> Randy Li]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 18 33 C0 89 41 04 89 41}
    condition:
        $a
}

rule PEiD_02047_SDProtector_V1_1X____Randy_Li___Sign_by_fly_
{
    meta:
        description = "[SDProtector V1.1X -> Randy Li ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? ?? ?? ?? 68 88 88 88 08 64 A1}
    condition:
        $a at pe.entry_point
}

rule PEiD_02048_SEA_AXE_v2_2_
{
    meta:
        description = "[SEA-AXE v2.2]"
        ep_only = "true"
    strings:
        $a = {FC BC ?? ?? 0E 1F A3 ?? ?? E8 ?? ?? A1 ?? ?? 8B ?? ?? ?? 2B C3 8E C0 B1 03 D3 E3 8B CB BF ?? ?? 8B F7 F3 A5}
    condition:
        $a at pe.entry_point
}

rule PEiD_02049_SEA_AXE_
{
    meta:
        description = "[SEA-AXE]"
        ep_only = "true"
    strings:
        $a = {FC BC ?? ?? 0E 1F E8 ?? ?? 26 A1 ?? ?? 8B 1E ?? ?? 2B C3 8E C0 B1 ?? D3 E3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02050_SecuPack_v1_5_
{
    meta:
        description = "[SecuPack v1.5]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 56 57 33 C0 89 45 F0 B8 CC 3A 40 ?? E8 E0 FC FF FF 33 C0 55 68 EA 3C 40 ?? 64 FF 30 64 89 20 6A ?? 68 80 ?? ?? ?? 6A 03 6A ?? 6A 01 ?? ?? ?? 80}
    condition:
        $a at pe.entry_point
}

rule PEiD_02051_SecureEXE_3_0____ZipWorx_
{
    meta:
        description = "[SecureEXE 3.0 -> ZipWorx]"
        ep_only = "true"
    strings:
        $a = {E9 B8 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02052_SecurePE_1_X____www_deepzone_org_
{
    meta:
        description = "[SecurePE 1.X -> www.deepzone.org]"
        ep_only = "true"
    strings:
        $a = {8B 04 24 E8 00 00 00 00 5D 81 ED 4C 2F 40 00 89 85 61 2F 40 00 8D 9D 65 2F 40 00 53 C3 00 00 00 00 8D B5 BA 2F 40 00 8B FE BB 65 2F 40 00 B9 C6 01 00 00 AD 2B C3 C1 C0 03 33 C3 AB 43 81 FB 8E 2F 40 00 75 05 BB 65 2F 40 00 E2 E7 89 AD 1A 31 40 00 89 AD 55 34 40 00 89 AD 68 34 40 00 8D 85 BA 2F 40 00 50 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02053_SecurePE_1_X_
{
    meta:
        description = "[SecurePE 1.X]"
        ep_only = "true"
    strings:
        $a = {8B 04 24 E8 00 00 00 00 5D 81 ED 4C 2F 40 00 89 85 61 2F 40 00 8D 9D 65 2F 40 00 53 C3 00 00 00 00 8D B5 BA 2F 40 00 8B FE BB 65 2F 40 00 B9 C6 01 00 00 AD 2B C3 C1 C0 03 33 C3 AB 43 81 FB 8E 2F 40 00 75 05 BB 65 2F 40 00 E2 E7 89 AD 1A 31 40 00 89 AD 55}
    condition:
        $a at pe.entry_point
}

rule PEiD_02054_SEN_Debug_Protector____
{
    meta:
        description = "[SEN Debug Protector???]"
        ep_only = "true"
    strings:
        $a = {BB ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? 29 ?? ?? 4E E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02055_Sentinel_SuperPro__Automatic_Protection__6_4_0____Safenet_
{
    meta:
        description = "[Sentinel SuperPro (Automatic Protection) 6.4.0 -> Safenet]"
        ep_only = "false"
    strings:
        $a = {68 ?? ?? ?? ?? 6A 01 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C9 3D B7 00 00 00 A1 ?? ?? ?? ?? 0F 94 C1 85 C0 89 0D ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 55 56 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 15}
    condition:
        $a
}

rule PEiD_02056_Sentinel_SuperPro__Automatic_Protection__6_4_1____Safenet_
{
    meta:
        description = "[Sentinel SuperPro (Automatic Protection) 6.4.1 -> Safenet]"
        ep_only = "false"
    strings:
        $a = {A1 ?? ?? ?? ?? 55 8B ?? ?? ?? 85 C0 74 ?? 85 ED 75 ?? A1 ?? ?? ?? ?? 50 55 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 55 51 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 6A 00 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 01 00 00 00 5D C2 0C 00}
    condition:
        $a
}

rule PEiD_02057_Sentinel_SuperPro__Automatic_Protection__v6_4_0____Safenet_
{
    meta:
        description = "[Sentinel SuperPro (Automatic Protection) v6.4.0 -> Safenet]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? 6A 01 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C9 3D B7 00 00 00 A1 ?? ?? ?? ?? 0F 94 C1 85 C0 89 0D ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 55 56 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 05 ?? ?? ?? ?? 25 FE FF DF 3F 0D 01 00 20 00 A3 ?? ?? ?? ?? 33 C0 50 C7 04 85 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 83 F8 64 7C ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 A1 ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 66 8B 55 00 83 C5 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_02058_Sentinel_SuperPro__Automatic_Protection__v6_4_1____Safenet_
{
    meta:
        description = "[Sentinel SuperPro (Automatic Protection) v6.4.1 -> Safenet]"
        ep_only = "true"
    strings:
        $a = {A1 ?? ?? ?? ?? 55 8B ?? ?? ?? 85 C0 74 ?? 85 ED 75 ?? A1 ?? ?? ?? ?? 50 55 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 55 51 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 6A 00 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 01 00 00 00 5D C2 0C 00 68 ?? ?? ?? ?? 6A 01 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C9 3D B7 00 00 00 A1 ?? ?? ?? ?? 0F 94 C1 85 C0 89 0D ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 56 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? 01 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 05 ?? ?? ?? ?? 25 FE FF DF 3F 0D 01 00 20 00 A3 ?? ?? ?? ?? 33 C0 50 C7 04 ?? ?? ?? ?? ?? 00 00 00 00 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02059_Setup_Factory_6_0_0_3_Setup_Launcher_
{
    meta:
        description = "[Setup Factory 6.0.0.3 Setup Launcher]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 90 61 40 00 68 70 3B 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 14 61 40 00 33 D2 8A D4 89 15 5C 89 40 00 8B C8 81 E1 FF 00 00 00 89 0D 58 89 40 00 C1 E1 08 03 CA 89 0D 54 89 40 00 C1 E8 10 A3 50 89}
    condition:
        $a
}

rule PEiD_02060_Setup_Factory_6_x_Custom_
{
    meta:
        description = "[Setup Factory 6.x Custom]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 ?? 61 40 00 68 ?? 43 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 ?? 61 40 00 33 D2 8A D4 89 15 A0 A9 40 00 8B C8 81 E1 FF 00 00 00 89 0D}
    condition:
        $a at pe.entry_point
}

rule PEiD_02061_Setup_Factory_v6_0_0_3_Setup_Launcher_
{
    meta:
        description = "[Setup Factory v6.0.0.3 Setup Launcher]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 90 61 40 00 68 70 3B 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 14 61 40 00 33 D2 8A D4 89 15 5C 89 40 00 8B C8 81 E1 FF 00 00 00 89 0D 58 89 40 00 C1 E1 08 03 CA 89 0D 54 89 40 00 C1 E8 10 A3 50 89 40 00 33 F6 56 E8 E0 00 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 E6 0F 00 00 FF 15 10 61 40 00 A3 40 8E 40 00 E8 A4 0E 00 00 A3 90 89 40 00 E8 4D 0C 00 00 E8 8F 0B 00 00 E8 22 FE FF FF 89 75 D0 8D 45 A4 50 FF 15 0C 61 40 00 E8 20 0B 00 00 89 45 9C F6 45 D0 01 74 06 0F B7 45 D4 EB 03 6A 0A 58 50 FF 75 9C 56 56 FF 15 08 61 40 00 50 E8 5A E9 FF FF 89 45 A0 50 E8 10 FE FF FF 8B 45}
    condition:
        $a
}

rule PEiD_02062_Setup2Go_Installer_Stub_
{
    meta:
        description = "[Setup2Go Installer Stub]"
        ep_only = "false"
    strings:
        $a = {5B 53 45 54 55 50 5F 49 4E 46 4F 5D 0D 0A 56 65 72}
    condition:
        $a
}

rule PEiD_02063_Sexe_Crypter_1_1___by_santasdad_
{
    meta:
        description = "[Sexe Crypter 1.1 - by santasdad]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 EC 53 56 57 33 C0 89 45 EC B8 D8 39 00 10 E8 30 FA FF FF 33 C0 55 68 D4 3A 00 10 64 FF 30 64 89 ?? ?? ?? ?? E4 3A 00 10 A1 00 57 00 10 50 E8 CC FA FF FF 8B D8 53 A1 00 57 00 10 50 E8 FE FA FF FF 8B F8 53 A1 00 57 00 10 50 E8 C8 FA FF FF 8B D8 53 E8 C8 FA FF FF 8B F0 85 F6 74 26 8B D7 4A B8 14 57 00 10 E8 AD F6 FF FF B8 14 57 00 10 E8 9B F6 FF FF 8B CF 8B D6 E8 DA FA FF FF 53 E8 84 FA FF FF 8D 4D EC BA F8 3A 00 10 A1 14 57 00 10 E8 0A FB FF FF 8B 55 EC B8 14 57 00 10 E8 65 F5 FF FF B8 14 57 00 10 E8 63 F6 FF FF E8 52 FC FF FF 33 C0 5A 59 59 64 89 10 68 DB 3A 00 10 8D 45 EC E8 ED F4 FF FF C3 E9 83 EF FF FF EB F0 5F 5E 5B E8 ED F3 FF FF 00 53 45 54 54 49 4E 47 53 00 00 00 00 FF FF FF FF 12 00 00 00 6B 75 74 68 37 36 67 62 62 67 36 37 34 76 38 38 67 79}
    condition:
        $a at pe.entry_point
}

rule PEiD_02064_Sharp_GPB_Graphics_format_
{
    meta:
        description = "[Sharp GPB Graphics format]"
        ep_only = "false"
    strings:
        $a = {4D 00 00 00 00 ?? ?? ?? ?? 08 00 00 00 03 00 00}
    condition:
        $a
}

rule PEiD_02065_Shegerd_Dongle_V4_78____MS_Co__
{
    meta:
        description = "[Shegerd Dongle V4.78 -> MS.Co.]"
        ep_only = "true"
    strings:
        $a = {E8 32 00 00 00 B8 ?? ?? ?? ?? 8B 18 C1 CB 05 89 DA 36 8B 4C 24 0C}
    condition:
        $a at pe.entry_point
}

rule PEiD_02066_ShellModify_0_1____pll621_
{
    meta:
        description = "[ShellModify 0.1 -> pll621]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 98 66 41 00 68 3C 3D 41 00 64 A1 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02067_shoooo_s_Pack____shoooo_
{
    meta:
        description = "[shoooo's Pack -> shoooo]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? E8 01 00 00 00 C3 C3 11 55 07 8B EC B8 ?? ?? ?? ?? E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02068_Shrink_v1_0_
{
    meta:
        description = "[Shrink v1.0]"
        ep_only = "true"
    strings:
        $a = {50 9C FC BE ?? ?? BF ?? ?? 57 B9 ?? ?? F3 A4 8B ?? ?? ?? BE ?? ?? BF ?? ?? F3 A4 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02069_Shrink_v2_0_
{
    meta:
        description = "[Shrink v2.0]"
        ep_only = "true"
    strings:
        $a = {E9 ?? ?? 50 9C FC BE ?? ?? 8B FE 8C C8 05 ?? ?? 8E C0 06 57 B9}
    condition:
        $a at pe.entry_point
}

rule PEiD_02070_Shrink_Wrap_v1_4_
{
    meta:
        description = "[Shrink Wrap v1.4]"
        ep_only = "true"
    strings:
        $a = {58 60 8B E8 55 33 F6 68 48 01 ?? ?? E8 49 01 ?? ?? EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_02071_Shrinker_3_2_
{
    meta:
        description = "[Shrinker 3.2]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 56 57 75 65 68 00 01 00 00 E8 F1 E6 FF FF 83 C4 04}
    condition:
        $a
}

rule PEiD_02072_Shrinker_3_3_
{
    meta:
        description = "[Shrinker 3.3]"
        ep_only = "false"
    strings:
        $a = {00 00 55 8B EC 56 57 75 65 68 00 01 00 00 E8}
    condition:
        $a
}

rule PEiD_02073_Shrinker_3_4_
{
    meta:
        description = "[Shrinker 3.4]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 56 57 75 6B 68 00 01 00 00 E8 11 0B 00 00 83 C4 04}
    condition:
        $a
}

rule PEiD_02074_Shrinker_v3_2_
{
    meta:
        description = "[Shrinker v3.2]"
        ep_only = "true"
    strings:
        $a = {83 3D ?? ?? ?? ?? ?? 55 8B EC 56 57 75 65 68 00 01 ?? ?? E8 ?? E6 FF FF 83 C4 04 8B 75 08 A3 ?? ?? ?? ?? 85 F6 74 1D 68 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_02075_Shrinker_v3_3_
{
    meta:
        description = "[Shrinker v3.3]"
        ep_only = "true"
    strings:
        $a = {83 3D ?? ?? ?? 00 00 55 8B EC 56 57 75 65 68 00 01 00 00 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02076_Shrinker_v3_4_
{
    meta:
        description = "[Shrinker v3.4]"
        ep_only = "true"
    strings:
        $a = {83 3D B4 ?? ?? ?? ?? 55 8B EC 56 57 75 6B 68 00 01 00 00 E8 ?? 0B 00 00 83 C4 04 8B 75 08 A3 B4 ?? ?? ?? 85 F6 74 23 83 7D 0C 03 77 1D 68 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_02077_Shrinker_v3_4_
{
    meta:
        description = "[Shrinker v3.4]"
        ep_only = "true"
    strings:
        $a = {BB ?? ?? BA ?? ?? 81 C3 07 00 B8 40 B4 B1 04 D3 E8 03 C3 8C D9 49 8E C1 26 03 0E 03 00 2B}
    condition:
        $a at pe.entry_point
}

rule PEiD_02078_Silicon_Realms_Install_Stub_
{
    meta:
        description = "[Silicon Realms Install Stub]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 ?? 92 40 00 68 ?? ?? 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 ?? ?? 40 00 33 D2 8A D4 89 15 ?? ?? 40 00 8B C8 81 E1 FF 00 00 00 89 0D ?? ?? 40 00 C1 E1 08 03 CA 89 0D ?? ?? 40 00 C1 E8 10 A3}
    condition:
        $a
}

rule PEiD_02079_Silicon_Realms_Install_Stub_
{
    meta:
        description = "[Silicon Realms Install Stub]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 6A FF 68 ?? 92 40 00 68 ?? ?? 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 ?? ?? 40 00 33 D2 8A D4 89 15 ?? ?? 40 00 8B C8 81 E1 FF 00 00 00 89 0D ?? ?? 40 00 C1 E1 08 03 CA 89 0D ?? ?? 40 00 C1 E8 10 A3 ?? ?? 40 00 33 F6 56 E8 ?? ?? 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 ?? ?? 00 00 FF 15 ?? 91 40 00 A3 ?? ?? 40 00 E8 ?? ?? 00 00 A3 ?? ?? 40 00 E8 ?? ?? 00 00 E8 ?? ?? 00 00 E8 ?? ?? FF FF 89 75 D0 8D 45 A4 50 FF 15 ?? 91 40 00 E8 ?? ?? 00 00 89 45 9C F6 45 D0 01 74 06 0F B7 45 D4 EB 03 6A 0A 58 50 FF 75 9C 56 56 FF 15 ?? 91 40 00 50 E8 ?? ?? FF FF 89 45 A0 50 E8 ?? ?? FF FF 8B 45 EC 8B 08 8B 09 89 4D 98 50 51 E8 ?? ?? 00 00 59 59 C3 8B 65 E8 FF 75 98 E8 ?? ?? FF FF 83 3D ?? ?? 40 00 01 75 05}
    condition:
        $a
}

rule PEiD_02080_SimbiOZ____Extranger_
{
    meta:
        description = "[SimbiOZ -> Extranger]"
        ep_only = "true"
    strings:
        $a = {50 60 E8 00 00 00 00 5D 81 ED 07 10 40 00 68 80 0B 00 00 8D 85 1F 10 40 00 50 E8 84 0B 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02081_SimbiOZ_1_3____Extranger_
{
    meta:
        description = "[SimbiOZ 1.3 -> Extranger]"
        ep_only = "true"
    strings:
        $a = {57 57 8D 7C 24 04 50 B8 00 ?? ?? ?? AB 58 5F C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02082_SimbiOZ_Poly_2_1____Extranger_
{
    meta:
        description = "[SimbiOZ Poly 2.1 -> Extranger]"
        ep_only = "true"
    strings:
        $a = {55 50 8B C4 83 C0 04 C7 00 ?? ?? ?? ?? 58 C3 90}
    condition:
        $a at pe.entry_point
}

rule PEiD_02083_SimbiOZ_PolyCryptor_v_xx___Extranger_
{
    meta:
        description = "[SimbiOZ PolyCryptor v.xx-> Extranger]"
        ep_only = "true"
    strings:
        $a = {55 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02084_Simple_UPX_Cryptor_V30_4_2005____MANtiCORE_
{
    meta:
        description = "[Simple UPX Cryptor V30.4.2005 -> MANtiCORE]"
        ep_only = "true"
    strings:
        $a = {60 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? ?? ?? ?? ?? E2 FA 61 68 ?? ?? ?? ?? C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02085_Simple_UPX_Cryptor_v30_4_2005__multi_layer_encryption_
{
    meta:
        description = "[Simple UPX Cryptor v30.4.2005 [multi layer encryption]"
        ep_only = "true"
    strings:
        $a = {60 B8 ?? ?? ?? 00 B9 18 00 00 00 80 34 08 ?? E2 FA 61 68 ?? ?? ?? 00 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02086_Simple_UPX_Cryptor_v30_4_2005__multi_layer_encryption_
{
    meta:
        description = "[Simple UPX Cryptor v30.4.2005 [multi layer encryption]"
        ep_only = "true"
    strings:
        $a = {60 B8 ?? ?? ?? ?? B9 18 00 00 00 80 34 08 ?? E2 FA 61 68 ?? ?? ?? ?? C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02087_Simple_UPX_Cryptor_v30_4_2005__One_layer_encryption_
{
    meta:
        description = "[Simple UPX Cryptor v30.4.2005 [One layer encryption]"
        ep_only = "true"
    strings:
        $a = {60 B8 ?? ?? ?? 00 B9 ?? 01 00 00 80 34 08 ?? E2 FA 61 68 ?? ?? ?? 00 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02088_SimplePack_1_11_Method_1____bagie_TMX_
{
    meta:
        description = "[SimplePack 1.11 Method 1 -> bagie[TMX]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5B 8D 5B FA BD 00 00 ?? ?? 8B 7D 3C 8D 74 3D 00 8D BE F8 00 00 00 0F B7 76 06 4E 8B 47 10 09 C0 74 55 0F B7 47 22 09 C0 74 4D 6A 04 68 00 10 00 00 FF 77 10 6A 00 FF 93 38 03 00 00 50 56 57 89 EE 03 77 0C 8B 4F 10 89 C7 89 C8 C1 E9 02 FC F3 A5 89 C1 83 E1 03 F3 A4 5F 5E 8B 04 24 89 EA 03 57 0C E8 3F 01 00 00 58 68 00 40 00 00 FF 77 10 50 FF 93 3C 03 00 00 83 C7 28 4E 75 9E BE ?? ?? ?? ?? 09 F6 0F 84 0C 01 00 00 01 EE 8B 4E 0C 09 C9 0F 84 FF 00 00 00 01 E9 89 CF 57 FF 93 30 03 00 00 09 C0 75 3D 6A 04 68 00 10 00 00 68 00 10 00 00 6A 00 FF 93 38 03 00 00 89 C6 8D 83 6F 02 00 00 57 50 56 FF 93 44 03 00 00 6A 10 6A 00 56 6A 00 FF 93 48 03 00 00 89 E5}
    condition:
        $a at pe.entry_point
}

rule PEiD_02089_SimplePack_1_11_Method_1____bagie_TMX__
{
    meta:
        description = "[SimplePack 1.11 Method 1 -> bagie[TMX]]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5B 8D 5B FA BD 00 00 ?? ?? 8B 7D 3C 8D 74 3D 00 8D BE F8 00 00 00 0F B7 76 06 4E 8B 47 10 09 C0 74 55 0F B7 47 22 09 C0 74 4D 6A 04 68 00 10 00 00 FF 77 10 6A 00 FF 93 38 03 00 00 50 56 57 89 EE 03 77 0C 8B 4F 10 89 C7 89 C8 C1 E9 02 FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_02090_SimplePack_1_11_Method_2_NT_____bagie_TMX__
{
    meta:
        description = "[SimplePack 1.11 Method 2(NT) -> bagie[TMX]]"
        ep_only = "true"
    strings:
        $a = {4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_02091_SimplePack_1_2_build_30_09__Method2_____bagie_
{
    meta:
        description = "[SimplePack 1.2.build.30.09 (Method2) -> bagie]"
        ep_only = "false"
    strings:
        $a = {4D 5A 90 EB 01 00 52 E9 86 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_02092_SimplePack_1_21_build_09_09__Method2_____bagie_
{
    meta:
        description = "[SimplePack 1.21.build.09.09 (Method2) -> bagie]"
        ep_only = "false"
    strings:
        $a = {4D 5A 90 EB 01 00 52 E9 8A 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_02093_SimplePack_1_X__Method2_____bagie_
{
    meta:
        description = "[SimplePack 1.X (Method2) -> bagie]"
        ep_only = "false"
    strings:
        $a = {4D 5A 90 EB 01 00 52 E9 ?? 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_02094_SimplePack_V1_0X____bagie___Sign_by_fly_
{
    meta:
        description = "[SimplePack V1.0X -> bagie ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5B 8D 5B FA 6A 00 FF 93 ?? ?? 00 00 89 C5 8B 7D 3C 8D 74 3D 00 8D BE F8 00 00 00 8B 86 88 00 00 00 09 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_02095_SimplePack_V1_1X__Method1_____bagie___Sign_by_fly_
{
    meta:
        description = "[SimplePack V1.1X (Method1) -> bagie ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5B 8D 5B FA BD ?? ?? ?? ?? 8B 7D 3C 8D 74 3D 00 8D BE F8 00 00 00 0F B7 76 06 4E 8B 47 10 09 C0}
    condition:
        $a at pe.entry_point
}

rule PEiD_02096_SimplePack_V1_1X__Method2_____bagie___Sign_by_fly_
{
    meta:
        description = "[SimplePack V1.1X (Method2) -> bagie ! Sign by fly]"
        ep_only = "false"
    strings:
        $a = {4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00}
    condition:
        $a
}

rule PEiD_02097_SimplePack_V1_1X__Method2_____bagie_
{
    meta:
        description = "[SimplePack V1.1X (Method2) -> bagie]"
        ep_only = "false"
    strings:
        $a = {4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04}
    condition:
        $a
}

rule PEiD_02098_SimplePack_V1_1X__Method2_____bagie_
{
    meta:
        description = "[SimplePack V1.1X (Method2) -> bagie]"
        ep_only = "false"
    strings:
        $a = {4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_02099_SimplePack_V1_1X_V1_2X__Method2_____bagie_
{
    meta:
        description = "[SimplePack V1.1X-V1.2X (Method2) -> bagie]"
        ep_only = "true"
    strings:
        $a = {4D 5A 90 EB 01 00 52 E9 ?? 01 00 00 50 45 00 00 4C 01 02 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02100_SimplePack_V1_2_build_30_09__Method2_____bagie_
{
    meta:
        description = "[SimplePack V1.2.build.30.09 (Method2) -> bagie]"
        ep_only = "true"
    strings:
        $a = {4D 5A 90 EB 01 00 52 E9 86 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_02101_SimplePack_V1_21_build_09_09__Method2_____bagie_
{
    meta:
        description = "[SimplePack V1.21.build.09.09 (Method2) -> bagie]"
        ep_only = "true"
    strings:
        $a = {4D 5A 90 EB 01 00 52 E9 8A 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_02102_SimplePack_V1_X__Method2_____bagie_
{
    meta:
        description = "[SimplePack V1.X (Method2) -> bagie]"
        ep_only = "true"
    strings:
        $a = {4D 5A 90 EB 01 00 52 E9 ?? 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_02103_SkD_Undetectabler_3__No_FSG_2_Method_____SkD_
{
    meta:
        description = "[SkD Undetectabler 3 (No FSG 2 Method) -> SkD]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 81 EC 10 02 00 00 68 00 02 00 00 8D 85 F8 FD FF FF 50 6A 00 FF 15 38 10 00 01 50 FF 15 3C 10 00 01 8D 8D F8 FD FF FF 51 E8 4F FB FF FF 83 C4 04 8B 15 ?? 16 00 01 52 A1 ?? 16 00 01 50 E8 50 FF FF FF 83 C4 08 A3 ?? 16 00 01 C7 85 F4 FD FF FF 00 00 00 00 EB 0F 8B 8D F4 FD FF FF 83 C1 01 89 8D F4 FD FF FF 8B 95 F4 FD FF FF 3B 15 ?? 16 00 01 73 1C 8B 85 F4 FD FF FF 8B 0D ?? 16 00 01 8D 54 01 07 81 FA 74 10 00 01 75 02 EB 02 EB C7 8B 85 F4 FD FF FF 50 E8 ?? 00 00 00 83 C4 04 89 85 F0 FD FF FF 8B 8D F0 FD FF FF 89 4D FC C7 45 F8 00 00 00 00 EB 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 3B 85 F4 FD FF FF 73 15 8B 4D FC 03 4D F8 8B 15 ?? 16 00 01 03 55 F8 8A 02 88 01 EB D7 83 3D ?? 16 00 01 00 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_02104_SkD_Undetectabler_Pro_2_0__No_UPX_Method_____SkD_
{
    meta:
        description = "[SkD Undetectabler Pro 2.0 (No UPX Method) -> SkD]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 B8 FC 26 00 10 E8 EC F3 FF FF 6A 0F E8 15 F5 FF FF E8 64 FD FF FF E8 BB ED FF FF 8D 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_02105_SLR__OPTLINK___1__
{
    meta:
        description = "[SLR (OPTLINK) (1)]"
        ep_only = "true"
    strings:
        $a = {87 C0 EB ?? 71 ?? 02 D8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02106_SLR__OPTLINK__
{
    meta:
        description = "[SLR (OPTLINK)]"
        ep_only = "true"
    strings:
        $a = {BF ?? ?? 8E DF FA 8E D7 81 C4 ?? ?? FB B4 30 CD 21}
    condition:
        $a at pe.entry_point
}

rule PEiD_02107_SLVc0deProtector_0_60____SLV___ICU_
{
    meta:
        description = "[SLVc0deProtector 0.60 -> SLV / ICU]"
        ep_only = "false"
    strings:
        $a = {EB 02 FA 04 E8 49 00 00 00 69 E8 49 00 00 00 95 E8 4F 00 00 00 68 E8 1F 00 00 00 49 E8 E9 FF FF FF 67 E8 1F 00 00 00 93 E8 31 00 00 00 78 E8 DD}
    condition:
        $a
}

rule PEiD_02108_SLVc0deProtector_1_1____SLV__h__
{
    meta:
        description = "[SLVc0deProtector 1.1 -> SLV (h)]"
        ep_only = "false"
    strings:
        $a = {E8 01 00 00 00 A0 5D EB 01 69 81 ED 5F 1A 40 00 8D 85 92 1A 40 00 F3 8D 95 83 1A 40 00 8B C0 8B D2 2B C2 83 E8 05 89 42 01 E8 FB FF FF FF 69 83 C4 08 E8 06 00 00 00 69 E8 F2 FF FF FF F3 B9 05 00 00 00 51 8D B5 BF 1A 40 00 8B FE B9 58 15 00 00 AC 32 C1 F6}
    condition:
        $a
}

rule PEiD_02109_SLVc0deProtector_1_1x____SLV___ICU_
{
    meta:
        description = "[SLVc0deProtector 1.1x -> SLV / ICU]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 58 C6 00 EB C6 40 01 08 FF E0 E9 4C ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02110_SLVc0deProtector_v1_1____SLV__h__
{
    meta:
        description = "[SLVc0deProtector v1.1 -> SLV (h)]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 58 C6 00 EB C6 40 01 08 FF E0 E9 4C}
    condition:
        $a at pe.entry_point
}

rule PEiD_02111_SLVc0deProtector_v1_1____SLV__h__
{
    meta:
        description = "[SLVc0deProtector v1.1 -> SLV (h)]"
        ep_only = "false"
    strings:
        $a = {E8 01 00 00 00 A0 5D EB 01 69 81 ED 5F 1A 40 00 8D 85 92 1A 40 00 F3 8D 95 83 1A 40 00 8B C0 8B D2 2B C2 83 E8 05 89 42 01 E8 FB FF FF FF 69 83 C4 08 E8 06 00 00 00 69 E8 F2 FF FF FF F3 B9 05 00 00 00 51 8D B5 BF 1A 40 00 8B FE B9 58 15 00 00 AC 32 C1 F6 D0 EB 01 00 D0 C0 FE C8 02 C1 AA E2 EF 59 E2 DE B7 FE AB E1 24 C8 0C 88 7A E1 B1 6A F7 95 83 1B A8 7F F8 A8 B0 1A 8B 08 91 47 6C 5A 88 6C 65 39 85 DB CB 54 3D B9 24 CF 4C AE C6 63 74 2C 63 F0 C8 18 0B 97 6B 79 63 A8 AB B8 78 A9 30 2F 2B DA 18 AC 35 45 36 BC 0D 7D 24 D1 51 3C E6 34 11 5A 43 06 24 89 FA 74 30}
    condition:
        $a
}

rule PEiD_02112_SmartE____Microsoft_
{
    meta:
        description = "[SmartE -> Microsoft]"
        ep_only = "true"
    strings:
        $a = {EB 15 03 00 00 00 ?? 00 00 00 00 00 00 00 00 00 00 00 68 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 1D 00 00 00 8B C5 55 60 9C 2B 85 8F 07 00 00 89 85 83 07 00 00 FF 74 24 2C E8 BB 01 00 00 0F 82 2F 06 00 00 E8 8E 04 00 00 49 0F 88 23 06}
    condition:
        $a at pe.entry_point
}

rule PEiD_02113_SmokesCrypt_v1_2_
{
    meta:
        description = "[SmokesCrypt v1.2]"
        ep_only = "true"
    strings:
        $a = {60 B8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 8A 14 08 80 F2 ?? 88 14 08 41 83 F9 ?? 75 F1}
    condition:
        $a at pe.entry_point
}

rule PEiD_02114_Soft_Defender_1_1x____Randy_Li_
{
    meta:
        description = "[Soft Defender 1.1x -> Randy Li]"
        ep_only = "true"
    strings:
        $a = {74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44}
    condition:
        $a at pe.entry_point
}

rule PEiD_02115_Soft_Defender_v1_0___v1_1_
{
    meta:
        description = "[Soft Defender v1.0 - v1.1]"
        ep_only = "true"
    strings:
        $a = {74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 CD ?? 59 9C 50 74 0A 75 08 E8 59 C2 04 ?? 55 8B EC E8 F4 FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 ?? ?? ?? ?? 58 05 BA 01 ?? ?? 03 C8 74 BE 75 BC E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02116_Soft_Defender_v1_12_
{
    meta:
        description = "[Soft Defender v1.12]"
        ep_only = "false"
    strings:
        $a = {74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 CD 00 59 9C 50 74 0A 75 08 E8 59 C2 04 00 55 8B EC E8 F4 FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 BE 01 00 00 03 C8 74 BD 75 BB E8}
    condition:
        $a
}

rule PEiD_02117_Soft_Defender_v1_1x____Randy_Li_
{
    meta:
        description = "[Soft Defender v1.1x -> Randy Li]"
        ep_only = "true"
    strings:
        $a = {74 07 75 05 ?? ?? ?? ?? ?? 74 1F 75 1D ?? 68 ?? ?? ?? 00 59 9C 50 74 0A 75 08 ?? 59 C2 04 00 ?? ?? ?? E8 F4 FF FF FF ?? ?? ?? 78 0F 79 0D}
    condition:
        $a at pe.entry_point
}

rule PEiD_02118_SoftComp_1_x____BG_Soft_PT_
{
    meta:
        description = "[SoftComp 1.x -> BG Soft PT]"
        ep_only = "false"
    strings:
        $a = {E8 00 00 00 00 81 2C 24 3A 10 41 00 5D E8 00 00 00 00 81 2C 24 31 01 00 00 8B 85 2A 0F 41 00 29 04 24 8B 04 24 89 85 2A 0F 41 00 58 8B 85 2A 0F 41 00}
    condition:
        $a
}

rule PEiD_02119_SoftDefender_1_x____Randy_Li_
{
    meta:
        description = "[SoftDefender 1.x -> Randy Li]"
        ep_only = "true"
    strings:
        $a = {74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 CD 00 59 9C 50 74 0A 75 08 E8 59 C2 04 00 55 8B EC E8 F4 FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 E6 01 00 00 03 C8 74 BD 75 BB E8 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02120_SoftDefender_1_x____Randy_Li_
{
    meta:
        description = "[SoftDefender 1.x -> Randy Li]"
        ep_only = "true"
    strings:
        $a = {74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 CD 00 59 9C 50 74 0A 75 08 E8 59 C2 04 00 55 8B EC E8 F4 FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 E6 01 00 00 03 C8 74 BD 75 BB E8 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02121_SoftProtect____SoftProtect_by_ru_
{
    meta:
        description = "[SoftProtect -> SoftProtect.by.ru]"
        ep_only = "true"
    strings:
        $a = {E8 0C 15 00 00 8D 85 2F 14 00 00 C7 00 00 00 00 00 E8 29 0F 00 00 E8 F6 14 00 00 8D 85 20 01 00 00 50 E8 AA 16 00 00 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_02122_SoftProtect____SoftProtect_by_ru_
{
    meta:
        description = "[SoftProtect -> SoftProtect.by.ru]"
        ep_only = "true"
    strings:
        $a = {EB 01 E3 60 E8 03 ?? ?? ?? D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 60 E8 03 ?? ?? ?? 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 EB 01 83 9C EB 01 D5 EB 08 35 9D EB 01 89 EB 03 0B EB F7 E8 ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 59 83 01 01 80 39 5C}
    condition:
        $a at pe.entry_point
}

rule PEiD_02123_SoftProtect____SoftProtect_by_ru_
{
    meta:
        description = "[SoftProtect -> SoftProtect.by.ru]"
        ep_only = "true"
    strings:
        $a = {EB 01 E3 60 E8 03 ?? ?? ?? D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 60 E8 03 ?? ?? ?? 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 EB 01 83 9C EB 01 D5 EB 08 35 9D EB 01 89 EB 03 0B EB F7 E8 ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 59 83 01 01 80 39 5C 75 F2 33 C4 74 0C 23 C4 0B C4 C6 01 59 C6 01 59 EB E2 90 E8 44 14 ?? ?? 8D 85 CF 13 ?? ?? C7 ?? ?? ?? ?? ?? E8 61 0E ?? ?? E8 2E 14 ?? ?? 8D 85 E4 01 ?? ?? 50 E8 E2 15 ?? ?? 83 BD 23 01 ?? ?? 01 75 07 E8 21 0D ?? ?? EB 09 8D 85 CF 13 ?? ?? 83 08 01 83 BD 1F 01 ?? ?? 01 75 07 E8 3E 0C ?? ?? EB 05 E8 A8 0C ?? ?? E8 B3 02 ?? ?? 8D 85 63 02 ?? ?? 50 E8 A3 15 ?? ?? 8D 85 F5 02 ?? ?? 50 E8 97 15 ?? ?? E8 E2 01 ?? ?? 8D 85 09 05 ?? ?? 50 E8 86 15 ?? ?? 8D 85 F8 0F ?? ?? 50 E8 7A 15 ?? ?? 8D 85 88 0F ?? ?? 50 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02124_SoftProtect____www_softprotect_by_ru_
{
    meta:
        description = "[SoftProtect -> www.softprotect.by.ru]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 ?? ?? ?? ?? ?? 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_02125_SoftSentry_v2_11_
{
    meta:
        description = "[SoftSentry v2.11]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC ?? 53 56 57 E9 50}
    condition:
        $a at pe.entry_point
}

rule PEiD_02126_SoftSentry_v3_0_
{
    meta:
        description = "[SoftSentry v3.0]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC ?? 53 56 57 E9 B0 06}
    condition:
        $a at pe.entry_point
}

rule PEiD_02127_Software_Compress____BG_Software_
{
    meta:
        description = "[Software Compress -> BG Software]"
        ep_only = "true"
    strings:
        $a = {E9 BE 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02128_Software_Compress____BG_Software_
{
    meta:
        description = "[Software Compress -> BG Software]"
        ep_only = "true"
    strings:
        $a = {E9 BE 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C3 60 FF 74 24 24 6A 40 FF 95 1A 0F 41 00 89 44 24 1C 61 C2 04 00 E8 00 00 00 00 81 2C 24 3A 10 41 00 5D E8 00 00 00 00 81 2C 24 31 01 00 00 8B 85 2A 0F 41 00 29 04 24 8B 04 24 89 85 2A 0F 41 00 58 8B 85 2A 0F 41 00 8B 50 3C 03 D0 8B 92 80 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02129_Software_Compress_v1_2____BG_Software_Protect_Technologies__h__
{
    meta:
        description = "[Software Compress v1.2 -> BG Software Protect Technologies (h)]"
        ep_only = "true"
    strings:
        $a = {E9 BE 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C3 60 FF 74 24 24 6A 40 FF 95 1A 0F 41 00 89 44 24 1C 61 C2 04 00 E8 00 00 00 00 81 2C 24 3A 10 41 00 5D E8 00 00 00 00 81 2C 24 31 01 00 00 8B 85 2A 0F 41 00 29 04 24}
    condition:
        $a at pe.entry_point
}

rule PEiD_02130_Software_Compress_V1_2____BG_Software_Protect_Technologies_
{
    meta:
        description = "[Software Compress V1.2 -> BG Software Protect Technologies]"
        ep_only = "true"
    strings:
        $a = {E9 BE 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02131_Software_Compress_v1_4_LITE____BG_Software_Protect_Technologies__h__
{
    meta:
        description = "[Software Compress v1.4 LITE -> BG Software Protect Technologies (h)]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 81 2C 24 AA 1A 41 00 5D E8 00 00 00 00 83 2C 24 6E 8B 85 5D 1A 41 00 29 04 24 8B 04 24 89 85 5D 1A 41 00 58 8B 85 5D 1A 41 00 8B 50 3C 03 D0 8B 92 80 00 00 00 03 D0 8B 4A 58 89 8D 49 1A 41 00 8B 4A 5C 89 8D 4D 1A 41 00 8B 4A 60 89 8D 55 1A}
    condition:
        $a at pe.entry_point
}

rule PEiD_02132_Software_Compress_v1_4_LITE____BG_Software_Protect_Technologies__h__
{
    meta:
        description = "[Software Compress v1.4 LITE -> BG Software Protect Technologies (h)]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 81 2C 24 AA 1A 41 00 5D E8 00 00 00 00 83 2C 24 6E 8B 85 5D 1A 41 00 29 04 24 8B 04 24 89 85 5D 1A 41 00 58 8B 85 5D 1A 41 00 8B 50 3C 03 D0 8B 92 80 00 00 00 03 D0 8B 4A 58 89 8D 49 1A 41 00 8B 4A 5C 89 8D 4D 1A 41 00 8B 4A 60 89 8D 55 1A 41 00 8B 4A 64 89 8D 51 1A 41 00 8B 4A 74 89 8D 59 1A 41 00 68 00 20 00 00 E8 D2 00 00 00 50 8D 8D 00 1C 41 00 50 51 E8 1B 00 00 00 83 C4 08 58 8D 78 74 8D B5 49 1A 41 00 B9 18 00 00 00 F3 A4 05 A4 00 00 00 50 C3 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C3 60 FF 74 24 24 6A 40 FF 95 4D 1A 41 00 89 44 24 1C 61 C2 04}
    condition:
        $a at pe.entry_point
}

rule PEiD_02133_SoftWrap_
{
    meta:
        description = "[SoftWrap]"
        ep_only = "true"
    strings:
        $a = {52 53 51 56 57 55 E8 ?? ?? ?? ?? 5D 81 ED 36 ?? ?? ?? E8 ?? 01 ?? ?? 60 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F}
    condition:
        $a at pe.entry_point
}

rule PEiD_02134_SOFTWrapper_for_Win9x_NT__Evaluation_Version__
{
    meta:
        description = "[SOFTWrapper for Win9x/NT (Evaluation Version)]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 5D 8B C5 2D ?? ?? ?? 00 50 81 ED 05 00 00 00 8B C5 2B 85 03 0F 00 00 89 85 03 0F 00 00 8B F0 03 B5 0B 0F 00 00 8B F8 03 BD 07 0F 00 00 83 7F 0C 00 74 2B 56 57 8B 7F 10 03 F8 8B 76 10 03 F0 83 3F 00 74 0C 8B 1E 89 1F 83 C6 04 83 C7 04 EB EF}
    condition:
        $a at pe.entry_point
}

rule PEiD_02135_SOFTWrapper_for_Win9x_NT__Evaluation_Version__
{
    meta:
        description = "[SOFTWrapper for Win9x/NT (Evaluation Version)]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 5D 8B C5 2D ?? ?? ?? 00 50 81 ED 05 00 00 00 8B C5 2B 85 03 0F 00 00 89 85 03 0F 00 00 8B F0 03 B5 0B 0F 00 00 8B F8 03 BD 07 0F 00 00 83 7F 0C 00 74 2B 56 57 8B 7F 10 03 F8 8B 76 10 03 F0 83 3F 00 74 0C 8B 1E 89 1F 83 C6 04 83 C7 04 EB EF 5F 5E 83 C6 14 83 C7 14 EB D3 00 00 00 00 8B F5 81 C6 0D 0A 00 00 B9 0C 00 00 00 8B 85 03 0F 00 00 01 46 02 83 C6 06 E2 F8 E8 06 08 00 00 68 00 01 00 00 8D 85 DD 0D 00 00 50 6A 00 E8 95 09 00 00 8B B5 03 0F 00 00 66 81 3E 4D 5A 75 33 03 76 3C 81 3E 50 45 00 00 75 28 8B 46 28 03 85 03 0F 00 00 3B C5 74 1B 6A 30 E8 99 09 00 00 6A 30 8D 85 DD 0D 00 00 50 8D 85 2B 0F 00 00 E9 55 03 00 00 66 8B 85 9D 0A 00 00 F6 C4 80 74 31 E8 6A 07 00 00 0B C0 75 23 6A 40 E8 69 09 00 00 6A 40 8D 85 DD 0D 00 00 50 8B 9D 17 0F}
    condition:
        $a at pe.entry_point
}

rule PEiD_02136_Spalsher_1_0___3_0____Amok_
{
    meta:
        description = "[Spalsher 1.0 - 3.0 -> Amok]"
        ep_only = "true"
    strings:
        $a = {9C 60 8B 44 24 24 E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02137_Spalsher_v1_0___v3_0_
{
    meta:
        description = "[Spalsher v1.0 - v3.0]"
        ep_only = "true"
    strings:
        $a = {9C 60 8B 44 24 24 E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? 50 E8 ED 02 ?? ?? 8C C0 0F 84}
    condition:
        $a at pe.entry_point
}

rule PEiD_02138_SPEC_b2_
{
    meta:
        description = "[SPEC b2]"
        ep_only = "true"
    strings:
        $a = {55 57 51 53 E8 ?? ?? ?? ?? 5D 8B C5 81 ED ?? ?? ?? ?? 2B 85 ?? ?? ?? ?? 83 E8 09 89 85 ?? ?? ?? ?? 0F B6}
    condition:
        $a at pe.entry_point
}

rule PEiD_02139_SPEC_b3_
{
    meta:
        description = "[SPEC b3]"
        ep_only = "true"
    strings:
        $a = {5B 53 50 45 43 5D E8 ?? ?? ?? ?? 5D 8B C5 81 ED 41 24 40 ?? 2B 85 89 26 40 ?? 83 E8 0B 89 85 8D 26 40 ?? 0F B6 B5 91 26 40 ?? 8B FD}
    condition:
        $a at pe.entry_point
}

rule PEiD_02140_Special_EXE_Password_Protector_v1_0_
{
    meta:
        description = "[Special EXE Password Protector v1.0]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 89 AD 8C 01 00 00 8B C5 2B 85 FE 75 00 00 89 85 3E 77}
    condition:
        $a at pe.entry_point
}

rule PEiD_02141_Special_EXE_Pasword_Protector_1_01__Eng_____Pavol_Cerven_
{
    meta:
        description = "[Special EXE Pasword Protector 1.01 (Eng) -> Pavol Cerven]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 89 AD 8C 01 00 00 8B C5 2B 85 FE 75 00 00 89 85 3E 77 00 00 8D 95 C6 77 00 00 8D 8D FF 77 00 00 55 68 00 20 00 00 51 52 6A 00 FF 95 04 7A 00 00 5D 6A 00 FF 95 FC 79 00 00 8D 8D 60 78 00 00 8D 95 85 01 00 00 55 68 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02142_Special_EXE_Pasword_Protector_v1_01__Eng_____Pavol_Cerven_
{
    meta:
        description = "[Special EXE Pasword Protector v1.01 (Eng) -> Pavol Cerven]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 89 AD 8C 01 00 00 8B C5 2B 85 FE 75 00 00 89 85 3E}
    condition:
        $a at pe.entry_point
}

rule PEiD_02143_Special_EXE_Pasword_Protector_v1_01__Eng_____Pavol_Cerven_
{
    meta:
        description = "[Special EXE Pasword Protector v1.01 (Eng) -> Pavol Cerven]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 89 AD 8C 01 00 00 8B C5 2B 85 FE 75 00 00 89 85 3E 77 00 00 8D 95 C6 77 00 00 8D 8D FF 77 00 00 55 68 00 20 00 00 51 52 6A 00 FF 95 04 7A 00 00 5D 6A 00 FF 95 FC 79 00 00 8D 8D 60 78 00 00 8D 95 85 01 00 00 55 68 00 04 00 00 52 6A 00 51 50 FF 95 08 7A 00 00 5D 8D B5 3F 78 00 00 6A 00 6A 00 6A 00 56 FF 95 0C 7A 00 00 0B C0 0F 84 FE 00 00 00 56 FF 95 10 7A 00 00 56 FF 95 14 7A 00 00 80 BD 3E 78 00 00 00 74 D4 33 D2 8B BD 3E 77 00 00 8D 85 1D 02 00 00 89 85 42 77 00 00 8D 85 49 02 00 00 89 85 46 77 00 00 8D 85 EB 75 00 00 89 85 4A 77 00 00 8B 84 D5 24 76 00 00 03 F8 8B 8C D5 28 76 00 00 3B 85 36 77 00 00 60 74 1F 8D B5 BD 02 00 00 FF D6 85 D2 75 11 60 87 FE 8D BD 15 78 00 00 B9 08 00 00 00 F3 A5 61 EB 15 8D 85 9F 02 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02144_Splash_Bitmap_v1_00__With_Unpack_Code_____BoB___Bobsoft_
{
    meta:
        description = "[Splash Bitmap v1.00 (With Unpack Code) -> BoB / Bobsoft]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 60 8B 6C 24 20 55 81 ED ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 29 F9 31 C0 FC F3 AA 8B 04 24 48 66 25 00 F0 66 81 38 4D 5A 75 F4 8B 48 3C 81 3C 01 50 45 00 00 75 E8 89 85 ?? ?? ?? ?? 6A 40}
    condition:
        $a at pe.entry_point
}

rule PEiD_02145_Splash_Bitmap_v1_00____BoB___Bobsoft_
{
    meta:
        description = "[Splash Bitmap v1.00 -> BoB / Bobsoft]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 60 8B 6C 24 20 55 81 ED ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 29 F9 31 C0 FC F3 AA 8B 04 24 48 66 25 00 F0 66 81 38 4D 5A 75 F4 8B 48 3C 81 3C 01 50 45 00 00 75 E8 89 85 ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 6A 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02146_SPLayer_v0_08_
{
    meta:
        description = "[SPLayer v0.08]"
        ep_only = "false"
    strings:
        $a = {8D 40 00 B9 ?? ?? ?? ?? 6A ?? 58 C0 0C ?? ?? 48 ?? ?? 66 13 F0 91 3B D9 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00}
    condition:
        $a
}

rule PEiD_02147_Splice_1_1___by_Tw1sted_L0gic_
{
    meta:
        description = "[Splice 1.1 - by Tw1sted L0gic]"
        ep_only = "true"
    strings:
        $a = {68 00 1A 40 00 E8 EE FF FF FF 00 00 00 00 00 00 30 00 00 00 40 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 ?? ?? ?? ?? ?? ?? 50 72 6F 6A 65 63 74 31 00 ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 06 00 00 00 AC}
    condition:
        $a at pe.entry_point
}

rule PEiD_02148_Splice_1_1___by_Tw1sted_L0gic_
{
    meta:
        description = "[Splice 1.1 - by Tw1sted L0gic]"
        ep_only = "true"
    strings:
        $a = {68 00 1A 40 00 E8 EE FF FF FF 00 00 00 00 00 00 30 00 00 00 40 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 ?? ?? ?? ?? ?? ?? 50 72 6F 6A 65 63 74 31 00 ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 06 00 00 00 AC 29 40 00 07 00 00 00 BC 28 40 00 07 00 00 00 74 28 40 00 07 00 00 00 2C 28 40 00 07 00 00 00 08 23 40 00 01 00 00 00 38 21 40 00 00 00 00 00 FF FF FF FF FF FF FF FF 00 00 00 00 8C 21 40 00 08 ?? 40 00 01 00 00 00 AC 19 40 00 00 00 00 00 00 00 00 00 00 00 00 00 AC 19 40 00 4F 00 43 00 50 00 00 00 E7 AF 58 2F 9A 4C 17 4D B7 A9 CA 3E 57 6F F7 76}
    condition:
        $a at pe.entry_point
}

rule PEiD_02149_ST_Protector_V1_5____Silent_Software_
{
    meta:
        description = "[ST Protector V1.5 -> Silent Software]"
        ep_only = "false"
    strings:
        $a = {00 00 00 00 4B 65 52 6E 45 6C 33 32 2E 64 4C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00}
    condition:
        $a
}

rule PEiD_02150_StarForce_Protection_Driver____Protection_Technology__h__
{
    meta:
        description = "[StarForce Protection Driver -> Protection Technology (h)]"
        ep_only = "true"
    strings:
        $a = {57 68 ?? 0D 01 00 68 00 ?? ?? 00 E8 50 ?? FF FF 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02151_StarForce_V3_X____StarForce_Copy_Protection_System_
{
    meta:
        description = "[StarForce V3.X -> StarForce Copy Protection System]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02152_StarForce_V3_X_DLL____StarForce_Copy_Protection_System_
{
    meta:
        description = "[StarForce V3.X DLL -> StarForce Copy Protection System]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? ?? ?? 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02153_Stealth_PE_v1_1_
{
    meta:
        description = "[Stealth PE v1.1]"
        ep_only = "true"
    strings:
        $a = {BA ?? ?? ?? 00 FF E2 BA ?? ?? ?? 00 B8 ?? ?? ?? ?? 89 02 83 C2 03 B8 ?? ?? ?? ?? 89 02 83 C2 FD FF E2}
    condition:
        $a at pe.entry_point
}

rule PEiD_02154_STNPEE_1_13_
{
    meta:
        description = "[STNPEE 1.13]"
        ep_only = "true"
    strings:
        $a = {55 57 56 52 51 53 E8 00 00 00 00 5D 8B D5 81 ED 97 3B 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02155_Stone_s_PE_Encryptor_v1_0_
{
    meta:
        description = "[Stone's PE Encryptor v1.0]"
        ep_only = "true"
    strings:
        $a = {55 57 56 52 51 53 E8 ?? ?? ?? ?? 5D 8B D5 81 ED 63 3A 40 ?? 2B 95 C2 3A 40 ?? 83 EA 0B 89 95 CB 3A 40 ?? 8D B5 CA 3A 40 ?? 0F B6 36}
    condition:
        $a at pe.entry_point
}

rule PEiD_02156_Stone_s_PE_Encryptor_v1_13_
{
    meta:
        description = "[Stone's PE Encryptor v1.13]"
        ep_only = "true"
    strings:
        $a = {55 57 56 52 51 53 E8 ?? ?? ?? ?? 5D 8B D5 81 ED 97 3B 40 ?? 2B 95 2D 3C 40 ?? 83 EA 0B 89 95 36 3C 40 ?? 01 95 24 3C 40 ?? 01 95 28}
    condition:
        $a at pe.entry_point
}

rule PEiD_02157_Stone_s_PE_Encryptor_v2_0_
{
    meta:
        description = "[Stone's PE Encryptor v2.0]"
        ep_only = "true"
    strings:
        $a = {53 51 52 56 57 55 E8 ?? ?? ?? ?? 5D 81 ED 42 30 40 ?? FF 95 32 35 40 ?? B8 37 30 40 ?? 03 C5 2B 85 1B 34 40 ?? 89 85 27 34 40 ?? 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_02158_Stone_s_PE_Encruptor_v1_13_
{
    meta:
        description = "[Stone`s PE Encruptor v1.13]"
        ep_only = "true"
    strings:
        $a = {55 57 56 52 51 53 E8 ?? ?? ?? ?? 5D 8B D5 81}
    condition:
        $a at pe.entry_point
}

rule PEiD_02159_Stony_Brook_Pascal_v6_14_
{
    meta:
        description = "[Stony Brook Pascal v6.14]"
        ep_only = "true"
    strings:
        $a = {31 ED 9A ?? ?? ?? ?? 55 89 E5 ?? EC ?? ?? 9A}
    condition:
        $a at pe.entry_point
}

rule PEiD_02160_Stony_Brook_Pascal__v7_0_
{
    meta:
        description = "[Stony Brook Pascal+ v7.0]"
        ep_only = "true"
    strings:
        $a = {31 ED 9A ?? ?? ?? ?? 55 89 E5 81 EC ?? ?? B8 ?? ?? 0E 50 9A ?? ?? ?? ?? BE ?? ?? 1E 0E BF ?? ?? 1E 07 1F FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_02161_Stranik_1_3_Modula_C_Pascal_
{
    meta:
        description = "[Stranik 1.3 Modula/C/Pascal]"
        ep_only = "true"
    strings:
        $a = {E8 ?? ?? FF FF E8 ?? ?? FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02162_STUD_RC4_1_0_Jamie_Edition__ScanTime_UnDetectable____by_MarjinZ_
{
    meta:
        description = "[STUD RC4 1.0 Jamie Edition (ScanTime UnDetectable) - by MarjinZ]"
        ep_only = "true"
    strings:
        $a = {68 2C 11 40 00 E8 F0 FF FF FF 00 00 00 00 00 00 30 00 00 00 38 00 00 00 00 00 00 00 37 BB 71 EC A4 E1 98 4C 9B FE 8F 0F FA 6A 07 F6 00 00 00 00 00 00 01 00 00 00 20 20 46 6F 72 20 73 74 75 64 00 20 54 6F 00 00 00 00 06 00 00 00 CC 1A 40 00 07 00 00 00 D4}
    condition:
        $a at pe.entry_point
}

rule PEiD_02163_STUD_RC4_1_0_Jamie_Edition__ScanTime_UnDetectable____by_MarjinZ_
{
    meta:
        description = "[STUD RC4 1.0 Jamie Edition (ScanTime UnDetectable) - by MarjinZ]"
        ep_only = "true"
    strings:
        $a = {68 2C 11 40 00 E8 F0 FF FF FF 00 00 00 00 00 00 30 00 00 00 38 00 00 00 00 00 00 00 37 BB 71 EC A4 E1 98 4C 9B FE 8F 0F FA 6A 07 F6 00 00 00 00 00 00 01 00 00 00 20 20 46 6F 72 20 73 74 75 64 00 20 54 6F 00 00 00 00 06 00 00 00 CC 1A 40 00 07 00 00 00 D4 18 40 00 07 00 00 00 7C 18 40 00 07 00 00 00 2C 18 40 00 07 00 00 00 E0 17 40 00 56 42 35 21 F0 1F 2A 00 00 00 00 00 00 00 00 00 00 00 00 00 7E 00 00 00 00 00 00 00 00 00 00 00 00 00 0A 00 09 04 00 00 00 00 00 00 E8 13 40 00 F4 13 40 00 00 F0 30 00 00 FF FF FF 08 00 00 00 01 00 00 00 00 00 00 00 E9 00 00 00 04 11 40 00 04 11 40 00 C8 10 40 00 78 00 00 00 7C 00 00 00 81 00 00 00 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 61 61 61 00 53 74 75 64 00 00 73 74 75 64 00 00 01 00 01 00 30 16 40 00 00 00 00 00 FF FF FF FF FF FF FF FF 00 00 00 00 B4 16 40 00 10 30 40 00 07 00 00 00 24 12 40 00 0E 00 20 00 00 00 00 00 1C 9E 21 00 EC 11 40 00 5C 10 40 00 E4 1A 40 00 2C 34 40 00 68 17 40 00 58 17 40 00 78 17 40 00 8C 17 40 00 8C 10 40 00 62 10 40 00 92 10 40 00 F8 1A 40 00 24 19 40 00 98 10 40 00 9E 10 40 00 77 04 18 FF 04 1C FF 05 00 00 24 01 00 0D 14 00 78 1C 40 00 48 21 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02164_SuckStop_v1_11_
{
    meta:
        description = "[SuckStop v1.11]"
        ep_only = "true"
    strings:
        $a = {EB ?? ?? ?? BE ?? ?? B4 30 CD 21 EB ?? 9B}
    condition:
        $a at pe.entry_point
}

rule PEiD_02165_Sun_Icon_Graphics_format_
{
    meta:
        description = "[Sun Icon Graphics format]"
        ep_only = "false"
    strings:
        $a = {2F 2A 20 46 6F 72 6D 61 74 5F 76 65 72 73 69 6F 6E 3D 31 2C}
    condition:
        $a
}

rule PEiD_02166_SuperDAT_
{
    meta:
        description = "[SuperDAT]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 6A FF 68 40 F3 42 00 68 A4 BF 42 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 08 F2 42 00 33 D2 8A D4 89 15 60 42 43 00 8B C8 81 E1 FF 00 00 00 89 0D}
    condition:
        $a at pe.entry_point
}

rule PEiD_02167_SVK_Protector_1_32__Eng_____Pavol_Cerven_
{
    meta:
        description = "[SVK Protector 1.32 (Eng) -> Pavol Cerven]"
        ep_only = "false"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 06 36 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E}
    condition:
        $a
}

rule PEiD_02168_SVK_Protector_1_3x__Eng_____Pavol_Cerven_
{
    meta:
        description = "[SVK Protector 1.3x (Eng) -> Pavol Cerven]"
        ep_only = "false"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 ?? ?? 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E}
    condition:
        $a
}

rule PEiD_02169_SVK_Protector_v1_32__Eng_____Pavol_Cerven_
{
    meta:
        description = "[SVK Protector v1.32 (Eng) -> Pavol Cerven]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 06 36 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 0C 61 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 18 61 00 00 5D 6A FF FF 95 10 61 00 00 44 65 62 75 67 67 65 72 20 6F 72 20 74 6F 6F 6C 20 66 6F 72 20 6D 6F 6E 69 74 6F 72 69 6E 67 20 64 65 74 65 63 74 65 64 21 21 21 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02170_SVK_Protector_v1_3x__Eng_____Pavol_Cerven_
{
    meta:
        description = "[SVK Protector v1.3x (Eng) -> Pavol Cerven]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 ?? ?? 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 0C 61 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 18 61 00 00 5D 6A FF FF 95 10 61 00 00 44 65 62 75 67 67 65 72 20 6F 72 20 74 6F 6F 6C 20 66 6F 72 20 6D 6F 6E 69 74 6F 72 69 6E 67 20 64 65 74 65 63 74 65 64 21 21 21 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02171_SVK_Protector_v1_051_
{
    meta:
        description = "[SVK-Protector v1.051]"
        ep_only = "true"
    strings:
        $a = {60 EB 03 C7 84 E8 EB 03 C7 84 9A E8 00 00 00 00 5D 81 ED 10 00 00 00 EB 03 C7 84 E9 64 A0 23 00 00 00 EB}
    condition:
        $a at pe.entry_point
}

rule PEiD_02172_SVK_Protector_v1_11_
{
    meta:
        description = "[SVK-Protector v1.11]"
        ep_only = "true"
    strings:
        $a = {60 E8 ?? ?? ?? ?? 5D 81 ED 06 ?? ?? ?? 64 A0 23}
    condition:
        $a at pe.entry_point
}

rule PEiD_02173_SVK_Protector_v1_32_
{
    meta:
        description = "[SVK-Protector v1.32]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 06 36 42 00 64 A0 23}
    condition:
        $a at pe.entry_point
}

rule PEiD_02174_SVKP_v1_32____Pavol_Cerven__h__
{
    meta:
        description = "[SVKP v1.32 -> Pavol Cerven (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 06 36 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 0C 61 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 18 61 00 00 5D 6A FF FF 95 10 61}
    condition:
        $a at pe.entry_point
}

rule PEiD_02175_SVKP_v1_42____Pavol_Cerven__h__
{
    meta:
        description = "[SVKP v1.42 -> Pavol Cerven (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 49 DC EC 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 2D 67 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 2D 67 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 39 67 00 00 5D 6A FF FF 95 31 67}
    condition:
        $a at pe.entry_point
}

rule PEiD_02176_SVKP_v1_43____Pavol_Cerven__h__
{
    meta:
        description = "[SVKP v1.43 -> Pavol Cerven (h)]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 49 DC CE 05 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 2D 67 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 2D 67 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 39 67 00 00 5D 6A FF FF 95 31 67}
    condition:
        $a at pe.entry_point
}

rule PEiD_02177_Symantec_C_v2_10__v4_00_or_Zortech_C_v3_0r1_
{
    meta:
        description = "[Symantec C v2.10, v4.00 or Zortech C v3.0r1]"
        ep_only = "true"
    strings:
        $a = {FA FC B8 ?? ?? 8E D8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02178_Symantec_C_v4_00___Libraries_
{
    meta:
        description = "[Symantec C v4.00 + Libraries]"
        ep_only = "true"
    strings:
        $a = {FA B8 ?? ?? DB E3 8E D8 8C 06 ?? ?? 8B D8 2B 1E ?? ?? 89 1E ?? ?? 26}
    condition:
        $a at pe.entry_point
}

rule PEiD_02179_Symantec_Visual_Cafe_v3_0_
{
    meta:
        description = "[Symantec Visual Cafe v3.0]"
        ep_only = "true"
    strings:
        $a = {64 8B 05 ?? ?? ?? ?? 55 8B EC 6A FF 68 ?? ?? 40 ?? 68 ?? ?? 40 ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 08 50 53 56 57 89 65 E8 C7 45 FC}
    condition:
        $a at pe.entry_point
}

rule PEiD_02180_Symantec_WinFax_PRO_7_5_Coverpage_
{
    meta:
        description = "[Symantec WinFax PRO 7.5 Coverpage]"
        ep_only = "false"
    strings:
        $a = {0C BD 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 06 80}
    condition:
        $a
}

rule PEiD_02181_Symantec_WinFax_PRO_8_3_Coverpage_Quick_CoverPage_
{
    meta:
        description = "[Symantec WinFax PRO 8.3 Coverpage Quick CoverPage]"
        ep_only = "false"
    strings:
        $a = {FF FF ?? ?? ?? ?? ?? 43 6F 76 65 72 44 61 74 61 62 61 73 65}
    condition:
        $a
}

rule PEiD_02182_Symantec_WinFax_PRO_8_3_Coverpage_
{
    meta:
        description = "[Symantec WinFax PRO 8.3 Coverpage]"
        ep_only = "false"
    strings:
        $a = {0C BD 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 06 6C}
    condition:
        $a
}

rule PEiD_02183_T_PACK_v0_5c__m1_
{
    meta:
        description = "[T-PACK v0.5c -m1]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? FD 60 BE ?? ?? BF ?? ?? B9 ?? ?? F3 A4 8B F7 BF ?? ?? FC 46 E9 8E FE}
    condition:
        $a at pe.entry_point
}

rule PEiD_02184_T_PACK_v0_5c__m2_
{
    meta:
        description = "[T-PACK v0.5c -m2]"
        ep_only = "true"
    strings:
        $a = {68 ?? ?? FD 60 BE ?? ?? BF ?? ?? B9 ?? ?? F3 A4 8B F7 BF ?? ?? FC 46 E9 CE FD}
    condition:
        $a at pe.entry_point
}

rule PEiD_02185_TASM___MASM_
{
    meta:
        description = "[TASM / MASM]"
        ep_only = "true"
    strings:
        $a = {6A 00 E8 ?? ?? 00 00 A3 ?? ?? 40 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02186_tElock_0_51____tE__
{
    meta:
        description = "[tElock 0.51 -> tE!]"
        ep_only = "true"
    strings:
        $a = {C1 EE 00 66 8B C9 EB 01 EB 60 EB 01 EB 9C E8 00 00 00 00 5E 83 C6 5E 8B FE 68 79 01 00 00 59 EB 01 EB AC 54 E8 03 00 00 00 5C EB 08 8D 64 24 04 FF 64 24 FC 6A 05 D0 2C 24 72 01 E8 01 24 24 5C F7 DC EB 02 CD 20 8D 64 24 FE F7 DC EB 02 CD 20 FE C8 E8 00 00 00 00 32 C1 EB 02 82 0D AA EB 03 82 0D 58 EB 02 1D 7A 49 EB 05 E8 01 00 00 00 7F AE 14 7E A0 77 76 75 74}
    condition:
        $a at pe.entry_point
}

rule PEiD_02187_tElock_0_96____tE__
{
    meta:
        description = "[tElock 0.96 -> tE!]"
        ep_only = "true"
    strings:
        $a = {E9 59 E4 FF FF 00 00 00 00 00 00 00 ?? ?? ?? ?? EE ?? ?? 00 00 00 00 00 00 00 00 00 0E ?? ?? 00 FE ?? ?? 00 F6 ?? ?? 00 00 00 00 00 00 00 00 00 1B ?? ?? 00 06 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 26 ?? ?? 00 00 00 00 00 39 ?? ?? 00 00 00 00 00 26 ?? ?? 00 00 00 00 00 39 ?? ?? 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C}
    condition:
        $a at pe.entry_point
}

rule PEiD_02188_tElock_0_98____tE__
{
    meta:
        description = "[tElock 0.98 -> tE!]"
        ep_only = "true"
    strings:
        $a = {E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? 1E ?? ?? 00 00 00 00 00 00 00 00 00 3E ?? ?? 00 2E ?? ?? 00 26 ?? ?? 00 00 00 00 00 00 00 00 00 4B ?? ?? 00 36 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 56 ?? ?? 00 00 00 00 00 69 ?? ?? 00 00 00 00 00 56 ?? ?? 00 00 00 00 00 69 ?? ?? 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 75 73 65}
    condition:
        $a at pe.entry_point
}

rule PEiD_02189_tElock_0_98____tHE_EGOiSTE__h__
{
    meta:
        description = "[tElock 0.98 -> tHE EGOiSTE (h)]"
        ep_only = "false"
    strings:
        $a = {E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00}
    condition:
        $a
}

rule PEiD_02190_tElock_0_98_Special_Build____forgot___heXer_
{
    meta:
        description = "[tElock 0.98 Special Build -> forgot & heXer]"
        ep_only = "true"
    strings:
        $a = {E9 99 D7 FF FF 00 00 00 ?? ?? ?? ?? AA ?? ?? 00 00 00 00 00 00 00 00 00 CA}
    condition:
        $a at pe.entry_point
}

rule PEiD_02191_tElock_0_99___1_0_private____tE__
{
    meta:
        description = "[tElock 0.99 - 1.0 private -> tE!]"
        ep_only = "true"
    strings:
        $a = {E9 ?? ?? FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02192_tElock_0_99____tE__
{
    meta:
        description = "[tElock 0.99 -> tE!]"
        ep_only = "true"
    strings:
        $a = {E9 5E DF FF FF 00 00 00 ?? ?? ?? ?? E5 ?? ?? 00 00 00 00 00 00 00 00 00 05}
    condition:
        $a at pe.entry_point
}

rule PEiD_02193_tElock_0_99_Special_Build____heXer___forgot_
{
    meta:
        description = "[tElock 0.99 Special Build -> heXer & forgot]"
        ep_only = "false"
    strings:
        $a = {E9 5E DF FF FF 00 00 00 ?? ?? ?? ?? E5 ?? ?? 00 00 00 00 00 00 00 00 00 05 ?? ?? 00 F5 ?? ?? 00 ED ?? ?? 00 00 00 00 00 00 00 00 00 12 ?? ?? 00 FD ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 1D ?? ?? 00 00 00 00 00 30 ?? ?? 00 00}
    condition:
        $a
}

rule PEiD_02194_tElock_0_99_
{
    meta:
        description = "[tElock 0.99]"
        ep_only = "false"
    strings:
        $a = {E9 ?? ?? FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? 02 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? 02 00 00}
    condition:
        $a
}

rule PEiD_02195_tElock_0_99c__Private_ECLIPSE_____tE__
{
    meta:
        description = "[tElock 0.99c (Private ECLIPSE) -> tE!]"
        ep_only = "true"
    strings:
        $a = {E9 3F DF FF FF 00 00 00 ?? ?? ?? ?? 04 ?? ?? 00 00 00 00 00 00 00 00 00 24 ?? ?? 00 14 ?? ?? 00 0C ?? ?? 00 00 00 00 00 00 00 00 00 31 ?? ?? 00 1C ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 3C ?? ?? 00 00 00 00 00 4F ?? ?? 00 00 00 00 00 3C ?? ?? 00 00 00 00 00 4F ?? ?? 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 75 73 65}
    condition:
        $a at pe.entry_point
}

rule PEiD_02196_tElock_v0_41x_
{
    meta:
        description = "[tElock v0.41x]"
        ep_only = "true"
    strings:
        $a = {66 8B C0 8D 24 24 EB 01 EB 60 EB 01 EB 9C E8 00 00 00 00 5E 83 C6 50 8B FE 68 78 01 ?? ?? 59 EB 01 EB AC 54 E8 03 ?? ?? ?? 5C EB 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_02197_tElock_v0_42_
{
    meta:
        description = "[tElock v0.42]"
        ep_only = "true"
    strings:
        $a = {C1 EE 00 66 8B C9 EB 01 EB 60 EB 01 EB 9C E8 00 00 00 00 5E 83 C6 52 8B FE 68 79 01 59 EB 01 EB AC 54 E8 03 5C EB 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_02198_tElock_v0_4x___v0_5x_
{
    meta:
        description = "[tElock v0.4x - v0.5x]"
        ep_only = "true"
    strings:
        $a = {C1 EE 00 66 8B C9 EB 01 EB 60 EB 01 EB 9C E8 00 00 00 00 5E 83 C6 ?? 8B FE 68 79 01 ?? ?? 59 EB 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_02199_tElock_v0_51_
{
    meta:
        description = "[tElock v0.51]"
        ep_only = "true"
    strings:
        $a = {C1 EE 00 66 8B C9 EB 01 EB 60 EB 01 EB 9C E8 00 00 00 00 5E 83 C6 5E 8B FE 68 79 01 59 EB 01 EB AC 54 E8 03 5C EB 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_02200_tElock_v0_60_
{
    meta:
        description = "[tElock v0.60]"
        ep_only = "true"
    strings:
        $a = {E9 00 00 00 00 60 E8 00 00 00 00 58 83 C0 08}
    condition:
        $a at pe.entry_point
}

rule PEiD_02201_tElock_v0_70_
{
    meta:
        description = "[tElock v0.70]"
        ep_only = "true"
    strings:
        $a = {60 E8 BD 10 00 00 C3 83 E2 00 F9 75 FA 70}
    condition:
        $a at pe.entry_point
}

rule PEiD_02202_tElock_v0_71_
{
    meta:
        description = "[tElock v0.71]"
        ep_only = "true"
    strings:
        $a = {60 E8 ED 10 00 00 C3 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_02203_tElock_v0_71b2_
{
    meta:
        description = "[tElock v0.71b2]"
        ep_only = "true"
    strings:
        $a = {60 E8 44 11 00 00 C3 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_02204_tElock_v0_71b7_
{
    meta:
        description = "[tElock v0.71b7]"
        ep_only = "true"
    strings:
        $a = {60 E8 48 11 00 00 C3 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_02205_tElock_v0_7x___v0_84_
{
    meta:
        description = "[tElock v0.7x - v0.84]"
        ep_only = "true"
    strings:
        $a = {60 E8 00 00 C3 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_02206_tElock_v0_80_
{
    meta:
        description = "[tElock v0.80]"
        ep_only = "true"
    strings:
        $a = {60 E8 F9 11 00 00 C3 83}
    condition:
        $a at pe.entry_point
}

rule PEiD_02207_tElock_v0_85f_
{
    meta:
        description = "[tElock v0.85f]"
        ep_only = "true"
    strings:
        $a = {60 E8 02 00 00 00 CD 20 E8 00 00 00 00 5E 2B C9 58 74 02}
    condition:
        $a at pe.entry_point
}

rule PEiD_02208_tElock_v0_90_
{
    meta:
        description = "[tElock v0.90]"
        ep_only = "true"
    strings:
        $a = {?? ?? E8 02 00 00 00 E8 00 E8 00 00 00 00 5E 2B}
    condition:
        $a at pe.entry_point
}

rule PEiD_02209_tElock_v0_92a_
{
    meta:
        description = "[tElock v0.92a]"
        ep_only = "true"
    strings:
        $a = {E9 7E E9 FF FF 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02210_tElock_v0_95_
{
    meta:
        description = "[tElock v0.95]"
        ep_only = "true"
    strings:
        $a = {E9 D5 E4 FF FF 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02211_tElock_v0_96_
{
    meta:
        description = "[tElock v0.96]"
        ep_only = "true"
    strings:
        $a = {E9 59 E4 FF FF 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02212_tElock_v0_98____tHE_EGOiSTE__h__
{
    meta:
        description = "[tElock v0.98 -> tHE EGOiSTE (h)]"
        ep_only = "true"
    strings:
        $a = {E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 75 73 65 72 33 32 2E 64 6C 6C 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 00 00 00 00 00 00 00 00 00 00 00 08 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02213_tElock_v0_98_
{
    meta:
        description = "[tElock v0.98]"
        ep_only = "true"
    strings:
        $a = {E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? 1E}
    condition:
        $a at pe.entry_point
}

rule PEiD_02214_tElock_v0_98b1_
{
    meta:
        description = "[tElock v0.98b1]"
        ep_only = "true"
    strings:
        $a = {E9 25 E4 FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_02215_tElock_v0_98b2_
{
    meta:
        description = "[tElock v0.98b2]"
        ep_only = "true"
    strings:
        $a = {E9 1B E4 FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_02216_tElock_v0_99_Special_Build____heXer___forgot_
{
    meta:
        description = "[tElock v0.99 Special Build -> heXer & forgot]"
        ep_only = "true"
    strings:
        $a = {E9 5E DF FF FF 00 00 00 ?? ?? ?? ?? E5 ?? ?? 00 00 00 00 00 00 00 00 00 05 ?? ?? 00 F5 ?? ?? 00 ED ?? ?? 00 00 00 00 00 00 00 00 00 12 ?? ?? 00 FD ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 1D ?? ?? 00 00 00 00 00 30 ?? ?? 00 00 00 00 00 1D ?? ?? 00 00 00 00 00 30 ?? ?? 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02217_tElock_v1_00_
{
    meta:
        description = "[tElock v1.00]"
        ep_only = "true"
    strings:
        $a = {E9 E5 E2 FF FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_02218_The_aPE_Inline_Patch_Basic__Advanced__Stealth__
{
    meta:
        description = "[The aPE Inline Patch Basic, Advanced, Stealth)]"
        ep_only = "true"
    strings:
        $a = {B9 ?? ?? ?? 00 E8 ?? ?? 00 00 89 01 68}
    condition:
        $a at pe.entry_point
}

rule PEiD_02219_The_aPE_Inline_Patch_ExtraStealth__SuperStealth__
{
    meta:
        description = "[The aPE Inline Patch ExtraStealth, SuperStealth)]"
        ep_only = "true"
    strings:
        $a = {E8 02 ?? ?? ?? EB 01 C3 3E 8B 44 24 FC 50 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89}
    condition:
        $a at pe.entry_point
}

rule PEiD_02220_The_Guard_Library_
{
    meta:
        description = "[The Guard Library]"
        ep_only = "true"
    strings:
        $a = {50 E8 ?? ?? ?? ?? 58 25 ?? F0 FF FF 8B C8 83 C1 60 51 83 C0 40 83 EA 06 52 FF 20 9D C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02221_The_Norton_Antivirus_Information_file_
{
    meta:
        description = "[The Norton Antivirus Information file]"
        ep_only = "false"
    strings:
        $a = {54 68 65 20 4E 6F 72 74 6F 6E 20 41 6E 74 69 56 69 72 75 73 20 49 6E 66 6F 72 6D 61 74 69 6F 6E 20 46 69 6C 65}
    condition:
        $a
}

rule PEiD_02222_TheHyper_s_protector____TheHyper__h__
{
    meta:
        description = "[TheHyper's protector -> TheHyper (h)]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 EC 14 8B FC E8 14 00 00 00 ?? ?? 01 01 ?? ?? 01 01 ?? ?? ?? 00 ?? ?? 01 01 ?? ?? 02 01 5E E8 0D 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 8B 46 04 FF 10 8B D8 E8 0D 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 53 8B 06 FF 10 89 07 E8}
    condition:
        $a
}

rule PEiD_02223_TheHyper_s_protector____TheHyper__h__
{
    meta:
        description = "[TheHyper's protector -> TheHyper (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 14 8B FC E8 14 00 00 00 ?? ?? 01 01 ?? ?? 01 01 ?? ?? ?? 00 ?? ?? 01 01 ?? ?? 02 01 5E E8 0D 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 8B 46 04 FF 10 8B D8 E8 0D 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 53 8B 06 FF 10 89 07 E8 0C 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 53 8B 06 FF 10 89 47 04 E8 0F 00 00 00 47 65 74 50 72 6F 63 65 73 73 48 65 61 70 00 53 8B 06 FF 10 89 47 08 E8 0A 00 00 00 48 65 61 70 41 6C 6C 6F 63 00 53 8B 06 FF 10 89 47 0C E8 09 00 00 00 48 65 61 70 46 72 65 65 00 53 8B 06 FF 10 89 47 10 57 FF 76 08 FF 76 0C FF 56 10 8B E5 5D}
    condition:
        $a at pe.entry_point
}

rule PEiD_02224_TheHyper_s_protector____TheHyper__h__
{
    meta:
        description = "[TheHyper's protector -> TheHyper (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 EC 14 8B FC E8 14 00 00 00 ?? ?? 01 01 ?? ?? 01 01 ?? ?? ?? 00 ?? ?? 01 01 ?? ?? ?? 01 5E E8 0D 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 8B 46 04 FF 10 8B D8 E8 0D 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 53 8B 06 FF 10 89 07 E8 0C 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 53 8B 06 FF 10 89 47 04 E8 0F 00 00 00 47 65 74 50 72 6F 63 65 73 73 48 65 61 70 00 53 8B 06 FF 10 89 47 08 E8 0A 00 00 00 48 65 61 70 41 6C 6C 6F 63 00 53 8B 06 FF 10 89 47 0C E8 09 00 00 00 48 65 61 70 46 72 65 65 00 53 8B 06 FF 10 89 47 10 57 FF 76 08 FF 76 0C FF 56 10 8B E5 5D}
    condition:
        $a at pe.entry_point
}

rule PEiD_02225_Themida____Oreans_Technologies_2004_
{
    meta:
        description = "[Themida -> Oreans Technologies 2004]"
        ep_only = "true"
    strings:
        $a = {B8 00 00 00 00 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02226_themida_1_0_0_5____http___www_oreans_com_
{
    meta:
        description = "[themida 1.0.0.5 -> http?//www.oreans.com]"
        ep_only = "true"
    strings:
        $a = {B8 00 00 00 00 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44}
    condition:
        $a at pe.entry_point
}

rule PEiD_02227_Themida_1_0_x_x___1_8_0_0__compressed_engine_____Oreans_Technologies_
{
    meta:
        description = "[Themida 1.0.x.x - 1.8.0.0 (compressed engine) -> Oreans Technologies]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02228_Themida_1_0_x_x___1_8_0_0__compressed_engine_____Oreans_Technologies_
{
    meta:
        description = "[Themida 1.0.x.x - 1.8.0.0 (compressed engine) -> Oreans Technologies]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8 ?? ?? ?? ?? 03 C7 B9 5A ?? ?? ?? 03 CF EB 0A B8 ?? ?? ?? ?? B9 5A ?? ?? ?? 50 51 E8 84 00 00 00 E8 00 00 00 00 58 2D 26 00 00 00 B9 EF 01 00 00 C6 00 E9 83 E9 05 89 48 01 61 E9 AF 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_02229_Themida_1_0_x_x___1_8_x_x__no_compression_____Oreans_Technologies__h__
{
    meta:
        description = "[Themida 1.0.x.x - 1.8.x.x (no compression) -> Oreans Technologies (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 D8 60 E8 00 00 00 00 5A 81 EA ?? ?? ?? ?? 8B DA C7 45 D8 00 00 00 00 8B 45 D8 40 89 45 D8 81 7D D8 80 00 00 00 74 0F 8B 45 08 89 83 ?? ?? ?? ?? FF 45 08 43 EB E1 89 45 DC 61 8B 45 DC C9 C2 04 00 55 8B EC 81 C4 7C FF FF FF 60 E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02230_Themida_1_0_x_x___1_8_x_x__no_compression_____Oreans_Technologies__h__
{
    meta:
        description = "[Themida 1.0.x.x - 1.8.x.x (no compression) -> Oreans Technologies (h)]"
        ep_only = "false"
    strings:
        $a = {55 8B EC 83 C4 D8 60 E8 00 00 00 00 5A 81 EA ?? ?? ?? ?? 8B DA C7 45 D8 00 00 00 00 8B 45 D8 40 89 45 D8 81 7D D8 80 00 00 00 74 0F 8B 45 08 89 83 ?? ?? ?? ?? FF 45 08 43 EB E1 89 45 DC 61 8B 45 DC C9 C2 04 00 55 8B EC 81 C4 7C FF FF FF 60 E8 00 00 00 00 5A 81 EA ?? ?? ?? ?? 8D 45 80 8B 5D 08 C7 85 7C FF FF FF 00 00 00 00 8B 8D 7C FF FF FF D1 C3 88 18 41 89 8D 7C FF FF FF 81 BD 7C FF FF FF 80 00 00 00 75 E3 C7 85 7C FF FF FF 00 00 00 00 8D BA ?? ?? ?? ?? 8D 75 80 8A 0E BB F4 01 00 00 B8 AB 37 54 78 D3 D0 8A 0F D3 D0 4B 75 F7 0F AF C3 47 46 8B 8D 7C FF FF FF 41 89 8D 7C FF FF FF 81 F9 80 00 00 00 75 D1 61 C9 C2 04 00 55 8B EC 83 C4 F0 8B 75 08 C7 45 FC 00 00 00 00 EB 04 FF 45 FC 46 80 3E 00 75 F7 BA 00 00 00 00 8B 75 08 8B 7D 0C EB 7F C7 45 F8 00 00 00 00 EB}
    condition:
        $a
}

rule PEiD_02231_Themida_1_2_0_1__compressed_____Oreans_Technologies__h__
{
    meta:
        description = "[Themida 1.2.0.1 (compressed) -> Oreans Technologies (h)]"
        ep_only = "true"
    strings:
        $a = {B8 00 00 ?? ?? 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02232_Themida_1_2_0_1__compressed_____Oreans_Technologies__h__
{
    meta:
        description = "[Themida 1.2.0.1 (compressed) -> Oreans Technologies (h)]"
        ep_only = "true"
    strings:
        $a = {B8 00 00 ?? ?? 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8 ?? ?? ?? 00 03 C7 B9 ?? ?? ?? 00 03 CF EB 0A B8 ?? ?? ?? ?? B9 5A ?? ?? ?? 50 51 E8 84 00 00 00 E8 00 00 00 00 58 2D 26 00 00 00 B9 EF 01 00 00 C6 00 E9 83 E9 05 89 48 01 61 E9 AF 01 00 00 02 00 00 00 91 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02233_Themida_1_2_0_1____Oreans_Technologies__h__
{
    meta:
        description = "[Themida 1.2.0.1 -> Oreans Technologies (h)]"
        ep_only = "false"
    strings:
        $a = {8B C5 8B D4 60 E8 00 00 00 00 5D 81 ED ?? ?? 35 09 89 95 ?? ?? 35 09 89 B5 ?? ?? 35 09 89 85 ?? ?? 35 09 83 BD ?? ?? 35 09 00 74 0C 8B E8 8B E2 B8 01 00 00 00 C2 0C 00 8B 44 24 24 89 85 ?? ?? 35 09 6A 45 E8 A3 00 00 00 68 9A 74 83 07 E8 DF 00 00 00 68 25}
    condition:
        $a
}

rule PEiD_02234_Themida_1_2_0_1____Oreans_Technologies__h__
{
    meta:
        description = "[Themida 1.2.0.1 -> Oreans Technologies (h)]"
        ep_only = "false"
    strings:
        $a = {8B C5 8B D4 60 E8 00 00 00 00 5D 81 ED ?? ?? 35 09 89 95 ?? ?? 35 09 89 B5 ?? ?? 35 09 89 85 ?? ?? 35 09 83 BD ?? ?? 35 09 00 74 0C 8B E8 8B E2 B8 01 00 00 00 C2 0C 00 8B 44 24 24 89 85 ?? ?? 35 09 6A 45 E8 A3 00 00 00 68 9A 74 83 07 E8 DF 00 00 00 68 25 4B 89 0A E8 D5 00 00 00 E9 11 02 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_02235_Themida_1_8_x_x____Oreans_Technologies_
{
    meta:
        description = "[Themida 1.8.x.x -> Oreans Technologies]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 60 0B C0 74 68 E8 00 00 00 00 58 05 53 00 00 00 80 38 E9 75 13 61 EB 45 DB 2D 37 ?? ?? ?? FF FF FF FF FF FF FF FF 3D 40 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67}
    condition:
        $a at pe.entry_point
}

rule PEiD_02236_Themida_1_8_x_x____Oreans_Technologies_
{
    meta:
        description = "[Themida 1.8.x.x -> Oreans Technologies]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 60 0B C0 74 68 E8 00 00 00 00 58 05 53 00 00 00 80 38 E9 75 13 61 EB 45 DB 2D 37 ?? ?? ?? FF FF FF FF FF FF FF FF 3D 40 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8 ?? ?? ?? ?? 03 C7 B9 ?? ?? ?? ?? 03 CF EB 0A B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 50 51 E8 84 00 00 00 E8 00 00 00 00 58 2D 26 00 00 00 B9 EF 01 00 00 C6 00 E9 83 E9 05 89 48 01 61 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_02237_Themida_WinLicense_V1_0_0_0_V1_8_0_0____Oreans_Technologies___Sign_by_fly_
{
    meta:
        description = "[Themida/WinLicense V1.0.0.0-V1.8.0.0 -> Oreans Technologies ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {B8 00 00 00 00 60 0B C0 74 58 E8 00 00 00 00 58 05 ?? 00 00 00 80 38 E9 75 ?? 61 EB ?? E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02238_Themida_WinLicense_V1_0_X_V1_7_X_DLL____Oreans_Technologies_
{
    meta:
        description = "[Themida/WinLicense V1.0.X-V1.7.X DLL -> Oreans Technologies]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 60 0B C0 74 58 E8 00 00 00 00 58 05 ?? ?? ?? ?? 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB ?? ?? 66 83 ?? ?? 66 39 18 75 12 0F B7 50 3C 03 D0 BB ?? ?? ?? ?? 83 C3 ?? 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8 ?? ?? ?? ?? 03 C7 B9 ?? ?? ?? ?? 03 CF EB 0A B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 50 51 E8 84 00 00 00 E8 00 00 00 00 58 2D ?? ?? ?? ?? B9 ?? ?? ?? ?? C6 00 E9 83 E9 ?? 89 48 01 61 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_02239_Themida_WinLicense_V1_8_2_0______Oreans_Technologies___Sign_by_fly_
{
    meta:
        description = "[Themida/WinLicense V1.8.2.0 + -> Oreans Technologies ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {B8 00 00 00 00 60 0B C0 74 68 E8 00 00 00 00 58 05 ?? 00 00 00 80 38 E9 75 ?? 61 EB ?? DB 2D ?? ?? ?? ?? FF FF FF FF FF FF FF FF 3D 40 E8 00 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02240_Themida_WinLicense_V1_8_X_V1_9_X_nbsp_____Oreans_Technologies_nbsp___nbsp___Sign_By_fly_
{
    meta:
        description = "[Themida/WinLicense V1.8.X-V1.9.X&nbsp; -> Oreans Technologies&nbsp; &nbsp;* Sign.By.fly]"
        ep_only = "true"
    strings:
        $a = {B8 ?? ?? ?? ?? 60 0B C0 74 68 E8 00 00 00 00 58 05 53 00 00 00 80 38 E9 75 13 61 EB 45 DB 2D ?? ?? ?? ?? FF FF FF FF FF FF FF FF 3D ?? ?? ?? ?? 00 00 58 25 00 F0 FF FF 33 FF 66 BB ?? ?? 66 83 ?? ?? 66 39 18 75 12 0F B7 50 3C 03 D0 BB ?? ?? ?? ?? 83 C3 ?? 39 1A 74 07 2D ?? ?? ?? ?? EB DA 8B F8 B8 ?? ?? ?? ?? 03 C7 B9 ?? ?? ?? ?? 03 CF EB 0A B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 50 51 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 58 2D ?? ?? ?? ?? B9 ?? ?? ?? ?? C6 00 E9 83 E9 05 89 48 01 61 E9}
    condition:
        $a at pe.entry_point
}

rule PEiD_02241_Themida_WinLicense_V1_X_NoCompression_SecureEngine____Oreans_Technologies_
{
    meta:
        description = "[Themida/WinLicense V1.X NoCompression SecureEngine -> Oreans Technologies]"
        ep_only = "false"
    strings:
        $a = {8B C5 8B D4 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 89 B5 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 74 0C 8B E8 8B E2 B8 01 00 00 00 C2 0C 00 8B 44 24 24 89 85 ?? ?? ?? ?? 6A 45 E8 A3 00 00 00 68 9A 74 83 07 E8 DF 00 00 00 68 25 4B 89 0A E8 D5 00 00 00 E9 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00}
    condition:
        $a
}

rule PEiD_02242_theWRAP___by_TronDoc_
{
    meta:
        description = "[theWRAP - by TronDoc]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 56 57 33 C0 89 45 F0 B8 48 D2 4B 00 E8 BC 87 F4 FF BB 04 0B 4D 00 33 C0 55 68 E8 D5 4B 00 64 FF 30 64 89 20 E8 9C F4 FF FF E8 F7 FB FF FF 6A 40 8D 55 F0 A1 F0 ED 4B 00 8B 00 E8 42 2E F7 FF 8B 4D F0 B2 01 A1 F4 C2 40 00 E8 F7 20 F5 FF}
    condition:
        $a at pe.entry_point
}

rule PEiD_02243_theWRAP___by_TronDoc_
{
    meta:
        description = "[theWRAP - by TronDoc]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 83 C4 F0 53 56 57 33 C0 89 45 F0 B8 48 D2 4B 00 E8 BC 87 F4 FF BB 04 0B 4D 00 33 C0 55 68 E8 D5 4B 00 64 FF 30 64 89 20 E8 9C F4 FF FF E8 F7 FB FF FF 6A 40 8D 55 F0 A1 F0 ED 4B 00 8B 00 E8 42 2E F7 FF 8B 4D F0 B2 01 A1 F4 C2 40 00 E8 F7 20 F5 FF 8B F0 B2 01 A1 B4 C3 40 00 E8 F1 5B F4 FF 89 03 33 D2 8B 03 E8 42 1E F5 FF 66 B9 02 00 BA FC FF FF FF 8B C6 8B 38 FF 57 0C BA B8 A7 4D 00 B9 04 00 00 00 8B C6 8B 38 FF 57 04 83 3D B8 A7 4D 00 00 0F 84 5E 01 00 00 8B 15 B8 A7 4D 00 83 C2 04 F7 DA 66 B9 02 00 8B C6 8B 38 FF 57 0C 8B 0D B8 A7 4D 00 8B D6 8B 03 E8 2B 1F F5 FF 8B C6 E8 B4 5B F4 FF 33 D2 8B 03 E8 DF 1D F5 FF BA F0 44 4E 00 B9 01 00 00 00 8B 03 8B 30 FF 56 04 80 3D F0 44 4E 00 0A 75 3F BA B8 A7 4D 00 B9 04 00 00 00 8B 03 8B 30 FF 56 04 8B 15 B8 A7}
    condition:
        $a at pe.entry_point
}

rule PEiD_02244_Thinstall_2_403____Jitit_
{
    meta:
        description = "[Thinstall 2.403 -> Jitit]"
        ep_only = "false"
    strings:
        $a = {6A 00 FF 15 20 50 40 00 E8 D4 F8 FF FF E9 E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41}
    condition:
        $a
}

rule PEiD_02245_Thinstall_2_4x___2_5x____Jitit_Software_
{
    meta:
        description = "[Thinstall 2.4x - 2.5x -> Jitit Software]"
        ep_only = "true"
    strings:
        $a = {55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? BD ?? ?? ?? ?? 03 E8}
    condition:
        $a at pe.entry_point
}

rule PEiD_02246_Thinstall_2_5_________h__
{
    meta:
        description = "[Thinstall 2.5 -> ??? (h)]"
        ep_only = "true"
    strings:
        $a = {55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D A7 1A 00 00 B9 6C 1A 00 00 BA 20 1B 00 00 BE 00 10 00 00 BF B0 53 00 00 BD EC 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? 81 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_02247_Thinstall_2_5xx____Jtit_
{
    meta:
        description = "[Thinstall 2.5xx -> Jtit]"
        ep_only = "true"
    strings:
        $a = {55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D ?? 1A 00 00 B9 ?? 1A 00 00 BA ?? 1B 00 00 BE 00 10 00 00 BF ?? 53 00 00 BD ?? 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? ?? 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10}
    condition:
        $a at pe.entry_point
}

rule PEiD_02248_Thinstall_2_628____Jtit__h__
{
    meta:
        description = "[Thinstall 2.628 -> Jtit (h)]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 58 BB 34 1D 00 00 2B C3 50 68 00 00 40 00 68 00 40 00 00 68 BC 00 00 00 E8 C3 FE FF FF E9 99 FF FF FF CC CC CC CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB A2 B9 01 00 00 00 E8 D0 00 00 00 83 C0 07 89 45 F8 C6 45 F7 00 83 F8 08 74 89 E8 B1 00 00 00 88 45 F7 E9 7C FF FF FF B9 07 00 00 00 E8 AA 00 00 00 50 33 C9 B1 02 E8 A0 00 00 00 8B C8 41 41 58 0B C0 74 04 8B D8 EB 5E 83 F9 02 74 6A 41 E8 88 00 00 00 89 45 FC E9 48 FF FF FF E8 87 00 00 00 49 E2 09 8B C3 E8 7D 00 00 00 EB 3A 49 8B C1 55 8B 4D FC 8B E8 33 C0 D3 E5 E8 5D 00 00 00 0B C5 5D 8B D8 E8 5F 00 00 00 3D 00 00 01 00 73 14 3D FF 37 00 00 73 0E 3D 7F 02 00 00 73 08 83 F8 7F 77 04 41 41 41 41 56 8B F7 2B F0 F3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02249_Thinstall_2_628____Jtit_
{
    meta:
        description = "[Thinstall 2.628 -> Jtit]"
        ep_only = "true"
    strings:
        $a = {E8 00 00 00 00 58 BB 34 1D 00 00 2B C3 50 68 00 00 40 00 68 00 40 00 00 68 BC 00 00 00 E8 C3 FE FF FF E9 99 FF FF FF CC CC CC CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01}
    condition:
        $a at pe.entry_point
}

rule PEiD_02250_Thinstall_3_035____Jtit_
{
    meta:
        description = "[Thinstall 3.035 -> Jtit]"
        ep_only = "true"
    strings:
        $a = {9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 28 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB A2 B9 01 00 00 00 E8 D0 00 00 00 83 C0 07 89 45 F8 C6 45 F7 00 83 F8 08 74 89 E8 B1 00 00 00 88 45 F7 E9 7C FF FF FF B9 07 00 00 00 E8 AA 00 00 00 50 33 C9 B1 02 E8 A0 00 00 00 8B C8 41 41 58 0B C0 74 04 8B D8 EB 5E 83 F9 02 74 6A 41 E8 88 00 00 00 89 45 FC E9 48 FF FF FF E8 87 00 00 00 49 E2 09 8B C3 E8 7D 00 00 00 EB 3A 49 8B C1 55 8B 4D FC 8B E8 33 C0 D3 E5 E8 5D 00 00 00 0B C5 5D 8B D8 E8 5F 00 00 00 3D 00 00 01 00 73 14 3D FF 37 00 00 73 0E 3D 7F 02 00 00 73 08 83 F8 7F 77 04 41 41 41 41 56 8B F7 2B F0 F3 A4 5E E9 F0 FE FF FF 33 C0 EB 05 8B C7 2B 45 0C 5E 5F 5B C9 C2 08 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 C3 B9 08 00 00 00 E8 01 00 00 00 C3 33 C0 E8 E1 FF FF FF 13 C0 E2 F7 C3 33 C9 41 E8 D4 FF FF FF 13 C9 E8 CD FF FF FF 72 F2 C3}
    condition:
        $a at pe.entry_point
}

rule PEiD_02251_Thinstall_Embedded_V1_9X____Jitit___Sign_by_fly_
{
    meta:
        description = "[Thinstall Embedded V1.9X -> Jitit ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {55 8B EC 51 53 56 57 6A 00 6A 00 FF 15 ?? ?? ?? ?? 50 E8 87 FC FF FF 59 59 A1 ?? ?? ?? ?? 8B 40 10 03 05 ?? ?? ?? ?? 89 45 FC 8B 45 FC FF E0 5F 5E 5B C9 C3 00 00 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02252_Thinstall_Embedded_V2_0X____Jitit___Sign_by_fly_
{
    meta:
        description = "[Thinstall Embedded V2.0X -> Jitit ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {B8 EF BE AD DE 50 6A 00 FF 15 ?? ?? ?? ?? E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 14 80 00 00 00 C2 04 00 55 8B EC 53 56 57 33 C0 33 FF 39 45 0C 8B F1 76 0C 8B 4D 08 03 3C 81 40 3B 45 0C 72 F4 8B CE E8 43 00 00 00 8B 46 14 33 D2 F7 F7 8B 5E 10 33 D2 8B F8 8B C3 F7 F7 89 7E 18 89 45 0C 33 C0 33 C9 8B 55 08 03 0C 82 40 39 4D 0C 73 F4 48 8B 14 82 2B CA 0F AF CF 2B D9 0F AF FA 89 7E 14 89 5E 10 5F 5E 5B 5D C2 08 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02253_Thinstall_Embedded_V2_0X____Jitit_
{
    meta:
        description = "[Thinstall Embedded V2.0X -> Jitit]"
        ep_only = "true"
    strings:
        $a = {B8 EF BE AD DE 50 6A 00 FF 15 ?? ?? ?? ?? E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41}
    condition:
        $a at pe.entry_point
}

rule PEiD_02254_Thinstall_Embedded_V2_2X_V2_308____Jitit___Sign_by_fly_
{
    meta:
        description = "[Thinstall Embedded V2.2X-V2.308 -> Jitit ! Sign by fly]"
        ep_only = "true"
    strings:
        $a = {B8 EF BE AD DE 50 6A 00 FF 15 ?? ?? ?? ?? E9 B9 FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 14 80 00 00 00 C2 04 00 55 8B EC 53 56 57 33 C0 33 FF 39 45 0C 8B F1 76 0C 8B 4D 08 03 3C 81 40 3B 45 0C 72 F4 8B CE E8 43 00 00 00 8B 46 14 33 D2 F7 F7 8B 5E 10 33 D2 8B F8 8B C3 F7 F7 89 7E 18 89 45 0C 33 C0 33 C9 8B 55 08 03 0C 82 40 39 4D 0C 73 F4 48 8B 14 82 2B CA 0F AF CF 2B D9 0F AF FA 89 7E 14 89 5E 10 5F 5E 5B 5D C2 08 00}
    condition:
        $a at pe.entry_point
}

rule PEiD_02255_Thinstall_Embedded_V2_2X_V2_308____Jitit_
{
    meta:
        description = "[Thinstall Embedded V2.2X-V2.308 -> Jitit]"
        ep_only = "true"
    strings:
        $a = {B8 EF BE AD DE 50 6A 00 FF 15 ?? ?? ?? ?? E9 B9 FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41}
    condition:
        $a