#!/usr/bin/env python

__description__ = "Program to perform TCP service detections via a SOCKS5 proxy"
__author__ = 'Didier Stevens'
__version__ = '0.0.1'
__date__ = '2021/10/02'

"""

Source code put in public domain by Didier Stevens, no Copyright
https://DidierStevens.com
Use at your own risk

History:
  2019/06/07: start
  2019/06/09: continue
  2021/08/31: Python 3
  2021/09/09: added option --probes
  2021/09/14: added SSL/TLS logic
  2021/09/17: changed proxy logic
  2021/09/26: updated error handling
  2021/09/27: added support for negative rarity option
  2021/09/29: added ~ for ports option
  2021/10/01: added option -H
  2021/10/02: added option -i; concurrent.futures

Todo:
"""

import optparse
import sys
import operator
import socket
import re
import os
import codecs
import ssl
import textwrap
import concurrent.futures
import time
try:
    import socks
except ImportError:
    print('This program requires PySocks: pip install PySocks')
    exit()

NMAPSERVICEPROBES = 'nmap-service-probes'

NOPROXY = 'noproxy'

TOP_TCP_PORTS = [80, 23, 443, 21, 22, 25, 3389, 110, 445, 139, 143, 53, 135, 3306, 8080, 1723, 111, 995, 993, 5900, 1025, 587, 8888, 199, 1720, 465, 548, 113, 81, 6001, 10000, 514, 5060, 179, 1026, 2000, 8443, 8000, 32768, 554, 26, 1433, 49152, 2001, 515, 8008, 49154, 1027, 5666, 646, 5000, 5631, 631, 49153, 8081, 2049, 88, 79, 5800, 106, 2121, 1110, 49155, 6000, 513, 990, 5357, 427, 49156, 543, 544, 5101, 144, 7, 389, 8009, 3128, 444, 9999, 5009, 7070, 5190, 3000, 5432, 3986, 1900, 13, 1029, 9, 5051, 6646, 49157, 1028, 873, 1755, 2717, 4899, 9100, 119, 37, 1000, 3001, 5001, 82, 10010, 1030, 9090, 2107, 1024, 2103, 6004, 1801, 5050, 19, 8031, 1041, 255, 2967, 1065, 1053, 3703, 1054, 1049, 1064, 1048, 1056, 17, 808, 3689, 1031, 1044, 1071, 5901, 9102, 100, 4001, 5120, 1039, 2869, 9000, 8010, 2105, 636, 1038, 2601, 7000, 1, 1069, 1066, 625, 311, 280, 254, 4000, 5003, 1761, 2002, 2005, 1998, 1032, 1050, 6112, 3690, 1521, 2161, 6002, 1080, 2401, 4045, 902, 787, 7937, 1058, 2383, 32771, 1033, 1059, 1040, 50000, 5555, 10001, 1494, 3, 2301, 593, 3268, 7938, 1022, 1234, 1074, 9001, 8002, 1035, 1036, 1037, 464, 1935, 497, 2003, 6666, 6543, 1352, 24, 3269, 1111, 500, 407, 20, 2006, 1218, 3260, 15000, 1034, 4444, 264, 2004, 33, 42510, 1042, 3052, 999, 1023, 1068, 222, 888, 7100, 563, 1717, 2008, 32770, 992, 32772, 7001, 8082, 2007, 5550, 512, 1043, 5801, 2009, 7019, 2701, 1700, 50001, 4662, 2065, 2010, 42, 3333, 9535, 161, 2602, 5100, 2604, 5002, 4002, 4443, 1047, 16993, 1051, 9415, 64623, 1311, 9593, 9594, 1062, 6789, 33354, 16992, 35500, 1052, 32769, 55600, 2702, 23502, 55555, 1060, 8652, 1055, 8651, 8193, 9595, 64680, 5226, 5225, 65389, 3283, 65000, 8701, 20828, 8089, 52869, 8192, 8194, 6059, 13782, 1067, 366, 5902, 9050, 1002, 85, 5500, 45100, 1863, 5431, 10243, 1864, 8085, 51103, 49999, 49, 6667, 90, 27000, 6881, 1503, 340, 8021, 1500, 8899, 2222, 9071, 5566, 8088, 32774, 9876, 6005, 1501, 9101, 5102, 32773, 5679, 163, 1666, 146, 648, 901, 83, 5214, 5004, 8083, 9207, 3476, 8084, 14238, 8001, 12345, 30, 912, 2030, 2605, 6, 541, 8007, 1248, 3005, 4, 306, 880, 2500, 1086, 4242, 1088, 9009, 52822, 8291, 1097, 2525, 6101, 900, 7200, 2809, 1083, 32775, 987, 211, 800, 12000, 705, 20005, 711, 13783, 6969, 16016, 20222, 2492, 2399, 16018, 3031, 3017, 19801, 2381, 2875, 20000, 20031, 63331, 3211, 2260, 5414, 3071, 2190, 16001, 2100, 2718, 2119, 5633, 2135, 20221, 2607, 19842, 2160, 2144, 15660, 21571, 4126, 2811, 1840, 1947, 1783, 9011, 9002, 9010, 28201, 25734, 5911, 5910, 15003, 5269, 5925, 15002, 1718, 5959, 1687, 4003, 8994, 9485, 9502, 9500, 6389, 9503, 30000, 24800, 5960, 58080, 5962, 5961, 14000, 57294, 9618, 8873, 30718, 5987, 31038, 5988, 1077, 10617, 5825, 3998, 8600, 8649, 5989, 3551, 6580, 3351, 8402, 9900, 8333, 8400, 8222, 9968, 22939, 6156, 8181, 1310, 32781, 10002, 8087, 10012, 1104, 8086, 32782, 3827, 10025, 10024, 9290, 3801, 6788, 1272, 1169, 3784, 3659, 3766, 1108, 1148, 9080, 7911, 3325, 50800, 13456, 3580, 7777, 7778, 10566, 7741, 4129, 10616, 10626, 10621, 10629, 10628, 50006, 1107, 1106, 50003, 1096, 27715, 7625, 7627, 11110, 3300, 1075, 1072, 1070, 1073, 49159, 49160, 34571, 1100, 6129, 14442, 6123, 49158, 5030, 3404, 1099, 4449, 1085, 65129, 60020, 5222, 3323, 1098, 17988, 1061, 48080, 5718, 1094, 34573, 11967, 1093, 6901, 9220, 33899, 1063, 19101, 3367, 1046, 7106, 1082, 34572, 1078, 1081, 3301, 5810, 1057, 5877, 1079, 40193, 1045, 691, 89, 1001, 212, 32776, 2020, 1999, 50002, 7002, 6003, 2998, 898, 32, 3372, 2033, 5510, 425, 5903, 749, 99, 13722, 6502, 5405, 6106, 458, 7007, 43, 24444, 1580, 10778, 1782, 27353, 7402, 27355, 7443, 27352, 7512, 1247, 1186, 1183, 8011, 1152, 1124, 8090, 7435, 1089, 32784, 1334, 1296, 9998, 8100, 61532, 8254, 9944, 2126, 9943, 8500, 9877, 8654, 9666, 49163, 49165, 49175, 50389, 50636, 51493, 2179, 1087, 9091, 9110, 55055, 10004, 56738, 8180, 61900, 2191, 5922, 3871, 62078, 5915, 3077, 19780, 3880, 3261, 7103, 5963, 19315, 5904, 19283, 3369, 2251, 3370, 3371, 18988, 5859, 3493, 3546, 5822, 3737, 3828, 3918, 16012, 3851, 3030, 5054, 5200, 15742, 4111, 3995, 2522, 4006, 5298, 3011, 4446, 5280, 32779, 1021, 32777, 9040, 32778, 2021, 700, 666, 616, 5802, 1112, 84, 2040, 4321, 1524, 49400, 38292, 545, 32780, 1084, 2111, 1600, 3006, 2048, 6547, 16080, 9111, 6699, 2638, 5560, 2034, 801, 6007, 2106, 555, 1533, 1443, 720, 667, 4900, 44176, 54328, 4848, 7676, 50500, 2608, 44501, 8800, 16000, 50300, 4567, 5061, 4550, 9878, 5678, 4445, 5221, 49161, 6100, 9575, 54045, 40911, 9081, 4279, 5544, 5033, 5080, 8292, 17877, 5440, 8290, 41511, 55056, 49167, 26214, 18101, 5087, 8200, 56737, 6565, 6566, 6567, 49176, 8383, 1862, 9003, 2323, 3971, 2725, 3945, 3920, 9200, 27356, 3914, 3905, 7496, 6025, 3889, 10003, 9917, 3878, 6510, 5730, 3869, 57797, 14441, 2394, 5811, 3826, 3814, 3809, 3800, 6689, 6692, 8300, 18040, 1090, 1091, 5815, 10009, 8099, 8093, 52673, 1114, 30951, 1117, 2393, 1119, 6779, 1122, 4005, 3527, 1131, 3517, 1138, 6792, 5850, 8045, 8042, 5862, 6839, 1151, 2909, 8022, 3390, 16113, 60443, 4004, 7800, 9418, 9099, 19350, 1175, 3324, 3322, 7999, 1199, 1201, 5906, 5907, 3221, 3168, 7921, 7920, 15004, 12265, 10180, 5952, 32785, 12174, 1271, 32783, 5950, 10215, 11111, 52848, 25735, 3003, 9898, 7025, 2022, 981, 6346, 777, 4998, 1009, 714, 70, 417, 617, 4224, 722, 668, 301, 1076, 5999, 524, 765, 2041, 10082, 1417, 6009, 7004, 2038, 259, 1007, 1984, 44443, 4343, 2068, 416, 1434, 1010, 687, 6006, 726, 2035, 4125, 9103, 109, 7201, 911, 2046, 1461, 2043, 125, 6669, 1455, 6668, 2047, 903, 481, 1011, 683, 2013, 44442, 9929, 31337, 2045, 5998, 783, 2042, 406, 256, 843, 22222, 5823, 5868, 59202, 59201, 12262, 12021, 3162, 5818, 7929, 1236, 32791, 1233, 32792, 59200, 3119, 1244, 12380, 7913, 2968, 12452, 1259, 58838, 1217, 10160, 5981, 59110, 32803, 5807, 1277, 1198, 1192, 58632, 60123, 3304, 5812, 3307, 1187, 1185, 19900, 1322, 2920, 58630, 12215, 1174, 1216, 12059, 58002, 58001, 7900, 7080, 60146, 5899, 8015, 2099, 5869, 7123, 3376, 1213, 1309, 6896, 8019, 32816, 1166, 5968, 2910, 1165, 1328, 3050, 1287, 3400, 1164, 57665, 3410, 1163, 5905, 15402, 7878, 32822, 1154, 8877, 10058, 3013, 7024, 60642, 3007, 1149, 32835, 5909, 1147, 12006, 8050, 21792, 5914, 1145, 1141, 2288, 1300, 1137, 1132, 3514, 9198, 9197, 1130, 20002, 1594, 2170, 65310, 9191, 1126, 1123, 2196, 1121, 61613, 5918, 5501, 7050, 7051, 5940, 1301, 8016, 5938, 2200, 15001, 3929, 9600, 55020, 10011, 1113, 23796, 52851, 30704, 8095, 8097, 6732, 1972, 8098, 7438, 3684, 1105, 4555, 3697, 6711, 5040, 2710, 3700, 8765, 1102, 1095, 7241, 3731, 1092, 23052, 30005, 9621, 18264, 1583, 41523, 33453, 33554, 29831, 10022, 1974, 2366, 10008, 3792, 35513, 53535, 9501, 3808, 7770, 1641, 53314, 4009, 3820, 3824, 10023, 2800, 10034, 29672, 31727, 49168, 55576, 3846, 3848, 47544, 3849, 18018, 9443, 28211, 3852, 3853, 3859, 3863, 7749, 9673, 3870, 39136, 49401, 3872, 4949, 9815, 44709, 4040, 8987, 1658, 3888, 5063, 7744, 49164, 27357, 3907, 40811, 53313, 3916, 52710, 2557, 5074, 3931, 3941, 3944, 4658, 53211, 1556, 6203, 10873, 3957, 3963, 8189, 3968, 3969, 37839, 8540, 6600, 13724, 6520, 3972, 8686, 8996, 3981, 38185, 3990, 52853, 3993, 3994, 38188, 4096, 4875, 6051, 1812, 1971, 1721, 52850, 7278, 1914, 26470, 1719, 52849, 9409, 2382, 52847, 6550, 1688, 46200, 49236, 49195, 16851, 52735, 5081, 9098, 8294, 4147, 39376, 8676, 4143, 17595, 5353, 5151, 6500, 52660, 51191, 9988, 6068, 5339, 8481, 4080, 6247, 8675, 1875, 7281, 4164, 9914, 1839, 8648, 4430, 49171, 50050, 16705, 7725, 6504, 1805, 9643, 51413, 8293, 40000, 9941, 26000, 6060, 8385, 4252, 4200, 39659, 4600, 5279, 7272, 5223, 16800, 41064, 8766, 9444, 49186, 5212, 5242, 8889, 46996, 6481, 4559, 502, 10005, 913, 1103, 2241, 725, 803, 623, 930, 639, 780, 1220, 6222, 5680, 1347, 1109, 2012, 2232, 710, 2501, 701, 856, 102, 441, 2044, 419, 447, 874, 475, 27, 123, 9992, 5010, 953, 931, 1222, 250, 8118, 442, 18000, 1158, 1270, 86, 540, 6008, 9152, 829, 1212, 3299, 210, 5803, 709, 223, 5520, 10083, 2433, 87, 57, 556, 251, 1013, 980, 1550, 2628, 1008, 7003, 3025, 6103, 55, 713, 792, 657, 1516, 674, 943, 840, 1350, 127, 157, 1351, 333, 77, 904, 523, 1020, 1241, 1547, 825, 1006, 7010, 2011, 1526, 732, 220, 2067, 684, 4333, 748, 610, 557, 778, 782, 786, 795, 822, 757, 790, 823, 731, 730, 862, 729, 905, 839, 6050, 846, 3399, 1522, 969, 971, 996, 998, 2903, 3456, 257, 2025, 1353, 1357, 1012, 600, 1014, 6662, 1015, 225, 602, 3632, 659, 2201, 655, 660, 728, 621, 715, 5011, 740, 754, 859, 864, 758, 878, 918, 802, 921, 806, 922, 44334, 928, 3999, 38037, 1004, 1005, 1525, 669, 6670, 1414, 641, 1413, 690, 1127, 2600, 1337, 606, 12346, 924, 98, 252, 6017, 805, 388, 2112, 411, 59, 9619, 8879, 8880, 9620, 8878, 8882, 8843, 8790, 9628, 9613, 8883, 8801, 9654, 8772, 8887, 8756, 8798, 9665, 7685, 8898, 8900, 8752, 9667, 9616, 9674, 10842, 9648, 9680, 10852, 9694, 9661, 9700, 8673, 9592, 8925, 9583, 10878, 7300, 10900, 8658, 7654, 8655, 8644, 8640, 9777, 8736, 9527, 11000, 8621, 10754, 9513, 8601, 11401, 9812, 8980, 7688, 9823, 9825, 9679, 11001, 9683, 9830, 9844, 8562, 8680, 9875, 8539, 8531, 11003, 9745, 8530, 8515, 9478, 8484, 11019, 8999, 8479, 9464, 9454, 8477, 8474, 10699, 7637, 11026, 9004, 9005, 8472, 8471, 11031, 8954, 8470, 8455, 8454, 8453, 8452, 9013, 8451, 9020, 9814, 9021, 11033, 8445, 9022, 9901, 10602, 9908, 11089, 9909, 8409, 8403, 9910, 9911, 8401, 9912, 9915, 10601, 9919, 9037, 9950, 7628, 11100, 9044, 9400, 7553, 9826, 9061, 8339, 9065, 11296, 8865, 8308, 11552, 8295, 10567, 9971, 9493, 11007, 11288, 9979, 8282, 9084, 11697, 9364, 8273, 9351, 11250, 7600, 9990, 7320, 8255, 8248, 7501, 8245, 8232, 11735, 7500, 8202, 8201, 10556, 10555, 9343, 9333, 10554, 10553, 11813, 7231, 11862, 9995, 10552, 10551, 10550, 11863, 7218, 11032, 11940, 7456, 7184, 7325, 10006, 12001, 8144, 9125, 9128, 7771, 9130, 9131, 10007, 7451, 7772, 9133, 9300, 8133, 10535, 8116, 12002, 8110, 10529, 9160, 8092, 9161, 10509, 7780, 10018, 10019, 7555, 11224, 10020, 9170, 10035, 9183, 9287, 10042, 10045, 8064, 8060, 7788, 10500, 7789, 12005, 10494, 8052, 10443, 8037, 10064, 8029, 8025, 8023, 8018, 10414, 9202, 7121, 8014, 10093, 10101, 7119, 10387, 8006, 8005, 8003, 12009, 10357, 7813, 7998, 7830, 7104, 7102, 7975, 9975, 10115, 10347, 7101, 65488, 10338, 12019, 12296, 12275, 9210, 12271, 7099, 12251, 12243, 9211, 12240, 12225, 7092, 12192, 12031, 7400, 12034, 12171, 7895, 10238, 10245, 12077, 11180, 10246, 12080, 11200, 10565, 7345, 8268, 7072, 7852, 7071, 7853, 12156, 12146, 12137, 10255, 7033, 12132, 12090, 10280, 7043, 12121, 7854, 12097, 7067, 7068, 12096, 5931, 5927, 5926, 5934, 5924, 5923, 5936, 5939, 5921, 5920, 5945, 5917, 5948, 5949, 5953, 2598, 65311, 65048, 5912, 64890, 5954, 64727, 15005, 5958, 64726, 5908, 64551, 64507, 64438, 4058, 5966, 37151, 5969, 64320, 15050, 37121, 64127, 15145, 5971, 5888, 5887, 5974, 64080, 5975, 5881, 5878, 36962, 5875, 5874, 15190, 5871, 36710, 36677, 4056, 6126, 63803, 63675, 63423, 5985, 5860, 63156, 63105, 5858, 5854, 5853, 5852, 5986, 62866, 5849, 5848, 5845, 62674, 14916, 62570, 5840, 5839, 5838, 5836, 5834, 5831, 5827, 5826, 15191, 5824, 62519, 14891, 5821, 5820, 62312, 14827, 15275, 5817, 62188, 62080, 62042, 5814, 62006, 61942, 61851, 14147, 61827, 61734, 61722, 15317, 5808, 61669, 6535, 5806, 61617, 5804, 14733, 14693, 15344, 14545, 61616, 14534, 18012, 14444, 61516, 61473, 18015, 61402, 61170, 13359, 61169, 61159, 5013, 60989, 60794, 60789, 60783, 3603, 60782, 18080, 3602, 60753, 60743, 14443, 60728, 60713, 60628, 60621, 60612, 60579, 4039, 60544, 60504, 60492, 14418, 60485, 3210, 60403, 3600, 60401, 4036, 60377, 60279, 60243, 60227, 60177, 3599, 6780, 60111, 60086, 60055, 60003, 60002, 60000, 59987, 59841, 59829, 59810, 59778, 59684, 5737, 5734, 5732, 59565, 59525, 59510, 59509, 59504, 59499, 59340, 59239, 3586, 59191, 18569, 59160, 5723, 59149, 5722, 59122, 5721, 59107, 4035, 59087, 58991, 58970, 58908, 3577, 58721, 15448, 4065, 15550, 58699, 13340, 58634, 58622, 58610, 5711, 58570, 58562, 58498, 6010, 58468, 58456, 58446, 3532, 58430, 58374, 58310, 58305, 58252, 58164, 58109, 58107, 58072, 57999, 18669, 57988, 57928, 57923, 57896, 15631, 57891, 57733, 57730, 57702, 57681, 57678, 57576, 57479, 57398, 57387, 4029, 57352, 57350, 57347, 5672, 57335, 57325, 57123, 57103, 57020, 5667, 15645, 5665, 56975, 6015, 56973, 15646, 56827, 56822, 56810, 56725, 56723, 56681, 56668, 56591, 56535, 56507, 15670, 39763, 56293, 15677, 56259, 3530, 15722, 56055, 56016, 55948, 55910, 55907, 5622, 5621, 5620, 55901, 55781, 55773, 55758, 5612, 5611, 55721, 55684, 55652, 55635, 55579, 55569, 55568, 55556, 55527, 55479, 55426, 55400, 4025, 55382, 4024, 55350, 55312, 55227, 15730, 55187, 55183, 55000, 54991, 4022, 54987, 6021, 54907, 54873, 54741, 54722, 5581, 54688, 5580, 54658, 54605, 4020, 54551, 54514, 54323, 54321, 13502, 54276, 54263, 54235, 54127, 54101, 54075, 5557, 4016, 4010, 53958, 53910, 53852, 5554, 53827, 5553, 15758, 5552, 15915, 53782, 13318, 53742, 53690, 3526, 53656, 53639, 53633, 3520, 38194, 4007, 18874, 53491, 6030, 53469, 53460, 53370, 53361, 53319, 3519, 13784, 18148, 53240, 6579, 53212, 3997, 5502, 53189, 53178, 53085, 52948, 3996, 52893, 13306, 13265, 14254, 3515, 5475, 52675, 5473, 52665, 52573, 52506, 52477, 52391, 52262, 52237, 52230, 3513, 52226, 3511, 52225, 52173, 52071, 5458, 5457, 52046, 52025, 52003, 52002, 3506, 52001, 52000, 51965, 51961, 51909, 51906, 51809, 51800, 5444, 51772, 51771, 5442, 5441, 51658, 51582, 51515, 51488, 51485, 51484, 51460, 51423, 51366, 51351, 51343, 51300, 5433, 51240, 51235, 51234, 51233, 51139, 51118, 51067, 51037, 16048, 51020, 51011, 50997, 50945, 50903, 50887, 50854, 50849, 50836, 50835, 5423, 50834, 50833, 37614, 50831, 50815, 3992, 50809, 50787, 50733, 50692, 50585, 50577, 50576, 50545, 50529, 50513, 50356, 50277, 50258, 50246, 50224, 50205, 50202, 50198, 50189, 50101, 50040, 50019, 50016, 49927, 49803, 49765, 49762, 49751, 49678, 49603, 49597, 49522, 49521, 3505, 49520, 49519, 49500, 49498, 49452, 13264, 49398, 49372, 4819, 49352, 49302, 3503, 49275, 5377, 3497, 5370, 49241, 4158, 49235, 3991, 49232, 13261, 49228, 49216, 49213, 49211, 49204, 49203, 49202, 49201, 16161, 49197, 49196, 49191, 49190, 49189, 16270, 49179, 16273, 49173, 49172, 49170, 16283, 49169, 49166, 49132, 49048, 49002, 16286, 5347, 48973, 13250, 3486, 48967, 48966, 48925, 48813, 48783, 48682, 48648, 48631, 16297, 48619, 3485, 48434, 48356, 48167, 3989, 48153, 3483, 34317, 48127, 4161, 48083, 6251, 48067, 48009, 47969, 47966, 47860, 47858, 33192, 47850, 13229, 47806, 47777, 47700, 47634, 47624, 47595, 47581, 47567, 3983, 3982, 16349, 3980, 3479, 18887, 47448, 47372, 47348, 47267, 47197, 47119, 6052, 5291, 47029, 47012, 46992, 46813, 46593, 3979, 46436, 46418, 46372, 6055, 46310, 46182, 13766, 46171, 3975, 46115, 46069, 46034, 45960, 45864, 45777, 45697, 5261, 45624, 5259, 18910, 45602, 33087, 45463, 5252, 45438, 45413, 45226, 5250, 45220, 45164, 45136, 45050, 45038, 1128, 44981, 44965, 44711, 44704, 18962, 44628, 3443, 44616, 3439, 44541, 13730, 5235, 6062, 5234, 5233, 3430, 44505, 6063, 3425, 44479, 3419, 6606, 13723, 3967, 44431, 44410, 3415, 6065, 3964, 44380, 3414, 13194, 13193, 3962, 19010, 6259, 5219, 44200, 16372, 3961, 19130, 13192, 6067, 44119, 44101, 4689, 44004, 6619, 5202, 43868, 5201, 43823, 13188, 43734, 3621, 43690, 3396, 6877, 43654, 3956, 3952, 13167, 3949, 3388, 16464, 4174, 6888, 17867, 13149, 3948, 43425, 6897, 43242, 18231, 3946, 2973, 4087, 43231, 3943, 43212, 13142, 3940, 3937, 43143, 4090, 3936, 43139, 13140, 3374, 13132, 3935, 3930, 43103, 5152, 43027, 43018, 1208, 13130, 5147, 3928, 43002, 13093, 43000, 6920, 5137, 3923, 3368, 42990, 42906, 3922, 5133, 5125, 42735, 5122, 5121, 6077, 16723, 16724, 3919, 19200, 6922, 42685, 42679, 5114, 42675, 42632, 42590, 42575, 5111, 16725, 3365, 3915, 42560, 19201, 13017, 42559, 3363, 1228, 12962, 42452, 42449, 16797, 42322, 6085, 42276, 3362, 5098, 42251, 5096, 5095, 3913, 42158, 16845, 42127, 42035, 3911, 42001, 41808, 5090, 12955, 5088, 6942, 1282, 41795, 41794, 41773, 1306, 41632, 3909, 41551, 12892, 6090, 6091, 41442, 41398, 41348, 41345, 41342, 16900, 1307, 41318, 14237, 41281, 41250, 41142, 41123, 3908, 4609, 12891, 5070, 3906, 6628, 3904, 3334, 3902, 19333, 40951, 5066, 4190, 1319, 12865, 1327, 3901, 12766, 4192, 4599, 1331, 19353, 1330, 16901, 3319, 14218, 3311, 3899, 40834, 40812, 3310, 6956, 17860, 40754, 5055, 32767, 5053, 19403, 5052, 40732, 4100, 12702, 40712, 20017, 12699, 3622, 3897, 40628, 40614, 3291, 40513, 32261, 40489, 3281, 3280, 19464, 4101, 19501, 40457, 20021, 18517, 3263, 12414, 32088, 3240, 3890, 3882, 3879, 4206, 19612, 40400, 40393, 6972, 40306, 3876, 3220, 40011, 6973, 6644, 5023, 40005, 40003, 6647, 5021, 40002, 5020, 19634, 5017, 5016, 5015, 40001, 5014, 6650, 32031, 2583, 5012, 3868, 12340, 39917, 6113, 39895, 3200, 39883, 39869, 39795, 39774, 6323, 39732, 3190, 5005, 6115, 3860, 31386, 17016, 17017, 17070, 17089, 17129, 3167, 19715, 39630, 4999, 39489, 65514, 3742, 30896, 3146, 39482, 3636, 39433, 3856, 39380, 31033, 19852, 3121, 3850, 39293, 4141, 39265, 2850, 3847, 3118, 3103, 3102, 6120, 39117, 3842, 39067, 3089, 3080, 38936, 19995, 3839, 38805, 3063, 38780, 4220, 3837, 3062, 3057, 38764, 3831, 38761, 3728, 38570, 19996, 3830, 3825, 30195, 38561, 38546, 4931, 17409, 3823, 4112, 30001, 38481, 20001, 3817, 38446, 4912, 4113, 3023, 4903, 38358, 38331, 38313, 3813, 29810, 13846, 38270, 3014, 38224, 38205, 3002, 20011, 3812, 3811, 4516, 3810, 38029, 3806, 37855, 4881, 37789, 37777, 37674, 37647, 4877, 4876, 3803, 3799, 28851, 37607, 37522, 37393, 37218, 37185, 3798, 2997, 3796, 2991, 4860, 4118, 4859, 37174, 28567, 2567, 2988, 36983, 3795, 36950, 36914, 36824, 36823, 36748, 28017, 36694, 4119, 36659, 36552, 36530, 36508, 36436, 36368, 36275, 36256, 36105, 36104, 36046, 35986, 35929, 6161, 35906, 35901, 35900, 35879, 35731, 35593, 35553, 35506, 35401, 6710, 35393, 35392, 35349, 35272, 35217, 35131, 35116, 35050, 35033, 34875, 34833, 4800, 34783, 34765, 34728, 4793, 34683, 34510, 34507, 34401, 34381, 34341, 4454, 34189, 34096, 34036, 34021, 33895, 4778, 33889, 33882, 4771, 4770, 33879, 4767, 33841, 4760, 33605, 33604, 33550, 33523, 33522, 33444, 33395, 33367, 33337, 33335, 33327, 6250, 33277, 4745, 33203, 33200, 27017, 3793, 17969, 33175, 33124, 2551, 33070, 33017, 33011, 33000, 32976, 1101, 32961, 32960, 32944, 32932, 32911, 32910, 32908, 32905, 32904, 32898, 32897, 32888, 1116, 32871, 1118, 2987, 32869, 32868, 1125, 2558, 1134, 1135, 4713, 4712, 1136, 25717, 2984, 32858, 1143, 32842, 1144, 32837, 1150, 4700, 1153, 1156, 1157, 1159, 1162, 32820, 1167, 1168, 32815, 25565, 1173, 32814, 1176, 4687, 25262, 1179, 1180, 1182, 1184, 1188, 1190, 1191, 1194, 1195, 1196, 1200, 32807, 1204, 1207, 25174, 1209, 1210, 1211, 2958, 32799, 1215, 32798, 32797, 1221, 1223, 1565, 1229, 32790, 32789, 1239, 1240, 1243, 32788, 1598, 1249, 1250, 1251, 17715, 1261, 1262, 1264, 1268, 4665, 1276, 1279, 1620, 1290, 1291, 17251, 1297, 1299, 1302, 2957, 6273, 1303, 1305, 6274, 4649, 1638, 4644, 3669, 1308, 1314, 1315, 1316, 6309, 25001, 4606, 1317, 1318, 24999, 4602, 1321, 4601, 1324, 6310, 1677, 1683, 4384, 2584, 2550, 1336, 32765, 1339, 1340, 32764, 1691, 4120, 17255, 2930, 1701, 32260, 4121, 32219, 1707, 32200, 32102, 2908, 4376, 2902, 4375, 32022, 4570, 32006, 17802, 2901, 3790, 2898, 31728, 3788, 3787, 31657, 31522, 3765, 31438, 4374, 3749, 6324, 1730, 4558, 4234, 2889, 1735, 2888, 31339, 1736, 2882, 31072, 20032, 31058, 1745, 2580, 20039, 30705, 1752, 14001, 2847, 24552, 30659, 2812, 30644, 3712, 30599, 2806, 30519, 4545, 17997, 6349, 30299, 3663, 6350, 30087, 1799, 18333, 4356, 2532, 4534, 2804, 4530, 29507, 29243, 4517, 1800, 29152, 29045, 28967, 28924, 1808, 28850, 17413, 18336, 28717, 18337, 6379, 1825, 28374, 1858, 28142, 1861, 28114, 2734, 1871, 27770, 6709, 4476, 4471, 1901, 4464, 27537, 27521, 2728, 27372, 2723, 17985, 18380, 27351, 27350, 20052, 27316, 1912, 18439, 27204, 3683, 27087, 27075, 27074, 27055, 27019, 27018, 17500, 1954, 27016, 2712, 4447, 27015, 17801, 3681, 1976, 20118, 3680, 6725, 17700, 2622, 4442, 26972, 26669, 20085, 23430, 4433, 26417, 26340, 2711, 3672, 4243, 2706, 26007, 26001, 6503, 6734, 25847, 23451, 3670, 25703, 23296, 25486, 25473, 25445, 4418, 25327, 25288, 4415, 4414, 23228, 25260, 20076, 23017, 2700, 1558, 1559, 17701, 1560, 4407, 22969, 1566, 1569, 1584, 17702, 1592, 22959, 1605, 1607, 1615, 22769, 4401, 22727, 1622, 1632, 1635, 13899, 1645, 4135, 2691, 2644, 2631, 3653, 20127, 13695, 25000, 22555, 4388, 22350, 20080, 22341, 22290, 20147, 1694, 1699, 2505, 1703, 22223, 1708, 22200, 1709, 22177, 22128, 1711, 2623, 1712, 1713, 1715, 24616, 1722, 20180, 22063, 4369, 22100, 24554, 22022, 1750, 2062, 1753, 3652, 24416, 2069, 24392, 1791, 4358, 1792, 4357, 2070, 2463, 2082, 4355, 1806, 1807, 4302, 1811, 1823, 2086, 1835, 24218, 2087, 2095, 4300, 1883, 2456, 1911, 2096, 1918, 1924, 1927, 23953, 23887, 6412, 2101, 1958, 1973, 1975, 4342, 4297, 1981, 23723, 2115, 2531, 20106, 4262, 20125, 18505, 3658, 3656, 23382, 23342, 2124, 23270, 2148, 4328, 23219, 23040, 2150, 2606, 21634, 4325, 13580, 21631, 20089, 22882, 2197, 20102, 21473, 2203, 22719, 2439, 22711, 22563, 21201, 2031, 21078, 21011, 2436, 2438, 20223, 2435, 3637, 20179, 22125, 20224, 2472, 2250, 2253, 2418, 2425, 20226, 2080, 2081, 20225, 2261, 2083, 20228, 2262, 20227, 20280, 2391, 2265, 4298, 2104, 2376, 21915, 21891, 2269, 2270, 2372, 4294, 2134, 2142, 2375, 2280, 21728, 2271, 20734, 2187, 2291, 2292, 2449, 2340, 2300, 20883, 2224, 2335, 2330, 20990, 2302, 20473, 2325, 2326, 2312, 2371, 2313, 20940, 20111, 20934, 2304, 967, 743, 809, 925, 642, 678, 5977, 1492, 1019, 31416, 32786, 779, 32787, 706, 27001, 578, 509, 3985, 446, 1441, 4008, 400, 961, 54320, 935, 942, 858, 863, 844, 22273, 811, 834, 762, 769, 635, 1444, 973, 914, 47, 5632, 817, 830, 789, 591, 1495, 1989, 983, 815, 5308, 1507, 11, 926, 66, 6105, 965, 979, 7005, 847, 68, 52, 76, 75, 104, 101, 1680, 1663, 1652, 158, 91, 122, 219, 6110, 860, 861, 27010, 525, 510, 603, 577, 620, 1420, 889, 649, 899, 665, 897, 894, 695, 682, 733, 916, 804, 1366, 1364, 1359, 1358, 798, 923, 771, 810, 807, 4199, 1139, 835, 12, 10, 833, 989, 828, 985, 984, 440, 974, 3045, 3049, 824, 750, 237, 958, 952, 3064, 501, 949, 449, 727, 946, 615, 9991, 716, 634, 538, 653, 707, 664, 3398, 814, 629, 950, 45, 16, 945, 1016, 936, 941, 875, 8076, 1388, 1465, 3086, 948, 962, 28, 851, 850, 7273, 2024, 1346, 938, 1178, 831, 1370, 1356, 826, 1214, 820, 819, 816, 4557, 813, 4660, 1349, 929, 927, 791, 2120, 761, 760, 1384, 745, 741, 736, 735, 919, 906, 724, 719, 6347, 5145, 1385, 702, 696, 1399, 1389, 673, 1400, 1404, 663, 661, 5191, 658, 1402, 651, 883, 881, 647, 640, 638, 1445, 632, 630, 870, 627, 872, 27374, 5232, 609, 605, 866, 1484, 5300, 1474, 6401, 1523, 507, 1517, 492, 491, 456, 450, 855, 448, 5400, 1552, 353, 343, 334, 300, 268, 9104, 249, 1551, 230, 221, 1651, 1988, 7597, 112, 2307, 2014, 92, 1991, 841, 2018, 2430, 836, 50, 988, 1018, 5978, 6665, 3900, 3141, 7009, 11371, 3264, 2026, 2015, 1997, 1996, 2064, 3292, 1668, 1664, 1650, 1539, 1535, 1527, 1515, 3397, 1762, 1995, 1486, 1476, 1475, 1467, 1466, 27665, 4480, 1435, 4500, 1412, 1405, 1403, 1401, 1387, 6701, 1381, 1379, 1373, 1372, 1369, 1354, 1348, 8123, 1496, 14, 14141, 1017, 794, 1003, 689, 997, 994, 685, 991, 6143, 680, 975, 970, 968, 964, 963, 960, 959, 951, 947, 944, 1497, 939, 933, 909, 895, 891, 676, 886, 879, 869, 628, 13720, 867, 854, 837, 832, 821, 622, 812, 799, 797, 796, 611, 788, 770, 756, 751, 734, 723, 721, 718, 708, 704, 703, 694, 692, 553, 868, 681, 402, 262, 675, 670, 454, 656, 654, 644, 637, 633, 15, 624, 9106, 8892, 6588, 18182, 561, 560, 9107, 40, 5530, 47557, 511, 505, 231, 35, 213, 9105, 18184, 201, 182, 253, 194, 60, 51, 214, 180, 137, 97, 69, 103, 6146, 16444, 6400, 65301, 5302, 6147, 5301, 6142, 5997, 6111, 6145, 13713, 233, 235, 236, 260, 261, 273, 276, 303, 308, 315, 325, 336, 350, 355, 362, 397, 399, 401, 403, 404, 410, 412, 9051, 415, 418, 422, 437, 453, 462, 466, 486, 493, 536, 568, 601, 604, 607, 608, 619, 626, 645, 672, 677, 686, 688, 697, 698, 699, 8770, 712, 717, 6544, 737, 738, 746, 747, 755, 759, 763, 764, 774, 776, 784, 785, 793, 818, 827, 838, 842, 848, 849, 852, 853, 857, 865, 1368, 871, 876, 877, 882, 884, 885, 887, 890, 892, 907, 908, 915, 920, 934, 956, 957, 966, 972, 978, 982, 1355, 1362, 1365, 1538, 1376, 1386, 1390, 1393, 1394, 1397, 1398, 1409, 1410, 1422, 1424, 1426, 1432, 1436, 1437, 1438, 18181, 1439, 1442, 1446, 1454, 18183, 1456, 1472, 1479, 1483, 1493, 1498, 1499, 1510, 1511, 1513, 1519, 26208, 1528, 1529, 1531, 1537, 4132, 1544, 1545, 1548, 1549, 7634, 1661, 1662, 1667, 1763, 1827, 94, 6700, 1986, 1990, 1992, 1994, 2023, 2027, 2053, 29, 31, 34, 38, 44, 58, 71, 73, 74, 93, 129, 95, 114, 115, 118, 120, 200, 133, 136, 138, 176, 177, 181, 193, 196, 206, 202, 204, 2627, 224, 7008, 2431, 2432, 7006, 3531, 3457, 4144, 6548, 228, 18187, 3984, 108, 130, 151, 150, 162, 168, 289, 294, 189, 185, 191, 190, 217, 7326, 977, 1374, 1488, 1491, 5717, 117, 234, 229, 132, 238, 258, 148, 265, 277, 295, 293, 173, 305, 337, 329, 358, 360, 361, 209, 216, 364, 373, 408, 420, 438, 451, 457, 479, 473, 485, 542, 571, 582, 596, 612, 614, 766, 768, 6141, 1363, 1407, 1411, 1423, 1440, 1430, 1451, 1459, 1473, 1518, 1542, 1670, 1672, 116, 141, 248, 5490, 267, 271, 270, 174, 316, 326, 192, 352, 351, 370, 369, 391, 13721, 423, 432, 439, 435, 472, 516, 526, 533, 552, 5303, 583, 572, 613, 643, 43188, 753, 775, 845, 17007, 954, 1391, 1383, 1427, 1419, 1458, 1457, 1464, 1462, 1470, 1469, 27007, 27009, 1502, 27002, 1509, 1508, 2766, 1987, 54, 65, 72, 67, 96, 2108, 142, 128, 288, 284, 184, 322, 205, 346, 226, 392, 460, 452, 480, 496, 535, 530, 5193, 739, 767, 893, 937, 976, 2564, 4672, 17300, 1416, 1429, 1449, 27005, 1482, 1505, 13718, 27003, 1480, 1540, 1532, 1671, 2019, 15151, 124, 380, 149, 413, 383, 428, 414, 487, 470, 522, 569, 598, 570, 618, 599, 662, 652, 896, 781, 955, 1371, 1396, 1418, 1453, 1448, 7464, 1543, 2028, 4133, 434, 528, 742, 564, 752, 932, 986, 2, 1541, 48, 5714, 56, 518, 773, 4987, 910, 1367, 1361, 13715, 13714, 3421, 1408, 744, 5713, 1395, 1360, 19150, 2016, 1993, 8, 13701, 3845, 13712, 3844, 13711, 4108, 4109, 3843, 3836, 3835, 3841, 3833, 4107, 3840, 3829, 6657, 3857, 3838, 3854, 3855, 6507, 6506, 3816, 3834, 6672, 3832, 4115, 6673, 4110, 3807, 3862, 3802, 18242, 6679, 3797, 13710, 3794, 3864, 3789, 6688, 3858, 6656, 3822, 18243, 4106, 3821, 6671, 3780, 3819, 3779, 3778, 3861, 3776, 3818, 3774, 3815, 3773, 3772, 6697, 3771, 3770, 13709, 3769, 4114, 3768, 3767, 13708, 4123, 3764, 3763, 3761, 3760, 3759, 3758, 3757, 3756, 3754, 3753, 3752, 3960, 3751, 3750, 3748, 3805, 3745, 3804, 6655, 4116, 3741, 3740, 3739, 3738, 3736, 3735, 6678, 4117, 3733, 3732, 6687, 3730, 3729, 3727, 3726, 6703, 3725, 3724, 3723, 3722, 3721, 3720, 3719, 6635, 3791, 3717, 3714, 3713, 3711, 13706, 3710, 3865, 4122, 6634, 3786, 3706, 3705, 3704, 3785, 6505, 3866, 3701, 4102, 3867, 3698, 18262, 6653, 13716, 3783, 4105, 13717, 6640, 4104, 3873, 3782, 3874, 3781, 6716, 4131, 3679, 3678, 6690, 3677, 3777, 3675, 3674, 3875, 3775, 6696, 13705, 3671, 13702, 3668, 3667, 3666, 4136, 3665, 18463, 3664, 3662, 3661, 3660, 3762, 3657, 4138, 3655, 3654, 4139, 3651, 4140, 3650, 6767, 3649, 3648, 3755, 3646, 3645, 3644, 13400, 3643, 3642, 3641, 3640, 3639, 3638, 3635, 3634, 3633, 6768, 4142, 3631, 3630, 3629, 3628, 3627, 3626, 3625, 3624, 3623, 3747, 6501, 6769, 3620, 3619, 3618, 3616, 6770, 3614, 3877, 4103, 3746, 3609, 6636, 3608, 3744, 4097, 4124, 3881, 3605, 3743, 4145, 6702, 4146, 3598, 3597, 3596, 6778, 3595, 3594, 3593, 3592, 6784, 3591, 3590, 3589, 3588, 3587, 3734, 3584, 3583, 3582, 3581, 3579, 4148, 3576, 3575, 18634, 3574, 6785, 3573, 3572, 3571, 3570, 3569, 3568, 3567, 3566, 3565, 3564, 3563, 3562, 3561, 3560, 3559, 3558, 3557, 3556, 6786, 3555, 3554, 3553, 3718, 18635, 3883, 3549, 3716, 3715, 3547, 3544, 3542, 3541, 3540, 3709, 6787, 3538, 3537, 3536, 3535, 3534, 3533, 3884, 3708, 4150, 3707, 3529, 18769, 4151, 3525, 3524, 3523, 4127, 3521, 4152, 3885, 3702, 3516, 4154, 6790, 3512, 3699, 4128, 18241, 13821, 3508, 6791, 6714, 3886, 3696, 3695, 3502, 3693, 3887, 6801, 3498, 3692, 6633, 3496, 3691, 3494, 6715, 3491, 4130, 3490, 6632, 3891, 3892, 3688, 3893, 3687, 3481, 3480, 3686, 4162, 3894, 3478, 3477, 3895, 3685, 3896, 3682, 3473, 3472, 3471, 3470, 3468, 13224, 3467, 3466, 3465, 3464, 3463, 6831, 3462, 3461, 3460, 3459, 3458, 4163, 4082, 3676, 3673, 3455, 3454, 19000, 3453, 3452, 3451, 3450, 3449, 4134, 3447, 3446, 3445, 6841, 4137, 6488, 3442, 3441, 6842, 3440, 3438, 3437, 3436, 3435, 3434, 3433, 3432, 3431, 4165, 13218, 3429, 3428, 3427, 3426, 6487, 3424, 13217, 3423, 6850, 3422, 19007, 3647, 3420, 4166, 3418, 3417, 3416, 4167, 3413, 3412, 3411, 13216, 3409, 3408, 3407, 4168, 3406, 3405, 19020, 3402, 4169, 3401, 4170, 6868, 4171, 6486, 4172, 3395, 3394, 3393, 3392, 3391, 4173, 19191, 13160, 3387, 4175, 3386, 3385, 3384, 4176, 3383, 3382, 4177, 3381, 3380, 3379, 3378, 3377, 4178, 3375, 3373, 19194, 4179, 6485, 4180, 4182, 3366, 4183, 3364, 4184, 4185, 3361, 3360, 3359, 3358, 3357, 3356, 3355, 3354, 3353, 3352, 6935, 3350, 3349, 3348, 3347, 3617, 3345, 3344, 6936, 3343, 3342, 3341, 3340, 3339, 3338, 4186, 3337, 4187, 3335, 3615, 4189, 4191, 3332, 3330, 3329, 3898, 3328, 3613, 3612, 4099, 3611, 3321, 4098, 3903, 3316, 3610, 6771, 3313, 3312, 6484, 3607, 6508, 3308, 3606, 3604, 12753, 3303, 6777, 3302, 19411, 3298, 3297, 3601, 13822, 6482, 4201, 6962, 3290, 3289, 3288, 3287, 3286, 3285, 3284, 19412, 3282, 4202, 6963, 3279, 3278, 3277, 3276, 3275, 3274, 6964, 3273, 3272, 3271, 3270, 4203, 3267, 3266, 6965, 3585, 19539, 4204, 3578, 3262, 6966, 19540, 3259, 3258, 3257, 3256, 3255, 4205, 3254, 3253, 3252, 3251, 3250, 3249, 3248, 3247, 3246, 6970, 3245, 3244, 3243, 3242, 3241, 3239, 3238, 3237, 3236, 19541, 3235, 3234, 3233, 3232, 3231, 3230, 3229, 4207, 3228, 3227, 3226, 3225, 3224, 3223, 3222, 3219, 3218, 3217, 3216, 3215, 3214, 3213, 4208, 3212, 6480, 4209, 3209, 3208, 3207, 3206, 3205, 3204, 3203, 3202, 3201, 3552, 4210, 3199, 3550, 3196, 3195, 3194, 3548, 3193, 3192, 3191, 3188, 3187, 3186, 3545, 3185, 3543, 3184, 3183, 3182, 3539, 3180, 12322, 3179, 3178, 3177, 3176, 3175, 3174, 12321, 3173, 3172, 4149, 3171, 12302, 3170, 3169, 6997, 4211, 3166, 6998, 3165, 3164, 3163, 12300, 3161, 4212, 3160, 3159, 6627, 3157, 3154, 3153, 6509, 3151, 3528, 3149, 3522, 3148, 3147, 4213, 3145, 3144, 3143, 3142, 3140, 3139, 3138, 3136, 3135, 3134, 3133, 3132, 3131, 19788, 4153, 3129, 3518, 3127, 3125, 3124, 3123, 3122, 3120, 4215, 3117, 4155, 3115, 3114, 3510, 3112, 3111, 12172, 3110, 3910, 3108, 3509, 3106, 3507, 3105, 7011, 3104, 4216, 3101, 4095, 7012, 3099, 18881, 4156, 3912, 3504, 3095, 4157, 3094, 3501, 3091, 3090, 4217, 3088, 3500, 3499, 3084, 3081, 4218, 3078, 7014, 3076, 3075, 6626, 3495, 3072, 4094, 3492, 3069, 3066, 3065, 4219, 7018, 3061, 3489, 3059, 3917, 3488, 6625, 3054, 3487, 6489, 4159, 6624, 4160, 3047, 3046, 3921, 4093, 3484, 3043, 3041, 13823, 6817, 3482, 3038, 3924, 3037, 3036, 3034, 3032, 7022, 3029, 3028, 18888, 3026, 3475, 7023, 3474, 3022, 3021, 3020, 3019, 3018, 3016, 3015, 3469, 3010, 3009, 3008, 12168, 7030, 3004, 7031, 4225, 20003, 6471, 20012, 2999, 4226, 7040, 2996, 2995, 2994, 2993, 2992, 2990, 2989, 4227, 12109, 2986, 13223, 4228, 2983, 2982, 2981, 2980, 2979, 2978, 2977, 2976, 2975, 2974, 3448, 2972, 2971, 3444, 2970, 7073, 2969, 7088, 20014, 2966, 2965, 7095, 2964, 2963, 2962, 2961, 2960, 2959, 4229, 2956, 2955, 2954, 2953, 2952, 2951, 2950, 2949, 4230, 2948, 2947, 2946, 2945, 12013, 2944, 2943, 2942, 2941, 7107, 2940, 2939, 2938, 2937, 2936, 2935, 2934, 2933, 2932, 2931, 2929, 12012, 2928, 2927, 2926, 2924, 2923, 2922, 2921, 12010, 7117, 2919, 2918, 2917, 2916, 2915, 2914, 2913, 2912, 2911, 7128, 7129, 4231, 2907, 2906, 2905, 2904, 12008, 12007, 4232, 4233, 2900, 2899, 2897, 2896, 2895, 2894, 2893, 2892, 2891, 2890, 12004, 4235, 2887, 2886, 12003, 2885, 7161, 2884, 2883, 7162, 2881, 2880, 2879, 7163, 2878, 2877, 2876, 4236, 7164, 2874, 2872, 2871, 2870, 7165, 20034, 2868, 2867, 2866, 2865, 7166, 2864, 2863, 2862, 2861, 2860, 2859, 2858, 2857, 2856, 7167, 2855, 2854, 2853, 2852, 2851, 4237, 2849, 2848, 7168, 2846, 2845, 2844, 2843, 2842, 2841, 2840, 2839, 2838, 7169, 2837, 2836, 2835, 2834, 2833, 2832, 2831, 2830, 2829, 2828, 2827, 7170, 2826, 2824, 2823, 2822, 20046, 2821, 2820, 2819, 2818, 2817, 2816, 2815, 2814, 7171, 2813, 4181, 3346, 20048, 2810, 2808, 2807, 2805, 4239, 7172, 2803, 2802, 7173, 2801, 7174, 2799, 2798, 2797, 2796, 2795, 2793, 2792, 2791, 2790, 2789, 2788, 2787, 2786, 2785, 20049, 2784, 2783, 2782, 7181, 2781, 2780, 2779, 2778, 2777, 2776, 2775, 2774, 2773, 2772, 2771, 2770, 2769, 2768, 11877, 2767, 3925, 2765, 2764, 2763, 2762, 2761, 2760, 2759, 2758, 2757, 2756, 2755, 2754, 2753, 2752, 2751, 2750, 7215, 2749, 2748, 3336, 4188, 2745, 2744, 2743, 3331, 2741, 2740, 7216, 2739, 2738, 11876, 2737, 2736, 3926, 7227, 2733, 2732, 2731, 2729, 3327, 4240, 3326, 2726, 6946, 2722, 19398, 7229, 2719, 6951, 4241, 3320, 2716, 2715, 2714, 4193, 3318, 7236, 7237, 2709, 2708, 3317, 2707, 3927, 11751, 2704, 3315, 3314, 2699, 2698, 2697, 4092, 2696, 7244, 2695, 2694, 11723, 2692, 4245, 3309, 2688, 2686, 6483, 2684, 2683, 2681, 3305, 2679, 11623, 2677, 2676, 2675, 2674, 2673, 19410, 2671, 2669, 2668, 7262, 2667, 2665, 11600, 2664, 2663, 2662, 3296, 3295, 2659, 3294, 2657, 3293, 6961, 3265, 2654, 2653, 2652, 2651, 2650, 2649, 2648, 2647, 7274, 2646, 2645, 4246, 2643, 2642, 11489, 2641, 2640, 2639, 7275, 11430, 2637, 2636, 7276, 2635, 2634, 2633, 2632, 2630, 7277, 2629, 4247, 2626, 7279, 2625, 2624, 13882, 4248, 2621, 2620, 2619, 2618, 2617, 2616, 7280, 2615, 2614, 2613, 2612, 2611, 2610, 2609, 7282, 4249, 4250, 2603, 4251, 7283, 2599, 2597, 2596, 2595, 2592, 2591, 2590, 2589, 2588, 2587, 2586, 2585, 4253, 11367, 2582, 2581, 2579, 2578, 2577, 2576, 2575, 2574, 2573, 2572, 2571, 2570, 2569, 2568, 4254, 2566, 2565, 2563, 2562, 2561, 2560, 2559, 7301, 2556, 2555, 2554, 2553, 7302, 2552, 4255, 2549, 2548, 2547, 2546, 2545, 2544, 7303, 2543, 11321, 2542, 2541, 2540, 7304, 2539, 2538, 2537, 2536, 2535, 2534, 7305, 2533, 4256, 2530, 2529, 4257, 2528, 2527, 2526, 7306, 2524, 2523, 2521, 2520, 2519, 2518, 4258, 2517, 2516, 7307, 2515, 2514, 2513, 11320, 2512, 2511, 7308, 2510, 2509, 2508, 2507, 2506, 7309, 2504, 2503, 2502, 4259, 7310, 20167, 2499, 2498, 2497, 2496, 2495, 11319, 2494, 2493, 7311, 4260, 2491, 2490, 2489, 2488, 7312, 2487, 2486, 2485, 2484, 2483, 2482, 2481, 2480, 2479, 2478, 2477, 2476, 2475, 2474, 2473, 6456, 2471, 2470, 2469, 2468, 3198, 2467, 2466, 2465, 2464, 3197, 2462, 2461, 6623, 2460, 2459, 2458, 2457, 2455, 2453, 2452, 2451, 2450, 17777, 2448, 2447, 2446, 3189, 2445, 2444, 2443, 2442, 2441, 2440, 4263, 2437, 2434, 20202, 7315, 6511, 4265, 3181, 2429, 2428, 2427, 2426, 2424, 2423, 2422, 2421, 2420, 2419, 7316, 4267, 7317, 2417, 2416, 2415, 2414, 2413, 2412, 2411, 2410, 3158, 2409, 2408, 2407, 7318, 2406, 2405, 2404, 2403, 2402, 4268, 2400, 4269, 2398, 2397, 2396, 7319, 2395, 7321, 2392, 2390, 2389, 2388, 4270, 2387, 2386, 2385, 2384, 6999, 20480, 7322, 3156, 7323, 4271, 3155, 3932, 4272, 2370, 20670, 2368, 2367, 3152, 3150, 2365, 2364, 2363, 2362, 2361, 2360, 3137, 2358, 2357, 2356, 2355, 2354, 2353, 2352, 2351, 2350, 2349, 2348, 2347, 2346, 4273, 2345, 2344, 2343, 7328, 2342, 2341, 4274, 2339, 2338, 2337, 2336, 3130, 6455, 7330, 2334, 2333, 2332, 2331, 7331, 4275, 2329, 2328, 7332, 2327, 4276, 7333, 2324, 4214, 2321, 7334, 2320, 2319, 7335, 2316, 2315, 2314, 4277, 2311, 2310, 2309, 2308, 4278, 2306, 2305, 2303, 13894, 6446, 4280, 2299, 3116, 3933, 2296, 2295, 2294, 2293, 7336, 4281, 3113, 3109, 2287, 2286, 2285, 2284, 7337, 2283, 3934, 2281, 4282, 2279, 2278, 3107, 2275, 2274, 7338, 2272, 11211, 4283, 7339, 2268, 3100, 2266, 7340, 4284, 2264, 2263, 7341, 4091, 4285, 20999, 3098, 2258, 2257, 3096, 7013, 6445, 7342, 3093, 7343, 3087, 2248, 2247, 7344, 2246, 2245, 2244, 2243, 2242, 7346, 11208, 2240, 7347, 3085, 2238, 2237, 2236, 2235, 2234, 3083, 2233, 21000, 7348, 2230, 2229, 2228, 3082, 3079, 2225, 21010, 2223, 4287, 2221, 2219, 2218, 2216, 4288, 2215, 7350, 2214, 2213, 2212, 2211, 3074, 3938, 2209, 3073, 2206, 3070, 2204, 2202, 4289, 7015, 7351, 2199, 3068, 3067, 7352, 2193, 3939, 2192, 7353, 21553, 2189, 2188, 4290, 2186, 2185, 2184, 7354, 2182, 2181, 2180, 3060, 2178, 2177, 3058, 2176, 2175, 4221, 2171, 7355, 4089, 7356, 3942, 3056, 2166, 2165, 4081, 3055, 2163, 2162, 21590, 3053, 4088, 19998, 19999, 3051, 2156, 7020, 4222, 6513, 2152, 3970, 4292, 6622, 6621, 3048, 2146, 7021, 2145, 21800, 2143, 2141, 3044, 2138, 3947, 2136, 4086, 3042, 2133, 6602, 2132, 7359, 6601, 4085, 6514, 3040, 2127, 3039, 2125, 3950, 3973, 3035, 21848, 4295, 3974, 2117, 2116, 2114, 2113, 3033, 4223, 4079, 4078, 2110, 2109, 21849, 3027, 4296, 22000, 22001, 7392, 2102, 3976, 3977, 3024, 4299, 7393, 2091, 2090, 2088, 4301, 2085, 3978, 22003, 7394, 4077, 2079, 2078, 7395, 2077, 2076, 7397, 2075, 2073, 2072, 3012, 2071, 4304, 22004, 7401, 2066, 22005, 4305, 2063, 4306, 2061, 2060, 2059, 4307, 2058, 2057, 2056, 2055, 4308, 2054, 6442, 2052, 4309, 2051, 2050, 4310, 11174, 11173, 22289, 7410, 11172, 22305, 7411, 7421, 22321, 22335, 4311, 11171, 2039, 22343, 7426, 2037, 2036, 7427, 22347, 4312, 22351, 22370, 2032, 4313, 22537, 4314, 2029, 4316, 6583, 6432, 4320, 7428, 17756, 4322, 22763, 7429, 22800, 2985, 4323, 22951, 2017, 20013, 4324, 4326, 23000, 7430, 23001, 7431, 23002, 23003, 23004, 23005, 4327, 23053, 4329, 23272, 23294, 6421, 23333, 4330, 4331, 23400, 23401, 23402, 6420, 4334, 11165, 4076, 4335, 4336, 23456, 6419, 23457, 7437, 6418, 23546, 4340, 1985, 1983, 1982, 11164, 4341, 1980, 1979, 1978, 1977, 6417, 11163, 1970, 1969, 11162, 1968, 1967, 1966, 1965, 1964, 1963, 11161, 1962, 1961, 1960, 7471, 1959, 17755, 7473, 1957, 1956, 1955, 4344, 1953, 1952, 1951, 1950, 1949, 1948, 7474, 4345, 1946, 1945, 1944, 1943, 1942, 1941, 1940, 1939, 1938, 1937, 1936, 1934, 1933, 1932, 11112, 1931, 1930, 1929, 1928, 4346, 1926, 1925, 1923, 7491, 1922, 24000, 1921, 1920, 1919, 4347, 1917, 1916, 1915, 1913, 4348, 1910, 1909, 1908, 1907, 1906, 1905, 1904, 1903, 1902, 24001, 24002, 1899, 7508, 1898, 1897, 1896, 7509, 1894, 1893, 1892, 7510, 1891, 1890, 1889, 1888, 1887, 1886, 24003, 1885, 1884, 7511, 4349, 1882, 1881, 1880, 1879, 1878, 1877, 1876, 11109, 1874, 11108, 1873, 1872, 1870, 1869, 1868, 1867, 1866, 1865, 24004, 24005, 24006, 11106, 4350, 1860, 1859, 1857, 11105, 1856, 1855, 1854, 1853, 1852, 1851, 1850, 1849, 1848, 1847, 1846, 1845, 1844, 1843, 1842, 11104, 1841, 11103, 4351, 7542, 1838, 1837, 1836, 24242, 1834, 1833, 1832, 1831, 1830, 1829, 1828, 7543, 4075, 1826, 4352, 7544, 1824, 1822, 1821, 1820, 1819, 7545, 1818, 1817, 1816, 1815, 7546, 1814, 24249, 1813, 4353, 1810, 1809, 4354, 7547, 24321, 1804, 1803, 1802, 24322, 6410, 1798, 1797, 7548, 1796, 1795, 1794, 1793, 24386, 6409, 1790, 1789, 1788, 1787, 1786, 1785, 1784, 4359, 7549, 1781, 1780, 1779, 1778, 1777, 1776, 1775, 1774, 7550, 1773, 1772, 1771, 1770, 1769, 1768, 7551, 1767, 7560, 1766, 1765, 1764, 4360, 1760, 1759, 1758, 1757, 1756, 24465, 1754, 4361, 17754, 4362, 1751, 1749, 1748, 1747, 1746, 4366, 1744, 7563, 1743, 1742, 1741, 11095, 1740, 1739, 4368, 1738, 1737, 6408, 1734, 7566, 1733, 1732, 1731, 4370, 7569, 1729, 1728, 1727, 7570, 1726, 1725, 1724, 7574, 24577, 4371, 7588, 24666, 24676, 1716, 1714, 4372, 4373, 1710, 4377, 1706, 1705, 1704, 1702, 24677, 4378, 24678, 7606, 17729, 1698, 1697, 1696, 1695, 4379, 1693, 1692, 1690, 1689, 7624, 24680, 1686, 24754, 1685, 1684, 6407, 1682, 1681, 7626, 6406, 1679, 1678, 6405, 1676, 1675, 1674, 1673, 24850, 4238, 24922, 4389, 1669, 4390, 18186, 25002, 1665, 4391, 25003, 25004, 3987, 1660, 1659, 1657, 1656, 1655, 1654, 1653, 25005, 4392, 4393, 25006, 4394, 1649, 1648, 7629, 1647, 1646, 25007, 6404, 1644, 1643, 1642, 7630, 1640, 7631, 1639, 4395, 1637, 1636, 1634, 7633, 1633, 4396, 10990, 1631, 1630, 1629, 1628, 1627, 10933, 1626, 1625, 1624, 7648, 1623, 4400, 10880, 1621, 25008, 1619, 10860, 1618, 1617, 7672, 1616, 4402, 1614, 1613, 1612, 1611, 7673, 1610, 1609, 7674, 1608, 1606, 7675, 4403, 1604, 1603, 1602, 1601, 1599, 7677, 1597, 10810, 1596, 1595, 10809, 1593, 4404, 1591, 1590, 7680, 1589, 1588, 1587, 1586, 25009, 1585, 4405, 7683, 1582, 1581, 10805, 1579, 1578, 1577, 7689, 1576, 1575, 1574, 1573, 1572, 1571, 1570, 1568, 1567, 4406, 1564, 1563, 1562, 1561, 4408, 10800, 4409, 4410, 1557, 7697, 7700, 1555, 1554, 1553, 4411, 4412, 4413, 7707, 6403, 3988, 4416, 4417, 4419, 1546, 25471, 4420, 4421, 2747, 4422, 25576, 2746, 25604, 2742, 4423, 4425, 6582, 7708, 25793, 1536, 4426, 25900, 1534, 25901, 2735, 25902, 4074, 1530, 25903, 6515, 25954, 25955, 10631, 7720, 7724, 4427, 4428, 6402, 26133, 7726, 1520, 6581, 26257, 26260, 4429, 7727, 26261, 1514, 26262, 1512, 26263, 4431, 2730, 4432, 7728, 26486, 1506, 2727, 26487, 1504, 26489, 7228, 4441, 2724, 7734, 13929, 27004, 17555, 3951, 4073, 27006, 2721, 7235, 1490, 27008, 1489, 2720, 1487, 6390, 1485, 4448, 18185, 1481, 4450, 2713, 4451, 1478, 1477, 4452, 4453, 4455, 27345, 1471, 4456, 11796, 7738, 1468, 7742, 7743, 4457, 4458, 1463, 27442, 10548, 1460, 27504, 2705, 2703, 4072, 7747, 6382, 27782, 20057, 1452, 27876, 4244, 27999, 1450, 28000, 1447, 28001, 4484, 4485, 4486, 28119, 4071, 28200, 4487, 10544, 10543, 28240, 4488, 13930, 28589, 6370, 4502, 18136, 6363, 1431, 2690, 6360, 2689, 1428, 2687, 29167, 1425, 6568, 2685, 6355, 1421, 10542, 4535, 29999, 7775, 2680, 1415, 30002, 10541, 10540, 30003, 4536, 30004, 11720, 4537, 30100, 2678, 4538, 30260, 1406, 4546, 4547, 4548, 4549, 7779, 4551, 6344, 30832, 4070, 4552, 6558, 7781, 2672, 30999, 2670, 31020, 31029, 1392, 2666, 4069, 4553, 6343, 4554, 6326, 6325, 18104, 7784, 4556, 31400, 4084, 1382, 1380, 4563, 31457, 1378, 1377, 6322, 31620, 1375, 2661, 2660, 4566, 31685, 7786, 2658, 31765, 4568, 31948, 2656, 31949, 4569, 2655, 6321, 6551, 4573, 32034, 2593, 6320, 6317, 6316, 4590, 4591, 4011, 32249, 7787, 4592, 32400, 32483, 32635, 4593, 4594, 32636, 7794, 4595, 1345, 1344, 1343, 10439, 1342, 1341, 4596, 7797, 1338, 6315, 7798, 4597, 1335, 1333, 1332, 4598, 1329, 7799, 1326, 7801, 1325, 1323, 7802, 1320, 4603, 4604, 7810, 4605, 6306, 4621, 10321, 1313, 1312, 7845, 7846, 6301, 6300, 1304, 4659, 7847, 10288, 10260, 7869, 10253, 4661, 1298, 7870, 7871, 7872, 1295, 1294, 1293, 1292, 10252, 4663, 1289, 1288, 7880, 7887, 1286, 1285, 1284, 1283, 1281, 1280, 4664, 1278, 1275, 1274, 1273, 7901, 7902, 1269, 1267, 1266, 1265, 7903, 4666, 1263, 17235, 4667, 1260, 10201, 1258, 10200, 1257, 1256, 10162, 1255, 1254, 1253, 1252, 4668, 10161, 4669, 4670, 1246, 1245, 7932, 1242, 7933, 4671, 1238, 1237, 10129, 1235, 10128, 10125, 1232, 1231, 1230, 10117, 4673, 6269, 1227, 7962, 1226, 10116, 1225, 1224, 4674, 7967, 10114, 1219, 4675, 7979, 4676, 4677, 7980, 32801, 10113, 4678, 4679, 7981, 1206, 1205, 4680, 7982, 1203, 1202, 4681, 10111, 10110, 1197, 4682, 10107, 1193, 7997, 32811, 4683, 1189, 4684, 10104, 10103, 10102, 4685, 1181, 4686, 1177, 4688, 1172, 1171, 1170, 10100, 4690, 8020, 10081, 4691, 8026, 17234, 1161, 1160, 4692, 10080, 8032, 17225, 1155, 8033, 17224, 8034, 10055, 8040, 4701, 8043, 8044, 10051, 1146, 8051, 8053, 6268, 4702, 6267, 1142, 1140, 4703, 4704, 8054, 8055, 6253, 4725, 8056, 1133, 8057, 8058, 8059, 1129, 8066, 4726, 10050, 8067, 4727, 8074, 1120, 4728, 4729, 1115, 8091, 32896, 4730, 4731, 8101, 4732, 4733, 6252, 8102, 8115, 4737, 4738, 4739, 4740, 33060, 4741, 33123, 8117, 8121, 4742, 8122, 4743, 4744, 8128, 4747, 8129, 33331, 33333, 33334, 4749, 8130, 4750, 33434, 4751, 4752, 6244, 8131, 4753, 6243, 8132, 33656, 6242, 6241, 17223, 14002, 4784, 4785, 34249, 4786, 34378, 34379, 4787, 4788, 4789, 4790, 34567, 4791, 14033, 6209, 6201, 4801, 34962, 34963, 34964, 34980, 35000, 35001, 35002, 35003, 35004, 35005, 35006, 6200, 4802, 4803, 4804, 35354, 35355, 35356, 35357, 6163, 4827, 17222, 8140, 6162, 17221, 4837, 4838, 4839, 6160, 36001, 4840, 6159, 4841, 4842, 36411, 36423, 36424, 4843, 36443, 36444, 36462, 36524, 4844, 36602, 4845, 4846, 36700, 4847, 6149, 36865, 4849, 4850, 8148, 4851, 14034, 6148, 4867, 8149, 4868, 4869, 8153, 8160, 4870, 37475, 8161, 37483, 8162, 37601, 8182, 8183, 8184, 4871, 9997, 8190, 4878, 37654, 4879, 14142, 4880, 8191, 38000, 38001, 4882, 38002, 9996, 4883, 4884, 4885, 38201, 38202, 38203, 8195, 6144, 4261, 4894, 14143, 17220, 4901, 8199, 4902, 14145, 4012, 4913, 7313, 9994, 4914, 4915, 8204, 13785, 8205, 8206, 6140, 17219, 4013, 4936, 4937, 8207, 4940, 6133, 4941, 6130, 4942, 8208, 4014, 2454, 9993, 4950, 38800, 4951, 38865, 4952, 4953, 6124, 14149, 6122, 6121, 4969, 4970, 8230, 6118, 4980, 4984, 4985, 8231, 4986, 7314, 8243, 4988, 9987, 4989, 8276, 4990, 4991, 8280, 6117, 6116, 9978, 4015, 17185, 17184, 8301, 4264, 9966, 39681, 9956, 8313, 4266, 4068, 6549, 6114, 9955, 9954, 8320, 5006, 8321, 5007, 5008, 8322, 16995, 9953, 9952, 16994, 14150, 4017, 14154, 5022, 4018, 9951, 8351, 4019, 5024, 5025, 40023, 9925, 8376, 13820, 5026, 5027, 8377, 5028, 4021, 5029, 40404, 8378, 5031, 4067, 8379, 8380, 5032, 5034, 8384, 5042, 6109, 4023, 5043, 8404, 5044, 8405, 8415, 8416, 5045, 8417, 4066, 5046, 9903, 5047, 5048, 16991, 5049, 16959, 16950, 6108, 6107, 8442, 5056, 4026, 5057, 8444, 5058, 5059, 40841, 40842, 6104, 40843, 5062, 8450, 5064, 40853, 5065, 8457, 9899, 5067, 8473, 41111, 9889, 5068, 5069, 8501, 8502, 6102, 4027, 8503, 41121, 5071, 9888, 5072, 8554, 41230, 4028, 8555, 5073, 2380, 8567, 5075, 9802, 5078, 5079, 2379, 6099, 2374, 8609, 772, 8610, 5082, 6088, 5083, 5084, 2373, 7324, 3953, 5085, 8611, 4030, 5086, 41796, 41797, 6087, 8612, 9801, 5092, 4031, 8613, 5093, 5094, 6086, 5099, 8614, 6084, 9800, 8615, 4032, 16789, 42508, 7327, 5103, 42509, 2359, 5104, 9762, 7329, 9753, 4033, 9750, 5105, 5106, 5107, 6083, 5112, 9747, 8665, 6082, 8666, 5115, 5116, 6081, 9695, 8688, 5117, 6080, 6076, 8699, 5134, 8711, 5135, 5136, 4034, 9668, 8732, 8733, 8750, 6075, 8763, 16666, 8764, 5146, 5150, 6074, 5153, 5154, 8778, 8786, 4064, 8787, 5155, 5156, 5157, 693, 5161, 8793, 9640, 2322, 5162, 4037, 43189, 43190, 6073, 8804, 43191, 43210, 5163, 5164, 5165, 679, 5166, 4038, 6072, 9632, 5167, 9631, 5168, 16665, 671, 5172, 9630, 9629, 43439, 8834, 43440, 6071, 2318, 16619, 9617, 43441, 9614, 5192, 16385, 2317, 5194, 8881, 5195, 5196, 650, 6070, 9612, 5197, 5203, 6069, 5209, 44123, 16384, 5215, 44321, 6066, 44322, 44323, 8890, 5224, 16368, 5227, 8891, 5228, 6064, 44444, 5229, 13786, 2298, 8893, 8894, 9599, 5230, 9598, 2297, 5231, 5236, 9597, 44544, 16367, 44553, 4041, 44600, 8901, 5237, 6061, 9596, 4042, 5245, 8910, 2290, 2289, 8911, 597, 44818, 44900, 595, 5246, 594, 14250, 45000, 45001, 592, 45002, 5247, 590, 45045, 589, 5248, 588, 45054, 586, 5249, 585, 584, 2282, 2277, 5251, 581, 580, 579, 45514, 5253, 5254, 6058, 576, 45678, 575, 574, 5264, 573, 8912, 6057, 2276, 45824, 45825, 2273, 5265, 567, 566, 565, 45966, 2267, 16361, 562, 6056, 5270, 5271, 559, 558, 5272, 8913, 46336, 6054, 5281, 6053, 551, 5282, 550, 8937, 549, 46998, 46999, 47000, 547, 546, 47001, 9555, 47100, 2259, 5299, 539, 8953, 16360, 537, 4043, 16311, 534, 5304, 2256, 532, 5305, 531, 16310, 2255, 5306, 529, 9536, 2254, 527, 47808, 2252, 47809, 5307, 9522, 5309, 4286, 6049, 521, 5310, 520, 48000, 519, 2249, 48001, 517, 2239, 48002, 48003, 48004, 48005, 48049, 48050, 5312, 5313, 5314, 48128, 508, 48129, 5315, 506, 5316, 504, 5317, 503, 5318, 8981, 48556, 16309, 5320, 5321, 499, 6048, 498, 48653, 6047, 495, 6046, 494, 5343, 5344, 8989, 6045, 490, 49000, 489, 5349, 488, 5350, 4044, 2231, 8990, 484, 483, 8991, 482, 8997, 8998, 5351, 478, 5352, 477, 476, 9450, 474, 6044, 2227, 9445, 2226, 471, 5354, 7349, 9007, 469, 5355, 468, 16162, 467, 5356, 9008, 5358, 463, 4063, 5359, 461, 2220, 5360, 459, 5361, 5362, 455, 5363, 13818, 2217, 5364, 6043, 6042, 5397, 5398, 5399, 9023, 6041, 5401, 9024, 5402, 5403, 2210, 5404, 4046, 436, 2208, 5406, 2207, 433, 5407, 2205, 431, 5408, 430, 6040, 429, 9025, 5409, 426, 5410, 9026, 424, 5411, 421, 5412, 2198, 9402, 5413, 4047, 9401, 13819, 9397, 4049, 5415, 9396, 4062, 5416, 409, 5417, 9390, 9389, 5418, 405, 4050, 5419, 5420, 4051, 5421, 5422, 398, 6039, 4052, 5424, 396, 6038, 395, 5425, 394, 393, 9388, 2183, 5426, 11202, 390, 5427, 9387, 5428, 387, 5429, 386, 385, 5430, 384, 3965, 9380, 382, 16021, 381, 2174, 16020, 379, 378, 377, 5434, 376, 375, 5435, 374, 6620, 372, 5436, 371, 2172, 5437, 368, 367, 9083, 6037, 365, 21554, 5443, 363, 6036, 16003, 2168, 5445, 3966, 359, 5450, 2164, 6035, 357, 5453, 356, 4053, 5454, 354, 5455, 9085, 349, 5456, 348, 347, 5461, 3954, 345, 5462, 344, 9374, 5463, 4054, 9086, 9087, 2158, 3955, 324, 9088, 323, 2154, 5464, 321, 320, 319, 318, 317, 5465, 2149, 4055, 5470, 314, 9089, 313, 5471, 312, 5472, 310, 9346, 309, 9345, 5474, 9092, 4061, 6034, 9093, 2147, 4083, 287, 286, 283, 282, 9344, 281, 4057, 4293, 21845, 269, 6033, 266, 3958, 263, 2137, 6032, 16002, 6031, 6444, 5503, 5504, 5505, 9321, 9119, 2130, 5506, 247, 246, 5507, 245, 15999, 244, 243, 242, 9122, 3959, 6029, 9123, 4059, 2128, 6028, 9318, 9312, 2173, 9306, 6027, 5540, 15998, 6026, 9295, 6024, 218, 2169, 215, 5556, 9294, 6023, 5565, 15740, 5567, 208, 5568, 207, 2167, 5569, 5573, 203, 5574, 5575, 6022, 5579, 198, 5582, 197, 5583, 195, 5584, 5585, 4291, 9162, 2159, 9163, 2157, 5586, 188, 6020, 187, 186, 5597, 2155, 5598, 183, 9164, 9293, 2153, 5599, 5600, 5601, 178, 5602, 175, 2151, 9292, 7357, 5603, 172, 171, 170, 5604, 169, 5605, 167, 166, 165, 6019, 164, 5618, 5627, 2140, 5628, 160, 9286, 159, 5629, 5630, 9285, 6018, 156, 155, 154, 153, 5634, 152, 6016, 5635, 2139, 5636, 7358, 5637, 147, 9284, 5638, 5639, 145, 5646, 6014, 5670, 5671, 140, 5673, 5674, 2131, 5675, 134, 9201, 5676, 21846, 131, 5677, 2129, 7365, 126, 9203, 6013, 5681, 5682, 121, 9204, 5683, 2123, 6012, 5684, 2122, 21847, 5687, 4060, 5688, 5689, 6011, 5693, 5696, 5700, 9205, 2118, 107, 15555, 9206, 105, 5715, 5716, 9283, 15363, 5719, 9208, 5720, 11201, 11175, 7391, 22002, 5724, 5725, 9209, 5726, 5727, 5728, 9282, 9212, 5729, 5741, 5742, 5743, 5744, 5745, 78, 5746, 9213, 5747, 9214, 5748, 2098, 5750, 14414, 5755, 2097, 9215, 5757, 2094, 64, 5766, 63, 62, 61, 5767, 9216, 5768, 2093, 5769, 2092, 9217, 2089, 5770, 5771, 5777, 9281, 5780, 5781, 5782, 5783, 5784, 46, 5785, 2084, 9222, 5786, 61439, 61440, 41, 61441, 39, 5787, 6443, 5793, 9280, 5794, 15345, 5993, 4303, 5992, 2074, 5991, 9279, 5813, 9278, 9277, 5990, 5841, 5842, 5863, 18, 5984, 5979, 5883, 15126, 15118, 14936, 14937, 5, 5913, 2594, 9255]

def PrintManual():
    manual = '''
Manual:

This program tries to identify services listening on TCP ports, by sending probes and checking replies.
Probes and replies are stored inside an external file. By default, this file is nmap's %s file.
nmap's %s file is not included with this program, you will need to take a copy from an nmap distribution package and put it in the same directory as this program.

By default, the TCP connections of this tool go over the Tor network. Option -P (--proxy) can be used to select another proxy than Tor, or specify that no proxy should be used: noproxy.

This tool takes one or more IP addresses and/or hostnames as arguments.
Option -p is used to specify the TCP ports to connect to.
Option -p takes a list of ports or port ranges separated by comma (,), like this: 80,443,12345-12349
A port is just a number, a port range is two numbers separated by a dash (-).
A special keyword is reserved for the top tcp ports according to nmap: keyword top.
onion-connect-service-detection.py -p top example.com will scan the top tcp ports according to nmap.
A selection can be made with top: top:100 will select the first 100 most prevalent ports, and top:-50 will select the last 50 most prevalent ports.
-p top:1000:100 will select 100 ports starting from the 1000th most prevalent port.
Prefix the provided ports with ~ to reverse the order (only useful with low workers count).

Use option -f to provide an probe file to use.

By default, probes with a rarity between 1 and 7 are used. Use option -r to change the rarity. For example, option -r 10 will use all probes (ratiry 1 to 10).
You can also provide a range: -r 3-5 for example, this will try probes with a rarity between 3 and 5.
If a scan with default rarity does not provide results, and you want to try all probes with a higher rarity without retrying the probes with rarity between 1 and 7, use option -r 8-10.

Use option -t to provide a timeout value in seconds.

Use option -s to probe over SSL/TLS connections in stead of TCP connections.

Use option -q to provide a list of probes to use: separate probe names by a comma. Probe names are not case sensitive.

Use option -H to include simple HTTP reply matching: this will match all replies that start with "HTTP/1.1 0" as HTTP replies.

Option -i can be used to lookup info on a port: no scan is performed, but a list of probes is provided, that would be used to scan said port.

-V is verbose mode.

Use option --maxworkers to specify the maximum numer of concurrent workers (e.g., threads). The default value is 25.
Use value 1 to scan all ports sequentially.

''' % (NMAPSERVICEPROBES, NMAPSERVICEPROBES)
    for line in manual.split('\n'):
        print(textwrap.fill(line))

def File2Strings(filename):
    try:
        if filename == '':
            f = sys.stdin
        else:
            f = open(filename, 'rb')
    except:
        return None
    try:
        return map(lambda line:line.rstrip(b'\n'), f.readlines())
    except:
        return None
    finally:
        if f != sys.stdin:
            f.close()

def ParseNumber(number):
    if number.startswith('0x'):
        return int(number[2:], 16)
    else:
        return int(number)

def MyRange(begin, end):
    if begin < end:
        return range(begin, end + 1)
    elif begin == end:
        return [begin]
    else:
        return range(begin, end - 1, -1)

def ParsePorts(expression):
    if expression.startswith('~'):
        reverse = True
        expression = expression[1:]
    else:
        reverse = False
    ports = []
    for portrange in expression.split(','):
        if portrange.startswith('top'):
            topOption = portrange.split(':')
            if topOption[0] != 'top':
                raise Exception('Ports option syntax error')
            if len(topOption) == 1:
                ports.extend(TOP_TCP_PORTS)
            elif len(topOption) == 2:
                number = ParseNumber(topOption[1])
                if number > 0:
                    ports.extend(TOP_TCP_PORTS[:number])
                else:
                    ports.extend(TOP_TCP_PORTS[number:])
            elif len(topOption) == 3:
                position = ParseNumber(topOption[1])
                length = ParseNumber(topOption[2])
                ports.extend(TOP_TCP_PORTS[position - 1:position - 1 + length])
            else:
                raise Exception('Ports option syntax error')
        else:
            result = portrange.split('-')
            if len(result) == 1:
                ports.append(ParseNumber(result[0]))
            else:
                ports.extend(MyRange(ParseNumber(result[0]), ParseNumber(result[1])))
    if reverse:
        ports = ports[::-1]
    return ports

def ParseRarity(expression):
    rarities = []
    result = expression.split('-')
    if len(result) == 1:
        rarities.extend(MyRange(0, ParseNumber(result[0])))
    else:
        rarities.extend(MyRange(ParseNumber(result[0]), ParseNumber(result[1])))
    return rarities

class cMatch():
    def __init__(self, line):
        self.lineMatch = line
        self.regroups = tuple()
        elements = line.split(b' ', 2)
        if elements[0] != b'match':
            raise Exception('match keyword expected!')
        self.name = elements[1]
        if elements[2][0] != ord('m'):
            raise Exception('m keyword expected! - ' % line)
        delimiter = elements[2][1]
        position = elements[2].find(delimiter, 2)
        if position == -1:
            raise Exception('delimiter expected! - ' % line)
        self.regex = elements[2][2:position]
        self.remainder = elements[2][position+1:]
        if len(self.remainder) == 0:
            return
        if self.remainder[0] == b' ':
            self.remainder = self.remainder.lstrip()
        else:
            position = self.remainder.find(b' ')
            if position == -1:
                self.regexOptions = self.remainder
                self.remainder = b''
            else:
                self.regexOptions = self.remainder[0:position]
                self.remainder = self.remainder[position + 1:]

    def Remainder(self):
        remainder = self.remainder
        for index, item in enumerate(self.regroups):
            remainder = remainder.replace(b'$%d' % (index + 1), item)
        return remainder

class cServiceProbe():
    orderCounter = 0

    def __init__(self, line):
        self.lineProbe = line
        elements = line.split(b' ', 3)
        self.type = elements[1]
        self.name = elements[2]
        self.ports = []
        self.sslports = []
        self.order = cServiceProbe.orderCounter
        cServiceProbe.orderCounter = cServiceProbe.orderCounter + 1
        if not elements[3].startswith(b'q') or len(elements[3]) < 3 or elements[3][1] != elements[3][-1]:
            raise Exception('query not found: %s' % line)
        self.query = elements[3][2:-1]
        self.matches = []
        self.softmatches = []

    def ParseLine(self, line):
        elements = line.split(b' ', 1)
        if elements[0] == b'rarity':
            self.rarity = int(elements[1])
        elif elements[0] == b'ports':
            self.ports = ParsePorts(elements[1].decode())
        elif elements[0] == b'sslports':
            self.sslports = ParsePorts(elements[1].decode())
        elif elements[0] == b'fallback':
            self.fallback = elements[1]
        elif elements[0] == b'match':
            self.matches.append(line)
        elif elements[0] == b'softmatch':
            self.softmatches.append(line)

    def Match(self, data):
        for line in self.matches:
            oMatch = cMatch(line)
            oREMatch = re.match(oMatch.regex, data)
            if oREMatch != None:
                oMatch.regroups = oREMatch.groups()
                return oMatch
        return None

class cServiceProbes():
    def __init__(self, filename):
        self.dProbes = {}
        oServiceProbe = None
        for line in File2Strings(filename):
            line = line.strip()
            if line.startswith(b'#'):
                continue
            if line == b'':
                continue
            entryType = line.split(b' ', 1)[0]
            if entryType == b'Probe':
                oServiceProbe = cServiceProbe(line)
                self.dProbes[oServiceProbe.name] = oServiceProbe
            elif oServiceProbe != None:
                oServiceProbe.ParseLine(line)

    def SelectProbes(self, type, port, rarities, portonly=False):
        probesPortMatching = []
        probesPortNotMatching = []
        for oServiceProbe in self.dProbes.values():
            if oServiceProbe.type == type and oServiceProbe.name != b'NULL' and oServiceProbe.rarity in rarities:
                if port in oServiceProbe.ports or port in oServiceProbe.sslports:
                    probesPortMatching.append(oServiceProbe)
                elif not portonly:
                    probesPortNotMatching.append(oServiceProbe)
        return [oServiceProbe for oServiceProbe in sorted(probesPortMatching, key=operator.attrgetter('rarity', 'order'))] + [oServiceProbe for oServiceProbe in sorted(probesPortNotMatching, key=operator.attrgetter('rarity', 'order'))]

class cMySocket():
    def __init__(self, options):
        self.ssl = False
        if options.proxy == NOPROXY:
            self.oSocket = socket.socket()
        else:
            proxyhost, proxyport = options.proxy.split(':')
            proxyport = ParseNumber(proxyport)
            self.oSocket = socks.socksocket()
#            print('[*] Setting SOCKS5 proxy %s %s' % (proxyhost, proxyport))
            self.oSocket.set_proxy(socks.SOCKS5, proxyhost, proxyport)
        if options.timeout != '':
            self.oSocket.settimeout(ParseNumber(options.timeout))

    def SSL(self):
        self.ssl = True
        self.oSSLContext = ssl.create_default_context()
        self.oSSLContext.check_hostname = False
        self.oSSLContext.verify_mode = ssl.CERT_NONE
        self.oSocketOriginal = self.oSocket
        try:
            self.oSSLSocket = self.oSSLContext.wrap_socket(self.oSocket)
        except:
            self.oSocket.close()
            return False

        self.oSocket = self.oSSLSocket

        return True

    def Close(self):
        self.oSocket.close()
        if self.ssl:
            self.oSocketOriginal.close()

def GetScriptPath():
    if getattr(sys, 'frozen', False):
        return os.path.dirname(sys.executable)
    else:
        return os.path.dirname(sys.argv[0])

def PrefixIfNeeded(string, prefix=' '):
    if string == '':
        return string
    else:
        return prefix + string

def PortScanSub(host, port, forcessl, oServiceProbes, selectedProbes, options):
    report = []
    ssltlsprobes = ['SSLSessionReq', 'TLSSessionReq']
    trytls = False

    star = '[*][%5d]' % port
    if options.forcessl:
        forcessl = True
    message = '%s %s' % (host, port)
    if forcessl:
        message += ' SSL/TLS'
    print('%s Service detection %s' % (star, message))
    receiveds = []
    probesNULL = []
    if b'NULL' in oServiceProbes.dProbes:
        probesNULL.append(oServiceProbes.dProbes[b'NULL'])
    for oServiceProbe in probesNULL + oServiceProbes.SelectProbes(b'TCP', port, ParseRarity(options.rarity)):
        if selectedProbes != True and oServiceProbe.name.decode().lower() not in selectedProbes:
            continue
        if forcessl and oServiceProbe.name.decode() in ssltlsprobes:
            continue
        matchFound = False
        if options.verbose:
            print('%s Creating socket' % star)
        oMySocket = cMySocket(options)

        if options.verbose:
            print('%s Connecting %s %s' % (star, host, port))
        try:
            oMySocket.oSocket.connect((host, port))
        except Exception as e:
            if '[Errno 10061]' in e.msg:
                if 'Error connecting to SOCKS5 proxy' in e.msg:
                    print('%s error connecting to SOCKS5 proxy' % star)
                    break
                else:
                    print('%s Port is closed: %s' % (star, e.msg))
                    break
            elif 'Connection refused' in e.msg:
                print('%s Port is closed' % star)
                break
            elif e.msg == 'Socket error: 0x01: General SOCKS server failure':
                print('%s SOCKS error: %s' % (star, e.msg))
                break
            else:
                print('%s Connecting error: %s' % (star, e.msg))
                break

        if forcessl:
            if options.verbose:
                print('%s SSL' % star)
            if not oMySocket.SSL():
                print('%s SSL connection failed' % star)
                break

        print('%s Sending Probe: %s' % (star, oServiceProbe.name.decode()))
        if options.verbose:
            print('%s Query = %s' % (star, oServiceProbe.query))

#                oMySocket.oSocket.sendall(oServiceProbe.query.decode('string_escape'))
        oMySocket.oSocket.sendall(codecs.escape_decode(oServiceProbe.query)[0])

        if options.verbose:
            print('%s Receiving' % star)
        try:
            received = ''
            received = oMySocket.oSocket.recv(0x1000)
        except ssl.SSLError:
            print('%s SSLError' % star)
        except Exception as e:
            if str(e) in ['timed out', 'The read operation timed out']:
                print('%s Timed out' % star)
            else:
                raise

        if len(received) > 0 and forcessl:
            while True:
                try:
                    extra = oMySocket.oSocket.recv(0x1000)
                    if len(extra) == 0:
                        break
                    received += extra
                except Exception as e:
                    break

        if len(received) > 0:
            if received in receiveds:
                print('%s Length = %d ALREADY RECEIVED ONCE' % (star, len(received)))
            else:
                print('%s Length = %d, Received = %s' % (star, len(received), repr(received)))
                receiveds.append(received)
        else:
            print('%s Length = %d' % (star, len(received)))
        if len(received) > 0:
            oMatch = oServiceProbe.Match(received)
            if oMatch != None:
                print('%s Match %s: %s%s' % (star, message, oMatch.name.decode(), PrefixIfNeeded(oMatch.Remainder().decode(), ' - ')))
                matchFound = True
                report.append([host, port, '%s%s' % (oMatch.name.decode(), PrefixIfNeeded(oMatch.Remainder().decode(), ' - '))])
                if oServiceProbe.name.decode() in ssltlsprobes:
                    trytls = True
            elif options.http and received.startswith(b'HTTP/1.1 '):
                print('%s Match %s: HTTP %s' % (star, message, received))
                matchFound = True
                report.append([host, port, repr(received.decode())])

        if options.verbose:
            print('%s Closing' % star)
        oMySocket.Close()

        if matchFound:
            break

    return [report, trytls, host, port]

def PortScan(hosts, options):
    if options.probes != '':
        selectedProbes = [probe.lower() for probe in options.probes.split(',')]
    else:
        selectedProbes = True
    dHosts = {}
    for host in hosts:
        if not host.startswith('@'):
            if options.ports == '':
                print('No ports to scan!')
                return
            dHosts[host] = [[port, False] for port in ParsePorts(options.ports)]
        else:
            for line in File2Strings(host[1:]):
                line = line.decode()
                if ':' in line:
                    first, second = line.split(':', 1)
                    dHosts[first] = dHosts.get(first, []) + [[port, False] for port in ParsePorts(second)]
                else:
                    if options.ports == '':
                        print('No ports to scan!')
                        return
                    dHosts[host] = [[port, False] for port in ParsePorts(options.ports)]

    oServiceProbes = cServiceProbes(options.probesfile)

    if options.info:
        for port in ParsePorts(options.ports):
            oServiceProbesPort = oServiceProbes.SelectProbes(b'TCP', port, 10, True)
            print('Port: %d' % port)
            for oServiceProbe in oServiceProbesPort:
                print(' %s %d' % (oServiceProbe.name, oServiceProbe.rarity))
        return

    report = []

    queue = []
    for host in dHosts:
        ports = dHosts[host]
        while len(ports) > 0:
            port, forcessl = ports[0]
            ports = ports[1:]
            queue.append([host, port, forcessl])

    starttime = time.time()

    with concurrent.futures.ThreadPoolExecutor(max_workers=options.maxworkers) as executor:
        futuresToCheck = [executor.submit(PortScanSub, host, port, forcessl, oServiceProbes, selectedProbes, options) for host, port, forcessl in queue]
        while futuresToCheck != []:
            futuresToCheckExtra = []
            for future in concurrent.futures.as_completed(futuresToCheck):
                try:
                    reportsub, trytls, hosttls, porttls = future.result()
                    if trytls:
                        futuresToCheckExtra.append(executor.submit(PortScanSub, hosttls, porttls , True, oServiceProbes, selectedProbes, options))
                    report.extend(reportsub)
                except KeyboardInterrupt:
                    raise
                except Exception as e:
                    print(e)
            futuresToCheck = futuresToCheckExtra

    if len(report) > 0:
        print('\nMatches:')
        dReport = {}
        for host, port, line in report:
            index = (host, port)
            dReport[index] = dReport.get(index, []) + [line]
        for host, port in sorted(dReport.keys()):
            print(' %s %5d %s' % (host, port, '/'.join(dReport[(host, port)])))

    print('\nElapsed: %ds' % (time.time() - starttime))

def ValidateProbeFile(options):
    if options.probesfile == '':
        options.probesfile = os.path.join(GetScriptPath(), NMAPSERVICEPROBES)
        if not os.path.exists(options.probesfile):
            print("This program requires a probe file. You can provide your own (option -f), or copy nmap's probe file (named %s) into the same folder as this program." % NMAPSERVICEPROBES)
            return False
    elif not os.path.exists(options.probesfile):
        print('The probe file you provided (%s) does not exist.' % options.probesfile)
        return False
    return True

def Main():
    moredesc = '''

Source code put in the public domain by Didier Stevens, no Copyright
Use at your own risk
https://DidierStevens.com'''

    oParser = optparse.OptionParser(usage='usage: %prog [options] IP/hostname ...\n' + __description__ + moredesc, version='%prog ' + __version__)
    oParser.add_option('-m', '--man', action='store_true', default=False, help='Print manual')
    oParser.add_option('-p', '--ports', type=str, default='', help='Ports to scan')
    oParser.add_option('-f', '--probesfile', type=str, default='', help='Probes file to use (default %s)' % NMAPSERVICEPROBES)
    oParser.add_option('-q', '--probes', type=str, default='', help='Probes to use')
    oParser.add_option('-s', '--forcessl', action='store_true', default=False, help='Force SSL')
    oParser.add_option('-r', '--rarity', type=str, default='7', help='Rarity value (default 7)')
    oParser.add_option('-t', '--timeout', type=str, default='', help='Timeout value')
    oParser.add_option('-H', '--http', action='store_true', default=False, help='Match simple HTTP reply')
    oParser.add_option('-P', '--proxy', type=str, default='localhost:9050', help='To use another SOCKS5 proxy than localhost:9050, provide address:port. Use %s for direct connections.' % NOPROXY)
    oParser.add_option('-V', '--verbose', action='store_true', default=False, help='Verbose')
    oParser.add_option('-i', '--info', action='store_true', default=False, help="Display info, don't scan")
    oParser.add_option('--maxworkers', type=int, default=25, help='max_workers for concurrent (default 25)')
    (options, args) = oParser.parse_args()

    if options.man:
        oParser.print_help()
        PrintManual()
        return

    if not ValidateProbeFile(options):
        return

    if len(args) > 0 or options.info:
        PortScan(args, options)
    else:
        oParser.print_help()
        return

if __name__ == '__main__':
    Main()
