#       test_regex.py
#
#       Copyright 2017 Daniel Mende <mail@c0decafe.de>
#

#       Redistribution and use in source and binary forms, with or without
#       modification, are permitted provided that the following conditions are
#       met:
#
#       * Redistributions of source code must retain the above copyright
#         notice, this list of conditions and the following disclaimer.
#       * Redistributions in binary form must reproduce the above
#         copyright notice, this list of conditions and the following disclaimer
#         in the documentation and/or other materials provided with the
#         distribution.
#       * Neither the name of the  nor the names of its
#         contributors may be used to endorse or promote products derived from
#         this software without specific prior written permission.
#
#       THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#       "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#       LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#       A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#       OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#       SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#       LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#       DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#       THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#       (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#       OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
from unittest import TestCase, main
from dizzy.objects.regex import Regex
from dizzy.value import Value


class TestRegex(TestCase):
    def test_init(self):
        f = Regex("test", "[0-9a-f]{1,2}\.[a-g]")
        self.assertEqual(f.name, "test")

    def test_iter(self):
        expected = [Value(b'0.a', 24), Value(b'0.b', 24), Value(b'0.c', 24), Value(b'0.d', 24), Value(b'0.e', 24),
                    Value(b'0.f', 24), Value(b'0.g', 24), Value(b'1.a', 24), Value(b'1.b', 24), Value(b'1.c', 24),
                    Value(b'1.d', 24), Value(b'1.e', 24), Value(b'1.f', 24), Value(b'1.g', 24), Value(b'2.a', 24),
                    Value(b'2.b', 24), Value(b'2.c', 24), Value(b'2.d', 24), Value(b'2.e', 24), Value(b'2.f', 24),
                    Value(b'2.g', 24), Value(b'3.a', 24), Value(b'3.b', 24), Value(b'3.c', 24), Value(b'3.d', 24),
                    Value(b'3.e', 24), Value(b'3.f', 24), Value(b'3.g', 24), Value(b'4.a', 24), Value(b'4.b', 24),
                    Value(b'4.c', 24), Value(b'4.d', 24), Value(b'4.e', 24), Value(b'4.f', 24), Value(b'4.g', 24),
                    Value(b'5.a', 24), Value(b'5.b', 24), Value(b'5.c', 24), Value(b'5.d', 24), Value(b'5.e', 24),
                    Value(b'5.f', 24), Value(b'5.g', 24), Value(b'6.a', 24), Value(b'6.b', 24), Value(b'6.c', 24),
                    Value(b'6.d', 24), Value(b'6.e', 24), Value(b'6.f', 24), Value(b'6.g', 24), Value(b'7.a', 24),
                    Value(b'7.b', 24), Value(b'7.c', 24), Value(b'7.d', 24), Value(b'7.e', 24), Value(b'7.f', 24),
                    Value(b'7.g', 24), Value(b'8.a', 24), Value(b'8.b', 24), Value(b'8.c', 24), Value(b'8.d', 24),
                    Value(b'8.e', 24), Value(b'8.f', 24), Value(b'8.g', 24), Value(b'9.a', 24), Value(b'9.b', 24),
                    Value(b'9.c', 24), Value(b'9.d', 24), Value(b'9.e', 24), Value(b'9.f', 24), Value(b'9.g', 24),
                    Value(b'a.a', 24), Value(b'a.b', 24), Value(b'a.c', 24), Value(b'a.d', 24), Value(b'a.e', 24),
                    Value(b'a.f', 24), Value(b'a.g', 24), Value(b'b.a', 24), Value(b'b.b', 24), Value(b'b.c', 24),
                    Value(b'b.d', 24), Value(b'b.e', 24), Value(b'b.f', 24), Value(b'b.g', 24), Value(b'c.a', 24),
                    Value(b'c.b', 24), Value(b'c.c', 24), Value(b'c.d', 24), Value(b'c.e', 24), Value(b'c.f', 24),
                    Value(b'c.g', 24), Value(b'd.a', 24), Value(b'd.b', 24), Value(b'd.c', 24), Value(b'd.d', 24),
                    Value(b'd.e', 24), Value(b'd.f', 24), Value(b'd.g', 24), Value(b'e.a', 24), Value(b'e.b', 24),
                    Value(b'e.c', 24), Value(b'e.d', 24), Value(b'e.e', 24), Value(b'e.f', 24), Value(b'e.g', 24),
                    Value(b'f.a', 24), Value(b'f.b', 24), Value(b'f.c', 24), Value(b'f.d', 24), Value(b'f.e', 24),
                    Value(b'f.f', 24), Value(b'f.g', 24), Value(b'00.a', 32), Value(b'00.b', 32), Value(b'00.c', 32),
                    Value(b'00.d', 32), Value(b'00.e', 32), Value(b'00.f', 32), Value(b'00.g', 32), Value(b'01.a', 32),
                    Value(b'01.b', 32), Value(b'01.c', 32), Value(b'01.d', 32), Value(b'01.e', 32), Value(b'01.f', 32),
                    Value(b'01.g', 32), Value(b'02.a', 32), Value(b'02.b', 32), Value(b'02.c', 32), Value(b'02.d', 32),
                    Value(b'02.e', 32), Value(b'02.f', 32), Value(b'02.g', 32), Value(b'03.a', 32), Value(b'03.b', 32),
                    Value(b'03.c', 32), Value(b'03.d', 32), Value(b'03.e', 32), Value(b'03.f', 32), Value(b'03.g', 32),
                    Value(b'04.a', 32), Value(b'04.b', 32), Value(b'04.c', 32), Value(b'04.d', 32), Value(b'04.e', 32),
                    Value(b'04.f', 32), Value(b'04.g', 32), Value(b'05.a', 32), Value(b'05.b', 32), Value(b'05.c', 32),
                    Value(b'05.d', 32), Value(b'05.e', 32), Value(b'05.f', 32), Value(b'05.g', 32), Value(b'06.a', 32),
                    Value(b'06.b', 32), Value(b'06.c', 32), Value(b'06.d', 32), Value(b'06.e', 32), Value(b'06.f', 32),
                    Value(b'06.g', 32), Value(b'07.a', 32), Value(b'07.b', 32), Value(b'07.c', 32), Value(b'07.d', 32),
                    Value(b'07.e', 32), Value(b'07.f', 32), Value(b'07.g', 32), Value(b'08.a', 32), Value(b'08.b', 32),
                    Value(b'08.c', 32), Value(b'08.d', 32), Value(b'08.e', 32), Value(b'08.f', 32), Value(b'08.g', 32),
                    Value(b'09.a', 32), Value(b'09.b', 32), Value(b'09.c', 32), Value(b'09.d', 32), Value(b'09.e', 32),
                    Value(b'09.f', 32), Value(b'09.g', 32), Value(b'0a.a', 32), Value(b'0a.b', 32), Value(b'0a.c', 32),
                    Value(b'0a.d', 32), Value(b'0a.e', 32), Value(b'0a.f', 32), Value(b'0a.g', 32), Value(b'0b.a', 32),
                    Value(b'0b.b', 32), Value(b'0b.c', 32), Value(b'0b.d', 32), Value(b'0b.e', 32), Value(b'0b.f', 32),
                    Value(b'0b.g', 32), Value(b'0c.a', 32), Value(b'0c.b', 32), Value(b'0c.c', 32), Value(b'0c.d', 32),
                    Value(b'0c.e', 32), Value(b'0c.f', 32), Value(b'0c.g', 32), Value(b'0d.a', 32), Value(b'0d.b', 32),
                    Value(b'0d.c', 32), Value(b'0d.d', 32), Value(b'0d.e', 32), Value(b'0d.f', 32), Value(b'0d.g', 32),
                    Value(b'0e.a', 32), Value(b'0e.b', 32), Value(b'0e.c', 32), Value(b'0e.d', 32), Value(b'0e.e', 32),
                    Value(b'0e.f', 32), Value(b'0e.g', 32), Value(b'0f.a', 32), Value(b'0f.b', 32), Value(b'0f.c', 32),
                    Value(b'0f.d', 32), Value(b'0f.e', 32), Value(b'0f.f', 32), Value(b'0f.g', 32), Value(b'10.a', 32),
                    Value(b'10.b', 32), Value(b'10.c', 32), Value(b'10.d', 32), Value(b'10.e', 32), Value(b'10.f', 32),
                    Value(b'10.g', 32), Value(b'11.a', 32), Value(b'11.b', 32), Value(b'11.c', 32), Value(b'11.d', 32),
                    Value(b'11.e', 32), Value(b'11.f', 32), Value(b'11.g', 32), Value(b'12.a', 32), Value(b'12.b', 32),
                    Value(b'12.c', 32), Value(b'12.d', 32), Value(b'12.e', 32), Value(b'12.f', 32), Value(b'12.g', 32),
                    Value(b'13.a', 32), Value(b'13.b', 32), Value(b'13.c', 32), Value(b'13.d', 32), Value(b'13.e', 32),
                    Value(b'13.f', 32), Value(b'13.g', 32), Value(b'14.a', 32), Value(b'14.b', 32), Value(b'14.c', 32),
                    Value(b'14.d', 32), Value(b'14.e', 32), Value(b'14.f', 32), Value(b'14.g', 32), Value(b'15.a', 32),
                    Value(b'15.b', 32), Value(b'15.c', 32), Value(b'15.d', 32), Value(b'15.e', 32), Value(b'15.f', 32),
                    Value(b'15.g', 32), Value(b'16.a', 32), Value(b'16.b', 32), Value(b'16.c', 32), Value(b'16.d', 32),
                    Value(b'16.e', 32), Value(b'16.f', 32), Value(b'16.g', 32), Value(b'17.a', 32), Value(b'17.b', 32),
                    Value(b'17.c', 32), Value(b'17.d', 32), Value(b'17.e', 32), Value(b'17.f', 32), Value(b'17.g', 32),
                    Value(b'18.a', 32), Value(b'18.b', 32), Value(b'18.c', 32), Value(b'18.d', 32), Value(b'18.e', 32),
                    Value(b'18.f', 32), Value(b'18.g', 32), Value(b'19.a', 32), Value(b'19.b', 32), Value(b'19.c', 32),
                    Value(b'19.d', 32), Value(b'19.e', 32), Value(b'19.f', 32), Value(b'19.g', 32), Value(b'1a.a', 32),
                    Value(b'1a.b', 32), Value(b'1a.c', 32), Value(b'1a.d', 32), Value(b'1a.e', 32), Value(b'1a.f', 32),
                    Value(b'1a.g', 32), Value(b'1b.a', 32), Value(b'1b.b', 32), Value(b'1b.c', 32), Value(b'1b.d', 32),
                    Value(b'1b.e', 32), Value(b'1b.f', 32), Value(b'1b.g', 32), Value(b'1c.a', 32), Value(b'1c.b', 32),
                    Value(b'1c.c', 32), Value(b'1c.d', 32), Value(b'1c.e', 32), Value(b'1c.f', 32), Value(b'1c.g', 32),
                    Value(b'1d.a', 32), Value(b'1d.b', 32), Value(b'1d.c', 32), Value(b'1d.d', 32), Value(b'1d.e', 32),
                    Value(b'1d.f', 32), Value(b'1d.g', 32), Value(b'1e.a', 32), Value(b'1e.b', 32), Value(b'1e.c', 32),
                    Value(b'1e.d', 32), Value(b'1e.e', 32), Value(b'1e.f', 32), Value(b'1e.g', 32), Value(b'1f.a', 32),
                    Value(b'1f.b', 32), Value(b'1f.c', 32), Value(b'1f.d', 32), Value(b'1f.e', 32), Value(b'1f.f', 32),
                    Value(b'1f.g', 32), Value(b'20.a', 32), Value(b'20.b', 32), Value(b'20.c', 32), Value(b'20.d', 32),
                    Value(b'20.e', 32), Value(b'20.f', 32), Value(b'20.g', 32), Value(b'21.a', 32), Value(b'21.b', 32),
                    Value(b'21.c', 32), Value(b'21.d', 32), Value(b'21.e', 32), Value(b'21.f', 32), Value(b'21.g', 32),
                    Value(b'22.a', 32), Value(b'22.b', 32), Value(b'22.c', 32), Value(b'22.d', 32), Value(b'22.e', 32),
                    Value(b'22.f', 32), Value(b'22.g', 32), Value(b'23.a', 32), Value(b'23.b', 32), Value(b'23.c', 32),
                    Value(b'23.d', 32), Value(b'23.e', 32), Value(b'23.f', 32), Value(b'23.g', 32), Value(b'24.a', 32),
                    Value(b'24.b', 32), Value(b'24.c', 32), Value(b'24.d', 32), Value(b'24.e', 32), Value(b'24.f', 32),
                    Value(b'24.g', 32), Value(b'25.a', 32), Value(b'25.b', 32), Value(b'25.c', 32), Value(b'25.d', 32),
                    Value(b'25.e', 32), Value(b'25.f', 32), Value(b'25.g', 32), Value(b'26.a', 32), Value(b'26.b', 32),
                    Value(b'26.c', 32), Value(b'26.d', 32), Value(b'26.e', 32), Value(b'26.f', 32), Value(b'26.g', 32),
                    Value(b'27.a', 32), Value(b'27.b', 32), Value(b'27.c', 32), Value(b'27.d', 32), Value(b'27.e', 32),
                    Value(b'27.f', 32), Value(b'27.g', 32), Value(b'28.a', 32), Value(b'28.b', 32), Value(b'28.c', 32),
                    Value(b'28.d', 32), Value(b'28.e', 32), Value(b'28.f', 32), Value(b'28.g', 32), Value(b'29.a', 32),
                    Value(b'29.b', 32), Value(b'29.c', 32), Value(b'29.d', 32), Value(b'29.e', 32), Value(b'29.f', 32),
                    Value(b'29.g', 32), Value(b'2a.a', 32), Value(b'2a.b', 32), Value(b'2a.c', 32), Value(b'2a.d', 32),
                    Value(b'2a.e', 32), Value(b'2a.f', 32), Value(b'2a.g', 32), Value(b'2b.a', 32), Value(b'2b.b', 32),
                    Value(b'2b.c', 32), Value(b'2b.d', 32), Value(b'2b.e', 32), Value(b'2b.f', 32), Value(b'2b.g', 32),
                    Value(b'2c.a', 32), Value(b'2c.b', 32), Value(b'2c.c', 32), Value(b'2c.d', 32), Value(b'2c.e', 32),
                    Value(b'2c.f', 32), Value(b'2c.g', 32), Value(b'2d.a', 32), Value(b'2d.b', 32), Value(b'2d.c', 32),
                    Value(b'2d.d', 32), Value(b'2d.e', 32), Value(b'2d.f', 32), Value(b'2d.g', 32), Value(b'2e.a', 32),
                    Value(b'2e.b', 32), Value(b'2e.c', 32), Value(b'2e.d', 32), Value(b'2e.e', 32), Value(b'2e.f', 32),
                    Value(b'2e.g', 32), Value(b'2f.a', 32), Value(b'2f.b', 32), Value(b'2f.c', 32), Value(b'2f.d', 32),
                    Value(b'2f.e', 32), Value(b'2f.f', 32), Value(b'2f.g', 32), Value(b'30.a', 32), Value(b'30.b', 32),
                    Value(b'30.c', 32), Value(b'30.d', 32), Value(b'30.e', 32), Value(b'30.f', 32), Value(b'30.g', 32),
                    Value(b'31.a', 32), Value(b'31.b', 32), Value(b'31.c', 32), Value(b'31.d', 32), Value(b'31.e', 32),
                    Value(b'31.f', 32), Value(b'31.g', 32), Value(b'32.a', 32), Value(b'32.b', 32), Value(b'32.c', 32),
                    Value(b'32.d', 32), Value(b'32.e', 32), Value(b'32.f', 32), Value(b'32.g', 32), Value(b'33.a', 32),
                    Value(b'33.b', 32), Value(b'33.c', 32), Value(b'33.d', 32), Value(b'33.e', 32), Value(b'33.f', 32),
                    Value(b'33.g', 32), Value(b'34.a', 32), Value(b'34.b', 32), Value(b'34.c', 32), Value(b'34.d', 32),
                    Value(b'34.e', 32), Value(b'34.f', 32), Value(b'34.g', 32), Value(b'35.a', 32), Value(b'35.b', 32),
                    Value(b'35.c', 32), Value(b'35.d', 32), Value(b'35.e', 32), Value(b'35.f', 32), Value(b'35.g', 32),
                    Value(b'36.a', 32), Value(b'36.b', 32), Value(b'36.c', 32), Value(b'36.d', 32), Value(b'36.e', 32),
                    Value(b'36.f', 32), Value(b'36.g', 32), Value(b'37.a', 32), Value(b'37.b', 32), Value(b'37.c', 32),
                    Value(b'37.d', 32), Value(b'37.e', 32), Value(b'37.f', 32), Value(b'37.g', 32), Value(b'38.a', 32),
                    Value(b'38.b', 32), Value(b'38.c', 32), Value(b'38.d', 32), Value(b'38.e', 32), Value(b'38.f', 32),
                    Value(b'38.g', 32), Value(b'39.a', 32), Value(b'39.b', 32), Value(b'39.c', 32), Value(b'39.d', 32),
                    Value(b'39.e', 32), Value(b'39.f', 32), Value(b'39.g', 32), Value(b'3a.a', 32), Value(b'3a.b', 32),
                    Value(b'3a.c', 32), Value(b'3a.d', 32), Value(b'3a.e', 32), Value(b'3a.f', 32), Value(b'3a.g', 32),
                    Value(b'3b.a', 32), Value(b'3b.b', 32), Value(b'3b.c', 32), Value(b'3b.d', 32), Value(b'3b.e', 32),
                    Value(b'3b.f', 32), Value(b'3b.g', 32), Value(b'3c.a', 32), Value(b'3c.b', 32), Value(b'3c.c', 32),
                    Value(b'3c.d', 32), Value(b'3c.e', 32), Value(b'3c.f', 32), Value(b'3c.g', 32), Value(b'3d.a', 32),
                    Value(b'3d.b', 32), Value(b'3d.c', 32), Value(b'3d.d', 32), Value(b'3d.e', 32), Value(b'3d.f', 32),
                    Value(b'3d.g', 32), Value(b'3e.a', 32), Value(b'3e.b', 32), Value(b'3e.c', 32), Value(b'3e.d', 32),
                    Value(b'3e.e', 32), Value(b'3e.f', 32), Value(b'3e.g', 32), Value(b'3f.a', 32), Value(b'3f.b', 32),
                    Value(b'3f.c', 32), Value(b'3f.d', 32), Value(b'3f.e', 32), Value(b'3f.f', 32), Value(b'3f.g', 32),
                    Value(b'40.a', 32), Value(b'40.b', 32), Value(b'40.c', 32), Value(b'40.d', 32), Value(b'40.e', 32),
                    Value(b'40.f', 32), Value(b'40.g', 32), Value(b'41.a', 32), Value(b'41.b', 32), Value(b'41.c', 32),
                    Value(b'41.d', 32), Value(b'41.e', 32), Value(b'41.f', 32), Value(b'41.g', 32), Value(b'42.a', 32),
                    Value(b'42.b', 32), Value(b'42.c', 32), Value(b'42.d', 32), Value(b'42.e', 32), Value(b'42.f', 32),
                    Value(b'42.g', 32), Value(b'43.a', 32), Value(b'43.b', 32), Value(b'43.c', 32), Value(b'43.d', 32),
                    Value(b'43.e', 32), Value(b'43.f', 32), Value(b'43.g', 32), Value(b'44.a', 32), Value(b'44.b', 32),
                    Value(b'44.c', 32), Value(b'44.d', 32), Value(b'44.e', 32), Value(b'44.f', 32), Value(b'44.g', 32),
                    Value(b'45.a', 32), Value(b'45.b', 32), Value(b'45.c', 32), Value(b'45.d', 32), Value(b'45.e', 32),
                    Value(b'45.f', 32), Value(b'45.g', 32), Value(b'46.a', 32), Value(b'46.b', 32), Value(b'46.c', 32),
                    Value(b'46.d', 32), Value(b'46.e', 32), Value(b'46.f', 32), Value(b'46.g', 32), Value(b'47.a', 32),
                    Value(b'47.b', 32), Value(b'47.c', 32), Value(b'47.d', 32), Value(b'47.e', 32), Value(b'47.f', 32),
                    Value(b'47.g', 32), Value(b'48.a', 32), Value(b'48.b', 32), Value(b'48.c', 32), Value(b'48.d', 32),
                    Value(b'48.e', 32), Value(b'48.f', 32), Value(b'48.g', 32), Value(b'49.a', 32), Value(b'49.b', 32),
                    Value(b'49.c', 32), Value(b'49.d', 32), Value(b'49.e', 32), Value(b'49.f', 32), Value(b'49.g', 32),
                    Value(b'4a.a', 32), Value(b'4a.b', 32), Value(b'4a.c', 32), Value(b'4a.d', 32), Value(b'4a.e', 32),
                    Value(b'4a.f', 32), Value(b'4a.g', 32), Value(b'4b.a', 32), Value(b'4b.b', 32), Value(b'4b.c', 32),
                    Value(b'4b.d', 32), Value(b'4b.e', 32), Value(b'4b.f', 32), Value(b'4b.g', 32), Value(b'4c.a', 32),
                    Value(b'4c.b', 32), Value(b'4c.c', 32), Value(b'4c.d', 32), Value(b'4c.e', 32), Value(b'4c.f', 32),
                    Value(b'4c.g', 32), Value(b'4d.a', 32), Value(b'4d.b', 32), Value(b'4d.c', 32), Value(b'4d.d', 32),
                    Value(b'4d.e', 32), Value(b'4d.f', 32), Value(b'4d.g', 32), Value(b'4e.a', 32), Value(b'4e.b', 32),
                    Value(b'4e.c', 32), Value(b'4e.d', 32), Value(b'4e.e', 32), Value(b'4e.f', 32), Value(b'4e.g', 32),
                    Value(b'4f.a', 32), Value(b'4f.b', 32), Value(b'4f.c', 32), Value(b'4f.d', 32), Value(b'4f.e', 32),
                    Value(b'4f.f', 32), Value(b'4f.g', 32), Value(b'50.a', 32), Value(b'50.b', 32), Value(b'50.c', 32),
                    Value(b'50.d', 32), Value(b'50.e', 32), Value(b'50.f', 32), Value(b'50.g', 32), Value(b'51.a', 32),
                    Value(b'51.b', 32), Value(b'51.c', 32), Value(b'51.d', 32), Value(b'51.e', 32), Value(b'51.f', 32),
                    Value(b'51.g', 32), Value(b'52.a', 32), Value(b'52.b', 32), Value(b'52.c', 32), Value(b'52.d', 32),
                    Value(b'52.e', 32), Value(b'52.f', 32), Value(b'52.g', 32), Value(b'53.a', 32), Value(b'53.b', 32),
                    Value(b'53.c', 32), Value(b'53.d', 32), Value(b'53.e', 32), Value(b'53.f', 32), Value(b'53.g', 32),
                    Value(b'54.a', 32), Value(b'54.b', 32), Value(b'54.c', 32), Value(b'54.d', 32), Value(b'54.e', 32),
                    Value(b'54.f', 32), Value(b'54.g', 32), Value(b'55.a', 32), Value(b'55.b', 32), Value(b'55.c', 32),
                    Value(b'55.d', 32), Value(b'55.e', 32), Value(b'55.f', 32), Value(b'55.g', 32), Value(b'56.a', 32),
                    Value(b'56.b', 32), Value(b'56.c', 32), Value(b'56.d', 32), Value(b'56.e', 32), Value(b'56.f', 32),
                    Value(b'56.g', 32), Value(b'57.a', 32), Value(b'57.b', 32), Value(b'57.c', 32), Value(b'57.d', 32),
                    Value(b'57.e', 32), Value(b'57.f', 32), Value(b'57.g', 32), Value(b'58.a', 32), Value(b'58.b', 32),
                    Value(b'58.c', 32), Value(b'58.d', 32), Value(b'58.e', 32), Value(b'58.f', 32), Value(b'58.g', 32),
                    Value(b'59.a', 32), Value(b'59.b', 32), Value(b'59.c', 32), Value(b'59.d', 32), Value(b'59.e', 32),
                    Value(b'59.f', 32), Value(b'59.g', 32), Value(b'5a.a', 32), Value(b'5a.b', 32), Value(b'5a.c', 32),
                    Value(b'5a.d', 32), Value(b'5a.e', 32), Value(b'5a.f', 32), Value(b'5a.g', 32), Value(b'5b.a', 32),
                    Value(b'5b.b', 32), Value(b'5b.c', 32), Value(b'5b.d', 32), Value(b'5b.e', 32), Value(b'5b.f', 32),
                    Value(b'5b.g', 32), Value(b'5c.a', 32), Value(b'5c.b', 32), Value(b'5c.c', 32), Value(b'5c.d', 32),
                    Value(b'5c.e', 32), Value(b'5c.f', 32), Value(b'5c.g', 32), Value(b'5d.a', 32), Value(b'5d.b', 32),
                    Value(b'5d.c', 32), Value(b'5d.d', 32), Value(b'5d.e', 32), Value(b'5d.f', 32), Value(b'5d.g', 32),
                    Value(b'5e.a', 32), Value(b'5e.b', 32), Value(b'5e.c', 32), Value(b'5e.d', 32), Value(b'5e.e', 32),
                    Value(b'5e.f', 32), Value(b'5e.g', 32), Value(b'5f.a', 32), Value(b'5f.b', 32), Value(b'5f.c', 32),
                    Value(b'5f.d', 32), Value(b'5f.e', 32), Value(b'5f.f', 32), Value(b'5f.g', 32), Value(b'60.a', 32),
                    Value(b'60.b', 32), Value(b'60.c', 32), Value(b'60.d', 32), Value(b'60.e', 32), Value(b'60.f', 32),
                    Value(b'60.g', 32), Value(b'61.a', 32), Value(b'61.b', 32), Value(b'61.c', 32), Value(b'61.d', 32),
                    Value(b'61.e', 32), Value(b'61.f', 32), Value(b'61.g', 32), Value(b'62.a', 32), Value(b'62.b', 32),
                    Value(b'62.c', 32), Value(b'62.d', 32), Value(b'62.e', 32), Value(b'62.f', 32), Value(b'62.g', 32),
                    Value(b'63.a', 32), Value(b'63.b', 32), Value(b'63.c', 32), Value(b'63.d', 32), Value(b'63.e', 32),
                    Value(b'63.f', 32), Value(b'63.g', 32), Value(b'64.a', 32), Value(b'64.b', 32), Value(b'64.c', 32),
                    Value(b'64.d', 32), Value(b'64.e', 32), Value(b'64.f', 32), Value(b'64.g', 32), Value(b'65.a', 32),
                    Value(b'65.b', 32), Value(b'65.c', 32), Value(b'65.d', 32), Value(b'65.e', 32), Value(b'65.f', 32),
                    Value(b'65.g', 32), Value(b'66.a', 32), Value(b'66.b', 32), Value(b'66.c', 32), Value(b'66.d', 32),
                    Value(b'66.e', 32), Value(b'66.f', 32), Value(b'66.g', 32), Value(b'67.a', 32), Value(b'67.b', 32),
                    Value(b'67.c', 32), Value(b'67.d', 32), Value(b'67.e', 32), Value(b'67.f', 32), Value(b'67.g', 32),
                    Value(b'68.a', 32), Value(b'68.b', 32), Value(b'68.c', 32), Value(b'68.d', 32), Value(b'68.e', 32),
                    Value(b'68.f', 32), Value(b'68.g', 32), Value(b'69.a', 32), Value(b'69.b', 32), Value(b'69.c', 32),
                    Value(b'69.d', 32), Value(b'69.e', 32), Value(b'69.f', 32), Value(b'69.g', 32), Value(b'6a.a', 32),
                    Value(b'6a.b', 32), Value(b'6a.c', 32), Value(b'6a.d', 32), Value(b'6a.e', 32), Value(b'6a.f', 32),
                    Value(b'6a.g', 32), Value(b'6b.a', 32), Value(b'6b.b', 32), Value(b'6b.c', 32), Value(b'6b.d', 32),
                    Value(b'6b.e', 32), Value(b'6b.f', 32), Value(b'6b.g', 32), Value(b'6c.a', 32), Value(b'6c.b', 32),
                    Value(b'6c.c', 32), Value(b'6c.d', 32), Value(b'6c.e', 32), Value(b'6c.f', 32), Value(b'6c.g', 32),
                    Value(b'6d.a', 32), Value(b'6d.b', 32), Value(b'6d.c', 32), Value(b'6d.d', 32), Value(b'6d.e', 32),
                    Value(b'6d.f', 32), Value(b'6d.g', 32), Value(b'6e.a', 32), Value(b'6e.b', 32), Value(b'6e.c', 32),
                    Value(b'6e.d', 32), Value(b'6e.e', 32), Value(b'6e.f', 32), Value(b'6e.g', 32), Value(b'6f.a', 32),
                    Value(b'6f.b', 32), Value(b'6f.c', 32), Value(b'6f.d', 32), Value(b'6f.e', 32), Value(b'6f.f', 32),
                    Value(b'6f.g', 32), Value(b'70.a', 32), Value(b'70.b', 32), Value(b'70.c', 32), Value(b'70.d', 32),
                    Value(b'70.e', 32), Value(b'70.f', 32), Value(b'70.g', 32), Value(b'71.a', 32), Value(b'71.b', 32),
                    Value(b'71.c', 32), Value(b'71.d', 32), Value(b'71.e', 32), Value(b'71.f', 32), Value(b'71.g', 32),
                    Value(b'72.a', 32), Value(b'72.b', 32), Value(b'72.c', 32), Value(b'72.d', 32), Value(b'72.e', 32),
                    Value(b'72.f', 32), Value(b'72.g', 32), Value(b'73.a', 32), Value(b'73.b', 32), Value(b'73.c', 32),
                    Value(b'73.d', 32), Value(b'73.e', 32), Value(b'73.f', 32), Value(b'73.g', 32), Value(b'74.a', 32),
                    Value(b'74.b', 32), Value(b'74.c', 32), Value(b'74.d', 32), Value(b'74.e', 32), Value(b'74.f', 32),
                    Value(b'74.g', 32), Value(b'75.a', 32), Value(b'75.b', 32), Value(b'75.c', 32), Value(b'75.d', 32),
                    Value(b'75.e', 32), Value(b'75.f', 32), Value(b'75.g', 32), Value(b'76.a', 32), Value(b'76.b', 32),
                    Value(b'76.c', 32), Value(b'76.d', 32), Value(b'76.e', 32), Value(b'76.f', 32), Value(b'76.g', 32),
                    Value(b'77.a', 32), Value(b'77.b', 32), Value(b'77.c', 32), Value(b'77.d', 32), Value(b'77.e', 32),
                    Value(b'77.f', 32), Value(b'77.g', 32), Value(b'78.a', 32), Value(b'78.b', 32), Value(b'78.c', 32),
                    Value(b'78.d', 32), Value(b'78.e', 32), Value(b'78.f', 32), Value(b'78.g', 32), Value(b'79.a', 32),
                    Value(b'79.b', 32), Value(b'79.c', 32), Value(b'79.d', 32), Value(b'79.e', 32), Value(b'79.f', 32),
                    Value(b'79.g', 32), Value(b'7a.a', 32), Value(b'7a.b', 32), Value(b'7a.c', 32), Value(b'7a.d', 32),
                    Value(b'7a.e', 32), Value(b'7a.f', 32), Value(b'7a.g', 32), Value(b'7b.a', 32), Value(b'7b.b', 32),
                    Value(b'7b.c', 32), Value(b'7b.d', 32), Value(b'7b.e', 32), Value(b'7b.f', 32), Value(b'7b.g', 32),
                    Value(b'7c.a', 32), Value(b'7c.b', 32), Value(b'7c.c', 32), Value(b'7c.d', 32), Value(b'7c.e', 32),
                    Value(b'7c.f', 32), Value(b'7c.g', 32), Value(b'7d.a', 32), Value(b'7d.b', 32), Value(b'7d.c', 32),
                    Value(b'7d.d', 32), Value(b'7d.e', 32), Value(b'7d.f', 32), Value(b'7d.g', 32), Value(b'7e.a', 32),
                    Value(b'7e.b', 32), Value(b'7e.c', 32), Value(b'7e.d', 32), Value(b'7e.e', 32), Value(b'7e.f', 32),
                    Value(b'7e.g', 32), Value(b'7f.a', 32), Value(b'7f.b', 32), Value(b'7f.c', 32), Value(b'7f.d', 32),
                    Value(b'7f.e', 32), Value(b'7f.f', 32), Value(b'7f.g', 32), Value(b'80.a', 32), Value(b'80.b', 32),
                    Value(b'80.c', 32), Value(b'80.d', 32), Value(b'80.e', 32), Value(b'80.f', 32), Value(b'80.g', 32),
                    Value(b'81.a', 32), Value(b'81.b', 32), Value(b'81.c', 32), Value(b'81.d', 32), Value(b'81.e', 32),
                    Value(b'81.f', 32), Value(b'81.g', 32), Value(b'82.a', 32), Value(b'82.b', 32), Value(b'82.c', 32),
                    Value(b'82.d', 32), Value(b'82.e', 32), Value(b'82.f', 32), Value(b'82.g', 32), Value(b'83.a', 32),
                    Value(b'83.b', 32), Value(b'83.c', 32), Value(b'83.d', 32), Value(b'83.e', 32), Value(b'83.f', 32),
                    Value(b'83.g', 32), Value(b'84.a', 32), Value(b'84.b', 32), Value(b'84.c', 32), Value(b'84.d', 32),
                    Value(b'84.e', 32), Value(b'84.f', 32), Value(b'84.g', 32), Value(b'85.a', 32), Value(b'85.b', 32),
                    Value(b'85.c', 32), Value(b'85.d', 32), Value(b'85.e', 32), Value(b'85.f', 32), Value(b'85.g', 32),
                    Value(b'86.a', 32), Value(b'86.b', 32), Value(b'86.c', 32), Value(b'86.d', 32), Value(b'86.e', 32),
                    Value(b'86.f', 32), Value(b'86.g', 32), Value(b'87.a', 32), Value(b'87.b', 32), Value(b'87.c', 32),
                    Value(b'87.d', 32), Value(b'87.e', 32), Value(b'87.f', 32), Value(b'87.g', 32), Value(b'88.a', 32),
                    Value(b'88.b', 32), Value(b'88.c', 32), Value(b'88.d', 32), Value(b'88.e', 32), Value(b'88.f', 32),
                    Value(b'88.g', 32), Value(b'89.a', 32), Value(b'89.b', 32), Value(b'89.c', 32), Value(b'89.d', 32),
                    Value(b'89.e', 32), Value(b'89.f', 32), Value(b'89.g', 32), Value(b'8a.a', 32), Value(b'8a.b', 32),
                    Value(b'8a.c', 32), Value(b'8a.d', 32), Value(b'8a.e', 32), Value(b'8a.f', 32), Value(b'8a.g', 32),
                    Value(b'8b.a', 32), Value(b'8b.b', 32), Value(b'8b.c', 32), Value(b'8b.d', 32), Value(b'8b.e', 32),
                    Value(b'8b.f', 32), Value(b'8b.g', 32), Value(b'8c.a', 32), Value(b'8c.b', 32), Value(b'8c.c', 32),
                    Value(b'8c.d', 32), Value(b'8c.e', 32), Value(b'8c.f', 32), Value(b'8c.g', 32), Value(b'8d.a', 32),
                    Value(b'8d.b', 32), Value(b'8d.c', 32), Value(b'8d.d', 32), Value(b'8d.e', 32), Value(b'8d.f', 32),
                    Value(b'8d.g', 32), Value(b'8e.a', 32), Value(b'8e.b', 32), Value(b'8e.c', 32), Value(b'8e.d', 32),
                    Value(b'8e.e', 32), Value(b'8e.f', 32), Value(b'8e.g', 32), Value(b'8f.a', 32), Value(b'8f.b', 32),
                    Value(b'8f.c', 32), Value(b'8f.d', 32), Value(b'8f.e', 32), Value(b'8f.f', 32), Value(b'8f.g', 32),
                    Value(b'90.a', 32), Value(b'90.b', 32), Value(b'90.c', 32), Value(b'90.d', 32), Value(b'90.e', 32),
                    Value(b'90.f', 32), Value(b'90.g', 32), Value(b'91.a', 32), Value(b'91.b', 32), Value(b'91.c', 32),
                    Value(b'91.d', 32), Value(b'91.e', 32), Value(b'91.f', 32), Value(b'91.g', 32), Value(b'92.a', 32),
                    Value(b'92.b', 32), Value(b'92.c', 32), Value(b'92.d', 32), Value(b'92.e', 32), Value(b'92.f', 32),
                    Value(b'92.g', 32), Value(b'93.a', 32), Value(b'93.b', 32), Value(b'93.c', 32), Value(b'93.d', 32),
                    Value(b'93.e', 32), Value(b'93.f', 32), Value(b'93.g', 32), Value(b'94.a', 32), Value(b'94.b', 32),
                    Value(b'94.c', 32), Value(b'94.d', 32), Value(b'94.e', 32), Value(b'94.f', 32), Value(b'94.g', 32),
                    Value(b'95.a', 32), Value(b'95.b', 32), Value(b'95.c', 32), Value(b'95.d', 32), Value(b'95.e', 32),
                    Value(b'95.f', 32), Value(b'95.g', 32), Value(b'96.a', 32), Value(b'96.b', 32), Value(b'96.c', 32),
                    Value(b'96.d', 32), Value(b'96.e', 32), Value(b'96.f', 32), Value(b'96.g', 32), Value(b'97.a', 32),
                    Value(b'97.b', 32), Value(b'97.c', 32), Value(b'97.d', 32), Value(b'97.e', 32), Value(b'97.f', 32),
                    Value(b'97.g', 32), Value(b'98.a', 32), Value(b'98.b', 32), Value(b'98.c', 32), Value(b'98.d', 32),
                    Value(b'98.e', 32), Value(b'98.f', 32), Value(b'98.g', 32), Value(b'99.a', 32), Value(b'99.b', 32),
                    Value(b'99.c', 32), Value(b'99.d', 32), Value(b'99.e', 32), Value(b'99.f', 32), Value(b'99.g', 32),
                    Value(b'9a.a', 32), Value(b'9a.b', 32), Value(b'9a.c', 32), Value(b'9a.d', 32), Value(b'9a.e', 32),
                    Value(b'9a.f', 32), Value(b'9a.g', 32), Value(b'9b.a', 32), Value(b'9b.b', 32), Value(b'9b.c', 32),
                    Value(b'9b.d', 32), Value(b'9b.e', 32), Value(b'9b.f', 32), Value(b'9b.g', 32), Value(b'9c.a', 32),
                    Value(b'9c.b', 32), Value(b'9c.c', 32), Value(b'9c.d', 32), Value(b'9c.e', 32), Value(b'9c.f', 32),
                    Value(b'9c.g', 32), Value(b'9d.a', 32), Value(b'9d.b', 32), Value(b'9d.c', 32), Value(b'9d.d', 32),
                    Value(b'9d.e', 32), Value(b'9d.f', 32), Value(b'9d.g', 32), Value(b'9e.a', 32), Value(b'9e.b', 32),
                    Value(b'9e.c', 32), Value(b'9e.d', 32), Value(b'9e.e', 32), Value(b'9e.f', 32), Value(b'9e.g', 32),
                    Value(b'9f.a', 32), Value(b'9f.b', 32), Value(b'9f.c', 32), Value(b'9f.d', 32), Value(b'9f.e', 32),
                    Value(b'9f.f', 32), Value(b'9f.g', 32), Value(b'a0.a', 32), Value(b'a0.b', 32), Value(b'a0.c', 32),
                    Value(b'a0.d', 32), Value(b'a0.e', 32), Value(b'a0.f', 32), Value(b'a0.g', 32), Value(b'a1.a', 32),
                    Value(b'a1.b', 32), Value(b'a1.c', 32), Value(b'a1.d', 32), Value(b'a1.e', 32), Value(b'a1.f', 32),
                    Value(b'a1.g', 32), Value(b'a2.a', 32), Value(b'a2.b', 32), Value(b'a2.c', 32), Value(b'a2.d', 32),
                    Value(b'a2.e', 32), Value(b'a2.f', 32), Value(b'a2.g', 32), Value(b'a3.a', 32), Value(b'a3.b', 32),
                    Value(b'a3.c', 32), Value(b'a3.d', 32), Value(b'a3.e', 32), Value(b'a3.f', 32), Value(b'a3.g', 32),
                    Value(b'a4.a', 32), Value(b'a4.b', 32), Value(b'a4.c', 32), Value(b'a4.d', 32), Value(b'a4.e', 32),
                    Value(b'a4.f', 32), Value(b'a4.g', 32), Value(b'a5.a', 32), Value(b'a5.b', 32), Value(b'a5.c', 32),
                    Value(b'a5.d', 32), Value(b'a5.e', 32), Value(b'a5.f', 32), Value(b'a5.g', 32), Value(b'a6.a', 32),
                    Value(b'a6.b', 32), Value(b'a6.c', 32), Value(b'a6.d', 32), Value(b'a6.e', 32), Value(b'a6.f', 32),
                    Value(b'a6.g', 32), Value(b'a7.a', 32), Value(b'a7.b', 32), Value(b'a7.c', 32), Value(b'a7.d', 32),
                    Value(b'a7.e', 32), Value(b'a7.f', 32), Value(b'a7.g', 32), Value(b'a8.a', 32), Value(b'a8.b', 32),
                    Value(b'a8.c', 32), Value(b'a8.d', 32), Value(b'a8.e', 32), Value(b'a8.f', 32), Value(b'a8.g', 32),
                    Value(b'a9.a', 32), Value(b'a9.b', 32), Value(b'a9.c', 32), Value(b'a9.d', 32), Value(b'a9.e', 32),
                    Value(b'a9.f', 32), Value(b'a9.g', 32), Value(b'aa.a', 32), Value(b'aa.b', 32), Value(b'aa.c', 32),
                    Value(b'aa.d', 32), Value(b'aa.e', 32), Value(b'aa.f', 32), Value(b'aa.g', 32), Value(b'ab.a', 32),
                    Value(b'ab.b', 32), Value(b'ab.c', 32), Value(b'ab.d', 32), Value(b'ab.e', 32), Value(b'ab.f', 32),
                    Value(b'ab.g', 32), Value(b'ac.a', 32), Value(b'ac.b', 32), Value(b'ac.c', 32), Value(b'ac.d', 32),
                    Value(b'ac.e', 32), Value(b'ac.f', 32), Value(b'ac.g', 32), Value(b'ad.a', 32), Value(b'ad.b', 32),
                    Value(b'ad.c', 32), Value(b'ad.d', 32), Value(b'ad.e', 32), Value(b'ad.f', 32), Value(b'ad.g', 32),
                    Value(b'ae.a', 32), Value(b'ae.b', 32), Value(b'ae.c', 32), Value(b'ae.d', 32), Value(b'ae.e', 32),
                    Value(b'ae.f', 32), Value(b'ae.g', 32), Value(b'af.a', 32), Value(b'af.b', 32), Value(b'af.c', 32),
                    Value(b'af.d', 32), Value(b'af.e', 32), Value(b'af.f', 32), Value(b'af.g', 32), Value(b'b0.a', 32),
                    Value(b'b0.b', 32), Value(b'b0.c', 32), Value(b'b0.d', 32), Value(b'b0.e', 32), Value(b'b0.f', 32),
                    Value(b'b0.g', 32), Value(b'b1.a', 32), Value(b'b1.b', 32), Value(b'b1.c', 32), Value(b'b1.d', 32),
                    Value(b'b1.e', 32), Value(b'b1.f', 32), Value(b'b1.g', 32), Value(b'b2.a', 32), Value(b'b2.b', 32),
                    Value(b'b2.c', 32), Value(b'b2.d', 32), Value(b'b2.e', 32), Value(b'b2.f', 32), Value(b'b2.g', 32),
                    Value(b'b3.a', 32), Value(b'b3.b', 32), Value(b'b3.c', 32), Value(b'b3.d', 32), Value(b'b3.e', 32),
                    Value(b'b3.f', 32), Value(b'b3.g', 32), Value(b'b4.a', 32), Value(b'b4.b', 32), Value(b'b4.c', 32),
                    Value(b'b4.d', 32), Value(b'b4.e', 32), Value(b'b4.f', 32), Value(b'b4.g', 32), Value(b'b5.a', 32),
                    Value(b'b5.b', 32), Value(b'b5.c', 32), Value(b'b5.d', 32), Value(b'b5.e', 32), Value(b'b5.f', 32),
                    Value(b'b5.g', 32), Value(b'b6.a', 32), Value(b'b6.b', 32), Value(b'b6.c', 32), Value(b'b6.d', 32),
                    Value(b'b6.e', 32), Value(b'b6.f', 32), Value(b'b6.g', 32), Value(b'b7.a', 32), Value(b'b7.b', 32),
                    Value(b'b7.c', 32), Value(b'b7.d', 32), Value(b'b7.e', 32), Value(b'b7.f', 32), Value(b'b7.g', 32),
                    Value(b'b8.a', 32), Value(b'b8.b', 32), Value(b'b8.c', 32), Value(b'b8.d', 32), Value(b'b8.e', 32),
                    Value(b'b8.f', 32), Value(b'b8.g', 32), Value(b'b9.a', 32), Value(b'b9.b', 32), Value(b'b9.c', 32),
                    Value(b'b9.d', 32), Value(b'b9.e', 32), Value(b'b9.f', 32), Value(b'b9.g', 32), Value(b'ba.a', 32),
                    Value(b'ba.b', 32), Value(b'ba.c', 32), Value(b'ba.d', 32), Value(b'ba.e', 32), Value(b'ba.f', 32),
                    Value(b'ba.g', 32), Value(b'bb.a', 32), Value(b'bb.b', 32), Value(b'bb.c', 32), Value(b'bb.d', 32),
                    Value(b'bb.e', 32), Value(b'bb.f', 32), Value(b'bb.g', 32), Value(b'bc.a', 32), Value(b'bc.b', 32),
                    Value(b'bc.c', 32), Value(b'bc.d', 32), Value(b'bc.e', 32), Value(b'bc.f', 32), Value(b'bc.g', 32),
                    Value(b'bd.a', 32), Value(b'bd.b', 32), Value(b'bd.c', 32), Value(b'bd.d', 32), Value(b'bd.e', 32),
                    Value(b'bd.f', 32), Value(b'bd.g', 32), Value(b'be.a', 32), Value(b'be.b', 32), Value(b'be.c', 32),
                    Value(b'be.d', 32), Value(b'be.e', 32), Value(b'be.f', 32), Value(b'be.g', 32), Value(b'bf.a', 32),
                    Value(b'bf.b', 32), Value(b'bf.c', 32), Value(b'bf.d', 32), Value(b'bf.e', 32), Value(b'bf.f', 32),
                    Value(b'bf.g', 32), Value(b'c0.a', 32), Value(b'c0.b', 32), Value(b'c0.c', 32), Value(b'c0.d', 32),
                    Value(b'c0.e', 32), Value(b'c0.f', 32), Value(b'c0.g', 32), Value(b'c1.a', 32), Value(b'c1.b', 32),
                    Value(b'c1.c', 32), Value(b'c1.d', 32), Value(b'c1.e', 32), Value(b'c1.f', 32), Value(b'c1.g', 32),
                    Value(b'c2.a', 32), Value(b'c2.b', 32), Value(b'c2.c', 32), Value(b'c2.d', 32), Value(b'c2.e', 32),
                    Value(b'c2.f', 32), Value(b'c2.g', 32), Value(b'c3.a', 32), Value(b'c3.b', 32), Value(b'c3.c', 32),
                    Value(b'c3.d', 32), Value(b'c3.e', 32), Value(b'c3.f', 32), Value(b'c3.g', 32), Value(b'c4.a', 32),
                    Value(b'c4.b', 32), Value(b'c4.c', 32), Value(b'c4.d', 32), Value(b'c4.e', 32), Value(b'c4.f', 32),
                    Value(b'c4.g', 32), Value(b'c5.a', 32), Value(b'c5.b', 32), Value(b'c5.c', 32), Value(b'c5.d', 32),
                    Value(b'c5.e', 32), Value(b'c5.f', 32), Value(b'c5.g', 32), Value(b'c6.a', 32), Value(b'c6.b', 32),
                    Value(b'c6.c', 32), Value(b'c6.d', 32), Value(b'c6.e', 32), Value(b'c6.f', 32), Value(b'c6.g', 32),
                    Value(b'c7.a', 32), Value(b'c7.b', 32), Value(b'c7.c', 32), Value(b'c7.d', 32), Value(b'c7.e', 32),
                    Value(b'c7.f', 32), Value(b'c7.g', 32), Value(b'c8.a', 32), Value(b'c8.b', 32), Value(b'c8.c', 32),
                    Value(b'c8.d', 32), Value(b'c8.e', 32), Value(b'c8.f', 32), Value(b'c8.g', 32), Value(b'c9.a', 32),
                    Value(b'c9.b', 32), Value(b'c9.c', 32), Value(b'c9.d', 32), Value(b'c9.e', 32), Value(b'c9.f', 32),
                    Value(b'c9.g', 32), Value(b'ca.a', 32), Value(b'ca.b', 32), Value(b'ca.c', 32), Value(b'ca.d', 32),
                    Value(b'ca.e', 32), Value(b'ca.f', 32), Value(b'ca.g', 32), Value(b'cb.a', 32), Value(b'cb.b', 32),
                    Value(b'cb.c', 32), Value(b'cb.d', 32), Value(b'cb.e', 32), Value(b'cb.f', 32), Value(b'cb.g', 32),
                    Value(b'cc.a', 32), Value(b'cc.b', 32), Value(b'cc.c', 32), Value(b'cc.d', 32), Value(b'cc.e', 32),
                    Value(b'cc.f', 32), Value(b'cc.g', 32), Value(b'cd.a', 32), Value(b'cd.b', 32), Value(b'cd.c', 32),
                    Value(b'cd.d', 32), Value(b'cd.e', 32), Value(b'cd.f', 32), Value(b'cd.g', 32), Value(b'ce.a', 32),
                    Value(b'ce.b', 32), Value(b'ce.c', 32), Value(b'ce.d', 32), Value(b'ce.e', 32), Value(b'ce.f', 32),
                    Value(b'ce.g', 32), Value(b'cf.a', 32), Value(b'cf.b', 32), Value(b'cf.c', 32), Value(b'cf.d', 32),
                    Value(b'cf.e', 32), Value(b'cf.f', 32), Value(b'cf.g', 32), Value(b'd0.a', 32), Value(b'd0.b', 32),
                    Value(b'd0.c', 32), Value(b'd0.d', 32), Value(b'd0.e', 32), Value(b'd0.f', 32), Value(b'd0.g', 32),
                    Value(b'd1.a', 32), Value(b'd1.b', 32), Value(b'd1.c', 32), Value(b'd1.d', 32), Value(b'd1.e', 32),
                    Value(b'd1.f', 32), Value(b'd1.g', 32), Value(b'd2.a', 32), Value(b'd2.b', 32), Value(b'd2.c', 32),
                    Value(b'd2.d', 32), Value(b'd2.e', 32), Value(b'd2.f', 32), Value(b'd2.g', 32), Value(b'd3.a', 32),
                    Value(b'd3.b', 32), Value(b'd3.c', 32), Value(b'd3.d', 32), Value(b'd3.e', 32), Value(b'd3.f', 32),
                    Value(b'd3.g', 32), Value(b'd4.a', 32), Value(b'd4.b', 32), Value(b'd4.c', 32), Value(b'd4.d', 32),
                    Value(b'd4.e', 32), Value(b'd4.f', 32), Value(b'd4.g', 32), Value(b'd5.a', 32), Value(b'd5.b', 32),
                    Value(b'd5.c', 32), Value(b'd5.d', 32), Value(b'd5.e', 32), Value(b'd5.f', 32), Value(b'd5.g', 32),
                    Value(b'd6.a', 32), Value(b'd6.b', 32), Value(b'd6.c', 32), Value(b'd6.d', 32), Value(b'd6.e', 32),
                    Value(b'd6.f', 32), Value(b'd6.g', 32), Value(b'd7.a', 32), Value(b'd7.b', 32), Value(b'd7.c', 32),
                    Value(b'd7.d', 32), Value(b'd7.e', 32), Value(b'd7.f', 32), Value(b'd7.g', 32), Value(b'd8.a', 32),
                    Value(b'd8.b', 32), Value(b'd8.c', 32), Value(b'd8.d', 32), Value(b'd8.e', 32), Value(b'd8.f', 32),
                    Value(b'd8.g', 32), Value(b'd9.a', 32), Value(b'd9.b', 32), Value(b'd9.c', 32), Value(b'd9.d', 32),
                    Value(b'd9.e', 32), Value(b'd9.f', 32), Value(b'd9.g', 32), Value(b'da.a', 32), Value(b'da.b', 32),
                    Value(b'da.c', 32), Value(b'da.d', 32), Value(b'da.e', 32), Value(b'da.f', 32), Value(b'da.g', 32),
                    Value(b'db.a', 32), Value(b'db.b', 32), Value(b'db.c', 32), Value(b'db.d', 32), Value(b'db.e', 32),
                    Value(b'db.f', 32), Value(b'db.g', 32), Value(b'dc.a', 32), Value(b'dc.b', 32), Value(b'dc.c', 32),
                    Value(b'dc.d', 32), Value(b'dc.e', 32), Value(b'dc.f', 32), Value(b'dc.g', 32), Value(b'dd.a', 32),
                    Value(b'dd.b', 32), Value(b'dd.c', 32), Value(b'dd.d', 32), Value(b'dd.e', 32), Value(b'dd.f', 32),
                    Value(b'dd.g', 32), Value(b'de.a', 32), Value(b'de.b', 32), Value(b'de.c', 32), Value(b'de.d', 32),
                    Value(b'de.e', 32), Value(b'de.f', 32), Value(b'de.g', 32), Value(b'df.a', 32), Value(b'df.b', 32),
                    Value(b'df.c', 32), Value(b'df.d', 32), Value(b'df.e', 32), Value(b'df.f', 32), Value(b'df.g', 32),
                    Value(b'e0.a', 32), Value(b'e0.b', 32), Value(b'e0.c', 32), Value(b'e0.d', 32), Value(b'e0.e', 32),
                    Value(b'e0.f', 32), Value(b'e0.g', 32), Value(b'e1.a', 32), Value(b'e1.b', 32), Value(b'e1.c', 32),
                    Value(b'e1.d', 32), Value(b'e1.e', 32), Value(b'e1.f', 32), Value(b'e1.g', 32), Value(b'e2.a', 32),
                    Value(b'e2.b', 32), Value(b'e2.c', 32), Value(b'e2.d', 32), Value(b'e2.e', 32), Value(b'e2.f', 32),
                    Value(b'e2.g', 32), Value(b'e3.a', 32), Value(b'e3.b', 32), Value(b'e3.c', 32), Value(b'e3.d', 32),
                    Value(b'e3.e', 32), Value(b'e3.f', 32), Value(b'e3.g', 32), Value(b'e4.a', 32), Value(b'e4.b', 32),
                    Value(b'e4.c', 32), Value(b'e4.d', 32), Value(b'e4.e', 32), Value(b'e4.f', 32), Value(b'e4.g', 32),
                    Value(b'e5.a', 32), Value(b'e5.b', 32), Value(b'e5.c', 32), Value(b'e5.d', 32), Value(b'e5.e', 32),
                    Value(b'e5.f', 32), Value(b'e5.g', 32), Value(b'e6.a', 32), Value(b'e6.b', 32), Value(b'e6.c', 32),
                    Value(b'e6.d', 32), Value(b'e6.e', 32), Value(b'e6.f', 32), Value(b'e6.g', 32), Value(b'e7.a', 32),
                    Value(b'e7.b', 32), Value(b'e7.c', 32), Value(b'e7.d', 32), Value(b'e7.e', 32), Value(b'e7.f', 32),
                    Value(b'e7.g', 32), Value(b'e8.a', 32), Value(b'e8.b', 32), Value(b'e8.c', 32), Value(b'e8.d', 32),
                    Value(b'e8.e', 32), Value(b'e8.f', 32), Value(b'e8.g', 32), Value(b'e9.a', 32), Value(b'e9.b', 32),
                    Value(b'e9.c', 32), Value(b'e9.d', 32), Value(b'e9.e', 32), Value(b'e9.f', 32), Value(b'e9.g', 32),
                    Value(b'ea.a', 32), Value(b'ea.b', 32), Value(b'ea.c', 32), Value(b'ea.d', 32), Value(b'ea.e', 32),
                    Value(b'ea.f', 32), Value(b'ea.g', 32), Value(b'eb.a', 32), Value(b'eb.b', 32), Value(b'eb.c', 32),
                    Value(b'eb.d', 32), Value(b'eb.e', 32), Value(b'eb.f', 32), Value(b'eb.g', 32), Value(b'ec.a', 32),
                    Value(b'ec.b', 32), Value(b'ec.c', 32), Value(b'ec.d', 32), Value(b'ec.e', 32), Value(b'ec.f', 32),
                    Value(b'ec.g', 32), Value(b'ed.a', 32), Value(b'ed.b', 32), Value(b'ed.c', 32), Value(b'ed.d', 32),
                    Value(b'ed.e', 32), Value(b'ed.f', 32), Value(b'ed.g', 32), Value(b'ee.a', 32), Value(b'ee.b', 32),
                    Value(b'ee.c', 32), Value(b'ee.d', 32), Value(b'ee.e', 32), Value(b'ee.f', 32), Value(b'ee.g', 32),
                    Value(b'ef.a', 32), Value(b'ef.b', 32), Value(b'ef.c', 32), Value(b'ef.d', 32), Value(b'ef.e', 32),
                    Value(b'ef.f', 32), Value(b'ef.g', 32), Value(b'f0.a', 32), Value(b'f0.b', 32), Value(b'f0.c', 32),
                    Value(b'f0.d', 32), Value(b'f0.e', 32), Value(b'f0.f', 32), Value(b'f0.g', 32), Value(b'f1.a', 32),
                    Value(b'f1.b', 32), Value(b'f1.c', 32), Value(b'f1.d', 32), Value(b'f1.e', 32), Value(b'f1.f', 32),
                    Value(b'f1.g', 32), Value(b'f2.a', 32), Value(b'f2.b', 32), Value(b'f2.c', 32), Value(b'f2.d', 32),
                    Value(b'f2.e', 32), Value(b'f2.f', 32), Value(b'f2.g', 32), Value(b'f3.a', 32), Value(b'f3.b', 32),
                    Value(b'f3.c', 32), Value(b'f3.d', 32), Value(b'f3.e', 32), Value(b'f3.f', 32), Value(b'f3.g', 32),
                    Value(b'f4.a', 32), Value(b'f4.b', 32), Value(b'f4.c', 32), Value(b'f4.d', 32), Value(b'f4.e', 32),
                    Value(b'f4.f', 32), Value(b'f4.g', 32), Value(b'f5.a', 32), Value(b'f5.b', 32), Value(b'f5.c', 32),
                    Value(b'f5.d', 32), Value(b'f5.e', 32), Value(b'f5.f', 32), Value(b'f5.g', 32), Value(b'f6.a', 32),
                    Value(b'f6.b', 32), Value(b'f6.c', 32), Value(b'f6.d', 32), Value(b'f6.e', 32), Value(b'f6.f', 32),
                    Value(b'f6.g', 32), Value(b'f7.a', 32), Value(b'f7.b', 32), Value(b'f7.c', 32), Value(b'f7.d', 32),
                    Value(b'f7.e', 32), Value(b'f7.f', 32), Value(b'f7.g', 32), Value(b'f8.a', 32), Value(b'f8.b', 32),
                    Value(b'f8.c', 32), Value(b'f8.d', 32), Value(b'f8.e', 32), Value(b'f8.f', 32), Value(b'f8.g', 32),
                    Value(b'f9.a', 32), Value(b'f9.b', 32), Value(b'f9.c', 32), Value(b'f9.d', 32), Value(b'f9.e', 32),
                    Value(b'f9.f', 32), Value(b'f9.g', 32), Value(b'fa.a', 32), Value(b'fa.b', 32), Value(b'fa.c', 32),
                    Value(b'fa.d', 32), Value(b'fa.e', 32), Value(b'fa.f', 32), Value(b'fa.g', 32), Value(b'fb.a', 32),
                    Value(b'fb.b', 32), Value(b'fb.c', 32), Value(b'fb.d', 32), Value(b'fb.e', 32), Value(b'fb.f', 32),
                    Value(b'fb.g', 32), Value(b'fc.a', 32), Value(b'fc.b', 32), Value(b'fc.c', 32), Value(b'fc.d', 32),
                    Value(b'fc.e', 32), Value(b'fc.f', 32), Value(b'fc.g', 32), Value(b'fd.a', 32), Value(b'fd.b', 32),
                    Value(b'fd.c', 32), Value(b'fd.d', 32), Value(b'fd.e', 32), Value(b'fd.f', 32), Value(b'fd.g', 32),
                    Value(b'fe.a', 32), Value(b'fe.b', 32), Value(b'fe.c', 32), Value(b'fe.d', 32), Value(b'fe.e', 32),
                    Value(b'fe.f', 32), Value(b'fe.g', 32), Value(b'ff.a', 32), Value(b'ff.b', 32), Value(b'ff.c', 32),
                    Value(b'ff.d', 32), Value(b'ff.e', 32), Value(b'ff.f', 32), Value(b'ff.g', 32)]

        f = Regex("test", "[0-9a-f]{1,2}\.[a-g]")
        self.assertEqual([i for i in f], expected)

    def test_length(self):
        f = Regex("test", "[0-9a-f]{1,2}\.[a-g]")
        self.assertEqual(f.length(), 1904)
        self.assertEqual(len(list(f)), f.length())


if __name__ == '__main__':
    main()
