"""dictionary.py

Created by Thomas Mangin on 2015-01-17.
Copyright (c) 2014-2017 Exa Networks. All rights reserved.
License: 3-clause BSD. (See the COPYRIGHT file)
"""

from __future__ import annotations

from collections import defaultdict
from typing import Any, Callable


# ===================================================================== dictdict
# an Hardcoded defaultdict with dict as method


class Dictionary(defaultdict[Any, dict[Any, Any]]):
    default_factory: Callable[[], dict[Any, Any]] | None

    def __init__(self) -> None:
        self.default_factory = dict
