﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FuzzTalk.Actions
{
    [Serializable]
    public class DetachDebugger : DebuggerAction
    {
        public override void Process(ActionInterpreter Interpreter)
        {
            var names = ProcessNames.Split(',');

            var actions = FuzzTalkScript.Current.GetAllActions()
                .OfType<AttachDebugger>()
                .Where(x => x.ProcessNames.Split(',').Any(y => names.Contains(y)));

            foreach (var action in actions)
                foreach (var p in action.DebuggerInstances)
                    p.Stop();
                    //p.Kill();
        }
    }
}
