﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

namespace FuzzTalk.Actions
{
    public class Receive : SocketAction
    {
        private byte[] _responseBytes;

        [XmlIgnore]
        public byte[] ResponseBytes
        {
            get { return _responseBytes; }
            set 
            {
                _responseBytes = value;

                ResponseString = value.GetString();
            }
        }

        [XmlIgnore]
        public string ResponseString { get; private set; }

        public override void Process(ActionInterpreter Interpreter)
        {
            try
            {
                var c = Interpreter.FindActionByName(Socket) as Connect;

                ResponseBytes = c.ReceiveData();

                if (Log)
                    Program.Log.AddEntry("Receive:\r\n\r\n" +
                        ASCIIEncoding.ASCII.GetString(ResponseBytes));
            }
            catch (System.Exception ex)
            {
                Program.Log.AddEntry("Receive Error:\r\n\r\n" + ex);
            } 
        }
    }
}
