﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

namespace FuzzTalk
{
    [Serializable]
    public class IntegerOverflow
    {
        private string _type;

        [XmlAttribute]
        public string Type
        {
            get { return _type; }
            set 
            {
                _type = value;

                SetValues();
            }
        }

        private string[] _minValues;

        [XmlIgnore]
        public string[] MinValues
        {
            get { return _minValues; }
        }

        private string[] _maxValues;

        [XmlIgnore]
        public string[] MaxValues
        {
            get { return _maxValues; }
        }

        private void SetValues()
        {            
            var type = System.Type.GetType(_type);

            if (type == null)
                throw new InvalidOperationException(string.Format("Type {0} not found", _type));

            object minValue = type.GetFieldValue("MinValue", null),
                maxValue = type.GetFieldValue("MaxValue", null);

            bool isUnsigned = minValue.ToString()[0] != '-';

            int count = 8;

            _minValues = new string[count - 1];
            _maxValues = new string[count - 1];

            for (int i = 1; i < count; i++)
            {
                if (!isUnsigned)
                {
                    _minValues[i - 1] = (Convert.ToInt64(minValue) / i).ToString();
                    _maxValues[i - 1] = (Convert.ToInt64(maxValue) / i).ToString();
                }
                else
                {
                    _minValues[i - 1] = (Convert.ToUInt64(minValue) / (uint)i).ToString();
                    _maxValues[i - 1] = (Convert.ToUInt64(maxValue) / (uint)i).ToString();
                }
            }
        }
    }    
}
