# 2022 CVES
from .cve_2020_15175 import CVE_2020_15175
from .cve_2022_31061 import CVE_2022_31061
from .cve_2022_35914 import CVE_2022_35914
from .unserialize_order_plugin import UNSERIALIZE_ORDER_2022

# 2023 CVES
from .cve_2023_41323 import CVE_2023_41323
from .cve_2023_41326 import CVE_2023_41326
from .php_upload import PHP_UPLOAD

# 2024 CVES
from .cve_2024_27937 import CVE_2024_27937
from .cve_2024_29889 import CVE_2024_29889
from .cve_2024_37148 import CVE_2024_37148
from .cve_2024_37149 import CVE_2024_37149
from .cve_2024_40638 import CVE_2024_40638 # Do not share pls
from .cve_2024_50339 import CVE_2024_50339

# 2025 CVES
from .cve_2025_24799 import CVE_2025_24799
from .cve_2025_32786 import CVE_2025_32786

# GLPI classic check
from .default_password_check import DEFAULT_PASSWORD_CHECK

def get_all_exploits():
    """
    Return the exploit available as Class

    :return: The class of exploits available
    :rtype: List[class:`exploits.exploit.GlpiExploit`]
    """

    all_exploits = [CVE_2020_15175, CVE_2022_31061, CVE_2022_35914, UNSERIALIZE_ORDER_2022, CVE_2023_41323, CVE_2023_41326]
    all_exploits += [PHP_UPLOAD, CVE_2024_27937, CVE_2024_29889, CVE_2024_37148, CVE_2024_37149]
    all_exploits += [CVE_2024_40638, CVE_2024_50339, CVE_2025_24799, CVE_2025_32786]
    all_exploits += [DEFAULT_PASSWORD_CHECK]
    return all_exploits
