from dataclasses import dataclass
from glpwnme.exploits.logger import Log

@dataclass
class Metadata:
    """
    Class containing the metadatas of an exploit
    """
    author: str = ""
    name: str = ""
    cvss: float = 0
    description: str = ""

    def display(self):
        """
        Display the metadatas of the exploit
        """
        Log.print(f"Exploit Informations:")

        if self.author:
            Log.print(f"Author: [green bold]{self.author}[/green bold]")

        if self.name:
            Log.print(f"Name: [green bold]{self.name}[/green bold]")

        if self.cvss != 0:
            Log.print(f"Score CVSS: [yellow bold]{self.cvss}[/yellow bold]")

        if self.description:
            Log.print(f"[bold]Description:[/bold]")
            Log.print("```")
            print(self.description)
            Log.print("```")

    @classmethod
    def parse_from_comment(cls, comments):
        """
        Parse the metadata from the comments

        :param comments: The doc comment from the class
        :type comments: str

        :return: The metadatas completed
        :rtype: class:Metadata
        """
        metadatas = {}
        comments = map(lambda w: w.strip(), comments.split("\n"))
        for comment in comments:
            index = comment.find("@")
            end = comment.find(" ")
            if(end != -1 and len(comment) > end):
                subkey = comment[index+1: end]
                value = comment[end+1:]
                if subkey.lower() in ["author", "name", "cvss", "description"]:
                    metadatas[subkey.lower()] = value

        if metadatas:
            return cls(**metadatas)
        return None
