# You can build the package from Git using something like:
# tar -czf swig-4.0.0.tar.gz swig-4.0.0 && rpmbuild -tb swig-4.0.0.tar.gz
# swig.spec.  Generated from swig.spec.in by configure.

%define ver          4.0.0
%define rel          1
%define prefix       /usr
%define home_page    http://www.swig.org
%define docprefix    %{prefix}/share

######################################################################
# Usually, nothing needs to be changed below here between releases
######################################################################
Summary: Simplified Wrapper and Interface Generator
Name: swig
Version: %{ver}
Release: %{rel}
URL: %{home_page}
Source0: %{name}-%{version}.tar.gz
License: BSD
Group: Development/Tools
BuildRoot: %{_tmppath}/%{name}-root

%description
SWIG is a software development tool that connects programs written in C and C++
with a variety of high-level programming languages. SWIG is primarily used with
common scripting languages such as Perl, Python, Tcl/Tk, and Ruby, however the
list of supported languages also includes non-scripting languages such as Java,
OCAML and C#. Also several interpreted and compiled Scheme implementations
(Guile, MzScheme) are supported. SWIG is most commonly used to create
high-level interpreted or compiled programming environments, user interfaces,
and as a tool for testing and prototyping C/C++ software. SWIG can also export
its parse tree in the form of XML. 

%prep
%setup -q -n %{name}-%{version}

%build
# so we can build package from Git source too
[ ! -r configure ] && ./autogen.sh
%configure
make

%install
rm -rf ${RPM_BUILD_ROOT}
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc ANNOUNCE CHANGES INSTALL LICENSE LICENSE-GPL LICENSE-UNIVERSITIES README RELEASENOTES
%doc Doc/*
%{_bindir}/*
%{prefix}/share/*

%changelog
* Thu Sep 16 2004 Marcelo Matus <mmatus@acms.arizona.edu>
- Small fixes needed after removing the runtime package
* Tue Jul 20 2004 William Fulton <wsf@fultondesigns.co.uk>
- Update for SWIG-1.3.22 - Removed runtime package
* Wed Mar 03 2004 Robert H De Vries
- Update to work with Fedora Core 1 rpm 4.2.1
* Wed Jul 24 2002 Sam Liddicott <sam@liddicott.com>
- Added runtime package of runtime libs
* Mon Sep 10 2001 Tony Seward <anthony.seward@ieee.org>
- Merge Red Hat's and Dustin Mitchell's .spec files.
- Install all of the examples in the documentation directory.
- Auto create the list of installed files.
