---
title: "Hadoop Exploiter"
draft: false
description: "Exploits Hadoop servers"
tags: ["exploiter", "hadoop", "yarn"]
pre: "<i class='fa fa-feather-pointed'></i> "
---

## Apache Hadoop

[Apache Hadoop](https://hadoop.apache.org/) is a widely-used framework for
distributed storage and processing of large data sets. Hadoop YARN is a
component of the Hadoop ecosystem which is used for job scheduling/monitoring
and cluster resource management.

## Exploitation

Hadoop servers with YARN are susceptible to RCE (remote
code execution) attacks. The [Hadoop YARN ResourceManager REST API](
https://apache.github.io/hadoop/hadoop-yarn/hadoop-yarn-site/WebServicesIntro.html
) enables users to submit a new application with launch context, which allows
arbitrary commands to be executed once the application is submitted
successfully. By default, Hadoop YARN opens the RPC service to the public,
giving attackers the ability to execute arbitrary commands and control the
target server.

Infection Monkey's Hadoop exploiter works by submitting a new application to
YARN. This application's launch context includes a custom command to download
and execute the Agent on the compromised machine.

![Hadoop Configuration](
/images/island/configuration-page/hadoop-exploiter-configuration.png
"Hadoop Configuration")

## Mitigation

1. Hadoop recommends [updating security related settings appropriately](
https://hadoop.apache.org/docs/current/hadoop-project-dist/hadoop-common/SecureMode.html#Configuration
). In this case, enabling Kerberos authentication is particularly valuable.

1. Allow only trusted connections to the Hadoop RPC service port.

## See also
- [Hadoop exploiter reference documentation](/reference/exploiters/hadoop)
