---
title: "Log4Shell Exploiter"
draft: false
description: "Exploits the Log4Shell vulnerability"
tags: ["exploiter", "log4shell", "log4j", "cve-2021-44228"]
pre: "<i class='fa fa-mug-hot'></i> "
---

{{% notice info %}}
The Log4Shell exploiter exploits [CVE-2021-44228](
https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-44228).
{{% /notice %}}

## Apache Log4j

[Apache Log4j](https://logging.apache.org/log4j/) is an open-source Java
logging framework that is used to log messages within software, including
information like error messages and user inputs in a program. Due to its
widespread adoption, thousands of software packages and applications use
Log4j, making them all vulnerable to
[Log4Shell](https://en.wikipedia.org/wiki/Log4Shell).

## Exploitation

Some versions of Apache Log4j have a logging feature called "Message Lookup
Substitution" enabled by default. This allows replacing certain special strings
by dynamically-generated strings at the time of logging. If log messages or log
message parameters can be controlled by an attacker, arbitrary code can be
executed. This vulnerability was nicknamed
"[Log4Shell](https://en.wikipedia.org/wiki/Log4Shell)".

Infection Monkey's Log4Shell exploiter takes advantage of this vulnerability
to propagate to a victim machine.

![Log4Shell Configuration](
/images/island/configuration-page/log4shell-exploiter-configuration.png
"Log4Shell Configuration")

### Services exploited

Infection Monkey attempts to exploit the Log4Shell vulnerability in the
following services:

- Apache Solr
- Apache Tomcat
- Logstash

**Note**: Even if none of these services are running in your environment,
running the Log4Shell exploiter can be a good way to test your IDS/IPS or EDR
solutions. These solutions should detect that Infection Monkey is attempting to
exploit the Log4Shell vulnerability and raise an appropriate alert.

## Mitigation

Learn more about this vulnerability and potential mitigations [here](
https://logging.apache.org/log4j/2.x/security.html#CVE-2021-44228).

## See also
- [Log4Shell exploiter reference
  documentation](/reference/exploiters/log4shell)
- [Infection Monkey's Log4Shell blog
  post](https://www.akamai.com/blog/security/infection-monkey-new-log4shell-simulation)
- [Quantifying Log4Shell: Vulnerability on a Massive
  scale](https://www.akamai.com/blog/security/quantifying-log4shell-vulnerability-on-a-massive-scale)
- [CVE-2021-44228](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-44228).
