---
title: "MSSQL Exploiter"
draft: false
description: "Exploits MSSQL by taking advantage of insecure configuration"
tags: ["exploiter", "mssql", "brute force"]
pre: "<i class='fa fa-database'></i> "
---

## MSSQL

[MSSQL (Microsoft SQL Server)](
https://learn.microsoft.com/en-us/sql/sql-server/what-is-sql-server) is a
relational database management system (RDBMS) developed by Microsoft whose
functions include managing, storing, retrieving, manipulating, and analyzing
data efficiently. In addition to manipulating data stored within the database,
the  [`xp_cmdshell`](
https://learn.microsoft.com/en-us/sql/relational-databases/system-stored-procedures/xp-cmdshell-transact-sql)
procedure allows users to manipulate the host server by executing Windows shell
commands from within the SQL Server environment.

## Exploitation

Because of the inherent security risks associated with `xp_cmdshell`, it is
disabled by default. If `xp_cmdshell` has been enabled on an MSSQL instance,
attackers who possess valid credentials can leverage MSSQL to run arbitrary commands
on the server. Infection Monkey's MSSQL exploiter uses brute-force to
authenticate with a victim's MSSQL server and uses `xp_cmdshell` to propagate
to the victim server.

![MSSQL Configuration](
/images/island/configuration-page/mssql-exploiter-configuration.png
"MSSQL Configuration")

### Credentials used

The MSSQL exploiter uses [user-configured credentials](
/usage/configuration/credentials), as well as credentials collected from other
victims for brute-forcing. All possible combinations of usernames and passwords
are used, prioritizing pairs provided by the user in the configuration.

## Mitigation

The best approach to mitigate this attack is to disable the `xp_cmdshell`
feature as described in [Microsoft's documentation](
https://docs.microsoft.com/en-us/sql/database-engine/configure-windows/xp-cmdshell-server-configuration-option?view=sql-server-2017).

## See also
- [MSSQL exploiter reference documentation](/reference/exploiters/mssql)
