from monkeyevents import ExploitationEvent

from monkey_island.cc.models import CommunicationType
from monkey_island.cc.repositories import NetworkModelUpdateFacade


class update_nodes_on_exploitation:
    def __init__(self, network_model_update_facade: NetworkModelUpdateFacade):
        self._network_model_update_facade = network_model_update_facade

    def __call__(self, event: ExploitationEvent):
        if event.success:
            self._network_model_update_facade.upsert_communication_from_event(
                event, CommunicationType.EXPLOITED
            )
