/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.util;

import com.aspect.snoop.agent.AgentLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import javassist.ClassPool;
import javassist.CtClass;

public class IOUtil {
    public static byte[] getBytesFromStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        boolean reading = true;
        while (reading) {
            int read = is.read(buffer);
            if (read == -1) {
                reading = false;
                continue;
            }
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static byte[] getClassBytes(Class clazz) {
        try {
            CtClass ct = ClassPool.getDefault().get(clazz.getName());
            return ct.toBytecode();
        }
        catch (Exception ex) {
            AgentLogger.error(ex);
            return null;
        }
    }
}

