/*
 * Decompiled with CFR 0.152.
 */
package entities;

import entities.AuxiliaryForDecryptThreads;
import entities.AvailableAlgorithms;
import entities.ByteArray;
import entities.DictionaryRule;
import entities.HashEntry;
import entities.JBruteThread;
import entities.ProcessResult;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import specialAlgorithm.MyMessageDigest;

public class MyDictionaryDecryptThread
extends JBruteThread {
    private String message;
    private ProcessResult opResult;
    private List<StringBuilder> words;
    private int algorithmCode = 0;
    private List<DictionaryRule> rules;
    private boolean stdoutMode = false;

    public MyDictionaryDecryptThread(String msg, ProcessResult pr, List<StringBuilder> words, List<DictionaryRule> rules, boolean stdoutMode) {
        this.message = msg;
        this.opResult = pr;
        this.algorithmCode = this.opResult.getAlgorithmCodes().equalsIgnoreCase("0") ? 0 : AvailableAlgorithms.getAlgorithmCodeFromInput(this.opResult.getAlgorithmCodes());
        this.words = words;
        this.rules = rules;
        this.stdoutMode = stdoutMode;
    }

    public List<DictionaryRule> getRules() {
        return this.rules;
    }

    public void setRules(List<DictionaryRule> rules) {
        this.rules = rules;
    }

    public List<StringBuilder> getWords() {
        return this.words;
    }

    public void setWords(List<StringBuilder> words) {
        this.words = words;
    }

    public String getMensaje() {
        return this.message;
    }

    public void setMensaje(String mensaje) {
        this.message = mensaje;
    }

    public ProcessResult getResultado() {
        return this.opResult;
    }

    public void setResultado(ProcessResult resultado) {
        this.opResult = resultado;
    }

    public int getAlgorithmCode() {
        return this.algorithmCode;
    }

    public void setAlgorithmCode(int algorithmCode) {
        this.algorithmCode = algorithmCode;
    }

    @Override
    public void run() {
        if (this.stdoutMode) {
            this.stdoutRuleProcessing();
        } else {
            this.opResult.validateEncryptedHashes();
            if (this.opResult.getPendingEncryptedHashes().size() == 0) {
                System.err.println();
                System.err.println("There are no valid hashes to decrypt!!!");
                System.err.println();
                return;
            }
            if (this.opResult.isChainedHash()) {
                this.decryptDictionaryChained();
            } else if (AvailableAlgorithms.isHashedSpecialAlgorithm(this.algorithmCode)) {
                this.decryptDictionarySpecialAlgorithm();
            } else {
                this.decryptDictionary();
            }
        }
    }

    private void stdoutRuleProcessing() {
        for (DictionaryRule rule : this.rules) {
            System.out.println("Processing rule \"" + rule.toString() + "\"");
            for (StringBuilder word : this.words) {
                List<StringBuilder> list = rule.aplicateRule(word);
                for (StringBuilder s : list) {
                    System.out.println(s);
                }
            }
        }
    }

    private void decryptDictionary() {
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        ArrayList<byte[]> saltList = new ArrayList<byte[]>();
        boolean[] preSaltList = new boolean[this.opResult.getPendingEncryptedHashes().size()];
        int auxIndex = 0;
        boolean useSalt = false;
        for (HashEntry entry : this.opResult.getEncryptedHashes()) {
            byteList.add(DatatypeConverter.parseHexBinary((String)entry.getHash()));
            byte[] auxSalt = AvailableAlgorithms.getSaltByteArray(entry.getSalt(), entry.getSaltType());
            if (auxSalt != null) {
                useSalt = true;
            }
            saltList.add(auxSalt);
            preSaltList[auxIndex] = entry.isPreSalt();
            ++auxIndex;
        }
        MessageDigest m = AvailableAlgorithms.getMessageDigest(this.algorithmCode);
        byte[] result = null;
        byte[] resultSalt = null;
        int cantEntrys = byteList.size();
        block1: for (DictionaryRule rule : this.rules) {
            if (this.message.equals("Thread 0")) {
                System.out.println("Processing rule \"" + rule.toString() + "\"");
            }
            for (StringBuilder word : this.words) {
                byte[] elem;
                int i;
                if (this.isSomethingDifferent()) {
                    useSalt = false;
                    byteList.clear();
                    saltList.clear();
                    preSaltList = new boolean[this.opResult.getPendingEncryptedHashes().size()];
                    auxIndex = 0;
                    for (HashEntry entry : this.opResult.getPendingEncryptedHashes()) {
                        byteList.add(DatatypeConverter.parseHexBinary((String)entry.getHash()));
                        byte[] auxSalt = AvailableAlgorithms.getSaltByteArray(entry.getSalt(), entry.getSaltType());
                        if (auxSalt != null) {
                            useSalt = true;
                        }
                        saltList.add(auxSalt);
                        preSaltList[auxIndex] = entry.isPreSalt();
                        ++auxIndex;
                    }
                    cantEntrys = byteList.size();
                    this.setSomethingDifferent(false);
                    if (this.opResult.isResolved()) break block1;
                }
                List<StringBuilder> list = rule.aplicateRule(word);
                if (useSalt) {
                    for (StringBuilder s : list) {
                        i = 0;
                        while (i < cantEntrys) {
                            elem = (byte[])byteList.get(i);
                            resultSalt = AuxiliaryForDecryptThreads.processSalt(ByteArray.toByteArray(s), (byte[])saltList.get(i), preSaltList[i]);
                            m.update(resultSalt);
                            result = m.digest();
                            if (Arrays.equals(elem, result)) {
                                this.opResult.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), s.toString());
                            }
                            ++i;
                        }
                    }
                    continue;
                }
                for (StringBuilder s : list) {
                    m.update(ByteArray.toByteArray(s));
                    result = m.digest();
                    i = 0;
                    while (i < cantEntrys) {
                        elem = (byte[])byteList.get(i);
                        if (Arrays.equals(elem, result)) {
                            this.opResult.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), s.toString());
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private void decryptDictionarySpecialAlgorithm() {
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        ArrayList<byte[]> saltList = new ArrayList<byte[]>();
        MyMessageDigest m = AvailableAlgorithms.getMyMessageDigest(this.algorithmCode);
        for (HashEntry he : this.opResult.getPendingEncryptedHashes()) {
            byte[] aux = m.hashToByteArray(he.getHash());
            byteList.add(aux);
            saltList.add(m.getSaltFromHash(aux));
        }
        int cantEntrys = byteList.size();
        byte[] result = null;
        block1: for (DictionaryRule rule : this.rules) {
            if (this.message.equals("Thread 0")) {
                System.out.println("Processing rule \"" + rule.toString() + "\"");
            }
            for (StringBuilder word : this.words) {
                if (this.isSomethingDifferent()) {
                    byteList.clear();
                    saltList.clear();
                    for (HashEntry entry : this.opResult.getPendingEncryptedHashes()) {
                        byte[] auxHash = m.hashToByteArray(entry.getHash());
                        byteList.add(auxHash);
                        saltList.add(m.getSaltFromHash(auxHash));
                    }
                    cantEntrys = byteList.size();
                    this.setSomethingDifferent(false);
                    if (this.opResult.isResolved()) break block1;
                }
                List<StringBuilder> list = rule.aplicateRule(word);
                for (StringBuilder s : list) {
                    result = ByteArray.toByteArray(s);
                    int i = 0;
                    while (i < cantEntrys) {
                        m.update(result);
                        if (Arrays.equals((byte[])byteList.get(i), m.digest((byte[])saltList.get(i)))) {
                            this.opResult.addDecryption(m.toHash((byte[])byteList.get(i)), s.toString());
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private void decryptDictionaryChained() {
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        ArrayList<byte[]> saltList = new ArrayList<byte[]>();
        boolean[] preSaltList = new boolean[this.opResult.getPendingEncryptedHashes().size()];
        int auxIndex = 0;
        boolean useSalt = false;
        for (HashEntry entry : this.opResult.getEncryptedHashes()) {
            byteList.add(DatatypeConverter.parseHexBinary((String)entry.getHash()));
            byte[] auxSalt = AvailableAlgorithms.getSaltByteArray(entry.getSalt(), entry.getSaltType());
            if (auxSalt != null) {
                useSalt = true;
            }
            saltList.add(auxSalt);
            preSaltList[auxIndex] = entry.isPreSalt();
            ++auxIndex;
        }
        MessageDigest[] ma = AvailableAlgorithms.getMessageDigestArray(this.opResult.getAlgorithmCodes());
        byte[] resultSalt = null;
        byte[] result = null;
        byte[] aux = null;
        int cantEntrys = byteList.size();
        block1: for (DictionaryRule rule : this.rules) {
            if (this.message.equals("Thread 0")) {
                System.out.println("Processing rule \"" + rule.toString() + "\"");
            }
            for (StringBuilder word : this.words) {
                byte[] elem;
                int i;
                if (this.isSomethingDifferent()) {
                    useSalt = false;
                    byteList.clear();
                    saltList.clear();
                    preSaltList = new boolean[this.opResult.getPendingEncryptedHashes().size()];
                    auxIndex = 0;
                    for (HashEntry entry : this.opResult.getPendingEncryptedHashes()) {
                        byteList.add(DatatypeConverter.parseHexBinary((String)entry.getHash()));
                        byte[] auxSalt = AvailableAlgorithms.getSaltByteArray(entry.getSalt(), entry.getSaltType());
                        if (auxSalt != null) {
                            useSalt = true;
                        }
                        saltList.add(auxSalt);
                        preSaltList[auxIndex] = entry.isPreSalt();
                        ++auxIndex;
                    }
                    cantEntrys = byteList.size();
                    this.setSomethingDifferent(false);
                    if (this.opResult.isResolved()) break block1;
                }
                List<StringBuilder> list = rule.aplicateRule(word);
                if (useSalt) {
                    for (StringBuilder s : list) {
                        i = 0;
                        while (i < cantEntrys) {
                            elem = (byte[])byteList.get(i);
                            resultSalt = AuxiliaryForDecryptThreads.processSalt(ByteArray.toByteArray(s), (byte[])saltList.get(i), preSaltList[i]);
                            int j = 0;
                            while (j < ma.length) {
                                ma[j].update(resultSalt);
                                aux = ma[j].digest();
                                if (ma.length - 1 != j) {
                                    resultSalt = AuxiliaryForDecryptThreads.getIntermediateChainedHash(aux, this.opResult.getChainedAlgorithmCase(), j);
                                }
                                ++j;
                            }
                            resultSalt = aux;
                            if (Arrays.equals(elem, resultSalt)) {
                                this.opResult.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), s.toString());
                            }
                            ++i;
                        }
                    }
                    continue;
                }
                for (StringBuilder s : list) {
                    result = ByteArray.toByteArray(s);
                    int j = 0;
                    while (j < ma.length) {
                        ma[j].update(result);
                        aux = ma[j].digest();
                        if (ma.length - 1 != j) {
                            result = AuxiliaryForDecryptThreads.getIntermediateChainedHash(aux, this.opResult.getChainedAlgorithmCase(), j);
                        }
                        ++j;
                    }
                    result = aux;
                    i = 0;
                    while (i < cantEntrys) {
                        elem = (byte[])byteList.get(i);
                        if (Arrays.equals(elem, result)) {
                            this.opResult.addDecryption(AvailableAlgorithms.getLowerCaseHash(elem), s.toString());
                        }
                        ++i;
                    }
                }
            }
        }
    }
}

